#include <stdlib.h>
#include <stdio.h>

#include "unity-webapps-service.h"
#include "unity-webapps-context.h"

#define ICON_URL "data:THIS IS NOT A VLIA DATA URIASJFAKSFLASF"

#include "uwa-test-client.h"

static GMainLoop *mainloop = NULL;

static void
context_ready (UnityWebappsContext *context, gpointer user_data)
{
  unity_webapps_notification_show_notification (context, 
						"Data URI",
						"A test notification with an invalid data URI",
						ICON_URL);
  printf("Set indicator property icon (to an invalid Data URI)\n");

  uwa_emit_test_finished ();
}

gint
main (gint argc, gchar **argv)
{
  UnityWebappsService *service;
  
  g_type_init ();
  
  service = unity_webapps_service_new ();
  
  unity_webapps_context_new (service, "TestDataURI", "test.ts", ICON_URL, NULL, context_ready, NULL);
  
  mainloop = g_main_loop_new (NULL, FALSE);
  
  g_main_loop_run (mainloop);
  
  return 0;  
}
