# - Try to find Eet
# Once done this will define
#
#  EET_INCLUDE_DIRS - the Eet include directory
#  EET_LIBRARIES - Link these to use Eet
#  EET_CFLAGS_OTHER - Compiler switches required for using Eet
#

# use pkg-config to get the directories and then use these values
# in the FIND_PATH() and FIND_LIBRARY() calls
if( NOT WIN32 )
  find_package(PkgConfig)
  pkg_check_modules(PC_Eet eet>=1.0.0)
endif( NOT WIN32 )

# use this just to create a nice message at FindPackageHandleStandardArgs
if (PC_Eet_FOUND)
  FIND_LIBRARY(Eet_LIBRARY NAMES eet
    PATHS
    ${PC_Eet_LIBDIR}
    ${PC_Eet_LIBRARY_DIRS}
  )
  SET(EET_LIBRARIES ${Eet_LIBRARY})
  SET(EET_INCLUDE_DIRS ${PC_Eet_INCLUDE_DIRS})
else (PC_Eet_FOUND)
  MESSAGE(STATUS "Could not find Eet. Please download it here (http://dev.openbossa.org/trac/qedje).")
endif (PC_Eet_FOUND)

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(Eet DEFAULT_MSG Eet_LIBRARY)

# show Eet_LIBRARY variables only in the advanced view
MARK_AS_ADVANCED(Eet_LIBRARY)