/* DataSource.c generated by valac 0.40.4, the Vala compiler
 * generated from DataSource.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/**/
/* DataSource*/
/* */
/* A DataSource is an object that is unique throughout the system.  DataSources*/
/* commonly have external and/or persistent representations, hence they have a notion of being*/
/* destroyed (versus removed or freed).  Several DataViews may exist that reference a single*/
/* DataSource.  Note that DataSources MUST be destroyed (rather than simply removed) from their*/
/* SourceCollection, and that they MUST be destroyed via their SourceCollection (rather than*/
/* calling DataSource.destroy() directly.)*/
/**/
/* Destroying a DataSource indicates it should remove all secondary and tertiary structures (such*/
/* as thumbnails) and any records pointing to its backing store.  SourceCollection.destroy_marked()*/
/* has a parameter indicating if the backing should be destroyed as well; that is when*/
/* internal_delete_backing() is called.*/
/**/
/* There are no provisions (currently) for a DataSource to be removed from its SourceCollection*/
/* without destroying its backing and/or secondary and tertiary structures.  DataSources are intended*/
/* to go to the grave with their SourceCollection otherwise.  If a need arises for a DataSource to*/
/* be peaceably removed from its SourceCollection, code will need to be written.  SourceSnapshots*/
/* may be one solution to this problem.*/
/**/
/* Some DataSources cannot be reconstituted (for example, if its backing file is deleted).  In*/
/* that case, dehydrate() should return null.  When reconstituted, it is the responsibility of the*/
/* implementation to ensure an exact clone is produced, minus any details that are not relevant or*/
/* exposed (such as a database ID).*/
/**/
/* If other DataSources refer to this DataSource, their state will *not* be */
/* saved/restored.  This must be achieved via other means.  However, implementations *should**/
/* track when changes to external state would break the proxy and call notify_broken();*/
/**/


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;
typedef struct _DataSourcePrivate DataSourcePrivate;

#define TYPE_SOURCE_HOLDING_TANK (source_holding_tank_get_type ())
#define SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank))
#define SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))
#define IS_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_HOLDING_TANK))
#define IS_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_HOLDING_TANK))
#define SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))

typedef struct _SourceHoldingTank SourceHoldingTank;
typedef struct _SourceHoldingTankClass SourceHoldingTankClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_SOURCE_SNAPSHOT (source_snapshot_get_type ())
#define SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshot))
#define SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))
#define IS_SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_SNAPSHOT))
#define IS_SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_SNAPSHOT))
#define SOURCE_SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))

typedef struct _SourceSnapshot SourceSnapshot;
typedef struct _SourceSnapshotClass SourceSnapshotClass;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;
enum  {
	DATA_SOURCE_0_PROPERTY,
	DATA_SOURCE_NUM_PROPERTIES
};
static GParamSpec* data_source_properties[DATA_SOURCE_NUM_PROPERTIES];
#define _source_holding_tank_unref0(var) ((var == NULL) ? NULL : (var = (source_holding_tank_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;
#define _source_backlink_unref0(var) ((var == NULL) ? NULL : (var = (source_backlink_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	DATA_SOURCE_UNLINKED_SIGNAL,
	DATA_SOURCE_RELINKED_SIGNAL,
	DATA_SOURCE_DESTROYED_SIGNAL,
	DATA_SOURCE_NUM_SIGNALS
};
static guint data_source_signals[DATA_SOURCE_NUM_SIGNALS] = {0};
typedef struct _SourceSnapshotPrivate SourceSnapshotPrivate;
typedef struct _ParamSpecSourceSnapshot ParamSpecSourceSnapshot;
enum  {
	SOURCE_SNAPSHOT_BROKEN_SIGNAL,
	SOURCE_SNAPSHOT_NUM_SIGNALS
};
static guint source_snapshot_signals[SOURCE_SNAPSHOT_NUM_SIGNALS] = {0};
typedef struct _SourceBacklinkPrivate SourceBacklinkPrivate;
typedef struct _ParamSpecSourceBacklink ParamSpecSourceBacklink;

#define TYPE_SOURCE_PROXY (source_proxy_get_type ())
#define SOURCE_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_PROXY, SourceProxy))
#define SOURCE_PROXY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_PROXY, SourceProxyClass))
#define IS_SOURCE_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_PROXY))
#define IS_SOURCE_PROXY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_PROXY))
#define SOURCE_PROXY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_PROXY, SourceProxyClass))

typedef struct _SourceProxy SourceProxy;
typedef struct _SourceProxyClass SourceProxyClass;
typedef struct _SourceProxyPrivate SourceProxyPrivate;
#define _source_snapshot_unref0(var) ((var == NULL) ? NULL : (var = (source_snapshot_unref (var), NULL)))
typedef struct _ParamSpecSourceProxy ParamSpecSourceProxy;
enum  {
	SOURCE_PROXY_RECONSTITUTED_SIGNAL,
	SOURCE_PROXY_DEHYDRATED_SIGNAL,
	SOURCE_PROXY_BROKEN_SIGNAL,
	SOURCE_PROXY_NUM_SIGNALS
};
static guint source_proxy_signals[SOURCE_PROXY_NUM_SIGNALS] = {0};

#define TYPE_PROXYABLE (proxyable_get_type ())
#define PROXYABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROXYABLE, Proxyable))
#define IS_PROXYABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROXYABLE))
#define PROXYABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_PROXYABLE, ProxyableIface))

typedef struct _Proxyable Proxyable;
typedef struct _ProxyableIface ProxyableIface;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataSource {
	DataObject parent_instance;
	DataSourcePrivate * priv;
};

struct _DataSourceClass {
	DataObjectClass parent_class;
	void (*notify_held_in_tank) (DataSource* self, SourceHoldingTank* holding_tank);
	void (*notify_unlinking) (DataSource* self, SourceCollection* collection);
	void (*notify_unlinked) (DataSource* self);
	void (*notify_relinking) (DataSource* self, SourceCollection* collection);
	void (*notify_relinked) (DataSource* self);
	gchar* (*get_typename) (DataSource* self);
	gint64 (*get_instance_id) (DataSource* self);
	gchar* (*get_source_id) (DataSource* self);
	void (*commit_backlinks) (DataSource* self, SourceCollection* sources, const gchar* dehydrated);
	SourceSnapshot* (*save_snapshot) (DataSource* self);
	gboolean (*internal_delete_backing) (DataSource* self, GError** error);
	gboolean (*equals) (DataSource* self, DataSource* source);
	void (*destroy) (DataSource* self);
	void (*unlinked) (DataSource* self, SourceCollection* sources);
	void (*relinked) (DataSource* self, SourceCollection* sources);
	void (*destroyed) (DataSource* self);
};

struct _DataSourcePrivate {
	DataView** subscribers;
	gint subscribers_length1;
	gint _subscribers_size_;
	SourceHoldingTank* holding_tank;
	SourceCollection* unlinked_from_collection;
	GeeHashMap* backlinks;
	gboolean in_contact;
	gboolean marked_for_destroy;
	gboolean is_destroyed;
};

typedef void (*DataSourceContactSubscriber) (DataView* view, void* user_data);
typedef void (*DataSourceContactSubscriberAlteration) (DataView* view, Alteration* alteration, void* user_data);
struct _SourceSnapshot {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SourceSnapshotPrivate * priv;
};

struct _SourceSnapshotClass {
	GTypeClass parent_class;
	void (*finalize) (SourceSnapshot *self);
	void (*notify_broken) (SourceSnapshot* self);
	void (*broken) (SourceSnapshot* self);
};

struct _SourceSnapshotPrivate {
	gboolean snapshot_broken;
};

struct _ParamSpecSourceSnapshot {
	GParamSpec parent_instance;
};

struct _SourceBacklink {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SourceBacklinkPrivate * priv;
};

struct _SourceBacklinkClass {
	GTypeClass parent_class;
	void (*finalize) (SourceBacklink *self);
};

struct _SourceBacklinkPrivate {
	gchar* _name;
	gchar* _value;
};

struct _ParamSpecSourceBacklink {
	GParamSpec parent_instance;
};

struct _SourceProxy {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SourceProxyPrivate * priv;
};

struct _SourceProxyClass {
	GTypeClass parent_class;
	void (*finalize) (SourceProxy *self);
	DataSource* (*reconstitute) (SourceProxy* self, gint64 object_id, SourceSnapshot* snapshot);
	void (*notify_reconstituted) (SourceProxy* self, DataSource* source);
	void (*notify_dehydrated) (SourceProxy* self);
	void (*notify_broken) (SourceProxy* self);
	void (*reconstituted) (SourceProxy* self, DataSource* source);
	void (*dehydrated) (SourceProxy* self);
	void (*broken) (SourceProxy* self);
};

struct _SourceProxyPrivate {
	gint64 object_id;
	gchar* source_string;
	DataSource* source;
	SourceSnapshot* snapshot;
	SourceCollection* membership;
};

struct _ParamSpecSourceProxy {
	GParamSpec parent_instance;
};

struct _ProxyableIface {
	GTypeInterface parent_iface;
	SourceProxy* (*get_proxy) (Proxyable* self);
};


static gpointer data_source_parent_class = NULL;
static gpointer source_snapshot_parent_class = NULL;
static gpointer source_backlink_parent_class = NULL;
static gpointer source_proxy_parent_class = NULL;

GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
void value_set_alteration (GValue* value,
                           gpointer v_object);
void value_take_alteration (GValue* value,
                            gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_data_collection (GValue* value,
                                gpointer v_object);
void value_take_data_collection (GValue* value,
                                 gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
gpointer source_holding_tank_ref (gpointer instance);
void source_holding_tank_unref (gpointer instance);
GParamSpec* param_spec_source_holding_tank (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
void value_set_source_holding_tank (GValue* value,
                                    gpointer v_object);
void value_take_source_holding_tank (GValue* value,
                                     gpointer v_object);
gpointer value_get_source_holding_tank (const GValue* value);
GType source_holding_tank_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
gpointer source_snapshot_ref (gpointer instance);
void source_snapshot_unref (gpointer instance);
GParamSpec* param_spec_source_snapshot (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_source_snapshot (GValue* value,
                                gpointer v_object);
void value_take_source_snapshot (GValue* value,
                                 gpointer v_object);
gpointer value_get_source_snapshot (const GValue* value);
GType source_snapshot_get_type (void) G_GNUC_CONST;
GType data_view_get_type (void) G_GNUC_CONST;
#define DATA_SOURCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DATA_SOURCE, DataSourcePrivate))
DataSource* data_source_construct (GType object_type,
                                   gint64 object_id);
DataObject* data_object_construct (GType object_type,
                                   gint64 object_id);
static void data_source_real_notify_membership_changed (DataObject* base,
                                                 DataCollection* collection);
void data_source_notify_unlinked (DataSource* self);
void data_object_notify_membership_changed (DataObject* self,
                                            DataCollection* collection);
void data_source_notify_held_in_tank (DataSource* self,
                                      SourceHoldingTank* holding_tank);
static void data_source_real_notify_held_in_tank (DataSource* self,
                                           SourceHoldingTank* holding_tank);
DataCollection* data_object_get_membership (DataObject* self);
static void data_source_real_notify_altered (DataObject* base,
                                      Alteration* alteration);
void source_holding_tank_internal_notify_altered (SourceHoldingTank* self,
                                                  DataSource* source,
                                                  Alteration* alteration);
void data_source_contact_subscribers_alteration (DataSource* self,
                                                 Alteration* alteration);
void data_object_notify_altered (DataObject* self,
                                 Alteration* alteration);
void data_source_notify_unlinking (DataSource* self,
                                   SourceCollection* collection);
static void data_source_real_notify_unlinking (DataSource* self,
                                        SourceCollection* collection);
static void data_source_real_notify_unlinked (DataSource* self);
void data_source_commit_backlinks (DataSource* self,
                                   SourceCollection* sources,
                                   const gchar* dehydrated);
static gchar* data_source_dehydrate_backlinks (DataSource* self);
void data_source_notify_relinking (DataSource* self,
                                   SourceCollection* collection);
static void data_source_real_notify_relinking (DataSource* self,
                                        SourceCollection* collection);
void data_source_notify_relinked (DataSource* self);
static void data_source_real_notify_relinked (DataSource* self);
gchar* data_source_get_typename (DataSource* self);
static gchar* data_source_real_get_typename (DataSource* self);
gint64 data_source_get_instance_id (DataSource* self);
static gint64 data_source_real_get_instance_id (DataSource* self);
gchar* data_source_get_source_id (DataSource* self);
static gchar* data_source_real_get_source_id (DataSource* self);
gpointer source_backlink_ref (gpointer instance);
void source_backlink_unref (gpointer instance);
GParamSpec* param_spec_source_backlink (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_source_backlink (GValue* value,
                                gpointer v_object);
void value_take_source_backlink (GValue* value,
                                 gpointer v_object);
gpointer value_get_source_backlink (const GValue* value);
GType source_backlink_get_type (void) G_GNUC_CONST;
gboolean data_source_has_backlink (DataSource* self,
                                   SourceBacklink* backlink);
const gchar* source_backlink_get_name (SourceBacklink* self);
const gchar* source_backlink_get_value (SourceBacklink* self);
GeeList* data_source_get_backlinks (DataSource* self,
                                    const gchar* name);
SourceBacklink* source_backlink_new (const gchar* name,
                                     const gchar* value);
SourceBacklink* source_backlink_construct (GType object_type,
                                           const gchar* name,
                                           const gchar* value);
void data_source_set_backlink (DataSource* self,
                               SourceBacklink* backlink);
void source_collection_internal_backlink_set (SourceCollection* self,
                                              DataSource* source,
                                              SourceBacklink* backlink);
gboolean data_source_remove_backlink (DataSource* self,
                                      SourceBacklink* backlink);
void source_collection_internal_backlink_removed (SourceCollection* self,
                                                  DataSource* source,
                                                  SourceBacklink* backlink);
static void data_source_real_commit_backlinks (DataSource* self,
                                        SourceCollection* sources,
                                        const gchar* dehydrated);
gchar* data_object_to_string (DataObject* self);
gboolean is_string_empty (const gchar* s);
void data_source_rehydrate_backlinks (DataSource* self,
                                      SourceCollection* unlinked_from,
                                      const gchar* dehydrated);
SourceSnapshot* data_source_save_snapshot (DataSource* self);
static SourceSnapshot* data_source_real_save_snapshot (DataSource* self);
void data_source_internal_mark_for_destroy (DataSource* self);
gboolean data_source_internal_delete_backing (DataSource* self,
                                              GError** error);
static gboolean data_source_real_internal_delete_backing (DataSource* self,
                                                   GError** error);
gboolean data_source_equals (DataSource* self,
                             DataSource* source);
static gboolean data_source_real_equals (DataSource* self,
                                  DataSource* source);
void data_source_destroy (DataSource* self);
static void data_source_real_destroy (DataSource* self);
void data_view_notify_unsubscribed (DataView* self,
                                    DataSource* source);
gboolean data_source_destroy_orphan (DataSource* self,
                                     gboolean delete_backing);
void source_collection_notify_unlinked_destroyed (SourceCollection* self,
                                                  DataSource* unlinked);
void data_source_internal_subscribe (DataSource* self,
                                     DataView* view);
static void _vala_array_add66 (DataView** * array,
                        int* length,
                        int* size,
                        DataView* value);
void data_source_internal_unsubscribe (DataSource* self,
                                       DataView* view);
void data_source_contact_subscribers (DataSource* self,
                                      DataSourceContactSubscriber contact_subscriber,
                                      void* contact_subscriber_target);
static void data_source_real_unlinked (DataSource* self,
                                SourceCollection* sources);
static void g_cclosure_user_marshal_VOID__DATA_COLLECTION (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data);
static void data_source_real_relinked (DataSource* self,
                                SourceCollection* sources);
static void data_source_real_destroyed (DataSource* self);
static void data_source_finalize (GObject * obj);
#define SOURCE_SNAPSHOT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SOURCE_SNAPSHOT, SourceSnapshotPrivate))
void source_snapshot_notify_broken (SourceSnapshot* self);
static void source_snapshot_real_notify_broken (SourceSnapshot* self);
gboolean source_snapshot_is_broken (SourceSnapshot* self);
SourceSnapshot* source_snapshot_construct (GType object_type);
static void source_snapshot_real_broken (SourceSnapshot* self);
static void source_snapshot_finalize (SourceSnapshot * obj);
#define SOURCE_BACKLINK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SOURCE_BACKLINK, SourceBacklinkPrivate))
static gboolean source_backlink_validate_name_value (const gchar* name,
                                              const gchar* value);
SourceBacklink* source_backlink_new_from_source (DataSource* source);
SourceBacklink* source_backlink_construct_from_source (GType object_type,
                                                       DataSource* source);
gchar* source_backlink_to_string (SourceBacklink* self);
guint source_backlink_hash_func (SourceBacklink* backlink);
gboolean source_backlink_equal_func (SourceBacklink* alink,
                                     SourceBacklink* blink);
const gchar* source_backlink_get_typename (SourceBacklink* self);
gint64 source_backlink_get_instance_id (SourceBacklink* self);
static void source_backlink_finalize (SourceBacklink * obj);
gpointer source_proxy_ref (gpointer instance);
void source_proxy_unref (gpointer instance);
GParamSpec* param_spec_source_proxy (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
void value_set_source_proxy (GValue* value,
                             gpointer v_object);
void value_take_source_proxy (GValue* value,
                              gpointer v_object);
gpointer value_get_source_proxy (const GValue* value);
GType source_proxy_get_type (void) G_GNUC_CONST;
#define SOURCE_PROXY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SOURCE_PROXY, SourceProxyPrivate))
static void source_proxy_drop_source (SourceProxy* self);
static void source_proxy_on_source_added (SourceProxy* self,
                                   GeeIterable* added);
static void _source_proxy_on_source_added_data_collection_items_added (DataCollection* _sender,
                                                                GeeIterable* added,
                                                                gpointer self);
SourceProxy* source_proxy_construct (GType object_type,
                                     DataSource* source);
gint64 data_object_get_object_id (DataObject* self);
static void source_proxy_on_snapshot_broken (SourceProxy* self);
static void _source_proxy_on_snapshot_broken_source_snapshot_broken (SourceSnapshot* _sender,
                                                              gpointer self);
static void source_proxy_set_source (SourceProxy* self,
                              DataSource* source);
DataSource* source_proxy_reconstitute (SourceProxy* self,
                                       gint64 object_id,
                                       SourceSnapshot* snapshot);
static DataSource* source_proxy_real_reconstitute (SourceProxy* self,
                                            gint64 object_id,
                                            SourceSnapshot* snapshot);
void source_proxy_notify_reconstituted (SourceProxy* self,
                                        DataSource* source);
static void source_proxy_real_notify_reconstituted (SourceProxy* self,
                                             DataSource* source);
void source_proxy_notify_dehydrated (SourceProxy* self);
static void source_proxy_real_notify_dehydrated (SourceProxy* self);
void source_proxy_notify_broken (SourceProxy* self);
static void source_proxy_real_notify_broken (SourceProxy* self);
static void source_proxy_on_destroyed (SourceProxy* self);
static void _source_proxy_on_destroyed_data_source_destroyed (DataSource* _sender,
                                                       gpointer self);
DataSource* source_proxy_get_source (SourceProxy* self);
gboolean data_collection_contains (DataCollection* self,
                                   DataObject* object);
static void source_proxy_real_reconstituted (SourceProxy* self,
                                      DataSource* source);
static void source_proxy_real_dehydrated (SourceProxy* self);
static void source_proxy_real_broken (SourceProxy* self);
static void source_proxy_finalize (SourceProxy * obj);
GType proxyable_get_type (void) G_GNUC_CONST;
SourceProxy* proxyable_get_proxy (Proxyable* self);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


DataSource*
data_source_construct (GType object_type,
                       gint64 object_id)
{
	DataSource * self = NULL;
#line 64 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self = (DataSource*) data_object_construct (object_type, object_id);
#line 63 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return self;
#line 616 "DataSource.c"
}


static void
data_source_real_notify_membership_changed (DataObject* base,
                                            DataCollection* collection)
{
	DataSource * self;
	gboolean _tmp4_ = FALSE;
#line 73 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DATA_SOURCE, DataSource);
#line 73 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail ((collection == NULL) || IS_DATA_COLLECTION (collection));
#line 75 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (collection == NULL) {
#line 632 "DataSource.c"
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_;
#line 76 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp1_ = self->priv->is_destroyed;
#line 76 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		if (_tmp1_) {
#line 76 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp0_ = TRUE;
#line 641 "DataSource.c"
		} else {
			GeeHashMap* _tmp2_;
#line 76 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp2_ = self->priv->backlinks;
#line 76 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp0_ = _tmp2_ != NULL;
#line 648 "DataSource.c"
		}
#line 76 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_vala_assert (_tmp0_, "is_destroyed || backlinks != null");
#line 652 "DataSource.c"
	} else {
		gboolean _tmp3_;
#line 78 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp3_ = self->priv->is_destroyed;
#line 78 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_vala_assert (!_tmp3_, "!is_destroyed");
#line 659 "DataSource.c"
	}
#line 82 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (collection == NULL) {
#line 663 "DataSource.c"
		GeeHashMap* _tmp5_;
#line 82 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp5_ = self->priv->backlinks;
#line 82 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp4_ = _tmp5_ != NULL;
#line 669 "DataSource.c"
	} else {
#line 82 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp4_ = FALSE;
#line 673 "DataSource.c"
	}
#line 82 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp4_) {
#line 83 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		data_source_notify_unlinked (self);
#line 679 "DataSource.c"
	}
#line 85 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	DATA_OBJECT_CLASS (data_source_parent_class)->notify_membership_changed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), collection);
#line 683 "DataSource.c"
}


static gpointer
_source_holding_tank_ref0 (gpointer self)
{
#line 100 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return self ? source_holding_tank_ref (self) : NULL;
#line 692 "DataSource.c"
}


static void
data_source_real_notify_held_in_tank (DataSource* self,
                                      SourceHoldingTank* holding_tank)
{
	DataCollection* _tmp0_;
	DataCollection* _tmp1_;
	SourceHoldingTank* _tmp4_;
#line 88 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail ((holding_tank == NULL) || IS_SOURCE_HOLDING_TANK (holding_tank));
#line 90 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = data_object_get_membership (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 90 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = _tmp0_;
#line 90 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (_tmp1_ == NULL, "get_membership() == null");
#line 90 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_data_collection_unref0 (_tmp1_);
#line 94 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (holding_tank != NULL) {
#line 715 "DataSource.c"
		SourceHoldingTank* _tmp2_;
#line 95 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp2_ = self->priv->holding_tank;
#line 95 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_vala_assert (_tmp2_ == NULL, "this.holding_tank == null");
#line 721 "DataSource.c"
	} else {
		SourceHoldingTank* _tmp3_;
#line 97 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp3_ = self->priv->holding_tank;
#line 97 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_vala_assert (_tmp3_ != NULL, "this.holding_tank != null");
#line 728 "DataSource.c"
	}
#line 100 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp4_ = _source_holding_tank_ref0 (holding_tank);
#line 100 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_source_holding_tank_unref0 (self->priv->holding_tank);
#line 100 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->holding_tank = _tmp4_;
#line 736 "DataSource.c"
}


void
data_source_notify_held_in_tank (DataSource* self,
                                 SourceHoldingTank* holding_tank)
{
#line 88 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 88 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	DATA_SOURCE_GET_CLASS (self)->notify_held_in_tank (self, holding_tank);
#line 748 "DataSource.c"
}


static void
data_source_real_notify_altered (DataObject* base,
                                 Alteration* alteration)
{
	DataSource * self;
	SourceHoldingTank* _tmp0_;
#line 103 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DATA_SOURCE, DataSource);
#line 103 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_ALTERATION (alteration));
#line 105 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->holding_tank;
#line 105 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp0_ != NULL) {
#line 766 "DataSource.c"
		SourceHoldingTank* _tmp1_;
#line 106 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp1_ = self->priv->holding_tank;
#line 106 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_holding_tank_internal_notify_altered (_tmp1_, self, alteration);
#line 772 "DataSource.c"
	} else {
#line 108 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		data_source_contact_subscribers_alteration (self, alteration);
#line 110 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		DATA_OBJECT_CLASS (data_source_parent_class)->notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), alteration);
#line 778 "DataSource.c"
	}
}


static void
data_source_real_notify_unlinking (DataSource* self,
                                   SourceCollection* collection)
{
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp3_;
#line 115 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (collection));
#line 116 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = self->priv->backlinks;
#line 116 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp1_ == NULL) {
#line 796 "DataSource.c"
		SourceCollection* _tmp2_;
#line 116 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp2_ = self->priv->unlinked_from_collection;
#line 116 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 802 "DataSource.c"
	} else {
#line 116 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = FALSE;
#line 806 "DataSource.c"
	}
#line 116 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (_tmp0_, "backlinks == null && unlinked_from_collection == null");
#line 118 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->unlinked_from_collection = collection;
#line 119 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 119 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_object_unref0 (self->priv->backlinks);
#line 119 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->backlinks = _tmp3_;
#line 818 "DataSource.c"
}


void
data_source_notify_unlinking (DataSource* self,
                              SourceCollection* collection)
{
#line 115 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 115 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	DATA_SOURCE_GET_CLASS (self)->notify_unlinking (self, collection);
#line 830 "DataSource.c"
}


static void
data_source_real_notify_unlinked (DataSource* self)
{
	gboolean _tmp0_ = FALSE;
	SourceCollection* _tmp1_;
	SourceCollection* _tmp3_;
	GeeHashMap* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
#line 124 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = self->priv->unlinked_from_collection;
#line 124 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp1_ != NULL) {
#line 847 "DataSource.c"
		GeeHashMap* _tmp2_;
#line 124 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp2_ = self->priv->backlinks;
#line 124 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 853 "DataSource.c"
	} else {
#line 124 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = FALSE;
#line 857 "DataSource.c"
	}
#line 124 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (_tmp0_, "unlinked_from_collection != null && backlinks != null");
#line 126 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = self->priv->unlinked_from_collection;
#line 126 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_emit (self, data_source_signals[DATA_SOURCE_UNLINKED_SIGNAL], 0, _tmp3_);
#line 129 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp4_ = self->priv->backlinks;
#line 129 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp5_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 129 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp6_ = _tmp5_;
#line 129 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp6_ > 0) {
#line 873 "DataSource.c"
		SourceCollection* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
#line 130 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp7_ = self->priv->unlinked_from_collection;
#line 130 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp8_ = data_source_dehydrate_backlinks (self);
#line 130 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp9_ = _tmp8_;
#line 130 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		data_source_commit_backlinks (self, _tmp7_, _tmp9_);
#line 130 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_g_free0 (_tmp9_);
#line 887 "DataSource.c"
	}
}


void
data_source_notify_unlinked (DataSource* self)
{
#line 123 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 123 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	DATA_SOURCE_GET_CLASS (self)->notify_unlinked (self);
#line 899 "DataSource.c"
}


static void
data_source_real_notify_relinking (DataSource* self,
                                   SourceCollection* collection)
{
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_;
#line 134 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (collection));
#line 135 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = self->priv->backlinks;
#line 135 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp1_ != NULL) {
#line 915 "DataSource.c"
		SourceCollection* _tmp2_;
#line 135 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp2_ = self->priv->unlinked_from_collection;
#line 135 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = _tmp2_ == collection;
#line 921 "DataSource.c"
	} else {
#line 135 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = FALSE;
#line 925 "DataSource.c"
	}
#line 135 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (_tmp0_, "(backlinks != null) && (unlinked_from_collection == collection)");
#line 929 "DataSource.c"
}


void
data_source_notify_relinking (DataSource* self,
                              SourceCollection* collection)
{
#line 134 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 134 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	DATA_SOURCE_GET_CLASS (self)->notify_relinking (self, collection);
#line 941 "DataSource.c"
}


static gpointer
_data_collection_ref0 (gpointer self)
{
#line 142 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return self ? data_collection_ref (self) : NULL;
#line 950 "DataSource.c"
}


static void
data_source_real_notify_relinked (DataSource* self)
{
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_;
	SourceCollection* relinked_to = NULL;
	SourceCollection* _tmp3_;
	SourceCollection* _tmp4_;
#line 140 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = self->priv->backlinks;
#line 140 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp1_ != NULL) {
#line 966 "DataSource.c"
		SourceCollection* _tmp2_;
#line 140 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp2_ = self->priv->unlinked_from_collection;
#line 140 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 972 "DataSource.c"
	} else {
#line 140 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = FALSE;
#line 976 "DataSource.c"
	}
#line 140 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (_tmp0_, "backlinks != null && unlinked_from_collection != null");
#line 142 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = self->priv->unlinked_from_collection;
#line 142 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp4_ = _data_collection_ref0 (_tmp3_);
#line 142 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	relinked_to = _tmp4_;
#line 143 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_object_unref0 (self->priv->backlinks);
#line 143 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->backlinks = NULL;
#line 144 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->unlinked_from_collection = NULL;
#line 145 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_emit (self, data_source_signals[DATA_SOURCE_RELINKED_SIGNAL], 0, relinked_to);
#line 148 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	data_source_commit_backlinks (self, NULL, NULL);
#line 139 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_data_collection_unref0 (relinked_to);
#line 998 "DataSource.c"
}


void
data_source_notify_relinked (DataSource* self)
{
#line 139 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 139 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	DATA_SOURCE_GET_CLASS (self)->notify_relinked (self);
#line 1009 "DataSource.c"
}


static gchar*
data_source_real_get_typename (DataSource* self)
{
#line 156 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_critical ("Type `%s' does not implement abstract method `data_source_get_typename'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 156 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return NULL;
#line 1020 "DataSource.c"
}


gchar*
data_source_get_typename (DataSource* self)
{
#line 156 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (self), NULL);
#line 156 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return DATA_SOURCE_GET_CLASS (self)->get_typename (self);
#line 1031 "DataSource.c"
}


static gint64
data_source_real_get_instance_id (DataSource* self)
{
	gint64 _tmp0_ = 0LL;
#line 162 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_critical ("Type `%s' does not implement abstract method `data_source_get_instance_id'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 162 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return _tmp0_;
#line 1043 "DataSource.c"
}


gint64
data_source_get_instance_id (DataSource* self)
{
#line 162 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (self), 0LL);
#line 162 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return DATA_SOURCE_GET_CLASS (self)->get_instance_id (self);
#line 1054 "DataSource.c"
}


static gchar*
data_source_real_get_source_id (DataSource* self)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 167 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = data_source_get_typename (self);
#line 167 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = _tmp0_;
#line 167 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = g_strdup_printf ("%s-%016" G_GINT64_MODIFIER "x", _tmp1_, data_source_get_instance_id (self));
#line 167 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = _tmp2_;
#line 167 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_free0 (_tmp1_);
#line 167 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp3_;
#line 167 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 1080 "DataSource.c"
}


gchar*
data_source_get_source_id (DataSource* self)
{
#line 166 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (self), NULL);
#line 166 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return DATA_SOURCE_GET_CLASS (self)->get_source_id (self);
#line 1091 "DataSource.c"
}


gboolean
data_source_has_backlink (DataSource* self,
                          SourceBacklink* backlink)
{
	gboolean result = FALSE;
	GeeHashMap* _tmp0_;
	GeeList* values = NULL;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gpointer _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeList* _tmp6_;
#line 170 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (self), FALSE);
#line 170 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_SOURCE_BACKLINK (backlink), FALSE);
#line 171 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->backlinks;
#line 171 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp0_ == NULL) {
#line 172 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		result = FALSE;
#line 172 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return result;
#line 1120 "DataSource.c"
	}
#line 174 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = self->priv->backlinks;
#line 174 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = source_backlink_get_name (backlink);
#line 174 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = _tmp2_;
#line 174 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp4_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp3_);
#line 174 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	values = (GeeList*) _tmp4_;
#line 176 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp6_ = values;
#line 176 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp6_ != NULL) {
#line 1136 "DataSource.c"
		GeeList* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
#line 176 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp7_ = values;
#line 176 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp8_ = source_backlink_get_value (backlink);
#line 176 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp9_ = _tmp8_;
#line 176 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp5_ = gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection), _tmp9_);
#line 1148 "DataSource.c"
	} else {
#line 176 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp5_ = FALSE;
#line 1152 "DataSource.c"
	}
#line 176 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp5_;
#line 176 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_object_unref0 (values);
#line 176 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 1160 "DataSource.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return self ? g_object_ref (self) : NULL;
#line 1169 "DataSource.c"
}


GeeList*
data_source_get_backlinks (DataSource* self,
                           const gchar* name)
{
	GeeList* result = NULL;
	GeeHashMap* _tmp0_;
	GeeList* values = NULL;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeList* _tmp4_;
	GeeList* backlinks = NULL;
	GeeArrayList* _tmp8_;
#line 179 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (self), NULL);
#line 179 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 180 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->backlinks;
#line 180 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp0_ == NULL) {
#line 181 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		result = NULL;
#line 181 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return result;
#line 1198 "DataSource.c"
	}
#line 183 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = self->priv->backlinks;
#line 183 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), name);
#line 183 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	values = (GeeList*) _tmp2_;
#line 184 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp4_ = values;
#line 184 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp4_ == NULL) {
#line 184 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp3_ = TRUE;
#line 1212 "DataSource.c"
	} else {
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
#line 184 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp5_ = values;
#line 184 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp6_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
#line 184 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp7_ = _tmp6_;
#line 184 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp3_ = _tmp7_ == 0;
#line 1225 "DataSource.c"
	}
#line 184 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp3_) {
#line 185 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		result = NULL;
#line 185 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_g_object_unref0 (values);
#line 185 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return result;
#line 1235 "DataSource.c"
	}
#line 187 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp8_ = gee_array_list_new (TYPE_SOURCE_BACKLINK, (GBoxedCopyFunc) source_backlink_ref, (GDestroyNotify) source_backlink_unref, NULL, NULL, NULL);
#line 187 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	backlinks = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_LIST, GeeList);
#line 1241 "DataSource.c"
	{
		GeeList* _value_list = NULL;
		GeeList* _tmp9_;
		GeeList* _tmp10_;
		gint _value_size = 0;
		GeeList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _value_index = 0;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp9_ = values;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp10_ = _g_object_ref0 (_tmp9_);
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_value_list = _tmp10_;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp11_ = _value_list;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp12_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_COLLECTION, GeeCollection));
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp13_ = _tmp12_;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_value_size = _tmp13_;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_value_index = -1;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		while (TRUE) {
#line 1269 "DataSource.c"
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gchar* value = NULL;
			GeeList* _tmp17_;
			gint _tmp18_;
			gpointer _tmp19_;
			GeeList* _tmp20_;
			const gchar* _tmp21_;
			SourceBacklink* _tmp22_;
			SourceBacklink* _tmp23_;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp14_ = _value_index;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_value_index = _tmp14_ + 1;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp15_ = _value_index;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp16_ = _value_size;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			if (!(_tmp15_ < _tmp16_)) {
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				break;
#line 1293 "DataSource.c"
			}
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp17_ = _value_list;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp18_ = _value_index;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp19_ = gee_list_get (_tmp17_, _tmp18_);
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			value = (gchar*) _tmp19_;
#line 189 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp20_ = backlinks;
#line 189 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp21_ = value;
#line 189 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp22_ = source_backlink_new (name, _tmp21_);
#line 189 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp23_ = _tmp22_;
#line 189 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_COLLECTION, GeeCollection), _tmp23_);
#line 189 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_source_backlink_unref0 (_tmp23_);
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_g_free0 (value);
#line 1317 "DataSource.c"
		}
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_g_object_unref0 (_value_list);
#line 1321 "DataSource.c"
	}
#line 191 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = backlinks;
#line 191 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_object_unref0 (values);
#line 191 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 1329 "DataSource.c"
}


void
data_source_set_backlink (DataSource* self,
                          SourceBacklink* backlink)
{
	GeeHashMap* _tmp0_;
	GeeList* values = NULL;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gpointer _tmp4_;
	GeeList* _tmp5_;
	GeeList* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	SourceCollection* sources = NULL;
	DataCollection* _tmp14_;
	SourceCollection* _tmp15_;
#line 194 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 194 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_BACKLINK (backlink));
#line 196 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->backlinks;
#line 196 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (_tmp0_ != NULL, "backlinks != null");
#line 198 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = self->priv->backlinks;
#line 198 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = source_backlink_get_name (backlink);
#line 198 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = _tmp2_;
#line 198 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp4_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp3_);
#line 198 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	values = (GeeList*) _tmp4_;
#line 199 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp5_ = values;
#line 199 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp5_ == NULL) {
#line 1372 "DataSource.c"
		GeeArrayList* _tmp6_;
		GeeHashMap* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		GeeList* _tmp10_;
#line 200 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp6_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 200 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_g_object_unref0 (values);
#line 200 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		values = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_LIST, GeeList);
#line 201 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp7_ = self->priv->backlinks;
#line 201 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp8_ = source_backlink_get_name (backlink);
#line 201 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp9_ = _tmp8_;
#line 201 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp10_ = values;
#line 201 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp9_, _tmp10_);
#line 1394 "DataSource.c"
	}
#line 204 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp11_ = values;
#line 204 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp12_ = source_backlink_get_value (backlink);
#line 204 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp13_ = _tmp12_;
#line 204 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_COLLECTION, GeeCollection), _tmp13_);
#line 206 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp14_ = data_object_get_membership (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 206 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	sources = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_SOURCE_COLLECTION, SourceCollection);
#line 207 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp15_ = sources;
#line 207 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp15_ != NULL) {
#line 1412 "DataSource.c"
		SourceCollection* _tmp16_;
#line 208 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp16_ = sources;
#line 208 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_collection_internal_backlink_set (_tmp16_, self, backlink);
#line 1418 "DataSource.c"
	}
#line 194 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_data_collection_unref0 (sources);
#line 194 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_object_unref0 (values);
#line 1424 "DataSource.c"
}


gboolean
data_source_remove_backlink (DataSource* self,
                             SourceBacklink* backlink)
{
	gboolean result = FALSE;
	GeeHashMap* _tmp0_;
	GeeList* values = NULL;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gpointer _tmp4_;
	GeeList* _tmp5_;
	gint original_size = 0;
	GeeList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GeeIterator* iter = NULL;
	GeeList* _tmp10_;
	GeeIterator* _tmp11_;
	GeeList* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	SourceCollection* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	SourceCollection* sources = NULL;
	DataCollection* _tmp29_;
	SourceCollection* _tmp30_;
	GeeList* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
#line 211 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (self), FALSE);
#line 211 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_SOURCE_BACKLINK (backlink), FALSE);
#line 212 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->backlinks;
#line 212 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp0_ == NULL) {
#line 213 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		result = FALSE;
#line 213 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return result;
#line 1473 "DataSource.c"
	}
#line 215 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = self->priv->backlinks;
#line 215 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = source_backlink_get_name (backlink);
#line 215 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = _tmp2_;
#line 215 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp4_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp3_);
#line 215 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	values = (GeeList*) _tmp4_;
#line 216 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp5_ = values;
#line 216 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp5_ == NULL) {
#line 217 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		result = FALSE;
#line 217 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_g_object_unref0 (values);
#line 217 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return result;
#line 1495 "DataSource.c"
	}
#line 219 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp6_ = values;
#line 219 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp7_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
#line 219 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp8_ = _tmp7_;
#line 219 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	original_size = _tmp8_;
#line 220 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp9_ = original_size;
#line 220 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (_tmp9_ > 0, "original_size > 0");
#line 222 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp10_ = values;
#line 222 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp11_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ITERABLE, GeeIterable));
#line 222 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	iter = _tmp11_;
#line 223 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	while (TRUE) {
#line 1517 "DataSource.c"
		GeeIterator* _tmp12_;
		GeeIterator* _tmp13_;
		gpointer _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gboolean _tmp18_;
#line 223 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp12_ = iter;
#line 223 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		if (!gee_iterator_next (_tmp12_)) {
#line 223 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			break;
#line 1531 "DataSource.c"
		}
#line 224 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp13_ = iter;
#line 224 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp14_ = gee_iterator_get (_tmp13_);
#line 224 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp15_ = (gchar*) _tmp14_;
#line 224 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp16_ = source_backlink_get_value (backlink);
#line 224 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp17_ = _tmp16_;
#line 224 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp18_ = g_strcmp0 (_tmp15_, _tmp17_) == 0;
#line 224 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_g_free0 (_tmp15_);
#line 224 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		if (_tmp18_) {
#line 1549 "DataSource.c"
			GeeIterator* _tmp19_;
#line 225 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp19_ = iter;
#line 225 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			gee_iterator_remove (_tmp19_);
#line 1555 "DataSource.c"
		}
	}
#line 228 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp20_ = values;
#line 228 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp21_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_COLLECTION, GeeCollection));
#line 228 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp22_ = _tmp21_;
#line 228 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp22_ == 0) {
#line 1566 "DataSource.c"
		GeeHashMap* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
#line 229 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp23_ = self->priv->backlinks;
#line 229 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp24_ = source_backlink_get_name (backlink);
#line 229 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp25_ = _tmp24_;
#line 229 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp25_, NULL);
#line 1578 "DataSource.c"
	}
#line 233 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp26_ = self->priv->unlinked_from_collection;
#line 233 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp27_ = data_source_dehydrate_backlinks (self);
#line 233 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp28_ = _tmp27_;
#line 233 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	data_source_commit_backlinks (self, _tmp26_, _tmp28_);
#line 233 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_free0 (_tmp28_);
#line 235 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp29_ = data_object_get_membership (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 235 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	sources = G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_SOURCE_COLLECTION, SourceCollection);
#line 236 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp30_ = sources;
#line 236 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp30_ != NULL) {
#line 1598 "DataSource.c"
		SourceCollection* _tmp31_;
#line 237 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp31_ = sources;
#line 237 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_collection_internal_backlink_removed (_tmp31_, self, backlink);
#line 1604 "DataSource.c"
	}
#line 239 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp32_ = values;
#line 239 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp33_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GEE_TYPE_COLLECTION, GeeCollection));
#line 239 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp34_ = _tmp33_;
#line 239 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp35_ = original_size;
#line 239 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp34_ != _tmp35_;
#line 239 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_data_collection_unref0 (sources);
#line 239 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_object_unref0 (iter);
#line 239 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_object_unref0 (values);
#line 239 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 1624 "DataSource.c"
}


static void
data_source_real_commit_backlinks (DataSource* self,
                                   SourceCollection* sources,
                                   const gchar* dehydrated)
{
	gboolean _tmp0_ = FALSE;
#line 248 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail ((sources == NULL) || IS_SOURCE_COLLECTION (sources));
#line 249 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (sources != NULL) {
#line 249 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = TRUE;
#line 1640 "DataSource.c"
	} else {
#line 249 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = dehydrated != NULL;
#line 1644 "DataSource.c"
	}
#line 249 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp0_) {
#line 1648 "DataSource.c"
		gchar* _tmp1_;
		gchar* _tmp2_;
#line 250 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp1_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 250 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp2_ = _tmp1_;
#line 250 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_warning ("DataSource.vala:250: No implementation to commit link state for %s", _tmp2_);
#line 250 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_g_free0 (_tmp2_);
#line 1659 "DataSource.c"
	}
}


void
data_source_commit_backlinks (DataSource* self,
                              SourceCollection* sources,
                              const gchar* dehydrated)
{
#line 248 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 248 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	DATA_SOURCE_GET_CLASS (self)->commit_backlinks (self, sources, dehydrated);
#line 1673 "DataSource.c"
}


static gchar*
data_source_dehydrate_backlinks (DataSource* self)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_;
	GString* builder = NULL;
	GString* _tmp5_;
	const gchar* _tmp49_ = NULL;
	GString* _tmp50_;
	const gchar* _tmp51_;
	gint _tmp52_;
	gint _tmp53_;
	gchar* _tmp56_;
#line 253 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (self), NULL);
#line 254 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = self->priv->backlinks;
#line 254 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp1_ == NULL) {
#line 254 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = TRUE;
#line 1699 "DataSource.c"
	} else {
		GeeHashMap* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 254 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp2_ = self->priv->backlinks;
#line 254 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp3_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 254 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp4_ = _tmp3_;
#line 254 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = _tmp4_ == 0;
#line 1712 "DataSource.c"
	}
#line 254 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp0_) {
#line 255 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		result = NULL;
#line 255 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return result;
#line 1720 "DataSource.c"
	}
#line 257 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp5_ = g_string_new ("");
#line 257 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	builder = _tmp5_;
#line 1726 "DataSource.c"
	{
		GeeIterator* _name_it = NULL;
		GeeHashMap* _tmp6_;
		GeeSet* _tmp7_;
		GeeSet* _tmp8_;
		GeeSet* _tmp9_;
		GeeIterator* _tmp10_;
		GeeIterator* _tmp11_;
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp6_ = self->priv->backlinks;
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp7_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp8_ = _tmp7_;
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp9_ = _tmp8_;
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp10_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ITERABLE, GeeIterable));
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp11_ = _tmp10_;
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_g_object_unref0 (_tmp9_);
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_name_it = _tmp11_;
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		while (TRUE) {
#line 1753 "DataSource.c"
			GeeIterator* _tmp12_;
			gchar* name = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			GeeList* values = NULL;
			GeeHashMap* _tmp15_;
			const gchar* _tmp16_;
			gpointer _tmp17_;
			gboolean _tmp18_ = FALSE;
			GeeList* _tmp19_;
			gchar* value_field = NULL;
			gchar* _tmp23_;
			const gchar* _tmp41_;
			gint _tmp42_;
			gint _tmp43_;
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp12_ = _name_it;
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			if (!gee_iterator_next (_tmp12_)) {
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				break;
#line 1775 "DataSource.c"
			}
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp13_ = _name_it;
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp14_ = gee_iterator_get (_tmp13_);
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			name = (gchar*) _tmp14_;
#line 259 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp15_ = self->priv->backlinks;
#line 259 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp16_ = name;
#line 259 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp17_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp16_);
#line 259 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			values = (GeeList*) _tmp17_;
#line 260 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp19_ = values;
#line 260 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			if (_tmp19_ == NULL) {
#line 260 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp18_ = TRUE;
#line 1797 "DataSource.c"
			} else {
				GeeList* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
#line 260 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp20_ = values;
#line 260 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp21_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_COLLECTION, GeeCollection));
#line 260 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp22_ = _tmp21_;
#line 260 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp18_ = _tmp22_ == 0;
#line 1810 "DataSource.c"
			}
#line 260 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			if (_tmp18_) {
#line 261 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_g_object_unref0 (values);
#line 261 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_g_free0 (name);
#line 261 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				continue;
#line 1820 "DataSource.c"
			}
#line 263 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp23_ = g_strdup ("");
#line 263 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			value_field = _tmp23_;
#line 1826 "DataSource.c"
			{
				GeeList* _value_list = NULL;
				GeeList* _tmp24_;
				GeeList* _tmp25_;
				gint _value_size = 0;
				GeeList* _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				gint _value_index = 0;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp24_ = values;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp25_ = _g_object_ref0 (_tmp24_);
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_value_list = _tmp25_;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp26_ = _value_list;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp27_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_COLLECTION, GeeCollection));
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp28_ = _tmp27_;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_value_size = _tmp28_;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_value_index = -1;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				while (TRUE) {
#line 1854 "DataSource.c"
					gint _tmp29_;
					gint _tmp30_;
					gint _tmp31_;
					gchar* value = NULL;
					GeeList* _tmp32_;
					gint _tmp33_;
					gpointer _tmp34_;
					const gchar* _tmp35_;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp29_ = _value_index;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_value_index = _tmp29_ + 1;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp30_ = _value_index;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp31_ = _value_size;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					if (!(_tmp30_ < _tmp31_)) {
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
						break;
#line 1875 "DataSource.c"
					}
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp32_ = _value_list;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp33_ = _value_index;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp34_ = gee_list_get (_tmp32_, _tmp33_);
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					value = (gchar*) _tmp34_;
#line 265 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp35_ = value;
#line 265 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					if (!is_string_empty (_tmp35_)) {
#line 1889 "DataSource.c"
						const gchar* _tmp36_;
						const gchar* _tmp37_;
						gchar* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp40_;
#line 266 "/home/jens/Source/shotwell/src/core/DataSource.vala"
						_tmp36_ = value_field;
#line 266 "/home/jens/Source/shotwell/src/core/DataSource.vala"
						_tmp37_ = value;
#line 266 "/home/jens/Source/shotwell/src/core/DataSource.vala"
						_tmp38_ = g_strconcat (_tmp37_, "|", NULL);
#line 266 "/home/jens/Source/shotwell/src/core/DataSource.vala"
						_tmp39_ = _tmp38_;
#line 266 "/home/jens/Source/shotwell/src/core/DataSource.vala"
						_tmp40_ = g_strconcat (_tmp36_, _tmp39_, NULL);
#line 266 "/home/jens/Source/shotwell/src/core/DataSource.vala"
						_g_free0 (value_field);
#line 266 "/home/jens/Source/shotwell/src/core/DataSource.vala"
						value_field = _tmp40_;
#line 266 "/home/jens/Source/shotwell/src/core/DataSource.vala"
						_g_free0 (_tmp39_);
#line 1911 "DataSource.c"
					}
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_g_free0 (value);
#line 1915 "DataSource.c"
				}
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_g_object_unref0 (_value_list);
#line 1919 "DataSource.c"
			}
#line 269 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp41_ = value_field;
#line 269 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp42_ = strlen (_tmp41_);
#line 269 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp43_ = _tmp42_;
#line 269 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			if (_tmp43_ > 0) {
#line 1929 "DataSource.c"
				GString* _tmp44_;
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
#line 270 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp44_ = builder;
#line 270 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp45_ = name;
#line 270 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp46_ = value_field;
#line 270 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp47_ = g_strdup_printf ("%s=%s\n", _tmp45_, _tmp46_);
#line 270 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp48_ = _tmp47_;
#line 270 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				g_string_append (_tmp44_, _tmp48_);
#line 270 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_g_free0 (_tmp48_);
#line 1949 "DataSource.c"
			}
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_g_free0 (value_field);
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_g_object_unref0 (values);
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_g_free0 (name);
#line 1957 "DataSource.c"
		}
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_g_object_unref0 (_name_it);
#line 1961 "DataSource.c"
	}
#line 273 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp50_ = builder;
#line 273 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp51_ = _tmp50_->str;
#line 273 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp52_ = strlen (_tmp51_);
#line 273 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp53_ = _tmp52_;
#line 273 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp53_ > 0) {
#line 1973 "DataSource.c"
		GString* _tmp54_;
		const gchar* _tmp55_;
#line 273 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp54_ = builder;
#line 273 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp55_ = _tmp54_->str;
#line 273 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp49_ = _tmp55_;
#line 1982 "DataSource.c"
	} else {
#line 273 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp49_ = NULL;
#line 1986 "DataSource.c"
	}
#line 273 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp56_ = g_strdup (_tmp49_);
#line 273 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp56_;
#line 273 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_string_free0 (builder);
#line 273 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 1996 "DataSource.c"
}


void
data_source_rehydrate_backlinks (DataSource* self,
                                 SourceCollection* unlinked_from,
                                 const gchar* dehydrated)
{
	GeeHashMap* _tmp0_;
	gchar** lines = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint lines_length1;
	gint _lines_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
#line 278 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 278 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (unlinked_from));
#line 279 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->unlinked_from_collection = unlinked_from;
#line 280 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 280 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_object_unref0 (self->priv->backlinks);
#line 280 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->backlinks = _tmp0_;
#line 282 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (dehydrated == NULL) {
#line 283 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return;
#line 2029 "DataSource.c"
	}
#line 285 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = _tmp1_ = g_strsplit (dehydrated, "\n", 0);
#line 285 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	lines = _tmp2_;
#line 285 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	lines_length1 = _vala_array_length (_tmp1_);
#line 285 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_lines_size_ = lines_length1;
#line 286 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = lines;
#line 286 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3__length1 = lines_length1;
#line 2043 "DataSource.c"
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
#line 286 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		line_collection = _tmp3_;
#line 286 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		line_collection_length1 = _tmp3__length1;
#line 286 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		for (line_it = 0; line_it < _tmp3__length1; line_it = line_it + 1) {
#line 2055 "DataSource.c"
			gchar* _tmp4_;
			gchar* line = NULL;
#line 286 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp4_ = g_strdup (line_collection[line_it]);
#line 286 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			line = _tmp4_;
#line 2062 "DataSource.c"
			{
				const gchar* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				gchar** tokens = NULL;
				const gchar* _tmp8_;
				gchar** _tmp9_;
				gchar** _tmp10_;
				gint tokens_length1;
				gint _tokens_size_;
				gchar** _tmp11_;
				gint _tmp11__length1;
				gchar** decoded_values = NULL;
				gchar** _tmp15_;
				gint _tmp15__length1;
				const gchar* _tmp16_;
				gchar** _tmp17_;
				gchar** _tmp18_;
				gint decoded_values_length1;
				gint _decoded_values_size_;
				GeeList* values = NULL;
				GeeArrayList* _tmp19_;
				gchar** _tmp20_;
				gint _tmp20__length1;
				GeeList* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
#line 287 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp5_ = line;
#line 287 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp6_ = strlen (_tmp5_);
#line 287 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp7_ = _tmp6_;
#line 287 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (_tmp7_ == 0) {
#line 288 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_g_free0 (line);
#line 288 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					continue;
#line 2102 "DataSource.c"
				}
#line 290 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp8_ = line;
#line 290 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, "=", 2);
#line 290 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				tokens = _tmp10_;
#line 290 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				tokens_length1 = _vala_array_length (_tmp9_);
#line 290 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tokens_size_ = tokens_length1;
#line 291 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp11_ = tokens;
#line 291 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp11__length1 = tokens_length1;
#line 291 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (_tmp11__length1 < 2) {
#line 2120 "DataSource.c"
					const gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
#line 292 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp12_ = line;
#line 292 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp13_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 292 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp14_ = _tmp13_;
#line 292 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					g_warning ("DataSource.vala:292: Unable to rehydrate \"%s\" for %s: name and value" \
" not present", _tmp12_, _tmp14_);
#line 292 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_g_free0 (_tmp14_);
#line 295 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 295 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_g_free0 (line);
#line 295 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					continue;
#line 2140 "DataSource.c"
				}
#line 298 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp15_ = tokens;
#line 298 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp15__length1 = tokens_length1;
#line 298 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp16_ = _tmp15_[1];
#line 298 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp18_ = _tmp17_ = g_strsplit (_tmp16_, "|", 0);
#line 298 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				decoded_values = _tmp18_;
#line 298 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				decoded_values_length1 = _vala_array_length (_tmp17_);
#line 298 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_decoded_values_size_ = decoded_values_length1;
#line 299 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp19_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 299 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				values = G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_LIST, GeeList);
#line 300 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp20_ = decoded_values;
#line 300 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp20__length1 = decoded_values_length1;
#line 2164 "DataSource.c"
				{
					gchar** value_collection = NULL;
					gint value_collection_length1 = 0;
					gint _value_collection_size_ = 0;
					gint value_it = 0;
#line 300 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					value_collection = _tmp20_;
#line 300 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					value_collection_length1 = _tmp20__length1;
#line 300 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					for (value_it = 0; value_it < _tmp20__length1; value_it = value_it + 1) {
#line 2176 "DataSource.c"
						gchar* _tmp21_;
						gchar* value = NULL;
#line 300 "/home/jens/Source/shotwell/src/core/DataSource.vala"
						_tmp21_ = g_strdup (value_collection[value_it]);
#line 300 "/home/jens/Source/shotwell/src/core/DataSource.vala"
						value = _tmp21_;
#line 2183 "DataSource.c"
						{
							gboolean _tmp22_ = FALSE;
							const gchar* _tmp23_;
#line 301 "/home/jens/Source/shotwell/src/core/DataSource.vala"
							_tmp23_ = value;
#line 301 "/home/jens/Source/shotwell/src/core/DataSource.vala"
							if (_tmp23_ != NULL) {
#line 2191 "DataSource.c"
								const gchar* _tmp24_;
								gint _tmp25_;
								gint _tmp26_;
#line 301 "/home/jens/Source/shotwell/src/core/DataSource.vala"
								_tmp24_ = value;
#line 301 "/home/jens/Source/shotwell/src/core/DataSource.vala"
								_tmp25_ = strlen (_tmp24_);
#line 301 "/home/jens/Source/shotwell/src/core/DataSource.vala"
								_tmp26_ = _tmp25_;
#line 301 "/home/jens/Source/shotwell/src/core/DataSource.vala"
								_tmp22_ = _tmp26_ > 0;
#line 2203 "DataSource.c"
							} else {
#line 301 "/home/jens/Source/shotwell/src/core/DataSource.vala"
								_tmp22_ = FALSE;
#line 2207 "DataSource.c"
							}
#line 301 "/home/jens/Source/shotwell/src/core/DataSource.vala"
							if (_tmp22_) {
#line 2211 "DataSource.c"
								GeeList* _tmp27_;
								const gchar* _tmp28_;
#line 302 "/home/jens/Source/shotwell/src/core/DataSource.vala"
								_tmp27_ = values;
#line 302 "/home/jens/Source/shotwell/src/core/DataSource.vala"
								_tmp28_ = value;
#line 302 "/home/jens/Source/shotwell/src/core/DataSource.vala"
								gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_COLLECTION, GeeCollection), _tmp28_);
#line 2220 "DataSource.c"
							}
#line 300 "/home/jens/Source/shotwell/src/core/DataSource.vala"
							_g_free0 (value);
#line 2224 "DataSource.c"
						}
					}
				}
#line 305 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp29_ = values;
#line 305 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp30_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_COLLECTION, GeeCollection));
#line 305 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp31_ = _tmp30_;
#line 305 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (_tmp31_ > 0) {
#line 2236 "DataSource.c"
					GeeHashMap* _tmp32_;
					gchar** _tmp33_;
					gint _tmp33__length1;
					const gchar* _tmp34_;
					GeeList* _tmp35_;
#line 306 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp32_ = self->priv->backlinks;
#line 306 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp33_ = tokens;
#line 306 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp33__length1 = tokens_length1;
#line 306 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp34_ = _tmp33_[0];
#line 306 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp35_ = values;
#line 306 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp34_, _tmp35_);
#line 2254 "DataSource.c"
				}
#line 286 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_g_object_unref0 (values);
#line 286 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				decoded_values = (_vala_array_free (decoded_values, decoded_values_length1, (GDestroyNotify) g_free), NULL);
#line 286 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 286 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_g_free0 (line);
#line 2264 "DataSource.c"
			}
		}
	}
#line 278 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 2270 "DataSource.c"
}


static SourceSnapshot*
data_source_real_save_snapshot (DataSource* self)
{
	SourceSnapshot* result = NULL;
#line 312 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = NULL;
#line 312 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 2282 "DataSource.c"
}


SourceSnapshot*
data_source_save_snapshot (DataSource* self)
{
#line 311 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (self), NULL);
#line 311 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return DATA_SOURCE_GET_CLASS (self)->save_snapshot (self);
#line 2293 "DataSource.c"
}


void
data_source_internal_mark_for_destroy (DataSource* self)
{
#line 316 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 317 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->marked_for_destroy = TRUE;
#line 2304 "DataSource.c"
}


static gboolean
data_source_real_internal_delete_backing (DataSource* self,
                                          GError** error)
{
	gboolean result = FALSE;
#line 325 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = TRUE;
#line 325 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 2317 "DataSource.c"
}


gboolean
data_source_internal_delete_backing (DataSource* self,
                                     GError** error)
{
#line 324 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (self), FALSE);
#line 324 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return DATA_SOURCE_GET_CLASS (self)->internal_delete_backing (self, error);
#line 2329 "DataSource.c"
}


static gboolean
data_source_real_equals (DataSource* self,
                         DataSource* source)
{
	gboolean result = FALSE;
#line 330 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail ((source == NULL) || IS_DATA_SOURCE (source), FALSE);
#line 331 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = self == source;
#line 331 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 2344 "DataSource.c"
}


gboolean
data_source_equals (DataSource* self,
                    DataSource* source)
{
#line 330 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (self), FALSE);
#line 330 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return DATA_SOURCE_GET_CLASS (self)->equals (self, source);
#line 2356 "DataSource.c"
}


static void
data_source_real_destroy (DataSource* self)
{
	gboolean _tmp0_;
#line 341 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->marked_for_destroy;
#line 341 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (_tmp0_, "marked_for_destroy");
#line 344 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->is_destroyed = TRUE;
#line 2370 "DataSource.c"
	{
		gint ctr = 0;
#line 347 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		ctr = 0;
#line 2375 "DataSource.c"
		{
			gboolean _tmp1_ = FALSE;
#line 347 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp1_ = TRUE;
#line 347 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			while (TRUE) {
#line 2382 "DataSource.c"
				gint _tmp3_;
				DataView** _tmp4_;
				gint _tmp4__length1;
				DataView** _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				DataView* _tmp7_;
#line 347 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (!_tmp1_) {
#line 2392 "DataSource.c"
					gint _tmp2_;
#line 347 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp2_ = ctr;
#line 347 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					ctr = _tmp2_ + 1;
#line 2398 "DataSource.c"
				}
#line 347 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp1_ = FALSE;
#line 347 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp3_ = ctr;
#line 347 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp4_ = self->priv->subscribers;
#line 347 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp4__length1 = self->priv->subscribers_length1;
#line 347 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (!(_tmp3_ < _tmp4__length1)) {
#line 347 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					break;
#line 2412 "DataSource.c"
				}
#line 348 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp5_ = self->priv->subscribers;
#line 348 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp5__length1 = self->priv->subscribers_length1;
#line 348 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp6_ = ctr;
#line 348 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp7_ = _tmp5_[_tmp6_];
#line 348 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (_tmp7_ != NULL) {
#line 2424 "DataSource.c"
					DataView* view = NULL;
					DataView** _tmp8_;
					gint _tmp8__length1;
					gint _tmp9_;
					DataView* _tmp10_;
					DataView* _tmp11_;
					DataView** _tmp12_;
					gint _tmp12__length1;
					gint _tmp13_;
					DataView* _tmp14_;
					DataView* _tmp15_;
#line 349 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp8_ = self->priv->subscribers;
#line 349 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp8__length1 = self->priv->subscribers_length1;
#line 349 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp9_ = ctr;
#line 349 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp10_ = _tmp8_[_tmp9_];
#line 349 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp11_ = _g_object_ref0 (_tmp10_);
#line 349 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					view = _tmp11_;
#line 350 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp12_ = self->priv->subscribers;
#line 350 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp12__length1 = self->priv->subscribers_length1;
#line 350 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp13_ = ctr;
#line 350 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_g_object_unref0 (_tmp12_[_tmp13_]);
#line 350 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp12_[_tmp13_] = NULL;
#line 350 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp14_ = _tmp12_[_tmp13_];
#line 352 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp15_ = view;
#line 352 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					data_view_notify_unsubscribed (_tmp15_, self);
#line 348 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_g_object_unref0 (view);
#line 2466 "DataSource.c"
				}
			}
		}
	}
#line 357 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_emit (self, data_source_signals[DATA_SOURCE_DESTROYED_SIGNAL], 0);
#line 2473 "DataSource.c"
}


void
data_source_destroy (DataSource* self)
{
#line 340 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 340 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	DATA_SOURCE_GET_CLASS (self)->destroy (self);
#line 2484 "DataSource.c"
}


gboolean
data_source_destroy_orphan (DataSource* self,
                            gboolean delete_backing)
{
	gboolean result = FALSE;
	gboolean ret = FALSE;
	SourceCollection* _tmp9_;
	GError * _inner_error_ = NULL;
#line 366 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (self), FALSE);
#line 367 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	ret = TRUE;
#line 368 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (delete_backing) {
#line 2502 "DataSource.c"
		{
			gboolean _tmp0_ = FALSE;
			gboolean _tmp1_;
#line 370 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp0_ = data_source_internal_delete_backing (self, &_inner_error_);
#line 370 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2510 "DataSource.c"
				goto __catch54_g_error;
			}
#line 370 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			ret = _tmp0_;
#line 371 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp1_ = ret;
#line 371 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			if (!_tmp1_) {
#line 2519 "DataSource.c"
				gchar* _tmp2_;
				gchar* _tmp3_;
#line 372 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp2_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 372 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp3_ = _tmp2_;
#line 372 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				g_warning ("DataSource.vala:372: Unable to delete backing for %s", _tmp3_);
#line 372 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_g_free0 (_tmp3_);
#line 2530 "DataSource.c"
			}
		}
		goto __finally54;
		__catch54_g_error:
		{
			GError* err = NULL;
			gchar* _tmp4_;
			gchar* _tmp5_;
			GError* _tmp6_;
			const gchar* _tmp7_;
#line 369 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			err = _inner_error_;
#line 369 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_inner_error_ = NULL;
#line 375 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp4_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 375 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp5_ = _tmp4_;
#line 375 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp6_ = err;
#line 375 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp7_ = _tmp6_->message;
#line 375 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			g_warning ("DataSource.vala:375: Unable to delete backing for %s: %s", _tmp5_, _tmp7_);
#line 375 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_g_free0 (_tmp5_);
#line 376 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			ret = FALSE;
#line 369 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_g_error_free0 (err);
#line 2561 "DataSource.c"
		}
		__finally54:
#line 369 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2566 "DataSource.c"
			gboolean _tmp8_ = FALSE;
#line 369 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 369 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			g_clear_error (&_inner_error_);
#line 369 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			return _tmp8_;
#line 2574 "DataSource.c"
		}
	}
#line 380 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	data_source_internal_mark_for_destroy (self);
#line 381 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	data_source_destroy (self);
#line 383 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp9_ = self->priv->unlinked_from_collection;
#line 383 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp9_ != NULL) {
#line 2585 "DataSource.c"
		SourceCollection* _tmp10_;
#line 384 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp10_ = self->priv->unlinked_from_collection;
#line 384 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_collection_notify_unlinked_destroyed (_tmp10_, self);
#line 2591 "DataSource.c"
	}
#line 386 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = ret;
#line 386 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 2597 "DataSource.c"
}


static void
_vala_array_add66 (DataView** * array,
                   int* length,
                   int* size,
                   DataView* value)
{
#line 406 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if ((*length) == (*size)) {
#line 406 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 406 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		*array = g_renew (DataView*, *array, (*size) + 1);
#line 2613 "DataSource.c"
	}
#line 406 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	(*array)[(*length)++] = value;
#line 406 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	(*array)[*length] = NULL;
#line 2619 "DataSource.c"
}


void
data_source_internal_subscribe (DataSource* self,
                                DataView* view)
{
	gboolean _tmp0_;
	DataView** _tmp12_;
	gint _tmp12__length1;
	DataView* _tmp13_;
#line 395 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 395 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_VIEW (view));
#line 396 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->in_contact;
#line 396 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (!_tmp0_, "!in_contact");
#line 2639 "DataSource.c"
	{
		gint ctr = 0;
#line 398 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		ctr = 0;
#line 2644 "DataSource.c"
		{
			gboolean _tmp1_ = FALSE;
#line 398 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp1_ = TRUE;
#line 398 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			while (TRUE) {
#line 2651 "DataSource.c"
				gint _tmp3_;
				DataView** _tmp4_;
				gint _tmp4__length1;
				DataView** _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				DataView* _tmp7_;
#line 398 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (!_tmp1_) {
#line 2661 "DataSource.c"
					gint _tmp2_;
#line 398 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp2_ = ctr;
#line 398 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					ctr = _tmp2_ + 1;
#line 2667 "DataSource.c"
				}
#line 398 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp1_ = FALSE;
#line 398 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp3_ = ctr;
#line 398 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp4_ = self->priv->subscribers;
#line 398 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp4__length1 = self->priv->subscribers_length1;
#line 398 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (!(_tmp3_ < _tmp4__length1)) {
#line 398 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					break;
#line 2681 "DataSource.c"
				}
#line 399 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp5_ = self->priv->subscribers;
#line 399 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp5__length1 = self->priv->subscribers_length1;
#line 399 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp6_ = ctr;
#line 399 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp7_ = _tmp5_[_tmp6_];
#line 399 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (_tmp7_ == NULL) {
#line 2693 "DataSource.c"
					DataView** _tmp8_;
					gint _tmp8__length1;
					gint _tmp9_;
					DataView* _tmp10_;
					DataView* _tmp11_;
#line 400 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp8_ = self->priv->subscribers;
#line 400 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp8__length1 = self->priv->subscribers_length1;
#line 400 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp9_ = ctr;
#line 400 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp10_ = _g_object_ref0 (view);
#line 400 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_g_object_unref0 (_tmp8_[_tmp9_]);
#line 400 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp8_[_tmp9_] = _tmp10_;
#line 400 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp11_ = _tmp8_[_tmp9_];
#line 402 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					return;
#line 2715 "DataSource.c"
				}
			}
		}
	}
#line 406 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp12_ = self->priv->subscribers;
#line 406 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp12__length1 = self->priv->subscribers_length1;
#line 406 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp13_ = _g_object_ref0 (view);
#line 406 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_array_add66 (&self->priv->subscribers, &self->priv->subscribers_length1, &self->priv->_subscribers_size_, _tmp13_);
#line 2728 "DataSource.c"
}


void
data_source_internal_unsubscribe (DataSource* self,
                                  DataView* view)
{
	gboolean _tmp0_;
#line 411 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 411 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_VIEW (view));
#line 412 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->in_contact;
#line 412 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (!_tmp0_, "!in_contact");
#line 2745 "DataSource.c"
	{
		gint ctr = 0;
#line 414 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		ctr = 0;
#line 2750 "DataSource.c"
		{
			gboolean _tmp1_ = FALSE;
#line 414 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp1_ = TRUE;
#line 414 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			while (TRUE) {
#line 2757 "DataSource.c"
				gint _tmp3_;
				DataView** _tmp4_;
				gint _tmp4__length1;
				DataView** _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				DataView* _tmp7_;
#line 414 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (!_tmp1_) {
#line 2767 "DataSource.c"
					gint _tmp2_;
#line 414 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp2_ = ctr;
#line 414 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					ctr = _tmp2_ + 1;
#line 2773 "DataSource.c"
				}
#line 414 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp1_ = FALSE;
#line 414 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp3_ = ctr;
#line 414 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp4_ = self->priv->subscribers;
#line 414 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp4__length1 = self->priv->subscribers_length1;
#line 414 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (!(_tmp3_ < _tmp4__length1)) {
#line 414 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					break;
#line 2787 "DataSource.c"
				}
#line 415 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp5_ = self->priv->subscribers;
#line 415 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp5__length1 = self->priv->subscribers_length1;
#line 415 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp6_ = ctr;
#line 415 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp7_ = _tmp5_[_tmp6_];
#line 415 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (_tmp7_ == view) {
#line 2799 "DataSource.c"
					DataView** _tmp8_;
					gint _tmp8__length1;
					gint _tmp9_;
					DataView* _tmp10_;
#line 416 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp8_ = self->priv->subscribers;
#line 416 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp8__length1 = self->priv->subscribers_length1;
#line 416 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp9_ = ctr;
#line 416 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_g_object_unref0 (_tmp8_[_tmp9_]);
#line 416 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp8_[_tmp9_] = NULL;
#line 416 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp10_ = _tmp8_[_tmp9_];
#line 418 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					return;
#line 2818 "DataSource.c"
				}
			}
		}
	}
}


void
data_source_contact_subscribers (DataSource* self,
                                 DataSourceContactSubscriber contact_subscriber,
                                 void* contact_subscriber_target)
{
	gboolean _tmp0_;
#line 423 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 424 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->in_contact;
#line 424 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (!_tmp0_, "!in_contact");
#line 426 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->in_contact = TRUE;
#line 2840 "DataSource.c"
	{
		gint ctr = 0;
#line 427 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		ctr = 0;
#line 2845 "DataSource.c"
		{
			gboolean _tmp1_ = FALSE;
#line 427 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp1_ = TRUE;
#line 427 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			while (TRUE) {
#line 2852 "DataSource.c"
				gint _tmp3_;
				DataView** _tmp4_;
				gint _tmp4__length1;
				DataView** _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				DataView* _tmp7_;
#line 427 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (!_tmp1_) {
#line 2862 "DataSource.c"
					gint _tmp2_;
#line 427 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp2_ = ctr;
#line 427 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					ctr = _tmp2_ + 1;
#line 2868 "DataSource.c"
				}
#line 427 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp1_ = FALSE;
#line 427 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp3_ = ctr;
#line 427 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp4_ = self->priv->subscribers;
#line 427 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp4__length1 = self->priv->subscribers_length1;
#line 427 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (!(_tmp3_ < _tmp4__length1)) {
#line 427 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					break;
#line 2882 "DataSource.c"
				}
#line 428 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp5_ = self->priv->subscribers;
#line 428 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp5__length1 = self->priv->subscribers_length1;
#line 428 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp6_ = ctr;
#line 428 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp7_ = _tmp5_[_tmp6_];
#line 428 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (_tmp7_ != NULL) {
#line 2894 "DataSource.c"
					DataView** _tmp8_;
					gint _tmp8__length1;
					gint _tmp9_;
					DataView* _tmp10_;
#line 429 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp8_ = self->priv->subscribers;
#line 429 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp8__length1 = self->priv->subscribers_length1;
#line 429 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp9_ = ctr;
#line 429 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp10_ = _tmp8_[_tmp9_];
#line 429 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					contact_subscriber (_tmp10_, contact_subscriber_target);
#line 2909 "DataSource.c"
				}
			}
		}
	}
#line 431 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->in_contact = FALSE;
#line 2916 "DataSource.c"
}


void
data_source_contact_subscribers_alteration (DataSource* self,
                                            Alteration* alteration)
{
	gboolean _tmp0_;
#line 434 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 434 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_ALTERATION (alteration));
#line 435 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->in_contact;
#line 435 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (!_tmp0_, "!in_contact");
#line 437 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->in_contact = TRUE;
#line 2935 "DataSource.c"
	{
		gint ctr = 0;
#line 438 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		ctr = 0;
#line 2940 "DataSource.c"
		{
			gboolean _tmp1_ = FALSE;
#line 438 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp1_ = TRUE;
#line 438 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			while (TRUE) {
#line 2947 "DataSource.c"
				gint _tmp3_;
				DataView** _tmp4_;
				gint _tmp4__length1;
				DataView** _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				DataView* _tmp7_;
#line 438 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (!_tmp1_) {
#line 2957 "DataSource.c"
					gint _tmp2_;
#line 438 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp2_ = ctr;
#line 438 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					ctr = _tmp2_ + 1;
#line 2963 "DataSource.c"
				}
#line 438 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp1_ = FALSE;
#line 438 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp3_ = ctr;
#line 438 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp4_ = self->priv->subscribers;
#line 438 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp4__length1 = self->priv->subscribers_length1;
#line 438 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (!(_tmp3_ < _tmp4__length1)) {
#line 438 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					break;
#line 2977 "DataSource.c"
				}
#line 439 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp5_ = self->priv->subscribers;
#line 439 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp5__length1 = self->priv->subscribers_length1;
#line 439 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp6_ = ctr;
#line 439 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp7_ = _tmp5_[_tmp6_];
#line 439 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (_tmp7_ != NULL) {
#line 2989 "DataSource.c"
					DataView** _tmp8_;
					gint _tmp8__length1;
					gint _tmp9_;
					DataView* _tmp10_;
#line 440 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp8_ = self->priv->subscribers;
#line 440 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp8__length1 = self->priv->subscribers_length1;
#line 440 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp9_ = ctr;
#line 440 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp10_ = _tmp8_[_tmp9_];
#line 440 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_OBJECT, DataObject), alteration);
#line 3004 "DataSource.c"
				}
			}
		}
	}
#line 442 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->in_contact = FALSE;
#line 3011 "DataSource.c"
}


static void
data_source_real_unlinked (DataSource* self,
                           SourceCollection* sources)
{
#line 51 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (sources));
#line 3021 "DataSource.c"
}


static void
g_cclosure_user_marshal_VOID__DATA_COLLECTION (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__DATA_COLLECTION) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__DATA_COLLECTION callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (n_param_values == 2);
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		data1 = closure->data;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		data2 = param_values->data[0].v_pointer;
#line 3047 "DataSource.c"
	} else {
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		data1 = param_values->data[0].v_pointer;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		data2 = closure->data;
#line 3053 "DataSource.c"
	}
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	callback = (GMarshalFunc_VOID__DATA_COLLECTION) (marshal_data ? marshal_data : cc->callback);
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	callback (data1, value_get_data_collection (param_values + 1), data2);
#line 3059 "DataSource.c"
}


static void
data_source_real_relinked (DataSource* self,
                           SourceCollection* sources)
{
#line 55 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (sources));
#line 3069 "DataSource.c"
}


static void
data_source_real_destroyed (DataSource* self)
{
}


static void
data_source_class_init (DataSourceClass * klass)
{
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	data_source_parent_class = g_type_class_peek_parent (klass);
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_type_class_add_private (klass, sizeof (DataSourcePrivate));
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataObjectClass *) klass)->notify_membership_changed = (void (*) (DataObject *, DataCollection*)) data_source_real_notify_membership_changed;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->notify_held_in_tank = (void (*) (DataSource *, SourceHoldingTank*)) data_source_real_notify_held_in_tank;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataObjectClass *) klass)->notify_altered = (void (*) (DataObject *, Alteration*)) data_source_real_notify_altered;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->notify_unlinking = (void (*) (DataSource *, SourceCollection*)) data_source_real_notify_unlinking;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->notify_unlinked = (void (*) (DataSource *)) data_source_real_notify_unlinked;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->notify_relinking = (void (*) (DataSource *, SourceCollection*)) data_source_real_notify_relinking;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->notify_relinked = (void (*) (DataSource *)) data_source_real_notify_relinked;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->get_typename = (gchar* (*) (DataSource *)) data_source_real_get_typename;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->get_instance_id = (gint64 (*) (DataSource *)) data_source_real_get_instance_id;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->get_source_id = (gchar* (*) (DataSource *)) data_source_real_get_source_id;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->commit_backlinks = (void (*) (DataSource *, SourceCollection*, const gchar*)) data_source_real_commit_backlinks;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->save_snapshot = (SourceSnapshot* (*) (DataSource *)) data_source_real_save_snapshot;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->internal_delete_backing = (gboolean (*) (DataSource *, GError**)) data_source_real_internal_delete_backing;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->equals = (gboolean (*) (DataSource *, DataSource*)) data_source_real_equals;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->destroy = (void (*) (DataSource *)) data_source_real_destroy;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->unlinked = data_source_real_unlinked;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->relinked = data_source_real_relinked;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->destroyed = data_source_real_destroyed;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	G_OBJECT_CLASS (klass)->finalize = data_source_finalize;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	data_source_signals[DATA_SOURCE_UNLINKED_SIGNAL] = g_signal_new ("unlinked", TYPE_DATA_SOURCE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataSourceClass, unlinked), NULL, NULL, g_cclosure_user_marshal_VOID__DATA_COLLECTION, G_TYPE_NONE, 1, TYPE_SOURCE_COLLECTION);
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	data_source_signals[DATA_SOURCE_RELINKED_SIGNAL] = g_signal_new ("relinked", TYPE_DATA_SOURCE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataSourceClass, relinked), NULL, NULL, g_cclosure_user_marshal_VOID__DATA_COLLECTION, G_TYPE_NONE, 1, TYPE_SOURCE_COLLECTION);
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	data_source_signals[DATA_SOURCE_DESTROYED_SIGNAL] = g_signal_new ("destroyed", TYPE_DATA_SOURCE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataSourceClass, destroyed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 3130 "DataSource.c"
}


static void
data_source_instance_init (DataSource * self)
{
	DataView** _tmp0_;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv = DATA_SOURCE_GET_PRIVATE (self);
#line 42 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = g_new0 (DataView*, 4 + 1);
#line 42 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->subscribers = _tmp0_;
#line 42 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->subscribers_length1 = 4;
#line 42 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->_subscribers_size_ = self->priv->subscribers_length1;
#line 43 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->holding_tank = NULL;
#line 44 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->unlinked_from_collection = NULL;
#line 45 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->backlinks = NULL;
#line 46 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->in_contact = FALSE;
#line 47 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->marked_for_destroy = FALSE;
#line 48 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->is_destroyed = FALSE;
#line 3160 "DataSource.c"
}


static void
data_source_finalize (GObject * obj)
{
	DataSource * self;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DATA_SOURCE, DataSource);
#line 42 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->subscribers = (_vala_array_free (self->priv->subscribers, self->priv->subscribers_length1, (GDestroyNotify) g_object_unref), NULL);
#line 43 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_source_holding_tank_unref0 (self->priv->holding_tank);
#line 45 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_object_unref0 (self->priv->backlinks);
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	G_OBJECT_CLASS (data_source_parent_class)->finalize (obj);
#line 3178 "DataSource.c"
}


GType
data_source_get_type (void)
{
	static volatile gsize data_source_type_id__volatile = 0;
	if (g_once_init_enter (&data_source_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DataSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) data_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DataSource), 0, (GInstanceInitFunc) data_source_instance_init, NULL };
		GType data_source_type_id;
		data_source_type_id = g_type_register_static (TYPE_DATA_OBJECT, "DataSource", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&data_source_type_id__volatile, data_source_type_id);
	}
	return data_source_type_id__volatile;
}


static void
source_snapshot_real_notify_broken (SourceSnapshot* self)
{
#line 455 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->snapshot_broken = TRUE;
#line 457 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_emit (self, source_snapshot_signals[SOURCE_SNAPSHOT_BROKEN_SIGNAL], 0);
#line 3203 "DataSource.c"
}


void
source_snapshot_notify_broken (SourceSnapshot* self)
{
#line 454 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_SNAPSHOT (self));
#line 454 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	SOURCE_SNAPSHOT_GET_CLASS (self)->notify_broken (self);
#line 3214 "DataSource.c"
}


gboolean
source_snapshot_is_broken (SourceSnapshot* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 460 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_SOURCE_SNAPSHOT (self), FALSE);
#line 461 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->snapshot_broken;
#line 461 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp0_;
#line 461 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 3231 "DataSource.c"
}


SourceSnapshot*
source_snapshot_construct (GType object_type)
{
	SourceSnapshot* self = NULL;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self = (SourceSnapshot*) g_type_create_instance (object_type);
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return self;
#line 3243 "DataSource.c"
}


static void
source_snapshot_real_broken (SourceSnapshot* self)
{
}


static void
value_source_snapshot_init (GValue* value)
{
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	value->data[0].v_pointer = NULL;
#line 3258 "DataSource.c"
}


static void
value_source_snapshot_free_value (GValue* value)
{
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (value->data[0].v_pointer) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_snapshot_unref (value->data[0].v_pointer);
#line 3269 "DataSource.c"
	}
}


static void
value_source_snapshot_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (src_value->data[0].v_pointer) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		dest_value->data[0].v_pointer = source_snapshot_ref (src_value->data[0].v_pointer);
#line 3282 "DataSource.c"
	} else {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3286 "DataSource.c"
	}
}


static gpointer
value_source_snapshot_peek_pointer (const GValue* value)
{
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return value->data[0].v_pointer;
#line 3296 "DataSource.c"
}


static gchar*
value_source_snapshot_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (collect_values[0].v_pointer) {
#line 3308 "DataSource.c"
		SourceSnapshot * object;
		object = collect_values[0].v_pointer;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		if (object->parent_instance.g_class == NULL) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3315 "DataSource.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3319 "DataSource.c"
		}
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = source_snapshot_ref (object);
#line 3323 "DataSource.c"
	} else {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = NULL;
#line 3327 "DataSource.c"
	}
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return NULL;
#line 3331 "DataSource.c"
}


static gchar*
value_source_snapshot_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	SourceSnapshot ** object_p;
	object_p = collect_values[0].v_pointer;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (!object_p) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3347 "DataSource.c"
	}
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (!value->data[0].v_pointer) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		*object_p = NULL;
#line 3353 "DataSource.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		*object_p = value->data[0].v_pointer;
#line 3357 "DataSource.c"
	} else {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		*object_p = source_snapshot_ref (value->data[0].v_pointer);
#line 3361 "DataSource.c"
	}
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return NULL;
#line 3365 "DataSource.c"
}


GParamSpec*
param_spec_source_snapshot (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	ParamSpecSourceSnapshot* spec;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SOURCE_SNAPSHOT), NULL);
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return G_PARAM_SPEC (spec);
#line 3385 "DataSource.c"
}


gpointer
value_get_source_snapshot (const GValue* value)
{
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_SNAPSHOT), NULL);
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return value->data[0].v_pointer;
#line 3396 "DataSource.c"
}


void
value_set_source_snapshot (GValue* value,
                           gpointer v_object)
{
	SourceSnapshot * old;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_SNAPSHOT));
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	old = value->data[0].v_pointer;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (v_object) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SOURCE_SNAPSHOT));
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = v_object;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_snapshot_ref (value->data[0].v_pointer);
#line 3419 "DataSource.c"
	} else {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = NULL;
#line 3423 "DataSource.c"
	}
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (old) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_snapshot_unref (old);
#line 3429 "DataSource.c"
	}
}


void
value_take_source_snapshot (GValue* value,
                            gpointer v_object)
{
	SourceSnapshot * old;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_SNAPSHOT));
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	old = value->data[0].v_pointer;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (v_object) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SOURCE_SNAPSHOT));
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = v_object;
#line 3451 "DataSource.c"
	} else {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = NULL;
#line 3455 "DataSource.c"
	}
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (old) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_snapshot_unref (old);
#line 3461 "DataSource.c"
	}
}


static void
source_snapshot_class_init (SourceSnapshotClass * klass)
{
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_snapshot_parent_class = g_type_class_peek_parent (klass);
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((SourceSnapshotClass *) klass)->finalize = source_snapshot_finalize;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_type_class_add_private (klass, sizeof (SourceSnapshotPrivate));
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((SourceSnapshotClass *) klass)->notify_broken = (void (*) (SourceSnapshot *)) source_snapshot_real_notify_broken;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((SourceSnapshotClass *) klass)->broken = source_snapshot_real_broken;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_snapshot_signals[SOURCE_SNAPSHOT_BROKEN_SIGNAL] = g_signal_new ("broken", TYPE_SOURCE_SNAPSHOT, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceSnapshotClass, broken), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 3481 "DataSource.c"
}


static void
source_snapshot_instance_init (SourceSnapshot * self)
{
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv = SOURCE_SNAPSHOT_GET_PRIVATE (self);
#line 447 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->snapshot_broken = FALSE;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->ref_count = 1;
#line 3494 "DataSource.c"
}


static void
source_snapshot_finalize (SourceSnapshot * obj)
{
	SourceSnapshot * self;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOURCE_SNAPSHOT, SourceSnapshot);
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_handlers_destroy (self);
#line 3506 "DataSource.c"
}


GType
source_snapshot_get_type (void)
{
	static volatile gsize source_snapshot_type_id__volatile = 0;
	if (g_once_init_enter (&source_snapshot_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_source_snapshot_init, value_source_snapshot_free_value, value_source_snapshot_copy_value, value_source_snapshot_peek_pointer, "p", value_source_snapshot_collect_value, "p", value_source_snapshot_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SourceSnapshotClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) source_snapshot_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SourceSnapshot), 0, (GInstanceInitFunc) source_snapshot_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType source_snapshot_type_id;
		source_snapshot_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SourceSnapshot", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&source_snapshot_type_id__volatile, source_snapshot_type_id);
	}
	return source_snapshot_type_id__volatile;
}


gpointer
source_snapshot_ref (gpointer instance)
{
	SourceSnapshot * self;
	self = instance;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_atomic_int_inc (&self->ref_count);
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return instance;
#line 3535 "DataSource.c"
}


void
source_snapshot_unref (gpointer instance)
{
	SourceSnapshot * self;
	self = instance;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		SOURCE_SNAPSHOT_GET_CLASS (self)->finalize (self);
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3550 "DataSource.c"
	}
}


static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
#line 1248 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1249 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1249 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1250 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1250 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1251 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _result_;
#line 1251 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 3576 "DataSource.c"
}


SourceBacklink*
source_backlink_construct (GType object_type,
                           const gchar* name,
                           const gchar* value)
{
	SourceBacklink* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 498 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 498 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (value != NULL, NULL);
#line 498 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self = (SourceBacklink*) g_type_create_instance (object_type);
#line 499 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (source_backlink_validate_name_value (name, value), "validate_name_value(name, value)");
#line 501 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = string_strip (name);
#line 501 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_free0 (self->priv->_name);
#line 501 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->_name = _tmp0_;
#line 502 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = string_strip (value);
#line 502 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_free0 (self->priv->_value);
#line 502 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->_value = _tmp1_;
#line 498 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return self;
#line 3610 "DataSource.c"
}


SourceBacklink*
source_backlink_new (const gchar* name,
                     const gchar* value)
{
#line 498 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return source_backlink_construct (TYPE_SOURCE_BACKLINK, name, value);
#line 3620 "DataSource.c"
}


SourceBacklink*
source_backlink_construct_from_source (GType object_type,
                                       DataSource* source)
{
	SourceBacklink* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
#line 505 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), NULL);
#line 505 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self = (SourceBacklink*) g_type_create_instance (object_type);
#line 506 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = data_source_get_typename (source);
#line 506 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = _tmp0_;
#line 506 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = string_strip (_tmp1_);
#line 506 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_free0 (self->priv->_name);
#line 506 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->_name = _tmp2_;
#line 506 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_free0 (_tmp1_);
#line 507 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = g_strdup_printf ("%" G_GINT64_FORMAT, data_source_get_instance_id (source));
#line 507 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp4_ = _tmp3_;
#line 507 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp5_ = string_strip (_tmp4_);
#line 507 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_free0 (self->priv->_value);
#line 507 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->_value = _tmp5_;
#line 507 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_free0 (_tmp4_);
#line 509 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp6_ = self->priv->_name;
#line 509 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp7_ = self->priv->_value;
#line 509 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (source_backlink_validate_name_value (_tmp6_, _tmp7_), "validate_name_value(_name, _value)");
#line 505 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return self;
#line 3673 "DataSource.c"
}


SourceBacklink*
source_backlink_new_from_source (DataSource* source)
{
#line 505 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return source_backlink_construct_from_source (TYPE_SOURCE_BACKLINK, source);
#line 3682 "DataSource.c"
}


static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
#line 1417 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1417 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1418 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1418 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1418 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 3702 "DataSource.c"
}


static gboolean
source_backlink_validate_name_value (const gchar* name,
                                     const gchar* value)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 512 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 512 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (value != NULL, FALSE);
#line 513 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (!string_contains (name, "=")) {
#line 513 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp1_ = !string_contains (name, "|");
#line 3721 "DataSource.c"
	} else {
#line 513 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp1_ = FALSE;
#line 3725 "DataSource.c"
	}
#line 513 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp1_) {
#line 513 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = !string_contains (value, "|");
#line 3731 "DataSource.c"
	} else {
#line 513 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = FALSE;
#line 3735 "DataSource.c"
	}
#line 513 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp0_;
#line 513 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 3741 "DataSource.c"
}


gchar*
source_backlink_to_string (SourceBacklink* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
#line 516 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_SOURCE_BACKLINK (self), NULL);
#line 517 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = source_backlink_get_name (self);
#line 517 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = _tmp0_;
#line 517 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = source_backlink_get_value (self);
#line 517 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = _tmp2_;
#line 517 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp4_ = g_strdup_printf ("Backlink %s=%s", _tmp1_, _tmp3_);
#line 517 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp4_;
#line 517 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 3770 "DataSource.c"
}


guint
source_backlink_hash_func (SourceBacklink* backlink)
{
	guint result = 0U;
	GHashFunc _tmp0_;
	const gchar* _tmp1_;
	GHashFunc _tmp2_;
	const gchar* _tmp3_;
#line 520 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail ((backlink == NULL) || IS_SOURCE_BACKLINK (backlink), 0U);
#line 521 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = g_str_hash;
#line 521 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = backlink->priv->_name;
#line 521 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = g_str_hash;
#line 521 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = backlink->priv->_value;
#line 521 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp0_ (_tmp1_) ^ _tmp2_ (_tmp3_);
#line 521 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 3796 "DataSource.c"
}


gboolean
source_backlink_equal_func (SourceBacklink* alink,
                            SourceBacklink* blink)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GEqualFunc _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
#line 524 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail ((alink == NULL) || IS_SOURCE_BACKLINK (alink), FALSE);
#line 524 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail ((blink == NULL) || IS_SOURCE_BACKLINK (blink), FALSE);
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = g_str_equal;
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = alink->priv->_name;
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = blink->priv->_name;
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp1_ (_tmp2_, _tmp3_)) {
#line 3821 "DataSource.c"
		GEqualFunc _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp4_ = g_str_equal;
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp5_ = alink->priv->_value;
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp6_ = blink->priv->_value;
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = _tmp4_ (_tmp5_, _tmp6_);
#line 3833 "DataSource.c"
	} else {
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = FALSE;
#line 3837 "DataSource.c"
	}
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp0_;
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 3843 "DataSource.c"
}


const gchar*
source_backlink_get_name (SourceBacklink* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 473 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_SOURCE_BACKLINK (self), NULL);
#line 474 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->_name;
#line 474 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp0_;
#line 474 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 3860 "DataSource.c"
}


const gchar*
source_backlink_get_value (SourceBacklink* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 479 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_SOURCE_BACKLINK (self), NULL);
#line 480 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->_value;
#line 480 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp0_;
#line 480 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 3877 "DataSource.c"
}


const gchar*
source_backlink_get_typename (SourceBacklink* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 486 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_SOURCE_BACKLINK (self), NULL);
#line 487 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->_name;
#line 487 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp0_;
#line 487 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 3894 "DataSource.c"
}


static gint64
int64_parse (const gchar* str)
{
	gint64 result = 0LL;
	gint64 _tmp0_;
#line 687 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0LL);
#line 688 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = g_ascii_strtoll (str, NULL, (guint) 0);
#line 688 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp0_;
#line 688 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 3911 "DataSource.c"
}


gint64
source_backlink_get_instance_id (SourceBacklink* self)
{
	gint64 result;
	const gchar* _tmp0_;
#line 493 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_SOURCE_BACKLINK (self), 0LL);
#line 494 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->_value;
#line 494 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = int64_parse (_tmp0_);
#line 494 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 3928 "DataSource.c"
}


static void
value_source_backlink_init (GValue* value)
{
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	value->data[0].v_pointer = NULL;
#line 3937 "DataSource.c"
}


static void
value_source_backlink_free_value (GValue* value)
{
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (value->data[0].v_pointer) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_backlink_unref (value->data[0].v_pointer);
#line 3948 "DataSource.c"
	}
}


static void
value_source_backlink_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (src_value->data[0].v_pointer) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		dest_value->data[0].v_pointer = source_backlink_ref (src_value->data[0].v_pointer);
#line 3961 "DataSource.c"
	} else {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3965 "DataSource.c"
	}
}


static gpointer
value_source_backlink_peek_pointer (const GValue* value)
{
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return value->data[0].v_pointer;
#line 3975 "DataSource.c"
}


static gchar*
value_source_backlink_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (collect_values[0].v_pointer) {
#line 3987 "DataSource.c"
		SourceBacklink * object;
		object = collect_values[0].v_pointer;
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		if (object->parent_instance.g_class == NULL) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3994 "DataSource.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3998 "DataSource.c"
		}
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = source_backlink_ref (object);
#line 4002 "DataSource.c"
	} else {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = NULL;
#line 4006 "DataSource.c"
	}
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return NULL;
#line 4010 "DataSource.c"
}


static gchar*
value_source_backlink_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	SourceBacklink ** object_p;
	object_p = collect_values[0].v_pointer;
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (!object_p) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4026 "DataSource.c"
	}
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (!value->data[0].v_pointer) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		*object_p = NULL;
#line 4032 "DataSource.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		*object_p = value->data[0].v_pointer;
#line 4036 "DataSource.c"
	} else {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		*object_p = source_backlink_ref (value->data[0].v_pointer);
#line 4040 "DataSource.c"
	}
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return NULL;
#line 4044 "DataSource.c"
}


GParamSpec*
param_spec_source_backlink (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	ParamSpecSourceBacklink* spec;
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SOURCE_BACKLINK), NULL);
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return G_PARAM_SPEC (spec);
#line 4064 "DataSource.c"
}


gpointer
value_get_source_backlink (const GValue* value)
{
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_BACKLINK), NULL);
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return value->data[0].v_pointer;
#line 4075 "DataSource.c"
}


void
value_set_source_backlink (GValue* value,
                           gpointer v_object)
{
	SourceBacklink * old;
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_BACKLINK));
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	old = value->data[0].v_pointer;
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (v_object) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SOURCE_BACKLINK));
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = v_object;
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_backlink_ref (value->data[0].v_pointer);
#line 4098 "DataSource.c"
	} else {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = NULL;
#line 4102 "DataSource.c"
	}
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (old) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_backlink_unref (old);
#line 4108 "DataSource.c"
	}
}


void
value_take_source_backlink (GValue* value,
                            gpointer v_object)
{
	SourceBacklink * old;
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_BACKLINK));
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	old = value->data[0].v_pointer;
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (v_object) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SOURCE_BACKLINK));
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = v_object;
#line 4130 "DataSource.c"
	} else {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = NULL;
#line 4134 "DataSource.c"
	}
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (old) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_backlink_unref (old);
#line 4140 "DataSource.c"
	}
}


static void
source_backlink_class_init (SourceBacklinkClass * klass)
{
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_backlink_parent_class = g_type_class_peek_parent (klass);
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((SourceBacklinkClass *) klass)->finalize = source_backlink_finalize;
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_type_class_add_private (klass, sizeof (SourceBacklinkPrivate));
#line 4154 "DataSource.c"
}


static void
source_backlink_instance_init (SourceBacklink * self)
{
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv = SOURCE_BACKLINK_GET_PRIVATE (self);
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->ref_count = 1;
#line 4165 "DataSource.c"
}


static void
source_backlink_finalize (SourceBacklink * obj)
{
	SourceBacklink * self;
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOURCE_BACKLINK, SourceBacklink);
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_handlers_destroy (self);
#line 469 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_free0 (self->priv->_name);
#line 470 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_free0 (self->priv->_value);
#line 4181 "DataSource.c"
}


GType
source_backlink_get_type (void)
{
	static volatile gsize source_backlink_type_id__volatile = 0;
	if (g_once_init_enter (&source_backlink_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_source_backlink_init, value_source_backlink_free_value, value_source_backlink_copy_value, value_source_backlink_peek_pointer, "p", value_source_backlink_collect_value, "p", value_source_backlink_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SourceBacklinkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) source_backlink_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SourceBacklink), 0, (GInstanceInitFunc) source_backlink_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType source_backlink_type_id;
		source_backlink_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SourceBacklink", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&source_backlink_type_id__volatile, source_backlink_type_id);
	}
	return source_backlink_type_id__volatile;
}


gpointer
source_backlink_ref (gpointer instance)
{
	SourceBacklink * self;
	self = instance;
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_atomic_int_inc (&self->ref_count);
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return instance;
#line 4210 "DataSource.c"
}


void
source_backlink_unref (gpointer instance)
{
	SourceBacklink * self;
	self = instance;
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		SOURCE_BACKLINK_GET_CLASS (self)->finalize (self);
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4225 "DataSource.c"
	}
}


static void
_source_proxy_on_source_added_data_collection_items_added (DataCollection* _sender,
                                                           GeeIterable* added,
                                                           gpointer self)
{
#line 588 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_proxy_on_source_added ((SourceProxy*) self, added);
#line 4237 "DataSource.c"
}


static void
_source_proxy_on_snapshot_broken_source_snapshot_broken (SourceSnapshot* _sender,
                                                         gpointer self)
{
#line 577 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_proxy_on_snapshot_broken ((SourceProxy*) self);
#line 4247 "DataSource.c"
}


SourceProxy*
source_proxy_construct (GType object_type,
                        DataSource* source)
{
	SourceProxy* self = NULL;
	gchar* _tmp0_;
	SourceSnapshot* _tmp1_;
	SourceSnapshot* _tmp2_;
	SourceSnapshot* _tmp3_;
	DataCollection* _tmp4_;
	SourceCollection* _tmp5_;
	SourceCollection* _tmp6_;
#line 571 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), NULL);
#line 571 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self = (SourceProxy*) g_type_create_instance (object_type);
#line 572 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->object_id = data_object_get_object_id (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_OBJECT, DataObject));
#line 573 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_OBJECT, DataObject));
#line 573 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_free0 (self->priv->source_string);
#line 573 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->source_string = _tmp0_;
#line 575 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = data_source_save_snapshot (source);
#line 575 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_source_snapshot_unref0 (self->priv->snapshot);
#line 575 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->snapshot = _tmp1_;
#line 576 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = self->priv->snapshot;
#line 576 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (_tmp2_ != NULL, "snapshot != null");
#line 577 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = self->priv->snapshot;
#line 577 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_connect (_tmp3_, "broken", (GCallback) _source_proxy_on_snapshot_broken_source_snapshot_broken, self);
#line 579 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_proxy_set_source (self, source);
#line 581 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp4_ = data_object_get_membership (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_OBJECT, DataObject));
#line 581 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_data_collection_unref0 (self->priv->membership);
#line 581 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->membership = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_SOURCE_COLLECTION, SourceCollection);
#line 582 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp5_ = self->priv->membership;
#line 582 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (_tmp5_ != NULL, "membership != null");
#line 583 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp6_ = self->priv->membership;
#line 583 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DATA_COLLECTION, DataCollection), "items-added", (GCallback) _source_proxy_on_source_added_data_collection_items_added, self);
#line 571 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return self;
#line 4307 "DataSource.c"
}


static DataSource*
source_proxy_real_reconstitute (SourceProxy* self,
                                gint64 object_id,
                                SourceSnapshot* snapshot)
{
#line 591 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_critical ("Type `%s' does not implement abstract method `source_proxy_reconstitute'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 591 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return NULL;
#line 4320 "DataSource.c"
}


DataSource*
source_proxy_reconstitute (SourceProxy* self,
                           gint64 object_id,
                           SourceSnapshot* snapshot)
{
#line 591 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_SOURCE_PROXY (self), NULL);
#line 591 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return SOURCE_PROXY_GET_CLASS (self)->reconstitute (self, object_id, snapshot);
#line 4333 "DataSource.c"
}


static void
source_proxy_real_notify_reconstituted (SourceProxy* self,
                                        DataSource* source)
{
#line 593 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 594 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_emit (self, source_proxy_signals[SOURCE_PROXY_RECONSTITUTED_SIGNAL], 0, source);
#line 4345 "DataSource.c"
}


void
source_proxy_notify_reconstituted (SourceProxy* self,
                                   DataSource* source)
{
#line 593 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_PROXY (self));
#line 593 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	SOURCE_PROXY_GET_CLASS (self)->notify_reconstituted (self, source);
#line 4357 "DataSource.c"
}


static void
source_proxy_real_notify_dehydrated (SourceProxy* self)
{
#line 598 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_emit (self, source_proxy_signals[SOURCE_PROXY_DEHYDRATED_SIGNAL], 0);
#line 4366 "DataSource.c"
}


void
source_proxy_notify_dehydrated (SourceProxy* self)
{
#line 597 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_PROXY (self));
#line 597 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	SOURCE_PROXY_GET_CLASS (self)->notify_dehydrated (self);
#line 4377 "DataSource.c"
}


static void
source_proxy_real_notify_broken (SourceProxy* self)
{
#line 602 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_emit (self, source_proxy_signals[SOURCE_PROXY_BROKEN_SIGNAL], 0);
#line 4386 "DataSource.c"
}


void
source_proxy_notify_broken (SourceProxy* self)
{
#line 601 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_PROXY (self));
#line 601 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	SOURCE_PROXY_GET_CLASS (self)->notify_broken (self);
#line 4397 "DataSource.c"
}


static void
source_proxy_on_snapshot_broken (SourceProxy* self)
{
#line 605 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_PROXY (self));
#line 606 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_proxy_drop_source (self);
#line 608 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_proxy_notify_broken (self);
#line 4410 "DataSource.c"
}


static void
_source_proxy_on_destroyed_data_source_destroyed (DataSource* _sender,
                                                  gpointer self)
{
#line 615 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_proxy_on_destroyed ((SourceProxy*) self);
#line 4420 "DataSource.c"
}


static void
source_proxy_set_source (SourceProxy* self,
                         DataSource* source)
{
	DataSource* _tmp0_;
#line 611 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_PROXY (self));
#line 611 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 612 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_proxy_drop_source (self);
#line 614 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = _g_object_ref0 (source);
#line 614 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_object_unref0 (self->priv->source);
#line 614 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->source = _tmp0_;
#line 615 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_connect (source, "destroyed", (GCallback) _source_proxy_on_destroyed_data_source_destroyed, self);
#line 4443 "DataSource.c"
}


static void
source_proxy_drop_source (SourceProxy* self)
{
	DataSource* _tmp0_;
	DataSource* _tmp1_;
	guint _tmp2_;
#line 618 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_PROXY (self));
#line 619 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->source;
#line 619 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp0_ == NULL) {
#line 620 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return;
#line 4461 "DataSource.c"
	}
#line 622 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = self->priv->source;
#line 622 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_parse_name ("destroyed", TYPE_DATA_SOURCE, &_tmp2_, NULL, FALSE);
#line 622 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _source_proxy_on_destroyed_data_source_destroyed, self);
#line 623 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_object_unref0 (self->priv->source);
#line 623 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->source = NULL;
#line 4473 "DataSource.c"
}


DataSource*
source_proxy_get_source (SourceProxy* self)
{
	DataSource* result = NULL;
	SourceSnapshot* _tmp0_;
	DataSource* _tmp1_;
	DataSource* new_source = NULL;
	gint64 _tmp4_;
	SourceSnapshot* _tmp5_;
	DataSource* _tmp6_;
	DataSource* _tmp7_;
	DataSource* _tmp8_;
	gint64 _tmp11_;
	DataSource* _tmp12_;
	DataSource* _tmp14_;
	gint64 _tmp15_;
	SourceCollection* _tmp16_;
	DataSource* _tmp17_;
	DataSource* _tmp18_;
	DataSource* _tmp19_;
#line 626 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_SOURCE_PROXY (self), NULL);
#line 627 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->snapshot;
#line 627 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (source_snapshot_is_broken (_tmp0_)) {
#line 628 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		result = NULL;
#line 628 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return result;
#line 4507 "DataSource.c"
	}
#line 630 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = self->priv->source;
#line 630 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp1_ != NULL) {
#line 4513 "DataSource.c"
		DataSource* _tmp2_;
		DataSource* _tmp3_;
#line 631 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp2_ = self->priv->source;
#line 631 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp3_ = _g_object_ref0 (_tmp2_);
#line 631 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		result = _tmp3_;
#line 631 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return result;
#line 4524 "DataSource.c"
	}
#line 636 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp4_ = self->priv->object_id;
#line 636 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp5_ = self->priv->snapshot;
#line 636 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp6_ = source_proxy_reconstitute (self, _tmp4_, _tmp5_);
#line 636 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	new_source = _tmp6_;
#line 637 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp7_ = self->priv->source;
#line 637 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp8_ = new_source;
#line 637 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp7_ != _tmp8_) {
#line 4540 "DataSource.c"
		DataSource* _tmp9_;
		DataSource* _tmp10_;
#line 638 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp9_ = new_source;
#line 638 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp10_ = _g_object_ref0 (_tmp9_);
#line 638 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_g_object_unref0 (self->priv->source);
#line 638 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		self->priv->source = _tmp10_;
#line 4551 "DataSource.c"
	}
#line 639 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp11_ = self->priv->object_id;
#line 639 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp12_ = self->priv->source;
#line 639 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp11_ != data_object_get_object_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_DATA_OBJECT, DataObject))) {
#line 4559 "DataSource.c"
		DataSource* _tmp13_;
#line 640 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp13_ = new_source;
#line 640 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		self->priv->object_id = data_object_get_object_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_DATA_OBJECT, DataObject));
#line 4565 "DataSource.c"
	}
#line 641 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp14_ = self->priv->source;
#line 641 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp15_ = self->priv->object_id;
#line 641 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (data_object_get_object_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_DATA_OBJECT, DataObject)) == _tmp15_, "source.get_object_id() == object_id");
#line 642 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp16_ = self->priv->membership;
#line 642 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp17_ = self->priv->source;
#line 642 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (data_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_DATA_OBJECT, DataObject)), "membership.contains(source)");
#line 644 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp18_ = self->priv->source;
#line 644 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp19_ = _g_object_ref0 (_tmp18_);
#line 644 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp19_;
#line 644 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_object_unref0 (new_source);
#line 644 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 4589 "DataSource.c"
}


static void
source_proxy_on_destroyed (SourceProxy* self)
{
	DataSource* _tmp0_;
#line 647 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_PROXY (self));
#line 648 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->source;
#line 648 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (_tmp0_ != NULL, "source != null");
#line 651 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_proxy_drop_source (self);
#line 653 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_proxy_notify_dehydrated (self);
#line 4607 "DataSource.c"
}


static void
source_proxy_on_source_added (SourceProxy* self,
                              GeeIterable* added)
{
	DataSource* _tmp0_;
#line 656 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_PROXY (self));
#line 656 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (GEE_IS_ITERABLE (added));
#line 658 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->source;
#line 658 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp0_ != NULL) {
#line 659 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return;
#line 4626 "DataSource.c"
	}
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp1_;
#line 661 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp1_ = gee_iterable_iterator (added);
#line 661 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_object_it = _tmp1_;
#line 661 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		while (TRUE) {
#line 4637 "DataSource.c"
			GeeIterator* _tmp2_;
			DataObject* object = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			DataObject* _tmp5_;
			gint64 _tmp6_;
			DataObject* _tmp7_;
			DataObject* _tmp8_;
#line 661 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp2_ = _object_it;
#line 661 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			if (!gee_iterator_next (_tmp2_)) {
#line 661 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				break;
#line 4652 "DataSource.c"
			}
#line 661 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp3_ = _object_it;
#line 661 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp4_ = gee_iterator_get (_tmp3_);
#line 661 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			object = (DataObject*) _tmp4_;
#line 663 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp5_ = object;
#line 663 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp6_ = self->priv->object_id;
#line 663 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			if (data_object_get_object_id (_tmp5_) != _tmp6_) {
#line 664 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_g_object_unref0 (object);
#line 664 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				continue;
#line 4670 "DataSource.c"
			}
#line 667 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp7_ = object;
#line 667 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			source_proxy_set_source (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_SOURCE, DataSource));
#line 669 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp8_ = object;
#line 669 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			source_proxy_notify_reconstituted (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_SOURCE, DataSource));
#line 671 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_g_object_unref0 (object);
#line 671 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			break;
#line 4684 "DataSource.c"
		}
#line 661 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_g_object_unref0 (_object_it);
#line 4688 "DataSource.c"
	}
}


static void
source_proxy_real_reconstituted (SourceProxy* self,
                                 DataSource* source)
{
#line 558 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 4699 "DataSource.c"
}


static void
source_proxy_real_dehydrated (SourceProxy* self)
{
}


static void
source_proxy_real_broken (SourceProxy* self)
{
}


static void
value_source_proxy_init (GValue* value)
{
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	value->data[0].v_pointer = NULL;
#line 4720 "DataSource.c"
}


static void
value_source_proxy_free_value (GValue* value)
{
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (value->data[0].v_pointer) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_proxy_unref (value->data[0].v_pointer);
#line 4731 "DataSource.c"
	}
}


static void
value_source_proxy_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (src_value->data[0].v_pointer) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		dest_value->data[0].v_pointer = source_proxy_ref (src_value->data[0].v_pointer);
#line 4744 "DataSource.c"
	} else {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4748 "DataSource.c"
	}
}


static gpointer
value_source_proxy_peek_pointer (const GValue* value)
{
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return value->data[0].v_pointer;
#line 4758 "DataSource.c"
}


static gchar*
value_source_proxy_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (collect_values[0].v_pointer) {
#line 4770 "DataSource.c"
		SourceProxy * object;
		object = collect_values[0].v_pointer;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		if (object->parent_instance.g_class == NULL) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4777 "DataSource.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4781 "DataSource.c"
		}
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = source_proxy_ref (object);
#line 4785 "DataSource.c"
	} else {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = NULL;
#line 4789 "DataSource.c"
	}
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return NULL;
#line 4793 "DataSource.c"
}


static gchar*
value_source_proxy_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	SourceProxy ** object_p;
	object_p = collect_values[0].v_pointer;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (!object_p) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4809 "DataSource.c"
	}
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (!value->data[0].v_pointer) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		*object_p = NULL;
#line 4815 "DataSource.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		*object_p = value->data[0].v_pointer;
#line 4819 "DataSource.c"
	} else {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		*object_p = source_proxy_ref (value->data[0].v_pointer);
#line 4823 "DataSource.c"
	}
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return NULL;
#line 4827 "DataSource.c"
}


GParamSpec*
param_spec_source_proxy (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	ParamSpecSourceProxy* spec;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SOURCE_PROXY), NULL);
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return G_PARAM_SPEC (spec);
#line 4847 "DataSource.c"
}


gpointer
value_get_source_proxy (const GValue* value)
{
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_PROXY), NULL);
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return value->data[0].v_pointer;
#line 4858 "DataSource.c"
}


void
value_set_source_proxy (GValue* value,
                        gpointer v_object)
{
	SourceProxy * old;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_PROXY));
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	old = value->data[0].v_pointer;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (v_object) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SOURCE_PROXY));
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = v_object;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_proxy_ref (value->data[0].v_pointer);
#line 4881 "DataSource.c"
	} else {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = NULL;
#line 4885 "DataSource.c"
	}
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (old) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_proxy_unref (old);
#line 4891 "DataSource.c"
	}
}


void
value_take_source_proxy (GValue* value,
                         gpointer v_object)
{
	SourceProxy * old;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_PROXY));
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	old = value->data[0].v_pointer;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (v_object) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SOURCE_PROXY));
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = v_object;
#line 4913 "DataSource.c"
	} else {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = NULL;
#line 4917 "DataSource.c"
	}
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (old) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_proxy_unref (old);
#line 4923 "DataSource.c"
	}
}


static void
source_proxy_class_init (SourceProxyClass * klass)
{
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_proxy_parent_class = g_type_class_peek_parent (klass);
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((SourceProxyClass *) klass)->finalize = source_proxy_finalize;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_type_class_add_private (klass, sizeof (SourceProxyPrivate));
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((SourceProxyClass *) klass)->reconstitute = (DataSource* (*) (SourceProxy *, gint64, SourceSnapshot*)) source_proxy_real_reconstitute;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((SourceProxyClass *) klass)->notify_reconstituted = (void (*) (SourceProxy *, DataSource*)) source_proxy_real_notify_reconstituted;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((SourceProxyClass *) klass)->notify_dehydrated = (void (*) (SourceProxy *)) source_proxy_real_notify_dehydrated;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((SourceProxyClass *) klass)->notify_broken = (void (*) (SourceProxy *)) source_proxy_real_notify_broken;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((SourceProxyClass *) klass)->reconstituted = source_proxy_real_reconstituted;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((SourceProxyClass *) klass)->dehydrated = source_proxy_real_dehydrated;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((SourceProxyClass *) klass)->broken = source_proxy_real_broken;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_proxy_signals[SOURCE_PROXY_RECONSTITUTED_SIGNAL] = g_signal_new ("reconstituted", TYPE_SOURCE_PROXY, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceProxyClass, reconstituted), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_DATA_SOURCE);
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_proxy_signals[SOURCE_PROXY_DEHYDRATED_SIGNAL] = g_signal_new ("dehydrated", TYPE_SOURCE_PROXY, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceProxyClass, dehydrated), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_proxy_signals[SOURCE_PROXY_BROKEN_SIGNAL] = g_signal_new ("broken", TYPE_SOURCE_PROXY, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceProxyClass, broken), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 4957 "DataSource.c"
}


static void
source_proxy_instance_init (SourceProxy * self)
{
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv = SOURCE_PROXY_GET_PRIVATE (self);
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->ref_count = 1;
#line 4968 "DataSource.c"
}


static void
source_proxy_finalize (SourceProxy * obj)
{
	SourceProxy * self;
	SourceCollection* _tmp0_;
	guint _tmp1_;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOURCE_PROXY, SourceProxy);
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_handlers_destroy (self);
#line 587 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_proxy_drop_source (self);
#line 588 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->membership;
#line 588 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_parse_name ("items-added", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
#line 588 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _source_proxy_on_source_added_data_collection_items_added, self);
#line 551 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_free0 (self->priv->source_string);
#line 552 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_object_unref0 (self->priv->source);
#line 553 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_source_snapshot_unref0 (self->priv->snapshot);
#line 554 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_data_collection_unref0 (self->priv->membership);
#line 4998 "DataSource.c"
}


GType
source_proxy_get_type (void)
{
	static volatile gsize source_proxy_type_id__volatile = 0;
	if (g_once_init_enter (&source_proxy_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_source_proxy_init, value_source_proxy_free_value, value_source_proxy_copy_value, value_source_proxy_peek_pointer, "p", value_source_proxy_collect_value, "p", value_source_proxy_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SourceProxyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) source_proxy_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SourceProxy), 0, (GInstanceInitFunc) source_proxy_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType source_proxy_type_id;
		source_proxy_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SourceProxy", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&source_proxy_type_id__volatile, source_proxy_type_id);
	}
	return source_proxy_type_id__volatile;
}


gpointer
source_proxy_ref (gpointer instance)
{
	SourceProxy * self;
	self = instance;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_atomic_int_inc (&self->ref_count);
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return instance;
#line 5027 "DataSource.c"
}


void
source_proxy_unref (gpointer instance)
{
	SourceProxy * self;
	self = instance;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		SOURCE_PROXY_GET_CLASS (self)->finalize (self);
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5042 "DataSource.c"
	}
}


SourceProxy*
proxyable_get_proxy (Proxyable* self)
{
#line 677 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_PROXYABLE (self), NULL);
#line 677 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return PROXYABLE_GET_INTERFACE (self)->get_proxy (self);
#line 5054 "DataSource.c"
}


static void
proxyable_base_init (ProxyableIface * iface)
{
#line 676 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	static gboolean initialized = FALSE;
#line 676 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (!initialized) {
#line 676 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		initialized = TRUE;
#line 5067 "DataSource.c"
	}
}


GType
proxyable_get_type (void)
{
	static volatile gsize proxyable_type_id__volatile = 0;
	if (g_once_init_enter (&proxyable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ProxyableIface), (GBaseInitFunc) proxyable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType proxyable_type_id;
		proxyable_type_id = g_type_register_static (G_TYPE_INTERFACE, "Proxyable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (proxyable_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&proxyable_type_id__volatile, proxyable_type_id);
	}
	return proxyable_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



