.TH CTIE 1 "8 June 2020" "Web2C @VERSION@"
.\"=====================================================================
.SH NAME
ctie \- merge or apply CWEB change files
.\"=====================================================================
.SH SYNOPSIS
.B ctie
.BR \-c | \-m
.I outputfile masterfile
.IR changefile .\|.\|.
.\"=====================================================================
.SH DESCRIPTION
The
.B ctie
program is used to process multiple change files used with the CWEB
system for literate programming.  The CWEB programs allow one to apply
patches to a source file (the
.IR masterfile )
by means of a single change file.
.B ctie
can be used to either merge up to 32 change files into a single one or
to apply the changes to the
.I masterfile
in order to create a new master file.  Output of either the new change
file or the patched master file goes into
.IR outputfile .
Any include files (indicated using the CWEB
.B @i
command) are fully expanded during
.B ctie
processing, which means that the change files are able to modify the
contents of any included files.
.SH OPTIONS
.TP
.B \-c
Create a single change file from the given
.IR changefile s.
.TP
.B \-m
Create a new master file by applying the given
.IR changefile s.
.\"=====================================================================
.SH ENVIRONMENT
The environment variable CWEBINPUTS is used to search for the input files,
or the system default if CWEBINPUTS is not set.  See
.BR tex (1)
for the details of the searching.
To avoid conflicts with other programs that also use the CWEBINPUTS
environment, you can be more specific and use CWEBINPUTS_ctie for
special requirements in CTIE.
.\"=====================================================================
.SH "SEE ALSO"
.BR cweb (1),
.IR ctiedoc.tex ,
.BR tie (1),
.BR web (1).
.\"=====================================================================
.SH "AUTHOR"
Julian Gilbey, jdg@debian.org.  The original TIE program was by Klaus
Guntermann, TH Darmstadt, Institut f. Theoretische Informatik.  The
TIE man page was by Joachim Schnitter, TH Darmstadt, Phys. Chemie I,
and was modified for CTIE by Julian Gilbey.
