/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.os.SystemClock;
import com.jayway.android.robotium.solo.Sleeper;
import com.jayway.android.robotium.solo.ViewFetcher;

class DialogUtils {
    private final ViewFetcher viewFetcher;
    private final Sleeper sleeper;

    public DialogUtils(ViewFetcher viewFetcher, Sleeper sleeper) {
        this.viewFetcher = viewFetcher;
        this.sleeper = sleeper;
    }

    public boolean waitForDialogToClose(long timeout) {
        int elementsBefore = this.viewFetcher.getWindowDecorViews().length;
        long endTime = SystemClock.uptimeMillis() + timeout;
        while (SystemClock.uptimeMillis() < endTime) {
            int elementsNow = this.viewFetcher.getWindowDecorViews().length;
            if (elementsBefore < elementsNow) {
                elementsBefore = elementsNow;
            }
            if (elementsBefore > elementsNow) {
                return true;
            }
            this.sleeper.sleep(10);
        }
        return false;
    }
}

