/** @file
*
*  Copyright (c) 2011-2013, ARM Limited. All rights reserved.
*
*  This program and the accompanying materials
*  are licensed and made available under the terms and conditions of the BSD License
*  which accompanies this distribution.  The full text of the license may be found at
*  http://opensource.org/licenses/bsd-license.php
*
*  THE PROGRAM IS DISTRIBUTED UNDER THE BSD LICENSE ON AN "AS IS" BASIS,
*  WITHOUT WARRANTIES OR REPRESENTATIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED.
*
**/

#include <Library/IoLib.h>
#include <Library/ArmPlatformLib.h>
#include <Library/DebugLib.h>
#include <Library/PcdLib.h>

#include <Ppi/ArmMpCoreInfo.h>

#include <ArmPlatform.h>


UINTN
ArmGetCpuCountPerCluster (
  VOID
  );

ARM_CORE_INFO mVersatileExpressMpCoreInfoTable[] = {
  {
    // Cluster 0, Core 0
    0x0, 0x0,

    // NOTE:
    // The foundation model does not have the VE_SYS_REGS like all the other VE
    // platforms. We pick a spot in RAM that *should* be safe in the simple case
    // of no UEFI apps interfering (Only the Linux loader getting used). By the
    // time we come to load Linux we should have all the cores in a safe place.
    // The image expects to be loaded at 0xa0000000. We also place the mailboxes
    // here as it does not matter if we corrupt the image at this time.
    // NOTE also see: "ArmVExpressSecLibRTSM/AArch64/RTSMFoundationBoot.S"

    // MP Core MailBox Set/Get/Clear Addresses and Clear Value
    (EFI_PHYSICAL_ADDRESS)0xa0000000,
    (EFI_PHYSICAL_ADDRESS)0xa0000000,
    (EFI_PHYSICAL_ADDRESS)0xa0000000,
    (UINT64)0x0

  },
  {
    // Cluster 0, Core 1
    0x0, 0x1,

    // MP Core MailBox Set/Get/Clear Addresses and Clear Value
    (EFI_PHYSICAL_ADDRESS)0xa0000000,
    (EFI_PHYSICAL_ADDRESS)0xa0000000,
    (EFI_PHYSICAL_ADDRESS)0xa0000000,
    (UINT64)0x0

  },
  {
    // Cluster 0, Core 2
    0x0, 0x2,

    // MP Core MailBox Set/Get/Clear Addresses and Clear Value
    (EFI_PHYSICAL_ADDRESS)0xa0000000,
    (EFI_PHYSICAL_ADDRESS)0xa0000000,
    (EFI_PHYSICAL_ADDRESS)0xa0000000,
    (UINT64)0x0
  },
  {
    // Cluster 0, Core 3
    0x0, 0x3,

    // MP Core MailBox Set/Get/Clear Addresses and Clear Value
    (EFI_PHYSICAL_ADDRESS)0xa0000000,
    (EFI_PHYSICAL_ADDRESS)0xa0000000,
    (EFI_PHYSICAL_ADDRESS)0xa0000000,
    (UINT64)0x0
  }
};

/**
  Return the current Boot Mode

  This function returns the boot reason on the platform

  @return   Return the current Boot Mode of the platform

**/
EFI_BOOT_MODE
ArmPlatformGetBootMode (
  VOID
  )
{
  return BOOT_WITH_FULL_CONFIGURATION;
}

/**
  Initialize controllers that must setup in the normal world

  This function is called by the ArmPlatformPkg/Pei or ArmPlatformPkg/Pei/PlatformPeim
  in the PEI phase.

**/
RETURN_STATUS
ArmPlatformInitialize (
  IN  UINTN                     MpId
  )
{
  /* The Foundation model has no SP810 to initialise. */

  return RETURN_SUCCESS;
}

/**
  Initialize the system (or sometimes called permanent) memory

  This memory is generally represented by the DRAM.

**/
VOID
ArmPlatformInitializeSystemMemory (
  VOID
  )
{
  // Nothing to do here
}

EFI_STATUS
PrePeiCoreGetMpCoreInfo (
  OUT UINTN                   *CoreCount,
  OUT ARM_CORE_INFO           **ArmCoreTable
  )
{
  // Foundation model has no VE_SYS_REGS
  // Only support one cluster
  *CoreCount    = ArmGetCpuCountPerCluster ();
  *ArmCoreTable = mVersatileExpressMpCoreInfoTable;

  return EFI_SUCCESS;
}

// Needs to be declared in the file. Otherwise gArmMpCoreInfoPpiGuid is undefined in the context of PrePeiCore
EFI_GUID mArmMpCoreInfoPpiGuid = ARM_MP_CORE_INFO_PPI_GUID;
ARM_MP_CORE_INFO_PPI mMpCoreInfoPpi = { PrePeiCoreGetMpCoreInfo };

EFI_PEI_PPI_DESCRIPTOR      gPlatformPpiTable[] = {
  {
    EFI_PEI_PPI_DESCRIPTOR_PPI,
    &mArmMpCoreInfoPpiGuid,
    &mMpCoreInfoPpi
  }
};

VOID
ArmPlatformGetPlatformPpiList (
  OUT UINTN                   *PpiListSize,
  OUT EFI_PEI_PPI_DESCRIPTOR  **PpiList
  )
{
  *PpiListSize = sizeof(gPlatformPpiTable);
  *PpiList = gPlatformPpiTable;
}
