/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import picard.PicardException;
import picard.illumina.parser.IlluminaFileMap;

class CycleIlluminaFileMap
extends TreeMap<Integer, IlluminaFileMap> {
    CycleIlluminaFileMap() {
    }

    public CycleIlluminaFileMap keep(List<Integer> tilesToKeep, Set<Integer> cycles) {
        CycleIlluminaFileMap ciMap = new CycleIlluminaFileMap();
        if (cycles != null) {
            for (int cycle : cycles) {
                IlluminaFileMap template = (IlluminaFileMap)this.get(cycle);
                if (template == null) continue;
                ciMap.put(cycle, template.keep(tilesToKeep));
            }
        }
        return ciMap;
    }

    public void assertValid(List<Integer> expectedTiles, int[] expectedCycles) {
        if (this.size() != expectedCycles.length) {
            throw new PicardException("Expected CycledIlluminaFileMap to contain " + expectedCycles.length + " cycles but only " + this.size() + " were found!");
        }
        if (((IlluminaFileMap)this.firstEntry().getValue()).size() != expectedTiles.size()) {
            throw new PicardException("Expected CycledIlluminaFileMap to contain " + expectedTiles.size() + " tiles but only " + ((IlluminaFileMap)this.firstEntry().getValue()).size() + " were found!");
        }
    }
}

