/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.Jpeg2000Module;
import edu.harvard.hul.ois.jhove.module.jpeg2000.COCMarkerSegment;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CODMarkerSegment;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CRGMarkerSegment;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Codestream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CommentMarkerSegment;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ContCodestream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.DefaultMarkerSegment;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MainOrTile;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Marker;
import edu.harvard.hul.ois.jhove.module.jpeg2000.PLMMarkerSegment;
import edu.harvard.hul.ois.jhove.module.jpeg2000.PLTMarkerSegment;
import edu.harvard.hul.ois.jhove.module.jpeg2000.POCMarkerSegment;
import edu.harvard.hul.ois.jhove.module.jpeg2000.PPMMarkerSegment;
import edu.harvard.hul.ois.jhove.module.jpeg2000.PPTMarkerSegment;
import edu.harvard.hul.ois.jhove.module.jpeg2000.QCCMarkerSegment;
import edu.harvard.hul.ois.jhove.module.jpeg2000.QCDMarkerSegment;
import edu.harvard.hul.ois.jhove.module.jpeg2000.RGNMarkerSegment;
import edu.harvard.hul.ois.jhove.module.jpeg2000.SIZMarkerSegment;
import edu.harvard.hul.ois.jhove.module.jpeg2000.SOTMarkerSegment;
import edu.harvard.hul.ois.jhove.module.jpeg2000.TLMMarkerSegment;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Tile;
import java.io.DataInputStream;
import java.io.IOException;

public abstract class MarkerSegment {
    protected static final int SOC = 79;
    protected static final int COD = 82;
    protected static final int COC = 83;
    protected static final int TLM = 85;
    protected static final int PLM = 87;
    protected static final int PLT = 88;
    protected static final int QCD = 92;
    protected static final int QCC = 93;
    protected static final int RGN = 94;
    protected static final int POC = 95;
    protected static final int PPM = 96;
    protected static final int PPT = 97;
    protected static final int CRG = 99;
    protected static final int COM = 100;
    protected static final int SOT = 144;
    protected static final int SOP = 145;
    protected static final int EPH = 146;
    protected static final int SOD = 147;
    protected static final int EOC = 217;
    protected static final int SIZ = 81;
    protected ContCodestream _ccs;
    protected Codestream _cs;
    protected Jpeg2000Module _module;
    protected DataInputStream _dstream;
    protected RepInfo _repInfo;

    public void setContCodestream(ContCodestream contCodestream) {
        this._ccs = contCodestream;
    }

    public void setCodestream(Codestream codestream) {
        this._cs = codestream;
    }

    public void setModule(Jpeg2000Module jpeg2000Module) {
        this._module = jpeg2000Module;
    }

    public void setDataInputStream(DataInputStream dataInputStream) {
        this._dstream = dataInputStream;
    }

    public void setRepInfo(RepInfo repInfo) {
        this._repInfo = repInfo;
    }

    public boolean isMarker() {
        return false;
    }

    protected static MarkerSegment markerSegmentMaker(int n) {
        switch (n) {
            case 144: {
                return new SOTMarkerSegment();
            }
            case 83: {
                return new COCMarkerSegment();
            }
            case 82: {
                return new CODMarkerSegment();
            }
            case 100: {
                return new CommentMarkerSegment();
            }
            case 99: {
                return new CRGMarkerSegment();
            }
            case 87: {
                return new PLMMarkerSegment();
            }
            case 88: {
                return new PLTMarkerSegment();
            }
            case 95: {
                return new POCMarkerSegment();
            }
            case 96: {
                return new PPMMarkerSegment();
            }
            case 97: {
                return new PPTMarkerSegment();
            }
            case 93: {
                return new QCCMarkerSegment();
            }
            case 92: {
                return new QCDMarkerSegment();
            }
            case 94: {
                return new RGNMarkerSegment();
            }
            case 81: {
                return new SIZMarkerSegment();
            }
            case 85: {
                return new TLMMarkerSegment();
            }
            case 79: 
            case 146: 
            case 147: 
            case 217: {
                return new Marker();
            }
        }
        return new DefaultMarkerSegment();
    }

    protected int readMarkLen() throws IOException {
        return this._module.readUnsignedShort(this._dstream);
    }

    protected int nCompBytes() {
        int n = this._cs.getNumComponents();
        if (n == 0) {
            return 0;
        }
        return n < 257 ? 1 : 2;
    }

    protected MainOrTile getMainOrTile() {
        Tile tile = this._ccs.getCurTile();
        if (tile != null) {
            return tile;
        }
        return this._cs;
    }

    protected abstract boolean process(int var1) throws IOException;
}

