const char cgGLHelixFragmentShader[] = 
"// this is the fragment program\n"
"\n"
"\n"
"struct inputs\n"
"{\n"
"	float4 HPOS : POSITION;\n"
"	float4 texcoord : TEXCOORD0;\n"
"	float4 texcoord1 : TEXCOORD1;	// duplicate of HPOS to read it\n"
"	float4 texcoord2 : TEXCOORD2;\n"
"	float4 texcoord3 : TEXCOORD3;\n"
"	float4 primarycolor : COLOR0;\n"
"	float3 secondarycolor : COLOR1;\n"
"};\n"
"\n"
"float3 expand(float3 vector)\n"
"{\n"
"    return 2.0 * (vector - 0.5);\n"
"}\n"
"\n"
"// register combiner vector normalization function\n"
"float3 normalize(float3 vector)\n"
"{\n"
"    float3 VdotV = dot(expand(vector), expand(vector));\n"
"    return (1-saturate(VdotV)) * (vector-0.5) + expand(vector);\n"
"}\n"
"\n"
"float getOpacity(uniform float4x4 ModelViewProjInverse,\n"
"				 float4 ndcPos,\n"
"				 uniform float4 endPoint1,\n"
"				 uniform float3 helixDCs,\n"
"				 uniform float3 refVector,\n"
"				 uniform sampler2D opacitymap,\n"
"				 uniform float3 helixDCsCrossRefVector,\n"
"				 uniform float lengthOfHelix)\n"
"{\n"
"	float pitch = endPoint1.a;\n"
"	endPoint1.a = 1.0;\n"
"\n"
"	// P be obj pos of frag\n"
"	// DCs be DCs of axis\n"
"	// P1 be one end point\n"
"	// P0 be a point on cylinder\n"
"	// P2 be point on axis closest to P\n"
"\n"
"	// 1. Get obj pos of point P\n"
"	float4 P = mul(ModelViewProjInverse,ndcPos);\n"
"\n"
"	// 2. t = (DCs . (P-P1)) / 1  ( 1 = DC.DC if DCs is normalized )\n"
"	float3 PminusP1 = (P-endPoint1).rgb;\n"
"	float y = dot(helixDCs, PminusP1);\n"
"\n"
"	float opacity = 0.0;\n"
"\n"
"	if( y >= 0 ) \n"
"	{\n"
"		if( y <= lengthOfHelix )\n"
"		{\n"
"			// 3. x = cos-1 [(P-P1-t*DCs) . (P0-P1)]\n"
"			float3 PVector = PminusP1-y*helixDCs;\n"
"			PVector = PVector / length(PVector);\n"
"			float x = acos(dot(PVector,refVector));	// theta lies in 0 to 180\n"
"\n"
"			// take cross of ref vec, dcs. // sent in by program\n"
"			// see which side new vector lies on\n"
"			float side = dot( PVector, helixDCsCrossRefVector );\n"
"			// modify the theta to lie in 0 - 360\n"
"			if( side < 0 ) x = 2.0*3.1415926535897932384626433832795 - x;\n"
"			x = x / (2.0*3.1415926535897932384626433832795);	// get answer from 0 - 1\n"
"			\n"
"			// H = endPoint1.a = pitch\n"
"			y = fmod( y, pitch ) / pitch;\n"
"\n"
"			// 5. opacity = TEX2D( opacitymap, xy )\n"
"			opacity = tex2D(opacitymap, float2(x,y)).r;\n"
"//			opacity = 1.0;\n"
"		}\n"
"	}\n"
"\n"
"	return opacity;\n"
"}\n"
"\n"
"float4 main(inputs IN, out float depth: DEPTH,\n"
"			uniform float4 maincolor,\n"
"			uniform sampler1D normalmap,\n"
"			uniform sampler2D depthmap,\n"
"			uniform sampler2D opacitymap,\n"
"			uniform float4x4 ModelViewProjInverse,\n"
"			uniform float3 helixDCs,\n"
"			uniform float3 refVector,\n"
"			uniform float3 helixDCsCrossRefVector,\n"
"			uniform float4 endPoint1,\n"
"			uniform float lengthOfHelix) : COLOR\n"
"{\n"
"	float4 normal = 2.0 * (tex1D(normalmap, IN.texcoord.x) - 0.5);\n"
"	\n"
"	IN.secondarycolor.rgb = normalize(IN.secondarycolor.rgb);\n"
"\n"
"	float3 NdotL = dot(normal.rgb, IN.secondarycolor);\n"
"	float3 color = IN.primarycolor.rgb*(saturate(NdotL) + IN.primarycolor.w);\n"
"\n"
"    // calculate reflection vector\n"
"    // R = 2 * (N * (N dot L) - L/2)\n"
"    //   = 2 * N * (N dot L) - L\n"
"    float3 reflectVec = ((NdotL * normal.rgb) + (-0.5 * IN.secondarycolor)) * 2.0;\n"
"\n"
"    // eye vector E = (0, 0, 1)\n"
"    // R dot E = (R.r*0 + R.g*0 + 1*R.b) = R.b\n"
"    float RdotE = saturate(reflectVec.b);   // max(0, RdotE);\n"
"\n"
"    // calculate specular as pow(RdotE, 16)\n"
"	float specular = pow(RdotE, 16); \n"
"    // add specular light contribution to final color\n"
"	color += specular;\n"
"	\n"
"	float3 depthVal;\n"
"	float z;\n"
"	float w;\n"
"	float4 ndcPos;\n"
"\n"
"\n"
"	depthVal = tex2D(depthmap, IN.texcoord.xy).rgb;\n"
"	// this endPoint.a is totally overloaded !\n"
"	if( endPoint1.a < 0.0 ) \n"
"	{\n"
"		depthVal.r = -1.0 * depthVal.r;\n"
"		endPoint1.a = -1.0 * endPoint1.a;\n"
"		color = color*0.5;\n"
"	}\n"
"    z = dot(IN.texcoord2.xyz, depthVal);\n"
"    w = dot(IN.texcoord3.xyz, depthVal);\n"
"    depth = (z / w);\n"
"	ndcPos = float4( IN.texcoord1.x, IN.texcoord1.y, depth, 1.0 );\n"
"\n"
"	float opacity = getOpacity(ModelViewProjInverse,\n"
"				 ndcPos,\n"
"				 endPoint1,\n"
"				 helixDCs,\n"
"				 refVector,\n"
"				 opacitymap,\n"
"				 helixDCsCrossRefVector,\n"
"				 lengthOfHelix);\n"
"	\n"
"	depth = depth*0.5 + 0.5;\n"
"	return float4(color, opacity);\n"
"}\n"
"\n"
"\n"
"// send in a helix opacity map\n"
"// obtain the fragments rotation and offset on cylinder\n"
"// get a mod of the offset\n"
"// lookup opacity!\n";
