#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Cats Hidden in Places:
# - Cats Hidden in Paris
# - Cats Hidden in Italy
# - Cats Hidden in Bali
# - Cats Hidden in Maple Hollow
# send your bug reports to contact@dotslashplay.it
###

script_version=20240219.3

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID_PARIS='cats-hidden-in-paris'
GAME_NAME_PARIS='Cats Hidden in Paris'

GAME_ID_ITALY='cats-hidden-in-italy'
GAME_NAME_ITALY='Cats Hidden in Italy'

GAME_ID_BALI='cats-hidden-in-bali'
GAME_NAME_BALI='Cats Hidden in Bali'

GAME_ID_MAPLE='cats-hidden-in-maple-hollow'
GAME_NAME_MAPLE='Cats Hidden in Maple Hollow'

# Archives

## Cats Hidden in Paris

ARCHIVE_BASE_PARIS_0_NAME='setup_cats_hidden_in_paris_1.0_gog_dlc_fix6_(69829).exe'
ARCHIVE_BASE_PARIS_0_MD5='6b55ff57a52f1edd2990133737c870cd'
ARCHIVE_BASE_PARIS_0_TYPE='innosetup'
ARCHIVE_BASE_PARIS_0_SIZE='106572'
ARCHIVE_BASE_PARIS_0_VERSION='1.0-gog69829'
ARCHIVE_BASE_PARIS_0_URL='https://www.gog.com/game/cats_hidden_in_paris'

## Cats Hidden in Italy

ARCHIVE_BASE_ITALY_0_NAME='setup_cats_hidden_in_italy_1.0_gog_savefix_proper_(69657).exe'
ARCHIVE_BASE_ITALY_0_MD5='7564fdad50e6e655cb16bca17db30058'
ARCHIVE_BASE_ITALY_0_TYPE='innosetup'
ARCHIVE_BASE_ITALY_0_SIZE='102010'
ARCHIVE_BASE_ITALY_0_VERSION='1.0-gog69657'
ARCHIVE_BASE_ITALY_0_URL='https://www.gog.com/game/cats_hidden_in_italy'

## Cats Hidden in Bali

ARCHIVE_BASE_BALI_0_NAME='setup_cats_hidden_in_bali_1.0_gog_(69565).exe'
ARCHIVE_BASE_BALI_0_MD5='23ce61713a61919f9724a3377feca967'
ARCHIVE_BASE_BALI_0_TYPE='innosetup'
ARCHIVE_BASE_BALI_0_SIZE='104429'
ARCHIVE_BASE_BALI_0_VERSION='1.0-gog69565'
ARCHIVE_BASE_BALI_0_URL='https://www.gog.com/game/cats_hidden_in_bali'

## Cats Hidden in Maple Hollow

ARCHIVE_BASE_MAPLE_0_NAME='setup_cats_hidden_in_maple_hollow_1.0_gog_(69635).exe'
ARCHIVE_BASE_MAPLE_0_MD5='2a3c9c4b7bc81efd01d62e45cf8f43e3'
ARCHIVE_BASE_MAPLE_0_TYPE='innosetup'
ARCHIVE_BASE_MAPLE_0_SIZE='97744'
ARCHIVE_BASE_MAPLE_0_VERSION='1.0-gog69635'
ARCHIVE_BASE_MAPLE_0_URL='https://www.gog.com/game/cats_hidden_in_maple_hollow'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
modules'
CONTENT_GAME0_BIN_FILES_PARIS='
cats hidden in paris.exe'
CONTENT_GAME0_BIN_FILES_ITALY='
cats hidden in italy.exe'
CONTENT_GAME0_BIN_FILES_BALI='
cats hidden in bali.exe'
CONTENT_GAME0_BIN_FILES_MAPLE='
cats hidden in maple hollow.exe'
CONTENT_GAME_DATA_FILES='
sounds'
CONTENT_GAME0_DATA_FILES_PARIS='
cats hidden in paris.dat'
CONTENT_GAME0_DATA_FILES_ITALY='
cats hidden in italy.dat'
CONTENT_GAME0_DATA_FILES_BALI='
cats hidden in bali.dat'
CONTENT_GAME0_DATA_FILES_MAPLE='
cats hidden in maple hollow.dat'

WINE_PERSISTENT_DIRECTORIES_PARIS='
users/${USER}/AppData/Roaming/Cats Hidden in Paris'
WINE_PERSISTENT_DIRECTORIES_ITALY='
users/${USER}/AppData/Roaming/Cats Hidden in Italy'
WINE_PERSISTENT_DIRECTORIES_BALI='
users/${USER}/AppData/Roaming/Cats Hidden in Bali'
WINE_PERSISTENT_DIRECTORIES_MAPLE='
users/${USER}/AppData/Roaming/Cats Hidden in Maple Hollow'

APP_MAIN_EXE_PARIS='cats hidden in paris.exe'
APP_MAIN_EXE_ITALY='cats hidden in italy.exe'
APP_MAIN_EXE_BALI='cats hidden in bali.exe'
APP_MAIN_EXE_MAPLE='cats hidden in maple hollow.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID_PARIS="${GAME_ID_PARIS}-data"
PKG_DATA_ID_ITALY="${GAME_ID_ITALY}-data"
PKG_DATA_ID_BALI="${GAME_ID_BALI}-data"
PKG_DATA_ID_MAPLE="${GAME_ID_MAPLE}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS_PARIS="$PKG_DATA_ID_PARIS"
PKG_BIN_DEPS_ITALY="$PKG_DATA_ID_ITALY"
PKG_BIN_DEPS_BALI="$PKG_DATA_ID_BALI"
PKG_BIN_DEPS_MAPLE="$PKG_DATA_ID_MAPLE"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
