#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Mopi
set -o errexit

###
# The Darkside Detective
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220628.1

# Set game-specific variables

GAME_ID='the-darkside-detective'
GAME_NAME='The Darkside Detective'

ARCHIVE_BASE_0='the_darkside_detective_2_3_0_1448r_49520.sh'
ARCHIVE_BASE_0_MD5='df6e6205d0d4fc64fc46f5be68f1afce'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='1200000'
ARCHIVE_BASE_0_VERSION='2.3.0.1448r-gog49520'
ARCHIVE_BASE_0_URL='https://www.gog.com/en/game/the_darkside_detective'

UNITY3D_NAME='thedarksidedetective'

CONTENT_PATH_DEFAULT='data/noarch/game'
ARCHIVE_GAME_BIN_FILES="
LinuxPlayer_s.debug
UnityPlayer_s.debug
UnityPlayer.so
${UNITY3D_NAME}.x86_64
${UNITY3D_NAME}_Data/MonoBleedingEdge"
ARCHIVE_GAME_DATA_FILES="
${UNITY3D_NAME}_Data"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID libc.so.6 libstdc++.so.6"

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"

# Include game files

prepare_package_layout

# Delete temporary files

rm --recursive "$PLAYIT_WORKDIR/gamedata"

# Get icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
