/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.Opcode;
import org.codehaus.janino.util.ClassFile;

public class CodeContext {
    private static final boolean DEBUG = false;
    private static final int INITIAL_SIZE = 100;
    private static final int SIZE_INCREMENT = 128;
    private ClassFile classFile;
    private short maxStack;
    private short maxLocals;
    private byte[] code;
    private Offset beginning;
    private Inserter end;
    private Inserter currentInserter;
    private List exceptionTableEntries;
    private static final byte UNEXAMINED = -1;
    private static final byte INVALID_OFFSET = -2;
    private short localVariableArrayLength = 0;
    private final Stack savedLocalVariableArrayLengths = new Stack();
    private final List relocatables = new ArrayList();

    public CodeContext(ClassFile classFile) {
        this.classFile = classFile;
        this.maxStack = 0;
        this.maxLocals = 0;
        this.code = new byte[100];
        this.beginning = new Offset();
        this.currentInserter = this.end = new Inserter();
        this.exceptionTableEntries = new ArrayList();
        this.beginning.offset = 0;
        this.end.offset = 0;
        this.beginning.next = this.end;
        this.end.prev = this.beginning;
    }

    public void addExceptionTableEntry(Offset offset, Offset offset2, Offset offset3, String string) {
        this.exceptionTableEntries.add(new ExceptionTableEntry(offset, offset2, offset3, string == null ? (short)0 : this.classFile.addConstantClassInfo(string)));
    }

    public short allocateLocalVariable(short s) {
        short s2 = this.localVariableArrayLength;
        this.localVariableArrayLength = (short)(this.localVariableArrayLength + s);
        if (this.localVariableArrayLength > this.maxLocals) {
            this.maxLocals = this.localVariableArrayLength;
        }
        return s2;
    }

    public Inserter currentInserter() {
        return this.currentInserter;
    }

    private int determineArgumentsSize(short s) {
        ClassFile.ConstantPoolInfo constantPoolInfo = this.classFile.getConstantPoolInfo(s);
        ClassFile.ConstantNameAndTypeInfo constantNameAndTypeInfo = (ClassFile.ConstantNameAndTypeInfo)this.classFile.getConstantPoolInfo(constantPoolInfo instanceof ClassFile.ConstantInterfaceMethodrefInfo ? ((ClassFile.ConstantInterfaceMethodrefInfo)constantPoolInfo).getNameAndTypeIndex() : ((ClassFile.ConstantMethodrefInfo)constantPoolInfo).getNameAndTypeIndex());
        ClassFile.ConstantUtf8Info constantUtf8Info = (ClassFile.ConstantUtf8Info)this.classFile.getConstantPoolInfo(constantNameAndTypeInfo.getDescriptorIndex());
        String string = constantUtf8Info.getString();
        if (string.charAt(0) != '(') {
            throw new RuntimeException("Method descriptor does not start with \"(\"");
        }
        int n = 1;
        int n2 = 0;
        block7: while (true) {
            switch (string.charAt(n++)) {
                case ')': {
                    return n2 - Descriptor.size(string.substring(n));
                }
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    ++n2;
                    continue block7;
                }
                case 'D': 
                case 'J': {
                    n2 += 2;
                    continue block7;
                }
                case '[': {
                    int n3;
                    ++n2;
                    while (string.charAt(n) == '[') {
                        ++n;
                    }
                    if ("BCFISZDJ".indexOf(string.charAt(n)) != -1) {
                        ++n;
                        continue block7;
                    }
                    if (string.charAt(n) != 'L') {
                        throw new RuntimeException("Invalid char after \"[\"");
                    }
                    do {
                        n3 = ++n;
                        ++n;
                    } while (string.charAt(n3) != ';');
                    continue block7;
                }
                case 'L': {
                    ++n2;
                    while (string.charAt(n++) != ';') {
                    }
                    continue block7;
                }
            }
            break;
        }
        throw new RuntimeException("Invalid method descriptor");
    }

    private int determineFieldSize(short s) {
        ClassFile.ConstantFieldrefInfo constantFieldrefInfo = (ClassFile.ConstantFieldrefInfo)this.classFile.getConstantPoolInfo(s);
        ClassFile.ConstantNameAndTypeInfo constantNameAndTypeInfo = (ClassFile.ConstantNameAndTypeInfo)this.classFile.getConstantPoolInfo(constantFieldrefInfo.getNameAndTypeIndex());
        ClassFile.ConstantUtf8Info constantUtf8Info = (ClassFile.ConstantUtf8Info)this.classFile.getConstantPoolInfo(constantNameAndTypeInfo.getDescriptorIndex());
        return Descriptor.size(constantUtf8Info.getString());
    }

    public void fixUp() {
        Offset offset = this.beginning;
        while (offset != this.end) {
            if (offset instanceof FixUp) {
                ((FixUp)((Object)offset)).fixUp();
            }
            offset = offset.next;
        }
    }

    public void flowAnalysis(String string) {
        int n;
        byte[] byArray = new byte[0xFFFF & this.end.offset];
        Arrays.fill(byArray, (byte)-1);
        this.flowAnalysis(string, this.code, 0xFFFF & this.end.offset, 0, 0, byArray);
        int n2 = 0;
        while (n2 != this.exceptionTableEntries.size()) {
            n = 0;
            while (n < this.exceptionTableEntries.size()) {
                ExceptionTableEntry exceptionTableEntry = (ExceptionTableEntry)this.exceptionTableEntries.get(n);
                if (byArray[0xFFFF & ((ExceptionTableEntry)exceptionTableEntry).startPC.offset] != -1) {
                    this.flowAnalysis(string, this.code, 0xFFFF & this.end.offset, 0xFFFF & ((ExceptionTableEntry)exceptionTableEntry).handlerPC.offset, byArray[0xFFFF & ((ExceptionTableEntry)exceptionTableEntry).startPC.offset] + 1, byArray);
                    ++n2;
                }
                ++n;
            }
        }
        this.maxStack = 0;
        n = 0;
        while (n < byArray.length) {
            byte by = byArray[n];
            if (by == -1) {
                throw new RuntimeException(String.valueOf(string) + ": Unexamined code at offset " + n);
            }
            if (by > this.maxStack) {
                this.maxStack = by;
            }
            ++n;
        }
    }

    /*
     * Handled duff style switch with additional control
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private void flowAnalysis(String var1_1, byte[] var2_2, int var3_3, int var4_4, int var5_5, byte[] var6_6) {
        while (true) {
            if (var4_4 < 0 || var4_4 >= var3_3) {
                throw new RuntimeException(String.valueOf(var1_1) + ": Offset out of range");
            }
            var7_7 = var6_6[var4_4];
            if (var7_7 == var5_5) {
                return;
            }
            if (var7_7 == -2) {
                throw new RuntimeException(String.valueOf(var1_1) + ": Invalid offset");
            }
            if (var7_7 != -1) {
                throw new RuntimeException(String.valueOf(var1_1) + ": Operand stack inconsistent at offset " + var4_4 + ": Previous size " + var7_7 + ", now " + var5_5);
            }
            var6_6[var4_4] = (byte)var5_5;
            var8_8 = var2_2[var4_4];
            var9_9 = var4_4 + 1;
            if (var8_8 == -60) {
                var8_8 = var2_2[var9_9++];
                var10_10 = Opcode.WIDE_OPCODE_PROPERTIES[255 & var8_8];
            } else {
                var10_10 = Opcode.OPCODE_PROPERTIES[255 & var8_8];
            }
            if (var10_10 == -1) {
                throw new RuntimeException(String.valueOf(var1_1) + ": Invalid opcode " + (255 & var8_8) + " at offset " + var4_4);
            }
            switch (var10_10 & 31) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    var5_5 += (var10_10 & 31) - 4;
                    break;
                }
                case 7: {
                    var5_5 = 0;
                    break;
                }
                case 9: {
                    --var5_5;
                }
                case 10: {
                    var5_5 += this.determineFieldSize((short)((var2_2[var9_9] << 8) + (255 & var2_2[var9_9 + 1])));
                    break;
                }
                case 11: {
                    --var5_5;
                }
                case 12: {
                    var5_5 -= this.determineFieldSize((short)((var2_2[var9_9] << 8) + (255 & var2_2[var9_9 + 1])));
                    break;
                }
                case 13: 
                case 14: 
                case 16: {
                    --var5_5;
                }
                case 15: {
                    var5_5 -= this.determineArgumentsSize((short)((var2_2[var9_9] << 8) + (255 & var2_2[var9_9 + 1])));
                    break;
                }
                case 18: {
                    var5_5 -= var2_2[var9_9 + 2] - 1;
                    break;
                }
                default: {
                    throw new RuntimeException(String.valueOf(var1_1) + ": Invalid stack delta");
                }
            }
            if (var5_5 < 0) {
                var11_12 = String.valueOf(this.classFile.getThisClassName()) + '.' + var1_1 + ": Operand stack underrun at offset " + var4_4;
                throw new RuntimeException(var11_12);
            }
            if (var5_5 > 127) {
                var11_13 = String.valueOf(this.classFile.getThisClassName()) + '.' + var1_1 + ": Operand stack overflow at offset " + var4_4;
                throw new RuntimeException(var11_13);
            }
            cfr_temp_0 = -2147483648;
            block31: do {
                switch (cfr_temp_0 == -2147483648 ? var10_10 & 480 : cfr_temp_0) {
                    case 32: 
                    case 64: 
                    case 128: 
                    case 192: {
                        ++var9_9;
                        break;
                    }
                    case 96: 
                    case 160: 
                    case 224: {
                        var9_9 += 2;
                        break;
                    }
                    case 256: {
                        this.flowAnalysis(var1_1, var2_2, var3_3, var4_4 + ((var2_2[var9_9++] << 8) + (255 & var2_2[var9_9++])), var5_5, var6_6);
                        break;
                    }
                    case 384: {
                        var11_11 = var4_4 + ((var2_2[var9_9++] << 8) + (255 & var2_2[var9_9++]));
                        if (var6_6[var11_11] != -1) break block31;
                        this.flowAnalysis(var1_1, var2_2, var3_3, var11_11, var5_5 + 1, var6_6);
                        break;
                    }
                    case 288: {
                        this.flowAnalysis(var1_1, var2_2, var3_3, var4_4 + ((var2_2[var9_9++] << 24) + ((255 & var2_2[var9_9++]) << 16) + ((255 & var2_2[var9_9++]) << 8) + (255 & var2_2[var9_9++])), var5_5, var6_6);
                        break;
                    }
                    default: {
                        throw new RuntimeException(String.valueOf(var1_1) + ": Invalid OP1");
                    }
                    case 0: {
                        break;
                    }
                    while (true) {
                        cfr_temp_0 = 320;
                        ++var9_9;
                        break;
                    }
                    case 320: {
                        if ((var9_9 & 3) != 0) ** continue;
                        this.flowAnalysis(var1_1, var2_2, var3_3, var4_4 + ((var2_2[var9_9++] << 24) + ((255 & var2_2[var9_9++]) << 16) + ((255 & var2_2[var9_9++]) << 8) + (255 & var2_2[var9_9++])), var5_5, var6_6);
                        var12_14 = (var2_2[var9_9++] << 24) + ((255 & var2_2[var9_9++]) << 16) + ((255 & var2_2[var9_9++]) << 8) + (255 & var2_2[var9_9++]);
                        var13_15 = 0;
                        while (var13_15 < var12_14) {
                            var9_9 += 4;
                            this.flowAnalysis(var1_1, var2_2, var3_3, var4_4 + ((var2_2[var9_9++] << 24) + ((255 & var2_2[var9_9++]) << 16) + ((255 & var2_2[var9_9++]) << 8) + (255 & var2_2[var9_9++])), var5_5, var6_6);
                            ++var13_15;
                        }
                        break block31;
                    }
                    while (true) {
                        cfr_temp_0 = 352;
                        ++var9_9;
                        break;
                    }
                    case 352: {
                        if ((var9_9 & 3) != 0) ** continue;
                        this.flowAnalysis(var1_1, var2_2, var3_3, var4_4 + ((var2_2[var9_9++] << 24) + ((255 & var2_2[var9_9++]) << 16) + ((255 & var2_2[var9_9++]) << 8) + (255 & var2_2[var9_9++])), var5_5, var6_6);
                        var13_15 = (var2_2[var9_9++] << 24) + ((255 & var2_2[var9_9++]) << 16) + ((255 & var2_2[var9_9++]) << 8) + (255 & var2_2[var9_9++]);
                        var14_16 = (var2_2[var9_9++] << 24) + ((255 & var2_2[var9_9++]) << 16) + ((255 & var2_2[var9_9++]) << 8) + (255 & var2_2[var9_9++]);
                        var15_17 = var13_15;
                        while (var15_17 <= var14_16) {
                            this.flowAnalysis(var1_1, var2_2, var3_3, var4_4 + ((var2_2[var9_9++] << 24) + ((255 & var2_2[var9_9++]) << 16) + ((255 & var2_2[var9_9++]) << 8) + (255 & var2_2[var9_9++])), var5_5, var6_6);
                            ++var15_17;
                        }
                        break block31;
                    }
                }
                break;
            } while (true);
            switch (var10_10 & 1536) {
                case 512: {
                    ++var9_9;
                    break;
                }
                case 1024: {
                    var9_9 += 2;
                    break;
                }
                default: {
                    throw new RuntimeException(String.valueOf(var1_1) + ": Invalid OP2");
                }
                case 0: 
            }
            switch (var10_10 & 2048) {
                case 2048: {
                    ++var9_9;
                    break;
                }
                default: {
                    throw new RuntimeException(String.valueOf(var1_1) + ": Invalid OP3");
                }
                case 0: 
            }
            Arrays.fill(var6_6, var4_4 + 1, var9_9, (byte)-2);
            if ((var10_10 & -32768) != 0) {
                return;
            }
            var4_4 = var9_9;
        }
    }

    public ClassFile getClassFile() {
        return this.classFile;
    }

    public Inserter newInserter() {
        Inserter inserter = new Inserter();
        inserter.set();
        return inserter;
    }

    public Offset newOffset() {
        Offset offset = new Offset();
        offset.set();
        return offset;
    }

    public void popInserter() {
        Inserter inserter = this.currentInserter.nextInserter;
        if (inserter == null) {
            throw new RuntimeException("Code inserter stack underflow");
        }
        this.currentInserter.nextInserter = null;
        this.currentInserter = inserter;
    }

    public void pushInserter(Inserter inserter) {
        if (inserter.nextInserter != null) {
            throw new RuntimeException("An Inserter can only be pushed once at a time");
        }
        inserter.nextInserter = this.currentInserter;
        this.currentInserter = inserter;
    }

    public void relocate() {
        int n = 0;
        while (n < this.relocatables.size()) {
            ((Relocatable)this.relocatables.get(n)).relocate();
            ++n;
        }
    }

    public void restoreLocalVariables() {
        this.localVariableArrayLength = (Short)this.savedLocalVariableArrayLengths.pop();
    }

    public void saveLocalVariables() {
        this.savedLocalVariableArrayLengths.push(new Short(this.localVariableArrayLength));
    }

    protected void storeCodeAttributeBody(DataOutputStream dataOutputStream, short s) throws IOException {
        Object object;
        Object object2;
        Object object3;
        dataOutputStream.writeShort(this.maxStack);
        dataOutputStream.writeShort(this.maxLocals);
        dataOutputStream.writeInt(0xFFFF & this.end.offset);
        dataOutputStream.write(this.code, 0, 0xFFFF & this.end.offset);
        dataOutputStream.writeShort(this.exceptionTableEntries.size());
        int n = 0;
        while (n < this.exceptionTableEntries.size()) {
            object3 = (ExceptionTableEntry)this.exceptionTableEntries.get(n);
            dataOutputStream.writeShort(((ExceptionTableEntry)object3).startPC.offset);
            dataOutputStream.writeShort(((ExceptionTableEntry)object3).endPC.offset);
            dataOutputStream.writeShort(((ExceptionTableEntry)object3).handlerPC.offset);
            dataOutputStream.writeShort(((ExceptionTableEntry)object3).catchType);
            ++n;
        }
        object3 = new ArrayList();
        if (s != 0) {
            object2 = new ArrayList();
            object = this.beginning;
            while (object != null) {
                if (object instanceof LineNumberOffset) {
                    object2.add(new ClassFile.LineNumberTableAttribute.Entry(((Offset)object).offset, ((LineNumberOffset)object).lineNumber));
                }
                object = ((Offset)object).next;
            }
            ClassFile.LineNumberTableAttribute.Entry[] entryArray = object2.toArray(new ClassFile.LineNumberTableAttribute.Entry[object2.size()]);
            object3.add(new ClassFile.LineNumberTableAttribute(s, entryArray));
        }
        dataOutputStream.writeShort(object3.size());
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (ClassFile.AttributeInfo)object2.next();
            ((ClassFile.AttributeInfo)object).store(dataOutputStream);
        }
    }

    public void write(short s, byte[] byArray) {
        Object object;
        block8: {
            if (byArray.length == 0) {
                return;
            }
            if (s != -1) {
                Offset offset = this.currentInserter.prev;
                while (offset != this.beginning) {
                    if (offset instanceof LineNumberOffset) {
                        if (((LineNumberOffset)offset).lineNumber != s) break;
                        break block8;
                    }
                    offset = offset.prev;
                }
                object = new LineNumberOffset(this.currentInserter.offset, s);
                ((Offset)object).prev = this.currentInserter.prev;
                ((Offset)object).next = this.currentInserter;
                this.currentInserter.prev.next = object;
                this.currentInserter.prev = object;
            }
        }
        int n = 0xFFFF & this.currentInserter.offset;
        if ((0xFFFF & this.end.offset) + byArray.length <= this.code.length) {
            System.arraycopy(this.code, n, this.code, n + byArray.length, (0xFFFF & this.end.offset) - n);
        } else {
            object = this.code;
            this.code = new byte[this.code.length + 128];
            if (this.code.length >= 65535) {
                throw new RuntimeException("Code attribute in class \"" + this.classFile.getThisClassName() + "\" grows beyond 64 KB");
            }
            System.arraycopy(object, 0, this.code, 0, n);
            System.arraycopy(object, n, this.code, n + byArray.length, (0xFFFF & this.end.offset) - n);
        }
        System.arraycopy(byArray, 0, this.code, n, byArray.length);
        object = this.currentInserter;
        while (object != null) {
            ((Offset)object).offset = (short)(((Offset)object).offset + byArray.length);
            object = ((Offset)object).next;
        }
    }

    public void writeBranch(short s, int n, Offset offset) {
        this.relocatables.add(new Branch(this.newOffset(), offset));
        this.write(s, new byte[]{(byte)n, -1, -1});
    }

    public void writeOffset(short s, Offset offset, Offset offset2) {
        this.relocatables.add(new OffsetBranch(this.newOffset(), offset, offset2));
        this.write(s, new byte[]{-1, -1, -1, -1});
    }

    public void writeShort(short s, int n) {
        this.write(s, new byte[]{(byte)(n >> 8), (byte)n});
    }

    private class Branch
    extends Relocatable {
        private final Offset source;
        private final Offset destination;

        public Branch(Offset offset, Offset offset2) {
            this.source = offset;
            this.destination = offset2;
        }

        public void relocate() {
            if (this.destination.offset == -1) {
                throw new RuntimeException("Cannot relocate branch to unset destination offset");
            }
            int n = this.destination.offset - this.source.offset;
            if (n > Short.MAX_VALUE || n < Short.MIN_VALUE) {
                throw new RuntimeException("Branch offset out of range");
            }
            byte[] byArray = new byte[]{(byte)(n >> 8), (byte)n};
            System.arraycopy(byArray, 0, CodeContext.this.code, (0xFFFF & this.source.offset) + 1, 2);
        }
    }

    private class OffsetBranch
    extends Relocatable {
        private final Offset where;
        private final Offset source;
        private final Offset destination;

        public OffsetBranch(Offset offset, Offset offset2, Offset offset3) {
            this.where = offset;
            this.source = offset2;
            this.destination = offset3;
        }

        public void relocate() {
            if (this.source.offset == -1 || this.destination.offset == -1) {
                throw new RuntimeException("Cannot relocate offset branch to unset destination offset");
            }
            int n = this.destination.offset - this.source.offset;
            byte[] byArray = new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
            System.arraycopy(byArray, 0, CodeContext.this.code, 0xFFFF & this.where.offset, 4);
        }
    }

    public class Offset {
        short offset = (short)-1;
        Offset prev = null;
        Offset next = null;
        static final short UNSET = -1;

        public final CodeContext getCodeContext() {
            return CodeContext.this;
        }

        public void set() {
            if (this.offset != -1) {
                throw new RuntimeException("Cannot \"set()\" Offset more than once");
            }
            this.offset = ((CodeContext)CodeContext.this).currentInserter.offset;
            this.prev = ((CodeContext)CodeContext.this).currentInserter.prev;
            this.next = CodeContext.this.currentInserter;
            this.prev.next = this;
            this.next.prev = this;
        }

        public String toString() {
            return String.valueOf(CodeContext.this.classFile.getThisClassName()) + ": " + (0xFFFF & this.offset);
        }
    }

    private static class ExceptionTableEntry {
        private final Offset startPC;
        private final Offset endPC;
        private final Offset handlerPC;
        private final short catchType;

        public ExceptionTableEntry(Offset offset, Offset offset2, Offset offset3, short s) {
            this.startPC = offset;
            this.endPC = offset2;
            this.handlerPC = offset3;
            this.catchType = s;
        }
    }

    public class Inserter
    extends Offset {
        private Inserter nextInserter = null;
    }

    public class LineNumberOffset
    extends Offset {
        private final short lineNumber;

        public LineNumberOffset(short s, short s2) {
            this.lineNumber = s2;
            this.offset = s;
        }
    }

    private abstract class Relocatable {
        Relocatable() {
        }

        public abstract void relocate();
    }

    public static interface FixUp {
        public void fixUp();
    }
}

