------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                     Copyright (C) 2002-2009, AdaCore                     --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
------------------------------------------------------------------------------

package body AWS.Resources.Streams is

   ------------
   -- Create --
   ------------

   procedure Create
     (Resource : out File_Type;
      Stream   : Stream_Access) is
   begin
      Resource := File_Type (Stream);
   end Create;

   ----------
   -- Name --
   ----------

   function Name (Resource : Stream_Type) return String is
      pragma Unreferenced (Resource);
   begin
      return "";
   end Name;

   ----------
   -- Size --
   ----------

   overriding function Size
     (Resource : Stream_Type) return Stream_Element_Offset
   is
      pragma Unreferenced (Resource);
   begin
      return Undefined_Length;
   end Size;

end AWS.Resources.Streams;
