/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;


/**
 * An XML attribute with namespace information.
 *
 * @author Elias Ross
 * @version 1.0
 */
public class AttributeNS
	extends Attribute
{

	private String namespaceURI;
	private String prefix;
	private String localName;

	/**
	 * Constructs an XML attribute with a namespace.
	 * Fields from the given interface are copied internally.
	 * @param namespace Attribute namespace
	 * @param value Attribute value
	 */
	public AttributeNS(Namespace namespace, String value)
	{
		this(namespace.getName(), value, 
			namespace.getNamespaceURI(), 
			namespace.getPrefix(),
			namespace.getLocalName());
	}

	/**
	 * Constructs an XML attribute with a namespace.
	 * @param name Name of element, minus prefix
	 * @param value Attribute value
	 * @param namespaceURI Attribute namespace
	 * @param prefix Attribute namespace prefix
	 */
	public AttributeNS(String name, String value, String namespaceURI, String prefix, String localName)
	{
		super(name, value);
		this.namespaceURI = namespaceURI;
		this.prefix = prefix;
		this.localName = localName;
	}

	/**
	 * Returns the namespace of this Attribute, or null if this
	 * attribute belongs to no particular namespace.
	 */
	public String getNamespaceURI() {
		return namespaceURI;
	}

	/**
	 * Returns the namespace of this Attribute, or null if this
	 * attribute belongs to no particular namespace.
	 */
	public String getPrefix() {
		return prefix;
	}

	/**
	 * Returns the local name of this Attribute.
	 */
	public String getLocalName() {
		return localName;
	}

}
