/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;

import java.util.HashMap;
import java.util.Map;

/** 
 * Maps String prefixes to URI's, and
 * maintains the current default namespace in use.
 */
public class UriMap
{
	private Map<String, String> map;
	// private String defaultNamespace;

	/**
	 * Constructs a URI map with no contents.
	 */
	public UriMap() {
		map = new HashMap<String, String>();
	}

	/**
	 * Constructs a URI map wrapping a Map.
	 */
	public UriMap(Map<String, String> map) {
		if (map == null)
			throw new IllegalArgumentException("null map");
		this.map = map;
	}

	/*
	 * Returns either the default namespace URI, or null if
	 * unspecified.
	public String getDefaultNamespace() {
		return defaultNamespace;
	}
	 */

	/*
	 * Sets either the default namespace URI, may be null if
	 * unspecified.
	public void setDefaultNamespace(String defaultNamespace) {
		this.defaultNamespace = defaultNamespace;
	}
	 */

	/**
	 * Returns the appropriate URI for the given prefix.
	 * If the prefix is not found, returns the default namespace.
	 */
	public String get(String prefix) {
		if (prefix == null)
			throw new IllegalArgumentException("null prefix");
		if (map == null)
			return null;
		return map.get(prefix);
	}

	/**
	 * Sets the mapping of a prefix to a URI.
	 */
	public void put(String prefix, String uri) {
		if (prefix == null)
			throw new IllegalArgumentException("null prefix");
		if (map == null)
			map = new HashMap<String, String>();
		map.put(prefix, uri);
	}

	/**
	 * Clears all URI mappings.
	 */
	public void clear() {
		if (map == null)
			return;
		map.clear();
	}

	/**
	 * Returns a string representation of this URIMap.
	 */
	@Override
	public String toString() {
		return "URIMap map=" + map;
	}

}

