/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.xmlrpc;

/**
 * The Xml-Rpc server uses this interface to call a method of an Rpc
 * handler. This should be implemented by any class that wants to
 * directly take control when it is called over Rpc. Classes not
 * implementing this interface will be wrapped into an Invoker object
 * that tries to find the matching method for an Xml-Rpc request. 
 * <p>
 * @author Elias Ross
 * @version 1.0
 * @see Invoker Using <code>Invoker</code> to wrap an existing object
 */ 

public interface XmlRpcHandler 
{
	/**
	 * Handle a Xml-Rpc request.
	 * @param method Method name
	 * @param params Iterator over the parameters
	 * @return parameter(s) to return
	 * @throws XmlRpcException with Xml-Rpc specific exception, or a
	 * wrapped exception
	 */
	ParamIterator execute(String method, ParamIterator params)
		throws XmlRpcException;
} 
