with Ada.Exceptions;
with Ada.Strings.Unbounded; use Ada.Strings.Unbounded;
with Ada.Text_IO;
with File_IO;
with GNATCOLL.JSON;

procedure JSON_Stack_Test is

   task T is
      pragma Storage_Size (2_000_000);
      entry E (Filename : String);
   end T;

   task body T is
   begin
      Main_Loop : loop
         select
            accept E (Filename : String) do

               begin
                  Ada.Text_IO.Put_Line ("");
                  Ada.Text_IO.Put_Line (Filename);

                  declare
                     JSON_Data : Unbounded_String := File_IO.Read_File (Filename);
                  begin
                     declare
                        Value : GNATCOLL.JSON.JSON_Value :=
                          GNATCOLL.JSON.Read
                          (Strm     => JSON_Data,
                           Filename => Filename);
                     begin
                        declare
                           New_JSON_Data : constant Unbounded_String :=
                             GNATCOLL.JSON.Write (Item => Value, Compact => False);
                        begin
                           File_IO.Write_File
                             (File_Name     => "json/out.json",
                              File_Contents => New_JSON_Data);
                        end;
                     end;
                  end;

               exception
                  when E : others =>
                     Ada.Text_IO.Put_Line
                       (Ada.Exceptions.Exception_Information (E));
               end;
            end E;

         or
            terminate;
         end select;
      end loop Main_Loop;
   end T;

begin
   T.E (Filename => "json/1.json");
   T.E (Filename => "json/2.json");
   T.E (Filename => "json/3.json");
   T.E (Filename => "json/4.json");
   T.E (Filename => "json/5.json");
   T.E (Filename => "json/6.json");
end JSON_Stack_Test;
