with GNATCOLL.Terminal;   use GNATCOLL.Terminal;
with Ada.Text_IO;         use Ada.Text_IO;

procedure Test_Colors is
   Info : Terminal_Info;

   procedure Header (Name : String; Fg : ANSI_Color);
   procedure Header (Name : String; Fg : ANSI_Color) is
   begin
      Info.Set_Color (Standard_Output, Fg, Reset, Normal);
      Put (Name);
   end Header;

   procedure Show (Name : String; Bg : ANSI_Color);
   procedure Show (Name : String; Bg : ANSI_Color) is
   begin
      Info.Set_Color (Standard_Output, Reset, Bg, Normal);
      Put (Name);

      for Fg in Black .. Grey loop 
         Info.Set_Color (Standard_Output, Fg, Bg, Normal);
         Put ("X ");
         Info.Set_Color (Standard_Output, Style => Dim);
         Put ("X ");
         Info.Set_Color (Standard_Output, Style => Bright);
         Put ("X ");
         Info.Set_Color (Standard_Output, Style => Reset_All);
         Put (" ");
      end loop;

      New_Line;
   end Show;

   procedure Put_No_Overflow (Str : String);
   --  Display the string, but truncates it to the width of the screen

   procedure Put_No_Overflow (Str : String) is
      Width : constant Integer := Info.Get_Width;
   begin
      if Width = -1 then
         Put (Str);
      else
         Put (Str (Str'First .. Integer'Min (Str'Last, Width)));
      end if;
   end Put_No_Overflow;

begin
   Info.Init_For_Stdout (Auto);

   Header ("        ", Reset);
   Header ("black  ", Black);
   Header ("red    ", Red);
   Header ("green  ", Green);
   Header ("yellow ", Yellow);
   Header ("blue   ", Blue);
   Header ("magenta", Magenta);
   Header ("cyan   ", Cyan);
   Header ("white  ", Grey);
   New_Line;

   Show ("black   ", Black);
   Show ("red     ", Red);
   Show ("green   ", Green);
   Show ("yellow  ", Yellow);
   Show ("blue    ", Blue);
   Show ("magenta ", Magenta);
   Show ("cyan    ", Cyan);
   Show ("white   ", Grey);

   for J in 1 .. 1_000 loop
      if J mod 10 = 0 then
         Put_No_Overflow ("Processing file" & J'Img & " with long name");
      elsif J mod 5 = 0 then
         Put_No_Overflow
            ("Some very long string, much larger than the actual size of the"
             & " terminal, in theory, although some people use large windows");
      else
         Put ("Processing file" & J'Img);
      end if;
      delay 0.1;
      Info.Beginning_Of_Line;
      Info.Clear_To_End_Of_Line;
   end loop;
end Test_Colors;
