/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class Base64EncodeStream
extends FilterOutputStream {
    private static final int BASE = 64;
    private static final int[] POW_64 = new int[]{262144, 4096, 64, 1};
    private static final char[] CHAR_MAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private boolean closed;
    private final byte[] data = new byte[3];
    private int dataSize;
    private final byte[] encoded = new byte[4];

    public Base64EncodeStream(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public void write(int n) throws IOException {
        if (this.closed) {
            return;
        }
        if (this.dataSize == this.data.length) {
            this.writeChunk();
            this.dataSize = 0;
        }
        this.data[this.dataSize++] = (byte)(n & 0xFF);
    }

    private void writeChunk() throws IOException {
        if (this.dataSize == 0) {
            return;
        }
        long l = Base64EncodeStream.toUInt32(this.data, this.dataSize);
        int n = this.data.length - this.dataSize;
        int n2 = this.encodeChunk(l, n);
        this.out.write(this.encoded, 0, n2);
    }

    private static long toUInt32(byte[] byArray, int n) {
        long l = 0L;
        int n2 = (3 - n) * 8;
        for (int i = n - 1; i >= 0; --i) {
            l |= (long)((byArray[i] & 0xFF) << n2);
            n2 += 8;
        }
        return Base64EncodeStream.toUnsignedInt(l);
    }

    private static long toUnsignedInt(long l) {
        return l & 0xFFFFFFFFL;
    }

    private int encodeChunk(long l, int n) {
        Arrays.fill(this.encoded, (byte)61);
        int n2 = this.encoded.length - n;
        for (int i = 0; i < n2; ++i) {
            this.encoded[i] = (byte)CHAR_MAP[(int)(l / (long)POW_64[i] % 64L)];
        }
        return this.encoded.length;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.writeChunk();
        super.close();
        this.closed = true;
    }
}

