/* ----- core/invsntrup653, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_invsntrup653_checksums[] = {
  "783437aa0948fbed0301273c0cd5c08de5d3cd1cec0b5ee2e4794efee2bdbc6c",
  "f7eec5214a2b2c85244e55ffc91787ecbd8c7e8c501ac4f01e4375c7c401e222",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_invsntrup653_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_invsntrup653_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_invsntrup653_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_invsntrup653_CONSTBYTES

static void *storage_core_invsntrup653_h;
static unsigned char *test_core_invsntrup653_h;
static void *storage_core_invsntrup653_n;
static unsigned char *test_core_invsntrup653_n;
static void *storage_core_invsntrup653_k;
static unsigned char *test_core_invsntrup653_k;
static void *storage_core_invsntrup653_c;
static unsigned char *test_core_invsntrup653_c;
static void *storage_core_invsntrup653_h2;
static unsigned char *test_core_invsntrup653_h2;
static void *storage_core_invsntrup653_n2;
static unsigned char *test_core_invsntrup653_n2;
static void *storage_core_invsntrup653_k2;
static unsigned char *test_core_invsntrup653_k2;
static void *storage_core_invsntrup653_c2;
static unsigned char *test_core_invsntrup653_c2;

#define precomputed_core_invsntrup653_NUM 4

static const unsigned char precomputed_core_invsntrup653_h[precomputed_core_invsntrup653_NUM][crypto_core_OUTPUTBYTES] = {
  {137,1,73,7,39,250,250,3,220,8,48,251,172,253,70,1,34,8,118,253,136,7,119,254,19,255,52,1,240,248,28,251,44,252,134,4,56,5,158,5,126,3,45,249,180,251,203,2,100,4,101,252,53,254,13,247,140,4,178,1,79,8,165,252,54,253,125,251,168,252,250,247,152,250,252,255,216,4,224,5,43,249,149,3,242,7,26,248,111,249,207,2,197,1,28,255,86,8,2,249,236,4,182,253,152,250,119,3,67,7,60,7,103,1,232,247,41,251,143,250,80,249,224,249,241,250,235,0,38,4,234,0,221,254,83,250,112,2,167,254,215,250,126,7,248,249,135,252,50,250,204,251,65,0,93,247,240,3,26,252,159,253,196,251,3,5,242,251,104,2,237,3,179,252,56,255,230,252,92,4,167,0,219,251,242,250,51,0,171,247,36,249,197,247,63,5,204,0,202,253,103,247,197,3,78,4,125,250,161,248,213,252,220,8,62,254,230,4,229,5,173,250,63,8,35,3,20,5,107,6,200,252,13,254,4,248,194,5,20,3,17,252,44,2,201,3,125,254,156,3,247,0,95,2,77,249,219,248,255,255,249,5,218,249,173,8,125,252,108,6,173,8,179,8,12,252,12,247,114,8,60,3,118,1,154,250,5,249,82,0,12,6,62,252,172,5,72,2,130,7,196,1,85,1,162,4,127,8,41,7,103,250,244,7,70,3,121,252,221,247,190,0,156,2,128,4,9,5,215,4,33,1,161,255,59,1,216,0,208,1,221,0,224,254,90,252,221,255,107,0,161,6,242,255,20,247,111,250,83,252,200,253,24,249,109,255,132,252,10,248,164,250,172,3,232,2,54,2,92,248,117,247,198,8,181,2,223,250,54,247,236,247,102,251,101,4,189,252,153,248,30,6,119,251,49,254,122,252,96,249,210,2,53,3,164,0,84,252,46,4,206,255,53,8,62,1,239,4,177,8,220,6,229,6,129,8,148,249,232,2,136,253,187,253,15,2,31,0,147,253,127,255,202,5,123,247,250,2,165,255,7,7,20,255,243,1,43,0,178,252,81,247,222,3,158,0,102,251,209,248,241,254,71,8,221,3,240,7,204,0,231,1,48,0,130,0,248,251,106,251,105,4,139,254,247,4,191,251,71,0,213,7,193,252,134,2,137,254,238,255,225,4,202,6,171,255,252,6,64,5,141,247,152,250,184,2,201,250,162,4,145,248,200,5,222,248,236,7,39,247,97,255,206,247,43,253,191,4,135,251,152,3,95,247,94,247,229,253,206,248,156,3,26,253,3,8,78,5,191,2,222,251,43,253,159,253,171,253,104,253,143,0,120,4,116,250,192,249,149,2,27,3,16,3,190,253,244,247,60,249,175,251,208,251,112,6,230,249,253,251,123,250,158,255,15,6,235,253,36,6,201,254,229,7,254,2,62,8,127,7,170,4,231,255,112,5,241,248,111,4,202,4,155,255,205,251,223,251,182,5,176,248,206,3,246,248,153,5,117,254,255,255,89,2,93,249,180,6,145,3,5,1,201,248,154,8,60,249,31,247,39,3,191,253,28,8,56,0,24,250,63,3,55,249,75,251,232,2,14,250,230,252,100,247,251,5,114,250,50,5,158,6,145,254,24,4,116,0,103,248,219,249,118,251,121,0,87,252,143,6,152,3,240,6,129,254,125,252,236,3,160,252,120,251,59,248,224,251,195,250,46,252,36,250,248,4,13,7,226,4,197,7,161,250,223,252,140,8,149,5,31,255,50,255,126,2,213,3,234,6,246,1,193,3,132,2,101,5,138,255,249,249,179,8,37,247,89,0,241,4,155,8,247,5,161,252,43,2,219,8,130,1,15,248,237,3,243,252,216,7,102,250,154,250,114,6,172,255,247,249,75,3,3,250,11,8,70,3,207,5,36,0,173,250,37,3,97,2,69,0,204,247,192,253,239,0,31,3,11,8,101,251,197,2,154,247,72,8,108,8,80,248,193,252,131,248,149,7,82,252,241,248,27,253,54,250,132,0,78,4,29,6,247,249,19,0,148,7,93,250,157,253,83,249,237,0,35,255,14,6,220,3,187,5,84,8,202,252,156,2,211,255,159,253,166,7,181,252,180,252,245,252,167,7,67,253,247,6,108,248,248,6,100,253,113,248,210,254,101,0,60,1,40,253,21,250,67,5,45,7,145,250,102,1,69,6,32,2,156,254,205,249,38,1,16,4,211,253,65,2,219,248,239,250,40,2,46,2,178,7,134,250,90,248,132,247,185,4,157,5,182,255,115,2,1,247,252,254,169,250,187,6,221,254,204,5,99,248,193,251,141,6,62,0,203,7,175,253,89,248,108,251,180,0,60,249,209,1,63,248,167,4,169,248,74,248,92,4,180,8,97,254,67,0,44,251,152,1,163,0,138,1,113,250,138,252,71,6,68,6,180,250,221,7,253,3,108,1,236,248,107,251,167,248,181,252,49,6,37,1,92,6,21,250,138,247,92,2,220,255,13,250,59,7,24,247,176,247,96,255,128,0,209,6,190,251,163,4,226,8,227,5,254,246,138,7,182,249,197,2,249,249,158,3,213,7,191,1,199,4,41,5,29,6,46,255,75,3,138,4,61,6,253,253,217,7,34,3,207,3,108,7,111,2,156,252,40,247,117,0,0,252,42,255,175,0,21,5,205,8,252,0,130,0,20,8,153,255,156,252,14,253,39,2,194,1,223,253,32,253,216,251,70,2,231,8,117,254,90,5,122,254,84,250,50,7,98,253,222,252,213,255,204,1,157,254,23,251,50,1,143,254,174,7,171,1,170,8,244,6,101,0,73,250,207,255,16,247,112,250,37,247,70,248,174,253,138,255,255,3,206,255,61,5,129,8,107,3,67,2,255,253,124,6,213,5,241,251,239,253,124,0,219,2,206,8,199,248,163,4,227,4,21,254,175,249,0},
  {19,252,187,1,169,254,232,247,47,5,42,4,165,7,141,3,229,2,208,4,237,7,177,5,175,250,44,250,238,8,180,249,19,254,182,2,210,250,5,9,211,0,145,4,121,2,69,251,11,250,79,252,116,7,78,4,172,5,122,6,112,254,67,5,169,3,200,255,32,248,22,248,103,4,23,247,141,1,169,253,171,251,46,249,146,253,215,254,246,1,145,0,200,4,95,6,196,252,12,255,47,4,91,2,128,6,210,249,209,252,178,250,137,247,252,248,61,253,109,2,70,248,83,5,27,247,79,253,181,6,54,5,19,8,105,2,169,3,129,6,212,8,127,7,233,1,252,0,161,248,239,247,89,4,214,252,133,253,222,251,226,249,107,253,71,254,62,254,71,8,16,2,65,1,18,2,39,254,113,249,119,254,71,6,207,3,161,249,220,7,242,248,21,8,112,4,198,8,175,2,246,3,98,7,39,252,20,254,0,3,237,2,253,250,12,7,210,250,6,7,224,252,109,254,80,6,174,4,98,248,154,7,237,253,143,249,35,6,118,2,192,2,230,248,198,8,218,4,202,247,155,4,55,1,213,5,184,0,37,251,180,7,221,5,53,248,195,251,211,2,132,7,162,2,68,6,201,254,16,254,150,254,185,251,101,4,244,248,150,7,253,0,158,250,166,254,13,7,193,252,47,8,18,3,87,6,14,8,60,249,4,9,146,7,160,2,94,253,31,1,116,253,190,250,92,254,32,4,56,7,52,8,119,247,135,252,226,249,245,5,68,248,210,1,73,2,239,8,108,249,83,255,50,251,17,0,103,7,168,1,12,5,100,8,131,255,26,247,154,4,125,252,50,252,65,6,130,3,152,2,46,255,222,255,40,0,237,2,205,6,119,254,63,249,135,0,172,250,232,252,119,0,62,248,207,247,37,247,182,251,66,4,40,251,21,248,90,5,103,250,226,6,253,254,246,254,226,3,172,6,45,0,185,7,130,248,227,254,59,248,226,249,180,2,205,255,132,4,104,8,25,4,247,248,193,252,1,252,249,255,174,249,126,0,29,8,224,5,172,254,220,251,180,255,39,255,147,250,160,7,223,4,55,253,246,4,221,5,24,2,172,7,54,4,178,7,78,253,207,8,47,250,51,6,161,250,36,1,105,7,107,248,19,250,36,3,235,8,195,249,149,251,56,247,195,254,179,255,152,8,65,7,68,3,97,6,67,5,136,4,125,251,60,7,184,251,198,7,133,247,103,247,141,7,193,247,174,2,23,5,222,247,21,1,161,1,42,251,46,2,167,255,211,255,48,5,201,2,17,253,158,249,20,248,186,250,68,251,253,0,17,5,228,248,42,8,136,253,9,253,130,251,11,0,29,2,28,6,7,4,121,253,197,253,165,1,242,5,255,252,238,254,195,253,66,252,95,252,235,254,220,3,138,6,8,250,171,253,23,254,131,1,192,253,244,254,148,254,147,249,90,251,244,6,81,0,201,253,96,2,18,4,84,2,209,1,152,254,49,250,213,255,252,248,124,1,121,248,198,255,132,0,89,253,104,7,184,250,31,2,113,6,164,249,23,247,79,8,167,2,103,8,148,255,55,249,62,254,4,255,112,249,103,251,6,0,244,254,152,8,40,3,254,3,231,250,152,6,212,7,80,251,167,247,48,4,207,252,148,7,20,5,212,7,100,4,207,250,205,6,56,253,183,4,19,247,81,250,20,7,226,249,66,5,137,255,187,247,121,4,167,0,163,255,176,6,91,4,236,8,113,255,174,255,103,7,185,251,150,252,77,6,139,5,194,254,211,252,167,5,242,8,18,1,168,255,233,251,35,252,120,252,9,255,151,250,184,254,82,0,113,5,64,248,73,6,17,253,87,255,18,255,64,5,255,5,214,6,129,6,77,248,252,254,96,8,209,1,175,7,199,253,97,248,17,6,21,247,31,253,127,253,250,249,51,249,237,8,192,2,161,4,230,5,162,247,249,1,102,6,19,253,53,0,235,0,8,1,145,251,180,2,192,5,129,0,88,254,161,0,190,2,147,247,185,0,40,3,220,4,152,253,44,8,121,252,177,247,68,5,126,251,207,5,65,255,172,252,160,8,196,251,243,0,54,248,180,6,173,249,163,252,39,6,83,2,38,1,170,250,39,253,242,250,210,4,159,3,248,249,78,252,23,8,7,7,17,3,109,4,169,247,128,6,163,3,6,254,54,252,167,248,244,3,169,0,77,254,121,255,140,1,136,255,49,2,16,253,48,1,157,253,41,3,133,1,185,250,212,6,124,247,87,1,111,7,157,0,161,255,204,2,173,0,66,254,173,5,214,4,185,250,110,6,12,251,194,7,76,253,134,251,171,7,179,7,38,250,217,4,10,4,58,250,237,2,7,255,191,255,10,5,53,247,90,6,163,3,110,247,208,5,160,2,173,248,137,250,198,0,7,4,31,0,70,8,233,252,197,7,2,5,162,1,221,248,140,0,221,5,223,3,81,1,86,2,237,2,136,247,42,6,199,1,70,254,179,251,38,249,83,253,200,0,73,1,236,253,122,250,64,252,33,252,158,3,9,253,213,249,6,255,12,7,152,248,223,253,165,6,254,8,122,1,125,247,82,252,8,249,215,254,105,247,86,250,47,4,189,252,195,3,51,8,43,249,140,7,32,252,84,1,34,250,87,251,220,249,35,254,85,251,222,249,254,5,75,249,193,250,22,250,243,2,47,4,3,4,19,0,207,3,112,253,40,253,203,250,91,251,123,7,113,1,202,255,37,255,221,250,133,0,124,2,216,3,70,6,24,251,101,2,7,5,135,7,128,3,210,254,55,252,51,254,20,1,64,249,108,4,18,248,98,8,58,5,73,7,21,3,43,249,35,7,224,248,84,3,237,5,155,247,78,248,94,1,30,248,160,255,54,8,121,5,165,4,33,6,74,2,37,255,186,5,176,251,0},
  {90,248,62,253,107,5,192,251,143,251,113,3,248,1,53,250,86,252,169,254,69,7,16,1,136,4,143,2,181,2,70,247,62,4,209,254,244,5,193,3,195,254,121,4,84,2,215,255,107,5,125,0,1,7,241,254,95,247,110,255,167,5,166,254,64,1,98,249,6,253,230,0,64,251,249,7,146,2,65,2,105,5,96,248,88,1,145,2,252,0,217,249,222,249,35,252,148,2,141,248,70,4,92,2,242,8,236,255,134,254,44,6,151,8,63,254,4,252,145,250,73,254,163,251,10,249,23,251,142,4,200,253,180,0,133,0,162,247,136,253,146,3,229,252,18,248,69,247,165,7,68,251,66,8,30,0,178,3,148,3,129,254,162,2,35,0,242,251,153,250,124,255,207,0,70,251,87,5,100,253,241,3,70,254,60,255,83,0,221,1,254,7,25,3,149,1,133,248,191,249,85,1,138,7,169,248,156,254,236,2,48,254,208,6,8,6,127,7,20,251,173,248,81,5,71,7,87,251,165,3,75,6,6,248,96,2,164,0,193,249,214,253,245,6,137,5,153,8,112,254,15,248,189,6,115,247,194,255,126,1,187,8,176,247,211,251,125,250,24,5,136,7,92,251,77,249,216,254,177,0,79,250,116,254,15,249,223,2,200,1,215,1,51,250,39,247,210,7,135,8,111,2,203,252,11,251,150,2,80,0,98,0,3,6,68,1,220,1,228,250,128,7,75,248,198,2,155,3,86,5,205,6,7,253,61,6,154,0,87,0,96,2,159,3,14,250,74,250,164,4,133,252,252,4,248,252,95,249,236,2,110,255,137,8,210,7,129,255,172,250,143,247,200,1,37,7,37,4,128,251,33,1,165,251,218,252,240,253,7,251,160,251,244,6,207,247,83,1,235,250,128,249,45,249,141,254,122,254,207,253,181,247,233,2,253,254,225,8,209,0,222,250,35,252,138,6,213,250,185,254,61,252,141,254,187,3,156,1,240,1,37,250,46,3,101,6,193,4,121,5,48,2,218,252,148,0,206,2,151,253,182,254,65,250,145,1,58,8,101,5,29,252,225,6,143,255,134,255,235,253,50,0,222,8,16,247,121,2,128,253,148,248,152,2,222,3,153,250,13,5,140,4,59,250,40,249,85,6,103,1,136,250,83,8,127,254,76,251,140,6,74,248,157,253,240,249,50,250,190,247,32,249,126,3,188,251,251,251,197,255,190,250,190,3,74,3,195,8,47,8,208,252,11,8,193,4,41,253,79,6,129,248,13,1,165,2,217,251,250,254,118,250,169,1,126,249,99,1,59,250,135,254,46,250,34,253,100,4,32,252,97,247,26,250,74,249,43,253,61,253,55,0,124,251,4,255,29,253,173,253,216,2,135,255,102,254,205,252,97,6,120,250,17,6,126,0,255,4,41,4,203,253,32,2,56,4,124,253,217,253,111,4,67,7,6,254,220,8,158,252,33,2,93,249,53,255,51,250,66,6,173,8,224,252,219,5,118,2,70,1,124,4,72,2,19,2,219,254,249,253,147,251,23,0,22,247,180,254,36,4,244,253,141,254,17,251,69,5,53,249,33,250,127,7,41,6,77,254,55,251,175,6,62,247,210,3,246,253,69,7,82,254,244,1,155,3,82,4,150,4,130,248,162,3,194,255,48,5,117,3,151,249,136,8,225,5,168,8,86,0,147,249,135,247,203,252,198,255,133,2,158,0,149,0,139,4,99,251,135,3,49,254,159,5,142,4,7,250,33,252,195,1,4,3,245,252,6,248,195,250,89,248,118,2,4,4,101,4,145,5,104,7,89,2,119,6,8,254,65,250,79,7,214,4,231,253,52,250,102,5,184,8,37,7,72,255,252,252,97,248,92,1,110,252,100,2,205,6,135,0,141,8,6,3,160,2,180,5,238,248,199,248,85,249,37,255,85,252,114,1,108,251,133,6,149,253,178,247,148,1,219,249,88,5,27,1,35,0,22,253,204,255,182,0,192,253,216,1,1,247,56,249,96,247,94,252,163,254,197,7,10,255,175,254,56,3,105,1,241,8,58,4,175,4,166,252,223,253,158,253,184,1,157,254,55,254,118,3,138,5,243,250,217,254,100,3,40,249,120,8,87,250,162,5,189,4,117,0,86,247,73,8,0,7,177,251,134,0,202,6,91,250,57,3,75,3,213,7,183,7,44,6,148,247,249,5,84,247,126,255,50,8,95,7,79,4,228,4,157,248,81,4,170,251,161,4,131,252,41,255,232,255,151,4,203,248,183,247,192,250,127,3,163,251,190,253,169,2,84,0,159,2,170,251,39,4,152,251,111,6,73,2,215,5,96,7,140,2,134,7,93,2,120,8,39,247,82,249,223,1,84,247,199,0,184,254,161,253,35,8,118,0,122,250,69,249,43,251,45,6,12,252,200,5,126,253,172,247,51,0,155,252,107,248,161,6,147,4,25,248,223,3,71,6,53,254,167,6,107,6,100,3,52,252,184,0,180,251,40,6,204,7,112,251,141,6,65,254,8,253,35,255,111,7,82,0,20,247,78,250,212,7,158,254,148,251,227,2,141,7,165,8,113,1,164,247,221,249,242,3,194,0,162,7,64,252,159,248,3,248,234,3,223,248,96,253,63,253,20,251,56,249,173,6,16,251,112,0,149,0,207,1,53,249,208,249,62,2,33,1,188,251,12,7,191,4,133,248,128,253,83,8,112,249,195,1,85,249,94,3,158,254,40,1,77,7,149,253,227,250,53,1,7,6,182,248,39,0,79,255,93,251,168,247,190,5,90,248,80,248,158,8,200,249,161,8,151,0,178,251,147,253,192,0,174,4,92,2,113,255,147,251,137,4,215,8,205,2,102,1,171,249,35,251,197,8,213,1,60,2,229,247,222,249,34,5,77,6,244,1,37,1,56,0,52,6,161,252,208,255,101,0,46,249,236,0,0},
  {134,4,172,4,217,251,187,252,161,0,224,7,180,0,25,250,126,8,120,0,65,249,160,249,12,6,254,249,198,251,62,7,171,254,180,251,230,8,116,254,91,253,69,2,4,5,81,6,177,248,179,254,217,2,79,252,186,2,160,7,198,8,78,254,121,5,91,2,214,8,3,253,183,7,88,250,53,250,174,4,136,251,166,251,178,6,170,250,59,7,32,255,224,251,110,0,65,0,194,5,37,253,195,3,214,250,144,248,130,8,56,7,78,4,18,252,128,249,225,7,247,2,54,0,216,252,202,253,203,5,128,4,50,7,144,0,43,5,226,250,49,3,24,249,79,254,193,250,27,249,255,246,90,252,254,246,193,247,223,247,61,250,241,5,242,254,123,248,225,2,97,250,21,247,8,253,243,3,84,253,114,6,69,252,254,251,63,4,16,6,95,5,160,0,183,6,40,251,120,252,20,252,139,248,202,1,154,2,46,248,102,249,54,2,68,247,196,255,194,4,37,250,104,6,61,253,105,249,39,251,151,249,95,252,58,6,32,248,31,249,31,251,153,4,101,4,135,7,235,7,152,253,59,6,22,253,174,252,97,250,141,4,157,255,75,7,136,248,94,3,56,4,138,6,215,254,193,3,207,4,255,255,20,7,116,0,84,255,150,248,190,247,92,254,56,0,30,2,29,6,139,249,244,3,199,0,201,250,77,1,63,253,171,2,127,248,56,2,186,251,248,255,34,250,127,0,52,252,49,4,229,1,31,3,167,254,212,1,131,4,18,0,38,248,12,8,165,248,87,255,38,6,24,247,53,253,238,252,44,250,216,255,221,6,184,8,155,0,127,253,230,4,7,5,66,2,110,248,169,254,93,251,232,254,16,4,51,3,23,3,6,253,35,253,243,3,238,4,19,250,42,251,221,251,70,6,84,1,250,0,174,3,6,6,0,2,75,249,160,247,1,6,67,1,129,4,209,6,210,3,84,0,71,1,219,253,65,6,229,247,255,4,234,4,141,250,51,1,235,248,97,4,211,7,217,248,141,6,23,252,145,252,200,0,140,254,77,6,113,250,199,251,239,255,44,3,205,248,75,5,222,254,180,252,40,2,143,249,118,247,253,6,182,247,135,4,30,2,234,7,204,252,134,255,180,2,229,255,48,251,185,3,220,251,35,253,209,4,143,5,177,251,65,6,61,5,188,247,5,2,140,254,119,248,186,247,94,6,245,7,110,1,189,253,119,3,129,1,159,247,26,4,223,0,25,2,164,1,254,249,121,3,65,3,59,249,113,2,46,4,110,0,211,247,250,3,180,249,126,8,24,8,60,249,136,0,94,4,236,253,39,255,229,248,197,8,189,247,15,8,60,255,38,248,160,4,181,4,104,3,88,3,65,8,204,3,129,249,204,4,128,3,251,4,254,4,220,252,66,255,240,254,82,251,152,5,27,255,176,251,204,253,154,7,168,3,228,1,36,249,68,6,13,251,169,2,6,253,23,7,137,7,152,6,104,253,71,248,237,2,145,251,227,0,133,0,184,249,122,8,33,0,0,8,151,6,82,251,199,3,60,6,76,247,142,4,53,7,232,7,32,5,158,2,101,8,163,249,135,8,36,0,4,251,206,253,30,2,72,252,66,6,193,8,50,254,73,255,45,252,38,4,52,253,72,7,35,247,159,254,185,253,124,252,152,254,196,5,51,255,90,253,208,3,152,252,175,6,169,252,117,251,63,251,167,251,143,253,72,248,117,6,65,7,16,1,85,2,106,253,156,253,102,253,146,2,136,2,156,247,226,4,148,253,29,8,125,4,123,1,37,5,112,4,80,3,143,248,220,1,107,253,171,8,241,3,14,2,179,253,36,6,23,3,215,250,46,7,48,255,65,8,75,2,247,254,103,2,164,254,205,254,166,250,50,252,87,247,26,250,41,8,13,2,146,3,228,3,225,3,95,248,106,253,247,248,56,252,91,3,26,250,15,254,71,248,187,1,16,0,19,251,94,254,255,8,39,250,25,247,83,8,169,8,196,254,118,8,101,4,109,4,28,247,130,0,140,253,13,1,154,249,41,6,214,3,22,8,44,3,59,6,193,5,242,4,41,3,232,251,122,0,75,1,219,254,70,252,128,247,159,248,185,251,217,249,104,251,138,255,159,251,124,248,171,255,177,248,134,7,228,0,135,2,231,6,170,247,29,3,30,0,101,255,166,251,160,252,175,248,97,249,237,4,109,250,159,255,116,8,242,5,226,7,18,8,205,255,191,253,224,249,120,252,183,2,36,250,244,7,172,4,158,254,87,2,246,0,112,3,217,247,37,6,64,7,151,1,100,252,176,6,172,5,106,2,194,251,166,250,221,7,224,4,34,8,197,6,100,0,238,0,167,8,39,250,9,1,201,249,76,254,159,253,121,1,150,247,30,255,150,247,158,248,20,1,7,5,192,248,16,251,22,0,207,253,124,250,183,255,123,255,141,4,210,249,242,8,254,8,11,253,44,0,202,248,173,253,98,6,63,252,68,2,186,255,236,3,17,251,151,6,219,6,20,0,153,253,125,250,12,7,43,252,57,251,229,249,34,248,58,250,93,255,220,3,157,254,108,6,10,253,176,255,243,254,140,255,13,7,116,252,56,251,49,4,155,1,27,247,206,5,63,4,93,0,192,2,109,6,75,6,64,253,18,251,107,2,123,0,105,247,248,250,250,253,98,4,106,254,4,249,152,254,55,249,125,6,201,247,76,8,233,3,149,255,110,6,67,5,124,253,159,0,89,5,170,251,233,255,8,1,135,249,102,0,122,7,132,254,250,248,146,250,236,251,116,251,61,3,152,3,116,249,247,248,35,250,17,2,176,251,193,249,84,1,156,3,78,255,90,2,12,253,93,2,54,255,16,247,186,251,77,4,183,250,64,249,137,250,132,251,246,248,218,0,5,252,26,249,23,2,36,254,115,255,0},
} ;

static const unsigned char precomputed_core_invsntrup653_n[precomputed_core_invsntrup653_NUM][crypto_core_INPUTBYTES] = {
  {13,228,255,151,110,255,243,150,57,100,53,227,217,228,223,65,238,82,117,179,180,231,36,165,125,33,217,54,7,124,183,135,8,64,148,162,67,6,79,179,76,253,200,139,204,232,228,14,163,101,2,67,254,65,212,228,8,67,142,212,243,54,116,159,143,84,84,63,35,134,224,123,23,39,29,253,251,153,197,157,81,160,142,59,233,111,233,17,144,227,194,100,33,116,150,237,205,115,160,178,167,24,101,235,169,49,58,30,152,109,120,104,100,57,239,46,250,47,247,40,110,231,108,167,1,56,6,19,207,50,123,152,158,151,197,230,75,58,54,125,102,137,250,195,222,136,154,62,19,147,7,81,204,211,137,75,151,51,230,116,57,62,143,23,61,16,163,97,183,164,3,194,167,17,206,253,185,78,43,128,134,32,153,193,215,95,209,104,31,253,137,39,226,190,225,168,100,255,88,108,11,224,91,87,194,155,28,51,186,179,88,17,118,233,200,213,36,68,243,167,26,70,127,11,187,196,179,48,130,157,140,189,129,12,35,250,207,77,116,241,226,185,178,176,63,249,46,235,56,255,65,150,5,54,231,221,55,1,198,196,46,72,255,205,29,224,30,98,187,90,132,173,68,134,152,45,214,205,115,246,113,115,129,213,60,112,81,160,55,230,235,36,179,233,130,180,26,100,47,141,181,144,63,60,168,134,32,138,30,90,72,230,127,187,128,121,231,60,186,115,54,189,127,176,53,227,74,69,183,143,117,175,203,45,199,124,244,22,147,245,74,210,219,202,104,55,28,124,111,42,253,108,221,71,231,105,185,170,112,188,36,208,100,236,23,110,75,150,22,118,7,14,207,92,171,0,248,182,230,110,118,41,204,233,42,57,183,151,128,244,230,97,233,232,239,123,103,205,206,58,166,75,6,135,159,200,62,197,173,215,89,242,228,17,86,211,44,222,113,0,117,237,98,180,87,10,164,93,169,226,84,243,74,2,45,114,72,248,32,94,146,16,34,229,141,159,152,252,88,223,17,243,166,13,3,76,68,61,58,69,54,31,118,79,58,124,69,149,10,32,180,248,137,16,9,180,171,160,239,34,195,122,25,191,135,138,170,193,133,79,104,16,51,43,40,42,198,174,237,253,84,225,65,255,201,199,82,14,125,42,243,35,251,116,172,192,16,21,192,88,113,215,31,202,160,223,52,153,99,136,240,111,49,191,194,225,142,22,140,39,139,118,215,47,8,221,221,61,135,91,229,177,240,198,149,200,10,183,76,135,255,182,106,64,24,179,119,89,35,10,139,79,64,79,32,134,207,145,249,160,246,52,37,103,234,42,189,17,66,102,102,31,88,191,62,105,137,221,184,233,161,119,47,177,46,107,131,0,16,17,62,71,40,28,171,135,139,60,145,121,12,138,201,19,230,161,3,135,115,115,105,98,50,243,2,211,200,150,248,190,94,24,160,98,242,201,9,46,78,165,110,25,141},
  {189,141,228,128,35,176,167,250,73,142,40,241,52,2,158,216,143,144,17,113,96,134,32,173,231,89,159,192,13,129,9,87,83,151,24,174,172,110,199,65,155,98,28,218,68,207,183,193,171,211,199,30,43,151,2,235,225,254,166,184,219,100,134,2,1,0,156,84,80,83,107,143,26,10,228,51,244,119,65,39,89,245,175,6,148,112,224,121,161,121,92,201,180,2,179,179,50,177,35,172,4,149,186,205,170,116,20,98,135,81,25,79,176,187,93,159,131,113,235,188,125,133,228,200,133,77,172,136,97,225,111,227,158,51,68,70,239,57,141,76,142,112,17,220,151,107,246,130,191,126,107,13,148,25,29,118,51,47,87,37,244,57,146,73,1,160,184,58,106,214,62,64,250,1,174,37,56,180,38,199,156,247,68,222,164,168,124,91,200,85,242,172,57,77,105,179,200,27,73,232,13,169,5,206,24,48,16,96,238,237,181,212,247,206,174,175,196,138,118,250,25,114,234,132,86,90,209,46,81,127,200,59,205,196,127,28,62,238,100,90,89,99,38,185,85,20,39,6,84,15,64,114,220,79,101,119,31,190,204,243,27,107,23,159,98,105,114,42,118,30,218,228,228,146,222,213,143,60,227,109,232,64,13,179,105,198,247,161,2,91,27,117,11,199,176,73,174,188,217,43,49,164,172,27,234,115,213,52,63,19,247,128,234,115,80,69,41,255,124,52,254,217,166,85,165,36,251,144,32,169,78,48,136,170,66,31,169,100,142,255,221,163,219,16,24,59,144,154,252,24,143,170,199,42,65,75,172,40,170,203,65,226,21,32,70,31,121,70,19,235,224,127,254,207,224,160,100,42,112,162,142,68,190,71,213,96,56,143,48,44,25,61,56,226,96,130,138,151,241,180,194,145,41,236,194,25,147,238,79,233,219,93,206,169,173,220,121,59,197,184,72,61,0,30,13,120,15,99,133,201,219,83,19,70,111,102,183,216,174,37,94,243,133,50,159,154,132,155,33,185,239,46,134,130,155,142,109,61,245,85,62,255,121,219,79,95,51,11,202,76,183,79,244,50,239,134,3,138,119,34,103,84,21,190,134,88,86,23,177,34,27,189,160,106,104,43,132,62,204,63,227,124,181,111,238,90,252,190,125,29,202,34,214,102,253,248,31,135,57,127,191,18,9,7,232,38,140,150,16,19,147,145,180,200,114,236,223,114,11,5,217,177,33,132,202,244,80,131,129,13,127,149,141,216,88,106,166,211,166,192,59,0,250,27,223,200,178,8,182,69,129,215,85,49,112,68,211,112,16,148,41,157,63,238,197,212,163,97,174,253,80,25,51,33,204,250,165,124,102,14,241,19,16,246,60,25,206,100,144,234,35,72,24,183,98,16,140,91,191,212,8,169,41,183,65,66,220,200,192,68,252,146,175,124,106,36,21,197,14,228,144,2,207,114,219,18,3,168,192,249,213,13,220},
  {254,48,115,31,209,53,3,3,152,99,182,68,238,158,205,57,158,10,248,110,45,36,253,60,157,197,123,240,168,3,138,167,253,203,116,65,69,122,188,215,207,223,32,192,39,234,23,102,81,158,239,176,153,76,237,100,88,133,210,203,52,234,203,53,189,147,166,195,166,226,221,196,109,115,17,19,58,0,68,85,89,230,161,190,86,244,11,6,82,128,40,56,235,137,90,238,66,184,30,79,172,10,84,42,94,40,165,116,154,68,253,38,195,94,8,159,241,13,144,213,139,55,237,92,63,236,154,120,115,224,129,137,142,186,203,211,12,55,77,145,85,16,168,199,30,237,80,89,147,108,92,104,183,42,188,247,29,123,32,42,117,27,191,51,166,123,219,214,176,178,58,161,198,237,141,167,206,163,128,246,221,50,178,112,159,130,26,105,20,106,138,114,27,232,154,50,163,117,47,109,29,73,222,134,153,52,173,184,185,89,70,14,66,13,125,79,103,111,32,113,40,67,207,95,183,255,115,74,52,168,148,242,91,84,198,51,162,61,165,161,48,38,23,4,41,39,45,196,113,102,244,162,25,11,91,175,223,222,127,74,207,200,128,202,101,149,160,196,58,27,14,223,215,66,118,54,131,234,171,200,194,149,109,212,160,201,162,215,174,167,136,141,213,98,149,250,247,178,124,211,208,248,147,63,239,123,90,189,2,252,209,132,51,163,96,122,49,231,64,171,185,140,32,111,141,103,32,245,71,165,10,234,110,170,193,84,109,83,241,99,157,172,189,31,169,176,149,214,209,56,22,71,52,163,113,158,29,245,79,202,95,133,158,235,87,33,212,96,198,86,72,204,174,3,169,73,74,52,104,91,144,225,3,244,4,56,233,29,95,3,78,57,198,1,119,255,241,213,59,46,243,143,156,62,193,132,146,33,20,132,71,12,42,159,240,2,99,35,4,58,203,111,56,224,205,36,183,150,203,83,187,2,187,151,252,144,192,207,154,125,69,139,35,49,12,151,145,170,250,105,241,112,136,126,132,32,168,141,196,229,72,232,124,47,222,229,18,129,249,43,124,223,218,38,72,33,249,232,150,172,250,68,241,12,128,210,200,202,76,102,7,240,178,20,63,255,28,15,167,205,124,229,137,42,3,13,64,66,41,222,108,126,216,92,86,20,101,227,189,109,7,64,120,162,19,218,153,109,65,16,193,224,245,207,113,156,130,17,25,59,80,27,4,23,180,98,33,68,232,240,59,250,130,231,219,6,156,146,198,124,112,106,110,192,194,160,2,65,82,207,141,74,182,250,26,135,72,15,183,217,194,59,61,93,177,87,235,169,107,201,251,173,189,68,116,151,30,130,137,14,217,148,55,57,94,53,199,18,118,55,229,133,5,77,180,56,71,81,183,224,134,255,92,173,77,158,47,94,253,90,33,243,60,234,32,188,65,247,208,37,238,217,16,142,61,104,224,217,169,220,232,217,104},
  {161,178,200,112,62,231,41,110,32,114,199,67,190,32,247,23,242,211,46,83,141,133,169,166,35,174,110,26,89,211,126,92,52,150,108,192,110,26,20,216,144,61,15,247,132,226,241,192,62,237,149,157,69,246,100,216,71,135,4,165,24,64,150,187,27,58,195,191,83,174,186,95,65,145,53,202,44,77,10,174,101,240,245,10,37,33,102,191,216,23,61,113,121,193,170,145,96,39,46,214,244,107,226,191,38,204,27,126,194,207,35,179,69,241,214,215,177,128,253,36,210,191,167,248,97,132,96,225,111,89,120,21,232,92,64,75,208,83,242,231,138,82,161,181,6,191,9,74,146,188,125,78,168,45,11,88,169,181,2,26,72,161,127,29,119,52,115,255,114,89,117,78,234,34,158,63,240,1,23,99,56,19,109,143,126,46,199,200,83,50,101,169,225,250,100,139,233,123,116,148,33,101,214,108,218,133,173,33,180,70,118,207,35,7,117,221,230,198,154,146,103,120,207,105,12,234,246,25,108,182,120,213,145,16,240,62,16,249,80,235,165,208,145,185,158,97,115,227,145,173,108,11,165,127,86,234,86,168,113,33,72,140,177,102,71,220,250,200,139,151,122,30,234,163,73,105,62,6,162,191,12,201,104,114,188,92,150,97,221,229,174,197,216,164,126,17,98,157,105,145,115,240,249,89,207,250,218,187,44,139,116,120,58,54,171,19,10,75,253,177,213,161,4,86,196,56,251,174,95,194,16,159,120,158,48,245,152,22,173,243,137,159,235,41,113,246,237,160,117,11,208,10,24,31,229,29,186,108,43,109,115,47,11,199,155,98,228,31,56,74,235,218,214,179,176,125,87,254,4,112,57,216,13,101,40,65,23,158,244,24,221,37,239,76,60,192,191,123,193,6,87,243,206,123,241,3,113,126,44,198,9,147,205,116,98,8,74,12,182,15,211,214,210,156,55,67,185,165,58,176,226,8,248,8,61,253,149,96,148,115,17,11,206,208,247,185,119,30,130,9,17,126,104,107,91,190,44,252,184,21,214,178,49,51,132,157,162,59,161,214,48,98,171,126,214,194,250,56,53,243,56,255,2,241,50,117,88,29,47,94,169,93,215,116,37,70,101,136,154,65,251,157,202,59,100,165,54,242,125,79,161,28,181,216,101,61,122,132,220,36,155,26,98,81,100,195,221,45,210,136,20,42,243,165,29,76,224,251,226,241,84,10,31,32,223,251,213,116,131,79,41,220,48,0,73,91,142,124,96,49,3,121,67,27,120,116,241,140,30,218,198,131,160,26,200,67,78,198,50,99,55,227,108,84,247,103,167,133,192,197,64,197,114,225,249,234,136,205,76,83,96,190,164,204,198,179,220,34,226,165,105,4,156,85,255,112,156,226,211,174,82,46,104,146,74,246,177,138,87,156,28,55,94,98,185,38,71,104,122,28,122,161,116,229,137,55,230,32,161,133,84,240,120},
} ;

static const unsigned char precomputed_core_invsntrup653_k[precomputed_core_invsntrup653_NUM][crypto_core_KEYBYTES] = {
  {},
  {},
  {},
  {},
} ;

static const unsigned char precomputed_core_invsntrup653_c[precomputed_core_invsntrup653_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
} ;

static void test_core_invsntrup653_impl(long long impl)
{
  unsigned char *h = test_core_invsntrup653_h;
  unsigned char *n = test_core_invsntrup653_n;
  unsigned char *k = test_core_invsntrup653_k;
  unsigned char *c = test_core_invsntrup653_c;
  unsigned char *h2 = test_core_invsntrup653_h2;
  unsigned char *n2 = test_core_invsntrup653_n2;
  unsigned char *k2 = test_core_invsntrup653_k2;
  unsigned char *c2 = test_core_invsntrup653_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_invsntrup653_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_invsntrup653(impl);
    printf("core_invsntrup653 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_invsntrup653_implementation(impl),ntruprime_dispatch_core_invsntrup653_compiler(impl));
  } else {
    crypto_core = ntruprime_core_invsntrup653;
    printf("core_invsntrup653 selected implementation %s compiler %s\n",ntruprime_core_invsntrup653_implementation(),ntruprime_core_invsntrup653_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");
    }
    checksum_expected(core_invsntrup653_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_invsntrup653_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_invsntrup653_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_invsntrup653_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_invsntrup653_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_invsntrup653_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_invsntrup653_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_invsntrup653_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_invsntrup653_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_invsntrup653_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_invsntrup653(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"invsntrup653")) return;
  storage_core_invsntrup653_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_invsntrup653_h = aligned(storage_core_invsntrup653_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_invsntrup653_n = callocplus(crypto_core_INPUTBYTES);
  test_core_invsntrup653_n = aligned(storage_core_invsntrup653_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_invsntrup653_k = callocplus(crypto_core_KEYBYTES);
  test_core_invsntrup653_k = aligned(storage_core_invsntrup653_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_invsntrup653_c = callocplus(crypto_core_CONSTBYTES);
  test_core_invsntrup653_c = aligned(storage_core_invsntrup653_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_invsntrup653_h2 = callocplus(maxalloc);
  test_core_invsntrup653_h2 = aligned(storage_core_invsntrup653_h2,crypto_core_OUTPUTBYTES);
  storage_core_invsntrup653_n2 = callocplus(maxalloc);
  test_core_invsntrup653_n2 = aligned(storage_core_invsntrup653_n2,crypto_core_INPUTBYTES);
  storage_core_invsntrup653_k2 = callocplus(maxalloc);
  test_core_invsntrup653_k2 = aligned(storage_core_invsntrup653_k2,crypto_core_KEYBYTES);
  storage_core_invsntrup653_c2 = callocplus(maxalloc);
  test_core_invsntrup653_c2 = aligned(storage_core_invsntrup653_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_invsntrup653 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_invsntrup653();++impl)
      forked(test_core_invsntrup653_impl,impl);
    ++test_core_invsntrup653_h;
    ++test_core_invsntrup653_n;
    ++test_core_invsntrup653_k;
    ++test_core_invsntrup653_c;
    ++test_core_invsntrup653_h2;
    ++test_core_invsntrup653_n2;
    ++test_core_invsntrup653_k2;
    ++test_core_invsntrup653_c2;
  }
  free(storage_core_invsntrup653_c2);
  free(storage_core_invsntrup653_k2);
  free(storage_core_invsntrup653_n2);
  free(storage_core_invsntrup653_h2);
  free(storage_core_invsntrup653_c);
  free(storage_core_invsntrup653_k);
  free(storage_core_invsntrup653_n);
  free(storage_core_invsntrup653_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

