/* moveStackTest.cc
 */
#include "osl/container/moveStack.h"
#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
#include <set>

class MoveStackTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(MoveStackTest);
  CPPUNIT_TEST(testPush);
  CPPUNIT_TEST_SUITE_END();
public:
  void testPush();
};

CPPUNIT_TEST_SUITE_REGISTRATION(MoveStackTest);
using namespace osl;

void MoveStackTest::testPush()
{
  MoveStack s;
  CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(0u), s.size());
  CPPUNIT_ASSERT_EQUAL(false, s.hasLastMove());
  CPPUNIT_ASSERT_EQUAL(false, s.hasLastMove(1));
  CPPUNIT_ASSERT_EQUAL(false, s.hasLastMove(2));
  CPPUNIT_ASSERT_EQUAL(Move::INVALID(), s.lastMove());
  
  const Move move71rook = 
    Move(Square::STAND(),Square(7,1),ROOK,PTYPE_EMPTY,false,BLACK);
  s.push(move71rook);

  CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1u), s.size());
  CPPUNIT_ASSERT_EQUAL(true, s.hasLastMove());
  CPPUNIT_ASSERT_EQUAL(true, s.hasLastMove(1));
  CPPUNIT_ASSERT_EQUAL(false, s.hasLastMove(2));
  CPPUNIT_ASSERT_EQUAL(move71rook, s.lastMove());
  CPPUNIT_ASSERT_EQUAL(move71rook, s.lastMove(1));

  s.pop();

  CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(0u), s.size());
  CPPUNIT_ASSERT_EQUAL(false, s.hasLastMove());
  CPPUNIT_ASSERT_EQUAL(false, s.hasLastMove(1));
  CPPUNIT_ASSERT_EQUAL(false, s.hasLastMove(2));
}


/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
