/*
 * libsysactivity
 * http://sourceforge.net/projects/libsysactivity/
 * Copyright (c) 2009-2011 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <stdio.h>
#include <unistd.h>
#include <pthread.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <inttypes.h>

int main() {
	int ret;
#ifdef SA_OPEN_DISK
	ret = sa_open_disk();
	if (ret != 0) {
		printf("%s:%d ERROR: sa_open_disk(): %s\n", __FILE__, __LINE__, strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif

	uint16_t number;
	ret = sa_count_disks(&number);
	if (ret != 0) {
		printf("%s:%d ERROR: sa_count_disks(): %s\n", __FILE__, __LINE__, strerror(ret));
		exit(EXIT_FAILURE);
	}

	struct sa_disk* hds = (struct sa_disk*) malloc(number * sizeof(struct sa_disk));
	if (hds == NULL)
		exit(EXIT_FAILURE);

	struct sa_disk dev;
	uint16_t written, i;
	for (i = 0; i < 9000; i++) {
		ret = sa_count_disks(&number);
		if (ret != 0) {
			printf("%s:%d ERROR: sa_count_disks(): %s\n", __FILE__, __LINE__, strerror(ret));
			exit(EXIT_FAILURE);
		}

		ret = sa_reset_disks();
		if (ret != 0) {
			printf("%s:%d ERROR: sa_reset_disks(): %s\n", __FILE__, __LINE__, strerror(ret));
			exit(EXIT_FAILURE);
		}

#if defined(__linux__) // gcc -E -dM -x c /dev/null
		ret = sa_get_disk("sda", &dev);
#elif defined(__OpenBSD__) || defined(__NetBSD__)
		ret = sa_get_disk("wd0", &dev);
#elif defined(__sun__)
		ret = sa_get_disk("cmdk0", &dev);
#elif defined(__DragonFly__)
		ret = sa_get_disk("ad1", &dev);
#else
		ret = sa_get_disk("ad0", &dev);
#endif
		if (ret != 0) {
			printf("%s:%d ERROR: sa_get_disk(): %s\n", __FILE__, __LINE__, strerror(ret));
			exit(EXIT_FAILURE);
		}

		ret = sa_get_disks(hds, number, &written);
		if (ret != 0) {
			printf("%s:%d ERROR: sa_get_disks(): %s\n", __FILE__, __LINE__, strerror(ret));
			exit(EXIT_FAILURE);
		}
	}

	free(hds);
#ifdef SA_CLOSE_DISK
	ret = sa_close_disk();
	if (ret != 0) {
		printf("%s:%d ERROR: sa_close_disk(): %s\n", __FILE__, __LINE__, strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif
	return EXIT_SUCCESS;
}
