/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#include "treemodel.h"

#include "treeitem.h"

TreeModel::TreeModel(QObject *parent)
 : QAbstractItemModel(parent)
{
}

TreeModel::~TreeModel()
{
  delete m_rootItem;
}

//\**************************
QVariant TreeModel::data(const QModelIndex & index, int role) const
{
  if(!index.isValid())
    return QVariant();

  TreeItem *item = static_cast<TreeItem*>(index.internalPointer());

  return item->data(index.column(), role);
}
//\**************************
QVariant TreeModel::headerData(int section, Qt::Orientation orientation, int role) const
{
  if(orientation == Qt::Horizontal && role == Qt::DisplayRole)
    return m_rootItem->data(section);

  return QVariant();
}
//\**************************
QModelIndex TreeModel::index(int row, int column, const QModelIndex & parent) const
{
  if(!hasIndex(row, column, parent))
    return QModelIndex();

  TreeItem *parentItem;

  if(!parent.isValid())
    parentItem = m_rootItem;
  else
    parentItem = static_cast<TreeItem*>(parent.internalPointer());

  TreeItem* childItem = const_cast<TreeItem*>(parentItem->child(row));

  if(childItem)
    return createIndex(row, column, childItem);
  else
    return QModelIndex();
}
//\**************************
QModelIndex TreeModel::parent(const QModelIndex & index) const
{
  if(!index.isValid())
    return QModelIndex();

  TreeItem *childItem = static_cast<TreeItem*>(index.internalPointer());
  TreeItem *parentItem = childItem->parent();

  if(parentItem == m_rootItem)
    return QModelIndex();

  return createIndex(parentItem->row(), 0, parentItem);
}
//\**************************
int TreeModel::rowCount(const QModelIndex & parent) const
{
  TreeItem *parentItem;
  if(parent.column() > 0)
      return 0;

  if(!parent.isValid())
    parentItem = m_rootItem;
  else
    parentItem = static_cast<TreeItem*>(parent.internalPointer());

  return parentItem->childCount();
}
//\**************************
int TreeModel::columnCount(const QModelIndex & parent) const
{
  if(parent.isValid())
    return static_cast<TreeItem*>(parent.internalPointer())->columnCount();
  else
    return m_rootItem->columnCount();
}
//\**************************

Qt::ItemFlags TreeModel::flags(const QModelIndex & index) const
{
  if(!index.isValid())
    return 0;

  return Qt::ItemIsEnabled | Qt::ItemIsSelectable;
}

void TreeModel::appendToRoot(TreeItem* item)
{
  if(!item)
    return;

  item->setParent(m_rootItem);
  m_rootItem->appendChild(item);
}

void TreeModel::clear()
{
  delete m_rootItem;

  m_rootItem = createRootItem();

  reset();
}
