/*
 * Copyright (C) 2009  Lorenzo Bettini <http://www.lorenzobettini.it>
 * See COPYING file that comes with this distribution
 */


#include <QFileDialog>

#include "filechooserframe.h"
#include "ui_filechooserframe.h"

FileChooserFrame::FileChooserFrame(QWidget *parent) :
    QFrame(parent),
    m_ui(new Ui::FileChooserFrame)
{
    m_ui->setupUi(this);

    connect(m_ui->browseButton, SIGNAL(clicked()), this, SLOT(chooseFile()));
}

FileChooserFrame::~FileChooserFrame()
{
    delete m_ui;
}

void FileChooserFrame::changeEvent(QEvent *e)
{
    QFrame::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void FileChooserFrame::setFileDescription(const QString &desc) {
    m_ui->fileDescription->setText(desc);
}

void FileChooserFrame::chooseFile() {
    QString fileName = QFileDialog::getOpenFileName(this);
    if (!fileName.isEmpty())
        m_ui->filePath->setText(fileName);
}

QString FileChooserFrame::getFilePath() const {
    return m_ui->filePath->text();
}
