# -*- coding: utf-8 -*-

# This file is included in the source of Videoporama
# Videoporama is a program to make diaporama export in video file
# ------------------------------------------------------------------------------------
# LICENCE DU SCRIPT:
# ------------------------------------------------------------------------------------
#
# Copyright (C) 2010 Lama Angelo, developpeur historique d'EKD:
# http://ekd.tuxfamily.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
# ------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------
# A QUOI CA SERT:
# ------------------------------------------------------------------------------------
#
# Ce script sert a produire un fichier ISS de l'arborescence d'une application (de
# preference une application Python). Fichier ISS (.iss) qui sera ensuite ouvert
# et compile dans Inno Setup pour produire un .exe exexcutable sous windows.
#
# Concernant Inno Setup: http://www.jrsoftware.org/isinfo.php
#
# Ce script a ete initialement concu pour produire un executable d'EKD (logiciel de 
# post-production pour vidéos et images) pour windows.
#
# ------------------------------------------------------------------------------------
# FONCTIONNEMENT DU SCRIPT:
# ------------------------------------------------------------------------------------
#
# 1) Il faut le mettre ce script dans le répertoire de l'application ... exactement
# a la racine (la ou se trouve le script principal de lancement de l'application).
#
# 2) Il faut editer le script dans un editeur de texte (gedit ou kate sous Linux),
# words (sous windows).
#
# 3) Il faut modifier les variables principales, cela est indique a partir de:
#
##############################################################################
# VARIABLES PRINCIPALES A MODIFIER (POUR CHAQUE VERSION DU LOGICIEL A COMPILER)
##############################################################################
# C'est ici que les variables doivente etre modifiees ...
##############################################################################
#
# Vous pouvez modifier le contenu des variables (les entetes vous indiquent ce
# que sont exactement les variables en question):
#
# self.appli_script_principal_demarrage
# self.appli_nom_court
# self.appli_nom_long
# self.appli_version
# self.appli_site_web
# self.appli_forum_discuss
# self.appli_annee
# self.appli_nom_du_paquet_exe
# self.appli_description
# self.appli_pour_nom_ds_rep
# self.appli_chemin_vers_arbo
# self.appli_nom_fichier_iss
# self.appli_chemin_enregistrement_exe
# self.appli_nom_fichier_manifest
# self.appli_icone_lancer_appli
# self.appli_icone_install_appli
# self.appli_icone_desinstall_appli
# self.appli_licence
# self.appli_lisez_moi
#
# 4) Lancement du script:
# 
# --> Sous windows: simplement cliquer sur les fichier:
# creation_iss_pour_exe_ekd_par_inno_setup.py
# 
# --> Sous GNU/Linux: ouvrir un terminal ... entrer dans
# le repertoire ou se trouve ce script: cd /home/user/chemin...vers...le...script,
# ensuite taper: python creation_iss_exe_compil_inno_setup.py
#
# A la fin du traitement
#
# ATTENTION (!!!): le fichier ISS sera enregistre dans le repertoire de l'application
#
# ------------------------------------------------------------------------------------
# PRECISIONS:
# ------------------------------------------------------------------------------------
#
# Vous devez avoir cree des icones (avec l'extension .ico) pour lancer l'application,
# un autre icone pour installer l'application et un dernier pour desinstaller
# l'application (ces 3 fichiers doivent se trouver a la racine de l'arborescence de
# l'application). De meme a la racine doivent aussi se trouver un fichier Lisez-moi.rtf
# (attention l'extension doit être .rtf). Il doit aussi y avoir un autre fichier rtf
# (toujours avec l'extension .rtf) precisant la licence de votre application.
#


import os, sys, ntpath, string, shutil, time, glob


# Uniquement pour windows
if os.name == 'nt':
	"#! "+sys.executable
	

class Appli_Windows_Fich_iss_pour_exe(object):
	def __init__(self):
	
		# Repertoire courant
		self.oi = os.getcwd()
		
		# Separateur
		self.sep = "\\"
		
		# Utile pour définir les dates des mises à jour
		t = time.localtime()
		annee = str(t[0])
		mois = str(t[1])
		nb_mois = len(mois)
		jour = str(t[2])
		nb_jour = len(jour)
		# Conditions d'utilisation
		#
		if nb_mois == 1: mois = '0'+mois
		else: mois = mois
		#
		if nb_jour == 1: jour = '0'+jour
		else: jour = jour	
		# Attribution de la qate de sortie de l'application (sous cette forme: 
		# annee-mois-jour sans les -) et de façon automatique (donc sans reglage 
		# pour l'utilisateur)
		self.appli_date_version = annee + mois + jour
		
		
		##############################################################################
		# VARIABLES PRINCIPALES A MODIFIER (POUR CHAQUE VERSION DU LOGICIEL A COMPILER)
		##############################################################################
		# C'est ici que les variables doivent etre modifiees ...
		##############################################################################
		
		# ----------------------------------------------------------------------------
		# Script principal de lancement de l'application
		# ----------------------------------------------------------------------------
		#
		self.appli_script_principal_demarrage = "Videoporama.exe"
		
		# ----------------------------------------------------------------------------
		# Nom court de l'application
		# ----------------------------------------------------------------------------
		#
		self.appli_nom_court = "Videoporama"
		
		# ----------------------------------------------------------------------------
		# Nom long de l'application
		# ----------------------------------------------------------------------------
		#
		self.appli_nom_long = "Videoporama"
		
		# ----------------------------------------------------------------------------
		# Version de l'application
		# ----------------------------------------------------------------------------
		#
		self.appli_version = "0.8.1-Alpha1"
		
		# ----------------------------------------------------------------------------
		# Site web du projet
		# ----------------------------------------------------------------------------
		#
		self.appli_site_web = "http://videoporama.tuxfamily.org"
		
		# ----------------------------------------------------------------------------
		# Adresse du forum de discussion du projet. Si l'application en
		# question ne possede pas de forum de discussion, mettre
		# l'adresse du site web a la place (ou laisser vide, comme ceci: "")
		# ----------------------------------------------------------------------------
		#
		self.appli_forum_discuss = "http://videoporama.tuxfamily.org/fsb"
		
		# ----------------------------------------------------------------------------
		# Annee de l'application
		# ----------------------------------------------------------------------------
		#
		self.appli_annee = "2010"
		
		# ----------------------------------------------------------------------------
		# Nom (juste le nom sans la date) du paquet exe pour la compilation
		# ----------------------------------------------------------------------------
		#
		self.appli_nom_du_paquet_exe = "Videoporama_win_"
		
		# ----------------------------------------------------------------------------
		# Description courte du logiciel
		# ----------------------------------------------------------------------------
		# 
		self.appli_description = "Logiciel de création de diaporama d'image exporté en vidéo"
		
		# ----------------------------------------------------------------------------
		# Version appli pour nom dans repertoire
		# ----------------------------------------------------------------------------
		#
		self.appli_pour_nom_ds_rep = "0_8_1"
		
		# ----------------------------------------------------------------------------
		# Chemin où se trouve toute l'arborescence de l'application a traiter
		# Repertoires ... sous-reps (pas fichier)
		# Par exemple ici le chemin exact sera: C:\dev_EKD\kit_windows
		# Ne vous inquietez pas self.sep correspond au séparateur antislash --> \
		# ----------------------------------------------------------------------------
		#
		self.appli_chemin_vers_arbo = "C:"+self.sep+"videoporama"
		
		# ----------------------------------------------------------------------------
		# Nom du fichier ISS (.iss) apres ecriture par ce script
		# --> La plupart du temps vous n'avez pas a modifier cette variable.
		# ----------------------------------------------------------------------------
		#
		self.appli_nom_fichier_iss = self.appli_nom_du_paquet_exe + self.appli_date_version + "_v_" + self.appli_pour_nom_ds_rep + "_inno_setup.iss"
		
		# ----------------------------------------------------------------------------
		# Repertoire où va etre enregistre le fichier .exe apres compilation (Inno Setup)
		# Par exemple ici le chemin exact sera: C:\dev_EKD\construct_exe_EKD_2_0_0
		# Si ce chemin n'existe pas, il faut le creer (repertoires, sous-repertoires)
		# Ne vous inquietez pas self.sep correspond au séparateur antislash --> \
		# ----------------------------------------------------------------------------
		#
		self.appli_chemin_enregistrement_exe = "C:"+self.sep+"videoporama"+self.sep+"EXE_"+self.appli_pour_nom_ds_rep
		
		# ----------------------------------------------------------------------------
		# Nom de sortie du fichier Manifest (après compilation InnoSetup)
		# ----------------------------------------------------------------------------
		#
		self.appli_nom_fichier_manifest = "fichier_manifest_de_sortie_InnoSetup_"+self.appli_pour_nom_ds_rep
		
		# ----------------------------------------------------------------------------
		# Nom de l'icone principal pour lancer l'appli (avec extension .ico)
		# Doit se trouver a la racine ds l'arborescence de l'application
		# ----------------------------------------------------------------------------
		#
		self.appli_icone_lancer_appli = "icone_videoporama.ico"	
		
		# ----------------------------------------------------------------------------
		# Nom de l'icone qui sert a l'nstallation de l'application (avec extension
		# .ico). Doit se trouver a la racine ds l'arborescence de l'application
		# ----------------------------------------------------------------------------
		#
		self.appli_icone_install_appli = "icone_videoporama_installation_is.ico"
		
		# ----------------------------------------------------------------------------
		# Nom de l'icone qui sert a la desinstallation de l'application (avec 
		# extension .ico). Doit se trouver a la racine ds l'arborescence de l'application
		# ----------------------------------------------------------------------------
		#
		self.appli_icone_desinstall_appli = "icone_videoporama_desinstallation_is.ico"	
		
		# ----------------------------------------------------------------------------
		# Nom de sortie du fichier de licence (doit se trouver a la racine
		# de l'arborescence) --> ce fichier doit reellement exister
		# ----------------------------------------------------------------------------
		#
		self.appli_licence = "licence.rtf"
		
		# ----------------------------------------------------------------------------
		# Nom de sortie du fichier lisez-moi (doit se trouver a la racine
		# de l'arborescence) --> ce fichier doit reellement exister
		# ----------------------------------------------------------------------------
		#
		self.appli_lisez_moi = "README.rtf"
		
		
		##############################################################################
		# CONTENU DU FICHIER ISS --> INNO SETUP                                      #
		##############################################################################
		# Ne rien modifier ici ... (dans les lignes ci-dessous)
		##############################################################################
	
		# ----------------------------------------------------------------------------
		# Entetes des differentes rubriques
		# ----------------------------------------------------------------------------
		#
		# Ne pas changer ces variables
		#
		self.setup = "[Setup]"
		self.files = "[Files]"
		self.languages = "[Languages]"
		self.icons = "[Icons]"
		self.uninstall_delete = "[UninstallDelete]"
		self.messages = "[Messages]"
		
		# ----------------------------------------------------------------------------
		# Donnees contenues dans [Setup]
		# ----------------------------------------------------------------------------
		#
		self.AppCopyright = "AppCopyright=Copyright "+self.appli_annee+" "+self.appli_nom_court+" "+self.appli_site_web
		self.AppName = "AppName="+self.appli_nom_court
		self.AppVerName = "AppVerName="+self.appli_nom_court+" "+self.appli_version
		self.DefaultDirName = "DefaultDirName={pf}"+self.sep+self.appli_nom_court
		#
		self.OutputDir = "OutputDir="+self.appli_chemin_enregistrement_exe
		#
		self.OutputBaseFilename = "OutputBaseFilename="+self.appli_nom_du_paquet_exe+self.appli_date_version
		#
		self.VersionInfoCompany = "VersionInfoCompany="+self.appli_nom_court
		self.VersionInfoDescription = "VersionInfoDescription="+self.appli_description
		#
		self.OutputManifestFile = "OutputManifestFile="+self.appli_chemin_enregistrement_exe+self.sep+self.appli_nom_fichier_manifest
		#
		self.VersionInfoCopyright = "VersionInfoCopyright=Copyright "+self.appli_annee+" "+self.appli_nom_court+" "+self.appli_site_web
		#
		self.SetupIconFile = "SetupIconFile="+self.appli_chemin_vers_arbo+self.sep+self.appli_icone_lancer_appli
		#
		self.AppPublisher = "AppPublisher="+self.appli_nom_court
		#
		self.AppPublisherURL = "AppPublisherURL="+self.appli_site_web
		self.AppSupportURL = "AppSupportURL="+self.appli_site_web
		self.AppUpdatesURL = "AppUpdatesURL="+self.appli_site_web
		#
		self.AppVersion = "AppVersion="+self.appli_version
		#
		self.UninstallDisplayIcon = "UninstallDisplayIcon={app}"+self.sep+self.appli_icone_desinstall_appli
		#
		self.Compression = "Compression=lzma"
		self.AllowUNCPath = "AllowUNCPath=false"
		self.InternalCompressLevel = "InternalCompressLevel=max"
		self.ChangesAssociations = "ChangesAssociations=true"
		self.EnableDirDoesntExistWarning = "EnableDirDoesntExistWarning=true"
		self.DisableProgramGroupPage = "DisableProgramGroupPage=true"
		self.ShowTasksTreeLines = "ShowTasksTreeLines=true"
		#
		self.AppContact = "AppContact="+self.appli_site_web
		#
		self.UninstallRestartComputer = "UninstallRestartComputer=false"
		#
		self.UninstallFilesDir = "UninstallFilesDir={app}"+self.appli_nom_court
		#
		# Si on veut que la machine redemarre a la finc de l'install 
		# de l'appli --> ici cette fonction a ete desactivee
		self.AlwaysRestart = ";AlwaysRestart=yes"
		
		# ----------------------------------------------------------------------------
		# Donnees contenues dans [Languages]
		# ----------------------------------------------------------------------------
		#
		self.lang_anglais = "Name: english; MessagesFile: compiler:Default.isl"
		self.lang_francais = "Name: french; MessagesFile: compiler:Languages\French.isl"
		self.lang_espagnol = "Name: spanish; MessagesFile: compiler:Languages\Spanish.isl"
		
		# ----------------------------------------------------------------------------
		# Donnees contenues dans [Icons]
		# ----------------------------------------------------------------------------
		#
		self.icones_01 = "Name: {commonprograms}"+self.sep+self.appli_nom_court+self.sep+self.appli_nom_long+"; Filename: {app}"+self.sep+self.appli_script_principal_demarrage+"; WorkingDir: {app}; IconFilename: {app}"+self.sep+self.appli_icone_install_appli
		self.icones_02 = "Name: {commonprograms}"+self.sep+self.appli_nom_court+self.sep+"Licence; Filename: {app}"+self.sep+self.appli_licence+"; WorkingDir: {app}"
		self.icones_03 = "Name: {commonprograms}"+self.sep+self.appli_nom_court+self.sep+"Lisez-moi; Filename: {app}"+self.sep+self.appli_lisez_moi+"; WorkingDir: {app}"
		self.icones_04 = "Name: {commonprograms}"+self.sep+self.appli_nom_court+self.sep+"Uninstall; Filename: {uninstallexe}; IconFilename: {app}"+self.sep+self.appli_icone_desinstall_appli
		self.icones_05 = "Name: {commondesktop}"+self.sep+self.appli_nom_court+"; Filename: {app}"+self.sep+self.appli_script_principal_demarrage+"; WorkingDir: {app}; IconFilename: {app}"+self.sep+self.appli_icone_lancer_appli
		
		# ----------------------------------------------------------------------------
		# Donnees contenues dans [UninstallDelete]
		# ----------------------------------------------------------------------------
		#
		self.desinstaller_01 = "Type: files; Name: {app}"+self.sep+"*.*"
		self.desinstaller_02 = "Type: dirifempty; Name: {app}"
		self.desinstaller_03 = "Type: filesandordirs; Name: {app}"+self.sep+"*.*"
		# Sera commente ...
		self.desinstaller_04 = ";Type: dirifempty; Name: {app}"+self.sep+"MPlayer-rtm-svn-29238"
		
		# ----------------------------------------------------------------------------
		# Donnees contenues dans [Messages]
		# ----------------------------------------------------------------------------
		#
		self.AboutSetupNote_01 = "AboutSetupNote=Website : "+self.appli_site_web
		self.AboutSetupNote_02 = "AboutSetupNote=Forum : "+self.appli_forum_discuss
	
		# ----------------------------------------------------------------------------
		# COMMENTAIRES ...
		# ----------------------------------------------------------------------------
		#
		# Commentaires entete du fichier
		self.commentaireEntete = "; Fichier ISS d'Inno Setup avec Inno Setup Compiler pour generer l'exe"
		#
		# ----------------------------------------------------------------------------
		# Commentaires contenus dans [Setup]
		# ----------------------------------------------------------------------------
		#
		self.Com_AppVerName = "; Changer le num. de version a chaque nouvelle mise a jour (en dessous)"
		#
		self.Com_OutputDir_01 = "; Changer le repertoire (l'application doit avoir son rep dedie avec date de"
		self.Com_OutputDir_02 = "; version) a chaque nouvelle mise a jour (par exemple: construct_exe_EKD_2_0_0)."
		self.Com_OutputDir_03 = "; Il s'agit ici du repertoire ou sera enregistre le fichier ISS --> .iss"
		self.Com_OutputDir_04 = "; qui sera passe a la moulinette pour constituer le .exe dans Inno Setup"
		# 
		self.Com_OutputBaseFilename_01 = "; Changer/mettre la date de version ici a chaque fois"
		# 
		self.Com_OutputManifestFile_01 = "; Changer le repertoire (l'application doit avoir son rep dedie avec date de"
		self.Com_OutputManifestFile_02 = "; version) a chaque nouvelle mise a jour (par exemple: construct_exe_EKD_2_0_0)."
		self.Com_OutputManifestFile_03 = "; Il s'agit ici du repertoire ou sera enregistre le fichier Manifest (!!!)"
		self.Com_OutputManifestFile_04 = "; Le fichier en question se nommera: fichier_manifest_de_sortie_InnoSetup"
		#
		self.Com_SetupIconFile_01 = "; Repertoire ou se trouve l'icone de lancement de l'application (.ico)"
		# 
		self.Com_AppVersion_01 = "; Numero de version en cours de l'application"
		# 
		self.Com_UninstallDisplayIcon_01 = "; Repertoire ou se trouve l'icone de desinstallation de l'application (.ico)"
		#
		self.Com_UninstallFilesDir_01 = "; Ligne tres importante (c'est ce qui fait reussir la"
		self.Com_UninstallFilesDir_02 = "; desinstallation). La le chemin de desinstall est bon."
		# 
		self.Com_AlwaysRestart_01 = "; Obliger l'ordinateur a redemarrer apres l'install"
		self.Com_AlwaysRestart_02 = "; Desactive par defaut"
		#
		# ----------------------------------------------------------------------------
		# Commentaires contenus dans [Files]
		# ----------------------------------------------------------------------------
		#
		self.Com_Files_01 = "; Changer le repertoire (l'application doit avoir son rep dedie avec date de version)"
		self.Com_Files_02 = "; a chaque nouvelle mise a jour ... et ce dans toutes les lignes ci-dessous !."
		self.Com_Files_03 = "; Rajouter les nouveaux fichiers dans cette rubrique (en suivant la syntaxe"
		self.Com_Files_04 = "; presente). Attention c'est une des parties les plus importantes ici !!!."
		#
		# ----------------------------------------------------------------------------
		# Commentaires contenus dans [UninstallDelete]
		# ----------------------------------------------------------------------------
		#
		self.Com_UninstallDelete_Entete_01 = "; Elimination des fichiers .pyc et .txt residuels (ainsi que des repertoires dans"
		self.Com_UninstallDelete_Entete_02 = "; lesquels ils etaient. A adapter a chaque nouvelle version !"
		self.Com_UninstallDelete_Entete_03 = "; ; -------------------------------------------------------------------------------"
		#
		self.Com_UninstallDelete_Retirer_Rep_et_Fich_01 = "; Retirer tous les repertoires et fichiers residuels presents"
		self.Com_UninstallDelete_Retirer_Rep_et_Fich_02 = "; dans le repertoire de l'application"
		#
		self.Com_UninstallDelete_Retirer_Tous_Rep_et_Fich_01 = "; Retirer tous les repertoires et fichiers"
		#
		self.Com_UninstallDelete_Retirer_Reps_recalcitrants_01 = "; Retirer tous les repertoires recalcitrants"
		
		##############################################################################
		# EXECUTION DES DIFFERENTES FONCTIONS                                        #
		##############################################################################
		
		self.elimin_fich_residuels()
		self.liste_fich_kit()
		self.listage_moteur()
		self.elimin_fichier_iss()
		self.ecriture_fichier_iss()
		self.message_final()


	def elimin_fich_residuels(self):
	
		""" 1er Listage est elimination des repertoires et fichiers inutiles """

		debut = os.getcwd()
		print debut
		repertoires = [debut]
	
		liste_rep_svn = []
		liste_rep_langue_pas_util = []
		liste_reps_trunk = []

		listeChemins=[]

		while len(repertoires)>0:
			repertoire = repertoires.pop()
			for nom in os.listdir(repertoire):
				chemin = os.path.join(repertoire, nom)
				if os.path.isfile(chemin):
					if chemin.endswith('.pyc') or chemin.endswith('.py~') or chemin.endswith('.directory'):
						os.remove(chemin)
					listeChemins.append(chemin)

					# On supprime les répertoires autres que en_EN et es_ES
					if chemin[-12:] not in ['locale/en_EN', 'locale/es_ES'] and chemin[-12:-3] in ['locale/en', 'locale/es']:
						liste_rep_langue_pas_util.append(chemin)
						
		print
		print "Nbre de fichiers en tout (avant supression des"
		print ".pyc et/ou .py~ et/ou .directory), s'ils existent:", len(listeChemins)
		print 

		# Supression des répertoires langue (et leur contenu) autre
		# que en_EN et es_ES (et ce dans le répertoire locale)
		for rep_2 in liste_rep_langue_pas_util: 
			if os.path.exists(rep_2) is True:
				print 'Répertoires langue'
				print '------------------'
				print
				print '* Supression de: ', rep_2
				shutil.rmtree(rep_2)
				print
		
		
	def liste_fich_kit(self):
	
		""" Listage final de l'arborescence de l'application """

		repertoires = [self.oi]

		self.listeChemins_01=[]

		while len(repertoires)>0:
        		repertoire = repertoires.pop()
        		for nom in os.listdir(repertoire):
                		chemin = os.path.join(repertoire, nom)
                		if os.path.isfile(chemin):
                        		self.listeChemins_01.append(chemin)
			
                		elif os.path.isdir(chemin):
                        		repertoires.append(chemin)  # C'est un repertoire et il n'est pas affiche
	
	
	def listage_moteur(self):
	
		""" Creation des differentes listes """
		
		# Nettoyage: on supprime les répertoires et sous-reps contenus dans .svn et ce 
		# dans la liste self.listeChemins_01
		self.listeChemins_01 = [t0 for t0 in self.listeChemins_01 if '.svn' not in t0]
		
		# Slicing effectue pour creer un nouveau chemin de la sorte:
		# Chemin où se trouve toute l'arborescence de l'application a traiter (chemin a
		# determiner par l'utilisateur) + "\\" + chemin de fichiers contenus dans
		# l'arborescence de l'application
		self.listeChemins_02 = []
		#
		self.arbo_interne_appli_01 = []
		#
		for parc_01 in self.listeChemins_01:
			self.listeChemins_02.append(self.appli_chemin_vers_arbo + self.sep + parc_01[len(self.oi)+1:])
			#
			self.arbo_interne_appli_01.append(self.sep + parc_01[len(self.oi)+1:])
		self.listeChemins_02.sort()
		self.arbo_interne_appli_01.sort()

		# Merci à jv (de la liste Python Aful) pour m'avoir fait prendre connaissance avec le module ntpath
		# Tous les chemins prennent la forme de ce qui doit être sous windows
		#
		# Chemins produits à partir de l'arborescence de l'application a traiter
		# (a partir de self.listeChemins_02)
		#
		# Liste fichiers pour Source: \\chemin\\... dans [Files]
		#
		self.listeChemins_03  = [ntpath.normpath(parc_02) for parc_02 in self.listeChemins_02]
		self.listeChemins_03.sort()
		
		# Comme au dessus
		#
		# Chemins produits à partir de l'arborescence interne de l'application a traiter
		# (a partir de self.arbo_interne_appli_01)
		self.arbo_interne_appli_02  = [ntpath.normpath(p_02) for p_02 in self.arbo_interne_appli_01]
		self.arbo_interne_appli_02.sort()
		
		# Listage des chemins internes de l'application qui sont directement à la racine
		# car ils vont avoir un traitement particulier dans l'ecriture des données dans 
		# la rubrique [Files] et ce dans le fichier ISS
		self.arbo_interne_appli_03 = []
		for fich_racine in self.arbo_interne_appli_02:
			c = string.count(fich_racine, "\\")
			if int(c) == 1:
				#
				# Liste fichiers pour DestDir: {app} dans [Files] 
				#
				self.arbo_interne_appli_03.append(fich_racine)
					
		# Dans les chemins produits à partir de l'arborescence interne de 
		# l'application, on fait ressortir les elements differents entre les fichiers  
		# contenus dans la liste self.arbo_interne_appli_02 (tous les fichiers) et les 
		# fichiers dans la liste des chemins internes de l'application qui sont directement 
		# a la racine 
		interTousFichArbo=set(self.arbo_interne_appli_02) 
		interRacineFichArbo=set(self.arbo_interne_appli_03) 
		interInterFichArbo=interTousFichArbo.symmetric_difference(interRacineFichArbo)
		#
		# Liste fichiers pour DestDir: {app}\\chemin\\... dans [Files]
		#
		self.listeInterInterArboInterneAppliFichDifferents=[t1 for t1 in interInterFichArbo]
		self.listeInterInterArboInterneAppliFichDifferents.sort()
		
		# Nettoyage: on supprime les répertoires et sous-reps contenus dans trunk (pour les 2 listes
		# qui peuvent contenir le repertoire trunk et ce dans les listes self.listeChemins_01 et
		# self.listeInterInterArboInterneAppliFichDifferents
		self.listeChemins_03 = [t1 for t1 in self.listeChemins_03 if "trunk" not in t1]
		self.listeInterInterArboInterneAppliFichDifferents = [t2 for t2 in self.listeInterInterArboInterneAppliFichDifferents if "trunk" not in t2]
		
		
	def elimin_fichier_iss(self):
	
		""" Elimination de l'ancien fichier ISS (.iss) s'il existe """
		
		# Pour windows uniquement
		if os.name == 'nt':
			liste_enr_fich_iss = glob.glob(self.appli_chemin_vers_arbo + self.sep + "*.iss")
			if len(liste_enr_fich_iss) == 1:
				print "Le fichier .iss existe déjà, on l'elimine avant creation du nouveau"
				for el in liste_enr_fich_iss: os.remove(el)
		# Pour Linux et MacOSX
		elif os.name in ['posix', 'mac']:
			liste_enr_fich_iss = glob.glob(self.oi + os.sep + "*.iss")
			if len(liste_enr_fich_iss) == 1:
				print "Le fichier .iss existe déjà, on l'elimine avant creation du nouveau"
				for el in liste_enr_fich_iss: os.remove(el)
			
		
	def ecriture_fichier_iss(self):
	
		""" Ecriture definitive du fichier ISS """
		
		# Pour ecriture dans fichier (la partie [Setup])
		iss_setup = self.commentaireEntete + '\n\n' + self.setup + '\n' + self.AppCopyright + '\n' + self.AppName + '\n' +  self.Com_AppVerName + '\n' + self.AppVerName + '\n' + self.DefaultDirName + '\n' + self.Com_OutputDir_01 + '\n' + self.Com_OutputDir_02 + '\n' + self.Com_OutputDir_03 + '\n' + self.Com_OutputDir_04 + '\n' + self.OutputDir + '\n' + self.Com_OutputBaseFilename_01 + '\n' +  self.OutputBaseFilename + '\n' + self.VersionInfoCompany + '\n' + self.VersionInfoDescription + '\n' + self.Com_OutputManifestFile_01 + '\n' + self.Com_OutputManifestFile_02 + '\n' + self.Com_OutputManifestFile_03 + '\n' + self.Com_OutputManifestFile_04 + '\n' + self.OutputManifestFile + '\n' + self.VersionInfoCopyright + '\n' + self.Com_SetupIconFile_01 + '\n' + self.SetupIconFile + '\n' + self.AppPublisher + '\n' + self.AppPublisherURL + '\n' + self.AppSupportURL + '\n' + self.AppUpdatesURL + '\n' + self.Com_AppVersion_01 + '\n' + self.AppVersion + '\n' + self.Com_UninstallDisplayIcon_01 + '\n' + self.UninstallDisplayIcon + '\n' + self.Compression + '\n' + self.AllowUNCPath + '\n' + self.InternalCompressLevel + '\n' + self.ChangesAssociations + '\n' + self.EnableDirDoesntExistWarning + '\n' + self.DisableProgramGroupPage + '\n' + self.ShowTasksTreeLines + '\n' + self.AppContact + '\n' + self.UninstallRestartComputer + '\n' + self.Com_UninstallFilesDir_01 + '\n' + self.Com_UninstallFilesDir_02 + '\n' + self.UninstallFilesDir + '\n' + self.Com_AlwaysRestart_01 + '\n' + self.Com_AlwaysRestart_02 + '\n' + self.AlwaysRestart

                # Ecriture de la partie [Setup] dans le fichier 
		#
		# Pour windows uniquement
		if os.name == 'nt':
			ecrCheminFich_01=open(self.appli_chemin_vers_arbo + self.sep + self.appli_nom_fichier_iss, 'w')
		# Pour Linux et MacOSX
		elif os.name in ['posix', 'mac']:
			ecrCheminFich_01=open(self.oi + os.sep + self.appli_nom_fichier_iss, 'w')
                ecrCheminFich_01.write(iss_setup)
                ecrCheminFich_01.close()
		
		# Pour ecriture dans fichier (l'entete de la partie [Files])
		iss_files_entete = '\n\n' + self.files + '\n' + self.Com_Files_01 + '\n' + self.Com_Files_02 + '\n' + self.Com_Files_03 + '\n' + self.Com_Files_04 + '\n'
		
		# Ecriture de l'entete de la partie [Files] dans le fichier 
		#
		# Pour windows uniquement
		if os.name == 'nt':
			ecrCheminFich_02=open(self.appli_chemin_vers_arbo + self.sep + self.appli_nom_fichier_iss, 'a')
		# Pour Linux et MacOSX
		elif os.name in ['posix', 'mac']:
			ecrCheminFich_02=open(self.oi + os.sep + self.appli_nom_fichier_iss, 'a')
                ecrCheminFich_02.write(iss_files_entete)
                ecrCheminFich_02.close()		
		
		# Ecriture de tous les fichiers presents a la racine de l'arborescence de l'application  
		# dans la partie [Files] du fichier
		for parc_aip in self.arbo_interne_appli_03:
			iss_files_fich_racine = "Source: " + self.appli_chemin_vers_arbo + parc_aip + "; DestDir: {app}" + "\n"
			# Pour windows uniquement
			if os.name == 'nt':
				ecrCheminFich_03=open(self.appli_chemin_vers_arbo + self.sep + self.appli_nom_fichier_iss, 'a')
			# Pour Linux et MacOSX
			elif os.name in ['posix', 'mac']:
				ecrCheminFich_03=open(self.oi + os.sep + self.appli_nom_fichier_iss, 'a')
			ecrCheminFich_03.write(iss_files_fich_racine)
			ecrCheminFich_03.close()
			
		# Ecriture de tous les fichiers presents dans tous les repertoires de  
		# l'arborescence de l'application dans la partie [Files] du fichier
		# -------------------------------------------------------------------
		# Sous Windows:
		# -------------
		# Attention dans la variable iss_files_fin ici on ne recupere que les
		# repertoires (et pas les fichiers) d'ou: os.path.dirname(parc_chem_fin)
		#
		# Sous Linux et MacOSX:
		# ---------------------
		# Mise en place d'une petite stratégie (lire les commentaires dans 
		# les lignes concernées)
		# -------------------------------------------------------------------
		for parc_chem_fin in self.listeInterInterArboInterneAppliFichDifferents:
			# Pour windows uniquement
			if os.name == 'nt':
				iss_files_fin = "Source: " + self.appli_chemin_vers_arbo + parc_chem_fin + "; DestDir: {app}" + os.path.dirname(parc_chem_fin) + "\n"
			# Pour Linux et MacOSX
			elif os.name in ['posix', 'mac']:
				# Remplacement du separateur \\ par le separateur du systeme
				parc_chem_fin = parc_chem_fin.replace(self.sep, os.sep)
				# Maintenant on peut recuperer uniquement le repertoire et pas le fichier --> os.path.dirname(parc_chem_fin)
				iss_files_fin = "Source: " + self.appli_chemin_vers_arbo + parc_chem_fin + "; DestDir: {app}" + os.path.dirname(parc_chem_fin) + "\n"
				# On revient en arriere --> remplacement du separateur 
				# du systeme par \\ (comme ds les chemins sous windows)
				iss_files_fin = iss_files_fin.replace(os.sep, self.sep)
			# Pour windows uniquement
			if os.name == 'nt':
				ecrCheminFich_04=open(self.appli_chemin_vers_arbo + self.sep + self.appli_nom_fichier_iss, 'a')
			# Pour Linux et MacOSX
			elif os.name in ['posix', 'mac']:
				ecrCheminFich_04=open(self.oi + os.sep + self.appli_nom_fichier_iss, 'a')
			ecrCheminFich_04.write(iss_files_fin)
			ecrCheminFich_04.close()
			
		# Pour ecriture dans fichier (la partie [Languages])
		iss_languages = '\n' + self.languages + '\n' + self.lang_anglais + '\n' + self.lang_francais + '\n' + self.lang_espagnol
		
		# Ecriture de l'entete de la partie [Languages] dans le fichier 
		#
		# Pour windows uniquement
		if os.name == 'nt':
			ecrCheminFich_05=open(self.appli_chemin_vers_arbo + self.sep + self.appli_nom_fichier_iss, 'a')
		# Pour Linux et MacOSX
		elif os.name in ['posix', 'mac']:
			ecrCheminFich_05=open(self.oi + os.sep + self.appli_nom_fichier_iss, 'a')
                ecrCheminFich_05.write(iss_languages)
                ecrCheminFich_05.close()

		# Pour ecriture dans fichier (la partie [Icons])
		iss_icons = '\n\n' + self.icons + '\n' + self.icones_01 + '\n' + self.icones_02 + '\n' + self.icones_03 + '\n' + self.icones_04 + '\n' + self.icones_05
		
		# Ecriture de la partie [Icons] dans le fichier 
		#
		# Pour windows uniquement
		if os.name == 'nt':
			ecrCheminFich_06=open(self.appli_chemin_vers_arbo + self.sep + self.appli_nom_fichier_iss, 'a')
		# Pour Linux et MacOSX
		elif os.name in ['posix', 'mac']:
			ecrCheminFich_06=open(self.oi + os.sep + self.appli_nom_fichier_iss, 'a')
                ecrCheminFich_06.write(iss_icons)
                ecrCheminFich_06.close()

		# Pour ecriture dans fichier (la partie [UninstallDelete])
		iss_unistall_delete = '\n\n' + self.uninstall_delete + '\n' + self.Com_UninstallDelete_Entete_01 + '\n' + self.Com_UninstallDelete_Entete_02 + '\n' + self.Com_UninstallDelete_Entete_03 + '\n' + self.Com_UninstallDelete_Retirer_Rep_et_Fich_01 + '\n' + self.Com_UninstallDelete_Retirer_Rep_et_Fich_02 + '\n' + self.desinstaller_01 + '\n' + self.Com_UninstallDelete_Retirer_Rep_et_Fich_01 + '\n' + self.desinstaller_02 + '\n' + self.desinstaller_03 + '\n' + self.Com_UninstallDelete_Retirer_Reps_recalcitrants_01 + '\n' + self.desinstaller_04
		
		# Ecriture de la partie [UninstallDelete] dans le fichier 
		#
		# Pour windows uniquement
		if os.name == 'nt':
			ecrCheminFich_07=open(self.appli_chemin_vers_arbo + self.sep + self.appli_nom_fichier_iss, 'a')
		# Pour Linux et MacOSX
		elif os.name in ['posix', 'mac']:
			ecrCheminFich_07=open(self.oi + os.sep + self.appli_nom_fichier_iss, 'a')
                ecrCheminFich_07.write(iss_unistall_delete)
                ecrCheminFich_07.close()
		
		# Pour ecriture dans fichier (la partie [Messages])
		iss_messages = '\n\n' + self.messages + '\n' + self.AboutSetupNote_01 + '\n' + self.AboutSetupNote_02 + '\n'
		
		# Ecriture de la partie [Messages] dans le fichier 
		#
		# Pour windows uniquement
		if os.name == 'nt':
			ecrCheminFich_08=open(self.appli_chemin_vers_arbo + self.sep + self.appli_nom_fichier_iss, 'a')
		# Pour Linux et MacOSX
		elif os.name in ['posix', 'mac']:
			ecrCheminFich_08=open(self.oi + os.sep + self.appli_nom_fichier_iss, 'a')
                ecrCheminFich_08.write(iss_messages)
                ecrCheminFich_08.close()
		
		
	def message_final(self):
	
		""" Message final affiche dans la fenetre MS-DOS sous windows ou la console sous Linux """
		
		print
		print "La creation du fichier ISS (.iss) pour Inno Setup s'est bien deroule (!)."
		print
		
		fich_iss_linux_mac = self.oi + os.sep + self.appli_nom_fichier_iss
		# Pour windows uniquement
		if os.name == 'nt':
			liste_fich_iss_win = glob.glob(self.appli_chemin_vers_arbo + self.sep + "*.iss")
			print "Votre fichier ISS apres enregistrement se trouve ici:", liste_fich_iss_win[0]
		# Pour Linux et MacOSX
		elif os.name in ['posix', 'mac']:
			liste_fich_iss_linux_mac = glob.glob(self.oi + os.sep + "*.iss")
			print "Votre fichier ISS apres enregistrement se trouve ici:", liste_fich_iss_linux_mac[0]
			
		print
		

# Appel de la classe
main = Appli_Windows_Fich_iss_pour_exe()
