/*-------------------------------------------------------------------------*\

	FILE........: DTMFS.H
	TYPE........: C Header File
	COMPANY.....: VoiceTronix
	AUTHOR......: David Rowe
	DATE CREATED: 21/10/96

	Typedef for structure used to store DTMF state variables.

\*-------------------------------------------------------------------------*/

#ifndef __DTMFS__
#define __DTMFS__

#include <stdint.h>

#define	DMEM		20	/* state debug memory length		*/

/* structure that contains state variables required for DTMF -----------*/

typedef struct {
    short   x[NDTMF];		/* buffer used for DTMF processing 	*/
    int     samples;		/* number of samples in x[] so far 	*/
    int     state;		/* curent state of DTMF state machine	*/
    int	    code;		/* code for possible DTMF tone		*/
    int     testmode;          	/* asserted for debugging printf's	*/
    int     states[DMEM];	/* debug memory				*/
    int     retcodes[DMEM];	/* debug memory				*/
    int16_t e;			/* current frame energy			*/
    int16_t etone;		/* frame energy during tone		*/
    int     env;		/* state variable for tone envelope	*/
} DTMFS;

#endif	/* __DTMFS__ */
