/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.networking;

import java.util.ArrayList;
import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLContentStateListener;
import org.web3d.vrml.nodes.VRMLEnvironmentalSensorNodeType;
import org.web3d.vrml.nodes.VRMLExternalNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLSensorNodeType;
import org.web3d.vrml.nodes.VRMLSingleExternalNodeType;
import org.web3d.vrml.nodes.VRMLTimeDependentNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseSensorNode;

public class BaseLoadSensor
extends BaseSensorNode
implements VRMLEnvironmentalSensorNodeType,
VRMLTimeDependentNodeType,
VRMLContentStateListener {
    private static final int[] SECONDARY_TYPE = new int[]{52};
    protected static final int FIELD_WATCHLIST = 3;
    protected static final int FIELD_TIMEOUT = 4;
    protected static final int FIELD_LOAD_TIME = 5;
    protected static final int FIELD_IS_LOADED = 6;
    protected static final int FIELD_PROGRESS = 7;
    protected static final int LAST_LOADSENSOR_INDEX = 7;
    protected static final int NUM_FIELDS = 8;
    protected static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected ArrayList vfWatchList;
    protected double vfTimeout;
    protected double vfLoadTime;
    protected boolean vfIsLoaded;
    protected float vfProgress;
    private VRMLClock vrmlClock;
    private int loadCnt;
    private boolean failed;
    private boolean isActiveChanged;

    public BaseLoadSensor() {
        super("LoadSensor");
        this.hasChanged = new boolean[8];
        this.vfEnabled = true;
        this.vfIsActive = false;
        this.isActiveChanged = false;
        this.vfWatchList = new ArrayList();
        this.vfTimeout = 0.0;
        this.vfProgress = 0.0f;
        this.vfIsLoaded = false;
        this.loadCnt = 0;
        this.failed = false;
    }

    public BaseLoadSensor(VRMLNodeType vRMLNodeType) {
        this();
        this.copy((VRMLSensorNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("timeout");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfTimeout = vRMLFieldData.longValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void allEventsComplete() {
        if (this.failed) {
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
            return;
        }
        this.hasChanged[7] = true;
        this.fireFieldChanged(7);
        if ((double)this.vfProgress == 1.0) {
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
        if (this.isActiveChanged) {
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    public void setVRMLClock(VRMLClock vRMLClock) {
        this.vrmlClock = vRMLClock;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 7) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 14;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfEnabled;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 3: {
                VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[this.vfWatchList.size()];
                this.vfWatchList.toArray(vRMLNodeTypeArray);
                vRMLFieldData.clear();
                vRMLFieldData.nodeArrayValue = vRMLNodeTypeArray;
                vRMLFieldData.dataType = (short)13;
                vRMLFieldData.numElements = vRMLNodeTypeArray.length;
                break;
            }
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfIsActive;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfIsLoaded;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.doubleValue = this.vfLoadTime;
                vRMLFieldData.dataType = (short)5;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.doubleValue = this.vfTimeout;
                vRMLFieldData.dataType = (short)5;
                break;
            }
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfProgress;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfEnabled);
                    break;
                }
                case 3: {
                    VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[this.vfWatchList.size()];
                    this.vfWatchList.toArray(vRMLNodeTypeArray);
                    vRMLNodeType.setValue(n2, vRMLNodeTypeArray, vRMLNodeTypeArray.length);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfTimeout);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfIsActive);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfLoadTime);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfIsLoaded);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfProgress);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field! " + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.vfEnabled = bl;
                if (this.inSetup) break;
                this.hasChanged[1] = true;
                this.fireFieldChanged(1);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, double d) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 4: {
                this.vfTimeout = d;
                if (this.inSetup) break;
                this.hasChanged[4] = true;
                this.fireFieldChanged(4);
                break;
            }
            default: {
                super.setValue(n, d);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException {
        switch (n) {
            case 3: {
                boolean bl = true;
                if (this.loadCnt > this.vfWatchList.size()) {
                    bl = false;
                }
                this.clearChildren();
                this.addChildNode(vRMLNodeType);
                if (vRMLNodeType != null) {
                    this.vfIsLoaded = false;
                }
                this.failed = false;
                if (this.inSetup || !bl) break;
                this.stateManager.addEndOfThisFrameListener(this);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
        this.hasChanged[n] = true;
        this.fireFieldChanged(n);
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 3: {
                boolean bl = true;
                if (this.loadCnt > this.vfWatchList.size()) {
                    bl = false;
                }
                this.clearChildren();
                for (int i = 0; i < n2; ++i) {
                    this.addChildNode(vRMLNodeTypeArray[i]);
                }
                if (n2 != 0) {
                    this.vfIsLoaded = false;
                }
                this.failed = false;
                if (this.inSetup || !bl) break;
                this.stateManager.addEndOfThisFrameListener(this);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeTypeArray, n2);
            }
        }
        this.hasChanged[n] = true;
        this.fireFieldChanged(n);
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        int n = this.vfWatchList.size();
        for (int i = 0; i < n; ++i) {
            VRMLNodeType vRMLNodeType = (VRMLNodeType)this.vfWatchList.get(i);
            vRMLNodeType.setupFinished();
        }
    }

    public void contentStateChanged(VRMLNodeType vRMLNodeType, int n, int n2) {
        if (!this.vfEnabled) {
            return;
        }
        int n3 = this.vfWatchList.size();
        switch (n2) {
            case 3: {
                ++this.loadCnt;
                if (this.loadCnt >= n3) {
                    this.vfProgress = 1.0f;
                    this.vfIsLoaded = true;
                    this.vfLoadTime = this.vrmlClock.getTime();
                    this.vfIsActive = false;
                    this.isActiveChanged = true;
                } else {
                    this.vfProgress = (float)this.loadCnt / (float)n3;
                }
                this.stateManager.addEndOfThisFrameListener(this);
                break;
            }
            case 4: {
                if (this.failed) break;
                this.vfIsLoaded = false;
                this.vfIsActive = false;
                this.isActiveChanged = true;
                this.failed = true;
                this.stateManager.addEndOfThisFrameListener(this);
                break;
            }
        }
    }

    private void clearChildren() {
        if (this.inSetup) {
            return;
        }
        int n = this.vfWatchList.size();
        for (int i = 0; i < n; ++i) {
            VRMLNodeType vRMLNodeType = (VRMLNodeType)this.vfWatchList.get(i);
            if (!(vRMLNodeType instanceof VRMLExternalNodeType)) continue;
            VRMLExternalNodeType vRMLExternalNodeType = (VRMLExternalNodeType)((Object)vRMLNodeType);
            vRMLExternalNodeType.removeContentStateListener(this);
        }
        this.vfWatchList.clear();
        this.loadCnt = 0;
        this.vfProgress = 0.0f;
    }

    private void addChildNode(VRMLNodeType vRMLNodeType) {
        this.vfWatchList.add(vRMLNodeType);
        if (vRMLNodeType != null) {
            if (!(vRMLNodeType instanceof VRMLSingleExternalNodeType)) {
                ++this.loadCnt;
            } else {
                VRMLSingleExternalNodeType vRMLSingleExternalNodeType = (VRMLSingleExternalNodeType)((Object)vRMLNodeType);
                vRMLSingleExternalNodeType.addContentStateListener(this);
            }
        }
    }

    static {
        nodeFields = new int[]{3, 0};
        fieldDecl = new VRMLFieldDeclaration[8];
        fieldMap = new HashMap(24);
        BaseLoadSensor.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseLoadSensor.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseLoadSensor.fieldDecl[3] = new VRMLFieldDeclaration(3, "MFNode", "watchList");
        BaseLoadSensor.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFTime", "timeOut");
        BaseLoadSensor.fieldDecl[2] = new VRMLFieldDeclaration(4, "SFBool", "isActive");
        BaseLoadSensor.fieldDecl[5] = new VRMLFieldDeclaration(4, "SFTime", "loadTime");
        BaseLoadSensor.fieldDecl[6] = new VRMLFieldDeclaration(4, "SFBool", "isLoaded");
        BaseLoadSensor.fieldDecl[7] = new VRMLFieldDeclaration(4, "SFFloat", "progress");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        n = new Integer(3);
        fieldMap.put("watchList", n);
        fieldMap.put("set_watchList", n);
        fieldMap.put("watchList_changed", n);
        n = new Integer(4);
        fieldMap.put("timeOut", n);
        fieldMap.put("set_timeOut", n);
        fieldMap.put("timeOut_changed", n);
        n = new Integer(2);
        fieldMap.put("isActive", n);
        fieldMap.put("isActive_changed", n);
        n = new Integer(5);
        fieldMap.put("loadTime", n);
        fieldMap.put("loadTime_changed", n);
        n = new Integer(6);
        fieldMap.put("isLoaded", n);
        fieldMap.put("isLoaded_changed", n);
        n = new Integer(7);
        fieldMap.put("progress", n);
        fieldMap.put("progress_changed", n);
    }
}

