/*
 * Copyright (c) 2006 Alvaro Lopes <alvieboy@alvie.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "config.h"
#include "modem_driver.h"
#include <string.h>

#ifdef HAVE_FAKE_MODEM
#include "modem_driver_fake.h"
#endif

#include "modem_driver_generic.h"

/**
 * @brief Find the appropriate driver by its name
 *
 * @param name The driver's name
 *
 * @returns NULL if no driver found, the driver instance otherwise
 *
 */

modem_driver_t *find_driver_by_name( const gchar *name )
{
    int idx;
    for (idx=0; drivers[idx]; idx++) {
	if ( strcmp( name, drivers[idx]->name )==0 )
            return drivers[idx];
    }
    return NULL;
}

/**
 * @brief Find the appropriate driver by its index
 *
 * @param name The driver's index (0...)
 *
 * @returns NULL if no driver found, the driver instance otherwise
 * @bugs Currently no bound checking is done.
 *
 */

modem_driver_t *find_driver_by_index( const int idx )
{
    /* TODO: Check bounds */

    return drivers[idx];
}

/**
 * @brief Find the appropriate driver index by its name
 *
 * @param name The driver's name
 *
 * @returns -1 if no driver found, the driver index in table otherwise
 *
 */

int find_driver_index_by_name( const gchar *name )
{
    int idx;
    for (idx=0; drivers[idx]; idx++) {
	if ( strcmp( name, drivers[idx]->name )==0 )
            return idx;
    }
    return -1;
}

/** The driver registry.
 ** All drivers must register here, or they won't be visible.
 */


modem_driver_t *drivers[] = {
    &modem_driver_generic,
#ifdef HAVE_FAKE_MODEM
    &modem_driver_fake,
    NULL
#endif
};
