/*****************************************************************************
 * broadcast.cpp : SAP Broadcast class
 ****************************************************************************
 * Copyright (C) 1998-2003 VideoLAN
 * $Id: broadcast.cpp,v 1.1 2003/05/22 02:22:45 nitrox Exp $
 *
 * Authors: Damien Lucas <nitrox@videolan.org>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string>
#include <vector>
using namespace std;

#include "program.h"
#include "message.h"
#include "broadcast.h"

Broadcast::Broadcast(unsigned int t)
{
    group=HELLO_GROUP;
    port=HELLO_PORT;
    ttl=t;
    return;
}


Broadcast::~Broadcast(){return;}


int Broadcast::Init(void)
{
    if ((fd=socket(AF_INET,SOCK_DGRAM,0)) < 0)
    {
        perror("socket");
        return(-1);
    }

    /* set up destination address */
    memset(&addr,0,sizeof(addr));
    addr.sin_family=AF_INET;
    addr.sin_addr.s_addr=inet_addr(group);
    addr.sin_port=htons(port);
    setsockopt( fd, IPPROTO_IP, IP_MULTICAST_TTL, &ttl, sizeof(ttl) );

    return 0;
}

int Broadcast::Send(Message* m)
{
    /* Create the final message */
    m->CreateFinalMessage();

    /* Get the message and the length */
    char* message=m->GetFinalMessage();
    unsigned int length=m->GetFinalMessageLen();
    if(message==NULL)
    {
        fprintf(stderr, "Bad message, skipping\n");
        return (-1);
    }

    if (sendto(fd,message,length,0,
               (struct sockaddr *) &addr,sizeof(addr)) < 0)
    {
        perror("sendto");
        return(-1);
    }
    return 0;
}
