"""API generator for decorator classes.
"""

__author__ = "Patrick K. O'Brien <pobrien@orbtech.com>"
__cvsid__ = "$Id: genapi.py,v 1.2 2003/07/02 23:11:44 RD Exp $"
__revision__ = "$Revision: 1.2 $"[11:-2]


import inspect
import os
import sys
import types


header = '''\
"""wxPython decorator classes.

This file is automatically generated, and these are not the real
wxPython classes.  These are Python versions for API documentation
purposes only.

Please send corrections, questions, and suggestions to:

Patrick K. O'Brien <pobrien@orbtech.com>
"""

__author__ = "Patrick K. O'Brien <pobrien@orbtech.com>"

from wxd import Parameters as wx

try:
    True
except NameError:
    True = 1==1
    False = 1==0
'''

modlist = [
    'Base',
    'Window',
    'Frames',
    'Accelerators',
    'App',
    'ClipDragDrop',
    'Config',
    'Controls',
    'DataStructures',
    'DateTime',
    'Dialogs',
    'Drawing',
    'Errors',
    'EventFunctions',
    'Events',
    'FileSystem',
    'Functions',
    'Help',
    'ImageHandlers',
    'Joystick',
    'LayoutConstraints',
    'Logging',
    'Menus',
    'MimeTypes',
    'Misc',
    'Panel',
    'Printing',
    'Process',
    'SashSplitter',
    'Sizers',
    'Streams',
    'Threading',
    'ToolBar',
    'Tree',
    'Validators',
    ]

dir = os.path.realpath('api/wx/')
filename = os.path.join(dir, '__init__.py')

def main():
    modules = {}
    f = file(filename, 'w')
    f.write(header)
    for modname in modlist:
        modules[modname] = __import__(modname, globals())
    for modname in modlist:
        module = modules[modname]
        try:
            source = inspect.getsource(module)
        except IOError:
            print 'No source for', module
        else:
            # Remove everything up to the first class or function definition.
            splitter = '\n\nclass '
            parts = source.split(splitter, 1)
            if len(parts) == 2:
                source = splitter + parts[1]
            else:
                splitter = '\n\ndef '
                parts = source.split(splitter, 1)
                if len(parts) == 2:
                    source = splitter + parts[1]
            source = '\n\n\n' + source.strip()
            f.write(source)
            print 'Writing', modname
    f.write('\n')
    f.close()

    # Add constants and any other missing stuff.
    f = file(filename, 'a')
    f.write('\n\n## Other Stuff:\n\n')
    import wx as old
    old = old.__dict__
    sys.path.insert(0, dir) # Munge the sys.path so that we can
    import __init__         # import the file we just created.
    new = __init__.__dict__
    l = [(k, v) for (k, v) in old.items() if (not k.startswith('_')
                                              and not k.endswith('Ptr')
                                              and not (k == 'cvar'))]
    l.sort()
    from wxPython import wx
    for key, value in l:
        if key not in new:
            if (inspect.isclass(value)
                or inspect.isroutine(value)
                or type(value) is types.InstanceType):
                value = repr(value)
            text = '%s = %r' % (key, value)
            f.write(text + '\n')
            print 'Writing', text
    f.close()

if __name__ == '__main__':
    main()
