/*****************************************************************************
 * error.c: error routines for VLMS
 *****************************************************************************
 * Copyright (C) 1007, 1998, 1999, 2000 VideoLAN
 *
 * Authors:
 * Regis Duchesne,     VIA, ECP, France <regis@via.ecp.fr>,  27/01/97
 * Michel Lespinasse,  VIA, ECP, France <walken@via.ecp.fr>, 02/02/97
 * Jean-Marc Dressler, VIA, ECP, France <polux@via.ecp.fr>,  17/05/99
 * Samuel Hocevar,     VIA, ECP, France <sam@via.ecp.fr>,    17/12/99
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 ****************************************************************************/

/* va_list */
#include <stdarg.h>
/* errno */
#include <errno.h>
/* vsprintf */
#include <stdio.h>
/* strcat */
#include <string.h>

static void err_doit(int errnoflag, const char *fmt, va_list ap)
{
    int errno_save;
    char buf[4096];

    errno_save = errno;     /* value caller might want printed */
    vsprintf(buf, fmt, ap);
    if (errnoflag)
	sprintf(buf+strlen(buf), " : %s", strerror(errno_save));
    strcat(buf, "\n");
    fflush(stdout);         /* in case stdout and stderr are the same */
    fputs(buf, stderr);
    fflush(stderr);         /* SunOS 4.1.* doesn't grok NULL argument */
    return;
}

void err_sys(const char *fmt, ...)
{
    va_list ap;

    va_start(ap, fmt);
    err_doit(1, fmt, ap);
    va_end(ap);
    exit(1);
}

void err_quit(const char *fmt, ...)
{
    va_list ap;

    va_start(ap, fmt);
    err_doit(0, fmt, ap);
    va_end(ap);
    exit(1);
}
