
#define PS_BUFFER_SIZE 16384
#define NO_PES 0
#define AUDIO_PES 1
#define VIDEO_PES 2
#define AC3_PES 3
#define SUBTITLE_PES 4
#define LPCM_PES 5
#define PRIVATE_PES 6
#define UNKNOWN_PES 12

#define PCR_PID 0x20 /* 0x20 == first video stream
		      * 0x40 == first audio stream */

typedef struct s_ps
{
    unsigned int pat_counter;
    unsigned int pmt_counter;

    /* These 3 parameters are passed 
     * as command line arguments
     *
     * 16 audio mpeg streams
     * 16 audio AV3 streams
     * 16 video mpeg streams
     * 32 subtitle streams */
    unsigned int audio_channel;
    unsigned int subtitles_channel;
    unsigned int audio_type; 
    
    unsigned int media_counter[0x100];
    unsigned int association_table[0x100];
    unsigned int found_streams;

    unsigned int found_scr;

    unsigned int ts_to_write;
    unsigned int ts_written;
    unsigned int sent_ts;

    unsigned char *ps_data;
    unsigned char *ps_end;
    unsigned char *ps_buffer;

    unsigned int pes_id;
    unsigned int private_id;
    s64          scr;
    unsigned int pcr_pid;

    unsigned int pes_type;
    unsigned int pes_size;
    unsigned int to_skip;
    unsigned int offset;
} ps_t;

void    ps_fill          ( options_t *options, unsigned int *left, int wait,
                           ps_t *ps );
ssize_t ps_read          ( options_t *options, ps_t *ps, void *ts );
void    write_media_ts   ( ps_t *ps, unsigned char *ts, unsigned int pid );
void    write_pat        ( ps_t *ps, unsigned char *ts );
void    write_pmt        ( ps_t *ps, unsigned char *ts );
int     full_write       ( int desc, const char *ptr, size_t len );

