/* packet-nbap.c
 * Routines for UMTS Node B Application Part(NBAP) packet dissection
 * Copyright 2005, Anders Broman <anders.broman@ericsson.com>
 *
 * $Id: packet-nbap-template.c 21927 2007-05-24 20:42:55Z etxrab $
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ref: 3GPP TS 25.433 version 6.6.0 Release 6
 */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <glib.h>
#include <epan/packet.h>
#include <epan/conversation.h>

#include <stdio.h>
#include <string.h>

#include <epan/asn1.h>

#include "packet-nbap.h"
#include "packet-ber.h"
#include "packet-per.h"

#define PNAME  "UTRAN Iub interface NBAP signalling"
#define PSNAME "NBAP"
#define PFNAME "nbap"



static dissector_handle_t nbap_handle=NULL;

/* Initialize the protocol and registered fields */
static int proto_nbap = -1;

static int hf_nbap_pdu_length = -1;
static int hf_nbap_IE_length = -1;

#include "packet-nbap-hf.c"

/* Initialize the subtree pointers */
static int ett_nbap = -1;
static int ett_nbap_initiatingMessageValue = -1;
static int ett_nbap_ProtocolIEValueValue = -1;
static int ett_nbap_SuccessfulOutcomeValue = -1;
static int ett_nbap_UnsuccessfulOutcomeValue = -1;

#include "packet-nbap-ett.c"

/* Global variables */
static proto_tree *top_tree;
static guint32 ProcedureCode;
static guint32 ProtocolIE_ID;
static guint32 ddMode;

#define BYTE_ALIGN_OFFSET(offset)		\
	if(offset&0x07){			\
		offset=(offset&0xfffffff8)+8;	\
	}
#define NBAP_FDD 1
/* Prodedure ID:s */
#define NBAP_ID_AUDIT 												0
#define NBAP_ID_AUDITREQUIRED 										1
#define NBAP_ID_BLOCKRESOURCE 										2
#define NBAP_ID_CELLDELETION 										3
#define NBAP_ID_CELLRECONFIGURATION 								4
#define NBAP_ID_CELLSETUP 											5
#define NBAP_ID_COMMONMEASUREMENTFAILURE 							6
#define NBAP_ID_COMMONMEASUREMENTINITIATION 						7
#define NBAP_ID_COMMONMEASUREMENTREPORT 							8
#define NBAP_ID_COMMONMEASUREMENTTERMINATION 						9
#define NBAP_ID_COMMONTRANSPORTCHANNELDELETE 						10
#define NBAP_ID_COMMONTRANSPORTCHANNELRECONFIGURE 					11
#define NBAP_ID_COMMONTRANSPORTCHANNELSETUP 						12
#define NBAP_ID_RESET												13
#define NBAP_ID_COMPRESSEDMODECOMMAND 								14
#define NBAP_ID_DEDICATEDMEASUREMENTFAILURE 						16
#define NBAP_ID_DEDICATEDMEASUREMENTINITIATION 						17
#define NBAP_ID_DEDICATEDMEASUREMENTREPORT 							18
#define NBAP_ID_DEDICATEDMEASUREMENTTERMINATION 					19
#define NBAP_ID_DOWNLINKPOWERCONTROL 								20
#define NBAP_ID_ERRORINDICATIONFORDEDICATED							21
#define NBAP_ID_PRIVATEMESSAGEFORDEDICATED							22
#define NBAP_ID_RADIOLINKADDITION 									23
#define NBAP_ID_RADIOLINKDELETION 									24
#define NBAP_ID_RADIOLINKFAILURE 									25
#define NBAP_ID_RADIOLINKRESTORATION 								26
#define NBAP_ID_RADIOLINKSETUP 										27
#define NBAP_ID_RESOURCESTATUSINDICATION 							28
#define NBAP_ID_SYNCHRONISEDRADIOLINKRECONFIGURATIONCANCELLATION	29
#define NBAP_ID_SYNCHRONISEDRADIOLINKRECONFIGURATIONCOMMIT			30
#define NBAP_ID_SYNCHRONISEDRADIOLINKRECONFIGURATIONPREPARATION 	31
#define NBAP_ID_SYSTEMINFORMATIONUPDATE 							32
#define NBAP_ID_UNBLOCKRESOURCE 									33
#define NBAP_ID_UNSYNCHRONISEDRADIOLINKRECONFIGURATION 				34
#define NBAP_ID_ERRORINDICATIONFORCOMMON							35
#define NBAP_ID_PRIVATEMESSAGEFORCOMMON								36
#define NBAP_ID_PHYSICALSHAREDCHANNELRECONFIGURATION 				37
#define NBAP_ID_DOWNLINKPOWERTIMESLOTCONTROL 						38
#define NBAP_ID_RADIOLINKPREEMPTION									39
#define NBAP_ID_INFORMATIONEXCHANGEFAILURE							40
#define NBAP_ID_INFORMATIONEXCHANGEINITIATION						41
#define NBAP_ID_INFORMATIONEXCHANGETERMINATION						42
#define NBAP_ID_INFORMATIONREPORTING								43
#define NBAP_ID_CELLSYNCHRONISATIONADJUSTMENT						44
#define NBAP_ID_CELLSYNCHRONISATIONINITIATION						45
#define NBAP_ID_CELLSYNCHRONISATIONRECONFIGURATION					46
#define NBAP_ID_CELLSYNCHRONISATIONREPORTING						47
#define NBAP_ID_CELLSYNCHRONISATIONTERMINATION						48
#define NBAP_ID_CELLSYNCHRONISATIONFAILURE							49
#define NBAP_ID_BEARERREARRANGEMENT									50
#define NBAP_ID_RADIOLINKACTIVATION									51
#define NBAP_ID_RADIOLINKPARAMETERUPDATE							52
#define NBAP_ID_MBMSNOTIFICATIONUPDATE								53

/* Protocol IE:s */
#define NBAP_IE_ID_AICH_INFORMATION													0
#define NBAP_IE_ID_AICH_INFORMATIONITEM_RESOURCESTATUSIND							1
#define NBAP_IE_ID_BCH_INFORMATION													7
#define NBAP_IE_ID_BCH_INFORMATIONITEM_RESOURCESTATUSIND							8
#define NBAP_IE_ID_BCCH_MODIFICATIONTIME											9
#define NBAP_IE_ID_BLOCKINGPRIORITYINDICATOR										10
#define NBAP_IE_ID_CAUSE															13
#define NBAP_IE_ID_CCP_INFORMATIONITEM_AUDITRSP										14
#define NBAP_IE_ID_CCP_INFORMATIONLIST_AUDITRSP										15
#define NBAP_IE_ID_CCP_INFORMATIONITEM_RESOURCESTATUSIND							16
#define NBAP_IE_ID_CELL_INFORMATIONITEM_AUDITRSP									17
#define NBAP_IE_ID_CELL_INFORMATIONITEM_RESOURCESTATUSIND							18
#define NBAP_IE_ID_CELL_INFORMATIONLIST_AUDITRSP									19
#define NBAP_IE_ID_CELLPARAMETERID													23
#define NBAP_IE_ID_CFN																24
#define NBAP_IE_ID_C_ID																25

#define NBAP_IE_ID_COMMONMEASUREMENTACCURACY										39
#define NBAP_IE_ID_COMMONMEASUREMENTOBJECTTYPE_CM_RPRT								31
#define NBAP_IE_ID_COMMONMEASUREMENTOBJECTTYPE_CM_RQST								32
#define NBAP_IE_ID_COMMONMEASUREMENTOBJECTTYPE_CM_RSP								33
#define NBAP_IE_ID_COMMONMEASUREMENTTYPE											34
#define NBAP_IE_ID_COMMONPHYSICALCHANNELID											35
#define NBAP_IE_ID_COMMONPHYSICALCHANNELTYPE_CTCH_SETUPRQSTFDD						36
#define NBAP_IE_ID_COMMONPHYSICALCHANNELTYPE_CTCH_SETUPRQSTTDD						37
#define NBAP_IE_ID_COMMUNICATIONCONTROLPORTID										40
#define NBAP_IE_ID_CONFIGURATIONGENERATIONID										43
#define NBAP_IE_ID_CRNC_COMMUNICATIONCONTEXTID										44
#define NBAP_IE_ID_CRITICALITYDIAGNOSTICS											45
#define NBAP_IE_ID_DCHS_TO_ADD_FDD													48
#define NBAP_IE_ID_DCH_ADDLIST_RL_RECONFPREPTDD										49
#define NBAP_IE_ID_DCHS_TO_ADD_TDD													50
#define NBAP_IE_ID_DCH_DELETELIST_RL_RECONFPREPFDD									52
#define NBAP_IE_ID_DCH_DELETELIST_RL_RECONFPREPTDD									53
#define NBAP_IE_ID_DCH_DELETELIST_RL_RECONFRQSTFDD									54
#define NBAP_IE_ID_DCH_DELETELIST_RL_RECONFRQSTTDD									55
#define NBAP_IE_ID_DCH_FDD_INFORMATION												56

#define NBAP_IE_ID_DCH_TDD_INFORMATION												57
#define NBAP_IE_ID_DCH_INFORMATIONRESPONSE											59
#define NBAP_IE_ID_FDD_DCHS_TO_MODIFY												62
#define NBAP_IE_ID_TDD_DCHS_TO_MODIFY												63
#define NBAP_IE_ID_DCH_MODIFYLIST_RL_RECONFRQSTTDD									65
#define NBAP_IE_ID_DCH_REARRANGELIST_BEARER_REARRANGEIND							135
#define NBAP_IE_ID_DEDICATEDMEASUREMENTOBJECTTYPE_DM_RPRT							67
#define NBAP_IE_ID_DEDICATEDMEASUREMENTOBJECTTYPE_DM_RQST							68
#define NBAP_IE_ID_DEDICATEDMEASUREMENTOBJECTTYPE_DM_RSP							69
#define NBAP_IE_ID_DEDICATEDMEASUREMENTTYPE											70
#define NBAP_IE_ID_DL_CCTRCH_INFORMATIONITEM_RL_SETUPRQSTTDD						72
#define NBAP_IE_ID_DL_CCTRCH_INFORMATIONLIST_RL_ADDITIONRQSTTDD						73
#define NBAP_IE_ID_DL_CCTRCH_INFORMATIONLIST_RL_SETUPRQSTTDD						76
#define NBAP_IE_ID_DL_DPCH_INFORMATIONITEM_RL_ADDITIONRQSTTDD						77
#define NBAP_IE_ID_DL_DPCH_INFORMATIONLIST_RL_SETUPRQSTTDD							79
#define NBAP_IE_ID_DL_DPCH_INFORMATION_RL_RECONFPREPFDD								81
#define NBAP_IE_ID_DL_DPCH_INFORMATION_RL_RECONFRQSTFDD								82
#define NBAP_IE_ID_DL_DPCH_INFORMATION_RL_SETUPRQSTFDD								83
#define NBAP_IE_ID_DL_DPCH_TIMINGADJUSTMENT											21
#define NBAP_IE_ID_DL_REFERENCEPOWERINFORMATIONITEM_DL_PC_RQST						84
#define NBAP_IE_ID_DLREFERENCEPOWER													85
#define NBAP_IE_ID_DLREFERENCEPOWERLIST_DL_PC_RQST									86
#define NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_87											87
#define NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_89											89
#define NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_91											91
#define NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_93											93
#define NBAP_IE_ID_DSCHS_TO_ADD_TDD													96
#define NBAP_IE_ID_DSCH_INFORMATION_DELETELIST_RL_RECONFPREPTDD						98
#define NBAP_IE_ID_DSCH_INFORMATION_MODIFYLIST_RL_RECONFPREPTDD						100
#define NBAP_IE_ID_DSCH_INFORMATIONRESPONSE											105
#define NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_106											106
#define NBAP_IE_ID_DSCH_TDD_INFORMATION												107
#define NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_108											108
#define NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_112											112
#define NBAP_IE_ID_DSCH_REARRANGELIST_BEARER_REARRANGEIND							136
#define NBAP_IE_ID_END_OF_AUDIT_SEQUENCE_INDICATOR 									113
#define NBAP_IE_ID_FACH_INFORMATION													116
#define NBAP_IE_ID_FACH_INFORMATIONITEM_RESOURCESTATUSIND							117
#define NBAP_IE_ID_FACH_PARAMETERSLIST_CTCH_RECONFRQSTTDD							120
#define NBAP_IE_ID_FACH_PARAMETERSLISTIE_CTCH_SETUPRQSTFDD							121
#define NBAP_IE_ID_FACH_PARAMETERSLISTIE_CTCH_SETUPRQSTTDD							122
#define NBAP_IE_ID_INDICATIONTYPE_RESOURCESTATUSIND									123
#define NBAP_IE_ID_LOCAL_CELL_ID													124
#define NBAP_IE_ID_LOCAL_CELL_GROUP_INFORMATIONITEM_AUDITRSP						2
#define NBAP_IE_ID_LOCAL_CELL_GROUP_INFORMATIONITEM_RESOURCESTATUSIND				3
#define NBAP_IE_ID_LOCAL_CELL_GROUP_INFORMATIONITEM2_RESOURCESTATUSIND				4
#define NBAP_IE_ID_LOCAL_CELL_GROUP_INFORMATIONLIST_AUDITRSP						5
#define NBAP_IE_ID_LOCAL_CELL_INFORMATIONITEM_AUDITRSP								125
#define NBAP_IE_ID_LOCAL_CELL_INFORMATIONITEM_RESOURCESTATUSIND						126
#define NBAP_IE_ID_LOCAL_CELL_INFORMATIONITEM2_RESOURCESTATUSIND					127
#define NBAP_IE_ID_LOCAL_CELL_INFORMATIONLIST_AUDITRSP								128
#define NBAP_IE_ID_ADJUSTMENTPERIOD													129
#define NBAP_IE_ID_MAXADJUSTMENTSTEP												130
#define NBAP_IE_ID_MAXIMUMTRANSMISSIONPOWER											131
#define NBAP_IE_ID_MEASUREMENTFILTERCOEFFICIENT										132
#define NBAP_IE_ID_MEASUREMENTID													133
#define NBAP_IE_ID_MESSAGESTRUCTURE													115
#define NBAP_IE_ID_MIB_SB_SIB_INFORMATIONLIST_SYSTEMINFOUPDATERQST					134
#define NBAP_IE_ID_NODEB_COMMUNICATIONCONTEXTID										143
#define NBAP_IE_ID_NEIGHBOURINGCELLMEASUREMENTINFORMATION							455
#define NBAP_IE_ID_P_CCPCH_INFORMATION												144
#define NBAP_IE_ID_P_CCPCH_INFORMATIONITEM_RESOURCESTATUSIND						145
#define NBAP_IE_ID_P_CPICH_INFORMATION												146
#define NBAP_IE_ID_P_CPICH_INFORMATIONITEM_RESOURCESTATUSIND						147
#define NBAP_IE_ID_P_SCH_INFORMATION												148
#define NBAP_IE_ID_PCCPCH_INFORMATION_CELL_RECONFRQSTTDD							150
#define NBAP_IE_ID_PCCPCH_INFORMATION_CELL_SETUPRQSTTDD								151
#define NBAP_IE_ID_PCH_PARAMETERS_CTCH_RECONFRQSTTDD								155
#define NBAP_IE_ID_PCH_PARAMETERSITEM_CTCH_SETUPRQSTFDD								156
#define NBAP_IE_ID_PCH_PARAMETERSITEM_CTCH_SETUPRQSTTDD								157
#define NBAP_IE_ID_PCH_INFORMATION													158
#define NBAP_IE_ID_PDSCH_INFORMATION_ADDLISTIE_PSCH_RECONFRQST						161
#define NBAP_IE_ID_PDSCH_INFORMATION_MODIFYLISTIE_PSCH_RECONFRQST					162
#define NBAP_IE_ID_PDSCHSETS_ADDLIST_PSCH_RECONFRQST								163
#define NBAP_IE_ID_PDSCHSETS_DELETELIST_PSCH_RECONFRQST								164
#define NBAP_IE_ID_PDSCHSETS_MODIFYLIST_PSCH_RECONFRQST								165
#define NBAP_IE_ID_PICH_INFORMATION													166
#define NBAP_IE_ID_PICH_PARAMETERS_CTCH_RECONFRQSTTDD								168
#define NBAP_IE_ID_POWERADJUSTMENTTYPE												169
#define NBAP_IE_ID_PRACH_INFORMATION												170
#define NBAP_IE_ID_PRIMARYCCPCH_INFORMATION_CELL_RECONFRQSTFDD						175
#define NBAP_IE_ID_PRIMARYCCPCH_INFORMATION_CELL_SETUPRQSTFDD						176
#define NBAP_IE_ID_PRIMARYCPICH_INFORMATION_CELL_RECONFRQSTFDD						177
#define NBAP_IE_ID_PRIMARYCPICH_INFORMATION_CELL_SETUPRQSTFDD						178
#define NBAP_IE_ID_PRIMARYSCH_INFORMATION_CELL_RECONFRQSTFDD						179
#define NBAP_IE_ID_PRIMARYSCH_INFORMATION_CELL_SETUPRQSTFDD							180
#define NBAP_IE_ID_PRIMARYSCRAMBLINGCODE											181
#define NBAP_IE_ID_SCH_INFORMATION_CELL_RECONFRQSTTDD								183
#define NBAP_IE_ID_SCH_INFORMATION_CELL_SETUPRQSTTDD								184
#define NBAP_IE_ID_PUSCH_INFORMATION_ADDLISTIE_PSCH_RECONFRQST						185
#define NBAP_IE_ID_PUSCH_INFORMATION_MODIFYLISTIE_PSCH_RECONFRQST					186
#define NBAP_IE_ID_PUSCHSETS_ADDLIST_PSCH_RECONFRQST								187
#define NBAP_IE_ID_PUSCHSETS_DELETELIST_PSCH_RECONFRQST								188
#define NBAP_IE_ID_PUSCHSETS_MODIFYLIST_PSCH_RECONFRQST								189
#define NBAP_IE_ID_RACH_INFORMATION													190
#define NBAP_IE_ID_RACH_PARAMETERSITEM_CTCH_SETUPRQSTFDD							196
#define NBAP_IE_ID_RACH_PARAMETERITEM_CTCH_SETUPRQSTTDD								197
#define NBAP_IE_ID_REPORTCHARACTERISTICS											198
#define NBAP_IE_ID_REPORTING_OBJECT_RL_FAILUREIND									199
#define NBAP_IE_ID_REPORTING_OBJECT_RL_RESTOREIND									200
#define NBAP_IE_ID_RL_INFORMATIONITEM_DM_RPRT										202
#define NBAP_IE_ID_RL_INFORMATIONITEM_DM_RQST										203
#define NBAP_IE_ID_RL_INFORMATIONITEM_DM_RSP										204
#define NBAP_IE_ID_RL_INFORMATIONITEM_RL_ADDITIONRQSTFDD							205
#define NBAP_IE_ID_RL_INFORMATIONITEM_RL_DELETIONRQST								206
#define NBAP_IE_ID_RL_INFORMATIONITEM_RL_FAILUREIND									207
#define NBAP_IE_ID_RL_INFORMATIONITEM_RL_PREEMPTREQUIREDIND							286
#define NBAP_IE_ID_RL_INFORMATIONITEM_RL_RECONFPREPFDD								208
#define NBAP_IE_ID_RL_INFORMATIONITEM_RL_RECONFRQSTFDD								209
#define NBAP_IE_ID_RL_INFORMATIONITEM_RL_RESTOREIND									210
#define NBAP_IE_ID_RL_INFORMATIONITEM_RL_SETUPRQSTFDD								211
#define NBAP_IE_ID_RL_INFORMATIONLIST_RL_ADDITIONRQSTFDD							212
#define NBAP_IE_ID_RL_INFORMATIONLIST_RL_DELETIONRQST								213
#define NBAP_IE_ID_RL_INFORMATIONLIST_RL_PREEMPTREQUIREDIND							237
#define NBAP_IE_ID_RL_INFORMATIONLIST_RL_RECONFPREPFDD								214
#define NBAP_IE_ID_RL_INFORMATIONLIST_RL_RECONFRQSTFDD								215
#define NBAP_IE_ID_RL_INFORMATIONLIST_RL_SETUPRQSTFDD								216
#define NBAP_IE_ID_RL_INFORMATIONRESPONSEITEM_RL_ADDITIONRSPFDD						217
#define NBAP_IE_ID_RL_INFORMATIONRESPONSEITEM_RL_RECONFREADY						218
#define NBAP_IE_ID_RL_INFORMATIONRESPONSEITEM_RL_RECONFRSP							219
#define NBAP_IE_ID_RL_INFORMATIONRESPONSEITEM_RL_SETUPRSPFDD						220
#define NBAP_IE_ID_RL_INFORMATIONRESPONSELIST_RL_ADDITIONRSPFDD						221
#define NBAP_IE_ID_RL_INFORMATIONRESPONSELIST_RL_RECONFREADY						222
#define NBAP_IE_ID_RL_INFORMATIONRESPONSELIST_RL_RECONFRSP							223
#define NBAP_IE_ID_RL_INFORMATIONRESPONSELIST_RL_SETUPRSPFDD						224
#define NBAP_IE_ID_RL_INFORMATIONRESPONSE_RL_ADDITIONRSPTDD							225
#define NBAP_IE_ID_RL_INFORMATIONRESPONSE_RL_SETUPRSPTDD							226
#define NBAP_IE_ID_RL_INFORMATION_RL_ADDITIONRQSTTDD								227
#define NBAP_IE_ID_RL_INFORMATION_RL_RECONFRQSTTDD									228
#define NBAP_IE_ID_RL_INFORMATION_RL_RECONFPREPTDD									229
#define NBAP_IE_ID_RL_INFORMATION_RL_SETUPRQSTTDD									230
#define NBAP_IE_ID_RL_RECONFIGURATIONFAILUREITEM_RL_RECONFFAILURE					236
#define NBAP_IE_ID_RL_SET_INFORMATIONITEM_DM_RPRT									238
#define NBAP_IE_ID_RL_SET_INFORMATIONITEM_DM_RSP									240
#define NBAP_IE_ID_RL_SET_INFORMATIONITEM_RL_FAILUREIND								241
#define NBAP_IE_ID_RL_SET_INFORMATIONITEM_RL_RESTOREIND								242
#define NBAP_IE_ID_S_CCPCH_INFORMATION												247
#define NBAP_IE_ID_S_CPICH_INFORMATION												249
#define NBAP_IE_ID_SCH_INFORMATION													251
#define NBAP_IE_ID_S_SCH_INFORMATION												253
#define NBAP_IE_ID_SECONDARY_CCPCHLISTIE_CTCH_RECONFRQSTTDD							257
#define NBAP_IE_ID_SECONDARY_CCPCH_PARAMETERLISTIE_CTCH_SETUPRQSTTDD				258
#define NBAP_IE_ID_SECONDARY_CCPCH_PARAMETERS_CTCH_RECONFRQSTTDD					259
#define NBAP_IE_ID_SECONDARYCPICH_INFORMATIONITEM_CELL_RECONFRQSTFDD				260
#define NBAP_IE_ID_SECONDARYCPICH_INFORMATIONITEM_CELL_SETUPRQSTFDD					261
#define NBAP_IE_ID_SECONDARYCPICH_INFORMATIONLIST_CELL_RECONFRQSTFDD				262
#define NBAP_IE_ID_SECONDARYCPICH_INFORMATIONLIST_CELL_SETUPRQSTFDD					263
#define NBAP_IE_ID_SECONDARYSCH_INFORMATION_CELL_RECONFRQSTFDD						264
#define NBAP_IE_ID_SECONDARYSCH_INFORMATION_CELL_SETUPRQSTFDD						265
#define NBAP_IE_ID_SEGMENTINFORMATIONLISTIE_SYSTEMINFOUPDATE						266
#define NBAP_IE_ID_SFN																268
#define NBAP_IE_ID_SIGNALLINGBEARERREQUESTINDICATOR									138
#define NBAP_IE_ID_SHUTDOWNTIMER													269
#define NBAP_IE_ID_START_OF_AUDIT_SEQUENCE_INDICATOR								114
#define NBAP_IE_ID_SUCCESSFUL_RL_INFORMATIONRESPITEM_RL_ADDITIONFAILUREFDD			270
#define NBAP_IE_ID_SUCCESSFUL_RL_INFORMATIONRESPITEM_RL_SETUPFAILUREFDD				271
#define NBAP_IE_ID_SYNCCASE															274
#define NBAP_IE_ID_SYNCCASEINDICATORITEM_CELL_SETUPRQSTTDD_PSCH						275
#define NBAP_IE_ID_T_CELL															276
#define NBAP_IE_ID_TARGETCOMMUNICATIONCONTROLPORTID									139
#define NBAP_IE_ID_TIMESLOTCONFIGURATIONLIST_CELL_RECONFRQSTTDD						277
#define NBAP_IE_ID_TIMESLOTCONFIGURATIONLIST_CELL_SETUPRQSTTDD						278
#define NBAP_IE_ID_TRANSMISSIONDIVERSITYAPPLIED										279
#define NBAP_IE_ID_TYPEOFERROR														508
#define NBAP_IE_ID_UARFCNFORNT														280
#define NBAP_IE_ID_UARFCNFORND														281
#define NBAP_IE_ID_UARFCNFORNU														282
#define NBAP_IE_ID_UL_CCTRCH_INFORMATIONITEM_RL_SETUPRQSTTDD						284
#define NBAP_IE_ID_UL_CCTRCH_INFORMATIONLIST_RL_ADDITIONRQSTTDD						285
#define NBAP_IE_ID_UL_CCTRCH_INFORMATIONLIST_RL_SETUPRQSTTDD						288
#define NBAP_IE_ID_UL_DPCH_INFORMATIONITEM_RL_ADDITIONRQSTTDD						289
#define NBAP_IE_ID_UL_DPCH_INFORMATIONLIST_RL_SETUPRQSTTDD							291
#define NBAP_IE_ID_UL_DPCH_INFORMATION_RL_RECONFPREPFDD								293
#define NBAP_IE_ID_UL_DPCH_INFORMATION_RL_RECONFRQSTFDD								294
#define NBAP_IE_ID_UL_DPCH_INFORMATION_RL_SETUPRQSTFDD								295
#define NBAP_IE_ID_UNSUCCESSFUL_RL_INFORMATIONRESPITEM_RL_ADDITIONFAILUREFDD		296
#define NBAP_IE_ID_UNSUCCESSFUL_RL_INFORMATIONRESPITEM_RL_SETUPFAILUREFDD			297
#define NBAP_IE_ID_UNSUCCESSFUL_RL_INFORMATIONRESP_RL_ADDITIONFAILURETDD			300
#define NBAP_IE_ID_UNSUCCESSFUL_RL_INFORMATIONRESP_RL_SETUPFAILURETDD				301
#define NBAP_IE_ID_USCH_INFORMATION_ADD												302
#define NBAP_IE_ID_USCH_INFORMATION_DELETELIST_RL_RECONFPREPTDD						304
#define NBAP_IE_ID_USCH_INFORMATION_MODIFYLIST_RL_RECONFPREPTDD						306
#define NBAP_IE_ID_USCH_INFORMATIONRESPONSE											309
#define NBAP_IE_ID_USCH_INFORMATION													310
#define NBAP_IE_ID_USCH_REARRANGELIST_BEARER_REARRANGEIND							141
#define NBAP_IE_ID_ACTIVE_PATTERN_SEQUENCE_INFORMATION 								315
#define NBAP_IE_ID_AICH_PARAMETERSLISTIE_CTCH_RECONFRQSTFDD							316
#define NBAP_IE_ID_ADJUSTMENTRATIO													317
#define NBAP_IE_ID_NOT_USED_320														320
#define NBAP_IE_ID_NOT_USED_322														322
#define NBAP_IE_ID_FACH_PARAMETERSLISTIE_CTCH_RECONFRQSTFDD							323
#define NBAP_IE_ID_CAUSELEVEL_PSCH_RECONFFAILURE									324
#define NBAP_IE_ID_CAUSELEVEL_RL_ADDITIONFAILUREFDD									325
#define NBAP_IE_ID_CAUSELEVEL_RL_ADDITIONFAILURETDD									326
#define NBAP_IE_ID_CAUSELEVEL_RL_RECONFFAILURE										327
#define NBAP_IE_ID_CAUSELEVEL_RL_SETUPFAILUREFDD									328
#define NBAP_IE_ID_CAUSELEVEL_RL_SETUPFAILURETDD									329
#define NBAP_IE_ID_NOT_USED_330														330
#define NBAP_IE_ID_NOT_USED_332														332
#define NBAP_IE_ID_CLOSED_LOOP_TIMING_ADJUSTMENT_MODE								333
#define NBAP_IE_ID_COMMONPHYSICALCHANNELTYPE_CTCH_RECONFRQSTFDD						334
#define NBAP_IE_ID_COMPRESSED_MODE_DEACTIVATION_FLAG								335
#define NBAP_IE_ID_NOT_USED_336														336
#define NBAP_IE_ID_NOT_USED_342														342
#define NBAP_IE_ID_NOT_USED_343														343
#define NBAP_IE_ID_DL_CCTRCH_INFORMATIONADDLIST_RL_RECONFPREPTDD					346
#define NBAP_IE_ID_DL_CCTRCH_INFORMATIONDELETEITEM_RL_RECONFRQSTTDD					347
#define NBAP_IE_ID_DL_CCTRCH_INFORMATIONDELETELIST_RL_RECONFPREPTDD					348
#define NBAP_IE_ID_DL_CCTRCH_INFORMATIONDELETELIST_RL_RECONFRQSTTDD					349
#define NBAP_IE_ID_DL_CCTRCH_INFORMATIONMODIFYITEM_RL_RECONFRQSTTDD					350
#define NBAP_IE_ID_DL_CCTRCH_INFORMATIONMODIFYLIST_RL_RECONFPREPTDD					351
#define NBAP_IE_ID_DL_CCTRCH_INFORMATIONMODIFYLIST_RL_RECONFRQSTTDD					352
#define NBAP_IE_ID_DL_DPCH_INFORMATIONADDLISTIE_RL_RECONFPREPTDD					353
#define NBAP_IE_ID_DL_DPCH_INFORMATIONMODIFY_ADDLISTIE_RL_RECONFPREPTDD				355
#define NBAP_IE_ID_DL_DPCH_INFORMATIONMODIFY_DELETELISTIE_RL_RECONFPREPTDD			356
#define NBAP_IE_ID_DL_DPCH_INFORMATIONMODIFY_MODIFYLISTIE_RL_RECONFPREPTDD			357
#define NBAP_IE_ID_DL_TPC_PATTERN01COUNT 											358
#define NBAP_IE_ID_DPC_MODE															450
#define NBAP_IE_ID_DPCHCONSTANT														359
#define NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_94											94
#define NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_110											110
#define NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_111											111
#define NBAP_IE_ID_FACH_PARAMETERSLIST_CTCH_SETUPRSP								362
#define NBAP_IE_ID_LIMITED_POWER_INCREASE_INFORMATION_CELL_SETUPRQSTFDD				369
#define NBAP_IE_ID_PCH_PARAMETERS_CTCH_SETUPRSP										374
#define NBAP_IE_ID_PCH_PARAMETERSITEM_CTCH_RECONFRQSTFDD							375
#define NBAP_IE_ID_NOT_USED_376														376
#define NBAP_IE_ID_PICH_PARAMETERSITEM_CTCH_RECONFRQSTFDD							380
#define NBAP_IE_ID_PRACHCONSTANT													381
#define NBAP_IE_ID_PRACH_PARAMETERSLISTIE_CTCH_RECONFRQSTFDD						383
#define NBAP_IE_ID_PUSCHCONSTANT													384
#define NBAP_IE_ID_RACH_PARAMETERS_CTCH_SETUPRSP									385
#define NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_443											443
#define NBAP_IE_ID_SYNCHRONISATION_CONFIGURATION_CELL_RECONFRQST					393
#define NBAP_IE_ID_SYNCHRONISATION_CONFIGURATION_CELL_SETUPRQST						394
#define NBAP_IE_ID_TRANSMISSION_GAP_PATTERN_SEQUENCE_INFORMATION					395
#define NBAP_IE_ID_UL_CCTRCH_INFORMATIONADDLIST_RL_RECONFPREPTDD					396
#define NBAP_IE_ID_UL_CCTRCH_INFORMATIONDELETEITEM_RL_RECONFRQSTTDD					397
#define NBAP_IE_ID_UL_CCTRCH_INFORMATIONDELETELIST_RL_RECONFPREPTDD					398
#define NBAP_IE_ID_UL_CCTRCH_INFORMATIONDELETELIST_RL_RECONFRQSTTDD					399
#define NBAP_IE_ID_UL_CCTRCH_INFORMATIONMODIFYITEM_RL_RECONFRQSTTDD					400
#define NBAP_IE_ID_UL_CCTRCH_INFORMATIONMODIFYLIST_RL_RECONFPREPTDD					401
#define NBAP_IE_ID_UL_CCTRCH_INFORMATIONMODIFYLIST_RL_RECONFRQSTTDD					402
#define NBAP_IE_ID_UL_DPCH_INFORMATIONADDLISTIE_RL_RECONFPREPTDD					403
#define NBAP_IE_ID_UL_DPCH_INFORMATIONMODIFY_ADDLISTIE_RL_RECONFPREPTDD				405
#define NBAP_IE_ID_UL_DPCH_INFORMATIONMODIFY_DELETELISTIE_RL_RECONFPREPTDD			406
#define NBAP_IE_ID_UL_DPCH_INFORMATIONMODIFY_MODIFYLISTIE_RL_RECONFPREPTDD			407
#define NBAP_IE_ID_UNSUCCESSFUL_PDSCHSETITEM_PSCH_RECONFFAILURETDD					408
#define NBAP_IE_ID_UNSUCCESSFUL_PUSCHSETITEM_PSCH_RECONFFAILURETDD					409
#define NBAP_IE_ID_COMMUNICATIONCONTEXTINFOITEM_RESET								412
#define NBAP_IE_ID_COMMUNICATIONCONTROLPORTINFOITEM_RESET							414
#define NBAP_IE_ID_RESETINDICATOR													416
#define NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_417											417
#define NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_418											418
#define NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_419											419
#define NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_142											142
#define NBAP_IE_ID_TIMINGADVANCEAPPLIED												287
#define NBAP_IE_ID_CFNREPORTINGINDICATOR											6
#define NBAP_IE_ID_SFNREPORTINGINDICATOR											11
#define NBAP_IE_ID_INNERLOOPDLPCSTATUS												12
#define NBAP_IE_ID_TIMESLOTISCPINFO													283
#define NBAP_IE_ID_PICH_PARAMETERSITEM_CTCH_SETUPRQSTTDD							167
#define NBAP_IE_ID_PRACH_PARAMETERSITEM_CTCH_SETUPRQSTTDD							20
#define NBAP_IE_ID_CCTRCH_INFORMATIONITEM_RL_FAILUREIND								46
#define NBAP_IE_ID_CCTRCH_INFORMATIONITEM_RL_RESTOREIND								47
#define NBAP_IE_ID_CAUSELEVEL_SYNCADJUSTMNTFAILURETDD								420
#define NBAP_IE_ID_CELLADJUSTMENTINFO_SYNCADJUSTMNTRQSTTDD							421
#define NBAP_IE_ID_CELLADJUSTMENTINFOITEM_SYNCADJUSTMENTRQSTTDD						494
#define NBAP_IE_ID_CELLSYNCBURSTINFOLIST_CELLSYNCRECONFRQSTTDD						482
#define NBAP_IE_ID_CELLSYNCBURSTTRANSINIT_CELLSYNCINITIATIONRQSTTDD					422
#define NBAP_IE_ID_CELLSYNCBURSTMEASUREINIT_CELLSYNCINITIATIONRQSTTDD				423
#define NBAP_IE_ID_CELLSYNCBURSTTRANSRECONFIGURATION_CELLSYNCRECONFRQSTTDD			424
#define NBAP_IE_ID_CELLSYNCBURSTMEASRECONFIGURATION_CELLSYNCRECONFRQSTTDD			425
#define NBAP_IE_ID_CELLSYNCBURSTTRANSINFOLIST_CELLSYNCRECONFRQSTTDD					426
#define NBAP_IE_ID_CELLSYNCBURSTMEASINFOLIST_CELLSYNCRECONFRQSTTDD					427
#define NBAP_IE_ID_CELLSYNCBURSTTRANSRECONFINFO_CELLSYNCRECONFRQSTTDD				428
#define NBAP_IE_ID_CELLSYNCINFO_CELLSYNCREPRTTDD									429
#define NBAP_IE_ID_CSBTRANSMISSIONID												430
#define NBAP_IE_ID_CSBMEASUREMENTID													431
#define NBAP_IE_ID_INTSTDPHCELLSYNCINFOITEM_CELLSYNCREPRTTDD						432
#define NBAP_IE_ID_NCYCLESPERSFNPERIOD 												433
#define NBAP_IE_ID_NREPETITIONSPERCYCLEPERIOD										434
#define NBAP_IE_ID_SYNCFRAMENUMBER													437
#define NBAP_IE_ID_SYNCHRONISATIONREPORTTYPE										438
#define NBAP_IE_ID_SYNCHRONISATIONREPORTCHARACTERISTICS								439
#define NBAP_IE_ID_UNSUCCESSFUL_CELL_INFORMATIONRESPITEM_SYNCADJUSTMNTFAILURETDD	440
#define NBAP_IE_ID_LATEENTRANCECELLSYNCINFOITEM_CELLSYNCREPRTTDD					119
#define NBAP_IE_ID_REFERENCECLOCKAVAILABILITY										435
#define NBAP_IE_ID_REFERENCESFNOFFSET												436
#define NBAP_IE_ID_INFORMATIONEXCHANGEID											444
#define NBAP_IE_ID_INFORMATIONEXCHANGEOBJECTTYPE_INFEX_RQST							445
#define NBAP_IE_ID_INFORMATIONTYPE													446
#define NBAP_IE_ID_INFORMATIONREPORTCHARACTERISTICS									447
#define NBAP_IE_ID_INFORMATIONEXCHANGEOBJECTTYPE_INFEX_RSP							448
#define NBAP_IE_ID_INFORMATIONEXCHANGEOBJECTTYPE_INFEX_RPRT							449
#define NBAP_IE_ID_IPDLPARAMETER_INFORMATION_CELL_RECONFRQSTFDD						451
#define NBAP_IE_ID_IPDLPARAMETER_INFORMATION_CELL_SETUPRQSTFDD						452
#define NBAP_IE_ID_IPDLPARAMETER_INFORMATION_CELL_RECONFRQSTTDD						453
#define NBAP_IE_ID_IPDLPARAMETER_INFORMATION_CELL_SETUPRQSTTDD						454
#define NBAP_IE_ID_DL_DPCH_LCR_INFORMATION_RL_SETUPRQSTTDD							74
#define NBAP_IE_ID_DWPCH_LCR_INFORMATION											78
#define NBAP_IE_ID_DWPCH_LCR_INFORMATIONLIST_AUDITRSP                   			90
#define NBAP_IE_ID_DWPCH_LCR_INFORMATION_CELL_SETUPRQSTTDD                   		97
#define NBAP_IE_ID_DWPCH_LCR_INFORMATION_CELL_RECONFRQSTTDD							99
#define NBAP_IE_ID_DWPCH_LCR_INFORMATION_RESOURCESTATUSIND							101
#define NBAP_IE_ID_MAXFACH_POWER_LCR_CTCH_SETUPRQSTTDD                   			154
#define NBAP_IE_ID_MAXFACH_POWER_LCR_CTCH_RECONFRQSTTDD                   			174
#define NBAP_IE_ID_FPACH_LCR_INFORMATION											290
#define NBAP_IE_ID_FPACH_LCR_INFORMATION_AUDITRSP                   				292
#define NBAP_IE_ID_FPACH_LCR_INFORMATIONLIST_AUDITRSP                   			22
#define NBAP_IE_ID_FPACH_LCR_INFORMATIONLIST_RESOURCESTATUSIND                   	311
#define NBAP_IE_ID_FPACH_LCR_PARAMETERS_CTCH_SETUPRQSTTDD                   		312
#define NBAP_IE_ID_FPACH_LCR_PARAMETERS_CTCH_RECONFRQSTTDD                   		314
#define NBAP_IE_ID_PCCPCH_LCR_INFORMATION_CELL_SETUPRQSTTDD                   		456
#define NBAP_IE_ID_PCH_POWER_LCR_CTCH_SETUPRQSTTDD									457
#define NBAP_IE_ID_PCH_POWER_LCR_CTCH_RECONFRQSTTDD									458
#define NBAP_IE_ID_PICH_LCR_PARAMETERS_CTCH_SETUPRQSTTDD                   			459
#define NBAP_IE_ID_PRACH_LCR_PARAMETERSLIST_CTCH_SETUPRQSTTDD                  		461
#define NBAP_IE_ID_RL_INFORMATIONRESPONSE_LCR_RL_SETUPRSPTDD	                   	463
#define NBAP_IE_ID_SECONDARY_CCPCH_LCR_PARAMETERLIST_CTCH_SETUPRQSTTDD              465
#define NBAP_IE_ID_TIMESLOT															495
#define NBAP_IE_ID_TIMESLOTCONFIGURATIONLIST_LCR_CELL_RECONFRQSTTDD                 466
#define NBAP_IE_ID_TIMESLOTCONFIGURATIONLIST_LCR_CELL_SETUPRQSTTDD                  467
#define NBAP_IE_ID_TIMESLOTISCP_LCR_INFOLIST_RL_SETUPRQSTTDD                   		468
#define NBAP_IE_ID_TIMESLOTLCR_CM_RQST                   							469
#define NBAP_IE_ID_UL_DPCH_LCR_INFORMATION_RL_SETUPRQSTTDD                   		470
#define NBAP_IE_ID_DL_DPCH_INFORMATIONITEM_LCR_RL_ADDITIONRQSTTDD					472
#define NBAP_IE_ID_UL_DPCH_INFORMATIONITEM_LCR_RL_ADDITIONRQSTTDD					473
#define NBAP_IE_ID_TIMESLOTISCP_INFORMATIONLIST_LCR_RL_ADDITIONRQSTTDD				474
#define NBAP_IE_ID_DL_DPCH_LCR_INFORMATIONADDLIST_RL_RECONFPREPTDD					475
#define NBAP_IE_ID_DL_DPCH_LCR_INFORMATIONMODIFY_ADDLIST_RL_RECONFPREPTDD			477
#define NBAP_IE_ID_DL_TIMESLOT_LCR_INFORMATIONMODIFY_MODIFYLIST_RL_RECONFPREPTDD	479
#define NBAP_IE_ID_TIMESLOTISCPINFOLIST_LCR_DL_PC_RQSTTDD							480
#define NBAP_IE_ID_UL_DPCH_LCR_INFORMATIONADDLISTIE_RL_RECONFPREPTDD				481
#define NBAP_IE_ID_UL_DPCH_LCR_INFORMATIONMODIFY_ADDLIST							483
#define NBAP_IE_ID_UL_TIMESLOTLCR_INFORMATION_RL_RECONFPREPTDD						485
#define NBAP_IE_ID_UL_SIRTARGET														510
#define NBAP_IE_ID_PDSCH_ADDINFORMATION_LCR_PSCH_RECONFRQST							486
#define NBAP_IE_ID_PDSCH_ADDINFORMATION_LCR_ADDLISTIE_PSCH_RECONFRQST				487
#define NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_26											 26
#define NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_27											 27
#define NBAP_IE_ID_PDSCH_MODIFYINFORMATION_LCR_PSCH_RECONFRQST						488
#define NBAP_IE_ID_PDSCH_MODIFYINFORMATION_LCR_MODIFYLISTIE_PSCH_RECONFRQST			489
#define NBAP_IE_ID_PUSCH_ADDINFORMATION_LCR_PSCH_RECONFRQST							490
#define NBAP_IE_ID_PUSCH_ADDINFORMATION_LCR_ADDLISTIE_PSCH_RECONFRQST				491
#define NBAP_IE_ID_PUSCH_MODIFYINFORMATION_LCR_PSCH_RECONFRQST						492
#define NBAP_IE_ID_PUSCH_MODIFYINFORMATION_LCR_MODIFYLISTIE_PSCH_RECONFRQST			493
#define NBAP_IE_ID_TIMESLOTINFO_CELLSYNCINITIATIONRQSTTDD							496
#define NBAP_IE_ID_SYNCREPORTTYPE_CELLSYNCREPRTTDD									497
#define NBAP_IE_ID_POWER_LOCAL_CELL_GROUP_INFORMATIONITEM_AUDITRSP					498
#define NBAP_IE_ID_POWER_LOCAL_CELL_GROUP_INFORMATIONITEM_RESOURCESTATUSIND			499
#define NBAP_IE_ID_POWER_LOCAL_CELL_GROUP_INFORMATIONITEM2_RESOURCESTATUSIND		500
#define NBAP_IE_ID_POWER_LOCAL_CELL_GROUP_INFORMATIONLIST_AUDITRSP					501
#define NBAP_IE_ID_POWER_LOCAL_CELL_GROUP_INFORMATIONLIST_RESOURCESTATUSIND			502
#define NBAP_IE_ID_POWER_LOCAL_CELL_GROUP_INFORMATIONLIST2_RESOURCESTATUSIND		503
#define NBAP_IE_ID_POWER_LOCAL_CELL_GROUP_ID										504
#define NBAP_IE_ID_PUSCH_INFO_DM_RQST												505
#define NBAP_IE_ID_PUSCH_INFO_DM_RSP												506
#define NBAP_IE_ID_PUSCH_INFO_DM_RPRT												507
#define NBAP_IE_ID_INITDL_POWER														509
#define NBAP_IE_ID_CELLSYNCBURSTREPETITIONPERIOD									511
#define NBAP_IE_ID_REPORTCHARACTERISTICSTYPE_ONMODIFICATION							512
#define NBAP_IE_ID_SFNSFNMEASUREMENTVALUEINFORMATION								513
#define NBAP_IE_ID_SFNSFNMEASUREMENTTHRESHOLDINFORMATION							514
#define NBAP_IE_ID_TUTRANGPSMEASUREMENTVALUEINFORMATION								515
#define NBAP_IE_ID_TUTRANGPSMEASUREMENTTHRESHOLDINFORMATION							516
#define NBAP_IE_ID_RX_TIMING_DEVIATION_VALUE_LCR									520
#define NBAP_IE_ID_RL_INFORMATIONRESPONSE_LCR_RL_ADDITIONRSPTDD						51
#define NBAP_IE_ID_DL_POWERBALANCING_INFORMATION									28
#define NBAP_IE_ID_DL_POWERBALANCING_ACTIVATIONINDICATOR							29
#define NBAP_IE_ID_DL_POWERBALANCING_UPDATEDINDICATOR								30
#define NBAP_IE_ID_CCTRCH_INITIAL_DL_POWER_RL_SETUPRQSTTDD							517
#define NBAP_IE_ID_CCTRCH_INITIAL_DL_POWER_RL_ADDITIONRQSTTDD						518
#define NBAP_IE_ID_CCTRCH_INITIAL_DL_POWER_RL_RECONFPREPTDD							519
#define NBAP_IE_ID_IPDLPARAMETER_INFORMATION_LCR_CELL_SETUPRQSTTDD					41
#define NBAP_IE_ID_IPDLPARAMETER_INFORMATION_LCR_CELL_RECONFRQSTTDD 				42
#define NBAP_IE_ID_HS_PDSCH_HS_SCCH_E_AGCH_E_RGCH_E_HICH_MAXPOWER_PSCH_RECONFRQST	522
#define NBAP_IE_ID_HS_PDSCH_HS_SCCH_SCRAMBLINGCODE_PSCH_RECONFRQST					523
#define NBAP_IE_ID_HS_PDSCH_FDD_CODE_INFORMATION_PSCH_RECONFRQST					524
#define NBAP_IE_ID_HS_SCCH_FDD_CODE_INFORMATION_PSCH_RECONFRQST						525
#define NBAP_IE_ID_HS_PDSCH_TDD_INFORMATION_PSCH_RECONFRQST							526
#define NBAP_IE_ID_ADD_TO_HS_SCCH_RESOURCE_POOL_PSCH_RECONFRQST						527
#define NBAP_IE_ID_MODIFY_HS_SCCH_RESOURCE_POOL_PSCH_RECONFRQST						528
#define NBAP_IE_ID_DELETE_FROM_HS_SCCH_RESOURCE_POOL_PSCH_RECONFRQST				529
#define NBAP_IE_ID_BINDINGID														102
#define NBAP_IE_ID_RL_SPECIFIC_DCH_INFO												103
#define NBAP_IE_ID_TRANSPORTLAYERADDRESS 											104
#define NBAP_IE_ID_DELAYEDACTIVATION 												231
#define NBAP_IE_ID_DELAYEDACTIVATIONLIST_RL_ACTIVATIONCMDFDD						232
#define NBAP_IE_ID_DELAYEDACTIVATIONINFORMATION_RL_ACTIVATIONCMDFDD					233
#define NBAP_IE_ID_DELAYEDACTIVATIONLIST_RL_ACTIVATIONCMDTDD						234
#define NBAP_IE_ID_DELAYEDACTIVATIONINFORMATION_RL_ACTIVATIONCMDTDD					235
#define NBAP_IE_ID_NEIGHBOURINGTDDCELLMEASUREMENTINFORMATIONLCR						58
#define NBAP_IE_ID_SYNCDLCODEID_TRANSINITLCR_CELLSYNCINITIATIONRQSTTDD				543
#define NBAP_IE_ID_SYNCDLCODEID_MEASUREINITLCR_CELLSYNCINITIATIONRQSTTDD			544
#define NBAP_IE_ID_SYNCDLCODEIDTRANSRECONFINFOLCR_CELLSYNCRECONFRQSTTDD				545
#define NBAP_IE_ID_SYNCDLCODEIDMEASRECONFIGURATIONLCR_CELLSYNCRECONFRQSTTDD			546
#define NBAP_IE_ID_SYNCDLCODEIDMEASINFOLIST_CELLSYNCRECONFRQSTTDD					547
#define NBAP_IE_ID_SYNCDLCODEIDSMEASINFOLIST_CELLSYNCREPRTTDD						548
#define NBAP_IE_ID_SYNCDLCODEIDTHREINFOLCR											549
#define NBAP_IE_ID_NSUBCYCLESPERCYCLEPERIOD_CELLSYNCRECONFRQSTTDD					550
#define NBAP_IE_ID_DWPCH_POWER														551
#define NBAP_IE_ID_ACCUMULATEDCLOCKUPDATE_CELLSYNCREPRTTDD							552
#define NBAP_IE_ID_ANGLE_OF_ARRIVAL_VALUE_LCR										521
#define NBAP_IE_ID_HSDSCH_FDD_INFORMATION											530
#define NBAP_IE_ID_HSDSCH_FDD_INFORMATION_RESPONSE									531
#define NBAP_IE_ID_HSDSCH_INFORMATION_TO_MODIFY										534
#define NBAP_IE_ID_HSDSCH_RNTI														535
#define NBAP_IE_ID_HSDSCH_TDD_INFORMATION											536
#define NBAP_IE_ID_HSDSCH_TDD_INFORMATION_RESPONSE									537
#define NBAP_IE_ID_HSPDSCH_RL_ID													541
#define NBAP_IE_ID_PRIMCCPCH_RSCP_DL_PC_RQSTTDD										542
#define NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_64											64
#define NBAP_IE_ID_PDSCH_RL_ID														66
#define NBAP_IE_ID_HSDSCH_REARRANGELIST_BEARER_REARRANGEIND							553
#define NBAP_IE_ID_UL_SYNCHRONISATION_PARAMETERS_LCR								554
#define NBAP_IE_ID_HSDSCH_FDD_UPDATE_INFORMATION									555
#define NBAP_IE_ID_HSDSCH_TDD_UPDATE_INFORMATION									556
#define NBAP_IE_ID_DL_DPCH_TIMESLOTFORMAT_LCR_MODIFYITEM_RL_RECONFPREPTDD			558
#define NBAP_IE_ID_UL_DPCH_TIMESLOTFORMAT_LCR_MODIFYITEM_RL_RECONFPREPTDD			559
#define NBAP_IE_ID_TDD_TPC_UPLINKSTEPSIZE_LCR_RL_SETUPRQSTTDD						560
#define NBAP_IE_ID_TDD_TPC_UPLINKSTEPSIZE_LCR_RL_ADDITIONRQSTTDD					561
#define NBAP_IE_ID_TDD_TPC_DOWNLINKSTEPSIZE_RL_ADDITIONRQSTTDD						562
#define NBAP_IE_ID_TDD_TPC_UPLINKSTEPSIZE_INFORMATIONADD_LCR_RL_RECONFPREPTDD		563
#define NBAP_IE_ID_TDD_TPC_UPLINKSTEPSIZE_INFORMATIONMODIFY_LCR_RL_RECONFPREPTDD	564
#define NBAP_IE_ID_TDD_TPC_DOWNLINKSTEPSIZE_INFORMATIONMODIFY_RL_RECONFPREPTDD		565
#define NBAP_IE_ID_TDD_TPC_DOWNLINKSTEPSIZE_INFORMATIONADD_RL_RECONFPREPTDD			566
#define NBAP_IE_ID_CCTRCH_MAXIMUM_DL_POWER_RL_SETUPRQSTTDD							567
#define NBAP_IE_ID_CCTRCH_MINIMUM_DL_POWER_RL_SETUPRQSTTDD							568
#define NBAP_IE_ID_CCTRCH_MAXIMUM_DL_POWER_RL_ADDITIONRQSTTDD						569
#define NBAP_IE_ID_CCTRCH_MINIMUM_DL_POWER_RL_ADDITIONRQSTTDD						570
#define NBAP_IE_ID_CCTRCH_MAXIMUM_DL_POWER_INFORMATIONADD_RL_RECONFPREPTDD			571
#define NBAP_IE_ID_CCTRCH_MINIMUM_DL_POWER_INFORMATIONADD_RL_RECONFPREPTDD			572
#define NBAP_IE_ID_CCTRCH_MAXIMUM_DL_POWER_INFORMATIONMODIFY_RL_RECONFPREPTDD		573
#define NBAP_IE_ID_CCTRCH_MINIMUM_DL_POWER_INFORMATIONMODIFY_RL_RECONFPREPTDD		574
#define NBAP_IE_ID_MAXIMUM_DL_POWER_MODIFY_LCR_INFORMATIONMODIFY_RL_RECONFPREPTDD	575
#define NBAP_IE_ID_MINIMUM_DL_POWER_MODIFY_LCR_INFORMATIONMODIFY_RL_RECONFPREPTDD	576
#define NBAP_IE_ID_DL_DPCH_LCR_INFORMATIONMODIFY_MODIFYLIST_RL_RECONFRQSTTDD		577
#define NBAP_IE_ID_CCTRCH_MAXIMUM_DL_POWER_INFORMATIONMODIFY_RL_RECONFRQSTTDD		578
#define NBAP_IE_ID_CCTRCH_MINIMUM_DL_POWER_INFORMATIONMODIFY_RL_RECONFRQSTTDD		579
#define NBAP_IE_ID_INITIAL_DL_POWER_TIMESLOTLCR_INFORMATIONITEM						580
#define NBAP_IE_ID_MAXIMUM_DL_POWER_TIMESLOTLCR_INFORMATIONITEM						581
#define NBAP_IE_ID_MINIMUM_DL_POWER_TIMESLOTLCR_INFORMATIONITEM						582
#define NBAP_IE_ID_HS_DSCHPROVIDEDBITRATEVALUEINFORMATION							583
#define NBAP_IE_ID_HS_DSCHREQUIREDPOWERVALUEINFORMATION								585
#define NBAP_IE_ID_HS_DSCHREQUIREDPOWERVALUE										586
#define NBAP_IE_ID_TRANSMITTEDCARRIERPOWEROFALLCODESNOTUSEDFORHSTRANSMISSION		587
#define NBAP_IE_ID_HS_SICH_RECEPTION_QUALITY 										588
#define NBAP_IE_ID_HS_SICH_RECEPTION_QUALITY_MEASUREMENT_VALUE 						589
#define NBAP_IE_ID_HSSICH_INFO_DM_RPRT 												590
#define NBAP_IE_ID_HSSICH_INFO_DM_RQST												591
#define NBAP_IE_ID_HSSICH_INFO_DM_RSP												592
#define NBAP_IE_ID_BEST_CELL_PORTIONS_VALUE											593
#define NBAP_IE_ID_PRIMARY_CPICH_USAGE_FOR_CHANNEL_ESTIMATION						594
#define NBAP_IE_ID_SECONDARY_CPICH_INFORMATION_CHANGE								595
#define NBAP_IE_ID_NUMBEROFREPORTEDCELLPORTIONS										596
#define NBAP_IE_ID_CELLPORTION_INFORMATIONITEM_CELL_SETUPRQSTFDD					597
#define NBAP_IE_ID_CELLPORTION_INFORMATIONLIST_CELL_SETUPRQSTFDD					598
#define NBAP_IE_ID_TIMESLOTISCP_LCR_INFOLIST_RL_RECONFPREPTDD						599
#define NBAP_IE_ID_SECONDARY_CPICH_INFORMATION										600
#define NBAP_IE_ID_RECEIVED_TOTAL_WIDE_BAND_POWER_FOR_CELLPORTION					601
#define NBAP_IE_ID_UNIDIRECTIONAL_DCH_INDICATOR										602
#define NBAP_IE_ID_TIMINGADJUSTMENTVALUELCR											603
#define NBAP_IE_ID_MULTIPLERL_DL_DPCH_INFORMATIONLIST								604
#define NBAP_IE_ID_MULTIPLERL_DL_DPCH_INFORMATIONMODIFYLIST							605
#define NBAP_IE_ID_MULTIPLERL_UL_DPCH_INFORMATIONLIST								606
#define NBAP_IE_ID_MULTIPLERL_UL_DPCH_INFORMATIONMODIFYLIST							607
#define NBAP_IE_ID_RL_ID															608
#define NBAP_IE_ID_SAT_INFO_ALMANAC_EXTITEM											609
#define NBAP_IE_ID_HSDPA_CAPABILITY													610
#define NBAP_IE_ID_HSDSCH_RESOURCES_INFORMATION_AUDITRSP							611
#define NBAP_IE_ID_HSDSCH_RESOURCES_INFORMATION_RESOURCESTATUSIND					612
#define NBAP_IE_ID_HSDSCH_MACDFLOWS_TO_ADD											613
#define NBAP_IE_ID_HSDSCH_MACDFLOWS_TO_DELETE										614
#define NBAP_IE_ID_HSDSCH_INFORMATION_TO_MODIFY_UNSYNCHRONISED						615
#define NBAP_IE_ID_TNLQOS															616
#define NBAP_IE_ID_RECEIVED_TOTAL_WIDE_BAND_POWER_FOR_CELLPORTION_VALUE				617
#define NBAP_IE_ID_TRANSMITTED_CARRIER_POWER_FOR_CELLPORTION						618
#define NBAP_IE_ID_TRANSMITTED_CARRIER_POWER_FOR_CELLPORTION_VALUE 					619
#define NBAP_IE_ID_TRANSMITTEDCARRIERPOWEROFALLCODESNOTUSEDFORHS_PDSCH_HS_SCCH_E_AGCH_E_RGCHORE_HICHTRANSMISSIONCELLPORTION		620
#define NBAP_IE_ID_TRANSMITTEDCARRIERPOWEROFALLCODESNOTUSEDFORHS_PDSCH_HS_SCCH_E_AGCH_E_RGCHORE_HICHTRANSMISSIONCELLPORTIONVALUE	621
#define NBAP_IE_ID_UPPTSINTERFERENCEVALUE											622
#define NBAP_IE_ID_PRIMARYCCPCH_RSCP_DELTA											623
#define NBAP_IE_ID_MEASUREMENTRECOVERYBEHAVIOR										624
#define NBAP_IE_ID_MEASUREMENTRECOVERYREPORTINGINDICATOR							625
#define NBAP_IE_ID_MEASUREMENTRECOVERYSUPPORTINDICATOR								626
#define NBAP_IE_ID_TSTD_INDICATOR													627
#define NBAP_IE_ID_MULTIPLE_RL_INFORMATION_RL_RECONFPREPTDD							628
#define NBAP_IE_ID_MULTIPLE_RL_INFORMATION_RL_RECONFRQSTTDD							629
#define NBAP_IE_ID_DL_DPCH_POWER_INFORMATION_RL_RECONFPREPFDD						630
#define NBAP_IE_ID_F_DPCH_INFORMATION_RL_RECONFPREPFDD								631
#define NBAP_IE_ID_F_DPCH_INFORMATION_RL_SETUPRQSTFDD								632
#define NBAP_IE_ID_ADDITIONAL_S_CCPCH_PARAMETERS_CTCH_RECONFRQSTTDD					633
#define NBAP_IE_ID_ADDITIONAL_S_CCPCH_PARAMETERS_CTCH_SETUPRQSTTDD					634
#define NBAP_IE_ID_ADDITIONAL_S_CCPCH_LCR_PARAMETERS_CTCH_RECONFRQSTTDD				635
#define NBAP_IE_ID_ADDITIONAL_S_CCPCH_LCR_PARAMETERS_CTCH_SETUPRQSTTDD				636
#define NBAP_IE_ID_MICH_CFN															637
#define NBAP_IE_ID_MICH_INFORMATION_AUDITRSP										638
#define NBAP_IE_ID_MICH_INFORMATION_RESOURCESTATUSIND								639
#define NBAP_IE_ID_MICH_PARAMETERS_CTCH_RECONFRQSTFDD								640
#define NBAP_IE_ID_MICH_PARAMETERS_CTCH_RECONFRQSTTDD								641
#define NBAP_IE_ID_MICH_PARAMETERS_CTCH_SETUPRQSTFDD								642
#define NBAP_IE_ID_MICH_PARAMETERS_CTCH_SETUPRQSTTDD								643
#define NBAP_IE_ID_MODIFICATION_PERIOD												644
#define NBAP_IE_ID_NI_INFORMATION_NOTIFUPDATECMD									645
#define NBAP_IE_ID_S_CCPCH_INFORMATIONLISTEXT_AUDITRSP								646
#define NBAP_IE_ID_S_CCPCH_INFORMATIONLISTEXT_RESOURCESTATUSIND						647
#define NBAP_IE_ID_S_CCPCH_LCR_INFORMATIONLISTEXT_AUDITRSP							648
#define NBAP_IE_ID_S_CCPCH_LCR_INFORMATIONLISTEXT_RESOURCESTATUSIND					649
#define NBAP_IE_ID_HARQ_PREAMBLE_MODE												650
#define NBAP_IE_ID_INITIAL_DL_DPCH_TIMINGADJUSTMENT									651
#define NBAP_IE_ID_INITIAL_DL_DPCH_TIMINGADJUSTMENT_ALLOWED							652
#define NBAP_IE_ID_DLTRANSMISSIONBRANCHLOADVALUE									653
#define NBAP_IE_ID_POWER_LOCAL_CELL_GROUP_CHOICE_CM_RQST							654
#define NBAP_IE_ID_POWER_LOCAL_CELL_GROUP_CHOICE_CM_RSP								655
#define NBAP_IE_ID_POWER_LOCAL_CELL_GROUP_CHOICE_CM_RPRT							656
#define NBAP_IE_ID_SYNCHRONISATIONINDICATOR											657
#define NBAP_IE_ID_HSDPA_AND_EDCH_CELLPORTION_INFORMATION_PSCH_RECONFRQST			658
#define NBAP_IE_ID_HSDPA_AND_EDCH_CELLPORTION_INFORMATIONLIST_PSCH_RECONFRQST		659
#define NBAP_IE_ID_HS_DSCHREQUIREDPOWERVALUE_FOR_CELL_PORTION						660
#define NBAP_IE_ID_HS_DSCHREQUIREDPOWERVALUEINFORMATION_FOR_CELLPORTION				661
#define NBAP_IE_ID_HS_DSCHPROVIDEDBITRATEVALUEINFORMATION_FOR_CELLPORTION			662
#define NBAP_IE_ID_E_AGCH_AND_E_RGCH_E_HICH_FDD_SCRAMBLING_CODE						663
#define NBAP_IE_ID_E_AGCH_FDD_CODE_INFORMATION										664
#define NBAP_IE_ID_E_DCH_CAPABILITY													665
#define NBAP_IE_ID_E_DCH_FDD_DL_CONTROL_CHANNEL_INFORMATION							666
#define NBAP_IE_ID_E_DCH_FDD_INFORMATION											667
#define NBAP_IE_ID_E_DCH_FDD_INFORMATION_RESPONSE									668
#define NBAP_IE_ID_E_DCH_FDD_INFORMATION_TO_MODIFY									669
#define NBAP_IE_ID_E_DCH_MACDFLOWS_TO_ADD											670
#define NBAP_IE_ID_E_DCH_MACDFLOWS_TO_DELETE										671
#define NBAP_IE_ID_E_DCH_RESOURCES_INFORMATION_AUDITRSP								672
#define NBAP_IE_ID_E_DCH_RESOURCES_INFORMATION_RESOURCESTATUSIND					673
#define NBAP_IE_ID_E_DCH_RL_INDICATION												674
#define NBAP_IE_ID_E_DCH_RL_SET_ID													675
#define NBAP_IE_ID_E_DPCH_INFORMATION_RL_RECONFPREPFDD								676
#define NBAP_IE_ID_E_DPCH_INFORMATION_RL_SETUPRQSTFDD								677
#define NBAP_IE_ID_E_RGCH_E_HICH_FDD_CODE_INFORMATION								678
#define NBAP_IE_ID_SERVING_E_DCH_RL_ID												679
#define NBAP_IE_ID_UL_DPDCH_INDICATOR_FOR_E_DCH_OPERATION							680
#define NBAP_IE_ID_FDD_S_CCPCH_FRAMEOFFSET_CTCH_SETUPRQSTFDD						681
#define NBAP_IE_ID_E_DPCH_INFORMATION_RL_RECONFRQSTFDD								682
#define NBAP_IE_ID_MAXIMUM_TARGET_RECEIVEDTOTALWIDEBANDPOWER						683
#define NBAP_IE_ID_E_DCHPROVIDEDBITRATEVALUEINFORMATION								684
#define NBAP_IE_ID_HARQ_PREAMBLE_MODE_ACTIVATION_INDICATOR							685
#define NBAP_IE_ID_RL_SPECIFIC_E_DCH_INFO											686
#define NBAP_IE_ID_E_DCH_CAPACITYCONSUMPTIONLAW										687
#define NBAP_IE_ID_MULTIPLE_DEDICATEDMEASUREMENTVALUELIST_TDD_DM_RSP				688
#define NBAP_IE_ID_MULTIPLE_DEDICATEDMEASUREMENTVALUELIST_LCR_TDD_DM_RSP			689
#define NBAP_IE_ID_E_DCH_REARRANGELIST_BEARER_REARRANGEIND							690
#define NBAP_IE_ID_HSDPA_AND_EDCH_CELLPORTION_INFORMATIONLISTIE_PSCH_RECONFRQST		691
#define NBAP_IE_ID_MULTIPLERL_DL_CCTRCH_INFORMATIONMODIFYLIST_RL_RECONFRQSTTDD		692
#define NBAP_IE_ID_TARGET_NONSERVING_EDCH_TO_TOTAL_EDCH_POWER_RATIO					693
#define NBAP_IE_ID_CELLPORTION_INFORMATIONITEM_CELL_RECONFRQSTFDD					694
#define NBAP_IE_ID_CELLPORTION_INFORMATIONLIST_CELL_RECONFRQSTFDD					695
#define NBAP_IE_ID_MULTIPLE_PUSCH_INFOLIST_DM_RSP									696
#define NBAP_IE_ID_MULTIPLE_PUSCH_INFOLIST_DM_RPRT									697
#define NBAP_IE_ID_REFERENCE_RECEIVEDTOTALWIDEBANDPOWER								698


static int dissect_nbap_InitiatingMessageValueValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree);
static int dissect_nbap_SuccessfulOutcomeValueValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree);
static int dissect_nbap_UnsuccessfulOutcomeValueValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree);
static int dissect_nbap_ProtocolIEValueValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree);
#include "packet-nbap-fn.c"


static int dissect_nbap_InitiatingMessageValueValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree){
	proto_item	*value_item = NULL;
	proto_tree	*value_tree = NULL;
	guint length;

    value_item = proto_tree_add_item(tree, hf_nbap_initiatingMessageValue, tvb, 0, -1, FALSE);
    value_tree = proto_item_add_subtree(value_item, ett_nbap_initiatingMessageValue);

	offset = dissect_per_length_determinant(tvb, offset, actx, value_tree, hf_nbap_pdu_length, &length);
	proto_item_set_len(value_item,length);

	
	switch(ProcedureCode){
	case NBAP_ID_AUDIT:											/* 	0 */
		offset = dissect_id_audit(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_AUDITREQUIRED:									/* 	1 */
		offset = dissect_id_auditRequired(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_BLOCKRESOURCE:									/* 	2 */
		offset = dissect_id_blockResource(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_CELLDELETION:									/* 	3 */
		offset = dissect_id_cellDeletion(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_CELLRECONFIGURATION: 							/* 	4 */
		if (ddMode==NBAP_FDD){
			offset = dissect_id_cellReconfiguration(tvb, offset, actx, value_tree);
		}else{
			offset = dissect_id_cellReconfiguration_tdd(tvb, offset, actx, value_tree);
		}
		break;
	case NBAP_ID_CELLSETUP:										/* 	5 */
		if (ddMode==NBAP_FDD){
			offset = dissect_id_cellSetup(tvb, offset, actx, value_tree);
		}else{
			offset = dissect_id_cellSetup_tdd(tvb, offset, actx, value_tree);
		}
		break;
	case NBAP_ID_COMMONMEASUREMENTFAILURE :						/* 	6 */
		offset = dissect_id_commonMeasurementFailure(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_COMMONMEASUREMENTINITIATION: 					/* 	7 */
		offset = dissect_id_commonMeasurementInitiation(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_COMMONMEASUREMENTREPORT:						/*  8 */
		offset = dissect_id_commonMeasurementReport(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_COMMONMEASUREMENTTERMINATION: 					/*	9 */
		offset = dissect_id_commonMeasurementTermination(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_COMMONTRANSPORTCHANNELDELETE: 					/*	10 */
		offset = dissect_id_commonTransportChannelDelete(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_COMMONTRANSPORTCHANNELRECONFIGURE:				/*	11 */
		if (ddMode==NBAP_FDD){
			offset = dissect_id_commonTransportChannelReconfigure(tvb, offset, actx, value_tree);
		}else{
			offset = dissect_id_commonTransportChannelReconfigure_tdd(tvb, offset, actx, value_tree);
		}
		break;
	case NBAP_ID_COMMONTRANSPORTCHANNELSETUP: 					/*	12 */
		if (ddMode==NBAP_FDD){
			offset = dissect_id_commonTransportChannelSetup(tvb, offset, actx, value_tree);
		}else{
			offset = dissect_id_commonTransportChannelSetup_tdd(tvb, offset, actx, value_tree);
		}
		break;
	case NBAP_ID_RESET:											/*	13 */
		offset = dissect_id_reset(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_COMPRESSEDMODECOMMAND:							/*	14 */
		offset = dissect_id_compressedModeCommand(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_DEDICATEDMEASUREMENTFAILURE: 					/*	16 */
		offset = dissect_id_dedicatedMeasurementFailure(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_DEDICATEDMEASUREMENTINITIATION: 				/*	17 */
		offset = dissect_id_dedicatedMeasurementInitiation(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_DEDICATEDMEASUREMENTREPORT: 					/*	18 */
		offset = dissect_id_dedicatedMeasurementReport(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_DEDICATEDMEASUREMENTTERMINATION: 				/*	19 */
		offset = dissect_id_dedicatedMeasurementTermination(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_DOWNLINKPOWERCONTROL: 							/*	20 */
		offset = dissect_id_downlinkPowerControl(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_ERRORINDICATIONFORDEDICATED:					/*	21 */
		offset = dissect_id_errorIndicationForDedicated(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_PRIVATEMESSAGEFORDEDICATED:					/*	22 */
		offset = dissect_id_compressedModeCommand(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_RADIOLINKADDITION:								/*	23 */
		offset = dissect_id_radioLinkAddition(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_RADIOLINKDELETION:								/*	24 */
		offset = dissect_id_radioLinkDeletion(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_RADIOLINKFAILURE: 								/*	25 */
		offset = dissect_id_radioLinkFailure(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_RADIOLINKRESTORATION: 							/*	26 */
		offset = dissect_id_radioLinkRestoration(tvb, offset, actx, value_tree);
		break;
		break;
	case NBAP_ID_RADIOLINKSETUP: 								/*	27 */
		if (ddMode==NBAP_FDD){
			offset = dissect_id_radioLinkSetup(tvb, offset, actx, value_tree);
		}else{
			offset = dissect_id_radioLinkSetup_tdd(tvb, offset, actx, value_tree);
		}
		break;
	case NBAP_ID_RESOURCESTATUSINDICATION: 						/*	28 */
		offset = dissect_id_resourceStatusIndication(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_SYNCHRONISEDRADIOLINKRECONFIGURATIONCANCELLATION:	/*	29 */
		offset = dissect_id_synchronisedRadioLinkReconfigurationCancellation(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_SYNCHRONISEDRADIOLINKRECONFIGURATIONCOMMIT:		/*	30 */
		offset = dissect_id_synchronisedRadioLinkReconfigurationCommit(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_SYNCHRONISEDRADIOLINKRECONFIGURATIONPREPARATION: /*	31 */
		if (ddMode==NBAP_FDD){
			offset = dissect_id_synchronisedRadioLinkReconfigurationPreparation(tvb, offset, actx, value_tree);
		}else{
			offset = dissect_id_synchronisedRadioLinkReconfigurationPreparation_tdd(tvb, offset, actx, value_tree);
		}
		break;
	case NBAP_ID_SYSTEMINFORMATIONUPDATE: 						/*	32 */
		offset = dissect_id_systemInformationUpdate(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_UNBLOCKRESOURCE: 								/*	33 */
		offset = dissect_id_unblockResource(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_UNSYNCHRONISEDRADIOLINKRECONFIGURATION: 		/*	34 */
		if (ddMode==NBAP_FDD){
			offset = dissect_id_unSynchronisedRadioLinkReconfiguration(tvb, offset, actx, value_tree);
		}else{
			offset = dissect_id_unSynchronisedRadioLinkReconfiguration_tdd(tvb, offset, actx, value_tree);
		}
		break;
	case NBAP_ID_ERRORINDICATIONFORCOMMON:						/*	35 */
		offset = dissect_id_errorIndicationForCommon(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_PRIVATEMESSAGEFORCOMMON:						/*	36 */
		offset = dissect_id_privateMessageForCommon(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_PHYSICALSHAREDCHANNELRECONFIGURATION: 			/*	37 */
		offset = dissect_id_physicalSharedChannelReconfiguration(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_DOWNLINKPOWERTIMESLOTCONTROL: 					/*	38 */
		offset = dissect_id_downlinkPowerTimeslotControl(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_RADIOLINKPREEMPTION:							/*	39 */
		offset = dissect_id_radioLinkPreemption(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_INFORMATIONEXCHANGEFAILURE:					/*	40 */
		offset = dissect_id_informationExchangeFailure(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_INFORMATIONEXCHANGEINITIATION:					/*	41 */
		offset = dissect_id_informationExchangeInitiation(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_INFORMATIONEXCHANGETERMINATION:				/*	42 */
		offset = dissect_id_informationExchangeTermination(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_INFORMATIONREPORTING:							/*	43 */
		offset = dissect_id_informationReporting(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_CELLSYNCHRONISATIONADJUSTMENT:					/*	44 */
		offset = dissect_id_cellSynchronisationAdjustment(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_CELLSYNCHRONISATIONINITIATION:					/*	45 */
		offset = dissect_id_cellSynchronisationInitiation(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_CELLSYNCHRONISATIONRECONFIGURATION:			/*	46 */
		offset = dissect_id_cellSynchronisationReconfiguration(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_CELLSYNCHRONISATIONREPORTING:					/*	47 */
		offset = dissect_id_cellSynchronisationReporting(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_CELLSYNCHRONISATIONTERMINATION:				/*	48 */
		offset = dissect_id_cellSynchronisationTermination(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_CELLSYNCHRONISATIONFAILURE:					/*	49 */
		offset = dissect_id_cellSynchronisationFailure(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_BEARERREARRANGEMENT:							/*	50 */
		offset = dissect_id_BearerRearrangement(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_RADIOLINKACTIVATION:							/*	51 */
		if (ddMode==NBAP_FDD){
			offset = dissect_id_radioLinkActivation(tvb, offset, actx, value_tree);
		}else{
			offset = dissect_id_radioLinkActivation_tdd(tvb, offset, actx, value_tree);
		}
		break;
	case NBAP_ID_RADIOLINKPARAMETERUPDATE:						/*	52 */
		if (ddMode==NBAP_FDD){
			offset = dissect_id_radioLinkParameterUpdate(tvb, offset, actx, value_tree);
		}else{
			offset = dissect_id_radioLinkParameterUpdate_tdd(tvb, offset, actx, value_tree);
		}
		break;
	case NBAP_ID_MBMSNOTIFICATIONUPDATE:						/*	53 */
		offset = dissect_id_mBMSNotificationUpdate(tvb, offset, actx, value_tree);
		break;


	default:
		offset = offset + length;
		break;
	}
	BYTE_ALIGN_OFFSET(offset)
	return offset;
}

static int dissect_nbap_SuccessfulOutcomeValueValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree){
	proto_item	*value_item = NULL;
	proto_tree	*value_tree = NULL;
	guint length;

    value_item = proto_tree_add_item(tree, hf_nbap_successfulOutcomeValue, tvb, 0, -1, FALSE);
    value_tree = proto_item_add_subtree(value_item, ett_nbap_initiatingMessageValue);

	offset = dissect_per_length_determinant(tvb, offset, actx, value_tree, hf_nbap_pdu_length, &length);
	proto_item_set_len(value_item,length);

	
	switch(ProcedureCode){
	case NBAP_ID_AUDIT:											/* 	0 */
		offset = dissect_id_audit_01(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_BLOCKRESOURCE:									/* 	2 */
		offset = dissect_id_blockResource_01(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_CELLDELETION:									/* 	3 */
		offset = dissect_id_cellDeletion_01(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_CELLRECONFIGURATION: 							/* 	4 */
		offset = dissect_id_cellReconfiguration_01(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_CELLSETUP:										/* 	5 */
		offset = dissect_id_cellSetup_01(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_COMMONMEASUREMENTINITIATION: 					/* 	7 */
		offset = dissect_id_commonMeasurementInitiation_01(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_COMMONTRANSPORTCHANNELDELETE: 					/*	10 */
		offset = dissect_id_commonTransportChannelDelete_01(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_COMMONTRANSPORTCHANNELRECONFIGURE:				/*	11 */
		offset = dissect_id_commonTransportChannelReconfigure_01(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_COMMONTRANSPORTCHANNELSETUP: 					/*	12 */
		offset = dissect_id_commonTransportChannelSetup_01(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_RESET:											/*	13 */
		offset = dissect_id_reset_01(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_DEDICATEDMEASUREMENTINITIATION: 				/*	17 */
		offset = dissect_id_dedicatedMeasurementInitiation(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_RADIOLINKADDITION:								/*	23 */
		if (ddMode==NBAP_FDD){
			offset = dissect_id_radioLinkAddition_01(tvb, offset, actx, value_tree);
		}else{
			offset = dissect_id_radioLinkAddition_tdd(tvb, offset, actx, value_tree);
		}
		break;
		break;
	case NBAP_ID_RADIOLINKDELETION:								/*	24 */
		offset = dissect_id_radioLinkDeletion_01(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_RADIOLINKSETUP: 								/*	27 */
		if (ddMode==NBAP_FDD){
			offset = dissect_id_radioLinkSetup_01(tvb, offset, actx, value_tree);
		}else{
			offset = dissect_id_radioLinkSetup_tdd_01(tvb, offset, actx, value_tree);
		}
		break;
	case NBAP_ID_SYNCHRONISEDRADIOLINKRECONFIGURATIONPREPARATION: /*	31 */
		offset = dissect_id_synchronisedRadioLinkReconfigurationPreparation_01(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_SYSTEMINFORMATIONUPDATE: 						/*	32 */
		offset = dissect_id_systemInformationUpdate_01(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_UNSYNCHRONISEDRADIOLINKRECONFIGURATION: 		/*	34 */
		offset = dissect_id_unSynchronisedRadioLinkReconfiguration_01(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_PHYSICALSHAREDCHANNELRECONFIGURATION: 			/*	37 */
		offset = dissect_id_physicalSharedChannelReconfiguration_01(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_INFORMATIONEXCHANGEINITIATION:					/*	41 */
		offset = dissect_id_informationExchangeInitiation_01(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_CELLSYNCHRONISATIONADJUSTMENT:					/*	44 */
		offset = dissect_id_cellSynchronisationAdjustment_01(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_CELLSYNCHRONISATIONINITIATION:					/*	45 */
		offset = dissect_id_cellSynchronisationInitiation_01(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_CELLSYNCHRONISATIONRECONFIGURATION:			/*	46 */
		offset = dissect_id_cellSynchronisationReconfiguration_01(tvb, offset, actx, value_tree);
		break;
	default:
		offset = offset + length;
		break;
	}
	BYTE_ALIGN_OFFSET(offset)
	return offset;
}

static int dissect_nbap_UnsuccessfulOutcomeValueValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree){
	proto_item	*value_item = NULL;
	proto_tree	*value_tree = NULL;
	guint length;

    value_item = proto_tree_add_item(tree, hf_nbap_unsuccessfulOutcomeValue, tvb, 0, -1, FALSE);
    value_tree = proto_item_add_subtree(value_item, ett_nbap_UnsuccessfulOutcomeValue);

	offset = dissect_per_length_determinant(tvb, offset, actx, value_tree, hf_nbap_pdu_length, &length);
	proto_item_set_len(value_item,length);

	
	switch(ProcedureCode){
	case NBAP_ID_AUDIT:											/* 	0 */
		offset = dissect_id_audit_02(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_BLOCKRESOURCE:									/* 	2 */
		offset = dissect_id_blockResource_02(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_CELLDELETION:									/* 	3 */
		offset = dissect_id_cellReconfiguration_02(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_CELLSETUP:										/* 	5 */
		offset = dissect_id_cellSetup_02(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_COMMONMEASUREMENTINITIATION: 					/* 	7 */
		offset = dissect_id_commonMeasurementInitiation_02(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_COMMONTRANSPORTCHANNELRECONFIGURE:				/*	11 */
		offset = dissect_id_commonTransportChannelReconfigure_02(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_COMMONTRANSPORTCHANNELSETUP: 					/*	12 */
		offset = dissect_id_commonTransportChannelSetup_02(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_DEDICATEDMEASUREMENTINITIATION: 				/*	17 */
		offset = dissect_id_dedicatedMeasurementInitiation_02(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_RADIOLINKADDITION:								/*	23 */
		if (ddMode==NBAP_FDD){
			offset = dissect_id_radioLinkAddition_02(tvb, offset, actx, value_tree);
		}else{
			offset = dissect_id_radioLinkAddition_tdd_01(tvb, offset, actx, value_tree);
		}
		break;
	case NBAP_ID_RADIOLINKSETUP: 								/*	27 */
		if (ddMode==NBAP_FDD){
			offset = dissect_id_radioLinkSetup_02(tvb, offset, actx, value_tree);
		}else{
			offset = dissect_id_radioLinkSetup_tdd_02(tvb, offset, actx, value_tree);
		}
		break;
	case NBAP_ID_SYNCHRONISEDRADIOLINKRECONFIGURATIONPREPARATION: /*	31 */
		offset = dissect_id_synchronisedRadioLinkReconfigurationPreparation_02(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_SYSTEMINFORMATIONUPDATE: 						/*	32 */
		offset = dissect_id_systemInformationUpdate_02(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_UNSYNCHRONISEDRADIOLINKRECONFIGURATION: 		/*	34 */
		offset = dissect_id_unSynchronisedRadioLinkReconfiguration_02(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_PHYSICALSHAREDCHANNELRECONFIGURATION: 			/*	37 */
		offset = dissect_id_physicalSharedChannelReconfiguration_02(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_INFORMATIONEXCHANGEINITIATION:					/*	41 */
		offset = dissect_id_informationExchangeInitiation_02(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_CELLSYNCHRONISATIONADJUSTMENT:					/*	44 */
		offset = dissect_id_cellSynchronisationAdjustment_02(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_CELLSYNCHRONISATIONINITIATION:					/*	45 */
		offset = dissect_id_cellSynchronisationInitiation_02(tvb, offset, actx, value_tree);
		break;
	case NBAP_ID_CELLSYNCHRONISATIONRECONFIGURATION:			/*	46 */
		offset = dissect_id_cellSynchronisationReconfiguration_02(tvb, offset, actx, value_tree);
		break;
	default:
		offset = offset + length;
		break;
	}
	BYTE_ALIGN_OFFSET(offset)
	return offset;
}

static int dissect_nbap_ProtocolIEValueValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree){
	proto_item	*value_item = NULL;
	proto_tree	*value_tree = NULL;
	guint length;

    value_item = proto_tree_add_item(tree, hf_nbap_value, tvb, 0, -1, FALSE);
    value_tree = proto_item_add_subtree(value_item, ett_nbap_ProtocolIEValueValue);

	offset = dissect_per_length_determinant(tvb, offset, actx, value_tree, hf_nbap_IE_length, &length);
	proto_item_set_len(value_item,length);

	
	switch(ProtocolIE_ID){
	case NBAP_IE_ID_AICH_INFORMATION:												/*0*/
		offset = dissect_id_AICH_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_AICH_INFORMATIONITEM_RESOURCESTATUSIND:							/*1*/
		offset = offset + length;
		break;
	case NBAP_IE_ID_BCH_INFORMATION:												/*7*/
		offset = dissect_id_BCH_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_BCH_INFORMATIONITEM_RESOURCESTATUSIND:							/*8*/
		offset = offset + length;
		break;
	case NBAP_IE_ID_BCCH_MODIFICATIONTIME:											/*9*/
		offset = dissect_id_BCCH_ModificationTime(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_BLOCKINGPRIORITYINDICATOR:										/*10*/
		offset = dissect_id_BlockingPriorityIndicator(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CAUSE:															/*13*/
		offset = dissect_id_Cause(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CCP_INFORMATIONITEM_AUDITRSP:									/*14*/
		offset = dissect_id_CCP_InformationItem_AuditRsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CCP_INFORMATIONLIST_AUDITRSP:									/*15*/
		offset = dissect_id_CCP_InformationList_AuditRsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CCP_INFORMATIONITEM_RESOURCESTATUSIND:							/*16*/
		offset = dissect_id_CCP_InformationItem_ResourceStatusInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CELL_INFORMATIONITEM_AUDITRSP:									/*17*/
		offset = dissect_id_Cell_InformationItem_AuditRsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CELL_INFORMATIONITEM_RESOURCESTATUSIND:							/*18*/
		offset = dissect_id_Cell_InformationItem_ResourceStatusInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CELL_INFORMATIONLIST_AUDITRSP:									/*19*/
		offset = dissect_id_Cell_InformationList_AuditRsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CELLPARAMETERID:												/*23*/
		offset = dissect_id_CellParameterID(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CFN:															/*24*/
		offset = dissect_id_CFN(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_C_ID:															/*25*/
		offset = dissect_id_C_ID(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_COMMONMEASUREMENTACCURACY:										/*39*/
		offset = dissect_id_CommonMeasurementAccuracy(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_COMMONMEASUREMENTOBJECTTYPE_CM_RPRT:							/* 31 */
		offset = dissect_id_CommonMeasurementObjectType_CM_Rprt(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_COMMONMEASUREMENTOBJECTTYPE_CM_RQST:							/*32*/
		offset = dissect_id_CommonMeasurementObjectType_CM_Rqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_COMMONMEASUREMENTOBJECTTYPE_CM_RSP:								/*33*/
		offset = dissect_id_CommonMeasurementObjectType_CM_Rsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_COMMONMEASUREMENTTYPE:											/*34*/
		offset = dissect_id_CommonMeasurementType(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_COMMONPHYSICALCHANNELID:										/*35*/
		offset = dissect_id_CommonPhysicalChannelID(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_COMMONPHYSICALCHANNELTYPE_CTCH_SETUPRQSTFDD:					/*36*/
		offset = dissect_id_CommonPhysicalChannelType_CTCH_SetupRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_COMMONPHYSICALCHANNELTYPE_CTCH_SETUPRQSTTDD:					/*37*/
		offset = dissect_id_CommonPhysicalChannelType_CTCH_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_COMMUNICATIONCONTROLPORTID:										/*40*/
		offset = dissect_id_CommunicationControlPortID(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CONFIGURATIONGENERATIONID:										/*43*/
		offset = dissect_id_ConfigurationGenerationID(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CRNC_COMMUNICATIONCONTEXTID:									/*44*/
		offset = dissect_id_CRNC_CommunicationContextID(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CRITICALITYDIAGNOSTICS:											/*45*/
		offset = dissect_id_CriticalityDiagnostics(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DCHS_TO_ADD_FDD:												/*48*/
		offset = dissect_id_DCHs_to_Add_FDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DCH_ADDLIST_RL_RECONFPREPTDD:									/*49*/
		offset = offset + length;
		break;
	case NBAP_IE_ID_DCHS_TO_ADD_TDD:												/*50*/
		offset = dissect_id_DCHs_to_Add_TDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DCH_DELETELIST_RL_RECONFPREPFDD:								/*52*/
		offset = dissect_id_DCH_DeleteList_RL_ReconfPrepFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DCH_DELETELIST_RL_RECONFPREPTDD:								/*53*/
		offset = dissect_id_DCH_DeleteList_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DCH_DELETELIST_RL_RECONFRQSTFDD:								/*54*/
		offset = dissect_id_DCH_DeleteList_RL_ReconfRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DCH_DELETELIST_RL_RECONFRQSTTDD:								/*55*/
		offset = dissect_id_DCH_DeleteList_RL_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DCH_FDD_INFORMATION:											/*56*/
		offset = dissect_id_DCH_FDD_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DCH_TDD_INFORMATION:						/*	57 */
		offset = dissect_id_DCH_TDD_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DCH_INFORMATIONRESPONSE:					/*	59 */
		offset = dissect_id_DCH_InformationResponse(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_FDD_DCHS_TO_MODIFY:							/*	62 */
		offset = dissect_id_FDD_DCHs_to_Modify(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TDD_DCHS_TO_MODIFY:							/*	63 */
		offset = dissect_id_TDD_DCHs_to_Modify(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DCH_MODIFYLIST_RL_RECONFRQSTTDD:			/*	65 */
		/*offset = dissect_id_DCH_ModifyList_RL_ReconfRqstTDD(tvb, offset, actx, value_tree);*/
		break;
	case NBAP_IE_ID_DCH_REARRANGELIST_BEARER_REARRANGEIND:		/*	135 */
		offset = dissect_id_DCH_RearrangeList_Bearer_RearrangeInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DEDICATEDMEASUREMENTOBJECTTYPE_DM_RPRT:		/*	67 */
		offset = dissect_id_DedicatedMeasurementObjectType_DM_Rprt(tvb, offset, actx, value_tree);;
		break;
	case NBAP_IE_ID_DEDICATEDMEASUREMENTOBJECTTYPE_DM_RQST:		/*	68 */
		offset = dissect_id_DedicatedMeasurementObjectType_DM_Rqst(tvb, offset, actx, value_tree);;
		break;
	case NBAP_IE_ID_DEDICATEDMEASUREMENTOBJECTTYPE_DM_RSP:		/*	69 */
		offset = dissect_id_DedicatedMeasurementObjectType_DM_Rsp(tvb, offset, actx, value_tree);;
		break;
	case NBAP_IE_ID_DEDICATEDMEASUREMENTTYPE:					/*	70 */
		offset = dissect_id_DedicatedMeasurementType(tvb, offset, actx, value_tree);
		break;	
	case NBAP_IE_ID_DL_CCTRCH_INFORMATIONITEM_RL_SETUPRQSTTDD:	/*	72 */
		offset = dissect_id_DL_CCTrCH_InformationItem_RL_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;	
	case NBAP_IE_ID_DL_CCTRCH_INFORMATIONLIST_RL_ADDITIONRQSTTDD:/*	73 */
		offset = dissect_id_DL_CCTrCH_InformationList_RL_AdditionRqstTDD(tvb, offset, actx, value_tree);
		break;	
	case NBAP_IE_ID_DL_CCTRCH_INFORMATIONLIST_RL_SETUPRQSTTDD:	/*	76 */
		offset = dissect_id_DL_CCTrCH_InformationList_RL_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;	
	case NBAP_IE_ID_DL_DPCH_INFORMATIONITEM_RL_ADDITIONRQSTTDD:	/*	77 */
		offset = dissect_id_DL_DPCH_InformationItem_RL_AdditionRqstTDD(tvb, offset, actx, value_tree);
		break;	
	case NBAP_IE_ID_DL_DPCH_INFORMATIONLIST_RL_SETUPRQSTTDD:	/*	79 */
		offset = dissect_id_DL_DPCH_InformationList_RL_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;	
	case NBAP_IE_ID_DL_DPCH_INFORMATION_RL_RECONFPREPFDD:		/*	81 */
		offset = dissect_id_DL_DPCH_Information_RL_ReconfPrepFDD(tvb, offset, actx, value_tree);
		break;	
	case NBAP_IE_ID_DL_DPCH_INFORMATION_RL_RECONFRQSTFDD:		/*	82 */
		offset = dissect_id_DL_DPCH_Information_RL_ReconfRqstFDD(tvb, offset, actx, value_tree);
		break;	
	case NBAP_IE_ID_DL_DPCH_INFORMATION_RL_SETUPRQSTFDD:		/*	83 */
		offset = dissect_id_DL_DPCH_Information_RL_SetupRqstFDD(tvb, offset, actx, value_tree);
		break;	
	case NBAP_IE_ID_DL_DPCH_TIMINGADJUSTMENT:					/*	21 */
		offset = dissect_id_DL_DPCH_TimingAdjustment(tvb, offset, actx, value_tree);
		break;	
	case NBAP_IE_ID_DL_REFERENCEPOWERINFORMATIONITEM_DL_PC_RQST:/*	84 */
		offset = dissect_id_DL_ReferencePowerInformationItem_DL_PC_Rqst(tvb, offset, actx, value_tree);
		break;	
	case NBAP_IE_ID_DLREFERENCEPOWER:							/*	85 */
		offset = dissect_id_DLReferencePower(tvb, offset, actx, value_tree);
		break;	
	case NBAP_IE_ID_DLREFERENCEPOWERLIST_DL_PC_RQST:			/*	86 */
		offset = dissect_id_DLReferencePowerList_DL_PC_Rqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_87:					/*	87 */
		break;
	case NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_89:					/*	89 */
		break;
	case NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_91:					/*	91 */
		break;
	case NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_93:					/*	93 */
		break;
	case NBAP_IE_ID_DSCHS_TO_ADD_TDD:							/*	96 */
		offset = dissect_id_DSCHs_to_Add_TDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DSCH_INFORMATION_DELETELIST_RL_RECONFPREPTDD:/*	98 */
		offset = dissect_id_DSCH_Information_DeleteList_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DSCH_INFORMATION_MODIFYLIST_RL_RECONFPREPTDD:/*	100 */
		offset = dissect_id_DSCH_Information_ModifyList_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DSCH_INFORMATIONRESPONSE:					/*	105 */
		offset = dissect_id_DSCH_InformationResponse(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_106:					/*	106 */
		break;
	case NBAP_IE_ID_DSCH_TDD_INFORMATION:						/*	107 */
		offset = dissect_id_DSCH_TDD_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_108:					/*	108 */
		break;
	case NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_112:					/*	112 */
		break;
	case NBAP_IE_ID_DSCH_REARRANGELIST_BEARER_REARRANGEIND:		/*	136 */
		offset = dissect_id_DSCH_RearrangeList_Bearer_RearrangeInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_END_OF_AUDIT_SEQUENCE_INDICATOR: 			/*	113 */
		offset = dissect_id_End_Of_Audit_Sequence_Indicator(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_FACH_INFORMATION:							/*	116 */
		offset = dissect_id_FACH_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_FACH_INFORMATIONITEM_RESOURCESTATUSIND:		/*	117 */
		break;
	case NBAP_IE_ID_FACH_PARAMETERSLIST_CTCH_RECONFRQSTTDD:		/*	120 */
		offset = dissect_id_FACH_ParametersList_CTCH_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_FACH_PARAMETERSLISTIE_CTCH_SETUPRQSTFDD:	/*	121 */
		offset = dissect_id_FACH_ParametersListIE_CTCH_SetupRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_FACH_PARAMETERSLISTIE_CTCH_SETUPRQSTTDD:	/*	122 */
		offset = dissect_id_FACH_ParametersListIE_CTCH_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_INDICATIONTYPE_RESOURCESTATUSIND:			/*	123 */
		offset = dissect_id_IndicationType_ResourceStatusInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_LOCAL_CELL_ID:								/*	124 */
		offset = dissect_id_Local_Cell_ID(tvb, offset, actx, value_tree);
		break;	
	case NBAP_IE_ID_LOCAL_CELL_GROUP_INFORMATIONITEM_AUDITRSP:			/*	2 */
		offset = dissect_id_Local_Cell_Group_InformationItem_AuditRsp(tvb, offset, actx, value_tree);
		break;	
	case NBAP_IE_ID_LOCAL_CELL_GROUP_INFORMATIONITEM_RESOURCESTATUSIND:	/*	3 */
		offset = dissect_id_Local_Cell_Group_InformationItem_ResourceStatusInd(tvb, offset, actx, value_tree);
		break;	
	case NBAP_IE_ID_LOCAL_CELL_GROUP_INFORMATIONITEM2_RESOURCESTATUSIND:/*	4 */
		offset = dissect_id_Local_Cell_Group_InformationItem2_ResourceStatusInd(tvb, offset, actx, value_tree);
		break;	
	case NBAP_IE_ID_LOCAL_CELL_GROUP_INFORMATIONLIST_AUDITRSP:			/*	5 */
		offset = dissect_id_Local_Cell_Group_InformationList_AuditRsp(tvb, offset, actx, value_tree);
		break;	
	case NBAP_IE_ID_LOCAL_CELL_INFORMATIONITEM_AUDITRSP:				/*	125 */
		offset = dissect_id_Local_Cell_InformationItem_AuditRsp(tvb, offset, actx, value_tree);
		break;	
	case NBAP_IE_ID_LOCAL_CELL_INFORMATIONITEM_RESOURCESTATUSIND:		/*	126 */
		offset = dissect_id_Local_Cell_InformationItem_ResourceStatusInd(tvb, offset, actx, value_tree);
		break;	
	case NBAP_IE_ID_LOCAL_CELL_INFORMATIONITEM2_RESOURCESTATUSIND:		/*	127 */
		offset = dissect_id_Local_Cell_InformationItem2_ResourceStatusInd(tvb, offset, actx, value_tree);
		break;	
	case NBAP_IE_ID_LOCAL_CELL_INFORMATIONLIST_AUDITRSP:				/*	128 */
		offset = dissect_id_Local_Cell_InformationList_AuditRsp(tvb, offset, actx, value_tree);
		break;	
	case NBAP_IE_ID_ADJUSTMENTPERIOD:									/*	129 */
		offset = dissect_id_AdjustmentPeriod(tvb, offset, actx, value_tree);
		break;	
	case NBAP_IE_ID_MAXADJUSTMENTSTEP:									/*	130 */
		offset = dissect_id_MaxAdjustmentStep(tvb, offset, actx, value_tree);
		break;	
	case NBAP_IE_ID_MAXIMUMTRANSMISSIONPOWER:							/*	131 */
		offset = dissect_id_MaximumTransmissionPower(tvb, offset, actx, value_tree);
		break;	
	case NBAP_IE_ID_MEASUREMENTFILTERCOEFFICIENT:						/*	132 */
		offset = dissect_id_MeasurementFilterCoefficient(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MEASUREMENTID:	/* 133 */
		offset = dissect_id_MeasurementID(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MESSAGESTRUCTURE: /* 115 */
		offset = dissect_id_MessageStructure(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MIB_SB_SIB_INFORMATIONLIST_SYSTEMINFOUPDATERQST:	/*	134 */
		offset = dissect_id_MIB_SB_SIB_InformationList_SystemInfoUpdateRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_NODEB_COMMUNICATIONCONTEXTID:						/*	143 */
		offset = dissect_id_NodeB_CommunicationContextID(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_NEIGHBOURINGCELLMEASUREMENTINFORMATION:				/*	455 */
		offset = dissect_id_NeighbouringCellMeasurementInformation(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_P_CCPCH_INFORMATION:								/*	144 */
		offset = dissect_id_P_CCPCH_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_P_CCPCH_INFORMATIONITEM_RESOURCESTATUSIND:			/*	145 */
		offset = dissect_id_P_CPICH_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_P_CPICH_INFORMATION:								/*	146 */
		break;
	case NBAP_IE_ID_P_CPICH_INFORMATIONITEM_RESOURCESTATUSIND:			/*	147 */
		break;
	case NBAP_IE_ID_P_SCH_INFORMATION:									/*	148 */
		offset = dissect_id_P_SCH_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PCCPCH_INFORMATION_CELL_RECONFRQSTTDD:				/*	150 */
		offset = dissect_id_PCCPCH_Information_Cell_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PCCPCH_INFORMATION_CELL_SETUPRQSTTDD:				/*	151 */
		offset = dissect_id_PCCPCH_Information_Cell_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PCH_PARAMETERS_CTCH_RECONFRQSTTDD:					/*	155 */
		offset = dissect_id_PCH_Parameters_CTCH_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PCH_PARAMETERSITEM_CTCH_SETUPRQSTFDD:				/*	156 */
		offset = dissect_id_PCH_ParametersItem_CTCH_SetupRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PCH_PARAMETERSITEM_CTCH_SETUPRQSTTDD:				/*	157 */
		offset = dissect_id_PCH_ParametersItem_CTCH_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PCH_INFORMATION:									/*	158 */
		offset = dissect_id_PCH_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PDSCH_INFORMATION_ADDLISTIE_PSCH_RECONFRQST:		/*	161 */
		offset = dissect_id_PDSCH_Information_AddListIE_PSCH_ReconfRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PDSCH_INFORMATION_MODIFYLISTIE_PSCH_RECONFRQST:		/*	162 */
		offset = dissect_id_PDSCH_Information_ModifyListIE_PSCH_ReconfRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PDSCHSETS_ADDLIST_PSCH_RECONFRQST:					/*	163 */
		offset = dissect_id_PDSCHSets_AddList_PSCH_ReconfRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PDSCHSETS_DELETELIST_PSCH_RECONFRQST:				/*	164 */
		offset = dissect_id_PDSCHSets_DeleteList_PSCH_ReconfRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PDSCHSETS_MODIFYLIST_PSCH_RECONFRQST:				/*	165 */
		offset = dissect_id_PDSCHSets_ModifyList_PSCH_ReconfRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PICH_INFORMATION:									/*	166 */
		offset = dissect_id_PICH_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PICH_PARAMETERS_CTCH_RECONFRQSTTDD:					/*	168 */
		offset = dissect_id_PICH_Parameters_CTCH_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_POWERADJUSTMENTTYPE:								/*	169 */
		offset = dissect_id_PowerAdjustmentType(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PRACH_INFORMATION:									/*	170 */
		offset = dissect_id_PRACH_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PRIMARYCCPCH_INFORMATION_CELL_RECONFRQSTFDD:		/*	175 */
		offset = dissect_id_PrimaryCCPCH_Information_Cell_ReconfRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PRIMARYCCPCH_INFORMATION_CELL_SETUPRQSTFDD:			/*	176 */
		offset = dissect_id_PrimaryCCPCH_Information_Cell_SetupRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PRIMARYCPICH_INFORMATION_CELL_RECONFRQSTFDD:		/*	177 */
		offset = dissect_id_PrimaryCPICH_Information_Cell_ReconfRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PRIMARYCPICH_INFORMATION_CELL_SETUPRQSTFDD:			/*	178 */
		offset = dissect_id_PrimaryCPICH_Information_Cell_SetupRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PRIMARYSCH_INFORMATION_CELL_RECONFRQSTFDD:			/*	179 */
		offset = dissect_id_PrimarySCH_Information_Cell_ReconfRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PRIMARYSCH_INFORMATION_CELL_SETUPRQSTFDD:			/*	180 */
		offset = dissect_id_PrimarySCH_Information_Cell_SetupRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PRIMARYSCRAMBLINGCODE:								/*	181 */
		offset = dissect_id_PrimaryScramblingCode(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SCH_INFORMATION_CELL_RECONFRQSTTDD:					/*	183 */
		offset = dissect_id_SCH_Information_Cell_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SCH_INFORMATION_CELL_SETUPRQSTTDD:					/*	184 */
		offset = dissect_id_SCH_Information_Cell_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PUSCH_INFORMATION_ADDLISTIE_PSCH_RECONFRQST:		/*	185 */
		offset = dissect_id_PUSCH_Information_AddListIE_PSCH_ReconfRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PUSCH_INFORMATION_MODIFYLISTIE_PSCH_RECONFRQST:		/*	186 */
		offset = dissect_id_PUSCH_Information_ModifyListIE_PSCH_ReconfRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PUSCHSETS_ADDLIST_PSCH_RECONFRQST:					/*	187 */
		offset = dissect_id_PUSCHSets_AddList_PSCH_ReconfRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PUSCHSETS_DELETELIST_PSCH_RECONFRQST:				/*	188 */
		offset = dissect_id_PUSCHSets_DeleteList_PSCH_ReconfRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PUSCHSETS_MODIFYLIST_PSCH_RECONFRQST:				/*	189 */
		offset = dissect_id_PUSCHSets_ModifyList_PSCH_ReconfRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RACH_INFORMATION:									/*	190 */
		offset = dissect_id_RACH_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RACH_PARAMETERSITEM_CTCH_SETUPRQSTFDD:				/*	196 */
		offset = dissect_id_RACH_ParametersItem_CTCH_SetupRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RACH_PARAMETERITEM_CTCH_SETUPRQSTTDD:				/*	197 */
		offset = dissect_id_RACH_ParameterItem_CTCH_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_REPORTCHARACTERISTICS:								/*	198 */
		offset = dissect_id_ReportCharacteristics(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_REPORTING_OBJECT_RL_FAILUREIND:						/*	199 */
		offset = dissect_id_Reporting_Object_RL_FailureInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_REPORTING_OBJECT_RL_RESTOREIND:						/*	200 */
		offset = dissect_id_Reporting_Object_RL_RestoreInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONITEM_DM_RPRT:							/*	202 */
		offset = dissect_id_RL_InformationItem_DM_Rprt(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONITEM_DM_RQST:							/*	203 */
		offset = dissect_id_RL_InformationItem_DM_Rqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONITEM_DM_RSP:							/*	204 */
		offset = dissect_id_RL_InformationItem_DM_Rsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONITEM_RL_ADDITIONRQSTFDD:				/*	205 */
		offset = dissect_id_RL_InformationItem_RL_AdditionRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONITEM_RL_DELETIONRQST:					/*	206 */
		offset = dissect_id_RL_informationItem_RL_DeletionRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONITEM_RL_FAILUREIND:					/*	207 */
		offset = dissect_id_RL_InformationItem_RL_FailureInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONITEM_RL_PREEMPTREQUIREDIND:			/*	286 */
		offset = dissect_id_RL_InformationItem_RL_PreemptRequiredInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONITEM_RL_RECONFPREPFDD:				/*	208 */
		offset = dissect_id_RL_InformationItem_RL_ReconfPrepFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONITEM_RL_RECONFRQSTFDD:				/*	209 */
		offset = dissect_id_RL_InformationItem_RL_ReconfRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONITEM_RL_RESTOREIND:					/*	210 */
		offset = dissect_id_RL_InformationItem_RL_RestoreInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONITEM_RL_SETUPRQSTFDD:					/*	211 */
		offset = dissect_id_RL_InformationItem_RL_SetupRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONLIST_RL_ADDITIONRQSTFDD:				/*	212 */
		offset = dissect_id_RL_InformationList_RL_AdditionRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONLIST_RL_DELETIONRQST:					/*	213 */
		offset = dissect_id_RL_informationList_RL_DeletionRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONLIST_RL_PREEMPTREQUIREDIND:			/*	237 */
		offset = dissect_id_RL_InformationList_RL_ReconfPrepFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONLIST_RL_RECONFPREPFDD:				/*	214 */
		/*offset = (tvb, offset, actx, value_tree);*/
		break;
	case NBAP_IE_ID_RL_INFORMATIONLIST_RL_RECONFRQSTFDD:				/*	215 */
		offset = dissect_id_RL_InformationList_RL_ReconfRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONLIST_RL_SETUPRQSTFDD:					/*	216 */
		offset = dissect_id_RL_InformationList_RL_SetupRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONRESPONSEITEM_RL_ADDITIONRSPFDD:		/*	217 */
		offset = dissect_id_RL_InformationResponseItem_RL_AdditionRspFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONRESPONSEITEM_RL_RECONFREADY:			/*	218 */
		offset = dissect_id_RL_InformationResponseItem_RL_ReconfReady(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONRESPONSEITEM_RL_RECONFRSP:			/*	219 */
		offset = dissect_id_RL_InformationResponseItem_RL_ReconfRsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONRESPONSEITEM_RL_SETUPRSPFDD:			/*	220 */
		offset = dissect_id_RL_InformationResponseItem_RL_SetupRspFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONRESPONSELIST_RL_ADDITIONRSPFDD:		/*	221 */
		offset = dissect_id_RL_InformationResponseList_RL_AdditionRspFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONRESPONSELIST_RL_RECONFREADY:			/*	222 */
		offset = dissect_id_RL_InformationResponseList_RL_ReconfReady(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONRESPONSELIST_RL_RECONFRSP:			/*	223 */
		offset = dissect_id_RL_InformationResponseList_RL_ReconfRsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONRESPONSELIST_RL_SETUPRSPFDD:			/*	224 */
		offset = dissect_id_RL_InformationResponseList_RL_SetupRspFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONRESPONSE_RL_ADDITIONRSPTDD:			/*	225 */
		offset = dissect_id_RL_InformationResponse_RL_AdditionRspTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONRESPONSE_RL_SETUPRSPTDD:				/*	226 */
		offset = dissect_id_RL_InformationResponse_RL_SetupRspTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATION_RL_ADDITIONRQSTTDD:					/*	227 */
		offset = dissect_id_RL_Information_RL_AdditionRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATION_RL_RECONFRQSTTDD:					/*	228 */
		offset = dissect_id_RL_Information_RL_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATION_RL_RECONFPREPTDD:					/*	229 */
		offset = dissect_id_RL_Information_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATION_RL_SETUPRQSTTDD:						/*	230 */
		offset = dissect_id_RL_Information_RL_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_RECONFIGURATIONFAILUREITEM_RL_RECONFFAILURE:		/*	236 */
		offset = dissect_id_RL_ReconfigurationFailureItem_RL_ReconfFailure(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_SET_INFORMATIONITEM_DM_RPRT:						/*	238 */
		offset = dissect_id_RL_Set_InformationItem_DM_Rprt(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_SET_INFORMATIONITEM_DM_RSP:						/*	240 */
		offset = dissect_id_RL_Set_InformationItem_DM_Rsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_SET_INFORMATIONITEM_RL_FAILUREIND:				/*	241 */
		offset = dissect_id_RL_Set_InformationItem_RL_FailureInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_SET_INFORMATIONITEM_RL_RESTOREIND:				/*	242 */
		offset = dissect_id_RL_Set_InformationItem_RL_RestoreInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_S_CCPCH_INFORMATION:								/*	247 */
		offset = dissect_id_S_CCPCH_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_S_CPICH_INFORMATION:								/*	249 */
		offset = dissect_id_S_CPICH_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SCH_INFORMATION:									/*	251 */
		offset = dissect_id_SCH_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_S_SCH_INFORMATION:									/*	253 */
		offset = dissect_id_S_SCH_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SECONDARY_CCPCHLISTIE_CTCH_RECONFRQSTTDD:			/*	257 */
		offset = dissect_id_Secondary_CCPCHListIE_CTCH_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SECONDARY_CCPCH_PARAMETERLISTIE_CTCH_SETUPRQSTTDD:	/*	258 */
		offset = dissect_id_Secondary_CCPCH_parameterListIE_CTCH_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SECONDARY_CCPCH_PARAMETERS_CTCH_RECONFRQSTTDD:		/*	259 */
		offset = dissect_id_Secondary_CCPCH_Parameters_CTCH_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SECONDARYCPICH_INFORMATIONITEM_CELL_RECONFRQSTFDD:	/*	260 */
		offset = dissect_id_SecondaryCPICH_InformationItem_Cell_ReconfRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SECONDARYCPICH_INFORMATIONITEM_CELL_SETUPRQSTFDD:	/*	261 */
		offset = dissect_id_SecondaryCPICH_InformationItem_Cell_SetupRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SECONDARYCPICH_INFORMATIONLIST_CELL_RECONFRQSTFDD:	/*	262 */
		offset = dissect_id_SecondaryCPICH_InformationList_Cell_ReconfRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SECONDARYCPICH_INFORMATIONLIST_CELL_SETUPRQSTFDD:	/*	263 */
		offset = dissect_id_SecondaryCPICH_InformationList_Cell_SetupRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SECONDARYSCH_INFORMATION_CELL_RECONFRQSTFDD:		/*	264 */
		offset = dissect_id_SecondarySCH_Information_Cell_ReconfRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SECONDARYSCH_INFORMATION_CELL_SETUPRQSTFDD:			/*	265 */
		offset = dissect_id_SecondarySCH_Information_Cell_SetupRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SEGMENTINFORMATIONLISTIE_SYSTEMINFOUPDATE:			/*	266 */
		offset = dissect_id_SegmentInformationListIE_SystemInfoUpdate(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SFN:												/* 268 */
		offset = dissect_id_SFN(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SIGNALLINGBEARERREQUESTINDICATOR:					/*	138 */
		offset = dissect_id_SignallingBearerRequestIndicator(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SHUTDOWNTIMER:										/*	269 */
		offset = dissect_id_ShutdownTimer(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_START_OF_AUDIT_SEQUENCE_INDICATOR:					/*	114 */
		offset = dissect_id_Start_Of_Audit_Sequence_Indicator(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SUCCESSFUL_RL_INFORMATIONRESPITEM_RL_ADDITIONFAILUREFDD:/*270 */
		offset = dissect_id_Successful_RL_InformationRespItem_RL_AdditionFailureFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SUCCESSFUL_RL_INFORMATIONRESPITEM_RL_SETUPFAILUREFDD:	/*	271 */
		offset = dissect_id_Successful_RL_InformationRespItem_RL_SetupFailureFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SYNCCASE:												/*	274 */
		offset = dissect_id_SyncCase(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SYNCCASEINDICATORITEM_CELL_SETUPRQSTTDD_PSCH:			/*	275 */
		offset = dissect_id_SyncCaseIndicatorItem_Cell_SetupRqstTDD_PSCH(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_T_CELL:													/*	276 */
		offset = dissect_id_T_Cell(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TARGETCOMMUNICATIONCONTROLPORTID:						/*	139 */
		offset = dissect_id_TargetCommunicationControlPortID(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TIMESLOTCONFIGURATIONLIST_CELL_RECONFRQSTTDD:			/*	277 */
		offset = dissect_id_TimeSlotConfigurationList_Cell_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TIMESLOTCONFIGURATIONLIST_CELL_SETUPRQSTTDD:			/*	278 */
		offset = dissect_id_TimeSlotConfigurationList_Cell_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TRANSMISSIONDIVERSITYAPPLIED:							/*	279 */
		offset = dissect_id_TransmissionDiversityApplied(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TYPEOFERROR:											/*	508 */
		offset = dissect_id_TypeOfError(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UARFCNFORNT:											/*	280 */
		offset = dissect_id_UARFCNforNt(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UARFCNFORND:											/*	281 */
		offset = dissect_id_UARFCNforNd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UARFCNFORNU:											/*	282 */
		offset = dissect_id_UARFCNforNu(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_CCTRCH_INFORMATIONITEM_RL_SETUPRQSTTDD:				/*	284 */
		offset = dissect_id_UL_CCTrCH_InformationItem_RL_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_CCTRCH_INFORMATIONLIST_RL_ADDITIONRQSTTDD:			/*	285 */
		offset = dissect_id_UL_CCTrCH_InformationList_RL_AdditionRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_CCTRCH_INFORMATIONLIST_RL_SETUPRQSTTDD:				/*	288 */
		offset = dissect_id_UL_CCTrCH_InformationList_RL_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_DPCH_INFORMATIONITEM_RL_ADDITIONRQSTTDD:				/*	289 */
		offset = dissect_id_UL_DPCH_InformationItem_RL_AdditionRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_DPCH_INFORMATIONLIST_RL_SETUPRQSTTDD:				/*	291 */
		offset = dissect_id_UL_DPCH_InformationList_RL_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_DPCH_INFORMATION_RL_RECONFPREPFDD:					/*	293 */
		offset = dissect_id_UL_DPCH_Information_RL_ReconfPrepFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_DPCH_INFORMATION_RL_RECONFRQSTFDD:					/*	294 */
		offset = dissect_id_UL_DPCH_Information_RL_ReconfRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_DPCH_INFORMATION_RL_SETUPRQSTFDD:					/*	295 */
		offset = dissect_id_UL_DPCH_Information_RL_SetupRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UNSUCCESSFUL_RL_INFORMATIONRESPITEM_RL_ADDITIONFAILUREFDD:	/*	296 */
		offset = dissect_id_Unsuccessful_RL_InformationRespItem_RL_AdditionFailureFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UNSUCCESSFUL_RL_INFORMATIONRESPITEM_RL_SETUPFAILUREFDD:	/*	297 */
		offset = dissect_id_Unsuccessful_RL_InformationRespItem_RL_SetupFailureFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UNSUCCESSFUL_RL_INFORMATIONRESP_RL_ADDITIONFAILURETDD:	/*	300 */
		offset = dissect_id_Unsuccessful_RL_InformationResp_RL_AdditionFailureTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UNSUCCESSFUL_RL_INFORMATIONRESP_RL_SETUPFAILURETDD:		/*	301 */
		offset = dissect_id_Unsuccessful_RL_InformationResp_RL_SetupFailureTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_USCH_INFORMATION_ADD:									/*	302 */
		offset = dissect_id_USCH_Information_Add(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_USCH_INFORMATION_DELETELIST_RL_RECONFPREPTDD:			/*	304 */
		offset = dissect_id_USCH_Information_DeleteList_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_USCH_INFORMATION_MODIFYLIST_RL_RECONFPREPTDD:			/*	306 */
		offset = dissect_id_USCH_Information_ModifyList_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_USCH_INFORMATIONRESPONSE:								/*	309 */
		offset = dissect_id_USCH_InformationResponse(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_USCH_INFORMATION:										/*	310 */
		offset = dissect_id_USCH_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_USCH_REARRANGELIST_BEARER_REARRANGEIND:					/*	141 */
		offset = dissect_id_USCH_RearrangeList_Bearer_RearrangeInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_ACTIVE_PATTERN_SEQUENCE_INFORMATION: 					/*	315 */
		offset = dissect_id_Active_Pattern_Sequence_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_AICH_PARAMETERSLISTIE_CTCH_RECONFRQSTFDD:				/*	316 */
		offset = dissect_id_AICH_ParametersListIE_CTCH_ReconfRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_ADJUSTMENTRATIO:										/*	317 */
		offset = dissect_id_AdjustmentRatio(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_NOT_USED_320:											/*	320 */
	case NBAP_IE_ID_NOT_USED_322:											/*	322 */
		break;
	case NBAP_IE_ID_FACH_PARAMETERSLISTIE_CTCH_RECONFRQSTFDD:				/*	323 */
		offset = dissect_id_FACH_ParametersListIE_CTCH_ReconfRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CAUSELEVEL_PSCH_RECONFFAILURE:							/*	324 */
		offset = dissect_id_CauseLevel_PSCH_ReconfFailure(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CAUSELEVEL_RL_ADDITIONFAILUREFDD:						/*	325 */
		offset = dissect_id_CauseLevel_RL_AdditionFailureFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CAUSELEVEL_RL_ADDITIONFAILURETDD:						/*	326 */
		offset = dissect_id_CauseLevel_RL_AdditionFailureTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CAUSELEVEL_RL_RECONFFAILURE:							/*	327 */
		offset = dissect_id_CauseLevel_RL_ReconfFailure(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CAUSELEVEL_RL_SETUPFAILUREFDD:							/*	328 */
		offset = dissect_id_CauseLevel_RL_SetupFailureFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CAUSELEVEL_RL_SETUPFAILURETDD:							/*	329 */
		offset = dissect_id_CauseLevel_RL_SetupFailureTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_NOT_USED_330:											/*	330 */
	case NBAP_IE_ID_NOT_USED_332:											/*	332 */
		break;
	case NBAP_IE_ID_CLOSED_LOOP_TIMING_ADJUSTMENT_MODE:						/*	333 */
		offset = dissect_id_Closed_Loop_Timing_Adjustment_Mode(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_COMMONPHYSICALCHANNELTYPE_CTCH_RECONFRQSTFDD:			/*	334 */
		offset = dissect_id_CommonPhysicalChannelType_CTCH_ReconfRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_COMPRESSED_MODE_DEACTIVATION_FLAG:						/*	335 */
		offset = dissect_id_Compressed_Mode_Deactivation_Flag(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_NOT_USED_336:											/*	336 */
	case NBAP_IE_ID_NOT_USED_342:											/*	342 */
	case NBAP_IE_ID_NOT_USED_343:											/*	343 */
		break;
	case NBAP_IE_ID_DL_CCTRCH_INFORMATIONADDLIST_RL_RECONFPREPTDD:			/*	346 */
		offset = dissect_id_DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DL_CCTRCH_INFORMATIONDELETEITEM_RL_RECONFRQSTTDD:		/*	347 */
		offset = dissect_id_DL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DL_CCTRCH_INFORMATIONDELETELIST_RL_RECONFPREPTDD:		/*	348 */
		offset = dissect_id_DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DL_CCTRCH_INFORMATIONDELETELIST_RL_RECONFRQSTTDD:		/*	349 */
		offset = dissect_id_DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DL_CCTRCH_INFORMATIONMODIFYITEM_RL_RECONFRQSTTDD:		/*	350 */
		offset = dissect_id_DL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DL_CCTRCH_INFORMATIONMODIFYLIST_RL_RECONFPREPTDD:		/*	351 */
		offset = dissect_id_DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DL_CCTRCH_INFORMATIONMODIFYLIST_RL_RECONFRQSTTDD:		/*	352 */
		offset = dissect_id_DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DL_DPCH_INFORMATIONADDLISTIE_RL_RECONFPREPTDD:			/*	353 */
		offset = dissect_id_DL_DPCH_InformationAddListIE_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DL_DPCH_INFORMATIONMODIFY_ADDLISTIE_RL_RECONFPREPTDD:	/*	355 */
		offset = dissect_id_DL_DPCH_InformationModify_AddListIE_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DL_DPCH_INFORMATIONMODIFY_DELETELISTIE_RL_RECONFPREPTDD:/*	356 */
		offset = dissect_id_DL_DPCH_InformationModify_DeleteListIE_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DL_DPCH_INFORMATIONMODIFY_MODIFYLISTIE_RL_RECONFPREPTDD:/*	357 */
		offset = dissect_id_DL_DPCH_InformationModify_ModifyListIE_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DL_TPC_PATTERN01COUNT: 									/*	358 */
		offset = dissect_id_DL_TPC_Pattern01Count(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DPC_MODE:												/*	450 */
		offset = dissect_id_DPC_Mode(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DPCHCONSTANT:											/*	359 */
		offset = dissect_id_DPCHConstant(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_94:								/*	94 */
	case NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_110:								/*	110 */
	case NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_111:								/*	111 */
		break;
	case NBAP_IE_ID_FACH_PARAMETERSLIST_CTCH_SETUPRSP:						/*	362 */
		offset = dissect_id_FACH_ParametersList_CTCH_SetupRsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_LIMITED_POWER_INCREASE_INFORMATION_CELL_SETUPRQSTFDD:	/*	369 */
		offset = dissect_id_Limited_power_increase_information_Cell_SetupRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PCH_PARAMETERS_CTCH_SETUPRSP:							/*	374 */
		offset = dissect_id_PCH_Parameters_CTCH_SetupRsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PCH_PARAMETERSITEM_CTCH_RECONFRQSTFDD:					/*	375 */
		offset = dissect_id_PCH_ParametersItem_CTCH_ReconfRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_NOT_USED_376:											/*	376 */
		break;
	case NBAP_IE_ID_PICH_PARAMETERSITEM_CTCH_RECONFRQSTFDD:					/*	380 */
		offset = dissect_id_PICH_ParametersItem_CTCH_ReconfRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PRACHCONSTANT:											/*	381 */
		offset = dissect_id_PRACHConstant(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PRACH_PARAMETERSLISTIE_CTCH_RECONFRQSTFDD:				/*	383 */
		offset = dissect_id_PRACH_ParametersListIE_CTCH_ReconfRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PUSCHCONSTANT:											/*	384 */
		offset = dissect_id_PUSCHConstant(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RACH_PARAMETERS_CTCH_SETUPRSP:							/*	385 */
		offset = dissect_id_RACH_Parameters_CTCH_SetupRsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_443:								/*	443 */
		break;
	case NBAP_IE_ID_SYNCHRONISATION_CONFIGURATION_CELL_RECONFRQST:			/*	393 */
		offset = dissect_id_Synchronisation_Configuration_Cell_ReconfRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SYNCHRONISATION_CONFIGURATION_CELL_SETUPRQST:			/*	394 */
		offset = dissect_id_Synchronisation_Configuration_Cell_SetupRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TRANSMISSION_GAP_PATTERN_SEQUENCE_INFORMATION:			/*	395 */
		offset = dissect_id_Transmission_Gap_Pattern_Sequence_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_CCTRCH_INFORMATIONADDLIST_RL_RECONFPREPTDD:			/*	396 */
		offset = dissect_id_UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_CCTRCH_INFORMATIONDELETEITEM_RL_RECONFRQSTTDD:		/*	397 */
		offset = dissect_id_UL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_CCTRCH_INFORMATIONDELETELIST_RL_RECONFPREPTDD:		/*	398 */
		offset = dissect_id_UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_CCTRCH_INFORMATIONDELETELIST_RL_RECONFRQSTTDD:		/*	399 */
		offset = dissect_id_UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_CCTRCH_INFORMATIONMODIFYITEM_RL_RECONFRQSTTDD:		/*	400 */
		offset = dissect_id_UL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_CCTRCH_INFORMATIONMODIFYLIST_RL_RECONFPREPTDD:		/*	401 */
		offset = dissect_id_UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_CCTRCH_INFORMATIONMODIFYLIST_RL_RECONFRQSTTDD:		/*	402 */
		offset = dissect_id_UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_DPCH_INFORMATIONADDLISTIE_RL_RECONFPREPTDD:			/*	403 */
		offset = dissect_id_UL_DPCH_InformationAddListIE_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_DPCH_INFORMATIONMODIFY_ADDLISTIE_RL_RECONFPREPTDD:	/*	405 */
		offset = dissect_id_UL_DPCH_InformationModify_AddListIE_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_DPCH_INFORMATIONMODIFY_DELETELISTIE_RL_RECONFPREPTDD:/*	406 */
		offset = dissect_id_UL_DPCH_InformationModify_DeleteListIE_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_DPCH_INFORMATIONMODIFY_MODIFYLISTIE_RL_RECONFPREPTDD:/*	407 */
		offset = dissect_id_UL_DPCH_InformationModify_ModifyListIE_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UNSUCCESSFUL_PDSCHSETITEM_PSCH_RECONFFAILURETDD:		/*	408 */
		offset = dissect_id_Unsuccessful_PDSCHSetItem_PSCH_ReconfFailureTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UNSUCCESSFUL_PUSCHSETITEM_PSCH_RECONFFAILURETDD:		/*	409 */
		offset = dissect_id_Unsuccessful_PUSCHSetItem_PSCH_ReconfFailureTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_COMMUNICATIONCONTEXTINFOITEM_RESET:						/*	412 */
		offset = dissect_id_CommunicationContextInfoItem_Reset(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_COMMUNICATIONCONTROLPORTINFOITEM_RESET:					/*	414 */
		offset = dissect_id_CommunicationControlPortInfoItem_Reset(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RESETINDICATOR:											/*	416 */
		offset = dissect_id_ResetIndicator(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_417:								/*	417 */
	case NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_418:								/*	418 */
	case NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_419:								/*	419 */
	case NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_142:								/*	142 */
		break;
	case NBAP_IE_ID_TIMINGADVANCEAPPLIED:									/*	287 */
		offset = dissect_id_TimingAdvanceApplied(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CFNREPORTINGINDICATOR:									/*	6	*/
		offset = dissect_id_CFNReportingIndicator(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SFNREPORTINGINDICATOR:									/*	11	*/
		offset = dissect_id_SFNReportingIndicator(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_INNERLOOPDLPCSTATUS:									/*	12 */
		offset = dissect_id_InnerLoopDLPCStatus(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TIMESLOTISCPINFO:										/*	283 */
		offset = dissect_id_TimeslotISCPInfo(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PICH_PARAMETERSITEM_CTCH_SETUPRQSTTDD:					/*	167 */
		offset = dissect_id_PICH_ParametersItem_CTCH_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PRACH_PARAMETERSITEM_CTCH_SETUPRQSTTDD:					/*	20 */
		offset = dissect_id_PRACH_ParametersItem_CTCH_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CCTRCH_INFORMATIONITEM_RL_FAILUREIND:					/*	46 */
		offset = dissect_id_CCTrCH_InformationItem_RL_FailureInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CCTRCH_INFORMATIONITEM_RL_RESTOREIND:					/*	47 */
		offset = dissect_id_CCTrCH_InformationItem_RL_RestoreInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CAUSELEVEL_SYNCADJUSTMNTFAILURETDD:						/*	420 */
		offset = dissect_id_CauseLevel_SyncAdjustmntFailureTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CELLADJUSTMENTINFO_SYNCADJUSTMNTRQSTTDD:				/*	421 */
		offset = dissect_id_CellAdjustmentInfo_SyncAdjustmntRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CELLADJUSTMENTINFOITEM_SYNCADJUSTMENTRQSTTDD:			/*	494 */
		offset = dissect_id_CellAdjustmentInfoItem_SyncAdjustmentRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CELLSYNCBURSTINFOLIST_CELLSYNCRECONFRQSTTDD:			/*	482 */
		offset = dissect_id_CellSyncBurstInfoList_CellSyncReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CELLSYNCBURSTTRANSINIT_CELLSYNCINITIATIONRQSTTDD:		/*	422 */
		offset = dissect_id_CellSyncBurstTransInit_CellSyncInitiationRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CELLSYNCBURSTMEASUREINIT_CELLSYNCINITIATIONRQSTTDD:		/*	423 */
		offset = dissect_id_CellSyncBurstMeasureInit_CellSyncInitiationRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CELLSYNCBURSTTRANSRECONFIGURATION_CELLSYNCRECONFRQSTTDD:/*	424 */
		offset = dissect_id_CellSyncBurstMeasReconfiguration_CellSyncReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CELLSYNCBURSTMEASRECONFIGURATION_CELLSYNCRECONFRQSTTDD:	/*	425 */
		offset = dissect_id_CellSyncBurstMeasInfoList_CellSyncReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CELLSYNCBURSTTRANSINFOLIST_CELLSYNCRECONFRQSTTDD:		/*	426 */
		offset = dissect_id_CellSyncBurstTransReconfInfo_CellSyncReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CELLSYNCBURSTMEASINFOLIST_CELLSYNCRECONFRQSTTDD:		/*	427 */
		offset = dissect_id_CellSyncInfo_CellSyncReprtTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CELLSYNCBURSTTRANSRECONFINFO_CELLSYNCRECONFRQSTTDD:		/*	428 */
		offset = dissect_id_CellSyncBurstTransReconfInfo_CellSyncReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CELLSYNCINFO_CELLSYNCREPRTTDD:							/*	429 */
		offset = dissect_id_CellSyncInfo_CellSyncReprtTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CSBTRANSMISSIONID:										/*	430 */
		offset = dissect_id_CSBTransmissionID(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CSBMEASUREMENTID:										/*	431 */
		offset = dissect_id_CSBMeasurementID(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_INTSTDPHCELLSYNCINFOITEM_CELLSYNCREPRTTDD:				/*	432 */
		break;
	case NBAP_IE_ID_NCYCLESPERSFNPERIOD: 									/*	433 */
		offset = dissect_id_NCyclesPerSFNperiod(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_NREPETITIONSPERCYCLEPERIOD:								/*	434 */
		offset = dissect_id_NRepetitionsPerCyclePeriod(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SYNCFRAMENUMBER:										/*	437 */
		offset = dissect_id_SyncFrameNumber(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SYNCHRONISATIONREPORTTYPE:								/*	438 */
		offset = dissect_id_SynchronisationReportType(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SYNCHRONISATIONREPORTCHARACTERISTICS:					/*	439 */
		offset = dissect_id_SynchronisationReportCharacteristics(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UNSUCCESSFUL_CELL_INFORMATIONRESPITEM_SYNCADJUSTMNTFAILURETDD:/*	440 */
		offset = dissect_id_Unsuccessful_cell_InformationRespItem_SyncAdjustmntFailureTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_LATEENTRANCECELLSYNCINFOITEM_CELLSYNCREPRTTDD:			/*	119 */
		break;
	case NBAP_IE_ID_REFERENCECLOCKAVAILABILITY:								/*	435 */
		offset = dissect_id_ReferenceClockAvailability(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_REFERENCESFNOFFSET:										/*	436 */
		offset = dissect_id_ReferenceSFNoffset(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_INFORMATIONEXCHANGEID:									/*	444 */
		offset = dissect_id_InformationExchangeID(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_INFORMATIONEXCHANGEOBJECTTYPE_INFEX_RQST:				/*	445 */
		offset = dissect_id_InformationExchangeObjectType_InfEx_Rqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_INFORMATIONTYPE:										/*	446 */
		offset = dissect_id_InformationType(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_INFORMATIONREPORTCHARACTERISTICS:						/*	447 */
		offset = dissect_id_InformationReportCharacteristics(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_INFORMATIONEXCHANGEOBJECTTYPE_INFEX_RSP:				/*	448 */
		offset = dissect_id_InformationExchangeObjectType_InfEx_Rsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_INFORMATIONEXCHANGEOBJECTTYPE_INFEX_RPRT:				/*	449 */
		offset = dissect_id_InformationExchangeObjectType_InfEx_Rprt(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_IPDLPARAMETER_INFORMATION_CELL_RECONFRQSTFDD:			/*	451 */
		offset = dissect_id_IPDLParameter_Information_Cell_ReconfRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_IPDLPARAMETER_INFORMATION_CELL_SETUPRQSTFDD:			/*	452 */
		offset = dissect_id_IPDLParameter_Information_Cell_SetupRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_IPDLPARAMETER_INFORMATION_CELL_RECONFRQSTTDD:			/*	453 */
		offset = dissect_id_IPDLParameter_Information_Cell_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_IPDLPARAMETER_INFORMATION_CELL_SETUPRQSTTDD:			/*	454 */
		offset = dissect_id_IPDLParameter_Information_Cell_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DL_DPCH_LCR_INFORMATION_RL_SETUPRQSTTDD:				/*	74 */
		offset = dissect_id_DL_DPCH_LCR_Information_RL_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;

	case NBAP_IE_ID_DWPCH_LCR_INFORMATION:									/*	78 */
		offset = dissect_id_DwPCH_LCR_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DWPCH_LCR_INFORMATIONLIST_AUDITRSP:                   	/*	90 */
		offset = dissect_id_DwPCH_LCR_InformationList_AuditRsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DWPCH_LCR_INFORMATION_CELL_SETUPRQSTTDD:                /*	97 */
		offset = dissect_id_DwPCH_LCR_Information_Cell_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DWPCH_LCR_INFORMATION_CELL_RECONFRQSTTDD:				/*	99 */
		offset = dissect_id_DwPCH_LCR_Information_Cell_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DWPCH_LCR_INFORMATION_RESOURCESTATUSIND:				/*	101 */
		offset = dissect_id_DwPCH_LCR_Information_ResourceStatusInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MAXFACH_POWER_LCR_CTCH_SETUPRQSTTDD:                   	/*	154 */
		offset = dissect_id_maxFACH_Power_LCR_CTCH_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MAXFACH_POWER_LCR_CTCH_RECONFRQSTTDD:                   /*	174 */
		offset = dissect_id_maxFACH_Power_LCR_CTCH_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_FPACH_LCR_INFORMATION:									/*	290 */
		offset = dissect_id_FPACH_LCR_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_FPACH_LCR_INFORMATION_AUDITRSP:                   		/*	292 */
		offset = dissect_id_FPACH_LCR_Information_AuditRsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_FPACH_LCR_INFORMATIONLIST_AUDITRSP:                   	/*	22 */
		offset = dissect_id_FPACH_LCR_InformationList_AuditRsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_FPACH_LCR_INFORMATIONLIST_RESOURCESTATUSIND:            /* 	311 */
		offset = dissect_id_FPACH_LCR_InformationList_ResourceStatusInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_FPACH_LCR_PARAMETERS_CTCH_SETUPRQSTTDD:                 /*	312 */
		offset = dissect_id_FPACH_LCR_Parameters_CTCH_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_FPACH_LCR_PARAMETERS_CTCH_RECONFRQSTTDD:                /*	314 */
		offset = dissect_id_FPACH_LCR_Parameters_CTCH_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PCCPCH_LCR_INFORMATION_CELL_SETUPRQSTTDD:               /*	456 */
		offset = dissect_id_PCCPCH_LCR_Information_Cell_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PCH_POWER_LCR_CTCH_SETUPRQSTTDD:						/*	457 */
		offset = dissect_id_PCH_Power_LCR_CTCH_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PCH_POWER_LCR_CTCH_RECONFRQSTTDD:						/*	458 */
		offset = dissect_id_PCH_Power_LCR_CTCH_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PICH_LCR_PARAMETERS_CTCH_SETUPRQSTTDD:                  /*	459 */
		offset = dissect_id_PICH_LCR_Parameters_CTCH_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PRACH_LCR_PARAMETERSLIST_CTCH_SETUPRQSTTDD:             /*	461 */
		offset = dissect_id_PRACH_LCR_ParametersList_CTCH_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONRESPONSE_LCR_RL_SETUPRSPTDD:	            /* 	463 */
		offset = dissect_id_RL_InformationResponse_LCR_RL_SetupRspTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SECONDARY_CCPCH_LCR_PARAMETERLIST_CTCH_SETUPRQSTTDD:    /*  465 */
		offset = dissect_id_Secondary_CCPCH_LCR_parameterList_CTCH_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TIMESLOT:												/*	495 */
		offset = dissect_id_TimeSlot(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TIMESLOTCONFIGURATIONLIST_LCR_CELL_RECONFRQSTTDD:       /*  466 */
		offset = dissect_id_TimeSlotConfigurationList_LCR_Cell_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TIMESLOTCONFIGURATIONLIST_LCR_CELL_SETUPRQSTTDD:        /*  467 */
		offset = dissect_id_TimeSlotConfigurationList_LCR_Cell_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TIMESLOTISCP_LCR_INFOLIST_RL_SETUPRQSTTDD:              /*	468 */
		offset = dissect_id_TimeslotISCP_LCR_InfoList_RL_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TIMESLOTLCR_CM_RQST:                   					/*	469 */
		offset = dissect_id_TimeSlotLCR_CM_Rqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_DPCH_LCR_INFORMATION_RL_SETUPRQSTTDD:                /*	470 */
		offset = dissect_id_UL_DPCH_LCR_Information_RL_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DL_DPCH_INFORMATIONITEM_LCR_RL_ADDITIONRQSTTDD:			/*	472 */
		offset = dissect_id_DL_DPCH_InformationItem_LCR_RL_AdditionRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_DPCH_INFORMATIONITEM_LCR_RL_ADDITIONRQSTTDD:			/*	473 */
		offset = dissect_id_UL_DPCH_InformationItem_LCR_RL_AdditionRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TIMESLOTISCP_INFORMATIONLIST_LCR_RL_ADDITIONRQSTTDD:	/*	474 */
		offset = dissect_id_TimeslotISCP_InformationList_LCR_RL_AdditionRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DL_DPCH_LCR_INFORMATIONADDLIST_RL_RECONFPREPTDD:		/*	475 */
		offset = dissect_id_DL_DPCH_LCR_InformationAddList_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DL_DPCH_LCR_INFORMATIONMODIFY_ADDLIST_RL_RECONFPREPTDD:			/*	477 */
		offset = dissect_id_DL_DPCH_LCR_InformationModify_AddList_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DL_TIMESLOT_LCR_INFORMATIONMODIFY_MODIFYLIST_RL_RECONFPREPTDD:	/*	479 */
		offset = dissect_id_DL_Timeslot_LCR_InformationModify_ModifyList_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TIMESLOTISCPINFOLIST_LCR_DL_PC_RQSTTDD:							/*	480 */
		offset = dissect_id_TimeslotISCPInfoList_LCR_DL_PC_RqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_DPCH_LCR_INFORMATIONADDLISTIE_RL_RECONFPREPTDD:				/*	481 */
		offset = dissect_id_UL_DPCH_LCR_InformationAddListIE_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_DPCH_LCR_INFORMATIONMODIFY_ADDLIST:							/*	483 */
		offset = dissect_id_UL_DPCH_LCR_InformationModify_AddList(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_TIMESLOTLCR_INFORMATION_RL_RECONFPREPTDD:					/*	485 */
		offset = dissect_id_UL_TimeslotLCR_Information_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_SIRTARGET:													/*	510 */
		offset = dissect_id_UL_SIRTarget(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PDSCH_ADDINFORMATION_LCR_PSCH_RECONFRQST:						/*	486 */
		offset = dissect_id_PDSCH_AddInformation_LCR_PSCH_ReconfRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PDSCH_ADDINFORMATION_LCR_ADDLISTIE_PSCH_RECONFRQST:				/*	487 */
		offset = dissect_id_PDSCH_ModifyInformation_LCR_PSCH_ReconfRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_26:										/*	 26 */
	case NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_27:										/*	 27 */
		break;
	case NBAP_IE_ID_PDSCH_MODIFYINFORMATION_LCR_PSCH_RECONFRQST:					/*	488 */
		offset = dissect_id_PUSCH_AddInformation_LCR_PSCH_ReconfRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PDSCH_MODIFYINFORMATION_LCR_MODIFYLISTIE_PSCH_RECONFRQST:		/*	489 */
		offset = dissect_id_PUSCH_ModifyInformation_LCR_PSCH_ReconfRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PUSCH_ADDINFORMATION_LCR_PSCH_RECONFRQST:						/*	490 */
		break;
	case NBAP_IE_ID_PUSCH_ADDINFORMATION_LCR_ADDLISTIE_PSCH_RECONFRQST:				/*	491 */
		break;
	case NBAP_IE_ID_PUSCH_MODIFYINFORMATION_LCR_PSCH_RECONFRQST:					/*	492 */
		break;
	case NBAP_IE_ID_PUSCH_MODIFYINFORMATION_LCR_MODIFYLISTIE_PSCH_RECONFRQST:		/*	493 */
		break;
	case NBAP_IE_ID_TIMESLOTINFO_CELLSYNCINITIATIONRQSTTDD:							/*	496 */
		offset = dissect_id_timeslotInfo_CellSyncInitiationRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SYNCREPORTTYPE_CELLSYNCREPRTTDD:								/*	497 */
		offset = dissect_id_SyncReportType_CellSyncReprtTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_POWER_LOCAL_CELL_GROUP_INFORMATIONITEM_AUDITRSP:				/*	498 */
		offset = dissect_id_Power_Local_Cell_Group_InformationItem_AuditRsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_POWER_LOCAL_CELL_GROUP_INFORMATIONITEM_RESOURCESTATUSIND:		/*	499 */
		offset = dissect_id_Power_Local_Cell_Group_InformationItem_ResourceStatusInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_POWER_LOCAL_CELL_GROUP_INFORMATIONITEM2_RESOURCESTATUSIND:		/*	500 */
		offset = dissect_id_Power_Local_Cell_Group_InformationItem2_ResourceStatusInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_POWER_LOCAL_CELL_GROUP_INFORMATIONLIST_AUDITRSP:				/*	501 */
		offset = dissect_id_Power_Local_Cell_Group_InformationList_AuditRsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_POWER_LOCAL_CELL_GROUP_INFORMATIONLIST_RESOURCESTATUSIND:		/*	502 */
		offset = dissect_id_Power_Local_Cell_Group_InformationList_ResourceStatusInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_POWER_LOCAL_CELL_GROUP_INFORMATIONLIST2_RESOURCESTATUSIND:		/*	503 */
		offset = dissect_id_Power_Local_Cell_Group_InformationList2_ResourceStatusInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_POWER_LOCAL_CELL_GROUP_ID:										/*	504 */
		offset = dissect_id_Power_Local_Cell_Group_ID(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PUSCH_INFO_DM_RQST:												/*	505 */
		offset = dissect_id_PUSCH_Info_DM_Rqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PUSCH_INFO_DM_RSP:												/*	506 */
		offset = dissect_id_PUSCH_Info_DM_Rsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PUSCH_INFO_DM_RPRT:												/*	507 */
		offset = dissect_id_PUSCH_Info_DM_Rprt(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_INITDL_POWER:													/*	509 */
		offset = dissect_id_InitDL_Power(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CELLSYNCBURSTREPETITIONPERIOD:									/*	511 */
		offset = dissect_id_cellSyncBurstRepetitionPeriod(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_REPORTCHARACTERISTICSTYPE_ONMODIFICATION:						/*	512 */
		offset = dissect_id_ReportCharacteristicsType_OnModification(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SFNSFNMEASUREMENTVALUEINFORMATION:								/*	513 */
		offset = dissect_id_SFNSFNMeasurementValueInformation(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SFNSFNMEASUREMENTTHRESHOLDINFORMATION:							/*	514 */
		offset = dissect_id_SFNSFNMeasurementThresholdInformation(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TUTRANGPSMEASUREMENTVALUEINFORMATION:							/*	515 */
		offset = dissect_id_TUTRANGPSMeasurementValueInformation(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TUTRANGPSMEASUREMENTTHRESHOLDINFORMATION:						/*	516 */
		offset = dissect_id_TUTRANGPSMeasurementThresholdInformation(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RX_TIMING_DEVIATION_VALUE_LCR:									/*	520 */
		offset = dissect_id_Rx_Timing_Deviation_Value_LCR(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_INFORMATIONRESPONSE_LCR_RL_ADDITIONRSPTDD:					/*	51	*/
		offset = dissect_id_RL_InformationResponse_LCR_RL_AdditionRspTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DL_POWERBALANCING_INFORMATION:									/*  28	*/
		offset = dissect_id_DL_PowerBalancing_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DL_POWERBALANCING_ACTIVATIONINDICATOR:							/*	29	*/
		offset = dissect_id_DL_PowerBalancing_ActivationIndicator(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DL_POWERBALANCING_UPDATEDINDICATOR:								/*	30	*/
		offset = dissect_id_DL_PowerBalancing_UpdatedIndicator(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CCTRCH_INITIAL_DL_POWER_RL_SETUPRQSTTDD:						/*	517	*/
		offset = dissect_id_CCTrCH_Initial_DL_Power_RL_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CCTRCH_INITIAL_DL_POWER_RL_ADDITIONRQSTTDD:						/*	518	*/
		offset = dissect_id_CCTrCH_Initial_DL_Power_RL_AdditionRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CCTRCH_INITIAL_DL_POWER_RL_RECONFPREPTDD:						/*	519	*/
		offset = dissect_id_CCTrCH_Initial_DL_Power_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_IPDLPARAMETER_INFORMATION_LCR_CELL_SETUPRQSTTDD:				/*	41	*/
		offset = dissect_id_IPDLParameter_Information_LCR_Cell_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_IPDLPARAMETER_INFORMATION_LCR_CELL_RECONFRQSTTDD: 				/*	42	*/
		offset = dissect_id_IPDLParameter_Information_LCR_Cell_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HS_PDSCH_HS_SCCH_E_AGCH_E_RGCH_E_HICH_MAXPOWER_PSCH_RECONFRQST:	/*	522	*/
		offset = dissect_id_HS_PDSCH_HS_SCCH_E_AGCH_E_RGCH_E_HICH_MaxPower_PSCH_ReconfRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HS_PDSCH_HS_SCCH_SCRAMBLINGCODE_PSCH_RECONFRQST:				/*	523	*/
		offset = dissect_id_HS_PDSCH_HS_SCCH_ScramblingCode_PSCH_ReconfRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HS_PDSCH_FDD_CODE_INFORMATION_PSCH_RECONFRQST:					/*	524	*/
		offset = dissect_id_HS_PDSCH_FDD_Code_Information_PSCH_ReconfRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HS_SCCH_FDD_CODE_INFORMATION_PSCH_RECONFRQST:					/*	525	*/
		offset = dissect_id_HS_SCCH_FDD_Code_Information_PSCH_ReconfRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HS_PDSCH_TDD_INFORMATION_PSCH_RECONFRQST:						/*	526	*/
		offset = dissect_id_HS_PDSCH_TDD_Information_PSCH_ReconfRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_ADD_TO_HS_SCCH_RESOURCE_POOL_PSCH_RECONFRQST:					/*	527	*/
		offset = dissect_id_Add_To_HS_SCCH_Resource_Pool_PSCH_ReconfRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MODIFY_HS_SCCH_RESOURCE_POOL_PSCH_RECONFRQST:					/*	528	*/
		offset = dissect_id_Modify_HS_SCCH_Resource_Pool_PSCH_ReconfRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DELETE_FROM_HS_SCCH_RESOURCE_POOL_PSCH_RECONFRQST:				/*	529	*/
		offset = dissect_id_Delete_From_HS_SCCH_Resource_Pool_PSCH_ReconfRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_BINDINGID:														/*	102	*/
		offset = dissect_id_bindingID(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_SPECIFIC_DCH_INFO:											/*	103	*/
		offset = dissect_id_RL_Specific_DCH_Info(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TRANSPORTLAYERADDRESS: 											/*	104	*/
		offset = dissect_id_transportlayeraddress(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DELAYEDACTIVATION:												/*	231	*/
		offset = dissect_id_DelayedActivation(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DELAYEDACTIVATIONLIST_RL_ACTIVATIONCMDFDD:						/*	232	*/
		offset = dissect_id_DelayedActivationList_RL_ActivationCmdFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DELAYEDACTIVATIONINFORMATION_RL_ACTIVATIONCMDFDD:				/*	233	*/
		offset = dissect_id_DelayedActivationInformation_RL_ActivationCmdFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DELAYEDACTIVATIONLIST_RL_ACTIVATIONCMDTDD:						/*	234	*/
		offset = dissect_id_DelayedActivationList_RL_ActivationCmdTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DELAYEDACTIVATIONINFORMATION_RL_ACTIVATIONCMDTDD:				/*	235	*/
		offset = dissect_id_DelayedActivationInformation_RL_ActivationCmdTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_NEIGHBOURINGTDDCELLMEASUREMENTINFORMATIONLCR:					/*	58	*/
		offset = dissect_id_neighbouringTDDCellMeasurementInformationLCR(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SYNCDLCODEID_TRANSINITLCR_CELLSYNCINITIATIONRQSTTDD:			/*	543	*/
		offset = dissect_id_SYNCDlCodeId_TransInitLCR_CellSyncInitiationRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SYNCDLCODEID_MEASUREINITLCR_CELLSYNCINITIATIONRQSTTDD:			/*	544	*/
		offset = dissect_id_SYNCDlCodeId_MeasureInitLCR_CellSyncInitiationRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SYNCDLCODEIDTRANSRECONFINFOLCR_CELLSYNCRECONFRQSTTDD:			/*	545	*/
		offset = dissect_id_SYNCDlCodeIdTransReconfInfoLCR_CellSyncReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SYNCDLCODEIDMEASRECONFIGURATIONLCR_CELLSYNCRECONFRQSTTDD:		/*	546	*/
		offset = dissect_id_SYNCDlCodeIdMeasReconfigurationLCR_CellSyncReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SYNCDLCODEIDMEASINFOLIST_CELLSYNCRECONFRQSTTDD:					/*	547	*/
		offset = dissect_id_SYNCDlCodeIdMeasInfoList_CellSyncReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SYNCDLCODEIDSMEASINFOLIST_CELLSYNCREPRTTDD:						/*	548	*/
		offset = dissect_id_SyncDLCodeIdsMeasInfoList_CellSyncReprtTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SYNCDLCODEIDTHREINFOLCR:										/*	549	*/
		offset = dissect_id_SyncDLCodeIdThreInfoLCR(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_NSUBCYCLESPERCYCLEPERIOD_CELLSYNCRECONFRQSTTDD:					/*	550	*/
		offset = dissect_id_NSubCyclesPerCyclePeriod_CellSyncReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DWPCH_POWER:													/*	551	*/
		offset = dissect_id_DwPCH_Power(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_ACCUMULATEDCLOCKUPDATE_CELLSYNCREPRTTDD:						/*	552	*/
		offset = dissect_id_AccumulatedClockupdate_CellSyncReprtTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_ANGLE_OF_ARRIVAL_VALUE_LCR:										/*	521	*/
		offset = dissect_id_Angle_Of_Arrival_Value_LCR(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HSDSCH_FDD_INFORMATION:											/*	530	*/
		offset = dissect_id_HSDSCH_FDD_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HSDSCH_FDD_INFORMATION_RESPONSE:								/*	531	*/
		offset = dissect_id_HSDSCH_FDD_Information_Response(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HSDSCH_INFORMATION_TO_MODIFY:									/*	534	*/
		offset = dissect_id_HSDSCH_Information_to_Modify(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HSDSCH_RNTI:													/*	535	*/
		offset = dissect_id_HSDSCH_RNTI(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HSDSCH_TDD_INFORMATION:											/*	536	*/
		offset = dissect_id_HSDSCH_TDD_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HSDSCH_TDD_INFORMATION_RESPONSE:								/*	537	*/
		offset = dissect_id_HSDSCH_TDD_Information_Response(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HSPDSCH_RL_ID:													/*	541	*/
		offset = dissect_id_HSPDSCH_RL_ID(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PRIMCCPCH_RSCP_DL_PC_RQSTTDD:									/*	542	*/
		offset = dissect_id_PrimCCPCH_RSCP_DL_PC_RqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UNUSED_PROTOCOLIE_ID_64:										/*	64	*/
		break;
	case NBAP_IE_ID_PDSCH_RL_ID:													/*	66	*/
		offset = dissect_id_PDSCH_RL_ID(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HSDSCH_REARRANGELIST_BEARER_REARRANGEIND:						/*	553	*/
		offset = dissect_id_HSDSCH_RearrangeList_Bearer_RearrangeInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_SYNCHRONISATION_PARAMETERS_LCR:								/*	554	*/
		offset = dissect_id_UL_Synchronisation_Parameters_LCR(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HSDSCH_FDD_UPDATE_INFORMATION:									/*	555	*/
		offset = dissect_id_HSDSCH_FDD_Update_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HSDSCH_TDD_UPDATE_INFORMATION:									/*	556	*/
		offset = dissect_id_HSDSCH_TDD_Update_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DL_DPCH_TIMESLOTFORMAT_LCR_MODIFYITEM_RL_RECONFPREPTDD:			/*	558	*/
		offset = dissect_id_DL_DPCH_TimeSlotFormat_LCR_ModifyItem_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_DPCH_TIMESLOTFORMAT_LCR_MODIFYITEM_RL_RECONFPREPTDD:			/*	559	*/
		offset = dissect_id_UL_DPCH_TimeSlotFormat_LCR_ModifyItem_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TDD_TPC_UPLINKSTEPSIZE_LCR_RL_SETUPRQSTTDD:						/*	560	*/
		offset = dissect_id_TDD_TPC_UplinkStepSize_LCR_RL_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TDD_TPC_UPLINKSTEPSIZE_LCR_RL_ADDITIONRQSTTDD:					/*	561	*/
		offset = dissect_id_TDD_TPC_UplinkStepSize_LCR_RL_AdditionRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TDD_TPC_DOWNLINKSTEPSIZE_RL_ADDITIONRQSTTDD:					/*	562	*/
		offset = dissect_id_TDD_TPC_DownlinkStepSize_RL_AdditionRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TDD_TPC_UPLINKSTEPSIZE_INFORMATIONADD_LCR_RL_RECONFPREPTDD:		/*	563	*/
		offset = dissect_id_TDD_TPC_UplinkStepSize_InformationAdd_LCR_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TDD_TPC_UPLINKSTEPSIZE_INFORMATIONMODIFY_LCR_RL_RECONFPREPTDD:	/*	564	*/
		offset = dissect_id_TDD_TPC_UplinkStepSize_InformationModify_LCR_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TDD_TPC_DOWNLINKSTEPSIZE_INFORMATIONMODIFY_RL_RECONFPREPTDD:	/*	565	*/
		offset = dissect_id_TDD_TPC_DownlinkStepSize_InformationModify_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TDD_TPC_DOWNLINKSTEPSIZE_INFORMATIONADD_RL_RECONFPREPTDD:		/*	566	*/
		offset = dissect_id_TDD_TPC_DownlinkStepSize_InformationAdd_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CCTRCH_MAXIMUM_DL_POWER_RL_SETUPRQSTTDD:						/*	567	*/
		offset = dissect_id_CCTrCH_Maximum_DL_Power_RL_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CCTRCH_MINIMUM_DL_POWER_RL_SETUPRQSTTDD:						/*	568	*/
		offset = dissect_id_CCTrCH_Minimum_DL_Power_RL_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CCTRCH_MAXIMUM_DL_POWER_RL_ADDITIONRQSTTDD:						/*	569	*/
		offset = dissect_id_CCTrCH_Maximum_DL_Power_RL_AdditionRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CCTRCH_MINIMUM_DL_POWER_RL_ADDITIONRQSTTDD:						/*	570	*/
		offset = dissect_id_CCTrCH_Minimum_DL_Power_RL_AdditionRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CCTRCH_MAXIMUM_DL_POWER_INFORMATIONADD_RL_RECONFPREPTDD:		/*	571	*/
		offset = dissect_id_CCTrCH_Maximum_DL_Power_InformationAdd_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CCTRCH_MINIMUM_DL_POWER_INFORMATIONADD_RL_RECONFPREPTDD:		/*	572	*/
		offset = dissect_id_CCTrCH_Minimum_DL_Power_InformationAdd_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CCTRCH_MAXIMUM_DL_POWER_INFORMATIONMODIFY_RL_RECONFPREPTDD:		/*	573	*/
		offset = dissect_id_CCTrCH_Maximum_DL_Power_InformationModify_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CCTRCH_MINIMUM_DL_POWER_INFORMATIONMODIFY_RL_RECONFPREPTDD:		/*	574	*/
		offset = dissect_id_CCTrCH_Minimum_DL_Power_InformationModify_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MAXIMUM_DL_POWER_MODIFY_LCR_INFORMATIONMODIFY_RL_RECONFPREPTDD:	/*	575	*/
		offset = dissect_id_Maximum_DL_Power_Modify_LCR_InformationModify_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MINIMUM_DL_POWER_MODIFY_LCR_INFORMATIONMODIFY_RL_RECONFPREPTDD:	/*	576	*/
		offset = dissect_id_Minimum_DL_Power_Modify_LCR_InformationModify_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DL_DPCH_LCR_INFORMATIONMODIFY_MODIFYLIST_RL_RECONFRQSTTDD:		/*	577	*/
		offset = dissect_id_DL_DPCH_LCR_InformationModify_ModifyList_RL_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CCTRCH_MAXIMUM_DL_POWER_INFORMATIONMODIFY_RL_RECONFRQSTTDD:		/*	578	*/
		offset = dissect_id_CCTrCH_Maximum_DL_Power_InformationModify_RL_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CCTRCH_MINIMUM_DL_POWER_INFORMATIONMODIFY_RL_RECONFRQSTTDD:		/*	579	*/
		offset = dissect_id_CCTrCH_Minimum_DL_Power_InformationModify_RL_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_INITIAL_DL_POWER_TIMESLOTLCR_INFORMATIONITEM:					/*	580	*/
		offset = dissect_id_Initial_DL_Power_TimeslotLCR_InformationItem(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MAXIMUM_DL_POWER_TIMESLOTLCR_INFORMATIONITEM:					/*	581	*/
		offset = dissect_id_Maximum_DL_Power_TimeslotLCR_InformationItem(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MINIMUM_DL_POWER_TIMESLOTLCR_INFORMATIONITEM:					/*	582	*/
		offset = dissect_id_Minimum_DL_Power_TimeslotLCR_InformationItem(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HS_DSCHPROVIDEDBITRATEVALUEINFORMATION:							/*	583	*/
		offset = dissect_id_HS_DSCHProvidedBitRateValueInformation(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HS_DSCHREQUIREDPOWERVALUEINFORMATION:							/*	585	*/
		offset = dissect_id_HS_DSCHRequiredPowerValueInformation(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HS_DSCHREQUIREDPOWERVALUE:										/*	586	*/
		offset = dissect_id_HS_DSCHRequiredPowerValue(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TRANSMITTEDCARRIERPOWEROFALLCODESNOTUSEDFORHSTRANSMISSION:		/*	587	*/
		offset = dissect_id_TransmittedCarrierPowerOfAllCodesNotUsedForHSTransmission(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HS_SICH_RECEPTION_QUALITY: 										/*	588	*/
		offset = dissect_id_HS_SICH_Reception_Quality(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HS_SICH_RECEPTION_QUALITY_MEASUREMENT_VALUE: 					/*	589	*/
		offset = dissect_id_HS_SICH_Reception_Quality_Measurement_Value(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HSSICH_INFO_DM_RPRT: 											/*	590	*/
		offset = dissect_id_HSSICH_Info_DM_Rprt(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HSSICH_INFO_DM_RQST:											/*	591	*/
		offset = dissect_id_HSSICH_Info_DM_Rqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HSSICH_INFO_DM_RSP:												/*	592	*/
		offset = dissect_id_HSSICH_Info_DM_Rsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_BEST_CELL_PORTIONS_VALUE:										/*	593	*/
		offset = dissect_id_Best_Cell_Portions_Value(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PRIMARY_CPICH_USAGE_FOR_CHANNEL_ESTIMATION:						/*	594	*/
		offset = dissect_id_Primary_CPICH_Usage_for_Channel_Estimation(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SECONDARY_CPICH_INFORMATION_CHANGE:								/*	595	*/
		offset = dissect_id_Secondary_CPICH_Information_Change(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_NUMBEROFREPORTEDCELLPORTIONS:									/*	596	*/
		offset = dissect_id_NumberOfReportedCellPortions(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CELLPORTION_INFORMATIONITEM_CELL_SETUPRQSTFDD:					/*	597	*/
		offset = dissect_id_CellPortion_InformationItem_Cell_SetupRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CELLPORTION_INFORMATIONLIST_CELL_SETUPRQSTFDD:					/*	598	*/
		offset = dissect_id_CellPortion_InformationList_Cell_SetupRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TIMESLOTISCP_LCR_INFOLIST_RL_RECONFPREPTDD:						/*	599	*/
		offset = dissect_id_TimeslotISCP_LCR_InfoList_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SECONDARY_CPICH_INFORMATION:									/*	600	*/
		offset = dissect_id_Secondary_CPICH_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RECEIVED_TOTAL_WIDE_BAND_POWER_FOR_CELLPORTION:					/*	601	*/
		offset = dissect_id_Received_total_wide_band_power_For_CellPortion(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UNIDIRECTIONAL_DCH_INDICATOR:									/*	602	*/
		offset = dissect_id_Unidirectional_DCH_Indicator(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TIMINGADJUSTMENTVALUELCR:										/*	603	*/
		offset = dissect_id_TimingAdjustmentValueLCR(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MULTIPLERL_DL_DPCH_INFORMATIONLIST:								/*	604	*/
		break;
	case NBAP_IE_ID_MULTIPLERL_DL_DPCH_INFORMATIONMODIFYLIST:						/*	605	*/
		break;
	case NBAP_IE_ID_MULTIPLERL_UL_DPCH_INFORMATIONLIST:								/*	606	*/
		offset = dissect_id_multipleRL_ul_DPCH_InformationList(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MULTIPLERL_UL_DPCH_INFORMATIONMODIFYLIST:						/*	607	*/
		offset = dissect_id_multipleRL_ul_DPCH_InformationModifyList(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_ID:															/*	608	*/
		offset = dissect_id_RL_ID(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SAT_INFO_ALMANAC_EXTITEM:										/*	609	*/
		offset = dissect_id_SAT_Info_Almanac_ExtItem(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HSDPA_CAPABILITY:												/*	610	*/
		offset = dissect_id_HSDPA_Capability(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HSDSCH_RESOURCES_INFORMATION_AUDITRSP:							/*	611	*/
		offset = dissect_id_HSDSCH_Resources_Information_AuditRsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HSDSCH_RESOURCES_INFORMATION_RESOURCESTATUSIND:					/*	612	*/
		offset = dissect_id_HSDSCH_Resources_Information_ResourceStatusInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HSDSCH_MACDFLOWS_TO_ADD:										/*	613	*/
		offset = dissect_id_HSDSCH_MACdFlows_to_Add(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HSDSCH_MACDFLOWS_TO_DELETE:										/*	614	*/
		offset = dissect_id_HSDSCH_MACdFlows_to_Delete(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HSDSCH_INFORMATION_TO_MODIFY_UNSYNCHRONISED:					/*	615	*/
		offset = dissect_id_HSDSCH_Information_to_Modify_Unsynchronised(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TNLQOS:															/*	616	*/
		offset = dissect_id_TnlQos(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RECEIVED_TOTAL_WIDE_BAND_POWER_FOR_CELLPORTION_VALUE:			/*	617	*/
		offset = dissect_id_Received_total_wide_band_power_For_CellPortion_Value(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TRANSMITTED_CARRIER_POWER_FOR_CELLPORTION:						/*	618	*/
		offset = dissect_id_Transmitted_Carrier_Power_For_CellPortion(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TRANSMITTED_CARRIER_POWER_FOR_CELLPORTION_VALUE :				/*	619	*/
		offset = dissect_id_Transmitted_Carrier_Power_For_CellPortion_Value(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TRANSMITTEDCARRIERPOWEROFALLCODESNOTUSEDFORHS_PDSCH_HS_SCCH_E_AGCH_E_RGCHORE_HICHTRANSMISSIONCELLPORTION:		/*620*/
		offset = dissect_id_TransmittedCarrierPowerOfAllCodesNotUsedForHS_PDSCH_HS_SCCH_E_AGCH_E_RGCHOrE_HICHTransmissionCellPortion(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TRANSMITTEDCARRIERPOWEROFALLCODESNOTUSEDFORHS_PDSCH_HS_SCCH_E_AGCH_E_RGCHORE_HICHTRANSMISSIONCELLPORTIONVALUE:	/*621*/
		offset = dissect_id_TransmittedCarrierPowerOfAllCodesNotUsedForHS_PDSCH_HS_SCCH_E_AGCH_E_RGCHOrE_HICHTransmissionCellPortionValue(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UPPTSINTERFERENCEVALUE:											/*	622	*/
		offset = dissect_id_UpPTSInterferenceValue(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_PRIMARYCCPCH_RSCP_DELTA:										/*	623	*/
		offset = dissect_id_PrimaryCCPCH_RSCP_Delta(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MEASUREMENTRECOVERYBEHAVIOR:									/*	624	*/
		offset = dissect_id_MeasurementRecoveryBehavior(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MEASUREMENTRECOVERYREPORTINGINDICATOR:							/*	625	*/
		offset = dissect_id_MeasurementRecoveryReportingIndicator(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MEASUREMENTRECOVERYSUPPORTINDICATOR:							/*	626	*/
		offset = dissect_id_MeasurementRecoverySupportIndicator(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TSTD_INDICATOR:													/*	627	*/
		offset = dissect_id_Tstd_indicator(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MULTIPLE_RL_INFORMATION_RL_RECONFPREPTDD:						/*	628	*/
		offset = dissect_id_multiple_RL_Information_RL_ReconfPrepTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MULTIPLE_RL_INFORMATION_RL_RECONFRQSTTDD:						/*	629	*/
		offset = dissect_id_multiple_RL_Information_RL_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DL_DPCH_POWER_INFORMATION_RL_RECONFPREPFDD:						/*	630	*/
		offset = dissect_id_DL_DPCH_Power_Information_RL_ReconfPrepFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_F_DPCH_INFORMATION_RL_RECONFPREPFDD:							/*	631	*/
		offset = dissect_id_F_DPCH_Information_RL_ReconfPrepFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_F_DPCH_INFORMATION_RL_SETUPRQSTFDD:								/*	632	*/
		offset = dissect_id_F_DPCH_Information_RL_SetupRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_ADDITIONAL_S_CCPCH_PARAMETERS_CTCH_RECONFRQSTTDD:				/*	633	*/
		offset = dissect_id_Additional_S_CCPCH_Parameters_CTCH_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_ADDITIONAL_S_CCPCH_PARAMETERS_CTCH_SETUPRQSTTDD:				/*	634	*/
		offset = dissect_id_Additional_S_CCPCH_Parameters_CTCH_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_ADDITIONAL_S_CCPCH_LCR_PARAMETERS_CTCH_RECONFRQSTTDD:			/*	635	*/
		offset = dissect_id_Additional_S_CCPCH_LCR_Parameters_CTCH_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_ADDITIONAL_S_CCPCH_LCR_PARAMETERS_CTCH_SETUPRQSTTDD:			/*	636	*/
		offset = dissect_id_Additional_S_CCPCH_LCR_Parameters_CTCH_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MICH_CFN:														/*	637	*/
		offset = dissect_id_MICH_CFN(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MICH_INFORMATION_AUDITRSP:										/*	638	*/
		offset = dissect_id_MICH_Information_AuditRsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MICH_INFORMATION_RESOURCESTATUSIND:								/*	639	*/
		offset = dissect_id_MICH_Information_ResourceStatusInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MICH_PARAMETERS_CTCH_RECONFRQSTFDD:								/*	640	*/
		offset = dissect_id_MICH_Parameters_CTCH_ReconfRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MICH_PARAMETERS_CTCH_RECONFRQSTTDD:								/*	641	*/
		offset = dissect_id_MICH_Parameters_CTCH_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MICH_PARAMETERS_CTCH_SETUPRQSTFDD:								/*	642	*/
		offset = dissect_id_MICH_Parameters_CTCH_SetupRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MICH_PARAMETERS_CTCH_SETUPRQSTTDD:								/*	643	*/
		offset = dissect_id_MICH_Parameters_CTCH_SetupRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MODIFICATION_PERIOD:											/*	644	*/
		offset = dissect_id_Modification_Period(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_NI_INFORMATION_NOTIFUPDATECMD:									/*	645	*/
		offset = dissect_id_NI_Information_NotifUpdateCmd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_S_CCPCH_INFORMATIONLISTEXT_AUDITRSP:							/*	646	*/
		offset = dissect_id_S_CCPCH_InformationListExt_AuditRsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_S_CCPCH_INFORMATIONLISTEXT_RESOURCESTATUSIND:					/*	647	*/
		offset = dissect_id_S_CCPCH_InformationListExt_ResourceStatusInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_S_CCPCH_LCR_INFORMATIONLISTEXT_AUDITRSP:						/*	648	*/
		offset = dissect_id_S_CCPCH_LCR_InformationListExt_AuditRsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_S_CCPCH_LCR_INFORMATIONLISTEXT_RESOURCESTATUSIND:				/*	649	*/
		offset = dissect_id_S_CCPCH_LCR_InformationListExt_ResourceStatusInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HARQ_PREAMBLE_MODE:												/*	650	*/
		offset = dissect_id_HARQ_Preamble_Mode(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_INITIAL_DL_DPCH_TIMINGADJUSTMENT:								/*	651	*/
		offset = dissect_id_Initial_DL_DPCH_TimingAdjustment(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_INITIAL_DL_DPCH_TIMINGADJUSTMENT_ALLOWED:						/*	652	*/
		offset = dissect_id_Initial_DL_DPCH_TimingAdjustment_Allowed(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_DLTRANSMISSIONBRANCHLOADVALUE:									/*	653	*/
		offset = dissect_id_DLTransmissionBranchLoadValue(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_POWER_LOCAL_CELL_GROUP_CHOICE_CM_RQST:							/*	654	*/
		offset = dissect_id_Power_Local_Cell_Group_choice_CM_Rqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_POWER_LOCAL_CELL_GROUP_CHOICE_CM_RSP:							/*	655	*/
		offset = dissect_id_Power_Local_Cell_Group_choice_CM_Rsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_POWER_LOCAL_CELL_GROUP_CHOICE_CM_RPRT:							/*	656	*/
		offset = dissect_id_Power_Local_Cell_Group_choice_CM_Rprt(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SYNCHRONISATIONINDICATOR:										/*	657	*/
		offset = dissect_id_SynchronisationIndicator(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HSDPA_AND_EDCH_CELLPORTION_INFORMATION_PSCH_RECONFRQST:			/*	658	*/
		offset = dissect_id_HSDPA_And_EDCH_CellPortion_Information_PSCH_ReconfRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HSDPA_AND_EDCH_CELLPORTION_INFORMATIONLIST_PSCH_RECONFRQST:		/*	659	*/
		offset = dissect_id_HSDPA_And_EDCH_CellPortion_InformationList_PSCH_ReconfRqst(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HS_DSCHREQUIREDPOWERVALUE_FOR_CELL_PORTION:						/*	660	*/
		offset = dissect_id_HS_DSCHRequiredPowerValue_For_Cell_Portion(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HS_DSCHREQUIREDPOWERVALUEINFORMATION_FOR_CELLPORTION:			/*	661	*/
		offset = dissect_id_HS_DSCHRequiredPowerValueInformation_For_CellPortion(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HS_DSCHPROVIDEDBITRATEVALUEINFORMATION_FOR_CELLPORTION:			/*	662	*/
		offset = dissect_id_HS_DSCHProvidedBitRateValueInformation_For_CellPortion(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_E_AGCH_AND_E_RGCH_E_HICH_FDD_SCRAMBLING_CODE:					/*	663	*/
		offset = dissect_id_E_AGCH_And_E_RGCH_E_HICH_FDD_Scrambling_Code(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_E_AGCH_FDD_CODE_INFORMATION:									/*	664	*/
		offset = dissect_id_E_AGCH_FDD_Code_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_E_DCH_CAPABILITY:												/*	665	*/
		offset = dissect_id_E_DCH_Capability(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_E_DCH_FDD_DL_CONTROL_CHANNEL_INFORMATION:						/*	666	*/
		offset = dissect_id_E_DCH_FDD_DL_Control_Channel_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_E_DCH_FDD_INFORMATION:											/*	667	*/
		offset = dissect_id_E_DCH_FDD_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_E_DCH_FDD_INFORMATION_RESPONSE:									/*	668	*/
		offset = dissect_id_E_DCH_FDD_Information_Response(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_E_DCH_FDD_INFORMATION_TO_MODIFY:								/*	669	*/
		offset = dissect_id_E_DCH_FDD_Information_to_Modify(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_E_DCH_MACDFLOWS_TO_ADD:											/*	670	*/
		offset = dissect_id_E_DCH_MACdFlows_to_Add(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_E_DCH_MACDFLOWS_TO_DELETE:										/*	671	*/
		offset = dissect_id_E_DCH_MACdFlows_to_Delete(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_E_DCH_RESOURCES_INFORMATION_AUDITRSP:							/*	672	*/
		offset = dissect_id_E_DCH_Resources_Information_AuditRsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_E_DCH_RESOURCES_INFORMATION_RESOURCESTATUSIND:					/*	673	*/
		offset = dissect_id_E_DCH_Resources_Information_ResourceStatusInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_E_DCH_RL_INDICATION:											/*	674	*/
		offset = dissect_id_E_DCH_RL_Indication(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_E_DCH_RL_SET_ID:												/*	675	*/
		offset = dissect_id_E_DCH_RL_Set_ID(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_E_DPCH_INFORMATION_RL_RECONFPREPFDD:							/*	676	*/
		offset = dissect_id_E_DPCH_Information_RL_ReconfPrepFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_E_DPCH_INFORMATION_RL_SETUPRQSTFDD:								/*	677	*/
		offset = dissect_id_E_DPCH_Information_RL_SetupRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_E_RGCH_E_HICH_FDD_CODE_INFORMATION:								/*	678	*/
		offset = dissect_id_E_RGCH_E_HICH_FDD_Code_Information(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_SERVING_E_DCH_RL_ID:											/*	679	*/
		offset = dissect_id_Serving_E_DCH_RL_ID(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_UL_DPDCH_INDICATOR_FOR_E_DCH_OPERATION:							/*	680	*/
		offset = dissect_id_UL_DPDCH_Indicator_For_E_DCH_Operation(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_FDD_S_CCPCH_FRAMEOFFSET_CTCH_SETUPRQSTFDD:						/*	681	*/
		offset = dissect_id_FDD_S_CCPCH_FrameOffset_CTCH_SetupRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_E_DPCH_INFORMATION_RL_RECONFRQSTFDD:							/*	682	*/
		offset = dissect_id_E_DPCH_Information_RL_ReconfRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MAXIMUM_TARGET_RECEIVEDTOTALWIDEBANDPOWER:						/*	683	*/
		offset = dissect_id_Maximum_Target_ReceivedTotalWideBandPower(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_E_DCHPROVIDEDBITRATEVALUEINFORMATION:							/*	684	*/
		offset = dissect_id_E_DCHProvidedBitRateValueInformation(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HARQ_PREAMBLE_MODE_ACTIVATION_INDICATOR:						/*	685	*/
		offset = dissect_id_HARQ_Preamble_Mode_Activation_Indicator(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_RL_SPECIFIC_E_DCH_INFO:											/*	686	*/
		offset = dissect_id_RL_Specific_E_DCH_Info(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_E_DCH_CAPACITYCONSUMPTIONLAW:									/*	687	*/
		offset = dissect_id_E_DCH_CapacityConsumptionLaw(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MULTIPLE_DEDICATEDMEASUREMENTVALUELIST_TDD_DM_RSP:				/*	688	*/
		offset = dissect_id_multiple_DedicatedMeasurementValueList_TDD_DM_Rsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MULTIPLE_DEDICATEDMEASUREMENTVALUELIST_LCR_TDD_DM_RSP:			/*	689	*/
		offset = dissect_id_multiple_DedicatedMeasurementValueList_LCR_TDD_DM_Rsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_E_DCH_REARRANGELIST_BEARER_REARRANGEIND:						/*	690	*/
		offset = dissect_id_E_DCH_RearrangeList_Bearer_RearrangeInd(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_HSDPA_AND_EDCH_CELLPORTION_INFORMATIONLISTIE_PSCH_RECONFRQST:	/*	691	*/
		break;
	case NBAP_IE_ID_MULTIPLERL_DL_CCTRCH_INFORMATIONMODIFYLIST_RL_RECONFRQSTTDD:	/*	692	*/
		offset = dissect_id_multipleRL_dl_CCTrCH_InformationModifyList_RL_ReconfRqstTDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_TARGET_NONSERVING_EDCH_TO_TOTAL_EDCH_POWER_RATIO:				/*	693	*/
		offset = dissect_id_Target_NonServing_EDCH_To_Total_EDCH_Power_Ratio(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CELLPORTION_INFORMATIONITEM_CELL_RECONFRQSTFDD:					/*	694	*/
		offset = dissect_id_CellPortion_InformationItem_Cell_ReconfRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_CELLPORTION_INFORMATIONLIST_CELL_RECONFRQSTFDD:					/*	695	*/
		offset = dissect_id_CellPortion_InformationList_Cell_ReconfRqstFDD(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MULTIPLE_PUSCH_INFOLIST_DM_RSP:									/*	696	*/
		offset = dissect_id_multiple_PUSCH_InfoList_DM_Rsp(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_MULTIPLE_PUSCH_INFOLIST_DM_RPRT:								/*	697	*/
		offset = dissect_id_multiple_PUSCH_InfoList_DM_Rprt(tvb, offset, actx, value_tree);
		break;
	case NBAP_IE_ID_REFERENCE_RECEIVEDTOTALWIDEBANDPOWER:							/*	698	*/
		offset = dissect_id_Reference_ReceivedTotalWideBandPower(tvb, offset, actx, value_tree);
		break;
	default:
		offset = offset + length;
		break;
	}
	BYTE_ALIGN_OFFSET(offset);	
	return offset;
}
static void
dissect_nbap(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree)
{
	proto_item	*nbap_item = NULL;
	proto_tree	*nbap_tree = NULL;

	top_tree = tree;

	/* make entry in the Protocol column on summary display */
	if (check_col(pinfo->cinfo, COL_PROTOCOL))
		col_set_str(pinfo->cinfo, COL_PROTOCOL, "NBAP");

    /* create the nbap protocol tree */
    nbap_item = proto_tree_add_item(tree, proto_nbap, tvb, 0, -1, FALSE);
    nbap_tree = proto_item_add_subtree(nbap_item, ett_nbap);

	dissect_NBAP_PDU_PDU(tvb, pinfo, nbap_tree);
}
/*--- proto_register_nbap -------------------------------------------*/
void proto_register_nbap(void) {

  /* List of fields */

  static hf_register_info hf[] = {
	{ &hf_nbap_pdu_length,
		{ "PDU Length", "nbap.pdu_length", FT_UINT32, BASE_DEC,
		NULL, 0, "Number of octets in the PDU", HFILL }},
	{ &hf_nbap_IE_length,
		{ "IE Length", "nbap.ie_length", FT_UINT32, BASE_DEC,
		NULL, 0, "Number of octets in the IE", HFILL }},
#include "packet-nbap-hfarr.c"
  };

  /* List of subtrees */
  static gint *ett[] = {
		  &ett_nbap,
		  &ett_nbap_initiatingMessageValue,
		  &ett_nbap_ProtocolIEValueValue,
		  &ett_nbap_SuccessfulOutcomeValue,
		  &ett_nbap_UnsuccessfulOutcomeValue,
#include "packet-nbap-ettarr.c"
  };


  /* Register protocol */
  proto_nbap = proto_register_protocol(PNAME, PSNAME, PFNAME);
  /* Register fields and subtrees */
  proto_register_field_array(proto_nbap, hf, array_length(hf));
  proto_register_subtree_array(ett, array_length(ett));

 
  register_dissector("nbap", dissect_nbap, proto_nbap);


}


/*--- proto_reg_handoff_nbap ---------------------------------------*/
void
proto_reg_handoff_nbap(void)
{

	nbap_handle = find_dissector("nbap");
	/*dissector_add("sctp.ppi",  Add ppid here, nbap_handle); */
	dissector_add("sctp.port", 0, nbap_handle);

}


