/* Do not modify this file. Changes will be overwritten.                      */
/* Generated automatically by the ASN.1 to Wireshark dissector compiler       */
/* packet-nr-rrc.c                                                            */
/* asn2wrs.py -L -p nr-rrc -c ./nr-rrc.cnf -s ./packet-nr-rrc-template -D . -O ../.. NR-InterNodeDefinitions.asn NR-RRC-Definitions.asn NR-Sidelink-Preconf.asn NR-UE-Variables.asn PC5-RRC-Definitions.asn */

/* Input file: packet-nr-rrc-template.c */

#line 1 "./asn1/nr-rrc/packet-nr-rrc-template.c"
/* packet-nr-rrc-template.c
 * NR;
 * Radio Resource Control (RRC) protocol specification
 * (3GPP TS 38.331 V16.8.0 Release 16) packet dissection
 * Copyright 2018-2022, Pascal Quantin
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "config.h"

#include <stdlib.h>

#include <epan/packet.h>
#include <epan/asn1.h>
#include <epan/expert.h>
#include <epan/reassemble.h>
#include <epan/exceptions.h>
#include <epan/show_exception.h>
#include <epan/proto_data.h>
#include <epan/prefs.h>

#include <wsutil/str_util.h>
#include <wsutil/epochs.h>

#include "packet-per.h"
#include "packet-gsm_map.h"
#include "packet-cell_broadcast.h"
#include "packet-mac-nr.h"
#include "packet-rlc-nr.h"
#include "packet-pdcp-nr.h"
#include "packet-rrc.h"
#include "packet-lte-rrc.h"
#include "packet-nr-rrc.h"
#include "packet-gsm_a_common.h"
#include "packet-lpp.h"

#define PNAME  "NR Radio Resource Control (RRC) protocol"
#define PSNAME "NR RRC"
#define PFNAME "nr-rrc"

void proto_register_nr_rrc(void);
void proto_reg_handoff_nr_rrc(void);

static dissector_handle_t nas_5gs_handle = NULL;
static dissector_handle_t lte_rrc_conn_reconf_handle = NULL;
static dissector_handle_t lte_rrc_conn_reconf_compl_handle = NULL;
static dissector_handle_t lte_rrc_ul_dcch_handle = NULL;
static dissector_handle_t lte_rrc_dl_dcch_handle = NULL;

static wmem_map_t *nr_rrc_etws_cmas_dcs_hash = NULL;

static reassembly_table nr_rrc_sib7_reassembly_table;
static reassembly_table nr_rrc_sib8_reassembly_table;

static gboolean nr_rrc_nas_in_root_tree;

extern int proto_mac_nr;
extern int proto_pdcp_nr;

/* Include constants */

/*--- Included file: packet-nr-rrc-val.h ---*/
#line 1 "./asn1/nr-rrc/packet-nr-rrc-val.h"
#define maxMeasFreqsMN                 32
#define maxMeasFreqsSN                 32
#define maxMeasIdentitiesMN            62
#define maxCellPrep                    32
#define maxAI_DCI_PayloadSize_r16      128
#define maxAI_DCI_PayloadSize_1_r16    127
#define maxBandComb                    65536
#define maxBandsUTRA_FDD_r16           64
#define maxBH_RLC_ChannelID_r16        65536
#define maxBT_IdReport_r16             32
#define maxBT_Name_r16                 4
#define maxCAG_Cell_r16                16
#define maxTwoPUCCH_Grp_ConfigList_r16 32
#define maxCBR_Config_r16              8
#define maxCBR_Config_1_r16            7
#define maxCBR_Level_r16               16
#define maxCBR_Level_1_r16             15
#define maxCellBlack                   16
#define maxCellGroupings_r16           32
#define maxCellHistory_r16             16
#define maxCellInter                   16
#define maxCellIntra                   16
#define maxCellMeasEUTRA               32
#define maxCellMeasIdle_r16            8
#define maxCellMeasUTRA_FDD_r16        32
#define maxCellWhite                   16
#define maxEARFCN                      262143
#define maxEUTRA_CellBlack             16
#define maxEUTRA_NS_Pmax               8
#define maxLogMeasReport_r16           520
#define maxMultiBands                  8
#define maxNARFCN                      3279165
#define maxNR_NS_Pmax                  8
#define maxFreqIdle_r16                8
#define maxNrofServingCells            32
#define maxNrofServingCells_1          31
#define maxNrofAggregatedCellsPerCellGroup 16
#define maxNrofAggregatedCellsPerCellGroupMinus4_r16 12
#define maxNrofDUCells_r16             512
#define maxNrofAvailabilityCombinationsPerSet_r16 512
#define maxNrofAvailabilityCombinationsPerSet_1_r16 511
#define maxNrofSCells                  31
#define maxNrofCellMeas                32
#define maxNrofCG_SL_r16               8
#define maxNrofCG_SL_1_r16             7
#define maxNrofSS_BlocksToAverage      16
#define maxNrofCondCells_r16           8
#define maxNrofCSI_RS_ResourcesToAverage 16
#define maxNrofDL_Allocations          16
#define maxNrofSR_ConfigPerCellGroup   8
#define maxLCG_ID                      7
#define maxLC_ID                       32
#define maxLC_ID_Iab_r16               65855
#define maxLTE_CRS_Patterns_r16        3
#define maxNrofTAGs                    4
#define maxNrofTAGs_1                  3
#define maxNrofBWPs                    4
#define maxNrofCombIDC                 128
#define maxNrofSymbols_1               13
#define maxNrofSlots                   320
#define maxNrofSlots_1                 319
#define maxNrofPhysicalResourceBlocks  275
#define maxNrofPhysicalResourceBlocks_1 274
#define maxNrofPhysicalResourceBlocksPlus1 276
#define maxNrofControlResourceSets     12
#define maxNrofControlResourceSets_1   11
#define maxNrofControlResourceSets_1_r16 15
#define maxNrofCoresetPools_r16        2
#define maxCoReSetDuration             3
#define maxNrofSearchSpaces_1          39
#define maxSFI_DCI_PayloadSize         128
#define maxSFI_DCI_PayloadSize_1       127
#define maxIAB_IP_Address_r16          32
#define maxINT_DCI_PayloadSize         126
#define maxINT_DCI_PayloadSize_1       125
#define maxNrofRateMatchPatterns       4
#define maxNrofRateMatchPatterns_1     3
#define maxNrofRateMatchPatternsPerGroup 8
#define maxNrofCSI_ReportConfigurations 48
#define maxNrofCSI_ReportConfigurations_1 47
#define maxNrofCSI_ResourceConfigurations 112
#define maxNrofCSI_ResourceConfigurations_1 111
#define maxNrofAP_CSI_RS_ResourcesPerSet 16
#define maxNrOfCSI_AperiodicTriggers   128
#define maxNrofReportConfigPerAperiodicTrigger 16
#define maxNrofNZP_CSI_RS_Resources    192
#define maxNrofNZP_CSI_RS_Resources_1  191
#define maxNrofNZP_CSI_RS_ResourcesPerSet 64
#define maxNrofNZP_CSI_RS_ResourceSets 64
#define maxNrofNZP_CSI_RS_ResourceSets_1 63
#define maxNrofNZP_CSI_RS_ResourceSetsPerConfig 16
#define maxNrofNZP_CSI_RS_ResourcesPerConfig 128
#define maxNrofZP_CSI_RS_Resources     32
#define maxNrofZP_CSI_RS_Resources_1   31
#define maxNrofZP_CSI_RS_ResourceSets_1 15
#define maxNrofZP_CSI_RS_ResourcesPerSet 16
#define maxNrofZP_CSI_RS_ResourceSets  16
#define maxNrofCSI_IM_Resources        32
#define maxNrofCSI_IM_Resources_1      31
#define maxNrofCSI_IM_ResourcesPerSet  8
#define maxNrofCSI_IM_ResourceSets     64
#define maxNrofCSI_IM_ResourceSets_1   63
#define maxNrofCSI_IM_ResourceSetsPerConfig 16
#define maxNrofCSI_SSB_ResourcePerSet  64
#define maxNrofCSI_SSB_ResourceSets    64
#define maxNrofCSI_SSB_ResourceSets_1  63
#define maxNrofCSI_SSB_ResourceSetsPerConfig 1
#define maxNrofFailureDetectionResources 10
#define maxNrofFailureDetectionResources_1 9
#define maxNrofFreqSL_r16              8
#define maxNrofSL_BWPs_r16             4
#define maxFreqSL_EUTRA_r16            8
#define maxNrofSL_MeasId_r16           64
#define maxNrofSL_ObjectId_r16         64
#define maxNrofSL_ReportConfigId_r16   64
#define maxNrofSL_PoolToMeasureNR_r16  8
#define maxFreqSL_NR_r16               8
#define maxNrofSL_QFIs_r16             2048
#define maxNrofSL_QFIsPerDest_r16      64
#define maxNrofObjectId                64
#define maxNrofPageRec                 32
#define maxNrofPCI_Ranges              8
#define maxPLMN                        12
#define maxNrofCSI_RS_ResourcesRRM     96
#define maxNrofCSI_RS_ResourcesRRM_1   95
#define maxNrofMeasId                  64
#define maxNrofQuantityConfig          2
#define maxNrofCSI_RS_CellsRRM         96
#define maxNrofSL_Dest_r16             32
#define maxNrofSL_Dest_1_r16           31
#define maxNrofSLRB_r16                512
#define maxSL_LCID_r16                 512
#define maxSL_SyncConfig_r16           16
#define maxNrofRXPool_r16              16
#define maxNrofTXPool_r16              8
#define maxNrofPoolID_r16              16
#define maxNrofSRS_PathlossReferenceRS_r16 64
#define maxNrofSRS_PathlossReferenceRS_1_r16 63
#define maxNrofSRS_ResourceSets        16
#define maxNrofSRS_ResourceSets_1      15
#define maxNrofSRS_PosResourceSets_r16 16
#define maxNrofSRS_PosResourceSets_1_r16 15
#define maxNrofSRS_Resources           64
#define maxNrofSRS_Resources_1         63
#define maxNrofSRS_PosResources_r16    64
#define maxNrofSRS_PosResources_1_r16  63
#define maxNrofSRS_ResourcesPerSet     16
#define maxNrofSRS_TriggerStates_1     3
#define maxNrofSRS_TriggerStates_2     2
#define maxRAT_CapabilityContainers    8
#define maxSimultaneousBands           32
#define maxULTxSwitchingBandPairs      32
#define maxNrofSlotFormatCombinationsPerSet 512
#define maxNrofSlotFormatCombinationsPerSet_1 511
#define maxNrofTrafficPattern_r16      8
#define maxNrofPUCCH_Resources         128
#define maxNrofPUCCH_Resources_1       127
#define maxNrofPUCCH_ResourceSets      4
#define maxNrofPUCCH_ResourceSets_1    3
#define maxNrofPUCCH_ResourcesPerSet   32
#define maxNrofPUCCH_P0_PerSet         8
#define maxNrofPUCCH_PathlossReferenceRSs 4
#define maxNrofPUCCH_PathlossReferenceRSs_1 3
#define maxNrofPUCCH_PathlossReferenceRSs_r16 64
#define maxNrofPUCCH_PathlossReferenceRSs_1_r16 63
#define maxNrofPUCCH_PathlossReferenceRSsDiff_r16 60
#define maxNrofPUCCH_ResourceGroups_r16 4
#define maxNrofPUCCH_ResourcesPerGroup_r16 128
#define maxNrofMultiplePUSCHs_r16      8
#define maxNrofP0_PUSCH_AlphaSets      30
#define maxNrofP0_PUSCH_AlphaSets_1    29
#define maxNrofPUSCH_PathlossReferenceRSs 4
#define maxNrofPUSCH_PathlossReferenceRSs_1 3
#define maxNrofPUSCH_PathlossReferenceRSs_r16 64
#define maxNrofPUSCH_PathlossReferenceRSs_1_r16 63
#define maxNrofPUSCH_PathlossReferenceRSsDiff_r16 60
#define maxNrofNAICS_Entries           8
#define maxBands                       1024
#define maxBandsMRDC                   1280
#define maxBandsEUTRA                  256
#define maxCellReport                  8
#define maxDRB                         29
#define maxFreq                        8
#define maxFreqLayers                  4
#define maxFreqIDC_r16                 128
#define maxCombIDC_r16                 128
#define maxFreqIDC_MRDC                32
#define maxNrofCandidateBeams          16
#define maxNrofCandidateBeams_r16      64
#define maxNrofCandidateBeamsExt_r16   48
#define maxNrofPCIsPerSMTC             64
#define maxNrofQFIs                    64
#define maxNrofResourceAvailabilityPerCombination_r16 256
#define maxNrOfSemiPersistentPUSCH_Triggers 64
#define maxNrofSR_Resources            8
#define maxNrofSlotFormatsPerCombination 256
#define maxNrofSpatialRelationInfos    8
#define maxNrofSpatialRelationInfos_plus_1 9
#define maxNrofSpatialRelationInfos_r16 64
#define maxNrofSpatialRelationInfosDiff_r16 56
#define maxNrofIndexesToReport         32
#define maxNrofIndexesToReport2        64
#define maxNrofSSBs_r16                64
#define maxNrofSSBs_1                  63
#define maxNrofS_NSSAI                 8
#define maxNrofTCI_StatesPDCCH         64
#define maxNrofTCI_States              128
#define maxNrofTCI_States_1            127
#define maxNrofUL_Allocations          16
#define maxQFI                         63
#define maxRA_CSIRS_Resources          96
#define maxRA_OccasionsPerCSIRS        64
#define maxRA_Occasions_1              511
#define maxRA_SSB_Resources            64
#define maxSCSs                        5
#define maxSecondaryCellGroups         3
#define maxNrofServingCellsEUTRA       32
#define maxMBSFN_Allocations           8
#define maxNrofMultiBands              8
#define maxCellSFTD                    3
#define maxReportConfigId              64
#define maxNrofCodebooks               16
#define maxNrofCSI_RS_ResourcesExt_r16 16
#define maxNrofCSI_RS_Resources        7
#define maxNrofCSI_RS_ResourcesAlt_r16 512
#define maxNrofCSI_RS_ResourcesAlt_1_r16 511
#define maxNrofSRI_PUSCH_Mappings      16
#define maxNrofSRI_PUSCH_Mappings_1    15
#define maxSIB                         32
#define maxSI_Message                  32
#define maxPO_perPF                    4
#define maxAccessCat_1                 63
#define maxBarringInfoSet              8
#define maxCellEUTRA                   8
#define maxEUTRA_Carrier               8
#define maxPLMNIdentities              8
#define maxDownlinkFeatureSets         1024
#define maxUplinkFeatureSets           1024
#define maxEUTRA_DL_FeatureSets        256
#define maxEUTRA_UL_FeatureSets        256
#define maxFeatureSetsPerBand          128
#define maxPerCC_FeatureSets           1024
#define maxFeatureSetCombinations      1024
#define maxInterRAT_RSTD_Freq          3
#define maxHRNN_Len_r16                48
#define maxNPN_r16                     12
#define maxNrOfMinSchedulingOffsetValues_r16 2
#define maxK0_SchedulingOffset_r16     16
#define maxK2_SchedulingOffset_r16     16
#define maxDCI_2_6_Size_r16            140
#define maxDCI_2_6_Size_1_r16          139
#define maxNrofUL_Allocations_r16      64
#define maxNrofP0_PUSCH_Set_r16        2
#define maxOnDemandSIB_r16             8
#define maxOnDemandPosSIB_r16          32
#define maxCI_DCI_PayloadSize_r16      126
#define maxCI_DCI_PayloadSize_1_r16    125
#define maxWLAN_Id_Report_r16          32
#define maxWLAN_Name_r16               4
#define maxRAReport_r16                8
#define maxTxConfig_r16                64
#define maxTxConfig_1_r16              63
#define maxPSSCH_TxConfig_r16          16
#define maxNrofCLI_RSSI_Resources_r16  64
#define maxNrofCLI_RSSI_Resources_1_r16 63
#define maxNrofCLI_SRS_Resources_r16   32
#define maxCLI_Report_r16              8
#define maxNrofConfiguredGrantConfig_r16 12
#define maxNrofConfiguredGrantConfig_1_r16 11
#define maxNrofCG_Type2DeactivationState 16
#define maxNrofConfiguredGrantConfigMAC_1_r16 31
#define maxNrofSPS_Config_r16          8
#define maxNrofSPS_Config_1_r16        7
#define maxNrofSPS_DeactivationState   16
#define maxNrofDormancyGroups          5
#define maxNrofPUCCH_ResourceGroups_1_r16 3
#define maxNrofServingCellsTCI_r16     32
#define maxNrofTxDC_TwoCarrier_r16     64

typedef enum _RAT_Type_enum {
  RAT_Type_nr  =   0,
  RAT_Type_eutra_nr =   1,
  RAT_Type_eutra =   2,
  RAT_Type_utra_fdd_v1610 =   3
} RAT_Type_enum;

typedef enum _T_targetRAT_Type_enum {
  T_targetRAT_Type_eutra =   0,
  T_targetRAT_Type_utra_fdd_v1610 =   1,
  T_targetRAT_Type_spare2 =   2,
  T_targetRAT_Type_spare1 =   3
} T_targetRAT_Type_enum;

/*--- End of included file: packet-nr-rrc-val.h ---*/
#line 67 "./asn1/nr-rrc/packet-nr-rrc-template.c"

/* Initialize the protocol and registered fields */
static int proto_nr_rrc = -1;

/*--- Included file: packet-nr-rrc-hf.c ---*/
#line 1 "./asn1/nr-rrc/packet-nr-rrc-hf.c"
static int hf_nr_rrc_nr_rrc_HandoverCommand_PDU = -1;  /* HandoverCommand */
static int hf_nr_rrc_nr_rrc_HandoverPreparationInformation_PDU = -1;  /* HandoverPreparationInformation */
static int hf_nr_rrc_nr_rrc_CG_Config_PDU = -1;   /* CG_Config */
static int hf_nr_rrc_nr_rrc_PH_TypeListSCG_PDU = -1;  /* PH_TypeListSCG */
static int hf_nr_rrc_nr_rrc_BandCombinationIndex_PDU = -1;  /* BandCombinationIndex */
static int hf_nr_rrc_nr_rrc_BandCombinationInfoSN_PDU = -1;  /* BandCombinationInfoSN */
static int hf_nr_rrc_nr_rrc_CG_ConfigInfo_PDU = -1;  /* CG_ConfigInfo */
static int hf_nr_rrc_nr_rrc_ConfigRestrictInfoSCG_PDU = -1;  /* ConfigRestrictInfoSCG */
static int hf_nr_rrc_nr_rrc_PH_TypeListMCG_PDU = -1;  /* PH_TypeListMCG */
static int hf_nr_rrc_nr_rrc_FeatureSetEntryIndex_PDU = -1;  /* FeatureSetEntryIndex */
static int hf_nr_rrc_nr_rrc_MeasurementTimingConfiguration_PDU = -1;  /* MeasurementTimingConfiguration */
static int hf_nr_rrc_nr_rrc_UERadioPagingInformation_PDU = -1;  /* UERadioPagingInformation */
static int hf_nr_rrc_UERadioAccessCapabilityInformation_PDU = -1;  /* UERadioAccessCapabilityInformation */
static int hf_nr_rrc_BCCH_BCH_Message_PDU = -1;   /* BCCH_BCH_Message */
static int hf_nr_rrc_BCCH_DL_SCH_Message_PDU = -1;  /* BCCH_DL_SCH_Message */
static int hf_nr_rrc_DL_CCCH_Message_PDU = -1;    /* DL_CCCH_Message */
static int hf_nr_rrc_DL_DCCH_Message_PDU = -1;    /* DL_DCCH_Message */
static int hf_nr_rrc_PCCH_Message_PDU = -1;       /* PCCH_Message */
static int hf_nr_rrc_UL_CCCH_Message_PDU = -1;    /* UL_CCCH_Message */
static int hf_nr_rrc_UL_CCCH1_Message_PDU = -1;   /* UL_CCCH1_Message */
static int hf_nr_rrc_nr_rrc_UL_DCCH_Message_PDU = -1;  /* UL_DCCH_Message */
static int hf_nr_rrc_nr_rrc_MIB_PDU = -1;         /* MIB */
static int hf_nr_rrc_nr_rrc_RRCReconfiguration_PDU = -1;  /* RRCReconfiguration */
static int hf_nr_rrc_nr_rrc_SL_ConfigDedicatedEUTRA_Info_r16_PDU = -1;  /* SL_ConfigDedicatedEUTRA_Info_r16 */
static int hf_nr_rrc_nr_rrc_RRCReconfigurationComplete_PDU = -1;  /* RRCReconfigurationComplete */
static int hf_nr_rrc_nr_rrc_SIB1_PDU = -1;        /* SIB1 */
static int hf_nr_rrc_nr_rrc_SidelinkUEInformationNR_r16_PDU = -1;  /* SidelinkUEInformationNR_r16 */
static int hf_nr_rrc_nr_rrc_UEAssistanceInformation_PDU = -1;  /* UEAssistanceInformation */
static int hf_nr_rrc_nr_rrc_RA_ReportList_r16_PDU = -1;  /* RA_ReportList_r16 */
static int hf_nr_rrc_nr_rrc_SIB2_PDU = -1;        /* SIB2 */
static int hf_nr_rrc_nr_rrc_SIB3_PDU = -1;        /* SIB3 */
static int hf_nr_rrc_nr_rrc_SIB4_PDU = -1;        /* SIB4 */
static int hf_nr_rrc_nr_rrc_SIB5_PDU = -1;        /* SIB5 */
static int hf_nr_rrc_nr_rrc_SIB6_PDU = -1;        /* SIB6 */
static int hf_nr_rrc_nr_rrc_SIB7_PDU = -1;        /* SIB7 */
static int hf_nr_rrc_nr_rrc_SIB8_PDU = -1;        /* SIB8 */
static int hf_nr_rrc_nr_rrc_SIB9_PDU = -1;        /* SIB9 */
static int hf_nr_rrc_nr_rrc_SIB10_r16_PDU = -1;   /* SIB10_r16 */
static int hf_nr_rrc_nr_rrc_SIB11_r16_PDU = -1;   /* SIB11_r16 */
static int hf_nr_rrc_nr_rrc_SIB12_r16_PDU = -1;   /* SIB12_r16 */
static int hf_nr_rrc_nr_rrc_SIB13_r16_PDU = -1;   /* SIB13_r16 */
static int hf_nr_rrc_nr_rrc_SIB14_r16_PDU = -1;   /* SIB14_r16 */
static int hf_nr_rrc_nr_rrc_CellGroupConfig_PDU = -1;  /* CellGroupConfig */
static int hf_nr_rrc_nr_rrc_DRX_Config_PDU = -1;  /* DRX_Config */
static int hf_nr_rrc_nr_rrc_LocationMeasurementInfo_PDU = -1;  /* LocationMeasurementInfo */
static int hf_nr_rrc_nr_rrc_MeasConfig_PDU = -1;  /* MeasConfig */
static int hf_nr_rrc_nr_rrc_MeasGapConfig_PDU = -1;  /* MeasGapConfig */
static int hf_nr_rrc_nr_rrc_MeasGapSharingConfig_PDU = -1;  /* MeasGapSharingConfig */
static int hf_nr_rrc_nr_rrc_MeasResultSCG_Failure_PDU = -1;  /* MeasResultSCG_Failure */
static int hf_nr_rrc_nr_rrc_NZP_CSI_RS_Resource_PDU = -1;  /* NZP_CSI_RS_Resource */
static int hf_nr_rrc_nr_rrc_P_Max_PDU = -1;       /* P_Max */
static int hf_nr_rrc_nr_rrc_PDCCH_ConfigSIB1_PDU = -1;  /* PDCCH_ConfigSIB1 */
static int hf_nr_rrc_nr_rrc_RACH_ConfigCommon_PDU = -1;  /* RACH_ConfigCommon */
static int hf_nr_rrc_nr_rrc_RadioBearerConfig_PDU = -1;  /* RadioBearerConfig */
static int hf_nr_rrc_nr_rrc_ReferenceTime_r16_PDU = -1;  /* ReferenceTime_r16 */
static int hf_nr_rrc_nr_rrc_SchedulingRequestResourceConfig_PDU = -1;  /* SchedulingRequestResourceConfig */
static int hf_nr_rrc_nr_rrc_TDD_UL_DL_ConfigCommon_PDU = -1;  /* TDD_UL_DL_ConfigCommon */
static int hf_nr_rrc_nr_rrc_UplinkTxDirectCurrentList_PDU = -1;  /* UplinkTxDirectCurrentList */
static int hf_nr_rrc_nr_rrc_BandParametersSidelink_r16_PDU = -1;  /* BandParametersSidelink_r16 */
static int hf_nr_rrc_nr_rrc_FreqBandList_PDU = -1;  /* FreqBandList */
static int hf_nr_rrc_nr_rrc_SidelinkParametersNR_r16_PDU = -1;  /* SidelinkParametersNR_r16 */
static int hf_nr_rrc_nr_rrc_UE_CapabilityRAT_ContainerList_PDU = -1;  /* UE_CapabilityRAT_ContainerList */
static int hf_nr_rrc_nr_rrc_UE_CapabilityRequestFilterCommon_PDU = -1;  /* UE_CapabilityRequestFilterCommon */
static int hf_nr_rrc_nr_rrc_UE_CapabilityRequestFilterNR_PDU = -1;  /* UE_CapabilityRequestFilterNR */
static int hf_nr_rrc_nr_rrc_UE_MRDC_Capability_PDU = -1;  /* UE_MRDC_Capability */
static int hf_nr_rrc_nr_rrc_UE_NR_Capability_PDU = -1;  /* UE_NR_Capability */
static int hf_nr_rrc_nr_rrc_VisitedCellInfoList_r16_PDU = -1;  /* VisitedCellInfoList_r16 */
static int hf_nr_rrc_nr_rrc_SL_PHY_MAC_RLC_Config_r16_PDU = -1;  /* SL_PHY_MAC_RLC_Config_r16 */
static int hf_nr_rrc_SBCCH_SL_BCH_Message_PDU = -1;  /* SBCCH_SL_BCH_Message */
static int hf_nr_rrc_SCCH_Message_PDU = -1;       /* SCCH_Message */
static int hf_nr_rrc_UECapabilityInformationSidelink_PDU = -1;  /* UECapabilityInformationSidelink */
static int hf_nr_rrc_MeasResultList2NR_PDU = -1;  /* MeasResultList2NR */
static int hf_nr_rrc_OverheatingAssistance_PDU = -1;  /* OverheatingAssistance */
static int hf_nr_rrc_SystemInformation_PDU = -1;  /* SystemInformation */
static int hf_nr_rrc_PosSystemInformation_r16_IEs_PDU = -1;  /* PosSystemInformation_r16_IEs */
static int hf_nr_rrc_UECapabilityEnquiry_v1560_IEs_PDU = -1;  /* UECapabilityEnquiry_v1560_IEs */
static int hf_nr_rrc_UE_MRDC_Capability_v15g0_PDU = -1;  /* UE_MRDC_Capability_v15g0 */
static int hf_nr_rrc_UE_NR_Capability_v15c0_PDU = -1;  /* UE_NR_Capability_v15c0 */
static int hf_nr_rrc_criticalExtensions = -1;     /* T_criticalExtensions */
static int hf_nr_rrc_c1 = -1;                     /* T_c1 */
static int hf_nr_rrc_handoverCommand = -1;        /* HandoverCommand_IEs */
static int hf_nr_rrc_spare3 = -1;                 /* NULL */
static int hf_nr_rrc_spare2 = -1;                 /* NULL */
static int hf_nr_rrc_spare1 = -1;                 /* NULL */
static int hf_nr_rrc_criticalExtensionsFuture = -1;  /* T_criticalExtensionsFuture */
static int hf_nr_rrc_handoverCommandMessage = -1;  /* T_handoverCommandMessage */
static int hf_nr_rrc_nonCriticalExtension = -1;   /* T_nonCriticalExtension */
static int hf_nr_rrc_criticalExtensions_01 = -1;  /* T_criticalExtensions_01 */
static int hf_nr_rrc_c1_01 = -1;                  /* T_c1_01 */
static int hf_nr_rrc_handoverPreparationInformation = -1;  /* HandoverPreparationInformation_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_01 = -1;  /* T_criticalExtensionsFuture_01 */
static int hf_nr_rrc_ue_CapabilityRAT_List = -1;  /* UE_CapabilityRAT_ContainerList */
static int hf_nr_rrc_sourceConfig = -1;           /* AS_Config */
static int hf_nr_rrc_rrm_Config = -1;             /* RRM_Config */
static int hf_nr_rrc_as_Context = -1;             /* AS_Context */
static int hf_nr_rrc_nonCriticalExtension_01 = -1;  /* T_nonCriticalExtension_01 */
static int hf_nr_rrc_rrcReconfiguration = -1;     /* T_rrcReconfiguration */
static int hf_nr_rrc_sourceRB_SN_Config = -1;     /* T_sourceRB_SN_Config */
static int hf_nr_rrc_sourceSCG_NR_Config = -1;    /* T_sourceSCG_NR_Config */
static int hf_nr_rrc_sourceSCG_EUTRA_Config = -1;  /* T_sourceSCG_EUTRA_Config */
static int hf_nr_rrc_sourceSCG_Configured = -1;   /* T_sourceSCG_Configured */
static int hf_nr_rrc_reestablishmentInfo = -1;    /* ReestablishmentInfo */
static int hf_nr_rrc_configRestrictInfo = -1;     /* ConfigRestrictInfoSCG */
static int hf_nr_rrc_ran_NotificationAreaInfo = -1;  /* RAN_NotificationAreaInfo */
static int hf_nr_rrc_ueAssistanceInformation = -1;  /* T_ueAssistanceInformation */
static int hf_nr_rrc_selectedBandCombinationSN = -1;  /* BandCombinationInfoSN */
static int hf_nr_rrc_configRestrictInfoDAPS_r16 = -1;  /* ConfigRestrictInfoDAPS_r16 */
static int hf_nr_rrc_sidelinkUEInformationNR_r16 = -1;  /* T_sidelinkUEInformationNR_r16 */
static int hf_nr_rrc_sidelinkUEInformationEUTRA_r16 = -1;  /* T_sidelinkUEInformationEUTRA_r16 */
static int hf_nr_rrc_ueAssistanceInformationEUTRA_r16 = -1;  /* T_ueAssistanceInformationEUTRA_r16 */
static int hf_nr_rrc_ueAssistanceInformationSCG_r16 = -1;  /* T_ueAssistanceInformationSCG_r16 */
static int hf_nr_rrc_needForGapsInfoNR_r16 = -1;  /* NeedForGapsInfoNR_r16 */
static int hf_nr_rrc_configRestrictInfoDAPS_v1640 = -1;  /* ConfigRestrictInfoDAPS_v1640 */
static int hf_nr_rrc_powerCoordination_r16 = -1;  /* T_powerCoordination_r16 */
static int hf_nr_rrc_p_DAPS_Source_r16 = -1;      /* P_Max */
static int hf_nr_rrc_p_DAPS_Target_r16 = -1;      /* P_Max */
static int hf_nr_rrc_uplinkPowerSharingDAPS_Mode_r16 = -1;  /* T_uplinkPowerSharingDAPS_Mode_r16 */
static int hf_nr_rrc_sourceFeatureSetPerDownlinkCC_r16 = -1;  /* FeatureSetDownlinkPerCC_Id */
static int hf_nr_rrc_sourceFeatureSetPerUplinkCC_r16 = -1;  /* FeatureSetUplinkPerCC_Id */
static int hf_nr_rrc_sourcePhysCellId = -1;       /* PhysCellId */
static int hf_nr_rrc_targetCellShortMAC_I = -1;   /* ShortMAC_I */
static int hf_nr_rrc_additionalReestabInfoList = -1;  /* ReestabNCellInfoList */
static int hf_nr_rrc_ReestabNCellInfoList_item = -1;  /* ReestabNCellInfo */
static int hf_nr_rrc_cellIdentity = -1;           /* CellIdentity */
static int hf_nr_rrc_key_gNodeB_Star = -1;        /* BIT_STRING_SIZE_256 */
static int hf_nr_rrc_shortMAC_I = -1;             /* ShortMAC_I */
static int hf_nr_rrc_ue_InactiveTime = -1;        /* T_ue_InactiveTime */
static int hf_nr_rrc_candidateCellInfoList = -1;  /* MeasResultList2NR */
static int hf_nr_rrc_rRM_Config_eag_1_candidateCellInfoListSN_EUTRA = -1;  /* MeasResultServFreqListEUTRA_SCG */
static int hf_nr_rrc_criticalExtensions_02 = -1;  /* T_criticalExtensions_02 */
static int hf_nr_rrc_c1_02 = -1;                  /* T_c1_02 */
static int hf_nr_rrc_cg_Config = -1;              /* CG_Config_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_02 = -1;  /* T_criticalExtensionsFuture_02 */
static int hf_nr_rrc_scg_CellGroupConfig = -1;    /* T_scg_CellGroupConfig */
static int hf_nr_rrc_scg_RB_Config = -1;          /* T_scg_RB_Config */
static int hf_nr_rrc_configRestrictModReq = -1;   /* ConfigRestrictModReqSCG */
static int hf_nr_rrc_drx_InfoSCG = -1;            /* DRX_Info */
static int hf_nr_rrc_candidateCellInfoListSN = -1;  /* T_candidateCellInfoListSN */
static int hf_nr_rrc_measConfigSN = -1;           /* MeasConfigSN */
static int hf_nr_rrc_selectedBandCombination = -1;  /* BandCombinationInfoSN */
static int hf_nr_rrc_fr_InfoListSCG = -1;         /* FR_InfoList */
static int hf_nr_rrc_candidateServingFreqListNR = -1;  /* CandidateServingFreqListNR */
static int hf_nr_rrc_nonCriticalExtension_02 = -1;  /* CG_Config_v1540_IEs */
static int hf_nr_rrc_pSCellFrequency = -1;        /* ARFCN_ValueNR */
static int hf_nr_rrc_reportCGI_RequestNR = -1;    /* T_reportCGI_RequestNR */
static int hf_nr_rrc_requestedCellInfo = -1;      /* T_requestedCellInfo */
static int hf_nr_rrc_ssbFrequency = -1;           /* ARFCN_ValueNR */
static int hf_nr_rrc_cellForWhichToReportCGI = -1;  /* PhysCellId */
static int hf_nr_rrc_ph_InfoSCG = -1;             /* PH_TypeListSCG */
static int hf_nr_rrc_nonCriticalExtension_03 = -1;  /* CG_Config_v1560_IEs */
static int hf_nr_rrc_pSCellFrequencyEUTRA = -1;   /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_scg_CellGroupConfigEUTRA = -1;  /* T_scg_CellGroupConfigEUTRA */
static int hf_nr_rrc_cG_Config_v1560_IEs_candidateCellInfoListSN_EUTRA = -1;  /* T_cG_Config_v1560_IEs_candidateCellInfoListSN_EUTRA */
static int hf_nr_rrc_candidateServingFreqListEUTRA = -1;  /* CandidateServingFreqListEUTRA */
static int hf_nr_rrc_needForGaps = -1;            /* T_needForGaps */
static int hf_nr_rrc_drx_ConfigSCG = -1;          /* DRX_Config */
static int hf_nr_rrc_reportCGI_RequestEUTRA = -1;  /* T_reportCGI_RequestEUTRA */
static int hf_nr_rrc_requestedCellInfoEUTRA = -1;  /* T_requestedCellInfoEUTRA */
static int hf_nr_rrc_eutraFrequency = -1;         /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_cellForWhichToReportCGI_EUTRA = -1;  /* EUTRA_PhysCellId */
static int hf_nr_rrc_nonCriticalExtension_04 = -1;  /* CG_Config_v1590_IEs */
static int hf_nr_rrc_scellFrequenciesSN_NR = -1;  /* SEQUENCE_SIZE_1_maxNrofServingCells_1_OF_ARFCN_ValueNR */
static int hf_nr_rrc_scellFrequenciesSN_NR_item = -1;  /* ARFCN_ValueNR */
static int hf_nr_rrc_scellFrequenciesSN_EUTRA = -1;  /* SEQUENCE_SIZE_1_maxNrofServingCells_1_OF_ARFCN_ValueEUTRA */
static int hf_nr_rrc_scellFrequenciesSN_EUTRA_item = -1;  /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_nonCriticalExtension_05 = -1;  /* CG_Config_v1610_IEs */
static int hf_nr_rrc_drx_InfoSCG2 = -1;           /* DRX_Info2 */
static int hf_nr_rrc_nonCriticalExtension_06 = -1;  /* CG_Config_v1620_IEs */
static int hf_nr_rrc_ueAssistanceInformationSCG_r16_01 = -1;  /* T_ueAssistanceInformationSCG_r16_01 */
static int hf_nr_rrc_nonCriticalExtension_07 = -1;  /* CG_Config_v1630_IEs */
static int hf_nr_rrc_selectedToffset_r16 = -1;    /* T_Offset_r16 */
static int hf_nr_rrc_nonCriticalExtension_08 = -1;  /* CG_Config_v1640_IEs */
static int hf_nr_rrc_servCellInfoListSCG_NR_r16 = -1;  /* ServCellInfoListSCG_NR_r16 */
static int hf_nr_rrc_servCellInfoListSCG_EUTRA_r16 = -1;  /* ServCellInfoListSCG_EUTRA_r16 */
static int hf_nr_rrc_nonCriticalExtension_09 = -1;  /* T_nonCriticalExtension_02 */
static int hf_nr_rrc_ServCellInfoListSCG_NR_r16_item = -1;  /* ServCellInfoXCG_NR_r16 */
static int hf_nr_rrc_dl_FreqInfo_NR_r16 = -1;     /* FrequencyConfig_NR_r16 */
static int hf_nr_rrc_ul_FreqInfo_NR_r16 = -1;     /* FrequencyConfig_NR_r16 */
static int hf_nr_rrc_freqBandIndicatorNR_r16 = -1;  /* FreqBandIndicatorNR */
static int hf_nr_rrc_carrierCenterFreq_NR_r16 = -1;  /* ARFCN_ValueNR */
static int hf_nr_rrc_carrierBandwidth_NR_r16 = -1;  /* INTEGER_1_maxNrofPhysicalResourceBlocks */
static int hf_nr_rrc_subcarrierSpacing_NR_r16 = -1;  /* SubcarrierSpacing */
static int hf_nr_rrc_ServCellInfoListSCG_EUTRA_r16_item = -1;  /* ServCellInfoXCG_EUTRA_r16 */
static int hf_nr_rrc_dl_CarrierFreq_EUTRA_r16 = -1;  /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_ul_CarrierFreq_EUTRA_r16 = -1;  /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_transmissionBandwidth_EUTRA_r16 = -1;  /* TransmissionBandwidth_EUTRA_r16 */
static int hf_nr_rrc_PH_TypeListSCG_item = -1;    /* PH_InfoSCG */
static int hf_nr_rrc_servCellIndex = -1;          /* ServCellIndex */
static int hf_nr_rrc_ph_Uplink = -1;              /* PH_UplinkCarrierSCG */
static int hf_nr_rrc_ph_SupplementaryUplink = -1;  /* PH_UplinkCarrierSCG */
static int hf_nr_rrc_ph_Type1or3 = -1;            /* T_ph_Type1or3 */
static int hf_nr_rrc_measuredFrequenciesSN = -1;  /* SEQUENCE_SIZE_1_maxMeasFreqsSN_OF_NR_FreqInfo */
static int hf_nr_rrc_measuredFrequenciesSN_item = -1;  /* NR_FreqInfo */
static int hf_nr_rrc_measuredFrequency = -1;      /* ARFCN_ValueNR */
static int hf_nr_rrc_requestedBC_MRDC = -1;       /* BandCombinationInfoSN */
static int hf_nr_rrc_requestedP_MaxFR1 = -1;      /* P_Max */
static int hf_nr_rrc_requestedPDCCH_BlindDetectionSCG = -1;  /* INTEGER_1_15 */
static int hf_nr_rrc_requestedP_MaxEUTRA = -1;    /* P_Max */
static int hf_nr_rrc_requestedP_MaxFR2_r16 = -1;  /* P_Max */
static int hf_nr_rrc_requestedMaxInterFreqMeasIdSCG_r16 = -1;  /* INTEGER_1_maxMeasIdentitiesMN */
static int hf_nr_rrc_requestedMaxIntraFreqMeasIdSCG_r16 = -1;  /* INTEGER_1_maxMeasIdentitiesMN */
static int hf_nr_rrc_requestedToffset_r16 = -1;   /* T_Offset_r16 */
static int hf_nr_rrc_bandCombinationIndex = -1;   /* BandCombinationIndex */
static int hf_nr_rrc_requestedFeatureSets = -1;   /* FeatureSetEntryIndex */
static int hf_nr_rrc_FR_InfoList_item = -1;       /* FR_Info */
static int hf_nr_rrc_fr_Type = -1;                /* T_fr_Type */
static int hf_nr_rrc_CandidateServingFreqListNR_item = -1;  /* ARFCN_ValueNR */
static int hf_nr_rrc_CandidateServingFreqListEUTRA_item = -1;  /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_criticalExtensions_03 = -1;  /* T_criticalExtensions_03 */
static int hf_nr_rrc_c1_03 = -1;                  /* T_c1_03 */
static int hf_nr_rrc_cg_ConfigInfo = -1;          /* CG_ConfigInfo_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_03 = -1;  /* T_criticalExtensionsFuture_03 */
static int hf_nr_rrc_ue_CapabilityInfo = -1;      /* T_ue_CapabilityInfo */
static int hf_nr_rrc_candidateCellInfoListMN = -1;  /* MeasResultList2NR */
static int hf_nr_rrc_candidateCellInfoListSN_01 = -1;  /* T_candidateCellInfoListSN_01 */
static int hf_nr_rrc_measResultCellListSFTD_NR = -1;  /* MeasResultCellListSFTD_NR */
static int hf_nr_rrc_scgFailureInfo = -1;         /* T_scgFailureInfo */
static int hf_nr_rrc_failureType = -1;            /* T_failureType */
static int hf_nr_rrc_measResultSCG = -1;          /* T_measResultSCG */
static int hf_nr_rrc_drx_InfoMCG = -1;            /* DRX_Info */
static int hf_nr_rrc_measConfigMN = -1;           /* MeasConfigMN */
static int hf_nr_rrc_sourceConfigSCG = -1;        /* T_sourceConfigSCG */
static int hf_nr_rrc_scg_RB_Config_01 = -1;       /* T_scg_RB_Config_01 */
static int hf_nr_rrc_mcg_RB_Config = -1;          /* T_mcg_RB_Config */
static int hf_nr_rrc_mrdc_AssistanceInfo = -1;    /* MRDC_AssistanceInfo */
static int hf_nr_rrc_nonCriticalExtension_10 = -1;  /* CG_ConfigInfo_v1540_IEs */
static int hf_nr_rrc_ph_InfoMCG = -1;             /* PH_TypeListMCG */
static int hf_nr_rrc_measResultReportCGI = -1;    /* T_measResultReportCGI */
static int hf_nr_rrc_cgi_Info = -1;               /* CGI_InfoNR */
static int hf_nr_rrc_nonCriticalExtension_11 = -1;  /* CG_ConfigInfo_v1560_IEs */
static int hf_nr_rrc_candidateCellInfoListMN_EUTRA = -1;  /* T_candidateCellInfoListMN_EUTRA */
static int hf_nr_rrc_cG_ConfigInfo_v1560_IEs_candidateCellInfoListSN_EUTRA = -1;  /* T_cG_ConfigInfo_v1560_IEs_candidateCellInfoListSN_EUTRA */
static int hf_nr_rrc_sourceConfigSCG_EUTRA = -1;  /* T_sourceConfigSCG_EUTRA */
static int hf_nr_rrc_scgFailureInfoEUTRA = -1;    /* T_scgFailureInfoEUTRA */
static int hf_nr_rrc_failureTypeEUTRA = -1;       /* T_failureTypeEUTRA */
static int hf_nr_rrc_measResultSCG_EUTRA = -1;    /* T_measResultSCG_EUTRA */
static int hf_nr_rrc_drx_ConfigMCG = -1;          /* DRX_Config */
static int hf_nr_rrc_measResultReportCGI_EUTRA = -1;  /* T_measResultReportCGI_EUTRA */
static int hf_nr_rrc_cgi_InfoEUTRA = -1;          /* CGI_InfoEUTRA */
static int hf_nr_rrc_measResultCellListSFTD_EUTRA = -1;  /* MeasResultCellListSFTD_EUTRA */
static int hf_nr_rrc_fr_InfoListMCG = -1;         /* FR_InfoList */
static int hf_nr_rrc_nonCriticalExtension_12 = -1;  /* CG_ConfigInfo_v1570_IEs */
static int hf_nr_rrc_sftdFrequencyList_NR = -1;   /* SFTD_FrequencyList_NR */
static int hf_nr_rrc_sftdFrequencyList_EUTRA = -1;  /* SFTD_FrequencyList_EUTRA */
static int hf_nr_rrc_nonCriticalExtension_13 = -1;  /* CG_ConfigInfo_v1590_IEs */
static int hf_nr_rrc_servFrequenciesMN_NR = -1;   /* SEQUENCE_SIZE_1_maxNrofServingCells_1_OF_ARFCN_ValueNR */
static int hf_nr_rrc_servFrequenciesMN_NR_item = -1;  /* ARFCN_ValueNR */
static int hf_nr_rrc_nonCriticalExtension_14 = -1;  /* CG_ConfigInfo_v1610_IEs */
static int hf_nr_rrc_drx_InfoMCG2 = -1;           /* DRX_Info2 */
static int hf_nr_rrc_alignedDRX_Indication = -1;  /* T_alignedDRX_Indication */
static int hf_nr_rrc_scgFailureInfo_r16 = -1;     /* T_scgFailureInfo_r16 */
static int hf_nr_rrc_failureType_r16 = -1;        /* T_failureType_r16 */
static int hf_nr_rrc_measResultSCG_r16 = -1;      /* T_measResultSCG_r16 */
static int hf_nr_rrc_dummy1 = -1;                 /* T_dummy1 */
static int hf_nr_rrc_failureTypeEUTRA_r16 = -1;   /* T_failureTypeEUTRA_r16 */
static int hf_nr_rrc_measResultSCG_EUTRA_r16 = -1;  /* OCTET_STRING */
static int hf_nr_rrc_sidelinkUEInformationNR_r16_01 = -1;  /* T_sidelinkUEInformationNR_r16_01 */
static int hf_nr_rrc_sidelinkUEInformationEUTRA_r16_01 = -1;  /* OCTET_STRING */
static int hf_nr_rrc_nonCriticalExtension_15 = -1;  /* CG_ConfigInfo_v1620_IEs */
static int hf_nr_rrc_ueAssistanceInformationSourceSCG_r16 = -1;  /* T_ueAssistanceInformationSourceSCG_r16 */
static int hf_nr_rrc_nonCriticalExtension_16 = -1;  /* CG_ConfigInfo_v1640_IEs */
static int hf_nr_rrc_servCellInfoListMCG_NR_r16 = -1;  /* ServCellInfoListMCG_NR_r16 */
static int hf_nr_rrc_servCellInfoListMCG_EUTRA_r16 = -1;  /* ServCellInfoListMCG_EUTRA_r16 */
static int hf_nr_rrc_nonCriticalExtension_17 = -1;  /* T_nonCriticalExtension_03 */
static int hf_nr_rrc_ServCellInfoListMCG_NR_r16_item = -1;  /* ServCellInfoXCG_NR_r16 */
static int hf_nr_rrc_ServCellInfoListMCG_EUTRA_r16_item = -1;  /* ServCellInfoXCG_EUTRA_r16 */
static int hf_nr_rrc_SFTD_FrequencyList_NR_item = -1;  /* ARFCN_ValueNR */
static int hf_nr_rrc_SFTD_FrequencyList_EUTRA_item = -1;  /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_allowedBC_ListMRDC = -1;     /* BandCombinationInfoList */
static int hf_nr_rrc_powerCoordination_FR1 = -1;  /* T_powerCoordination_FR1 */
static int hf_nr_rrc_p_maxNR_FR1 = -1;            /* P_Max */
static int hf_nr_rrc_p_maxEUTRA = -1;             /* P_Max */
static int hf_nr_rrc_p_maxUE_FR1 = -1;            /* P_Max */
static int hf_nr_rrc_servCellIndexRangeSCG = -1;  /* T_servCellIndexRangeSCG */
static int hf_nr_rrc_lowBound = -1;               /* ServCellIndex */
static int hf_nr_rrc_upBound = -1;                /* ServCellIndex */
static int hf_nr_rrc_maxMeasFreqsSCG = -1;        /* INTEGER_1_maxMeasFreqsMN */
static int hf_nr_rrc_configRestrictInfoSCG_dummy = -1;  /* INTEGER_1_maxMeasIdentitiesMN */
static int hf_nr_rrc_selectedBandEntriesMNList = -1;  /* SEQUENCE_SIZE_1_maxBandComb_OF_SelectedBandEntriesMN */
static int hf_nr_rrc_selectedBandEntriesMNList_item = -1;  /* SelectedBandEntriesMN */
static int hf_nr_rrc_pdcch_BlindDetectionSCG = -1;  /* INTEGER_1_15 */
static int hf_nr_rrc_maxNumberROHC_ContextSessionsSN = -1;  /* INTEGER_0_16384 */
static int hf_nr_rrc_maxIntraFreqMeasIdentitiesSCG = -1;  /* INTEGER_1_maxMeasIdentitiesMN */
static int hf_nr_rrc_maxInterFreqMeasIdentitiesSCG = -1;  /* INTEGER_1_maxMeasIdentitiesMN */
static int hf_nr_rrc_p_maxNR_FR1_MCG_r16 = -1;    /* P_Max */
static int hf_nr_rrc_powerCoordination_FR2_r16 = -1;  /* T_powerCoordination_FR2_r16 */
static int hf_nr_rrc_p_maxNR_FR2_MCG_r16 = -1;    /* P_Max */
static int hf_nr_rrc_p_maxNR_FR2_SCG_r16 = -1;    /* P_Max */
static int hf_nr_rrc_p_maxUE_FR2_r16 = -1;        /* P_Max */
static int hf_nr_rrc_nrdc_PC_mode_FR1_r16 = -1;   /* T_nrdc_PC_mode_FR1_r16 */
static int hf_nr_rrc_nrdc_PC_mode_FR2_r16 = -1;   /* T_nrdc_PC_mode_FR2_r16 */
static int hf_nr_rrc_maxMeasSRS_ResourceSCG_r16 = -1;  /* INTEGER_0_maxNrofCLI_SRS_Resources_r16 */
static int hf_nr_rrc_maxMeasCLI_ResourceSCG_r16 = -1;  /* INTEGER_0_maxNrofCLI_RSSI_Resources_r16 */
static int hf_nr_rrc_maxNumberEHC_ContextsSN_r16 = -1;  /* INTEGER_0_65536 */
static int hf_nr_rrc_allowedReducedConfigForOverheating_r16 = -1;  /* OverheatingAssistance */
static int hf_nr_rrc_maxToffset_r16 = -1;         /* T_Offset_r16 */
static int hf_nr_rrc_SelectedBandEntriesMN_item = -1;  /* BandEntryIndex */
static int hf_nr_rrc_PH_TypeListMCG_item = -1;    /* PH_InfoMCG */
static int hf_nr_rrc_ph_Uplink_01 = -1;           /* PH_UplinkCarrierMCG */
static int hf_nr_rrc_ph_SupplementaryUplink_01 = -1;  /* PH_UplinkCarrierMCG */
static int hf_nr_rrc_ph_Type1or3_01 = -1;         /* T_ph_Type1or3_01 */
static int hf_nr_rrc_BandCombinationInfoList_item = -1;  /* BandCombinationInfo */
static int hf_nr_rrc_allowedFeatureSetsList = -1;  /* SEQUENCE_SIZE_1_maxFeatureSetsPerBand_OF_FeatureSetEntryIndex */
static int hf_nr_rrc_allowedFeatureSetsList_item = -1;  /* FeatureSetEntryIndex */
static int hf_nr_rrc_drx_LongCycleStartOffset = -1;  /* T_drx_LongCycleStartOffset */
static int hf_nr_rrc_ms10 = -1;                   /* INTEGER_0_9 */
static int hf_nr_rrc_ms20 = -1;                   /* INTEGER_0_19 */
static int hf_nr_rrc_ms32 = -1;                   /* INTEGER_0_31 */
static int hf_nr_rrc_ms40 = -1;                   /* INTEGER_0_39 */
static int hf_nr_rrc_ms60 = -1;                   /* INTEGER_0_59 */
static int hf_nr_rrc_ms64 = -1;                   /* INTEGER_0_63 */
static int hf_nr_rrc_ms70 = -1;                   /* INTEGER_0_69 */
static int hf_nr_rrc_ms80 = -1;                   /* INTEGER_0_79 */
static int hf_nr_rrc_ms128 = -1;                  /* INTEGER_0_127 */
static int hf_nr_rrc_ms160 = -1;                  /* INTEGER_0_159 */
static int hf_nr_rrc_ms256 = -1;                  /* INTEGER_0_255 */
static int hf_nr_rrc_ms320 = -1;                  /* INTEGER_0_319 */
static int hf_nr_rrc_ms512 = -1;                  /* INTEGER_0_511 */
static int hf_nr_rrc_ms640 = -1;                  /* INTEGER_0_639 */
static int hf_nr_rrc_ms1024 = -1;                 /* INTEGER_0_1023 */
static int hf_nr_rrc_ms1280 = -1;                 /* INTEGER_0_1279 */
static int hf_nr_rrc_ms2048 = -1;                 /* INTEGER_0_2047 */
static int hf_nr_rrc_ms2560 = -1;                 /* INTEGER_0_2559 */
static int hf_nr_rrc_ms5120 = -1;                 /* INTEGER_0_5119 */
static int hf_nr_rrc_ms10240 = -1;                /* INTEGER_0_10239 */
static int hf_nr_rrc_shortDRX = -1;               /* T_shortDRX */
static int hf_nr_rrc_drx_ShortCycle = -1;         /* T_drx_ShortCycle */
static int hf_nr_rrc_drx_ShortCycleTimer = -1;    /* INTEGER_1_16 */
static int hf_nr_rrc_drx_onDurationTimer = -1;    /* T_drx_onDurationTimer */
static int hf_nr_rrc_subMilliSeconds = -1;        /* INTEGER_1_31 */
static int hf_nr_rrc_milliSeconds = -1;           /* T_milliSeconds */
static int hf_nr_rrc_measuredFrequenciesMN = -1;  /* SEQUENCE_SIZE_1_maxMeasFreqsMN_OF_NR_FreqInfo */
static int hf_nr_rrc_measuredFrequenciesMN_item = -1;  /* NR_FreqInfo */
static int hf_nr_rrc_measGapConfig = -1;          /* T_measGapConfig */
static int hf_nr_rrc_release = -1;                /* NULL */
static int hf_nr_rrc_setup = -1;                  /* GapConfig */
static int hf_nr_rrc_gapPurpose = -1;             /* T_gapPurpose */
static int hf_nr_rrc_measGapConfigFR2 = -1;       /* T_measGapConfigFR2 */
static int hf_nr_rrc_affectedCarrierFreqCombInfoListMRDC = -1;  /* SEQUENCE_SIZE_1_maxNrofCombIDC_OF_AffectedCarrierFreqCombInfoMRDC */
static int hf_nr_rrc_affectedCarrierFreqCombInfoListMRDC_item = -1;  /* AffectedCarrierFreqCombInfoMRDC */
static int hf_nr_rrc_overheatingAssistanceSCG_r16 = -1;  /* T_overheatingAssistanceSCG_r16 */
static int hf_nr_rrc_victimSystemType = -1;       /* VictimSystemType */
static int hf_nr_rrc_interferenceDirectionMRDC = -1;  /* T_interferenceDirectionMRDC */
static int hf_nr_rrc_affectedCarrierFreqCombMRDC = -1;  /* T_affectedCarrierFreqCombMRDC */
static int hf_nr_rrc_affectedCarrierFreqCombEUTRA = -1;  /* AffectedCarrierFreqCombEUTRA */
static int hf_nr_rrc_affectedCarrierFreqCombNR = -1;  /* AffectedCarrierFreqCombNR */
static int hf_nr_rrc_gps = -1;                    /* T_gps */
static int hf_nr_rrc_glonass = -1;                /* T_glonass */
static int hf_nr_rrc_bds = -1;                    /* T_bds */
static int hf_nr_rrc_galileo = -1;                /* T_galileo */
static int hf_nr_rrc_wlan = -1;                   /* T_wlan */
static int hf_nr_rrc_bluetooth = -1;              /* T_bluetooth */
static int hf_nr_rrc_AffectedCarrierFreqCombEUTRA_item = -1;  /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_AffectedCarrierFreqCombNR_item = -1;  /* ARFCN_ValueNR */
static int hf_nr_rrc_criticalExtensions_04 = -1;  /* T_criticalExtensions_04 */
static int hf_nr_rrc_c1_04 = -1;                  /* T_c1_04 */
static int hf_nr_rrc_measTimingConf = -1;         /* MeasurementTimingConfiguration_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_04 = -1;  /* T_criticalExtensionsFuture_04 */
static int hf_nr_rrc_measTiming = -1;             /* MeasTimingList */
static int hf_nr_rrc_nonCriticalExtension_18 = -1;  /* MeasurementTimingConfiguration_v1550_IEs */
static int hf_nr_rrc_campOnFirstSSB = -1;         /* BOOLEAN */
static int hf_nr_rrc_psCellOnlyOnFirstSSB = -1;   /* BOOLEAN */
static int hf_nr_rrc_nonCriticalExtension_19 = -1;  /* MeasurementTimingConfiguration_v1610_IEs */
static int hf_nr_rrc_csi_RS_Config_r16 = -1;      /* T_csi_RS_Config_r16 */
static int hf_nr_rrc_csi_RS_SubcarrierSpacing_r16 = -1;  /* SubcarrierSpacing */
static int hf_nr_rrc_csi_RS_CellMobility_r16 = -1;  /* CSI_RS_CellMobility */
static int hf_nr_rrc_refSSBFreq_r16 = -1;         /* ARFCN_ValueNR */
static int hf_nr_rrc_nonCriticalExtension_20 = -1;  /* T_nonCriticalExtension_04 */
static int hf_nr_rrc_MeasTimingList_item = -1;    /* MeasTiming */
static int hf_nr_rrc_frequencyAndTiming = -1;     /* T_frequencyAndTiming */
static int hf_nr_rrc_carrierFreq = -1;            /* ARFCN_ValueNR */
static int hf_nr_rrc_ssbSubcarrierSpacing = -1;   /* SubcarrierSpacing */
static int hf_nr_rrc_ssb_MeasurementTimingConfiguration = -1;  /* SSB_MTC */
static int hf_nr_rrc_ss_RSSI_Measurement = -1;    /* SS_RSSI_Measurement */
static int hf_nr_rrc_ssb_ToMeasure = -1;          /* SSB_ToMeasure */
static int hf_nr_rrc_physCellId = -1;             /* PhysCellId */
static int hf_nr_rrc_criticalExtensions_05 = -1;  /* T_criticalExtensions_05 */
static int hf_nr_rrc_c1_05 = -1;                  /* T_c1_05 */
static int hf_nr_rrc_ueRadioPagingInformation = -1;  /* UERadioPagingInformation_IEs */
static int hf_nr_rrc_spare7 = -1;                 /* NULL */
static int hf_nr_rrc_spare6 = -1;                 /* NULL */
static int hf_nr_rrc_spare5 = -1;                 /* NULL */
static int hf_nr_rrc_spare4 = -1;                 /* NULL */
static int hf_nr_rrc_criticalExtensionsFuture_05 = -1;  /* T_criticalExtensionsFuture_05 */
static int hf_nr_rrc_supportedBandListNRForPaging = -1;  /* SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicatorNR */
static int hf_nr_rrc_supportedBandListNRForPaging_item = -1;  /* FreqBandIndicatorNR */
static int hf_nr_rrc_nonCriticalExtension_21 = -1;  /* UERadioPagingInformation_v15e0_IEs */
static int hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeA_FDD_FR1 = -1;  /* T_dl_SchedulingOffset_PDSCH_TypeA_FDD_FR1 */
static int hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeA_TDD_FR1 = -1;  /* T_dl_SchedulingOffset_PDSCH_TypeA_TDD_FR1 */
static int hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeA_TDD_FR2 = -1;  /* T_dl_SchedulingOffset_PDSCH_TypeA_TDD_FR2 */
static int hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeB_FDD_FR1 = -1;  /* T_dl_SchedulingOffset_PDSCH_TypeB_FDD_FR1 */
static int hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeB_TDD_FR1 = -1;  /* T_dl_SchedulingOffset_PDSCH_TypeB_TDD_FR1 */
static int hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeB_TDD_FR2 = -1;  /* T_dl_SchedulingOffset_PDSCH_TypeB_TDD_FR2 */
static int hf_nr_rrc_nonCriticalExtension_22 = -1;  /* T_nonCriticalExtension_05 */
static int hf_nr_rrc_criticalExtensions_06 = -1;  /* T_criticalExtensions_06 */
static int hf_nr_rrc_c1_06 = -1;                  /* T_c1_06 */
static int hf_nr_rrc_ueRadioAccessCapabilityInformation = -1;  /* UERadioAccessCapabilityInformation_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_06 = -1;  /* T_criticalExtensionsFuture_06 */
static int hf_nr_rrc_ue_RadioAccessCapabilityInfo = -1;  /* T_ue_RadioAccessCapabilityInfo */
static int hf_nr_rrc_nonCriticalExtension_23 = -1;  /* T_nonCriticalExtension_06 */
static int hf_nr_rrc_message = -1;                /* BCCH_BCH_MessageType */
static int hf_nr_rrc_mib = -1;                    /* MIB */
static int hf_nr_rrc_messageClassExtension = -1;  /* T_messageClassExtension */
static int hf_nr_rrc_message_01 = -1;             /* BCCH_DL_SCH_MessageType */
static int hf_nr_rrc_c1_07 = -1;                  /* T_c1_07 */
static int hf_nr_rrc_systemInformation = -1;      /* SystemInformation */
static int hf_nr_rrc_systemInformationBlockType1 = -1;  /* SIB1 */
static int hf_nr_rrc_messageClassExtension_01 = -1;  /* T_messageClassExtension_01 */
static int hf_nr_rrc_message_02 = -1;             /* DL_CCCH_MessageType */
static int hf_nr_rrc_c1_08 = -1;                  /* T_c1_08 */
static int hf_nr_rrc_rrcReject = -1;              /* RRCReject */
static int hf_nr_rrc_rrcSetup = -1;               /* RRCSetup */
static int hf_nr_rrc_messageClassExtension_02 = -1;  /* T_messageClassExtension_02 */
static int hf_nr_rrc_message_03 = -1;             /* DL_DCCH_MessageType */
static int hf_nr_rrc_c1_09 = -1;                  /* T_c1_09 */
static int hf_nr_rrc_rrcReconfiguration_01 = -1;  /* RRCReconfiguration */
static int hf_nr_rrc_rrcResume = -1;              /* RRCResume */
static int hf_nr_rrc_rrcRelease = -1;             /* RRCRelease */
static int hf_nr_rrc_rrcReestablishment = -1;     /* RRCReestablishment */
static int hf_nr_rrc_securityModeCommand = -1;    /* SecurityModeCommand */
static int hf_nr_rrc_dlInformationTransfer = -1;  /* DLInformationTransfer */
static int hf_nr_rrc_ueCapabilityEnquiry = -1;    /* UECapabilityEnquiry */
static int hf_nr_rrc_counterCheck = -1;           /* CounterCheck */
static int hf_nr_rrc_mobilityFromNRCommand = -1;  /* MobilityFromNRCommand */
static int hf_nr_rrc_dlDedicatedMessageSegment_r16 = -1;  /* DLDedicatedMessageSegment_r16 */
static int hf_nr_rrc_ueInformationRequest_r16 = -1;  /* UEInformationRequest_r16 */
static int hf_nr_rrc_dlInformationTransferMRDC_r16 = -1;  /* DLInformationTransferMRDC_r16 */
static int hf_nr_rrc_loggedMeasurementConfiguration_r16 = -1;  /* LoggedMeasurementConfiguration_r16 */
static int hf_nr_rrc_messageClassExtension_03 = -1;  /* T_messageClassExtension_03 */
static int hf_nr_rrc_message_04 = -1;             /* PCCH_MessageType */
static int hf_nr_rrc_c1_10 = -1;                  /* T_c1_10 */
static int hf_nr_rrc_paging = -1;                 /* Paging */
static int hf_nr_rrc_messageClassExtension_04 = -1;  /* T_messageClassExtension_04 */
static int hf_nr_rrc_message_05 = -1;             /* UL_CCCH_MessageType */
static int hf_nr_rrc_c1_11 = -1;                  /* T_c1_11 */
static int hf_nr_rrc_rrcSetupRequest = -1;        /* RRCSetupRequest */
static int hf_nr_rrc_rrcResumeRequest = -1;       /* RRCResumeRequest */
static int hf_nr_rrc_rrcReestablishmentRequest = -1;  /* RRCReestablishmentRequest */
static int hf_nr_rrc_rrcSystemInfoRequest = -1;   /* RRCSystemInfoRequest */
static int hf_nr_rrc_messageClassExtension_05 = -1;  /* T_messageClassExtension_05 */
static int hf_nr_rrc_message_06 = -1;             /* UL_CCCH1_MessageType */
static int hf_nr_rrc_c1_12 = -1;                  /* T_c1_12 */
static int hf_nr_rrc_rrcResumeRequest1 = -1;      /* RRCResumeRequest1 */
static int hf_nr_rrc_messageClassExtension_06 = -1;  /* T_messageClassExtension_06 */
static int hf_nr_rrc_message_07 = -1;             /* UL_DCCH_MessageType */
static int hf_nr_rrc_c1_13 = -1;                  /* T_c1_13 */
static int hf_nr_rrc_measurementReport = -1;      /* MeasurementReport */
static int hf_nr_rrc_rrcReconfigurationComplete = -1;  /* RRCReconfigurationComplete */
static int hf_nr_rrc_rrcSetupComplete = -1;       /* RRCSetupComplete */
static int hf_nr_rrc_rrcReestablishmentComplete = -1;  /* RRCReestablishmentComplete */
static int hf_nr_rrc_rrcResumeComplete = -1;      /* RRCResumeComplete */
static int hf_nr_rrc_securityModeComplete = -1;   /* SecurityModeComplete */
static int hf_nr_rrc_securityModeFailure = -1;    /* SecurityModeFailure */
static int hf_nr_rrc_ulInformationTransfer = -1;  /* ULInformationTransfer */
static int hf_nr_rrc_locationMeasurementIndication = -1;  /* LocationMeasurementIndication */
static int hf_nr_rrc_ueCapabilityInformation = -1;  /* UECapabilityInformation */
static int hf_nr_rrc_counterCheckResponse = -1;   /* CounterCheckResponse */
static int hf_nr_rrc_ueAssistanceInformation_01 = -1;  /* UEAssistanceInformation */
static int hf_nr_rrc_failureInformation = -1;     /* FailureInformation */
static int hf_nr_rrc_ulInformationTransferMRDC = -1;  /* ULInformationTransferMRDC */
static int hf_nr_rrc_scgFailureInformation = -1;  /* SCGFailureInformation */
static int hf_nr_rrc_scgFailureInformationEUTRA = -1;  /* SCGFailureInformationEUTRA */
static int hf_nr_rrc_messageClassExtension_07 = -1;  /* T_messageClassExtension_07 */
static int hf_nr_rrc_c2 = -1;                     /* T_c2 */
static int hf_nr_rrc_ulDedicatedMessageSegment_r16 = -1;  /* ULDedicatedMessageSegment_r16 */
static int hf_nr_rrc_dedicatedSIBRequest_r16 = -1;  /* DedicatedSIBRequest_r16 */
static int hf_nr_rrc_mcgFailureInformation_r16 = -1;  /* MCGFailureInformation_r16 */
static int hf_nr_rrc_ueInformationResponse_r16 = -1;  /* UEInformationResponse_r16 */
static int hf_nr_rrc_sidelinkUEInformationNR_r16_02 = -1;  /* SidelinkUEInformationNR_r16 */
static int hf_nr_rrc_ulInformationTransferIRAT_r16 = -1;  /* ULInformationTransferIRAT_r16 */
static int hf_nr_rrc_iabOtherInformation_r16 = -1;  /* IABOtherInformation_r16 */
static int hf_nr_rrc_spare9 = -1;                 /* NULL */
static int hf_nr_rrc_spare8 = -1;                 /* NULL */
static int hf_nr_rrc_messageClassExtensionFuture_r16 = -1;  /* T_messageClassExtensionFuture_r16 */
static int hf_nr_rrc_rrc_TransactionIdentifier = -1;  /* RRC_TransactionIdentifier */
static int hf_nr_rrc_criticalExtensions_07 = -1;  /* T_criticalExtensions_07 */
static int hf_nr_rrc_counterCheck_01 = -1;        /* CounterCheck_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_07 = -1;  /* T_criticalExtensionsFuture_07 */
static int hf_nr_rrc_drb_CountMSB_InfoList = -1;  /* DRB_CountMSB_InfoList */
static int hf_nr_rrc_lateNonCriticalExtension = -1;  /* OCTET_STRING */
static int hf_nr_rrc_nonCriticalExtension_24 = -1;  /* T_nonCriticalExtension_07 */
static int hf_nr_rrc_DRB_CountMSB_InfoList_item = -1;  /* DRB_CountMSB_Info */
static int hf_nr_rrc_drb_Identity = -1;           /* DRB_Identity */
static int hf_nr_rrc_countMSB_Uplink = -1;        /* INTEGER_0_33554431 */
static int hf_nr_rrc_countMSB_Downlink = -1;      /* INTEGER_0_33554431 */
static int hf_nr_rrc_criticalExtensions_08 = -1;  /* T_criticalExtensions_08 */
static int hf_nr_rrc_counterCheckResponse_01 = -1;  /* CounterCheckResponse_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_08 = -1;  /* T_criticalExtensionsFuture_08 */
static int hf_nr_rrc_drb_CountInfoList = -1;      /* DRB_CountInfoList */
static int hf_nr_rrc_nonCriticalExtension_25 = -1;  /* T_nonCriticalExtension_08 */
static int hf_nr_rrc_DRB_CountInfoList_item = -1;  /* DRB_CountInfo */
static int hf_nr_rrc_count_Uplink = -1;           /* INTEGER_0_4294967295 */
static int hf_nr_rrc_count_Downlink = -1;         /* INTEGER_0_4294967295 */
static int hf_nr_rrc_criticalExtensions_09 = -1;  /* T_criticalExtensions_09 */
static int hf_nr_rrc_dedicatedSIBRequest_r16_01 = -1;  /* DedicatedSIBRequest_r16_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_09 = -1;  /* T_criticalExtensionsFuture_09 */
static int hf_nr_rrc_onDemandSIB_RequestList_r16 = -1;  /* T_onDemandSIB_RequestList_r16 */
static int hf_nr_rrc_requestedSIB_List_r16 = -1;  /* SEQUENCE_SIZE_1_maxOnDemandSIB_r16_OF_SIB_ReqInfo_r16 */
static int hf_nr_rrc_requestedSIB_List_r16_item = -1;  /* SIB_ReqInfo_r16 */
static int hf_nr_rrc_requestedPosSIB_List_r16 = -1;  /* SEQUENCE_SIZE_1_maxOnDemandPosSIB_r16_OF_PosSIB_ReqInfo_r16 */
static int hf_nr_rrc_requestedPosSIB_List_r16_item = -1;  /* PosSIB_ReqInfo_r16 */
static int hf_nr_rrc_nonCriticalExtension_26 = -1;  /* T_nonCriticalExtension_09 */
static int hf_nr_rrc_gnss_id_r16 = -1;            /* GNSS_ID_r16 */
static int hf_nr_rrc_sbas_id_r16 = -1;            /* SBAS_ID_r16 */
static int hf_nr_rrc_posSibType_r16 = -1;         /* T_posSibType_r16 */
static int hf_nr_rrc_criticalExtensions_10 = -1;  /* T_criticalExtensions_10 */
static int hf_nr_rrc_dlDedicatedMessageSegment_r16_01 = -1;  /* DLDedicatedMessageSegment_r16_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_10 = -1;  /* T_criticalExtensionsFuture_10 */
static int hf_nr_rrc_segmentNumber_r16 = -1;      /* INTEGER_0_4 */
static int hf_nr_rrc_rrc_MessageSegmentContainer_r16 = -1;  /* OCTET_STRING */
static int hf_nr_rrc_rrc_MessageSegmentType_r16 = -1;  /* T_rrc_MessageSegmentType_r16 */
static int hf_nr_rrc_nonCriticalExtension_27 = -1;  /* T_nonCriticalExtension_10 */
static int hf_nr_rrc_criticalExtensions_11 = -1;  /* T_criticalExtensions_11 */
static int hf_nr_rrc_dlInformationTransfer_01 = -1;  /* DLInformationTransfer_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_11 = -1;  /* T_criticalExtensionsFuture_11 */
static int hf_nr_rrc_dedicatedNAS_Message = -1;   /* DedicatedNAS_Message */
static int hf_nr_rrc_nonCriticalExtension_28 = -1;  /* DLInformationTransfer_v1610_IEs */
static int hf_nr_rrc_referenceTimeInfo_r16 = -1;  /* ReferenceTimeInfo_r16 */
static int hf_nr_rrc_nonCriticalExtension_29 = -1;  /* T_nonCriticalExtension_11 */
static int hf_nr_rrc_criticalExtensions_12 = -1;  /* T_criticalExtensions_12 */
static int hf_nr_rrc_c1_14 = -1;                  /* T_c1_14 */
static int hf_nr_rrc_dlInformationTransferMRDC_r16_01 = -1;  /* DLInformationTransferMRDC_r16_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_12 = -1;  /* T_criticalExtensionsFuture_12 */
static int hf_nr_rrc_dl_DCCH_MessageNR_r16 = -1;  /* T_dl_DCCH_MessageNR_r16 */
static int hf_nr_rrc_dl_DCCH_MessageEUTRA_r16 = -1;  /* T_dl_DCCH_MessageEUTRA_r16 */
static int hf_nr_rrc_nonCriticalExtension_30 = -1;  /* T_nonCriticalExtension_12 */
static int hf_nr_rrc_criticalExtensions_13 = -1;  /* T_criticalExtensions_13 */
static int hf_nr_rrc_failureInformation_01 = -1;  /* FailureInformation_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_13 = -1;  /* T_criticalExtensionsFuture_13 */
static int hf_nr_rrc_failureInfoRLC_Bearer = -1;  /* FailureInfoRLC_Bearer */
static int hf_nr_rrc_nonCriticalExtension_31 = -1;  /* FailureInformation_v1610_IEs */
static int hf_nr_rrc_cellGroupId = -1;            /* CellGroupId */
static int hf_nr_rrc_logicalChannelIdentity = -1;  /* LogicalChannelIdentity */
static int hf_nr_rrc_failureType_01 = -1;         /* T_failureType_01 */
static int hf_nr_rrc_failureInfoDAPS_r16 = -1;    /* FailureInfoDAPS_r16 */
static int hf_nr_rrc_nonCriticalExtension_32 = -1;  /* T_nonCriticalExtension_13 */
static int hf_nr_rrc_failureType_r16_01 = -1;     /* T_failureType_r16_01 */
static int hf_nr_rrc_criticalExtensions_14 = -1;  /* T_criticalExtensions_14 */
static int hf_nr_rrc_iabOtherInformation_r16_01 = -1;  /* IABOtherInformation_r16_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_14 = -1;  /* T_criticalExtensionsFuture_14 */
static int hf_nr_rrc_ip_InfoType_r16 = -1;        /* T_ip_InfoType_r16 */
static int hf_nr_rrc_iab_IP_Request_r16 = -1;     /* T_iab_IP_Request_r16 */
static int hf_nr_rrc_iab_IPv4_AddressNumReq_r16 = -1;  /* IAB_IP_AddressNumReq_r16 */
static int hf_nr_rrc_iab_IPv6_AddressReq_r16 = -1;  /* T_iab_IPv6_AddressReq_r16 */
static int hf_nr_rrc_iab_IPv6_AddressNumReq_r16 = -1;  /* IAB_IP_AddressNumReq_r16 */
static int hf_nr_rrc_iab_IPv6_AddressPrefixReq_r16 = -1;  /* IAB_IP_AddressPrefixReq_r16 */
static int hf_nr_rrc_iab_IP_Report_r16 = -1;      /* T_iab_IP_Report_r16 */
static int hf_nr_rrc_iab_IPv4_AddressReport_r16 = -1;  /* IAB_IP_AddressAndTraffic_r16 */
static int hf_nr_rrc_iab_IPv6_Report_r16 = -1;    /* T_iab_IPv6_Report_r16 */
static int hf_nr_rrc_iab_IPv6_AddressReport_r16 = -1;  /* IAB_IP_AddressAndTraffic_r16 */
static int hf_nr_rrc_iab_IPv6_PrefixReport_r16 = -1;  /* IAB_IP_PrefixAndTraffic_r16 */
static int hf_nr_rrc_nonCriticalExtension_33 = -1;  /* T_nonCriticalExtension_14 */
static int hf_nr_rrc_all_Traffic_NumReq_r16 = -1;  /* INTEGER_1_8 */
static int hf_nr_rrc_f1_C_Traffic_NumReq_r16 = -1;  /* INTEGER_1_8 */
static int hf_nr_rrc_f1_U_Traffic_NumReq_r16 = -1;  /* INTEGER_1_8 */
static int hf_nr_rrc_non_F1_Traffic_NumReq_r16 = -1;  /* INTEGER_1_8 */
static int hf_nr_rrc_all_Traffic_PrefixReq_r16 = -1;  /* T_all_Traffic_PrefixReq_r16 */
static int hf_nr_rrc_f1_C_Traffic_PrefixReq_r16 = -1;  /* T_f1_C_Traffic_PrefixReq_r16 */
static int hf_nr_rrc_f1_U_Traffic_PrefixReq_r16 = -1;  /* T_f1_U_Traffic_PrefixReq_r16 */
static int hf_nr_rrc_non_F1_Traffic_PrefixReq_r16 = -1;  /* T_non_F1_Traffic_PrefixReq_r16 */
static int hf_nr_rrc_all_Traffic_IAB_IP_Address_r16 = -1;  /* SEQUENCE_SIZE_1_8_OF_IAB_IP_Address_r16 */
static int hf_nr_rrc_all_Traffic_IAB_IP_Address_r16_item = -1;  /* IAB_IP_Address_r16 */
static int hf_nr_rrc_f1_C_Traffic_IP_Address_r16 = -1;  /* SEQUENCE_SIZE_1_8_OF_IAB_IP_Address_r16 */
static int hf_nr_rrc_f1_C_Traffic_IP_Address_r16_item = -1;  /* IAB_IP_Address_r16 */
static int hf_nr_rrc_f1_U_Traffic_IP_Address_r16 = -1;  /* SEQUENCE_SIZE_1_8_OF_IAB_IP_Address_r16 */
static int hf_nr_rrc_f1_U_Traffic_IP_Address_r16_item = -1;  /* IAB_IP_Address_r16 */
static int hf_nr_rrc_non_F1_Traffic_IP_Address_r16 = -1;  /* SEQUENCE_SIZE_1_8_OF_IAB_IP_Address_r16 */
static int hf_nr_rrc_non_F1_Traffic_IP_Address_r16_item = -1;  /* IAB_IP_Address_r16 */
static int hf_nr_rrc_all_Traffic_IAB_IP_Address_r16_01 = -1;  /* IAB_IP_Address_r16 */
static int hf_nr_rrc_f1_C_Traffic_IP_Address_r16_01 = -1;  /* IAB_IP_Address_r16 */
static int hf_nr_rrc_f1_U_Traffic_IP_Address_r16_01 = -1;  /* IAB_IP_Address_r16 */
static int hf_nr_rrc_non_F1_Traffic_IP_Address_r16_01 = -1;  /* IAB_IP_Address_r16 */
static int hf_nr_rrc_criticalExtensions_15 = -1;  /* T_criticalExtensions_15 */
static int hf_nr_rrc_locationMeasurementIndication_01 = -1;  /* LocationMeasurementIndication_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_15 = -1;  /* T_criticalExtensionsFuture_15 */
static int hf_nr_rrc_measurementIndication = -1;  /* T_measurementIndication */
static int hf_nr_rrc_setup_01 = -1;               /* LocationMeasurementInfo */
static int hf_nr_rrc_nonCriticalExtension_34 = -1;  /* T_nonCriticalExtension_15 */
static int hf_nr_rrc_criticalExtensions_16 = -1;  /* T_criticalExtensions_16 */
static int hf_nr_rrc_loggedMeasurementConfiguration_r16_01 = -1;  /* LoggedMeasurementConfiguration_r16_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_16 = -1;  /* T_criticalExtensionsFuture_16 */
static int hf_nr_rrc_traceReference_r16 = -1;     /* TraceReference_r16 */
static int hf_nr_rrc_traceRecordingSessionRef_r16 = -1;  /* OCTET_STRING_SIZE_2 */
static int hf_nr_rrc_tce_Id_r16 = -1;             /* OCTET_STRING_SIZE_1 */
static int hf_nr_rrc_absoluteTimeInfo_r16 = -1;   /* AbsoluteTimeInfo_r16 */
static int hf_nr_rrc_areaConfiguration_r16 = -1;  /* AreaConfiguration_r16 */
static int hf_nr_rrc_plmn_IdentityList_r16 = -1;  /* PLMN_IdentityList2_r16 */
static int hf_nr_rrc_bt_NameList_r16 = -1;        /* T_bt_NameList_r16 */
static int hf_nr_rrc_setup_02 = -1;               /* BT_NameList_r16 */
static int hf_nr_rrc_wlan_NameList_r16 = -1;      /* T_wlan_NameList_r16 */
static int hf_nr_rrc_setup_03 = -1;               /* WLAN_NameList_r16 */
static int hf_nr_rrc_sensor_NameList_r16 = -1;    /* T_sensor_NameList_r16 */
static int hf_nr_rrc_setup_04 = -1;               /* Sensor_NameList_r16 */
static int hf_nr_rrc_loggingDuration_r16 = -1;    /* LoggingDuration_r16 */
static int hf_nr_rrc_reportType = -1;             /* T_reportType */
static int hf_nr_rrc_periodical = -1;             /* LoggedPeriodicalReportConfig_r16 */
static int hf_nr_rrc_eventTriggered = -1;         /* LoggedEventTriggerConfig_r16 */
static int hf_nr_rrc_nonCriticalExtension_35 = -1;  /* T_nonCriticalExtension_16 */
static int hf_nr_rrc_loggingInterval_r16 = -1;    /* LoggingInterval_r16 */
static int hf_nr_rrc_eventType_r16 = -1;          /* EventType_r16 */
static int hf_nr_rrc_outOfCoverage = -1;          /* NULL */
static int hf_nr_rrc_eventL1 = -1;                /* T_eventL1 */
static int hf_nr_rrc_l1_Threshold = -1;           /* MeasTriggerQuantity */
static int hf_nr_rrc_hysteresis = -1;             /* Hysteresis */
static int hf_nr_rrc_timeToTrigger = -1;          /* TimeToTrigger */
static int hf_nr_rrc_criticalExtensions_17 = -1;  /* T_criticalExtensions_17 */
static int hf_nr_rrc_mcgFailureInformation_r16_01 = -1;  /* MCGFailureInformation_r16_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_17 = -1;  /* T_criticalExtensionsFuture_17 */
static int hf_nr_rrc_failureReportMCG_r16 = -1;   /* FailureReportMCG_r16 */
static int hf_nr_rrc_nonCriticalExtension_36 = -1;  /* T_nonCriticalExtension_17 */
static int hf_nr_rrc_failureType_r16_02 = -1;     /* T_failureType_r16_02 */
static int hf_nr_rrc_measResultFreqList_r16 = -1;  /* MeasResultList2NR */
static int hf_nr_rrc_measResultFreqListEUTRA_r16 = -1;  /* MeasResultList2EUTRA */
static int hf_nr_rrc_measResultSCG_r16_01 = -1;   /* T_measResultSCG_r16_01 */
static int hf_nr_rrc_measResultSCG_EUTRA_r16_01 = -1;  /* T_measResultSCG_EUTRA_r16 */
static int hf_nr_rrc_measResultFreqListUTRA_FDD_r16 = -1;  /* MeasResultList2UTRA */
static int hf_nr_rrc_MeasResultList2UTRA_item = -1;  /* MeasResult2UTRA_FDD_r16 */
static int hf_nr_rrc_carrierFreq_r16 = -1;        /* ARFCN_ValueUTRA_FDD_r16 */
static int hf_nr_rrc_measResultNeighCellList_r16 = -1;  /* MeasResultListUTRA_FDD_r16 */
static int hf_nr_rrc_MeasResultList2EUTRA_item = -1;  /* MeasResult2EUTRA_r16 */
static int hf_nr_rrc_criticalExtensions_18 = -1;  /* T_criticalExtensions_18 */
static int hf_nr_rrc_measurementReport_01 = -1;   /* MeasurementReport_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_18 = -1;  /* T_criticalExtensionsFuture_18 */
static int hf_nr_rrc_measResults = -1;            /* MeasResults */
static int hf_nr_rrc_nonCriticalExtension_37 = -1;  /* T_nonCriticalExtension_18 */
static int hf_nr_rrc_systemFrameNumber = -1;      /* BIT_STRING_SIZE_6 */
static int hf_nr_rrc_subCarrierSpacingCommon = -1;  /* T_subCarrierSpacingCommon */
static int hf_nr_rrc_ssb_SubcarrierOffset = -1;   /* INTEGER_0_15 */
static int hf_nr_rrc_dmrs_TypeA_Position = -1;    /* T_dmrs_TypeA_Position */
static int hf_nr_rrc_pdcch_ConfigSIB1 = -1;       /* PDCCH_ConfigSIB1 */
static int hf_nr_rrc_cellBarred = -1;             /* T_cellBarred */
static int hf_nr_rrc_intraFreqReselection = -1;   /* T_intraFreqReselection */
static int hf_nr_rrc_spare = -1;                  /* BIT_STRING_SIZE_1 */
static int hf_nr_rrc_criticalExtensions_19 = -1;  /* T_criticalExtensions_19 */
static int hf_nr_rrc_mobilityFromNRCommand_01 = -1;  /* MobilityFromNRCommand_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_19 = -1;  /* T_criticalExtensionsFuture_19 */
static int hf_nr_rrc_targetRAT_Type = -1;         /* T_targetRAT_Type */
static int hf_nr_rrc_targetRAT_MessageContainer = -1;  /* T_targetRAT_MessageContainer */
static int hf_nr_rrc_nas_SecurityParamFromNR = -1;  /* T_nas_SecurityParamFromNR */
static int hf_nr_rrc_nonCriticalExtension_38 = -1;  /* MobilityFromNRCommand_v1610_IEs */
static int hf_nr_rrc_voiceFallbackIndication_r16 = -1;  /* T_voiceFallbackIndication_r16 */
static int hf_nr_rrc_nonCriticalExtension_39 = -1;  /* T_nonCriticalExtension_19 */
static int hf_nr_rrc_pagingRecordList = -1;       /* PagingRecordList */
static int hf_nr_rrc_nonCriticalExtension_40 = -1;  /* T_nonCriticalExtension_20 */
static int hf_nr_rrc_PagingRecordList_item = -1;  /* PagingRecord */
static int hf_nr_rrc_ue_Identity = -1;            /* PagingUE_Identity */
static int hf_nr_rrc_accessType = -1;             /* T_accessType */
static int hf_nr_rrc_ng_5G_S_TMSI = -1;           /* NG_5G_S_TMSI */
static int hf_nr_rrc_fullI_RNTI = -1;             /* I_RNTI_Value */
static int hf_nr_rrc_criticalExtensions_20 = -1;  /* T_criticalExtensions_20 */
static int hf_nr_rrc_rrcReestablishment_01 = -1;  /* RRCReestablishment_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_20 = -1;  /* T_criticalExtensionsFuture_20 */
static int hf_nr_rrc_nextHopChainingCount = -1;   /* NextHopChainingCount */
static int hf_nr_rrc_nonCriticalExtension_41 = -1;  /* T_nonCriticalExtension_21 */
static int hf_nr_rrc_criticalExtensions_21 = -1;  /* T_criticalExtensions_21 */
static int hf_nr_rrc_rrcReestablishmentComplete_01 = -1;  /* RRCReestablishmentComplete_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_21 = -1;  /* T_criticalExtensionsFuture_21 */
static int hf_nr_rrc_nonCriticalExtension_42 = -1;  /* RRCReestablishmentComplete_v1610_IEs */
static int hf_nr_rrc_ue_MeasurementsAvailable_r16 = -1;  /* UE_MeasurementsAvailable_r16 */
static int hf_nr_rrc_nonCriticalExtension_43 = -1;  /* T_nonCriticalExtension_22 */
static int hf_nr_rrc_rrcReestablishmentRequest_01 = -1;  /* RRCReestablishmentRequest_IEs */
static int hf_nr_rrc_ue_Identity_01 = -1;         /* ReestabUE_Identity */
static int hf_nr_rrc_reestablishmentCause = -1;   /* ReestablishmentCause */
static int hf_nr_rrc_c_RNTI = -1;                 /* RNTI_Value */
static int hf_nr_rrc_criticalExtensions_22 = -1;  /* T_criticalExtensions_22 */
static int hf_nr_rrc_rrcReconfiguration_02 = -1;  /* RRCReconfiguration_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_22 = -1;  /* T_criticalExtensionsFuture_22 */
static int hf_nr_rrc_radioBearerConfig = -1;      /* RadioBearerConfig */
static int hf_nr_rrc_secondaryCellGroup = -1;     /* T_secondaryCellGroup */
static int hf_nr_rrc_measConfig = -1;             /* MeasConfig */
static int hf_nr_rrc_nonCriticalExtension_44 = -1;  /* RRCReconfiguration_v1530_IEs */
static int hf_nr_rrc_masterCellGroup = -1;        /* T_masterCellGroup */
static int hf_nr_rrc_fullConfig = -1;             /* T_fullConfig */
static int hf_nr_rrc_dedicatedNAS_MessageList = -1;  /* SEQUENCE_SIZE_1_maxDRB_OF_DedicatedNAS_Message */
static int hf_nr_rrc_dedicatedNAS_MessageList_item = -1;  /* DedicatedNAS_Message */
static int hf_nr_rrc_masterKeyUpdate = -1;        /* MasterKeyUpdate */
static int hf_nr_rrc_dedicatedSIB1_Delivery = -1;  /* T_dedicatedSIB1_Delivery */
static int hf_nr_rrc_dedicatedSystemInformationDelivery = -1;  /* T_dedicatedSystemInformationDelivery */
static int hf_nr_rrc_otherConfig = -1;            /* OtherConfig */
static int hf_nr_rrc_nonCriticalExtension_45 = -1;  /* RRCReconfiguration_v1540_IEs */
static int hf_nr_rrc_otherConfig_v1540 = -1;      /* OtherConfig_v1540 */
static int hf_nr_rrc_nonCriticalExtension_46 = -1;  /* RRCReconfiguration_v1560_IEs */
static int hf_nr_rrc_mrdc_SecondaryCellGroupConfig = -1;  /* T_mrdc_SecondaryCellGroupConfig */
static int hf_nr_rrc_setup_05 = -1;               /* MRDC_SecondaryCellGroupConfig */
static int hf_nr_rrc_radioBearerConfig2 = -1;     /* T_radioBearerConfig2 */
static int hf_nr_rrc_sk_Counter = -1;             /* SK_Counter */
static int hf_nr_rrc_nonCriticalExtension_47 = -1;  /* RRCReconfiguration_v1610_IEs */
static int hf_nr_rrc_otherConfig_v1610 = -1;      /* OtherConfig_v1610 */
static int hf_nr_rrc_bap_Config_r16 = -1;         /* T_bap_Config_r16 */
static int hf_nr_rrc_setup_06 = -1;               /* BAP_Config_r16 */
static int hf_nr_rrc_iab_IP_AddressConfigurationList_r16 = -1;  /* IAB_IP_AddressConfigurationList_r16 */
static int hf_nr_rrc_conditionalReconfiguration_r16 = -1;  /* ConditionalReconfiguration_r16 */
static int hf_nr_rrc_daps_SourceRelease_r16 = -1;  /* T_daps_SourceRelease_r16 */
static int hf_nr_rrc_t316_r16 = -1;               /* T_t316_r16 */
static int hf_nr_rrc_setup_07 = -1;               /* T316_r16 */
static int hf_nr_rrc_needForGapsConfigNR_r16 = -1;  /* T_needForGapsConfigNR_r16 */
static int hf_nr_rrc_setup_08 = -1;               /* NeedForGapsConfigNR_r16 */
static int hf_nr_rrc_onDemandSIB_Request_r16 = -1;  /* T_onDemandSIB_Request_r16 */
static int hf_nr_rrc_setup_09 = -1;               /* OnDemandSIB_Request_r16 */
static int hf_nr_rrc_dedicatedPosSysInfoDelivery_r16 = -1;  /* T_dedicatedPosSysInfoDelivery_r16 */
static int hf_nr_rrc_sl_ConfigDedicatedNR_r16 = -1;  /* T_sl_ConfigDedicatedNR_r16 */
static int hf_nr_rrc_setup_10 = -1;               /* SL_ConfigDedicatedNR_r16 */
static int hf_nr_rrc_sl_ConfigDedicatedEUTRA_Info_r16 = -1;  /* T_sl_ConfigDedicatedEUTRA_Info_r16 */
static int hf_nr_rrc_setup_11 = -1;               /* SL_ConfigDedicatedEUTRA_Info_r16 */
static int hf_nr_rrc_targetCellSMTC_SCG_r16 = -1;  /* SSB_MTC */
static int hf_nr_rrc_nonCriticalExtension_48 = -1;  /* T_nonCriticalExtension_23 */
static int hf_nr_rrc_mrdc_ReleaseAndAdd = -1;     /* T_mrdc_ReleaseAndAdd */
static int hf_nr_rrc_mrdc_SecondaryCellGroup = -1;  /* T_mrdc_SecondaryCellGroup */
static int hf_nr_rrc_nr_SCG = -1;                 /* T_nr_SCG */
static int hf_nr_rrc_eutra_SCG = -1;              /* T_eutra_SCG */
static int hf_nr_rrc_bap_Address_r16 = -1;        /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_defaultUL_BAP_RoutingID_r16 = -1;  /* BAP_RoutingID_r16 */
static int hf_nr_rrc_defaultUL_BH_RLC_Channel_r16 = -1;  /* BH_RLC_ChannelID_r16 */
static int hf_nr_rrc_flowControlFeedbackType_r16 = -1;  /* T_flowControlFeedbackType_r16 */
static int hf_nr_rrc_keySetChangeIndicator = -1;  /* BOOLEAN */
static int hf_nr_rrc_nas_Container = -1;          /* T_nas_Container */
static int hf_nr_rrc_onDemandSIB_RequestProhibitTimer_r16 = -1;  /* T_onDemandSIB_RequestProhibitTimer_r16 */
static int hf_nr_rrc_iab_IP_AddressToAddModList_r16 = -1;  /* SEQUENCE_SIZE_1_maxIAB_IP_Address_r16_OF_IAB_IP_AddressConfiguration_r16 */
static int hf_nr_rrc_iab_IP_AddressToAddModList_r16_item = -1;  /* IAB_IP_AddressConfiguration_r16 */
static int hf_nr_rrc_iab_IP_AddressToReleaseList_r16 = -1;  /* SEQUENCE_SIZE_1_maxIAB_IP_Address_r16_OF_IAB_IP_AddressIndex_r16 */
static int hf_nr_rrc_iab_IP_AddressToReleaseList_r16_item = -1;  /* IAB_IP_AddressIndex_r16 */
static int hf_nr_rrc_iab_IP_AddressIndex_r16 = -1;  /* IAB_IP_AddressIndex_r16 */
static int hf_nr_rrc_iab_IP_Address_r16 = -1;     /* IAB_IP_Address_r16 */
static int hf_nr_rrc_iab_IP_Usage_r16 = -1;       /* IAB_IP_Usage_r16 */
static int hf_nr_rrc_iab_donor_DU_BAP_Address_r16 = -1;  /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_sl_ConfigDedicatedEUTRA_r16 = -1;  /* T_sl_ConfigDedicatedEUTRA_r16 */
static int hf_nr_rrc_sl_TimeOffsetEUTRA_List_r16 = -1;  /* SEQUENCE_SIZE_8_OF_SL_TimeOffsetEUTRA_r16 */
static int hf_nr_rrc_sl_TimeOffsetEUTRA_List_r16_item = -1;  /* SL_TimeOffsetEUTRA_r16 */
static int hf_nr_rrc_criticalExtensions_23 = -1;  /* T_criticalExtensions_23 */
static int hf_nr_rrc_rrcReconfigurationComplete_01 = -1;  /* RRCReconfigurationComplete_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_23 = -1;  /* T_criticalExtensionsFuture_23 */
static int hf_nr_rrc_nonCriticalExtension_49 = -1;  /* RRCReconfigurationComplete_v1530_IEs */
static int hf_nr_rrc_uplinkTxDirectCurrentList = -1;  /* UplinkTxDirectCurrentList */
static int hf_nr_rrc_nonCriticalExtension_50 = -1;  /* RRCReconfigurationComplete_v1560_IEs */
static int hf_nr_rrc_scg_Response = -1;           /* T_scg_Response */
static int hf_nr_rrc_nr_SCG_Response = -1;        /* T_nr_SCG_Response */
static int hf_nr_rrc_eutra_SCG_Response = -1;     /* T_eutra_SCG_Response */
static int hf_nr_rrc_nonCriticalExtension_51 = -1;  /* RRCReconfigurationComplete_v1610_IEs */
static int hf_nr_rrc_nonCriticalExtension_52 = -1;  /* RRCReconfigurationComplete_v1640_IEs */
static int hf_nr_rrc_uplinkTxDirectCurrentTwoCarrierList_r16 = -1;  /* UplinkTxDirectCurrentTwoCarrierList_r16 */
static int hf_nr_rrc_nonCriticalExtension_53 = -1;  /* T_nonCriticalExtension_24 */
static int hf_nr_rrc_criticalExtensions_24 = -1;  /* T_criticalExtensions_24 */
static int hf_nr_rrc_rrcReject_01 = -1;           /* RRCReject_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_24 = -1;  /* T_criticalExtensionsFuture_24 */
static int hf_nr_rrc_waitTime = -1;               /* RejectWaitTime */
static int hf_nr_rrc_nonCriticalExtension_54 = -1;  /* T_nonCriticalExtension_25 */
static int hf_nr_rrc_criticalExtensions_25 = -1;  /* T_criticalExtensions_25 */
static int hf_nr_rrc_rrcRelease_01 = -1;          /* RRCRelease_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_25 = -1;  /* T_criticalExtensionsFuture_25 */
static int hf_nr_rrc_redirectedCarrierInfo = -1;  /* RedirectedCarrierInfo */
static int hf_nr_rrc_cellReselectionPriorities = -1;  /* CellReselectionPriorities */
static int hf_nr_rrc_suspendConfig = -1;          /* SuspendConfig */
static int hf_nr_rrc_deprioritisationReq = -1;    /* T_deprioritisationReq */
static int hf_nr_rrc_deprioritisationType = -1;   /* T_deprioritisationType */
static int hf_nr_rrc_deprioritisationTimer = -1;  /* T_deprioritisationTimer */
static int hf_nr_rrc_nonCriticalExtension_55 = -1;  /* RRCRelease_v1540_IEs */
static int hf_nr_rrc_nonCriticalExtension_56 = -1;  /* RRCRelease_v1610_IEs */
static int hf_nr_rrc_voiceFallbackIndication_r16_01 = -1;  /* T_voiceFallbackIndication_r16_01 */
static int hf_nr_rrc_measIdleConfig_r16 = -1;     /* T_measIdleConfig_r16 */
static int hf_nr_rrc_setup_12 = -1;               /* MeasIdleConfigDedicated_r16 */
static int hf_nr_rrc_nonCriticalExtension_57 = -1;  /* RRCRelease_v1650_IEs */
static int hf_nr_rrc_mpsPriorityIndication_r16 = -1;  /* T_mpsPriorityIndication_r16 */
static int hf_nr_rrc_nonCriticalExtension_58 = -1;  /* T_nonCriticalExtension_26 */
static int hf_nr_rrc_nr = -1;                     /* CarrierInfoNR */
static int hf_nr_rrc_eutra = -1;                  /* RedirectedCarrierInfo_EUTRA */
static int hf_nr_rrc_cnType = -1;                 /* T_cnType */
static int hf_nr_rrc_smtc = -1;                   /* SSB_MTC */
static int hf_nr_rrc_shortI_RNTI = -1;            /* ShortI_RNTI_Value */
static int hf_nr_rrc_ran_PagingCycle = -1;        /* PagingCycle */
static int hf_nr_rrc_t380 = -1;                   /* PeriodicRNAU_TimerValue */
static int hf_nr_rrc_freqPriorityListEUTRA = -1;  /* FreqPriorityListEUTRA */
static int hf_nr_rrc_freqPriorityListNR = -1;     /* FreqPriorityListNR */
static int hf_nr_rrc_t320 = -1;                   /* T_t320 */
static int hf_nr_rrc_FreqPriorityListEUTRA_item = -1;  /* FreqPriorityEUTRA */
static int hf_nr_rrc_FreqPriorityListNR_item = -1;  /* FreqPriorityNR */
static int hf_nr_rrc_carrierFreq_01 = -1;         /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_cellReselectionPriority = -1;  /* CellReselectionPriority */
static int hf_nr_rrc_cellReselectionSubPriority = -1;  /* CellReselectionSubPriority */
static int hf_nr_rrc_cellList = -1;               /* PLMN_RAN_AreaCellList */
static int hf_nr_rrc_ran_AreaConfigList = -1;     /* PLMN_RAN_AreaConfigList */
static int hf_nr_rrc_PLMN_RAN_AreaCellList_item = -1;  /* PLMN_RAN_AreaCell */
static int hf_nr_rrc_plmn_Identity = -1;          /* PLMN_Identity */
static int hf_nr_rrc_ran_AreaCells = -1;          /* SEQUENCE_SIZE_1_32_OF_CellIdentity */
static int hf_nr_rrc_ran_AreaCells_item = -1;     /* CellIdentity */
static int hf_nr_rrc_PLMN_RAN_AreaConfigList_item = -1;  /* PLMN_RAN_AreaConfig */
static int hf_nr_rrc_ran_Area = -1;               /* SEQUENCE_SIZE_1_16_OF_RAN_AreaConfig */
static int hf_nr_rrc_ran_Area_item = -1;          /* RAN_AreaConfig */
static int hf_nr_rrc_trackingAreaCode = -1;       /* TrackingAreaCode */
static int hf_nr_rrc_ran_AreaCodeList = -1;       /* SEQUENCE_SIZE_1_32_OF_RAN_AreaCode */
static int hf_nr_rrc_ran_AreaCodeList_item = -1;  /* RAN_AreaCode */
static int hf_nr_rrc_criticalExtensions_26 = -1;  /* T_criticalExtensions_26 */
static int hf_nr_rrc_rrcResume_01 = -1;           /* RRCResume_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_26 = -1;  /* T_criticalExtensionsFuture_26 */
static int hf_nr_rrc_masterCellGroup_01 = -1;     /* T_masterCellGroup_01 */
static int hf_nr_rrc_fullConfig_01 = -1;          /* T_fullConfig_01 */
static int hf_nr_rrc_nonCriticalExtension_59 = -1;  /* RRCResume_v1560_IEs */
static int hf_nr_rrc_radioBearerConfig2_01 = -1;  /* T_radioBearerConfig2_01 */
static int hf_nr_rrc_nonCriticalExtension_60 = -1;  /* RRCResume_v1610_IEs */
static int hf_nr_rrc_idleModeMeasurementReq_r16 = -1;  /* T_idleModeMeasurementReq_r16 */
static int hf_nr_rrc_restoreMCG_SCells_r16 = -1;  /* T_restoreMCG_SCells_r16 */
static int hf_nr_rrc_restoreSCG_r16 = -1;         /* T_restoreSCG_r16 */
static int hf_nr_rrc_mrdc_SecondaryCellGroup_r16 = -1;  /* T_mrdc_SecondaryCellGroup_r16 */
static int hf_nr_rrc_nr_SCG_r16 = -1;             /* T_nr_SCG_r16 */
static int hf_nr_rrc_eutra_SCG_r16 = -1;          /* T_eutra_SCG_r16 */
static int hf_nr_rrc_needForGapsConfigNR_r16_01 = -1;  /* T_needForGapsConfigNR_r16_01 */
static int hf_nr_rrc_nonCriticalExtension_61 = -1;  /* T_nonCriticalExtension_27 */
static int hf_nr_rrc_criticalExtensions_27 = -1;  /* T_criticalExtensions_27 */
static int hf_nr_rrc_rrcResumeComplete_01 = -1;   /* RRCResumeComplete_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_27 = -1;  /* T_criticalExtensionsFuture_27 */
static int hf_nr_rrc_selectedPLMN_Identity = -1;  /* INTEGER_1_maxPLMN */
static int hf_nr_rrc_nonCriticalExtension_62 = -1;  /* RRCResumeComplete_v1610_IEs */
static int hf_nr_rrc_idleMeasAvailable_r16 = -1;  /* T_idleMeasAvailable_r16 */
static int hf_nr_rrc_measResultIdleEUTRA_r16 = -1;  /* MeasResultIdleEUTRA_r16 */
static int hf_nr_rrc_measResultIdleNR_r16 = -1;   /* MeasResultIdleNR_r16 */
static int hf_nr_rrc_scg_Response_r16 = -1;       /* T_scg_Response_r16 */
static int hf_nr_rrc_nr_SCG_Response_01 = -1;     /* T_nr_SCG_Response_01 */
static int hf_nr_rrc_eutra_SCG_Response_01 = -1;  /* T_eutra_SCG_Response_01 */
static int hf_nr_rrc_mobilityHistoryAvail_r16 = -1;  /* T_mobilityHistoryAvail_r16 */
static int hf_nr_rrc_mobilityState_r16 = -1;      /* T_mobilityState_r16 */
static int hf_nr_rrc_nonCriticalExtension_63 = -1;  /* RRCResumeComplete_v1640_IEs */
static int hf_nr_rrc_nonCriticalExtension_64 = -1;  /* T_nonCriticalExtension_28 */
static int hf_nr_rrc_rrcResumeRequest_01 = -1;    /* RRCResumeRequest_IEs */
static int hf_nr_rrc_resumeIdentity = -1;         /* ShortI_RNTI_Value */
static int hf_nr_rrc_resumeMAC_I = -1;            /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_resumeCause = -1;            /* ResumeCause */
static int hf_nr_rrc_rrcResumeRequest1_01 = -1;   /* RRCResumeRequest1_IEs */
static int hf_nr_rrc_resumeIdentity_01 = -1;      /* I_RNTI_Value */
static int hf_nr_rrc_criticalExtensions_28 = -1;  /* T_criticalExtensions_28 */
static int hf_nr_rrc_rrcSetup_01 = -1;            /* RRCSetup_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_28 = -1;  /* T_criticalExtensionsFuture_28 */
static int hf_nr_rrc_masterCellGroup_02 = -1;     /* T_masterCellGroup_02 */
static int hf_nr_rrc_nonCriticalExtension_65 = -1;  /* T_nonCriticalExtension_29 */
static int hf_nr_rrc_criticalExtensions_29 = -1;  /* T_criticalExtensions_29 */
static int hf_nr_rrc_rrcSetupComplete_01 = -1;    /* RRCSetupComplete_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_29 = -1;  /* T_criticalExtensionsFuture_29 */
static int hf_nr_rrc_registeredAMF = -1;          /* RegisteredAMF */
static int hf_nr_rrc_guami_Type = -1;             /* T_guami_Type */
static int hf_nr_rrc_s_NSSAI_List = -1;           /* SEQUENCE_SIZE_1_maxNrofS_NSSAI_OF_S_NSSAI */
static int hf_nr_rrc_s_NSSAI_List_item = -1;      /* S_NSSAI */
static int hf_nr_rrc_ng_5G_S_TMSI_Value = -1;     /* T_ng_5G_S_TMSI_Value */
static int hf_nr_rrc_ng_5G_S_TMSI_Part2 = -1;     /* BIT_STRING_SIZE_9 */
static int hf_nr_rrc_nonCriticalExtension_66 = -1;  /* RRCSetupComplete_v1610_IEs */
static int hf_nr_rrc_iab_NodeIndication_r16 = -1;  /* T_iab_NodeIndication_r16 */
static int hf_nr_rrc_idleMeasAvailable_r16_01 = -1;  /* T_idleMeasAvailable_r16_01 */
static int hf_nr_rrc_mobilityHistoryAvail_r16_01 = -1;  /* T_mobilityHistoryAvail_r16_01 */
static int hf_nr_rrc_mobilityState_r16_01 = -1;   /* T_mobilityState_r16_01 */
static int hf_nr_rrc_nonCriticalExtension_67 = -1;  /* T_nonCriticalExtension_30 */
static int hf_nr_rrc_amf_Identifier = -1;         /* AMF_Identifier */
static int hf_nr_rrc_rrcSetupRequest_01 = -1;     /* RRCSetupRequest_IEs */
static int hf_nr_rrc_ue_Identity_02 = -1;         /* InitialUE_Identity */
static int hf_nr_rrc_establishmentCause = -1;     /* EstablishmentCause */
static int hf_nr_rrc_ng_5G_S_TMSI_Part1 = -1;     /* BIT_STRING_SIZE_39 */
static int hf_nr_rrc_randomValue = -1;            /* BIT_STRING_SIZE_39 */
static int hf_nr_rrc_criticalExtensions_30 = -1;  /* T_criticalExtensions_30 */
static int hf_nr_rrc_rrcSystemInfoRequest_01 = -1;  /* RRCSystemInfoRequest_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_r16 = -1;  /* T_criticalExtensionsFuture_r16 */
static int hf_nr_rrc_rrcPosSystemInfoRequest_r16 = -1;  /* RRC_PosSystemInfoRequest_r16_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_30 = -1;  /* T_criticalExtensionsFuture_30 */
static int hf_nr_rrc_requested_SI_List = -1;      /* BIT_STRING_SIZE_maxSI_Message */
static int hf_nr_rrc_spare_01 = -1;               /* BIT_STRING_SIZE_12 */
static int hf_nr_rrc_requestedPosSI_List = -1;    /* BIT_STRING_SIZE_maxSI_Message */
static int hf_nr_rrc_spare_02 = -1;               /* BIT_STRING_SIZE_11 */
static int hf_nr_rrc_criticalExtensions_31 = -1;  /* T_criticalExtensions_31 */
static int hf_nr_rrc_scgFailureInformation_01 = -1;  /* SCGFailureInformation_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_31 = -1;  /* T_criticalExtensionsFuture_31 */
static int hf_nr_rrc_failureReportSCG = -1;       /* FailureReportSCG */
static int hf_nr_rrc_nonCriticalExtension_68 = -1;  /* SCGFailureInformation_v1590_IEs */
static int hf_nr_rrc_nonCriticalExtension_69 = -1;  /* T_nonCriticalExtension_31 */
static int hf_nr_rrc_failureType_02 = -1;         /* T_failureType_02 */
static int hf_nr_rrc_measResultFreqList = -1;     /* MeasResultFreqList */
static int hf_nr_rrc_measResultSCG_Failure = -1;  /* T_measResultSCG_Failure */
static int hf_nr_rrc_locationInfo_r16 = -1;       /* LocationInfo_r16 */
static int hf_nr_rrc_failureType_v1610 = -1;      /* T_failureType_v1610 */
static int hf_nr_rrc_MeasResultFreqList_item = -1;  /* MeasResult2NR */
static int hf_nr_rrc_criticalExtensions_32 = -1;  /* T_criticalExtensions_32 */
static int hf_nr_rrc_scgFailureInformationEUTRA_01 = -1;  /* SCGFailureInformationEUTRA_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_32 = -1;  /* T_criticalExtensionsFuture_32 */
static int hf_nr_rrc_failureReportSCG_EUTRA = -1;  /* FailureReportSCG_EUTRA */
static int hf_nr_rrc_nonCriticalExtension_70 = -1;  /* SCGFailureInformationEUTRA_v1590_IEs */
static int hf_nr_rrc_nonCriticalExtension_71 = -1;  /* T_nonCriticalExtension_32 */
static int hf_nr_rrc_failureType_03 = -1;         /* T_failureType_03 */
static int hf_nr_rrc_measResultFreqListMRDC = -1;  /* MeasResultFreqListFailMRDC */
static int hf_nr_rrc_measResultSCG_FailureMRDC = -1;  /* T_measResultSCG_FailureMRDC */
static int hf_nr_rrc_MeasResultFreqListFailMRDC_item = -1;  /* MeasResult2EUTRA */
static int hf_nr_rrc_criticalExtensions_33 = -1;  /* T_criticalExtensions_33 */
static int hf_nr_rrc_securityModeCommand_01 = -1;  /* SecurityModeCommand_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_33 = -1;  /* T_criticalExtensionsFuture_33 */
static int hf_nr_rrc_securityConfigSMC = -1;      /* SecurityConfigSMC */
static int hf_nr_rrc_nonCriticalExtension_72 = -1;  /* T_nonCriticalExtension_33 */
static int hf_nr_rrc_securityAlgorithmConfig = -1;  /* SecurityAlgorithmConfig */
static int hf_nr_rrc_criticalExtensions_34 = -1;  /* T_criticalExtensions_34 */
static int hf_nr_rrc_securityModeComplete_01 = -1;  /* SecurityModeComplete_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_34 = -1;  /* T_criticalExtensionsFuture_34 */
static int hf_nr_rrc_nonCriticalExtension_73 = -1;  /* T_nonCriticalExtension_34 */
static int hf_nr_rrc_criticalExtensions_35 = -1;  /* T_criticalExtensions_35 */
static int hf_nr_rrc_securityModeFailure_01 = -1;  /* SecurityModeFailure_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_35 = -1;  /* T_criticalExtensionsFuture_35 */
static int hf_nr_rrc_nonCriticalExtension_74 = -1;  /* T_nonCriticalExtension_35 */
static int hf_nr_rrc_cellSelectionInfo = -1;      /* T_cellSelectionInfo */
static int hf_nr_rrc_q_RxLevMin = -1;             /* Q_RxLevMin */
static int hf_nr_rrc_q_RxLevMinOffset = -1;       /* INTEGER_1_8 */
static int hf_nr_rrc_q_RxLevMinSUL = -1;          /* Q_RxLevMin */
static int hf_nr_rrc_q_QualMin = -1;              /* Q_QualMin */
static int hf_nr_rrc_q_QualMinOffset = -1;        /* INTEGER_1_8 */
static int hf_nr_rrc_cellAccessRelatedInfo = -1;  /* CellAccessRelatedInfo */
static int hf_nr_rrc_connEstFailureControl = -1;  /* ConnEstFailureControl */
static int hf_nr_rrc_si_SchedulingInfo = -1;      /* SI_SchedulingInfo */
static int hf_nr_rrc_servingCellConfigCommon = -1;  /* ServingCellConfigCommonSIB */
static int hf_nr_rrc_ims_EmergencySupport = -1;   /* T_ims_EmergencySupport */
static int hf_nr_rrc_eCallOverIMS_Support = -1;   /* T_eCallOverIMS_Support */
static int hf_nr_rrc_ue_TimersAndConstants = -1;  /* UE_TimersAndConstants */
static int hf_nr_rrc_uac_BarringInfo = -1;        /* T_uac_BarringInfo */
static int hf_nr_rrc_uac_BarringForCommon = -1;   /* UAC_BarringPerCatList */
static int hf_nr_rrc_uac_BarringPerPLMN_List = -1;  /* UAC_BarringPerPLMN_List */
static int hf_nr_rrc_uac_BarringInfoSetList = -1;  /* UAC_BarringInfoSetList */
static int hf_nr_rrc_uac_AccessCategory1_SelectionAssistanceInfo = -1;  /* T_uac_AccessCategory1_SelectionAssistanceInfo */
static int hf_nr_rrc_plmnCommon = -1;             /* UAC_AccessCategory1_SelectionAssistanceInfo */
static int hf_nr_rrc_individualPLMNList = -1;     /* SEQUENCE_SIZE_2_maxPLMN_OF_UAC_AccessCategory1_SelectionAssistanceInfo */
static int hf_nr_rrc_individualPLMNList_item = -1;  /* UAC_AccessCategory1_SelectionAssistanceInfo */
static int hf_nr_rrc_useFullResumeID = -1;        /* T_useFullResumeID */
static int hf_nr_rrc_nonCriticalExtension_75 = -1;  /* SIB1_v1610_IEs */
static int hf_nr_rrc_idleModeMeasurementsEUTRA_r16 = -1;  /* T_idleModeMeasurementsEUTRA_r16 */
static int hf_nr_rrc_idleModeMeasurementsNR_r16 = -1;  /* T_idleModeMeasurementsNR_r16 */
static int hf_nr_rrc_posSI_SchedulingInfo_r16 = -1;  /* PosSI_SchedulingInfo_r16 */
static int hf_nr_rrc_nonCriticalExtension_76 = -1;  /* SIB1_v1630_IEs */
static int hf_nr_rrc_uac_BarringInfo_v1630 = -1;  /* T_uac_BarringInfo_v1630 */
static int hf_nr_rrc_uac_AC1_SelectAssistInfo_r16 = -1;  /* SEQUENCE_SIZE_2_maxPLMN_OF_UAC_AC1_SelectAssistInfo_r16 */
static int hf_nr_rrc_uac_AC1_SelectAssistInfo_r16_item = -1;  /* UAC_AC1_SelectAssistInfo_r16 */
static int hf_nr_rrc_nonCriticalExtension_77 = -1;  /* T_nonCriticalExtension_36 */
static int hf_nr_rrc_criticalExtensions_36 = -1;  /* T_criticalExtensions_36 */
static int hf_nr_rrc_sidelinkUEInformationNR_r16_03 = -1;  /* SidelinkUEInformationNR_r16_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_36 = -1;  /* T_criticalExtensionsFuture_36 */
static int hf_nr_rrc_sl_RxInterestedFreqList_r16 = -1;  /* SL_InterestedFreqList_r16 */
static int hf_nr_rrc_sl_TxResourceReqList_r16 = -1;  /* SL_TxResourceReqList_r16 */
static int hf_nr_rrc_sl_FailureList_r16 = -1;     /* SL_FailureList_r16 */
static int hf_nr_rrc_nonCriticalExtension_78 = -1;  /* T_nonCriticalExtension_37 */
static int hf_nr_rrc_SL_InterestedFreqList_r16_item = -1;  /* INTEGER_1_maxNrofFreqSL_r16 */
static int hf_nr_rrc_SL_TxResourceReqList_r16_item = -1;  /* SL_TxResourceReq_r16 */
static int hf_nr_rrc_sl_DestinationIdentity_r16 = -1;  /* SL_DestinationIdentity_r16 */
static int hf_nr_rrc_sl_CastType_r16 = -1;        /* T_sl_CastType_r16 */
static int hf_nr_rrc_sl_RLC_ModeIndicationList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofSLRB_r16_OF_SL_RLC_ModeIndication_r16 */
static int hf_nr_rrc_sl_RLC_ModeIndicationList_r16_item = -1;  /* SL_RLC_ModeIndication_r16 */
static int hf_nr_rrc_sl_QoS_InfoList_r16 = -1;    /* SEQUENCE_SIZE_1_maxNrofSL_QFIsPerDest_r16_OF_SL_QoS_Info_r16 */
static int hf_nr_rrc_sl_QoS_InfoList_r16_item = -1;  /* SL_QoS_Info_r16 */
static int hf_nr_rrc_sl_TypeTxSyncList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofFreqSL_r16_OF_SL_TypeTxSync_r16 */
static int hf_nr_rrc_sl_TypeTxSyncList_r16_item = -1;  /* SL_TypeTxSync_r16 */
static int hf_nr_rrc_sl_TxInterestedFreqList_r16 = -1;  /* SL_TxInterestedFreqList_r16 */
static int hf_nr_rrc_sl_CapabilityInformationSidelink_r16 = -1;  /* T_sl_CapabilityInformationSidelink_r16 */
static int hf_nr_rrc_SL_TxInterestedFreqList_r16_item = -1;  /* INTEGER_1_maxNrofFreqSL_r16 */
static int hf_nr_rrc_sl_QoS_FlowIdentity_r16 = -1;  /* SL_QoS_FlowIdentity_r16 */
static int hf_nr_rrc_sl_QoS_Profile_r16 = -1;     /* SL_QoS_Profile_r16 */
static int hf_nr_rrc_sl_Mode_r16 = -1;            /* T_sl_Mode_r16 */
static int hf_nr_rrc_sl_AM_Mode_r16 = -1;         /* NULL */
static int hf_nr_rrc_sl_UM_Mode_r16 = -1;         /* NULL */
static int hf_nr_rrc_SL_FailureList_r16_item = -1;  /* SL_Failure_r16 */
static int hf_nr_rrc_sl_Failure_r16 = -1;         /* T_sl_Failure_r16 */
static int hf_nr_rrc_criticalExtensions_37 = -1;  /* T_criticalExtensions_37 */
static int hf_nr_rrc_systemInformation_01 = -1;   /* SystemInformation_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_r16_01 = -1;  /* T_criticalExtensionsFuture_r16_01 */
static int hf_nr_rrc_posSystemInformation_r16 = -1;  /* PosSystemInformation_r16_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_37 = -1;  /* T_criticalExtensionsFuture_37 */
static int hf_nr_rrc_sib_TypeAndInfo = -1;        /* T_sib_TypeAndInfo */
static int hf_nr_rrc_sib_TypeAndInfo_item = -1;   /* T_sib_TypeAndInfo_item */
static int hf_nr_rrc_sib2 = -1;                   /* SIB2 */
static int hf_nr_rrc_sib3 = -1;                   /* SIB3 */
static int hf_nr_rrc_sib4 = -1;                   /* SIB4 */
static int hf_nr_rrc_sib5 = -1;                   /* SIB5 */
static int hf_nr_rrc_sib6 = -1;                   /* SIB6 */
static int hf_nr_rrc_sib7 = -1;                   /* SIB7 */
static int hf_nr_rrc_sib8 = -1;                   /* SIB8 */
static int hf_nr_rrc_sib9 = -1;                   /* SIB9 */
static int hf_nr_rrc_sib10_v1610 = -1;            /* SIB10_r16 */
static int hf_nr_rrc_sib11_v1610 = -1;            /* SIB11_r16 */
static int hf_nr_rrc_sib12_v1610 = -1;            /* SIB12_r16 */
static int hf_nr_rrc_sib13_v1610 = -1;            /* SIB13_r16 */
static int hf_nr_rrc_sib14_v1610 = -1;            /* SIB14_r16 */
static int hf_nr_rrc_nonCriticalExtension_79 = -1;  /* T_nonCriticalExtension_38 */
static int hf_nr_rrc_criticalExtensions_38 = -1;  /* T_criticalExtensions_38 */
static int hf_nr_rrc_ueAssistanceInformation_02 = -1;  /* UEAssistanceInformation_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_38 = -1;  /* T_criticalExtensionsFuture_38 */
static int hf_nr_rrc_delayBudgetReport = -1;      /* DelayBudgetReport */
static int hf_nr_rrc_nonCriticalExtension_80 = -1;  /* UEAssistanceInformation_v1540_IEs */
static int hf_nr_rrc_type1 = -1;                  /* T_type1 */
static int hf_nr_rrc_overheatingAssistance = -1;  /* OverheatingAssistance */
static int hf_nr_rrc_nonCriticalExtension_81 = -1;  /* UEAssistanceInformation_v1610_IEs */
static int hf_nr_rrc_reducedMaxCCs = -1;          /* ReducedMaxCCs_r16 */
static int hf_nr_rrc_reducedMaxBW_FR1 = -1;       /* ReducedMaxBW_FRx_r16 */
static int hf_nr_rrc_reducedMaxBW_FR2 = -1;       /* ReducedMaxBW_FRx_r16 */
static int hf_nr_rrc_reducedMaxMIMO_LayersFR1 = -1;  /* T_reducedMaxMIMO_LayersFR1 */
static int hf_nr_rrc_reducedMIMO_LayersFR1_DL = -1;  /* MIMO_LayersDL */
static int hf_nr_rrc_reducedMIMO_LayersFR1_UL = -1;  /* MIMO_LayersUL */
static int hf_nr_rrc_reducedMaxMIMO_LayersFR2 = -1;  /* T_reducedMaxMIMO_LayersFR2 */
static int hf_nr_rrc_reducedMIMO_LayersFR2_DL = -1;  /* MIMO_LayersDL */
static int hf_nr_rrc_reducedMIMO_LayersFR2_UL = -1;  /* MIMO_LayersUL */
static int hf_nr_rrc_idc_Assistance_r16 = -1;     /* IDC_Assistance_r16 */
static int hf_nr_rrc_drx_Preference_r16 = -1;     /* DRX_Preference_r16 */
static int hf_nr_rrc_maxBW_Preference_r16 = -1;   /* MaxBW_Preference_r16 */
static int hf_nr_rrc_maxCC_Preference_r16 = -1;   /* MaxCC_Preference_r16 */
static int hf_nr_rrc_maxMIMO_LayerPreference_r16 = -1;  /* MaxMIMO_LayerPreference_r16 */
static int hf_nr_rrc_minSchedulingOffsetPreference_r16 = -1;  /* MinSchedulingOffsetPreference_r16 */
static int hf_nr_rrc_releasePreference_r16 = -1;  /* ReleasePreference_r16 */
static int hf_nr_rrc_sl_UE_AssistanceInformationNR_r16 = -1;  /* SL_UE_AssistanceInformationNR_r16 */
static int hf_nr_rrc_referenceTimeInfoPreference_r16 = -1;  /* BOOLEAN */
static int hf_nr_rrc_nonCriticalExtension_82 = -1;  /* T_nonCriticalExtension_39 */
static int hf_nr_rrc_affectedCarrierFreqList_r16 = -1;  /* AffectedCarrierFreqList_r16 */
static int hf_nr_rrc_affectedCarrierFreqCombList_r16 = -1;  /* AffectedCarrierFreqCombList_r16 */
static int hf_nr_rrc_AffectedCarrierFreqList_r16_item = -1;  /* AffectedCarrierFreq_r16 */
static int hf_nr_rrc_carrierFreq_r16_01 = -1;     /* ARFCN_ValueNR */
static int hf_nr_rrc_interferenceDirection_r16 = -1;  /* T_interferenceDirection_r16 */
static int hf_nr_rrc_AffectedCarrierFreqCombList_r16_item = -1;  /* AffectedCarrierFreqComb_r16 */
static int hf_nr_rrc_affectedCarrierFreqComb_r16 = -1;  /* SEQUENCE_SIZE_2_maxNrofServingCells_OF_ARFCN_ValueNR */
static int hf_nr_rrc_affectedCarrierFreqComb_r16_item = -1;  /* ARFCN_ValueNR */
static int hf_nr_rrc_victimSystemType_r16 = -1;   /* VictimSystemType_r16 */
static int hf_nr_rrc_gps_r16 = -1;                /* T_gps_r16 */
static int hf_nr_rrc_glonass_r16 = -1;            /* T_glonass_r16 */
static int hf_nr_rrc_bds_r16 = -1;                /* T_bds_r16 */
static int hf_nr_rrc_galileo_r16 = -1;            /* T_galileo_r16 */
static int hf_nr_rrc_navIC_r16 = -1;              /* T_navIC_r16 */
static int hf_nr_rrc_wlan_r16 = -1;               /* T_wlan_r16 */
static int hf_nr_rrc_bluetooth_r16 = -1;          /* T_bluetooth_r16 */
static int hf_nr_rrc_preferredDRX_InactivityTimer_r16 = -1;  /* T_preferredDRX_InactivityTimer_r16 */
static int hf_nr_rrc_preferredDRX_LongCycle_r16 = -1;  /* T_preferredDRX_LongCycle_r16 */
static int hf_nr_rrc_preferredDRX_ShortCycle_r16 = -1;  /* T_preferredDRX_ShortCycle_r16 */
static int hf_nr_rrc_preferredDRX_ShortCycleTimer_r16 = -1;  /* INTEGER_1_16 */
static int hf_nr_rrc_reducedMaxBW_FR1_r16 = -1;   /* ReducedMaxBW_FRx_r16 */
static int hf_nr_rrc_reducedMaxBW_FR2_r16 = -1;   /* ReducedMaxBW_FRx_r16 */
static int hf_nr_rrc_reducedMaxCCs_r16 = -1;      /* ReducedMaxCCs_r16 */
static int hf_nr_rrc_reducedMaxMIMO_LayersFR1_r16 = -1;  /* T_reducedMaxMIMO_LayersFR1_r16 */
static int hf_nr_rrc_reducedMIMO_LayersFR1_DL_r16 = -1;  /* INTEGER_1_8 */
static int hf_nr_rrc_reducedMIMO_LayersFR1_UL_r16 = -1;  /* INTEGER_1_4 */
static int hf_nr_rrc_reducedMaxMIMO_LayersFR2_r16 = -1;  /* T_reducedMaxMIMO_LayersFR2_r16 */
static int hf_nr_rrc_reducedMIMO_LayersFR2_DL_r16 = -1;  /* INTEGER_1_8 */
static int hf_nr_rrc_reducedMIMO_LayersFR2_UL_r16 = -1;  /* INTEGER_1_4 */
static int hf_nr_rrc_preferredK0_r16 = -1;        /* T_preferredK0_r16 */
static int hf_nr_rrc_preferredK0_SCS_15kHz_r16 = -1;  /* T_preferredK0_SCS_15kHz_r16 */
static int hf_nr_rrc_preferredK0_SCS_30kHz_r16 = -1;  /* T_preferredK0_SCS_30kHz_r16 */
static int hf_nr_rrc_preferredK0_SCS_60kHz_r16 = -1;  /* T_preferredK0_SCS_60kHz_r16 */
static int hf_nr_rrc_preferredK0_SCS_120kHz_r16 = -1;  /* T_preferredK0_SCS_120kHz_r16 */
static int hf_nr_rrc_preferredK2_r16 = -1;        /* T_preferredK2_r16 */
static int hf_nr_rrc_preferredK2_SCS_15kHz_r16 = -1;  /* T_preferredK2_SCS_15kHz_r16 */
static int hf_nr_rrc_preferredK2_SCS_30kHz_r16 = -1;  /* T_preferredK2_SCS_30kHz_r16 */
static int hf_nr_rrc_preferredK2_SCS_60kHz_r16 = -1;  /* T_preferredK2_SCS_60kHz_r16 */
static int hf_nr_rrc_preferredK2_SCS_120kHz_r16 = -1;  /* T_preferredK2_SCS_120kHz_r16 */
static int hf_nr_rrc_preferredRRC_State_r16 = -1;  /* T_preferredRRC_State_r16 */
static int hf_nr_rrc_reducedBW_DL_r16 = -1;       /* ReducedAggregatedBandwidth */
static int hf_nr_rrc_reducedBW_UL_r16 = -1;       /* ReducedAggregatedBandwidth */
static int hf_nr_rrc_reducedCCsDL_r16 = -1;       /* INTEGER_0_31 */
static int hf_nr_rrc_reducedCCsUL_r16 = -1;       /* INTEGER_0_31 */
static int hf_nr_rrc_SL_UE_AssistanceInformationNR_r16_item = -1;  /* SL_TrafficPatternInfo_r16 */
static int hf_nr_rrc_trafficPeriodicity_r16 = -1;  /* T_trafficPeriodicity_r16 */
static int hf_nr_rrc_timingOffset_r16 = -1;       /* INTEGER_0_10239 */
static int hf_nr_rrc_messageSize_r16 = -1;        /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_criticalExtensions_39 = -1;  /* T_criticalExtensions_39 */
static int hf_nr_rrc_ueCapabilityEnquiry_01 = -1;  /* UECapabilityEnquiry_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_39 = -1;  /* T_criticalExtensionsFuture_39 */
static int hf_nr_rrc_ue_CapabilityRAT_RequestList = -1;  /* UE_CapabilityRAT_RequestList */
static int hf_nr_rrc_ue_CapabilityEnquiryExt = -1;  /* T_ue_CapabilityEnquiryExt */
static int hf_nr_rrc_capabilityRequestFilterCommon = -1;  /* UE_CapabilityRequestFilterCommon */
static int hf_nr_rrc_nonCriticalExtension_83 = -1;  /* UECapabilityEnquiry_v1610_IEs */
static int hf_nr_rrc_rrc_SegAllowed_r16 = -1;     /* T_rrc_SegAllowed_r16 */
static int hf_nr_rrc_nonCriticalExtension_84 = -1;  /* T_nonCriticalExtension_40 */
static int hf_nr_rrc_criticalExtensions_40 = -1;  /* T_criticalExtensions_40 */
static int hf_nr_rrc_ueCapabilityInformation_01 = -1;  /* UECapabilityInformation_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_40 = -1;  /* T_criticalExtensionsFuture_40 */
static int hf_nr_rrc_ue_CapabilityRAT_ContainerList = -1;  /* UE_CapabilityRAT_ContainerList */
static int hf_nr_rrc_nonCriticalExtension_85 = -1;  /* T_nonCriticalExtension_41 */
static int hf_nr_rrc_criticalExtensions_41 = -1;  /* T_criticalExtensions_41 */
static int hf_nr_rrc_ueInformationRequest_r16_01 = -1;  /* UEInformationRequest_r16_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_41 = -1;  /* T_criticalExtensionsFuture_41 */
static int hf_nr_rrc_idleModeMeasurementReq_r16_01 = -1;  /* T_idleModeMeasurementReq_r16_01 */
static int hf_nr_rrc_logMeasReportReq_r16 = -1;   /* T_logMeasReportReq_r16 */
static int hf_nr_rrc_connEstFailReportReq_r16 = -1;  /* T_connEstFailReportReq_r16 */
static int hf_nr_rrc_ra_ReportReq_r16 = -1;       /* T_ra_ReportReq_r16 */
static int hf_nr_rrc_rlf_ReportReq_r16 = -1;      /* T_rlf_ReportReq_r16 */
static int hf_nr_rrc_mobilityHistoryReportReq_r16 = -1;  /* T_mobilityHistoryReportReq_r16 */
static int hf_nr_rrc_nonCriticalExtension_86 = -1;  /* T_nonCriticalExtension_42 */
static int hf_nr_rrc_criticalExtensions_42 = -1;  /* T_criticalExtensions_42 */
static int hf_nr_rrc_ueInformationResponse_r16_01 = -1;  /* UEInformationResponse_r16_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_42 = -1;  /* T_criticalExtensionsFuture_42 */
static int hf_nr_rrc_logMeasReport_r16 = -1;      /* LogMeasReport_r16 */
static int hf_nr_rrc_connEstFailReport_r16 = -1;  /* ConnEstFailReport_r16 */
static int hf_nr_rrc_ra_ReportList_r16 = -1;      /* RA_ReportList_r16 */
static int hf_nr_rrc_rlf_Report_r16 = -1;         /* RLF_Report_r16 */
static int hf_nr_rrc_mobilityHistoryReport_r16 = -1;  /* MobilityHistoryReport_r16 */
static int hf_nr_rrc_nonCriticalExtension_87 = -1;  /* T_nonCriticalExtension_43 */
static int hf_nr_rrc_absoluteTimeStamp_r16 = -1;  /* AbsoluteTimeInfo_r16 */
static int hf_nr_rrc_logMeasInfoList_r16 = -1;    /* LogMeasInfoList_r16 */
static int hf_nr_rrc_logMeasAvailable_r16 = -1;   /* T_logMeasAvailable_r16 */
static int hf_nr_rrc_logMeasAvailableBT_r16 = -1;  /* T_logMeasAvailableBT_r16 */
static int hf_nr_rrc_logMeasAvailableWLAN_r16 = -1;  /* T_logMeasAvailableWLAN_r16 */
static int hf_nr_rrc_LogMeasInfoList_r16_item = -1;  /* LogMeasInfo_r16 */
static int hf_nr_rrc_relativeTimeStamp_r16 = -1;  /* INTEGER_0_7200 */
static int hf_nr_rrc_servCellIdentity_r16 = -1;   /* CGI_Info_Logging_r16 */
static int hf_nr_rrc_measResultServingCell_r16 = -1;  /* MeasResultServingCell_r16 */
static int hf_nr_rrc_measResultNeighCells_r16 = -1;  /* T_measResultNeighCells_r16 */
static int hf_nr_rrc_measResultNeighCellListNR = -1;  /* MeasResultListLogging2NR_r16 */
static int hf_nr_rrc_measResultNeighCellListEUTRA = -1;  /* MeasResultList2EUTRA_r16 */
static int hf_nr_rrc_anyCellSelectionDetected_r16 = -1;  /* T_anyCellSelectionDetected_r16 */
static int hf_nr_rrc_measResultFailedCell_r16 = -1;  /* MeasResultFailedCell_r16 */
static int hf_nr_rrc_measResultNeighCells_r16_01 = -1;  /* T_measResultNeighCells_r16_01 */
static int hf_nr_rrc_measResultNeighCellListNR_01 = -1;  /* MeasResultList2NR_r16 */
static int hf_nr_rrc_numberOfConnFail_r16 = -1;   /* INTEGER_1_8 */
static int hf_nr_rrc_perRAInfoList_r16 = -1;      /* PerRAInfoList_r16 */
static int hf_nr_rrc_timeSinceFailure_r16 = -1;   /* TimeSinceFailure_r16 */
static int hf_nr_rrc_resultsSSB_Cell = -1;        /* MeasQuantityResults */
static int hf_nr_rrc_resultsSSB = -1;             /* T_resultsSSB */
static int hf_nr_rrc_best_ssb_Index = -1;         /* SSB_Index */
static int hf_nr_rrc_best_ssb_Results = -1;       /* MeasQuantityResults */
static int hf_nr_rrc_numberOfGoodSSB = -1;        /* INTEGER_1_maxNrofSSBs_r16 */
static int hf_nr_rrc_cgi_Info_01 = -1;            /* CGI_Info_Logging_r16 */
static int hf_nr_rrc_measResult_r16 = -1;         /* T_measResult_r16 */
static int hf_nr_rrc_cellResults_r16 = -1;        /* T_cellResults_r16 */
static int hf_nr_rrc_resultsSSB_Cell_r16 = -1;    /* MeasQuantityResults */
static int hf_nr_rrc_rsIndexResults_r16 = -1;     /* T_rsIndexResults_r16 */
static int hf_nr_rrc_resultsSSB_Indexes_r16 = -1;  /* ResultsPerSSB_IndexList */
static int hf_nr_rrc_RA_ReportList_r16_item = -1;  /* RA_Report_r16 */
static int hf_nr_rrc_cellId_r16 = -1;             /* T_cellId_r16 */
static int hf_nr_rrc_cellGlobalId_r16 = -1;       /* CGI_Info_Logging_r16 */
static int hf_nr_rrc_pci_arfcn_r16 = -1;          /* T_pci_arfcn_r16 */
static int hf_nr_rrc_physCellId_r16 = -1;         /* PhysCellId */
static int hf_nr_rrc_ra_InformationCommon_r16 = -1;  /* RA_InformationCommon_r16 */
static int hf_nr_rrc_raPurpose_r16 = -1;          /* T_raPurpose_r16 */
static int hf_nr_rrc_absoluteFrequencyPointA_r16 = -1;  /* ARFCN_ValueNR */
static int hf_nr_rrc_locationAndBandwidth_r16 = -1;  /* INTEGER_0_37949 */
static int hf_nr_rrc_subcarrierSpacing_r16 = -1;  /* SubcarrierSpacing */
static int hf_nr_rrc_msg1_FrequencyStart_r16 = -1;  /* INTEGER_0_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_msg1_FrequencyStartCFRA_r16 = -1;  /* INTEGER_0_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_msg1_SubcarrierSpacing_r16 = -1;  /* SubcarrierSpacing */
static int hf_nr_rrc_msg1_SubcarrierSpacingCFRA_r16 = -1;  /* SubcarrierSpacing */
static int hf_nr_rrc_msg1_FDM_r16 = -1;           /* T_msg1_FDM_r16 */
static int hf_nr_rrc_msg1_FDMCFRA_r16 = -1;       /* T_msg1_FDMCFRA_r16 */
static int hf_nr_rrc_perRAInfoList_v1660 = -1;    /* PerRAInfoList_v1660 */
static int hf_nr_rrc_msg1_SCS_From_prach_ConfigurationIndex_r16 = -1;  /* T_msg1_SCS_From_prach_ConfigurationIndex_r16 */
static int hf_nr_rrc_PerRAInfoList_r16_item = -1;  /* PerRAInfo_r16 */
static int hf_nr_rrc_PerRAInfoList_v1660_item = -1;  /* PerRACSI_RSInfo_v1660 */
static int hf_nr_rrc_perRASSBInfoList_r16 = -1;   /* PerRASSBInfo_r16 */
static int hf_nr_rrc_perRACSI_RSInfoList_r16 = -1;  /* PerRACSI_RSInfo_r16 */
static int hf_nr_rrc_ssb_Index_r16 = -1;          /* SSB_Index */
static int hf_nr_rrc_numberOfPreamblesSentOnSSB_r16 = -1;  /* INTEGER_1_200 */
static int hf_nr_rrc_perRAAttemptInfoList_r16 = -1;  /* PerRAAttemptInfoList_r16 */
static int hf_nr_rrc_csi_RS_Index_r16 = -1;       /* CSI_RS_Index */
static int hf_nr_rrc_numberOfPreamblesSentOnCSI_RS_r16 = -1;  /* INTEGER_1_200 */
static int hf_nr_rrc_csi_RS_Index_v1660 = -1;     /* INTEGER_1_96 */
static int hf_nr_rrc_PerRAAttemptInfoList_r16_item = -1;  /* PerRAAttemptInfo_r16 */
static int hf_nr_rrc_contentionDetected_r16 = -1;  /* BOOLEAN */
static int hf_nr_rrc_dlRSRPAboveThreshold_r16 = -1;  /* BOOLEAN */
static int hf_nr_rrc_nr_RLF_Report_r16 = -1;      /* T_nr_RLF_Report_r16 */
static int hf_nr_rrc_measResultLastServCell_r16 = -1;  /* MeasResultRLFNR_r16 */
static int hf_nr_rrc_measResultNeighCells_r16_02 = -1;  /* T_measResultNeighCells_r16_02 */
static int hf_nr_rrc_measResultListNR_r16 = -1;   /* MeasResultList2NR_r16 */
static int hf_nr_rrc_measResultListEUTRA_r16 = -1;  /* MeasResultList2EUTRA_r16 */
static int hf_nr_rrc_c_RNTI_r16 = -1;             /* RNTI_Value */
static int hf_nr_rrc_previousPCellId_r16 = -1;    /* T_previousPCellId_r16 */
static int hf_nr_rrc_nrPreviousCell_r16 = -1;     /* CGI_Info_Logging_r16 */
static int hf_nr_rrc_eutraPreviousCell_r16 = -1;  /* CGI_InfoEUTRALogging */
static int hf_nr_rrc_failedPCellId_r16 = -1;      /* T_failedPCellId_r16 */
static int hf_nr_rrc_nrFailedPCellId_r16 = -1;    /* T_nrFailedPCellId_r16 */
static int hf_nr_rrc_pci_arfcn_r16_01 = -1;       /* T_pci_arfcn_r16_01 */
static int hf_nr_rrc_eutraFailedPCellId_r16 = -1;  /* T_eutraFailedPCellId_r16 */
static int hf_nr_rrc_cellGlobalId_r16_01 = -1;    /* CGI_InfoEUTRALogging */
static int hf_nr_rrc_pci_arfcn_r16_02 = -1;       /* T_pci_arfcn_r16_02 */
static int hf_nr_rrc_physCellId_r16_01 = -1;      /* EUTRA_PhysCellId */
static int hf_nr_rrc_carrierFreq_r16_02 = -1;     /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_reconnectCellId_r16 = -1;    /* T_reconnectCellId_r16 */
static int hf_nr_rrc_nrReconnectCellId_r16 = -1;  /* CGI_Info_Logging_r16 */
static int hf_nr_rrc_eutraReconnectCellId_r16 = -1;  /* CGI_InfoEUTRALogging */
static int hf_nr_rrc_timeUntilReconnection_r16 = -1;  /* TimeUntilReconnection_r16 */
static int hf_nr_rrc_reestablishmentCellId_r16 = -1;  /* CGI_Info_Logging_r16 */
static int hf_nr_rrc_timeConnFailure_r16 = -1;    /* INTEGER_0_1023 */
static int hf_nr_rrc_connectionFailureType_r16 = -1;  /* T_connectionFailureType_r16 */
static int hf_nr_rrc_rlf_Cause_r16 = -1;          /* T_rlf_Cause_r16 */
static int hf_nr_rrc_noSuitableCellFound_r16 = -1;  /* T_noSuitableCellFound_r16 */
static int hf_nr_rrc_csi_rsRLMConfigBitmap_v1650 = -1;  /* BIT_STRING_SIZE_96 */
static int hf_nr_rrc_eutra_RLF_Report_r16 = -1;   /* T_eutra_RLF_Report_r16 */
static int hf_nr_rrc_failedPCellId_EUTRA = -1;    /* CGI_InfoEUTRALogging */
static int hf_nr_rrc_measResult_RLF_Report_EUTRA_r16 = -1;  /* T_measResult_RLF_Report_EUTRA_r16 */
static int hf_nr_rrc_MeasResultList2NR_r16_item = -1;  /* MeasResult2NR_r16 */
static int hf_nr_rrc_MeasResultList2EUTRA_r16_item = -1;  /* MeasResult2EUTRA_r16 */
static int hf_nr_rrc_ssbFrequency_r16 = -1;       /* ARFCN_ValueNR */
static int hf_nr_rrc_refFreqCSI_RS_r16 = -1;      /* ARFCN_ValueNR */
static int hf_nr_rrc_measResultList_r16 = -1;     /* MeasResultListNR */
static int hf_nr_rrc_MeasResultListLogging2NR_r16_item = -1;  /* MeasResultLogging2NR_r16 */
static int hf_nr_rrc_measResultListLoggingNR_r16 = -1;  /* MeasResultListLoggingNR_r16 */
static int hf_nr_rrc_MeasResultListLoggingNR_r16_item = -1;  /* MeasResultLoggingNR_r16 */
static int hf_nr_rrc_numberOfGoodSSB_r16 = -1;    /* INTEGER_1_maxNrofSSBs_r16 */
static int hf_nr_rrc_measResultList_r16_01 = -1;  /* MeasResultListEUTRA */
static int hf_nr_rrc_measResult_r16_01 = -1;      /* T_measResult_r16_01 */
static int hf_nr_rrc_cellResults_r16_01 = -1;     /* T_cellResults_r16_01 */
static int hf_nr_rrc_resultsCSI_RS_Cell_r16 = -1;  /* MeasQuantityResults */
static int hf_nr_rrc_rsIndexResults_r16_01 = -1;  /* T_rsIndexResults_r16_01 */
static int hf_nr_rrc_ssbRLMConfigBitmap_r16 = -1;  /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_resultsCSI_RS_Indexes_r16 = -1;  /* ResultsPerCSI_RS_IndexList */
static int hf_nr_rrc_csi_rsRLMConfigBitmap_r16 = -1;  /* BIT_STRING_SIZE_96 */
static int hf_nr_rrc_criticalExtensions_43 = -1;  /* T_criticalExtensions_43 */
static int hf_nr_rrc_ulDedicatedMessageSegment_r16_01 = -1;  /* ULDedicatedMessageSegment_r16_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_43 = -1;  /* T_criticalExtensionsFuture_43 */
static int hf_nr_rrc_segmentNumber_r16_01 = -1;   /* INTEGER_0_15 */
static int hf_nr_rrc_rrc_MessageSegmentType_r16_01 = -1;  /* T_rrc_MessageSegmentType_r16_01 */
static int hf_nr_rrc_nonCriticalExtension_88 = -1;  /* T_nonCriticalExtension_44 */
static int hf_nr_rrc_criticalExtensions_44 = -1;  /* T_criticalExtensions_44 */
static int hf_nr_rrc_ulInformationTransfer_01 = -1;  /* ULInformationTransfer_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_44 = -1;  /* T_criticalExtensionsFuture_44 */
static int hf_nr_rrc_nonCriticalExtension_89 = -1;  /* T_nonCriticalExtension_45 */
static int hf_nr_rrc_criticalExtensions_45 = -1;  /* T_criticalExtensions_45 */
static int hf_nr_rrc_c1_15 = -1;                  /* T_c1_15 */
static int hf_nr_rrc_ulInformationTransferIRAT_r16_01 = -1;  /* ULInformationTransferIRAT_r16_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_45 = -1;  /* T_criticalExtensionsFuture_45 */
static int hf_nr_rrc_ul_DCCH_MessageEUTRA_r16 = -1;  /* T_ul_DCCH_MessageEUTRA_r16 */
static int hf_nr_rrc_nonCriticalExtension_90 = -1;  /* T_nonCriticalExtension_46 */
static int hf_nr_rrc_criticalExtensions_46 = -1;  /* T_criticalExtensions_46 */
static int hf_nr_rrc_c1_16 = -1;                  /* T_c1_16 */
static int hf_nr_rrc_ulInformationTransferMRDC_01 = -1;  /* ULInformationTransferMRDC_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_46 = -1;  /* T_criticalExtensionsFuture_46 */
static int hf_nr_rrc_ul_DCCH_MessageNR = -1;      /* T_ul_DCCH_MessageNR */
static int hf_nr_rrc_ul_DCCH_MessageEUTRA = -1;   /* T_ul_DCCH_MessageEUTRA */
static int hf_nr_rrc_nonCriticalExtension_91 = -1;  /* T_nonCriticalExtension_47 */
static int hf_nr_rrc_cellReselectionInfoCommon = -1;  /* T_cellReselectionInfoCommon */
static int hf_nr_rrc_nrofSS_BlocksToAverage = -1;  /* INTEGER_2_maxNrofSS_BlocksToAverage */
static int hf_nr_rrc_absThreshSS_BlocksConsolidation = -1;  /* ThresholdNR */
static int hf_nr_rrc_rangeToBestCell = -1;        /* RangeToBestCell */
static int hf_nr_rrc_q_Hyst = -1;                 /* T_q_Hyst */
static int hf_nr_rrc_speedStateReselectionPars = -1;  /* T_speedStateReselectionPars */
static int hf_nr_rrc_mobilityStateParameters = -1;  /* MobilityStateParameters */
static int hf_nr_rrc_q_HystSF = -1;               /* T_q_HystSF */
static int hf_nr_rrc_sf_Medium = -1;              /* T_sf_Medium */
static int hf_nr_rrc_sf_High = -1;                /* T_sf_High */
static int hf_nr_rrc_cellReselectionServingFreqInfo = -1;  /* T_cellReselectionServingFreqInfo */
static int hf_nr_rrc_s_NonIntraSearchP = -1;      /* ReselectionThreshold */
static int hf_nr_rrc_s_NonIntraSearchQ = -1;      /* ReselectionThresholdQ */
static int hf_nr_rrc_threshServingLowP = -1;      /* ReselectionThreshold */
static int hf_nr_rrc_threshServingLowQ = -1;      /* ReselectionThresholdQ */
static int hf_nr_rrc_intraFreqCellReselectionInfo = -1;  /* T_intraFreqCellReselectionInfo */
static int hf_nr_rrc_s_IntraSearchP = -1;         /* ReselectionThreshold */
static int hf_nr_rrc_s_IntraSearchQ = -1;         /* ReselectionThresholdQ */
static int hf_nr_rrc_t_ReselectionNR = -1;        /* T_Reselection */
static int hf_nr_rrc_frequencyBandList = -1;      /* MultiFrequencyBandListNR_SIB */
static int hf_nr_rrc_frequencyBandListSUL = -1;   /* MultiFrequencyBandListNR_SIB */
static int hf_nr_rrc_p_Max = -1;                  /* P_Max */
static int hf_nr_rrc_deriveSSB_IndexFromCell = -1;  /* BOOLEAN */
static int hf_nr_rrc_t_ReselectionNR_SF = -1;     /* SpeedStateScaleFactors */
static int hf_nr_rrc_smtc2_LP_r16 = -1;           /* SSB_MTC2_LP_r16 */
static int hf_nr_rrc_ssb_PositionQCL_Common_r16 = -1;  /* SSB_PositionQCL_Relation_r16 */
static int hf_nr_rrc_relaxedMeasurement_r16 = -1;  /* T_relaxedMeasurement_r16 */
static int hf_nr_rrc_lowMobilityEvaluation_r16 = -1;  /* T_lowMobilityEvaluation_r16 */
static int hf_nr_rrc_s_SearchDeltaP_r16 = -1;     /* T_s_SearchDeltaP_r16 */
static int hf_nr_rrc_t_SearchDeltaP_r16 = -1;     /* T_t_SearchDeltaP_r16 */
static int hf_nr_rrc_cellEdgeEvaluation_r16 = -1;  /* T_cellEdgeEvaluation_r16 */
static int hf_nr_rrc_s_SearchThresholdP_r16 = -1;  /* ReselectionThreshold */
static int hf_nr_rrc_s_SearchThresholdQ_r16 = -1;  /* ReselectionThresholdQ */
static int hf_nr_rrc_combineRelaxedMeasCondition_r16 = -1;  /* T_combineRelaxedMeasCondition_r16 */
static int hf_nr_rrc_highPriorityMeasRelax_r16 = -1;  /* T_highPriorityMeasRelax_r16 */
static int hf_nr_rrc_intraFreqNeighCellList = -1;  /* IntraFreqNeighCellList */
static int hf_nr_rrc_intraFreqBlackCellList = -1;  /* IntraFreqBlackCellList */
static int hf_nr_rrc_intraFreqNeighCellList_v1610 = -1;  /* IntraFreqNeighCellList_v1610 */
static int hf_nr_rrc_intraFreqWhiteCellList_r16 = -1;  /* IntraFreqWhiteCellList_r16 */
static int hf_nr_rrc_intraFreqCAG_CellList_r16 = -1;  /* SEQUENCE_SIZE_1_maxPLMN_OF_IntraFreqCAG_CellListPerPLMN_r16 */
static int hf_nr_rrc_intraFreqCAG_CellList_r16_item = -1;  /* IntraFreqCAG_CellListPerPLMN_r16 */
static int hf_nr_rrc_IntraFreqNeighCellList_item = -1;  /* IntraFreqNeighCellInfo */
static int hf_nr_rrc_IntraFreqNeighCellList_v1610_item = -1;  /* IntraFreqNeighCellInfo_v1610 */
static int hf_nr_rrc_q_OffsetCell = -1;           /* Q_OffsetRange */
static int hf_nr_rrc_q_RxLevMinOffsetCell = -1;   /* INTEGER_1_8 */
static int hf_nr_rrc_q_RxLevMinOffsetCellSUL = -1;  /* INTEGER_1_8 */
static int hf_nr_rrc_q_QualMinOffsetCell = -1;    /* INTEGER_1_8 */
static int hf_nr_rrc_ssb_PositionQCL_r16 = -1;    /* SSB_PositionQCL_Relation_r16 */
static int hf_nr_rrc_IntraFreqBlackCellList_item = -1;  /* PCI_Range */
static int hf_nr_rrc_IntraFreqWhiteCellList_r16_item = -1;  /* PCI_Range */
static int hf_nr_rrc_plmn_IdentityIndex_r16 = -1;  /* INTEGER_1_maxPLMN */
static int hf_nr_rrc_cag_CellList_r16 = -1;       /* SEQUENCE_SIZE_1_maxCAG_Cell_r16_OF_PCI_Range */
static int hf_nr_rrc_cag_CellList_r16_item = -1;  /* PCI_Range */
static int hf_nr_rrc_interFreqCarrierFreqList = -1;  /* InterFreqCarrierFreqList */
static int hf_nr_rrc_interFreqCarrierFreqList_v1610 = -1;  /* InterFreqCarrierFreqList_v1610 */
static int hf_nr_rrc_InterFreqCarrierFreqList_item = -1;  /* InterFreqCarrierFreqInfo */
static int hf_nr_rrc_InterFreqCarrierFreqList_v1610_item = -1;  /* InterFreqCarrierFreqInfo_v1610 */
static int hf_nr_rrc_dl_CarrierFreq = -1;         /* ARFCN_ValueNR */
static int hf_nr_rrc_threshX_HighP = -1;          /* ReselectionThreshold */
static int hf_nr_rrc_threshX_LowP = -1;           /* ReselectionThreshold */
static int hf_nr_rrc_threshX_Q = -1;              /* T_threshX_Q */
static int hf_nr_rrc_threshX_HighQ = -1;          /* ReselectionThresholdQ */
static int hf_nr_rrc_threshX_LowQ = -1;           /* ReselectionThresholdQ */
static int hf_nr_rrc_q_OffsetFreq = -1;           /* Q_OffsetRange */
static int hf_nr_rrc_interFreqNeighCellList = -1;  /* InterFreqNeighCellList */
static int hf_nr_rrc_interFreqBlackCellList = -1;  /* InterFreqBlackCellList */
static int hf_nr_rrc_interFreqNeighCellList_v1610 = -1;  /* InterFreqNeighCellList_v1610 */
static int hf_nr_rrc_interFreqWhiteCellList_r16 = -1;  /* InterFreqWhiteCellList_r16 */
static int hf_nr_rrc_interFreqCAG_CellList_r16 = -1;  /* SEQUENCE_SIZE_1_maxPLMN_OF_InterFreqCAG_CellListPerPLMN_r16 */
static int hf_nr_rrc_interFreqCAG_CellList_r16_item = -1;  /* InterFreqCAG_CellListPerPLMN_r16 */
static int hf_nr_rrc_InterFreqNeighCellList_item = -1;  /* InterFreqNeighCellInfo */
static int hf_nr_rrc_InterFreqNeighCellList_v1610_item = -1;  /* InterFreqNeighCellInfo_v1610 */
static int hf_nr_rrc_InterFreqBlackCellList_item = -1;  /* PCI_Range */
static int hf_nr_rrc_InterFreqWhiteCellList_r16_item = -1;  /* PCI_Range */
static int hf_nr_rrc_carrierFreqListEUTRA = -1;   /* CarrierFreqListEUTRA */
static int hf_nr_rrc_t_ReselectionEUTRA = -1;     /* T_Reselection */
static int hf_nr_rrc_t_ReselectionEUTRA_SF = -1;  /* SpeedStateScaleFactors */
static int hf_nr_rrc_carrierFreqListEUTRA_v1610 = -1;  /* CarrierFreqListEUTRA_v1610 */
static int hf_nr_rrc_CarrierFreqListEUTRA_item = -1;  /* CarrierFreqEUTRA */
static int hf_nr_rrc_CarrierFreqListEUTRA_v1610_item = -1;  /* CarrierFreqEUTRA_v1610 */
static int hf_nr_rrc_eutra_multiBandInfoList = -1;  /* EUTRA_MultiBandInfoList */
static int hf_nr_rrc_eutra_FreqNeighCellList = -1;  /* EUTRA_FreqNeighCellList */
static int hf_nr_rrc_eutra_BlackCellList = -1;    /* EUTRA_FreqBlackCellList */
static int hf_nr_rrc_allowedMeasBandwidth = -1;   /* EUTRA_AllowedMeasBandwidth */
static int hf_nr_rrc_presenceAntennaPort1 = -1;   /* EUTRA_PresenceAntennaPort1 */
static int hf_nr_rrc_threshX_High = -1;           /* ReselectionThreshold */
static int hf_nr_rrc_threshX_Low = -1;            /* ReselectionThreshold */
static int hf_nr_rrc_q_RxLevMin_01 = -1;          /* INTEGER_M70_M22 */
static int hf_nr_rrc_q_QualMin_01 = -1;           /* INTEGER_M34_M3 */
static int hf_nr_rrc_p_MaxEUTRA = -1;             /* INTEGER_M30_33 */
static int hf_nr_rrc_threshX_Q_01 = -1;           /* T_threshX_Q_01 */
static int hf_nr_rrc_highSpeedEUTRACarrier_r16 = -1;  /* T_highSpeedEUTRACarrier_r16 */
static int hf_nr_rrc_EUTRA_FreqBlackCellList_item = -1;  /* EUTRA_PhysCellIdRange */
static int hf_nr_rrc_EUTRA_FreqNeighCellList_item = -1;  /* EUTRA_FreqNeighCellInfo */
static int hf_nr_rrc_physCellId_01 = -1;          /* EUTRA_PhysCellId */
static int hf_nr_rrc_eUTRA_FreqNeighCellInfo_dummy = -1;  /* EUTRA_Q_OffsetRange */
static int hf_nr_rrc_messageIdentifier = -1;      /* T_messageIdentifier */
static int hf_nr_rrc_serialNumber = -1;           /* T_serialNumber */
static int hf_nr_rrc_warningType = -1;            /* T_warningType */
static int hf_nr_rrc_messageIdentifier_01 = -1;   /* T_messageIdentifier_01 */
static int hf_nr_rrc_serialNumber_01 = -1;        /* T_serialNumber_01 */
static int hf_nr_rrc_warningMessageSegmentType = -1;  /* T_warningMessageSegmentType */
static int hf_nr_rrc_warningMessageSegmentNumber = -1;  /* T_warningMessageSegmentNumber */
static int hf_nr_rrc_warningMessageSegment = -1;  /* T_warningMessageSegment */
static int hf_nr_rrc_dataCodingScheme = -1;       /* T_dataCodingScheme */
static int hf_nr_rrc_messageIdentifier_02 = -1;   /* T_messageIdentifier_02 */
static int hf_nr_rrc_serialNumber_02 = -1;        /* T_serialNumber_02 */
static int hf_nr_rrc_warningMessageSegmentType_01 = -1;  /* T_warningMessageSegmentType_01 */
static int hf_nr_rrc_warningMessageSegmentNumber_01 = -1;  /* T_warningMessageSegmentNumber_01 */
static int hf_nr_rrc_warningMessageSegment_01 = -1;  /* T_warningMessageSegment_01 */
static int hf_nr_rrc_dataCodingScheme_01 = -1;    /* T_dataCodingScheme_01 */
static int hf_nr_rrc_warningAreaCoordinatesSegment = -1;  /* OCTET_STRING */
static int hf_nr_rrc_timeInfo = -1;               /* T_timeInfo */
static int hf_nr_rrc_timeInfoUTC = -1;            /* T_timeInfoUTC */
static int hf_nr_rrc_dayLightSavingTime = -1;     /* T_dayLightSavingTime */
static int hf_nr_rrc_leapSeconds = -1;            /* INTEGER_M127_128 */
static int hf_nr_rrc_localTimeOffset = -1;        /* INTEGER_M63_64 */
static int hf_nr_rrc_hrnn_List_r16 = -1;          /* HRNN_List_r16 */
static int hf_nr_rrc_HRNN_List_r16_item = -1;     /* HRNN_r16 */
static int hf_nr_rrc_hrnn_r16 = -1;               /* OCTET_STRING_SIZE_1_maxHRNN_Len_r16 */
static int hf_nr_rrc_measIdleConfigSIB_r16 = -1;  /* MeasIdleConfigSIB_r16 */
static int hf_nr_rrc_segmentNumber_r16_02 = -1;   /* INTEGER_0_63 */
static int hf_nr_rrc_segmentType_r16 = -1;        /* T_segmentType_r16 */
static int hf_nr_rrc_segmentContainer_r16 = -1;   /* OCTET_STRING */
static int hf_nr_rrc_sl_V2X_ConfigCommon_r16 = -1;  /* T_sl_V2X_ConfigCommon_r16 */
static int hf_nr_rrc_sIB13_r16_dummy = -1;        /* OCTET_STRING */
static int hf_nr_rrc_tdd_Config_r16 = -1;         /* T_tdd_Config_r16 */
static int hf_nr_rrc_sl_V2X_ConfigCommonExt_r16 = -1;  /* OCTET_STRING */
static int hf_nr_rrc_posSIB_TypeAndInfo_r16 = -1;  /* T_posSIB_TypeAndInfo_r16 */
static int hf_nr_rrc_posSIB_TypeAndInfo_r16_item = -1;  /* T_posSIB_TypeAndInfo_r16_item */
static int hf_nr_rrc_posSib1_1_r16 = -1;          /* T_posSib1_1_r16 */
static int hf_nr_rrc_posSib1_2_r16 = -1;          /* T_posSib1_2_r16 */
static int hf_nr_rrc_posSib1_3_r16 = -1;          /* T_posSib1_3_r16 */
static int hf_nr_rrc_posSib1_4_r16 = -1;          /* T_posSib1_4_r16 */
static int hf_nr_rrc_posSib1_5_r16 = -1;          /* T_posSib1_5_r16 */
static int hf_nr_rrc_posSib1_6_r16 = -1;          /* T_posSib1_6_r16 */
static int hf_nr_rrc_posSib1_7_r16 = -1;          /* T_posSib1_7_r16 */
static int hf_nr_rrc_posSib1_8_r16 = -1;          /* T_posSib1_8_r16 */
static int hf_nr_rrc_posSib2_1_r16 = -1;          /* T_posSib2_1_r16 */
static int hf_nr_rrc_posSib2_2_r16 = -1;          /* T_posSib2_2_r16 */
static int hf_nr_rrc_posSib2_3_r16 = -1;          /* T_posSib2_3_r16 */
static int hf_nr_rrc_posSib2_4_r16 = -1;          /* T_posSib2_4_r16 */
static int hf_nr_rrc_posSib2_5_r16 = -1;          /* T_posSib2_5_r16 */
static int hf_nr_rrc_posSib2_6_r16 = -1;          /* T_posSib2_6_r16 */
static int hf_nr_rrc_posSib2_7_r16 = -1;          /* T_posSib2_7_r16 */
static int hf_nr_rrc_posSib2_8_r16 = -1;          /* T_posSib2_8_r16 */
static int hf_nr_rrc_posSib2_9_r16 = -1;          /* T_posSib2_9_r16 */
static int hf_nr_rrc_posSib2_10_r16 = -1;         /* T_posSib2_10_r16 */
static int hf_nr_rrc_posSib2_11_r16 = -1;         /* T_posSib2_11_r16 */
static int hf_nr_rrc_posSib2_12_r16 = -1;         /* T_posSib2_12_r16 */
static int hf_nr_rrc_posSib2_13_r16 = -1;         /* T_posSib2_13_r16 */
static int hf_nr_rrc_posSib2_14_r16 = -1;         /* T_posSib2_14_r16 */
static int hf_nr_rrc_posSib2_15_r16 = -1;         /* T_posSib2_15_r16 */
static int hf_nr_rrc_posSib2_16_r16 = -1;         /* T_posSib2_16_r16 */
static int hf_nr_rrc_posSib2_17_r16 = -1;         /* T_posSib2_17_r16 */
static int hf_nr_rrc_posSib2_18_r16 = -1;         /* T_posSib2_18_r16 */
static int hf_nr_rrc_posSib2_19_r16 = -1;         /* T_posSib2_19_r16 */
static int hf_nr_rrc_posSib2_20_r16 = -1;         /* T_posSib2_20_r16 */
static int hf_nr_rrc_posSib2_21_r16 = -1;         /* T_posSib2_21_r16 */
static int hf_nr_rrc_posSib2_22_r16 = -1;         /* T_posSib2_22_r16 */
static int hf_nr_rrc_posSib2_23_r16 = -1;         /* T_posSib2_23_r16 */
static int hf_nr_rrc_posSib3_1_r16 = -1;          /* T_posSib3_1_r16 */
static int hf_nr_rrc_posSib4_1_r16 = -1;          /* T_posSib4_1_r16 */
static int hf_nr_rrc_posSib5_1_r16 = -1;          /* T_posSib5_1_r16 */
static int hf_nr_rrc_posSib6_1_r16 = -1;          /* T_posSib6_1_r16 */
static int hf_nr_rrc_posSib6_2_r16 = -1;          /* T_posSib6_2_r16 */
static int hf_nr_rrc_posSib6_3_r16 = -1;          /* T_posSib6_3_r16 */
static int hf_nr_rrc_nonCriticalExtension_92 = -1;  /* T_nonCriticalExtension_48 */
static int hf_nr_rrc_posSchedulingInfoList_r16 = -1;  /* SEQUENCE_SIZE_1_maxSI_Message_OF_PosSchedulingInfo_r16 */
static int hf_nr_rrc_posSchedulingInfoList_r16_item = -1;  /* PosSchedulingInfo_r16 */
static int hf_nr_rrc_posSI_RequestConfig_r16 = -1;  /* SI_RequestConfig */
static int hf_nr_rrc_posSI_RequestConfigSUL_r16 = -1;  /* SI_RequestConfig */
static int hf_nr_rrc_offsetToSI_Used_r16 = -1;    /* T_offsetToSI_Used_r16 */
static int hf_nr_rrc_posSI_Periodicity_r16 = -1;  /* T_posSI_Periodicity_r16 */
static int hf_nr_rrc_posSI_BroadcastStatus_r16 = -1;  /* T_posSI_BroadcastStatus_r16 */
static int hf_nr_rrc_posSIB_MappingInfo_r16 = -1;  /* PosSIB_MappingInfo_r16 */
static int hf_nr_rrc_PosSIB_MappingInfo_r16_item = -1;  /* PosSIB_Type_r16 */
static int hf_nr_rrc_encrypted_r16 = -1;          /* T_encrypted_r16 */
static int hf_nr_rrc_posSibType_r16_01 = -1;      /* T_posSibType_r16_01 */
static int hf_nr_rrc_areaScope_r16 = -1;          /* T_areaScope_r16 */
static int hf_nr_rrc_gnss_id_r16_01 = -1;         /* T_gnss_id_r16 */
static int hf_nr_rrc_sbas_id_r16_01 = -1;         /* T_sbas_id_r16 */
static int hf_nr_rrc_assistanceDataSIB_Element_r16 = -1;  /* T_assistanceDataSIB_Element_r16 */
static int hf_nr_rrc_availabilityCombinationsPerCellIndex_r16 = -1;  /* AvailabilityCombinationsPerCellIndex_r16 */
static int hf_nr_rrc_iab_DU_CellIdentity_r16 = -1;  /* CellIdentity */
static int hf_nr_rrc_positionInDCI_AI_r16 = -1;   /* INTEGER_0_maxAI_DCI_PayloadSize_1_r16 */
static int hf_nr_rrc_availabilityCombinations_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofAvailabilityCombinationsPerSet_r16_OF_AvailabilityCombination_r16 */
static int hf_nr_rrc_availabilityCombinations_r16_item = -1;  /* AvailabilityCombination_r16 */
static int hf_nr_rrc_availabilityCombinationId_r16 = -1;  /* AvailabilityCombinationId_r16 */
static int hf_nr_rrc_resourceAvailability_r16 = -1;  /* T_resourceAvailability_r16 */
static int hf_nr_rrc_resourceAvailability_r16_item = -1;  /* INTEGER_0_7 */
static int hf_nr_rrc_ai_RNTI_r16 = -1;            /* AI_RNTI_r16 */
static int hf_nr_rrc_dci_PayloadSizeAI_r16 = -1;  /* INTEGER_1_maxAI_DCI_PayloadSize_r16 */
static int hf_nr_rrc_availableCombToAddModList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofDUCells_r16_OF_AvailabilityCombinationsPerCell_r16 */
static int hf_nr_rrc_availableCombToAddModList_r16_item = -1;  /* AvailabilityCombinationsPerCell_r16 */
static int hf_nr_rrc_availableCombToReleaseList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofDUCells_r16_OF_AvailabilityCombinationsPerCellIndex_r16 */
static int hf_nr_rrc_availableCombToReleaseList_r16_item = -1;  /* AvailabilityCombinationsPerCellIndex_r16 */
static int hf_nr_rrc_bap_PathId_r16 = -1;         /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_rootSequenceIndex_BFR = -1;  /* INTEGER_0_137 */
static int hf_nr_rrc_rach_ConfigBFR = -1;         /* RACH_ConfigGeneric */
static int hf_nr_rrc_rsrp_ThresholdSSB = -1;      /* RSRP_Range */
static int hf_nr_rrc_candidateBeamRSList = -1;    /* SEQUENCE_SIZE_1_maxNrofCandidateBeams_OF_PRACH_ResourceDedicatedBFR */
static int hf_nr_rrc_candidateBeamRSList_item = -1;  /* PRACH_ResourceDedicatedBFR */
static int hf_nr_rrc_ssb_perRACH_Occasion = -1;   /* T_ssb_perRACH_Occasion */
static int hf_nr_rrc_ra_ssb_OccasionMaskIndex = -1;  /* INTEGER_0_15 */
static int hf_nr_rrc_recoverySearchSpaceId = -1;  /* SearchSpaceId */
static int hf_nr_rrc_ra_Prioritization = -1;      /* RA_Prioritization */
static int hf_nr_rrc_beamFailureRecoveryTimer = -1;  /* T_beamFailureRecoveryTimer */
static int hf_nr_rrc_msg1_SubcarrierSpacing = -1;  /* SubcarrierSpacing */
static int hf_nr_rrc_ra_PrioritizationTwoStep_r16 = -1;  /* RA_Prioritization */
static int hf_nr_rrc_candidateBeamRSListExt_v1610 = -1;  /* T_candidateBeamRSListExt_v1610 */
static int hf_nr_rrc_setup_13 = -1;               /* CandidateBeamRSListExt_r16 */
static int hf_nr_rrc_spCell_BFR_CBRA_r16 = -1;    /* T_spCell_BFR_CBRA_r16 */
static int hf_nr_rrc_ssb = -1;                    /* BFR_SSB_Resource */
static int hf_nr_rrc_csi_RS = -1;                 /* BFR_CSIRS_Resource */
static int hf_nr_rrc_ssb_01 = -1;                 /* SSB_Index */
static int hf_nr_rrc_ra_PreambleIndex = -1;       /* INTEGER_0_63 */
static int hf_nr_rrc_csi_RS_01 = -1;              /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_ra_OccasionList = -1;        /* T_ra_OccasionList */
static int hf_nr_rrc_ra_OccasionList_item = -1;   /* INTEGER_0_maxRA_Occasions_1 */
static int hf_nr_rrc_CandidateBeamRSListExt_r16_item = -1;  /* PRACH_ResourceDedicatedBFR */
static int hf_nr_rrc_rsrp_ThresholdBFR_r16 = -1;  /* RSRP_Range */
static int hf_nr_rrc_candidateBeamRSSCellList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofCandidateBeams_r16_OF_CandidateBeamRS_r16 */
static int hf_nr_rrc_candidateBeamRSSCellList_r16_item = -1;  /* CandidateBeamRS_r16 */
static int hf_nr_rrc_candidateBeamConfig_r16 = -1;  /* T_candidateBeamConfig_r16 */
static int hf_nr_rrc_ssb_r16 = -1;                /* SSB_Index */
static int hf_nr_rrc_csi_RS_r16 = -1;             /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_servingCellId = -1;          /* ServCellIndex */
static int hf_nr_rrc_betaOffsetACK_Index1 = -1;   /* INTEGER_0_31 */
static int hf_nr_rrc_betaOffsetACK_Index2 = -1;   /* INTEGER_0_31 */
static int hf_nr_rrc_betaOffsetACK_Index3 = -1;   /* INTEGER_0_31 */
static int hf_nr_rrc_betaOffsetCSI_Part1_Index1 = -1;  /* INTEGER_0_31 */
static int hf_nr_rrc_betaOffsetCSI_Part1_Index2 = -1;  /* INTEGER_0_31 */
static int hf_nr_rrc_betaOffsetCSI_Part2_Index1 = -1;  /* INTEGER_0_31 */
static int hf_nr_rrc_betaOffsetCSI_Part2_Index2 = -1;  /* INTEGER_0_31 */
static int hf_nr_rrc_bh_LogicalChannelIdentity_r16 = -1;  /* LogicalChannelIdentity */
static int hf_nr_rrc_bh_LogicalChannelIdentityExt_r16 = -1;  /* BH_LogicalChannelIdentity_Ext_r16 */
static int hf_nr_rrc_bh_LogicalChannelIdentity_r16_01 = -1;  /* BH_LogicalChannelIdentity_r16 */
static int hf_nr_rrc_bh_RLC_ChannelID_r16 = -1;   /* BH_RLC_ChannelID_r16 */
static int hf_nr_rrc_reestablishRLC_r16 = -1;     /* T_reestablishRLC_r16 */
static int hf_nr_rrc_rlc_Config_r16 = -1;         /* RLC_Config */
static int hf_nr_rrc_mac_LogicalChannelConfig_r16 = -1;  /* LogicalChannelConfig */
static int hf_nr_rrc_periodicBSR_Timer = -1;      /* T_periodicBSR_Timer */
static int hf_nr_rrc_retxBSR_Timer = -1;          /* T_retxBSR_Timer */
static int hf_nr_rrc_logicalChannelSR_DelayTimer = -1;  /* T_logicalChannelSR_DelayTimer */
static int hf_nr_rrc_locationAndBandwidth = -1;   /* INTEGER_0_37949 */
static int hf_nr_rrc_subcarrierSpacing = -1;      /* SubcarrierSpacing */
static int hf_nr_rrc_cyclicPrefix = -1;           /* T_cyclicPrefix */
static int hf_nr_rrc_bwp_Id = -1;                 /* BWP_Id */
static int hf_nr_rrc_bwp_Common = -1;             /* BWP_DownlinkCommon */
static int hf_nr_rrc_bwp_Dedicated = -1;          /* BWP_DownlinkDedicated */
static int hf_nr_rrc_genericParameters = -1;      /* BWP */
static int hf_nr_rrc_pdcch_ConfigCommon = -1;     /* T_pdcch_ConfigCommon */
static int hf_nr_rrc_setup_14 = -1;               /* PDCCH_ConfigCommon */
static int hf_nr_rrc_pdsch_ConfigCommon = -1;     /* T_pdsch_ConfigCommon */
static int hf_nr_rrc_setup_15 = -1;               /* PDSCH_ConfigCommon */
static int hf_nr_rrc_pdcch_Config = -1;           /* T_pdcch_Config */
static int hf_nr_rrc_setup_16 = -1;               /* PDCCH_Config */
static int hf_nr_rrc_pdsch_Config = -1;           /* T_pdsch_Config */
static int hf_nr_rrc_setup_17 = -1;               /* PDSCH_Config */
static int hf_nr_rrc_sps_Config = -1;             /* T_sps_Config */
static int hf_nr_rrc_setup_18 = -1;               /* SPS_Config */
static int hf_nr_rrc_radioLinkMonitoringConfig = -1;  /* T_radioLinkMonitoringConfig */
static int hf_nr_rrc_setup_19 = -1;               /* RadioLinkMonitoringConfig */
static int hf_nr_rrc_sps_ConfigToAddModList_r16 = -1;  /* SPS_ConfigToAddModList_r16 */
static int hf_nr_rrc_sps_ConfigToReleaseList_r16 = -1;  /* SPS_ConfigToReleaseList_r16 */
static int hf_nr_rrc_sps_ConfigDeactivationStateList_r16 = -1;  /* SPS_ConfigDeactivationStateList_r16 */
static int hf_nr_rrc_beamFailureRecoverySCellConfig_r16 = -1;  /* T_beamFailureRecoverySCellConfig_r16 */
static int hf_nr_rrc_setup_20 = -1;               /* BeamFailureRecoverySCellConfig_r16 */
static int hf_nr_rrc_sl_PDCCH_Config_r16 = -1;    /* T_sl_PDCCH_Config_r16 */
static int hf_nr_rrc_sl_V2X_PDCCH_Config_r16 = -1;  /* T_sl_V2X_PDCCH_Config_r16 */
static int hf_nr_rrc_SPS_ConfigToAddModList_r16_item = -1;  /* SPS_Config */
static int hf_nr_rrc_SPS_ConfigToReleaseList_r16_item = -1;  /* SPS_ConfigIndex_r16 */
static int hf_nr_rrc_SPS_ConfigDeactivationState_r16_item = -1;  /* SPS_ConfigIndex_r16 */
static int hf_nr_rrc_SPS_ConfigDeactivationStateList_r16_item = -1;  /* SPS_ConfigDeactivationState_r16 */
static int hf_nr_rrc_bwp_Common_01 = -1;          /* BWP_UplinkCommon */
static int hf_nr_rrc_bwp_Dedicated_01 = -1;       /* BWP_UplinkDedicated */
static int hf_nr_rrc_rach_ConfigCommon = -1;      /* T_rach_ConfigCommon */
static int hf_nr_rrc_setup_21 = -1;               /* RACH_ConfigCommon */
static int hf_nr_rrc_pusch_ConfigCommon = -1;     /* T_pusch_ConfigCommon */
static int hf_nr_rrc_setup_22 = -1;               /* PUSCH_ConfigCommon */
static int hf_nr_rrc_pucch_ConfigCommon = -1;     /* T_pucch_ConfigCommon */
static int hf_nr_rrc_setup_23 = -1;               /* PUCCH_ConfigCommon */
static int hf_nr_rrc_rach_ConfigCommonIAB_r16 = -1;  /* T_rach_ConfigCommonIAB_r16 */
static int hf_nr_rrc_useInterlacePUCCH_PUSCH_r16 = -1;  /* T_useInterlacePUCCH_PUSCH_r16 */
static int hf_nr_rrc_msgA_ConfigCommon_r16 = -1;  /* T_msgA_ConfigCommon_r16 */
static int hf_nr_rrc_setup_24 = -1;               /* MsgA_ConfigCommon_r16 */
static int hf_nr_rrc_pucch_Config = -1;           /* T_pucch_Config */
static int hf_nr_rrc_setup_25 = -1;               /* PUCCH_Config */
static int hf_nr_rrc_pusch_Config = -1;           /* T_pusch_Config */
static int hf_nr_rrc_setup_26 = -1;               /* PUSCH_Config */
static int hf_nr_rrc_configuredGrantConfig = -1;  /* T_configuredGrantConfig */
static int hf_nr_rrc_setup_27 = -1;               /* ConfiguredGrantConfig */
static int hf_nr_rrc_srs_Config = -1;             /* T_srs_Config */
static int hf_nr_rrc_setup_28 = -1;               /* SRS_Config */
static int hf_nr_rrc_beamFailureRecoveryConfig = -1;  /* T_beamFailureRecoveryConfig */
static int hf_nr_rrc_setup_29 = -1;               /* BeamFailureRecoveryConfig */
static int hf_nr_rrc_sl_PUCCH_Config_r16 = -1;    /* T_sl_PUCCH_Config_r16 */
static int hf_nr_rrc_cp_ExtensionC2_r16 = -1;     /* INTEGER_1_28 */
static int hf_nr_rrc_cp_ExtensionC3_r16 = -1;     /* INTEGER_1_28 */
static int hf_nr_rrc_useInterlacePUCCH_PUSCH_r16_01 = -1;  /* T_useInterlacePUCCH_PUSCH_r16_01 */
static int hf_nr_rrc_pucch_ConfigurationList_r16 = -1;  /* T_pucch_ConfigurationList_r16 */
static int hf_nr_rrc_setup_30 = -1;               /* PUCCH_ConfigurationList_r16 */
static int hf_nr_rrc_lbt_FailureRecoveryConfig_r16 = -1;  /* T_lbt_FailureRecoveryConfig_r16 */
static int hf_nr_rrc_setup_31 = -1;               /* LBT_FailureRecoveryConfig_r16 */
static int hf_nr_rrc_configuredGrantConfigToAddModList_r16 = -1;  /* ConfiguredGrantConfigToAddModList_r16 */
static int hf_nr_rrc_configuredGrantConfigToReleaseList_r16 = -1;  /* ConfiguredGrantConfigToReleaseList_r16 */
static int hf_nr_rrc_configuredGrantConfigType2DeactivationStateList_r16 = -1;  /* ConfiguredGrantConfigType2DeactivationStateList_r16 */
static int hf_nr_rrc_ConfiguredGrantConfigToAddModList_r16_item = -1;  /* ConfiguredGrantConfig */
static int hf_nr_rrc_ConfiguredGrantConfigToReleaseList_r16_item = -1;  /* ConfiguredGrantConfigIndex_r16 */
static int hf_nr_rrc_ConfiguredGrantConfigType2DeactivationState_r16_item = -1;  /* ConfiguredGrantConfigIndex_r16 */
static int hf_nr_rrc_ConfiguredGrantConfigType2DeactivationStateList_r16_item = -1;  /* ConfiguredGrantConfigType2DeactivationState_r16 */
static int hf_nr_rrc_plmn_IdentityInfoList = -1;  /* PLMN_IdentityInfoList */
static int hf_nr_rrc_cellReservedForOtherUse = -1;  /* T_cellReservedForOtherUse */
static int hf_nr_rrc_cellReservedForFutureUse_r16 = -1;  /* T_cellReservedForFutureUse_r16 */
static int hf_nr_rrc_npn_IdentityInfoList_r16 = -1;  /* NPN_IdentityInfoList_r16 */
static int hf_nr_rrc_plmn_IdentityList_eutra_5gc = -1;  /* PLMN_IdentityList_EUTRA_5GC */
static int hf_nr_rrc_trackingAreaCode_eutra_5gc = -1;  /* TrackingAreaCode */
static int hf_nr_rrc_ranac_5gc = -1;              /* RAN_AreaCode */
static int hf_nr_rrc_cellAccessRelatedInfo_EUTRA_5GC_cellIdentity_eutra_5gc = -1;  /* CellIdentity_EUTRA_5GC */
static int hf_nr_rrc_PLMN_IdentityList_EUTRA_5GC_item = -1;  /* PLMN_Identity_EUTRA_5GC */
static int hf_nr_rrc_plmn_Identity_EUTRA_5GC = -1;  /* PLMN_Identity */
static int hf_nr_rrc_plmn_index = -1;             /* INTEGER_1_maxPLMN */
static int hf_nr_rrc_cellIdentity_EUTRA = -1;     /* BIT_STRING_SIZE_28 */
static int hf_nr_rrc_cellId_index = -1;           /* INTEGER_1_maxPLMN */
static int hf_nr_rrc_plmn_IdentityList_eutra_epc = -1;  /* PLMN_IdentityList_EUTRA_EPC */
static int hf_nr_rrc_trackingAreaCode_eutra_epc = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_cellIdentity_eutra_epc = -1;  /* BIT_STRING_SIZE_28 */
static int hf_nr_rrc_PLMN_IdentityList_EUTRA_EPC_item = -1;  /* PLMN_Identity */
static int hf_nr_rrc_rlc_BearerToAddModList = -1;  /* SEQUENCE_SIZE_1_maxLC_ID_OF_RLC_BearerConfig */
static int hf_nr_rrc_rlc_BearerToAddModList_item = -1;  /* RLC_BearerConfig */
static int hf_nr_rrc_rlc_BearerToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxLC_ID_OF_LogicalChannelIdentity */
static int hf_nr_rrc_rlc_BearerToReleaseList_item = -1;  /* LogicalChannelIdentity */
static int hf_nr_rrc_mac_CellGroupConfig = -1;    /* MAC_CellGroupConfig */
static int hf_nr_rrc_physicalCellGroupConfig = -1;  /* PhysicalCellGroupConfig */
static int hf_nr_rrc_spCellConfig = -1;           /* SpCellConfig */
static int hf_nr_rrc_sCellToAddModList = -1;      /* SEQUENCE_SIZE_1_maxNrofSCells_OF_SCellConfig */
static int hf_nr_rrc_sCellToAddModList_item = -1;  /* SCellConfig */
static int hf_nr_rrc_sCellToReleaseList = -1;     /* SEQUENCE_SIZE_1_maxNrofSCells_OF_SCellIndex */
static int hf_nr_rrc_sCellToReleaseList_item = -1;  /* SCellIndex */
static int hf_nr_rrc_reportUplinkTxDirectCurrent = -1;  /* T_reportUplinkTxDirectCurrent */
static int hf_nr_rrc_bh_RLC_ChannelToAddModList_r16 = -1;  /* SEQUENCE_SIZE_1_maxBH_RLC_ChannelID_r16_OF_BH_RLC_ChannelConfig_r16 */
static int hf_nr_rrc_bh_RLC_ChannelToAddModList_r16_item = -1;  /* BH_RLC_ChannelConfig_r16 */
static int hf_nr_rrc_bh_RLC_ChannelToReleaseList_r16 = -1;  /* SEQUENCE_SIZE_1_maxBH_RLC_ChannelID_r16_OF_BH_RLC_ChannelID_r16 */
static int hf_nr_rrc_bh_RLC_ChannelToReleaseList_r16_item = -1;  /* BH_RLC_ChannelID_r16 */
static int hf_nr_rrc_f1c_TransferPath_r16 = -1;   /* T_f1c_TransferPath_r16 */
static int hf_nr_rrc_simultaneousTCI_UpdateList1_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofServingCellsTCI_r16_OF_ServCellIndex */
static int hf_nr_rrc_simultaneousTCI_UpdateList1_r16_item = -1;  /* ServCellIndex */
static int hf_nr_rrc_simultaneousTCI_UpdateList2_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofServingCellsTCI_r16_OF_ServCellIndex */
static int hf_nr_rrc_simultaneousTCI_UpdateList2_r16_item = -1;  /* ServCellIndex */
static int hf_nr_rrc_simultaneousSpatial_UpdatedList1_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofServingCellsTCI_r16_OF_ServCellIndex */
static int hf_nr_rrc_simultaneousSpatial_UpdatedList1_r16_item = -1;  /* ServCellIndex */
static int hf_nr_rrc_simultaneousSpatial_UpdatedList2_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofServingCellsTCI_r16_OF_ServCellIndex */
static int hf_nr_rrc_simultaneousSpatial_UpdatedList2_r16_item = -1;  /* ServCellIndex */
static int hf_nr_rrc_uplinkTxSwitchingOption_r16 = -1;  /* T_uplinkTxSwitchingOption_r16 */
static int hf_nr_rrc_uplinkTxSwitchingPowerBoosting_r16 = -1;  /* T_uplinkTxSwitchingPowerBoosting_r16 */
static int hf_nr_rrc_reportUplinkTxDirectCurrentTwoCarrier_r16 = -1;  /* T_reportUplinkTxDirectCurrentTwoCarrier_r16 */
static int hf_nr_rrc_reconfigurationWithSync = -1;  /* ReconfigurationWithSync */
static int hf_nr_rrc_rlf_TimersAndConstants = -1;  /* T_rlf_TimersAndConstants */
static int hf_nr_rrc_setup_32 = -1;               /* RLF_TimersAndConstants */
static int hf_nr_rrc_rlmInSyncOutOfSyncThreshold = -1;  /* T_rlmInSyncOutOfSyncThreshold */
static int hf_nr_rrc_spCellConfigDedicated = -1;  /* ServingCellConfig */
static int hf_nr_rrc_spCellConfigCommon = -1;     /* ServingCellConfigCommon */
static int hf_nr_rrc_newUE_Identity = -1;         /* RNTI_Value */
static int hf_nr_rrc_t304 = -1;                   /* T_t304 */
static int hf_nr_rrc_rach_ConfigDedicated = -1;   /* T_rach_ConfigDedicated */
static int hf_nr_rrc_uplink = -1;                 /* RACH_ConfigDedicated */
static int hf_nr_rrc_supplementaryUplink = -1;    /* RACH_ConfigDedicated */
static int hf_nr_rrc_daps_UplinkPowerConfig_r16 = -1;  /* DAPS_UplinkPowerConfig_r16 */
static int hf_nr_rrc_uplinkPowerSharingDAPS_Mode_r16_01 = -1;  /* T_uplinkPowerSharingDAPS_Mode_r16_01 */
static int hf_nr_rrc_sCellIndex = -1;             /* SCellIndex */
static int hf_nr_rrc_sCellConfigCommon = -1;      /* ServingCellConfigCommon */
static int hf_nr_rrc_sCellConfigDedicated = -1;   /* ServingCellConfig */
static int hf_nr_rrc_sCellState_r16 = -1;         /* T_sCellState_r16 */
static int hf_nr_rrc_secondaryDRX_GroupConfig_r16 = -1;  /* T_secondaryDRX_GroupConfig_r16 */
static int hf_nr_rrc_cgi_info_EPC = -1;           /* T_cgi_info_EPC */
static int hf_nr_rrc_cgi_info_EPC_legacy = -1;    /* CellAccessRelatedInfo_EUTRA_EPC */
static int hf_nr_rrc_cgi_info_EPC_list = -1;      /* SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_EPC */
static int hf_nr_rrc_cgi_info_EPC_list_item = -1;  /* CellAccessRelatedInfo_EUTRA_EPC */
static int hf_nr_rrc_cgi_info_5GC = -1;           /* SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_5GC */
static int hf_nr_rrc_cgi_info_5GC_item = -1;      /* CellAccessRelatedInfo_EUTRA_5GC */
static int hf_nr_rrc_freqBandIndicator = -1;      /* FreqBandIndicatorEUTRA */
static int hf_nr_rrc_multiBandInfoList = -1;      /* MultiBandInfoListEUTRA */
static int hf_nr_rrc_freqBandIndicatorPriority = -1;  /* T_freqBandIndicatorPriority */
static int hf_nr_rrc_plmn_Identity_eutra_5gc = -1;  /* PLMN_Identity */
static int hf_nr_rrc_cGI_InfoEUTRALogging_cellIdentity_eutra_5gc = -1;  /* BIT_STRING_SIZE_28 */
static int hf_nr_rrc_plmn_Identity_eutra_epc = -1;  /* PLMN_Identity */
static int hf_nr_rrc_frequencyBandList_01 = -1;   /* MultiFrequencyBandListNR */
static int hf_nr_rrc_noSIB1 = -1;                 /* T_noSIB1 */
static int hf_nr_rrc_cellReservedForOtherUse_r16 = -1;  /* T_cellReservedForOtherUse_r16 */
static int hf_nr_rrc_plmn_Identity_r16 = -1;      /* PLMN_Identity */
static int hf_nr_rrc_cellIdentity_r16 = -1;       /* CellIdentity */
static int hf_nr_rrc_trackingAreaCode_r16 = -1;   /* TrackingAreaCode */
static int hf_nr_rrc_codebookType = -1;           /* T_codebookType */
static int hf_nr_rrc_type1_01 = -1;               /* T_type1_01 */
static int hf_nr_rrc_subType = -1;                /* T_subType */
static int hf_nr_rrc_typeI_SinglePanel = -1;      /* T_typeI_SinglePanel */
static int hf_nr_rrc_nrOfAntennaPorts = -1;       /* T_nrOfAntennaPorts */
static int hf_nr_rrc_two = -1;                    /* T_two */
static int hf_nr_rrc_twoTX_CodebookSubsetRestriction = -1;  /* BIT_STRING_SIZE_6 */
static int hf_nr_rrc_moreThanTwo = -1;            /* T_moreThanTwo */
static int hf_nr_rrc_n1_n2 = -1;                  /* T_n1_n2 */
static int hf_nr_rrc_two_one_TypeI_SinglePanel_Restriction = -1;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_two_two_TypeI_SinglePanel_Restriction = -1;  /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_four_one_TypeI_SinglePanel_Restriction = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_three_two_TypeI_SinglePanel_Restriction = -1;  /* BIT_STRING_SIZE_96 */
static int hf_nr_rrc_six_one_TypeI_SinglePanel_Restriction = -1;  /* BIT_STRING_SIZE_24 */
static int hf_nr_rrc_four_two_TypeI_SinglePanel_Restriction = -1;  /* BIT_STRING_SIZE_128 */
static int hf_nr_rrc_eight_one_TypeI_SinglePanel_Restriction = -1;  /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_four_three_TypeI_SinglePanel_Restriction = -1;  /* BIT_STRING_SIZE_192 */
static int hf_nr_rrc_six_two_TypeI_SinglePanel_Restriction = -1;  /* BIT_STRING_SIZE_192 */
static int hf_nr_rrc_twelve_one_TypeI_SinglePanel_Restriction = -1;  /* BIT_STRING_SIZE_48 */
static int hf_nr_rrc_four_four_TypeI_SinglePanel_Restriction = -1;  /* BIT_STRING_SIZE_256 */
static int hf_nr_rrc_eight_two_TypeI_SinglePanel_Restriction = -1;  /* BIT_STRING_SIZE_256 */
static int hf_nr_rrc_sixteen_one_TypeI_SinglePanel_Restriction = -1;  /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_typeI_SinglePanel_codebookSubsetRestriction_i2 = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_typeI_SinglePanel_ri_Restriction = -1;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_typeI_MultiPanel = -1;       /* T_typeI_MultiPanel */
static int hf_nr_rrc_ng_n1_n2 = -1;               /* T_ng_n1_n2 */
static int hf_nr_rrc_two_two_one_TypeI_MultiPanel_Restriction = -1;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_two_four_one_TypeI_MultiPanel_Restriction = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_four_two_one_TypeI_MultiPanel_Restriction = -1;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_two_two_two_TypeI_MultiPanel_Restriction = -1;  /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_two_eight_one_TypeI_MultiPanel_Restriction = -1;  /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_four_four_one_TypeI_MultiPanel_Restriction = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_two_four_two_TypeI_MultiPanel_Restriction = -1;  /* BIT_STRING_SIZE_128 */
static int hf_nr_rrc_four_two_two_TypeI_MultiPanel_Restriction = -1;  /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_ri_Restriction = -1;         /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_codebookMode = -1;           /* INTEGER_1_2 */
static int hf_nr_rrc_type2 = -1;                  /* T_type2 */
static int hf_nr_rrc_subType_01 = -1;             /* T_subType_01 */
static int hf_nr_rrc_typeII = -1;                 /* T_typeII */
static int hf_nr_rrc_n1_n2_codebookSubsetRestriction = -1;  /* T_n1_n2_codebookSubsetRestriction */
static int hf_nr_rrc_two_one = -1;                /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_two_two = -1;                /* BIT_STRING_SIZE_43 */
static int hf_nr_rrc_four_one = -1;               /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_three_two = -1;              /* BIT_STRING_SIZE_59 */
static int hf_nr_rrc_six_one = -1;                /* BIT_STRING_SIZE_48 */
static int hf_nr_rrc_four_two = -1;               /* BIT_STRING_SIZE_75 */
static int hf_nr_rrc_eight_one = -1;              /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_four_three = -1;             /* BIT_STRING_SIZE_107 */
static int hf_nr_rrc_six_two = -1;                /* BIT_STRING_SIZE_107 */
static int hf_nr_rrc_twelve_one = -1;             /* BIT_STRING_SIZE_96 */
static int hf_nr_rrc_four_four = -1;              /* BIT_STRING_SIZE_139 */
static int hf_nr_rrc_eight_two = -1;              /* BIT_STRING_SIZE_139 */
static int hf_nr_rrc_sixteen_one = -1;            /* BIT_STRING_SIZE_128 */
static int hf_nr_rrc_typeII_RI_Restriction = -1;  /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_typeII_PortSelection = -1;   /* T_typeII_PortSelection */
static int hf_nr_rrc_portSelectionSamplingSize = -1;  /* T_portSelectionSamplingSize */
static int hf_nr_rrc_typeII_PortSelectionRI_Restriction = -1;  /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_phaseAlphabetSize = -1;      /* T_phaseAlphabetSize */
static int hf_nr_rrc_subbandAmplitude = -1;       /* BOOLEAN */
static int hf_nr_rrc_numberOfBeams = -1;          /* T_numberOfBeams */
static int hf_nr_rrc_codebookType_01 = -1;        /* T_codebookType_01 */
static int hf_nr_rrc_type2_01 = -1;               /* T_type2_01 */
static int hf_nr_rrc_subType_02 = -1;             /* T_subType_02 */
static int hf_nr_rrc_typeII_r16 = -1;             /* T_typeII_r16 */
static int hf_nr_rrc_n1_n2_codebookSubsetRestriction_r16 = -1;  /* T_n1_n2_codebookSubsetRestriction_r16 */
static int hf_nr_rrc_typeII_RI_Restriction_r16 = -1;  /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_typeII_PortSelection_r16 = -1;  /* T_typeII_PortSelection_r16 */
static int hf_nr_rrc_portSelectionSamplingSize_r16 = -1;  /* T_portSelectionSamplingSize_r16 */
static int hf_nr_rrc_typeII_PortSelectionRI_Restriction_r16 = -1;  /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_numberOfPMI_SubbandsPerCQI_Subband_r16 = -1;  /* INTEGER_1_2 */
static int hf_nr_rrc_paramCombination_r16 = -1;   /* INTEGER_1_8 */
static int hf_nr_rrc_gnss_TOD_msec_r16 = -1;      /* OCTET_STRING */
static int hf_nr_rrc_locationTimestamp_r16 = -1;  /* T_locationTimestamp_r16 */
static int hf_nr_rrc_locationCoordinate_r16 = -1;  /* T_locationCoordinate_r16 */
static int hf_nr_rrc_locationError_r16 = -1;      /* T_locationError_r16 */
static int hf_nr_rrc_locationSource_r16 = -1;     /* T_locationSource_r16 */
static int hf_nr_rrc_velocityEstimate_r16 = -1;   /* T_velocityEstimate_r16 */
static int hf_nr_rrc_CondReconfigToAddModList_r16_item = -1;  /* CondReconfigToAddMod_r16 */
static int hf_nr_rrc_condReconfigId_r16 = -1;     /* CondReconfigId_r16 */
static int hf_nr_rrc_condExecutionCond_r16 = -1;  /* SEQUENCE_SIZE_1_2_OF_MeasId */
static int hf_nr_rrc_condExecutionCond_r16_item = -1;  /* MeasId */
static int hf_nr_rrc_condRRCReconfig_r16 = -1;    /* T_condRRCReconfig_r16 */
static int hf_nr_rrc_attemptCondReconfig_r16 = -1;  /* T_attemptCondReconfig_r16 */
static int hf_nr_rrc_condReconfigToRemoveList_r16 = -1;  /* CondReconfigToRemoveList_r16 */
static int hf_nr_rrc_condReconfigToAddModList_r16 = -1;  /* CondReconfigToAddModList_r16 */
static int hf_nr_rrc_CondReconfigToRemoveList_r16_item = -1;  /* CondReconfigId_r16 */
static int hf_nr_rrc_frequencyHopping = -1;       /* T_frequencyHopping */
static int hf_nr_rrc_cg_DMRS_Configuration = -1;  /* DMRS_UplinkConfig */
static int hf_nr_rrc_mcs_Table = -1;              /* T_mcs_Table */
static int hf_nr_rrc_mcs_TableTransformPrecoder = -1;  /* T_mcs_TableTransformPrecoder */
static int hf_nr_rrc_uci_OnPUSCH = -1;            /* T_uci_OnPUSCH */
static int hf_nr_rrc_setup_33 = -1;               /* CG_UCI_OnPUSCH */
static int hf_nr_rrc_resourceAllocation = -1;     /* T_resourceAllocation */
static int hf_nr_rrc_rbg_Size = -1;               /* T_rbg_Size */
static int hf_nr_rrc_powerControlLoopToUse = -1;  /* T_powerControlLoopToUse */
static int hf_nr_rrc_p0_PUSCH_Alpha = -1;         /* P0_PUSCH_AlphaSetId */
static int hf_nr_rrc_transformPrecoder = -1;      /* T_transformPrecoder */
static int hf_nr_rrc_nrofHARQ_Processes = -1;     /* INTEGER_1_16 */
static int hf_nr_rrc_repK = -1;                   /* T_repK */
static int hf_nr_rrc_repK_RV = -1;                /* T_repK_RV */
static int hf_nr_rrc_periodicity = -1;            /* T_periodicity */
static int hf_nr_rrc_configuredGrantTimer = -1;   /* INTEGER_1_64 */
static int hf_nr_rrc_rrc_ConfiguredUplinkGrant = -1;  /* T_rrc_ConfiguredUplinkGrant */
static int hf_nr_rrc_timeDomainOffset = -1;       /* INTEGER_0_5119 */
static int hf_nr_rrc_timeDomainAllocation = -1;   /* INTEGER_0_15 */
static int hf_nr_rrc_configuredGrantConfig_rrc_ConfiguredUplinkGrant_frequencyDomainAllocation = -1;  /* BIT_STRING_SIZE_18 */
static int hf_nr_rrc_antennaPort = -1;            /* INTEGER_0_31 */
static int hf_nr_rrc_dmrs_SeqInitialization = -1;  /* INTEGER_0_1 */
static int hf_nr_rrc_precodingAndNumberOfLayers = -1;  /* INTEGER_0_63 */
static int hf_nr_rrc_srs_ResourceIndicator = -1;  /* INTEGER_0_15 */
static int hf_nr_rrc_mcsAndTBS = -1;              /* INTEGER_0_31 */
static int hf_nr_rrc_frequencyHoppingOffset = -1;  /* INTEGER_1_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_pathlossReferenceIndex = -1;  /* INTEGER_0_maxNrofPUSCH_PathlossReferenceRSs_1 */
static int hf_nr_rrc_pusch_RepTypeIndicator_r16 = -1;  /* T_pusch_RepTypeIndicator_r16 */
static int hf_nr_rrc_frequencyHoppingPUSCH_RepTypeB_r16 = -1;  /* T_frequencyHoppingPUSCH_RepTypeB_r16 */
static int hf_nr_rrc_timeReferenceSFN_r16 = -1;   /* T_timeReferenceSFN_r16 */
static int hf_nr_rrc_cg_RetransmissionTimer_r16 = -1;  /* INTEGER_1_64 */
static int hf_nr_rrc_cg_minDFI_Delay_r16 = -1;    /* T_cg_minDFI_Delay_r16 */
static int hf_nr_rrc_cg_nrofPUSCH_InSlot_r16 = -1;  /* INTEGER_1_7 */
static int hf_nr_rrc_cg_nrofSlots_r16 = -1;       /* INTEGER_1_40 */
static int hf_nr_rrc_cg_StartingOffsets_r16 = -1;  /* CG_StartingOffsets_r16 */
static int hf_nr_rrc_cg_UCI_Multiplexing_r16 = -1;  /* T_cg_UCI_Multiplexing_r16 */
static int hf_nr_rrc_cg_COT_SharingOffset_r16 = -1;  /* INTEGER_1_39 */
static int hf_nr_rrc_betaOffsetCG_UCI_r16 = -1;   /* INTEGER_0_31 */
static int hf_nr_rrc_cg_COT_SharingList_r16 = -1;  /* SEQUENCE_SIZE_1_1709_OF_CG_COT_Sharing_r16 */
static int hf_nr_rrc_cg_COT_SharingList_r16_item = -1;  /* CG_COT_Sharing_r16 */
static int hf_nr_rrc_harq_ProcID_Offset_r16 = -1;  /* INTEGER_0_15 */
static int hf_nr_rrc_harq_ProcID_Offset2_r16 = -1;  /* INTEGER_0_15 */
static int hf_nr_rrc_configuredGrantConfigIndex_r16 = -1;  /* ConfiguredGrantConfigIndex_r16 */
static int hf_nr_rrc_configuredGrantConfigIndexMAC_r16 = -1;  /* ConfiguredGrantConfigIndexMAC_r16 */
static int hf_nr_rrc_periodicityExt_r16 = -1;     /* INTEGER_1_5120 */
static int hf_nr_rrc_startingFromRV0_r16 = -1;    /* T_startingFromRV0_r16 */
static int hf_nr_rrc_phy_PriorityIndex_r16 = -1;  /* T_phy_PriorityIndex_r16 */
static int hf_nr_rrc_autonomousTx_r16 = -1;       /* T_autonomousTx_r16 */
static int hf_nr_rrc_dynamic = -1;                /* SEQUENCE_SIZE_1_4_OF_BetaOffsets */
static int hf_nr_rrc_dynamic_item = -1;           /* BetaOffsets */
static int hf_nr_rrc_semiStatic = -1;             /* BetaOffsets */
static int hf_nr_rrc_noCOT_Sharing_r16 = -1;      /* NULL */
static int hf_nr_rrc_cot_Sharing_r16 = -1;        /* T_cot_Sharing_r16 */
static int hf_nr_rrc_duration_r16 = -1;           /* INTEGER_1_39 */
static int hf_nr_rrc_offset_r16 = -1;             /* INTEGER_1_39 */
static int hf_nr_rrc_channelAccessPriority_r16 = -1;  /* INTEGER_1_4 */
static int hf_nr_rrc_cg_StartingFullBW_InsideCOT_r16 = -1;  /* T_cg_StartingFullBW_InsideCOT_r16 */
static int hf_nr_rrc_cg_StartingFullBW_InsideCOT_r16_item = -1;  /* INTEGER_0_6 */
static int hf_nr_rrc_cg_StartingFullBW_OutsideCOT_r16 = -1;  /* T_cg_StartingFullBW_OutsideCOT_r16 */
static int hf_nr_rrc_cg_StartingFullBW_OutsideCOT_r16_item = -1;  /* INTEGER_0_6 */
static int hf_nr_rrc_cg_StartingPartialBW_InsideCOT_r16 = -1;  /* INTEGER_0_6 */
static int hf_nr_rrc_cg_StartingPartialBW_OutsideCOT_r16 = -1;  /* INTEGER_0_6 */
static int hf_nr_rrc_connEstFailCount = -1;       /* T_connEstFailCount */
static int hf_nr_rrc_connEstFailOffsetValidity = -1;  /* T_connEstFailOffsetValidity */
static int hf_nr_rrc_connEstFailOffset = -1;      /* INTEGER_0_15 */
static int hf_nr_rrc_controlResourceSetId = -1;   /* ControlResourceSetId */
static int hf_nr_rrc_frequencyDomainResources = -1;  /* BIT_STRING_SIZE_45 */
static int hf_nr_rrc_duration = -1;               /* INTEGER_1_maxCoReSetDuration */
static int hf_nr_rrc_cce_REG_MappingType = -1;    /* T_cce_REG_MappingType */
static int hf_nr_rrc_interleaved = -1;            /* T_interleaved */
static int hf_nr_rrc_reg_BundleSize = -1;         /* T_reg_BundleSize */
static int hf_nr_rrc_interleaverSize = -1;        /* T_interleaverSize */
static int hf_nr_rrc_shiftIndex = -1;             /* INTEGER_0_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_nonInterleaved = -1;         /* NULL */
static int hf_nr_rrc_precoderGranularity = -1;    /* T_precoderGranularity */
static int hf_nr_rrc_tci_StatesPDCCH_ToAddList = -1;  /* SEQUENCE_SIZE_1_maxNrofTCI_StatesPDCCH_OF_TCI_StateId */
static int hf_nr_rrc_tci_StatesPDCCH_ToAddList_item = -1;  /* TCI_StateId */
static int hf_nr_rrc_tci_StatesPDCCH_ToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofTCI_StatesPDCCH_OF_TCI_StateId */
static int hf_nr_rrc_tci_StatesPDCCH_ToReleaseList_item = -1;  /* TCI_StateId */
static int hf_nr_rrc_tci_PresentInDCI = -1;       /* T_tci_PresentInDCI */
static int hf_nr_rrc_pdcch_DMRS_ScramblingID = -1;  /* INTEGER_0_65535 */
static int hf_nr_rrc_rb_Offset_r16 = -1;          /* INTEGER_0_5 */
static int hf_nr_rrc_tci_PresentDCI_1_2_r16 = -1;  /* INTEGER_1_3 */
static int hf_nr_rrc_coresetPoolIndex_r16 = -1;   /* INTEGER_0_1 */
static int hf_nr_rrc_controlResourceSetId_v1610 = -1;  /* ControlResourceSetId_v1610 */
static int hf_nr_rrc_schedulingCellInfo = -1;     /* T_schedulingCellInfo */
static int hf_nr_rrc_own = -1;                    /* T_own */
static int hf_nr_rrc_cif_Presence = -1;           /* BOOLEAN */
static int hf_nr_rrc_other = -1;                  /* T_other */
static int hf_nr_rrc_schedulingCellId = -1;       /* ServCellIndex */
static int hf_nr_rrc_cif_InSchedulingCell = -1;   /* INTEGER_1_7 */
static int hf_nr_rrc_carrierIndicatorSize_r16 = -1;  /* T_carrierIndicatorSize_r16 */
static int hf_nr_rrc_carrierIndicatorSizeDCI_1_2_r16 = -1;  /* INTEGER_0_3 */
static int hf_nr_rrc_carrierIndicatorSizeDCI_0_2_r16 = -1;  /* INTEGER_0_3 */
static int hf_nr_rrc_enableDefaultBeamForCCS_r16 = -1;  /* T_enableDefaultBeamForCCS_r16 */
static int hf_nr_rrc_CSI_AperiodicTriggerStateList_item = -1;  /* CSI_AperiodicTriggerState */
static int hf_nr_rrc_associatedReportConfigInfoList = -1;  /* SEQUENCE_SIZE_1_maxNrofReportConfigPerAperiodicTrigger_OF_CSI_AssociatedReportConfigInfo */
static int hf_nr_rrc_associatedReportConfigInfoList_item = -1;  /* CSI_AssociatedReportConfigInfo */
static int hf_nr_rrc_reportConfigId = -1;         /* CSI_ReportConfigId */
static int hf_nr_rrc_resourcesForChannel = -1;    /* T_resourcesForChannel */
static int hf_nr_rrc_nzp_CSI_RS = -1;             /* T_nzp_CSI_RS */
static int hf_nr_rrc_resourceSet = -1;            /* INTEGER_1_maxNrofNZP_CSI_RS_ResourceSetsPerConfig */
static int hf_nr_rrc_qcl_info = -1;               /* SEQUENCE_SIZE_1_maxNrofAP_CSI_RS_ResourcesPerSet_OF_TCI_StateId */
static int hf_nr_rrc_qcl_info_item = -1;          /* TCI_StateId */
static int hf_nr_rrc_csi_SSB_ResourceSet = -1;    /* INTEGER_1_maxNrofCSI_SSB_ResourceSetsPerConfig */
static int hf_nr_rrc_csi_IM_ResourcesForInterference = -1;  /* INTEGER_1_maxNrofCSI_IM_ResourceSetsPerConfig */
static int hf_nr_rrc_nzp_CSI_RS_ResourcesForInterference = -1;  /* INTEGER_1_maxNrofNZP_CSI_RS_ResourceSetsPerConfig */
static int hf_nr_rrc_startingRB = -1;             /* INTEGER_0_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_nrofRBs = -1;                /* INTEGER_24_maxNrofPhysicalResourceBlocksPlus1 */
static int hf_nr_rrc_csi_IM_ResourceId = -1;      /* CSI_IM_ResourceId */
static int hf_nr_rrc_csi_IM_ResourceElementPattern = -1;  /* T_csi_IM_ResourceElementPattern */
static int hf_nr_rrc_pattern0 = -1;               /* T_pattern0 */
static int hf_nr_rrc_subcarrierLocation_p0 = -1;  /* T_subcarrierLocation_p0 */
static int hf_nr_rrc_symbolLocation_p0 = -1;      /* INTEGER_0_12 */
static int hf_nr_rrc_pattern1 = -1;               /* T_pattern1 */
static int hf_nr_rrc_subcarrierLocation_p1 = -1;  /* T_subcarrierLocation_p1 */
static int hf_nr_rrc_symbolLocation_p1 = -1;      /* INTEGER_0_13 */
static int hf_nr_rrc_freqBand = -1;               /* CSI_FrequencyOccupation */
static int hf_nr_rrc_periodicityAndOffset = -1;   /* CSI_ResourcePeriodicityAndOffset */
static int hf_nr_rrc_csi_IM_ResourceSetId = -1;   /* CSI_IM_ResourceSetId */
static int hf_nr_rrc_csi_IM_Resources = -1;       /* SEQUENCE_SIZE_1_maxNrofCSI_IM_ResourcesPerSet_OF_CSI_IM_ResourceId */
static int hf_nr_rrc_csi_IM_Resources_item = -1;  /* CSI_IM_ResourceId */
static int hf_nr_rrc_nzp_CSI_RS_ResourceToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_Resources_OF_NZP_CSI_RS_Resource */
static int hf_nr_rrc_nzp_CSI_RS_ResourceToAddModList_item = -1;  /* NZP_CSI_RS_Resource */
static int hf_nr_rrc_nzp_CSI_RS_ResourceToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_Resources_OF_NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_nzp_CSI_RS_ResourceToReleaseList_item = -1;  /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_nzp_CSI_RS_ResourceSetToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourceSets_OF_NZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_nzp_CSI_RS_ResourceSetToAddModList_item = -1;  /* NZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_nzp_CSI_RS_ResourceSetToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourceSets_OF_NZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_nzp_CSI_RS_ResourceSetToReleaseList_item = -1;  /* NZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_csi_IM_ResourceToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_IM_Resources_OF_CSI_IM_Resource */
static int hf_nr_rrc_csi_IM_ResourceToAddModList_item = -1;  /* CSI_IM_Resource */
static int hf_nr_rrc_csi_IM_ResourceToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_IM_Resources_OF_CSI_IM_ResourceId */
static int hf_nr_rrc_csi_IM_ResourceToReleaseList_item = -1;  /* CSI_IM_ResourceId */
static int hf_nr_rrc_csi_IM_ResourceSetToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_IM_ResourceSets_OF_CSI_IM_ResourceSet */
static int hf_nr_rrc_csi_IM_ResourceSetToAddModList_item = -1;  /* CSI_IM_ResourceSet */
static int hf_nr_rrc_csi_IM_ResourceSetToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_IM_ResourceSets_OF_CSI_IM_ResourceSetId */
static int hf_nr_rrc_csi_IM_ResourceSetToReleaseList_item = -1;  /* CSI_IM_ResourceSetId */
static int hf_nr_rrc_csi_SSB_ResourceSetToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_SSB_ResourceSets_OF_CSI_SSB_ResourceSet */
static int hf_nr_rrc_csi_SSB_ResourceSetToAddModList_item = -1;  /* CSI_SSB_ResourceSet */
static int hf_nr_rrc_csi_SSB_ResourceSetToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_SSB_ResourceSets_OF_CSI_SSB_ResourceSetId */
static int hf_nr_rrc_csi_SSB_ResourceSetToReleaseList_item = -1;  /* CSI_SSB_ResourceSetId */
static int hf_nr_rrc_csi_ResourceConfigToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_ResourceConfigurations_OF_CSI_ResourceConfig */
static int hf_nr_rrc_csi_ResourceConfigToAddModList_item = -1;  /* CSI_ResourceConfig */
static int hf_nr_rrc_csi_ResourceConfigToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_ResourceConfigurations_OF_CSI_ResourceConfigId */
static int hf_nr_rrc_csi_ResourceConfigToReleaseList_item = -1;  /* CSI_ResourceConfigId */
static int hf_nr_rrc_csi_ReportConfigToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_ReportConfigurations_OF_CSI_ReportConfig */
static int hf_nr_rrc_csi_ReportConfigToAddModList_item = -1;  /* CSI_ReportConfig */
static int hf_nr_rrc_csi_ReportConfigToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_ReportConfigurations_OF_CSI_ReportConfigId */
static int hf_nr_rrc_csi_ReportConfigToReleaseList_item = -1;  /* CSI_ReportConfigId */
static int hf_nr_rrc_reportTriggerSize = -1;      /* INTEGER_0_6 */
static int hf_nr_rrc_aperiodicTriggerStateList = -1;  /* T_aperiodicTriggerStateList */
static int hf_nr_rrc_setup_34 = -1;               /* CSI_AperiodicTriggerStateList */
static int hf_nr_rrc_semiPersistentOnPUSCH_TriggerStateList = -1;  /* T_semiPersistentOnPUSCH_TriggerStateList */
static int hf_nr_rrc_setup_35 = -1;               /* CSI_SemiPersistentOnPUSCH_TriggerStateList */
static int hf_nr_rrc_reportTriggerSizeDCI_0_2_r16 = -1;  /* INTEGER_0_6 */
static int hf_nr_rrc_carrier = -1;                /* ServCellIndex */
static int hf_nr_rrc_resourcesForChannelMeasurement = -1;  /* CSI_ResourceConfigId */
static int hf_nr_rrc_csi_IM_ResourcesForInterference_01 = -1;  /* CSI_ResourceConfigId */
static int hf_nr_rrc_nzp_CSI_RS_ResourcesForInterference_01 = -1;  /* CSI_ResourceConfigId */
static int hf_nr_rrc_reportConfigType = -1;       /* T_reportConfigType */
static int hf_nr_rrc_periodic = -1;               /* T_periodic */
static int hf_nr_rrc_reportSlotConfig = -1;       /* CSI_ReportPeriodicityAndOffset */
static int hf_nr_rrc_pucch_CSI_ResourceList = -1;  /* SEQUENCE_SIZE_1_maxNrofBWPs_OF_PUCCH_CSI_Resource */
static int hf_nr_rrc_pucch_CSI_ResourceList_item = -1;  /* PUCCH_CSI_Resource */
static int hf_nr_rrc_semiPersistentOnPUCCH = -1;  /* T_semiPersistentOnPUCCH */
static int hf_nr_rrc_semiPersistentOnPUSCH = -1;  /* T_semiPersistentOnPUSCH */
static int hf_nr_rrc_reportSlotConfig_01 = -1;    /* T_reportSlotConfig */
static int hf_nr_rrc_reportSlotOffsetList = -1;   /* T_reportSlotOffsetList */
static int hf_nr_rrc_reportSlotOffsetList_item = -1;  /* INTEGER_0_32 */
static int hf_nr_rrc_p0alpha = -1;                /* P0_PUSCH_AlphaSetId */
static int hf_nr_rrc_aperiodic = -1;              /* T_aperiodic */
static int hf_nr_rrc_reportSlotOffsetList_01 = -1;  /* T_reportSlotOffsetList_01 */
static int hf_nr_rrc_reportQuantity = -1;         /* T_reportQuantity */
static int hf_nr_rrc_none = -1;                   /* NULL */
static int hf_nr_rrc_cri_RI_PMI_CQI = -1;         /* NULL */
static int hf_nr_rrc_cri_RI_i1 = -1;              /* NULL */
static int hf_nr_rrc_cri_RI_i1_CQI = -1;          /* T_cri_RI_i1_CQI */
static int hf_nr_rrc_pdsch_BundleSizeForCSI = -1;  /* T_pdsch_BundleSizeForCSI */
static int hf_nr_rrc_cri_RI_CQI = -1;             /* NULL */
static int hf_nr_rrc_cri_RSRP = -1;               /* NULL */
static int hf_nr_rrc_ssb_Index_RSRP = -1;         /* NULL */
static int hf_nr_rrc_cri_RI_LI_PMI_CQI = -1;      /* NULL */
static int hf_nr_rrc_reportFreqConfiguration = -1;  /* T_reportFreqConfiguration */
static int hf_nr_rrc_cqi_FormatIndicator = -1;    /* T_cqi_FormatIndicator */
static int hf_nr_rrc_pmi_FormatIndicator = -1;    /* T_pmi_FormatIndicator */
static int hf_nr_rrc_csi_ReportingBand = -1;      /* T_csi_ReportingBand */
static int hf_nr_rrc_subbands3 = -1;              /* BIT_STRING_SIZE_3 */
static int hf_nr_rrc_subbands4 = -1;              /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_subbands5 = -1;              /* BIT_STRING_SIZE_5 */
static int hf_nr_rrc_subbands6 = -1;              /* BIT_STRING_SIZE_6 */
static int hf_nr_rrc_subbands7 = -1;              /* BIT_STRING_SIZE_7 */
static int hf_nr_rrc_subbands8 = -1;              /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_subbands9 = -1;              /* BIT_STRING_SIZE_9 */
static int hf_nr_rrc_subbands10 = -1;             /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_subbands11 = -1;             /* BIT_STRING_SIZE_11 */
static int hf_nr_rrc_subbands12 = -1;             /* BIT_STRING_SIZE_12 */
static int hf_nr_rrc_subbands13 = -1;             /* BIT_STRING_SIZE_13 */
static int hf_nr_rrc_subbands14 = -1;             /* BIT_STRING_SIZE_14 */
static int hf_nr_rrc_subbands15 = -1;             /* BIT_STRING_SIZE_15 */
static int hf_nr_rrc_subbands16 = -1;             /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_subbands17 = -1;             /* BIT_STRING_SIZE_17 */
static int hf_nr_rrc_subbands18 = -1;             /* BIT_STRING_SIZE_18 */
static int hf_nr_rrc_subbands19_v1530 = -1;       /* BIT_STRING_SIZE_19 */
static int hf_nr_rrc_timeRestrictionForChannelMeasurements = -1;  /* T_timeRestrictionForChannelMeasurements */
static int hf_nr_rrc_timeRestrictionForInterferenceMeasurements = -1;  /* T_timeRestrictionForInterferenceMeasurements */
static int hf_nr_rrc_codebookConfig = -1;         /* CodebookConfig */
static int hf_nr_rrc_cSI_ReportConfig_dummy = -1;  /* T_cSI_ReportConfig_dummy */
static int hf_nr_rrc_groupBasedBeamReporting = -1;  /* T_groupBasedBeamReporting */
static int hf_nr_rrc_enabled = -1;                /* NULL */
static int hf_nr_rrc_disabled = -1;               /* T_disabled */
static int hf_nr_rrc_nrofReportedRS = -1;         /* T_nrofReportedRS */
static int hf_nr_rrc_cqi_Table = -1;              /* T_cqi_Table */
static int hf_nr_rrc_subbandSize = -1;            /* T_subbandSize */
static int hf_nr_rrc_non_PMI_PortIndication = -1;  /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourcesPerConfig_OF_PortIndexFor8Ranks */
static int hf_nr_rrc_non_PMI_PortIndication_item = -1;  /* PortIndexFor8Ranks */
static int hf_nr_rrc_semiPersistentOnPUSCH_v1530 = -1;  /* T_semiPersistentOnPUSCH_v1530 */
static int hf_nr_rrc_reportSlotConfig_v1530 = -1;  /* T_reportSlotConfig_v1530 */
static int hf_nr_rrc_semiPersistentOnPUSCH_v1610 = -1;  /* T_semiPersistentOnPUSCH_v1610 */
static int hf_nr_rrc_reportSlotOffsetListDCI_0_2_r16 = -1;  /* T_reportSlotOffsetListDCI_0_2_r16 */
static int hf_nr_rrc_reportSlotOffsetListDCI_0_2_r16_item = -1;  /* INTEGER_0_32 */
static int hf_nr_rrc_reportSlotOffsetListDCI_0_1_r16 = -1;  /* T_reportSlotOffsetListDCI_0_1_r16 */
static int hf_nr_rrc_reportSlotOffsetListDCI_0_1_r16_item = -1;  /* INTEGER_0_32 */
static int hf_nr_rrc_aperiodic_v1610 = -1;        /* T_aperiodic_v1610 */
static int hf_nr_rrc_reportSlotOffsetListDCI_0_2_r16_01 = -1;  /* T_reportSlotOffsetListDCI_0_2_r16_01 */
static int hf_nr_rrc_reportSlotOffsetListDCI_0_1_r16_01 = -1;  /* T_reportSlotOffsetListDCI_0_1_r16_01 */
static int hf_nr_rrc_reportQuantity_r16 = -1;     /* T_reportQuantity_r16 */
static int hf_nr_rrc_cri_SINR_r16 = -1;           /* NULL */
static int hf_nr_rrc_ssb_Index_SINR_r16 = -1;     /* NULL */
static int hf_nr_rrc_codebookConfig_r16 = -1;     /* CodebookConfig_r16 */
static int hf_nr_rrc_slots4 = -1;                 /* INTEGER_0_3 */
static int hf_nr_rrc_slots5 = -1;                 /* INTEGER_0_4 */
static int hf_nr_rrc_slots8 = -1;                 /* INTEGER_0_7 */
static int hf_nr_rrc_slots10 = -1;                /* INTEGER_0_9 */
static int hf_nr_rrc_slots16 = -1;                /* INTEGER_0_15 */
static int hf_nr_rrc_slots20 = -1;                /* INTEGER_0_19 */
static int hf_nr_rrc_slots40 = -1;                /* INTEGER_0_39 */
static int hf_nr_rrc_slots80 = -1;                /* INTEGER_0_79 */
static int hf_nr_rrc_slots160 = -1;               /* INTEGER_0_159 */
static int hf_nr_rrc_slots320 = -1;               /* INTEGER_0_319 */
static int hf_nr_rrc_uplinkBandwidthPartId = -1;  /* BWP_Id */
static int hf_nr_rrc_pucch_Resource = -1;         /* PUCCH_ResourceId */
static int hf_nr_rrc_portIndex8 = -1;             /* T_portIndex8 */
static int hf_nr_rrc_rank1_8 = -1;                /* PortIndex8 */
static int hf_nr_rrc_rank2_8 = -1;                /* SEQUENCE_SIZE_2_OF_PortIndex8 */
static int hf_nr_rrc_rank2_8_item = -1;           /* PortIndex8 */
static int hf_nr_rrc_rank3_8 = -1;                /* SEQUENCE_SIZE_3_OF_PortIndex8 */
static int hf_nr_rrc_rank3_8_item = -1;           /* PortIndex8 */
static int hf_nr_rrc_rank4_8 = -1;                /* SEQUENCE_SIZE_4_OF_PortIndex8 */
static int hf_nr_rrc_rank4_8_item = -1;           /* PortIndex8 */
static int hf_nr_rrc_rank5_8 = -1;                /* SEQUENCE_SIZE_5_OF_PortIndex8 */
static int hf_nr_rrc_rank5_8_item = -1;           /* PortIndex8 */
static int hf_nr_rrc_rank6_8 = -1;                /* SEQUENCE_SIZE_6_OF_PortIndex8 */
static int hf_nr_rrc_rank6_8_item = -1;           /* PortIndex8 */
static int hf_nr_rrc_rank7_8 = -1;                /* SEQUENCE_SIZE_7_OF_PortIndex8 */
static int hf_nr_rrc_rank7_8_item = -1;           /* PortIndex8 */
static int hf_nr_rrc_rank8_8 = -1;                /* SEQUENCE_SIZE_8_OF_PortIndex8 */
static int hf_nr_rrc_rank8_8_item = -1;           /* PortIndex8 */
static int hf_nr_rrc_portIndex4 = -1;             /* T_portIndex4 */
static int hf_nr_rrc_rank1_4 = -1;                /* PortIndex4 */
static int hf_nr_rrc_rank2_4 = -1;                /* SEQUENCE_SIZE_2_OF_PortIndex4 */
static int hf_nr_rrc_rank2_4_item = -1;           /* PortIndex4 */
static int hf_nr_rrc_rank3_4 = -1;                /* SEQUENCE_SIZE_3_OF_PortIndex4 */
static int hf_nr_rrc_rank3_4_item = -1;           /* PortIndex4 */
static int hf_nr_rrc_rank4_4 = -1;                /* SEQUENCE_SIZE_4_OF_PortIndex4 */
static int hf_nr_rrc_rank4_4_item = -1;           /* PortIndex4 */
static int hf_nr_rrc_portIndex2 = -1;             /* T_portIndex2 */
static int hf_nr_rrc_rank1_2 = -1;                /* PortIndex2 */
static int hf_nr_rrc_rank2_2 = -1;                /* SEQUENCE_SIZE_2_OF_PortIndex2 */
static int hf_nr_rrc_rank2_2_item = -1;           /* PortIndex2 */
static int hf_nr_rrc_portIndex1 = -1;             /* NULL */
static int hf_nr_rrc_csi_ResourceConfigId = -1;   /* CSI_ResourceConfigId */
static int hf_nr_rrc_csi_RS_ResourceSetList = -1;  /* T_csi_RS_ResourceSetList */
static int hf_nr_rrc_nzp_CSI_RS_SSB = -1;         /* T_nzp_CSI_RS_SSB */
static int hf_nr_rrc_nzp_CSI_RS_ResourceSetList = -1;  /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourceSetsPerConfig_OF_NZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_nzp_CSI_RS_ResourceSetList_item = -1;  /* NZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_csi_SSB_ResourceSetList = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_SSB_ResourceSetsPerConfig_OF_CSI_SSB_ResourceSetId */
static int hf_nr_rrc_csi_SSB_ResourceSetList_item = -1;  /* CSI_SSB_ResourceSetId */
static int hf_nr_rrc_csi_IM_ResourceSetList = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_IM_ResourceSetsPerConfig_OF_CSI_IM_ResourceSetId */
static int hf_nr_rrc_csi_IM_ResourceSetList_item = -1;  /* CSI_IM_ResourceSetId */
static int hf_nr_rrc_resourceType = -1;           /* T_resourceType */
static int hf_nr_rrc_slots32 = -1;                /* INTEGER_0_31 */
static int hf_nr_rrc_slots64 = -1;                /* INTEGER_0_63 */
static int hf_nr_rrc_slots640 = -1;               /* INTEGER_0_639 */
static int hf_nr_rrc_csi_RS_CellList_Mobility = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_RS_CellsRRM_OF_CSI_RS_CellMobility */
static int hf_nr_rrc_csi_RS_CellList_Mobility_item = -1;  /* CSI_RS_CellMobility */
static int hf_nr_rrc_refServCellIndex = -1;       /* ServCellIndex */
static int hf_nr_rrc_cellId = -1;                 /* PhysCellId */
static int hf_nr_rrc_csi_rs_MeasurementBW = -1;   /* T_csi_rs_MeasurementBW */
static int hf_nr_rrc_nrofPRBs = -1;               /* T_nrofPRBs */
static int hf_nr_rrc_startPRB = -1;               /* INTEGER_0_2169 */
static int hf_nr_rrc_density = -1;                /* T_density */
static int hf_nr_rrc_csi_rs_ResourceList_Mobility = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_RS_ResourcesRRM_OF_CSI_RS_Resource_Mobility */
static int hf_nr_rrc_csi_rs_ResourceList_Mobility_item = -1;  /* CSI_RS_Resource_Mobility */
static int hf_nr_rrc_csi_RS_Index = -1;           /* CSI_RS_Index */
static int hf_nr_rrc_slotConfig = -1;             /* T_slotConfig */
static int hf_nr_rrc_ms4 = -1;                    /* INTEGER_0_31 */
static int hf_nr_rrc_ms5 = -1;                    /* INTEGER_0_39 */
static int hf_nr_rrc_ms10_01 = -1;                /* INTEGER_0_79 */
static int hf_nr_rrc_ms20_01 = -1;                /* INTEGER_0_159 */
static int hf_nr_rrc_ms40_01 = -1;                /* INTEGER_0_319 */
static int hf_nr_rrc_associatedSSB = -1;          /* T_associatedSSB */
static int hf_nr_rrc_ssb_Index = -1;              /* SSB_Index */
static int hf_nr_rrc_isQuasiColocated = -1;       /* BOOLEAN */
static int hf_nr_rrc_frequencyDomainAllocation = -1;  /* T_frequencyDomainAllocation */
static int hf_nr_rrc_row1 = -1;                   /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_row2 = -1;                   /* BIT_STRING_SIZE_12 */
static int hf_nr_rrc_firstOFDMSymbolInTimeDomain = -1;  /* INTEGER_0_13 */
static int hf_nr_rrc_sequenceGenerationConfig = -1;  /* INTEGER_0_1023 */
static int hf_nr_rrc_frequencyDomainAllocation_01 = -1;  /* T_frequencyDomainAllocation_01 */
static int hf_nr_rrc_row4 = -1;                   /* BIT_STRING_SIZE_3 */
static int hf_nr_rrc_other_01 = -1;               /* BIT_STRING_SIZE_6 */
static int hf_nr_rrc_nrofPorts = -1;              /* T_nrofPorts */
static int hf_nr_rrc_firstOFDMSymbolInTimeDomain2 = -1;  /* INTEGER_2_12 */
static int hf_nr_rrc_cdm_Type = -1;               /* T_cdm_Type */
static int hf_nr_rrc_density_01 = -1;             /* T_density_01 */
static int hf_nr_rrc_dot5 = -1;                   /* T_dot5 */
static int hf_nr_rrc_one = -1;                    /* NULL */
static int hf_nr_rrc_three = -1;                  /* NULL */
static int hf_nr_rrc_spare_03 = -1;               /* NULL */
static int hf_nr_rrc_CSI_SemiPersistentOnPUSCH_TriggerStateList_item = -1;  /* CSI_SemiPersistentOnPUSCH_TriggerState */
static int hf_nr_rrc_associatedReportConfigInfo = -1;  /* CSI_ReportConfigId */
static int hf_nr_rrc_csi_SSB_ResourceSetId = -1;  /* CSI_SSB_ResourceSetId */
static int hf_nr_rrc_csi_SSB_ResourceList = -1;   /* SEQUENCE_SIZE_1_maxNrofCSI_SSB_ResourcePerSet_OF_SSB_Index */
static int hf_nr_rrc_csi_SSB_ResourceList_item = -1;  /* SSB_Index */
static int hf_nr_rrc_dmrs_Type = -1;              /* T_dmrs_Type */
static int hf_nr_rrc_dmrs_AdditionalPosition = -1;  /* T_dmrs_AdditionalPosition */
static int hf_nr_rrc_maxLength = -1;              /* T_maxLength */
static int hf_nr_rrc_scramblingID0 = -1;          /* INTEGER_0_65535 */
static int hf_nr_rrc_scramblingID1 = -1;          /* INTEGER_0_65535 */
static int hf_nr_rrc_phaseTrackingRS = -1;        /* T_phaseTrackingRS */
static int hf_nr_rrc_setup_36 = -1;               /* PTRS_DownlinkConfig */
static int hf_nr_rrc_dmrs_Downlink_r16 = -1;      /* T_dmrs_Downlink_r16 */
static int hf_nr_rrc_dmrs_Type_01 = -1;           /* T_dmrs_Type_01 */
static int hf_nr_rrc_dmrs_AdditionalPosition_01 = -1;  /* T_dmrs_AdditionalPosition_01 */
static int hf_nr_rrc_phaseTrackingRS_01 = -1;     /* T_phaseTrackingRS_01 */
static int hf_nr_rrc_setup_37 = -1;               /* PTRS_UplinkConfig */
static int hf_nr_rrc_maxLength_01 = -1;           /* T_maxLength_01 */
static int hf_nr_rrc_transformPrecodingDisabled = -1;  /* T_transformPrecodingDisabled */
static int hf_nr_rrc_dmrs_Uplink_r16 = -1;        /* T_dmrs_Uplink_r16 */
static int hf_nr_rrc_transformPrecodingEnabled = -1;  /* T_transformPrecodingEnabled */
static int hf_nr_rrc_nPUSCH_Identity = -1;        /* INTEGER_0_1007 */
static int hf_nr_rrc_sequenceGroupHopping = -1;   /* T_sequenceGroupHopping */
static int hf_nr_rrc_sequenceHopping = -1;        /* T_sequenceHopping */
static int hf_nr_rrc_dmrs_UplinkTransformPrecoding_r16 = -1;  /* T_dmrs_UplinkTransformPrecoding_r16 */
static int hf_nr_rrc_setup_38 = -1;               /* DMRS_UplinkTransformPrecoding_r16 */
static int hf_nr_rrc_pi2BPSK_ScramblingID0 = -1;  /* INTEGER_0_65535 */
static int hf_nr_rrc_pi2BPSK_ScramblingID1 = -1;  /* INTEGER_0_65535 */
static int hf_nr_rrc_frequencyInfoDL = -1;        /* FrequencyInfoDL */
static int hf_nr_rrc_initialDownlinkBWP = -1;     /* BWP_DownlinkCommon */
static int hf_nr_rrc_frequencyInfoDL_01 = -1;     /* FrequencyInfoDL_SIB */
static int hf_nr_rrc_bcch_Config = -1;            /* BCCH_Config */
static int hf_nr_rrc_pcch_Config = -1;            /* PCCH_Config */
static int hf_nr_rrc_modificationPeriodCoeff = -1;  /* T_modificationPeriodCoeff */
static int hf_nr_rrc_defaultPagingCycle = -1;     /* PagingCycle */
static int hf_nr_rrc_nAndPagingFrameOffset = -1;  /* T_nAndPagingFrameOffset */
static int hf_nr_rrc_oneT = -1;                   /* NULL */
static int hf_nr_rrc_halfT = -1;                  /* INTEGER_0_1 */
static int hf_nr_rrc_quarterT = -1;               /* INTEGER_0_3 */
static int hf_nr_rrc_oneEighthT = -1;             /* INTEGER_0_7 */
static int hf_nr_rrc_oneSixteenthT = -1;          /* INTEGER_0_15 */
static int hf_nr_rrc_ns = -1;                     /* T_ns */
static int hf_nr_rrc_firstPDCCH_MonitoringOccasionOfPO = -1;  /* T_firstPDCCH_MonitoringOccasionOfPO */
static int hf_nr_rrc_sCS15KHZoneT = -1;           /* T_sCS15KHZoneT */
static int hf_nr_rrc_sCS15KHZoneT_item = -1;      /* INTEGER_0_139 */
static int hf_nr_rrc_sCS30KHZoneT_SCS15KHZhalfT = -1;  /* T_sCS30KHZoneT_SCS15KHZhalfT */
static int hf_nr_rrc_sCS30KHZoneT_SCS15KHZhalfT_item = -1;  /* INTEGER_0_279 */
static int hf_nr_rrc_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT = -1;  /* T_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT */
static int hf_nr_rrc_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT_item = -1;  /* INTEGER_0_559 */
static int hf_nr_rrc_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT = -1;  /* T_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT */
static int hf_nr_rrc_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT_item = -1;  /* INTEGER_0_1119 */
static int hf_nr_rrc_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT = -1;  /* T_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT */
static int hf_nr_rrc_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT_item = -1;  /* INTEGER_0_2239 */
static int hf_nr_rrc_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT = -1;  /* T_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT */
static int hf_nr_rrc_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT_item = -1;  /* INTEGER_0_4479 */
static int hf_nr_rrc_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT = -1;  /* T_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT */
static int hf_nr_rrc_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT_item = -1;  /* INTEGER_0_8959 */
static int hf_nr_rrc_sCS120KHZoneSixteenthT = -1;  /* T_sCS120KHZoneSixteenthT */
static int hf_nr_rrc_sCS120KHZoneSixteenthT_item = -1;  /* INTEGER_0_17919 */
static int hf_nr_rrc_nrofPDCCH_MonitoringOccasionPerSSB_InPO_r16 = -1;  /* INTEGER_2_4 */
static int hf_nr_rrc_int_RNTI = -1;               /* RNTI_Value */
static int hf_nr_rrc_timeFrequencySet = -1;       /* T_timeFrequencySet */
static int hf_nr_rrc_dci_PayloadSize = -1;        /* INTEGER_0_maxINT_DCI_PayloadSize */
static int hf_nr_rrc_int_ConfigurationPerServingCell = -1;  /* SEQUENCE_SIZE_1_maxNrofServingCells_OF_INT_ConfigurationPerServingCell */
static int hf_nr_rrc_int_ConfigurationPerServingCell_item = -1;  /* INT_ConfigurationPerServingCell */
static int hf_nr_rrc_positionInDCI = -1;          /* INTEGER_0_maxINT_DCI_PayloadSize_1 */
static int hf_nr_rrc_drx_onDurationTimer_01 = -1;  /* T_drx_onDurationTimer_01 */
static int hf_nr_rrc_milliSeconds_01 = -1;        /* T_milliSeconds_01 */
static int hf_nr_rrc_drx_InactivityTimer = -1;    /* T_drx_InactivityTimer */
static int hf_nr_rrc_drx_HARQ_RTT_TimerDL = -1;   /* INTEGER_0_56 */
static int hf_nr_rrc_drx_HARQ_RTT_TimerUL = -1;   /* INTEGER_0_56 */
static int hf_nr_rrc_drx_RetransmissionTimerDL = -1;  /* T_drx_RetransmissionTimerDL */
static int hf_nr_rrc_drx_RetransmissionTimerUL = -1;  /* T_drx_RetransmissionTimerUL */
static int hf_nr_rrc_drx_LongCycleStartOffset_01 = -1;  /* T_drx_LongCycleStartOffset_01 */
static int hf_nr_rrc_shortDRX_01 = -1;            /* T_shortDRX_01 */
static int hf_nr_rrc_drx_ShortCycle_01 = -1;      /* T_drx_ShortCycle_01 */
static int hf_nr_rrc_drx_SlotOffset = -1;         /* INTEGER_0_31 */
static int hf_nr_rrc_drx_onDurationTimer_02 = -1;  /* T_drx_onDurationTimer_02 */
static int hf_nr_rrc_milliSeconds_02 = -1;        /* T_milliSeconds_02 */
static int hf_nr_rrc_drx_InactivityTimer_01 = -1;  /* T_drx_InactivityTimer_01 */
static int hf_nr_rrc_absoluteFrequencySSB = -1;   /* ARFCN_ValueNR */
static int hf_nr_rrc_absoluteFrequencyPointA = -1;  /* ARFCN_ValueNR */
static int hf_nr_rrc_scs_SpecificCarrierList = -1;  /* SEQUENCE_SIZE_1_maxSCSs_OF_SCS_SpecificCarrier */
static int hf_nr_rrc_scs_SpecificCarrierList_item = -1;  /* SCS_SpecificCarrier */
static int hf_nr_rrc_offsetToPointA = -1;         /* INTEGER_0_2199 */
static int hf_nr_rrc_additionalSpectrumEmission = -1;  /* AdditionalSpectrumEmission */
static int hf_nr_rrc_frequencyShift7p5khz = -1;   /* T_frequencyShift7p5khz */
static int hf_nr_rrc_frequencyShift7p5khz_01 = -1;  /* T_frequencyShift7p5khz_01 */
static int hf_nr_rrc_highSpeedMeasFlag_r16 = -1;  /* T_highSpeedMeasFlag_r16 */
static int hf_nr_rrc_highSpeedDemodFlag_r16 = -1;  /* T_highSpeedDemodFlag_r16 */
static int hf_nr_rrc_symbols_r16 = -1;            /* T_symbols_r16 */
static int hf_nr_rrc_oneSlot = -1;                /* BIT_STRING_SIZE_14 */
static int hf_nr_rrc_twoSlots = -1;               /* BIT_STRING_SIZE_28 */
static int hf_nr_rrc_periodicityAndPattern_r16 = -1;  /* T_periodicityAndPattern_r16 */
static int hf_nr_rrc_n2 = -1;                     /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_n4 = -1;                     /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_n5 = -1;                     /* BIT_STRING_SIZE_5 */
static int hf_nr_rrc_n8 = -1;                     /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_n10 = -1;                    /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_n20 = -1;                    /* BIT_STRING_SIZE_20 */
static int hf_nr_rrc_n40 = -1;                    /* BIT_STRING_SIZE_40 */
static int hf_nr_rrc_lbt_FailureInstanceMaxCount_r16 = -1;  /* T_lbt_FailureInstanceMaxCount_r16 */
static int hf_nr_rrc_lbt_FailureDetectionTimer_r16 = -1;  /* T_lbt_FailureDetectionTimer_r16 */
static int hf_nr_rrc_commonLocationInfo_r16 = -1;  /* CommonLocationInfo_r16 */
static int hf_nr_rrc_bt_LocationInfo_r16 = -1;    /* LogMeasResultListBT_r16 */
static int hf_nr_rrc_wlan_LocationInfo_r16 = -1;  /* LogMeasResultListWLAN_r16 */
static int hf_nr_rrc_sensor_LocationInfo_r16 = -1;  /* Sensor_LocationInfo_r16 */
static int hf_nr_rrc_eutra_RSTD = -1;             /* EUTRA_RSTD_InfoList */
static int hf_nr_rrc_eutra_FineTimingDetection = -1;  /* NULL */
static int hf_nr_rrc_nr_PRS_Measurement_r16 = -1;  /* NR_PRS_MeasurementInfoList_r16 */
static int hf_nr_rrc_EUTRA_RSTD_InfoList_item = -1;  /* EUTRA_RSTD_Info */
static int hf_nr_rrc_measPRS_Offset = -1;         /* INTEGER_0_39 */
static int hf_nr_rrc_NR_PRS_MeasurementInfoList_r16_item = -1;  /* NR_PRS_MeasurementInfo_r16 */
static int hf_nr_rrc_dl_PRS_PointA_r16 = -1;      /* ARFCN_ValueNR */
static int hf_nr_rrc_nr_MeasPRS_RepetitionAndOffset_r16 = -1;  /* T_nr_MeasPRS_RepetitionAndOffset_r16 */
static int hf_nr_rrc_ms20_r16 = -1;               /* INTEGER_0_19 */
static int hf_nr_rrc_ms40_r16 = -1;               /* INTEGER_0_39 */
static int hf_nr_rrc_ms80_r16 = -1;               /* INTEGER_0_79 */
static int hf_nr_rrc_ms160_r16 = -1;              /* INTEGER_0_159 */
static int hf_nr_rrc_nr_MeasPRS_length_r16 = -1;  /* T_nr_MeasPRS_length_r16 */
static int hf_nr_rrc_ul_SpecificParameters = -1;  /* T_ul_SpecificParameters */
static int hf_nr_rrc_priority = -1;               /* INTEGER_1_16 */
static int hf_nr_rrc_prioritisedBitRate = -1;     /* T_prioritisedBitRate */
static int hf_nr_rrc_bucketSizeDuration = -1;     /* T_bucketSizeDuration */
static int hf_nr_rrc_allowedServingCells = -1;    /* SEQUENCE_SIZE_1_maxNrofServingCells_1_OF_ServCellIndex */
static int hf_nr_rrc_allowedServingCells_item = -1;  /* ServCellIndex */
static int hf_nr_rrc_allowedSCS_List = -1;        /* SEQUENCE_SIZE_1_maxSCSs_OF_SubcarrierSpacing */
static int hf_nr_rrc_allowedSCS_List_item = -1;   /* SubcarrierSpacing */
static int hf_nr_rrc_maxPUSCH_Duration = -1;      /* T_maxPUSCH_Duration */
static int hf_nr_rrc_configuredGrantType1Allowed = -1;  /* T_configuredGrantType1Allowed */
static int hf_nr_rrc_logicalChannelGroup = -1;    /* INTEGER_0_maxLCG_ID */
static int hf_nr_rrc_schedulingRequestID = -1;    /* SchedulingRequestId */
static int hf_nr_rrc_logicalChannelSR_Mask = -1;  /* BOOLEAN */
static int hf_nr_rrc_logicalChannelSR_DelayTimerApplied = -1;  /* BOOLEAN */
static int hf_nr_rrc_bitRateQueryProhibitTimer = -1;  /* T_bitRateQueryProhibitTimer */
static int hf_nr_rrc_allowedCG_List_r16 = -1;     /* SEQUENCE_SIZE_0_maxNrofConfiguredGrantConfigMAC_1_r16_OF_ConfiguredGrantConfigIndexMAC_r16 */
static int hf_nr_rrc_allowedCG_List_r16_item = -1;  /* ConfiguredGrantConfigIndexMAC_r16 */
static int hf_nr_rrc_allowedPHY_PriorityIndex_r16 = -1;  /* T_allowedPHY_PriorityIndex_r16 */
static int hf_nr_rrc_bitRateMultiplier_r16 = -1;  /* T_bitRateMultiplier_r16 */
static int hf_nr_rrc_drx_Config = -1;             /* T_drx_Config */
static int hf_nr_rrc_setup_39 = -1;               /* DRX_Config */
static int hf_nr_rrc_schedulingRequestConfig = -1;  /* SchedulingRequestConfig */
static int hf_nr_rrc_bsr_Config = -1;             /* BSR_Config */
static int hf_nr_rrc_tag_Config = -1;             /* TAG_Config */
static int hf_nr_rrc_phr_Config = -1;             /* T_phr_Config */
static int hf_nr_rrc_setup_40 = -1;               /* PHR_Config */
static int hf_nr_rrc_mAC_CellGroupConfig_skipUplinkTxDynamic = -1;  /* BOOLEAN */
static int hf_nr_rrc_csi_Mask = -1;               /* BOOLEAN */
static int hf_nr_rrc_dataInactivityTimer = -1;    /* T_dataInactivityTimer */
static int hf_nr_rrc_setup_41 = -1;               /* DataInactivityTimer */
static int hf_nr_rrc_usePreBSR_r16 = -1;          /* T_usePreBSR_r16 */
static int hf_nr_rrc_schedulingRequestID_LBT_SCell_r16 = -1;  /* SchedulingRequestId */
static int hf_nr_rrc_lch_BasedPrioritization_r16 = -1;  /* T_lch_BasedPrioritization_r16 */
static int hf_nr_rrc_schedulingRequestID_BFR_SCell_r16 = -1;  /* SchedulingRequestId */
static int hf_nr_rrc_drx_ConfigSecondaryGroup_r16 = -1;  /* T_drx_ConfigSecondaryGroup_r16 */
static int hf_nr_rrc_setup_42 = -1;               /* DRX_ConfigSecondaryGroup */
static int hf_nr_rrc_enhancedSkipUplinkTxDynamic_r16 = -1;  /* T_enhancedSkipUplinkTxDynamic_r16 */
static int hf_nr_rrc_enhancedSkipUplinkTxConfigured_r16 = -1;  /* T_enhancedSkipUplinkTxConfigured_r16 */
static int hf_nr_rrc_measObjectToRemoveList = -1;  /* MeasObjectToRemoveList */
static int hf_nr_rrc_measObjectToAddModList = -1;  /* MeasObjectToAddModList */
static int hf_nr_rrc_reportConfigToRemoveList = -1;  /* ReportConfigToRemoveList */
static int hf_nr_rrc_reportConfigToAddModList = -1;  /* ReportConfigToAddModList */
static int hf_nr_rrc_measIdToRemoveList = -1;     /* MeasIdToRemoveList */
static int hf_nr_rrc_measIdToAddModList = -1;     /* MeasIdToAddModList */
static int hf_nr_rrc_s_MeasureConfig = -1;        /* T_s_MeasureConfig */
static int hf_nr_rrc_ssb_RSRP = -1;               /* RSRP_Range */
static int hf_nr_rrc_csi_RSRP = -1;               /* RSRP_Range */
static int hf_nr_rrc_quantityConfig = -1;         /* QuantityConfig */
static int hf_nr_rrc_measGapConfig_01 = -1;       /* MeasGapConfig */
static int hf_nr_rrc_measGapSharingConfig = -1;   /* MeasGapSharingConfig */
static int hf_nr_rrc_interFrequencyConfig_NoGap_r16 = -1;  /* T_interFrequencyConfig_NoGap_r16 */
static int hf_nr_rrc_MeasObjectToRemoveList_item = -1;  /* MeasObjectId */
static int hf_nr_rrc_MeasIdToRemoveList_item = -1;  /* MeasId */
static int hf_nr_rrc_ReportConfigToRemoveList_item = -1;  /* ReportConfigId */
static int hf_nr_rrc_gapFR2 = -1;                 /* T_gapFR2 */
static int hf_nr_rrc_gapFR1 = -1;                 /* T_gapFR1 */
static int hf_nr_rrc_gapUE = -1;                  /* T_gapUE */
static int hf_nr_rrc_gapOffset = -1;              /* INTEGER_0_159 */
static int hf_nr_rrc_mgl = -1;                    /* T_mgl */
static int hf_nr_rrc_mgrp = -1;                   /* T_mgrp */
static int hf_nr_rrc_mgta = -1;                   /* T_mgta */
static int hf_nr_rrc_refServCellIndicator = -1;   /* T_refServCellIndicator */
static int hf_nr_rrc_refFR2ServCellAsyncCA_r16 = -1;  /* ServCellIndex */
static int hf_nr_rrc_mgl_r16 = -1;                /* T_mgl_r16 */
static int hf_nr_rrc_gapSharingFR2 = -1;          /* T_gapSharingFR2 */
static int hf_nr_rrc_setup_43 = -1;               /* MeasGapSharingScheme */
static int hf_nr_rrc_gapSharingFR1 = -1;          /* T_gapSharingFR1 */
static int hf_nr_rrc_gapSharingUE = -1;           /* T_gapSharingUE */
static int hf_nr_rrc_measIdleCarrierListNR_r16 = -1;  /* SEQUENCE_SIZE_1_maxFreqIdle_r16_OF_MeasIdleCarrierNR_r16 */
static int hf_nr_rrc_measIdleCarrierListNR_r16_item = -1;  /* MeasIdleCarrierNR_r16 */
static int hf_nr_rrc_measIdleCarrierListEUTRA_r16 = -1;  /* SEQUENCE_SIZE_1_maxFreqIdle_r16_OF_MeasIdleCarrierEUTRA_r16 */
static int hf_nr_rrc_measIdleCarrierListEUTRA_r16_item = -1;  /* MeasIdleCarrierEUTRA_r16 */
static int hf_nr_rrc_measIdleDuration_r16 = -1;   /* T_measIdleDuration_r16 */
static int hf_nr_rrc_validityAreaList_r16 = -1;   /* ValidityAreaList_r16 */
static int hf_nr_rrc_ValidityAreaList_r16_item = -1;  /* ValidityArea_r16 */
static int hf_nr_rrc_validityCellList_r16 = -1;   /* ValidityCellList */
static int hf_nr_rrc_ValidityCellList_item = -1;  /* PCI_Range */
static int hf_nr_rrc_ssbSubcarrierSpacing_r16 = -1;  /* SubcarrierSpacing */
static int hf_nr_rrc_measCellListNR_r16 = -1;     /* CellListNR_r16 */
static int hf_nr_rrc_reportQuantities_r16 = -1;   /* T_reportQuantities_r16 */
static int hf_nr_rrc_qualityThreshold_r16 = -1;   /* T_qualityThreshold_r16 */
static int hf_nr_rrc_idleRSRP_Threshold_NR_r16 = -1;  /* RSRP_Range */
static int hf_nr_rrc_idleRSRQ_Threshold_NR_r16 = -1;  /* RSRQ_Range */
static int hf_nr_rrc_ssb_MeasConfig_r16 = -1;     /* T_ssb_MeasConfig_r16 */
static int hf_nr_rrc_nrofSS_BlocksToAverage_r16 = -1;  /* INTEGER_2_maxNrofSS_BlocksToAverage */
static int hf_nr_rrc_absThreshSS_BlocksConsolidation_r16 = -1;  /* ThresholdNR */
static int hf_nr_rrc_smtc_r16 = -1;               /* SSB_MTC */
static int hf_nr_rrc_ssb_ToMeasure_r16 = -1;      /* SSB_ToMeasure */
static int hf_nr_rrc_deriveSSB_IndexFromCell_r16 = -1;  /* BOOLEAN */
static int hf_nr_rrc_ss_RSSI_Measurement_r16 = -1;  /* SS_RSSI_Measurement */
static int hf_nr_rrc_beamMeasConfigIdle_r16 = -1;  /* BeamMeasConfigIdle_NR_r16 */
static int hf_nr_rrc_carrierFreqEUTRA_r16 = -1;   /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_allowedMeasBandwidth_r16 = -1;  /* EUTRA_AllowedMeasBandwidth */
static int hf_nr_rrc_measCellListEUTRA_r16 = -1;  /* CellListEUTRA_r16 */
static int hf_nr_rrc_reportQuantitiesEUTRA_r16 = -1;  /* T_reportQuantitiesEUTRA_r16 */
static int hf_nr_rrc_qualityThresholdEUTRA_r16 = -1;  /* T_qualityThresholdEUTRA_r16 */
static int hf_nr_rrc_idleRSRP_Threshold_EUTRA_r16 = -1;  /* RSRP_RangeEUTRA */
static int hf_nr_rrc_idleRSRQ_Threshold_EUTRA_r16 = -1;  /* RSRQ_RangeEUTRA_r16 */
static int hf_nr_rrc_CellListNR_r16_item = -1;    /* PCI_Range */
static int hf_nr_rrc_CellListEUTRA_r16_item = -1;  /* EUTRA_PhysCellIdRange */
static int hf_nr_rrc_reportQuantityRS_Indexes_r16 = -1;  /* T_reportQuantityRS_Indexes_r16 */
static int hf_nr_rrc_maxNrofRS_IndexesToReport_r16 = -1;  /* INTEGER_1_maxNrofIndexesToReport */
static int hf_nr_rrc_includeBeamMeasurements_r16 = -1;  /* BOOLEAN */
static int hf_nr_rrc_MeasIdToAddModList_item = -1;  /* MeasIdToAddMod */
static int hf_nr_rrc_measId = -1;                 /* MeasId */
static int hf_nr_rrc_measObjectId = -1;           /* MeasObjectId */
static int hf_nr_rrc_reportConfigId_01 = -1;      /* ReportConfigId */
static int hf_nr_rrc_cli_ResourceConfig_r16 = -1;  /* CLI_ResourceConfig_r16 */
static int hf_nr_rrc_srs_ResourceConfig_r16 = -1;  /* T_srs_ResourceConfig_r16 */
static int hf_nr_rrc_setup_44 = -1;               /* SRS_ResourceListConfigCLI_r16 */
static int hf_nr_rrc_rssi_ResourceConfig_r16 = -1;  /* T_rssi_ResourceConfig_r16 */
static int hf_nr_rrc_setup_45 = -1;               /* RSSI_ResourceListConfigCLI_r16 */
static int hf_nr_rrc_SRS_ResourceListConfigCLI_r16_item = -1;  /* SRS_ResourceConfigCLI_r16 */
static int hf_nr_rrc_RSSI_ResourceListConfigCLI_r16_item = -1;  /* RSSI_ResourceConfigCLI_r16 */
static int hf_nr_rrc_srs_Resource_r16 = -1;       /* SRS_Resource */
static int hf_nr_rrc_srs_SCS_r16 = -1;            /* SubcarrierSpacing */
static int hf_nr_rrc_refServCellIndex_r16 = -1;   /* ServCellIndex */
static int hf_nr_rrc_refBWP_r16 = -1;             /* BWP_Id */
static int hf_nr_rrc_rssi_ResourceId_r16 = -1;    /* RSSI_ResourceId_r16 */
static int hf_nr_rrc_rssi_SCS_r16 = -1;           /* SubcarrierSpacing */
static int hf_nr_rrc_startPRB_r16 = -1;           /* INTEGER_0_2169 */
static int hf_nr_rrc_nrofPRBs_r16 = -1;           /* INTEGER_4_maxNrofPhysicalResourceBlocksPlus1 */
static int hf_nr_rrc_startPosition_r16 = -1;      /* INTEGER_0_13 */
static int hf_nr_rrc_nrofSymbols_r16 = -1;        /* INTEGER_1_14 */
static int hf_nr_rrc_rssi_PeriodicityAndOffset_r16 = -1;  /* RSSI_PeriodicityAndOffset_r16 */
static int hf_nr_rrc_sl10 = -1;                   /* INTEGER_0_9 */
static int hf_nr_rrc_sl20 = -1;                   /* INTEGER_0_19 */
static int hf_nr_rrc_sl40 = -1;                   /* INTEGER_0_39 */
static int hf_nr_rrc_sl80 = -1;                   /* INTEGER_0_79 */
static int hf_nr_rrc_sl160 = -1;                  /* INTEGER_0_159 */
static int hf_nr_rrc_sl320 = -1;                  /* INTEGER_0_319 */
static int hf_nr_rrc_s1640 = -1;                  /* INTEGER_0_639 */
static int hf_nr_rrc_cellsToRemoveListEUTRAN = -1;  /* EUTRA_CellIndexList */
static int hf_nr_rrc_cellsToAddModListEUTRAN = -1;  /* SEQUENCE_SIZE_1_maxCellMeasEUTRA_OF_EUTRA_Cell */
static int hf_nr_rrc_cellsToAddModListEUTRAN_item = -1;  /* EUTRA_Cell */
static int hf_nr_rrc_blackCellsToRemoveListEUTRAN = -1;  /* EUTRA_CellIndexList */
static int hf_nr_rrc_blackCellsToAddModListEUTRAN = -1;  /* SEQUENCE_SIZE_1_maxCellMeasEUTRA_OF_EUTRA_BlackCell */
static int hf_nr_rrc_blackCellsToAddModListEUTRAN_item = -1;  /* EUTRA_BlackCell */
static int hf_nr_rrc_eutra_PresenceAntennaPort1 = -1;  /* EUTRA_PresenceAntennaPort1 */
static int hf_nr_rrc_eutra_Q_OffsetRange = -1;    /* EUTRA_Q_OffsetRange */
static int hf_nr_rrc_widebandRSRQ_Meas = -1;      /* BOOLEAN */
static int hf_nr_rrc_EUTRA_CellIndexList_item = -1;  /* EUTRA_CellIndex */
static int hf_nr_rrc_cellIndexEUTRA = -1;         /* EUTRA_CellIndex */
static int hf_nr_rrc_cellIndividualOffset = -1;   /* EUTRA_Q_OffsetRange */
static int hf_nr_rrc_physCellIdRange = -1;        /* EUTRA_PhysCellIdRange */
static int hf_nr_rrc_smtc1 = -1;                  /* SSB_MTC */
static int hf_nr_rrc_smtc2 = -1;                  /* SSB_MTC2 */
static int hf_nr_rrc_refFreqCSI_RS = -1;          /* ARFCN_ValueNR */
static int hf_nr_rrc_referenceSignalConfig = -1;  /* ReferenceSignalConfig */
static int hf_nr_rrc_absThreshCSI_RS_Consolidation = -1;  /* ThresholdNR */
static int hf_nr_rrc_nrofCSI_RS_ResourcesToAverage = -1;  /* INTEGER_2_maxNrofCSI_RS_ResourcesToAverage */
static int hf_nr_rrc_quantityConfigIndex = -1;    /* INTEGER_1_maxNrofQuantityConfig */
static int hf_nr_rrc_offsetMO = -1;               /* Q_OffsetRangeList */
static int hf_nr_rrc_cellsToRemoveList = -1;      /* PCI_List */
static int hf_nr_rrc_cellsToAddModList = -1;      /* CellsToAddModList */
static int hf_nr_rrc_blackCellsToRemoveList = -1;  /* PCI_RangeIndexList */
static int hf_nr_rrc_blackCellsToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofPCI_Ranges_OF_PCI_RangeElement */
static int hf_nr_rrc_blackCellsToAddModList_item = -1;  /* PCI_RangeElement */
static int hf_nr_rrc_whiteCellsToRemoveList = -1;  /* PCI_RangeIndexList */
static int hf_nr_rrc_whiteCellsToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofPCI_Ranges_OF_PCI_RangeElement */
static int hf_nr_rrc_whiteCellsToAddModList_item = -1;  /* PCI_RangeElement */
static int hf_nr_rrc_freqBandIndicatorNR = -1;    /* FreqBandIndicatorNR */
static int hf_nr_rrc_measCycleSCell = -1;         /* T_measCycleSCell */
static int hf_nr_rrc_smtc3list_r16 = -1;          /* SSB_MTC3List_r16 */
static int hf_nr_rrc_rmtc_Config_r16 = -1;        /* T_rmtc_Config_r16 */
static int hf_nr_rrc_setup_46 = -1;               /* RMTC_Config_r16 */
static int hf_nr_rrc_t312_r16 = -1;               /* T_t312_r16 */
static int hf_nr_rrc_setup_47 = -1;               /* T312_r16 */
static int hf_nr_rrc_SSB_MTC3List_r16_item = -1;  /* SSB_MTC3_r16 */
static int hf_nr_rrc_ssb_ConfigMobility = -1;     /* SSB_ConfigMobility */
static int hf_nr_rrc_csi_rs_ResourceConfigMobility = -1;  /* T_csi_rs_ResourceConfigMobility */
static int hf_nr_rrc_setup_48 = -1;               /* CSI_RS_ResourceConfigMobility */
static int hf_nr_rrc_ssb_ToMeasure_01 = -1;       /* T_ssb_ToMeasure */
static int hf_nr_rrc_setup_49 = -1;               /* SSB_ToMeasure */
static int hf_nr_rrc_ssb_PositionQCL_CellsToAddModList_r16 = -1;  /* SSB_PositionQCL_CellsToAddModList_r16 */
static int hf_nr_rrc_ssb_PositionQCL_CellsToRemoveList_r16 = -1;  /* PCI_List */
static int hf_nr_rrc_rsrpOffsetSSB = -1;          /* Q_OffsetRange */
static int hf_nr_rrc_rsrqOffsetSSB = -1;          /* Q_OffsetRange */
static int hf_nr_rrc_sinrOffsetSSB = -1;          /* Q_OffsetRange */
static int hf_nr_rrc_rsrpOffsetCSI_RS = -1;       /* Q_OffsetRange */
static int hf_nr_rrc_rsrqOffsetCSI_RS = -1;       /* Q_OffsetRange */
static int hf_nr_rrc_sinrOffsetCSI_RS = -1;       /* Q_OffsetRange */
static int hf_nr_rrc_thresholdRSRP = -1;          /* RSRP_Range */
static int hf_nr_rrc_thresholdRSRQ = -1;          /* RSRQ_Range */
static int hf_nr_rrc_thresholdSINR = -1;          /* SINR_Range */
static int hf_nr_rrc_CellsToAddModList_item = -1;  /* CellsToAddMod */
static int hf_nr_rrc_cellIndividualOffset_01 = -1;  /* Q_OffsetRangeList */
static int hf_nr_rrc_rmtc_Periodicity_r16 = -1;   /* T_rmtc_Periodicity_r16 */
static int hf_nr_rrc_rmtc_SubframeOffset_r16 = -1;  /* INTEGER_0_639 */
static int hf_nr_rrc_measDurationSymbols_r16 = -1;  /* T_measDurationSymbols_r16 */
static int hf_nr_rrc_rmtc_Frequency_r16 = -1;     /* ARFCN_ValueNR */
static int hf_nr_rrc_ref_SCS_CP_r16 = -1;         /* T_ref_SCS_CP_r16 */
static int hf_nr_rrc_SSB_PositionQCL_CellsToAddModList_r16_item = -1;  /* SSB_PositionQCL_CellsToAddMod_r16 */
static int hf_nr_rrc_tx_PoolMeasToRemoveList_r16 = -1;  /* Tx_PoolMeasList_r16 */
static int hf_nr_rrc_tx_PoolMeasToAddModList_r16 = -1;  /* Tx_PoolMeasList_r16 */
static int hf_nr_rrc_Tx_PoolMeasList_r16_item = -1;  /* SL_ResourcePoolID_r16 */
static int hf_nr_rrc_MeasObjectToAddModList_item = -1;  /* MeasObjectToAddMod */
static int hf_nr_rrc_measObject = -1;             /* T_measObject */
static int hf_nr_rrc_measObjectNR = -1;           /* MeasObjectNR */
static int hf_nr_rrc_measObjectEUTRA = -1;        /* MeasObjectEUTRA */
static int hf_nr_rrc_measObjectUTRA_FDD_r16 = -1;  /* MeasObjectUTRA_FDD_r16 */
static int hf_nr_rrc_measObjectNR_SL_r16 = -1;    /* MeasObjectNR_SL_r16 */
static int hf_nr_rrc_measObjectCLI_r16 = -1;      /* MeasObjectCLI_r16 */
static int hf_nr_rrc_utra_FDD_Q_OffsetRange_r16 = -1;  /* UTRA_FDD_Q_OffsetRange_r16 */
static int hf_nr_rrc_cellsToRemoveList_r16 = -1;  /* UTRA_FDD_CellIndexList_r16 */
static int hf_nr_rrc_cellsToAddModList_r16 = -1;  /* CellsToAddModListUTRA_FDD_r16 */
static int hf_nr_rrc_CellsToAddModListUTRA_FDD_r16_item = -1;  /* CellsToAddModUTRA_FDD_r16 */
static int hf_nr_rrc_cellIndexUTRA_FDD_r16 = -1;  /* UTRA_FDD_CellIndex_r16 */
static int hf_nr_rrc_physCellId_r16_02 = -1;      /* PhysCellIdUTRA_FDD_r16 */
static int hf_nr_rrc_UTRA_FDD_CellIndexList_r16_item = -1;  /* UTRA_FDD_CellIndex_r16 */
static int hf_nr_rrc_MeasResultCellListSFTD_NR_item = -1;  /* MeasResultCellSFTD_NR */
static int hf_nr_rrc_sfn_OffsetResult = -1;       /* INTEGER_0_1023 */
static int hf_nr_rrc_frameBoundaryOffsetResult = -1;  /* INTEGER_M30720_30719 */
static int hf_nr_rrc_rsrp_Result = -1;            /* RSRP_Range */
static int hf_nr_rrc_MeasResultCellListSFTD_EUTRA_item = -1;  /* MeasResultSFTD_EUTRA */
static int hf_nr_rrc_eutra_PhysCellId = -1;       /* EUTRA_PhysCellId */
static int hf_nr_rrc_measResultServingMOList = -1;  /* MeasResultServMOList */
static int hf_nr_rrc_measResultNeighCells = -1;   /* T_measResultNeighCells */
static int hf_nr_rrc_measResultListNR = -1;       /* MeasResultListNR */
static int hf_nr_rrc_measResultListEUTRA = -1;    /* MeasResultListEUTRA */
static int hf_nr_rrc_measResultListUTRA_FDD_r16 = -1;  /* MeasResultListUTRA_FDD_r16 */
static int hf_nr_rrc_measResultServFreqListEUTRA_SCG = -1;  /* MeasResultServFreqListEUTRA_SCG */
static int hf_nr_rrc_measResultServFreqListNR_SCG = -1;  /* MeasResultServFreqListNR_SCG */
static int hf_nr_rrc_measResultSFTD_EUTRA = -1;   /* MeasResultSFTD_EUTRA */
static int hf_nr_rrc_measResultSFTD_NR = -1;      /* MeasResultCellSFTD_NR */
static int hf_nr_rrc_measResultForRSSI_r16 = -1;  /* MeasResultForRSSI_r16 */
static int hf_nr_rrc_ul_PDCP_DelayValueResultList_r16 = -1;  /* UL_PDCP_DelayValueResultList_r16 */
static int hf_nr_rrc_measResultsSL_r16 = -1;      /* MeasResultsSL_r16 */
static int hf_nr_rrc_measResultCLI_r16 = -1;      /* MeasResultCLI_r16 */
static int hf_nr_rrc_MeasResultServMOList_item = -1;  /* MeasResultServMO */
static int hf_nr_rrc_servCellId = -1;             /* ServCellIndex */
static int hf_nr_rrc_measResultServingCell = -1;  /* MeasResultNR */
static int hf_nr_rrc_measResultBestNeighCell = -1;  /* MeasResultNR */
static int hf_nr_rrc_MeasResultListNR_item = -1;  /* MeasResultNR */
static int hf_nr_rrc_measResult = -1;             /* T_measResult */
static int hf_nr_rrc_cellResults = -1;            /* T_cellResults */
static int hf_nr_rrc_resultsCSI_RS_Cell = -1;     /* MeasQuantityResults */
static int hf_nr_rrc_rsIndexResults = -1;         /* T_rsIndexResults */
static int hf_nr_rrc_resultsSSB_Indexes = -1;     /* ResultsPerSSB_IndexList */
static int hf_nr_rrc_resultsCSI_RS_Indexes = -1;  /* ResultsPerCSI_RS_IndexList */
static int hf_nr_rrc_MeasResultListEUTRA_item = -1;  /* MeasResultEUTRA */
static int hf_nr_rrc_eutra_PhysCellId_01 = -1;    /* PhysCellId */
static int hf_nr_rrc_measResult_01 = -1;          /* MeasQuantityResultsEUTRA */
static int hf_nr_rrc_cgi_Info_02 = -1;            /* CGI_InfoEUTRA */
static int hf_nr_rrc_MultiBandInfoListEUTRA_item = -1;  /* FreqBandIndicatorEUTRA */
static int hf_nr_rrc_measQuantityResults_rsrp = -1;  /* RSRP_Range */
static int hf_nr_rrc_measQuantityResults_rsrq = -1;  /* RSRQ_Range */
static int hf_nr_rrc_measQuantityResultssinr = -1;  /* SINR_Range */
static int hf_nr_rrc_measQuantityResultsEUTRA_rsrp = -1;  /* RSRP_RangeEUTRA */
static int hf_nr_rrc_measQuantityResultsEUTRA_rsrq = -1;  /* RSRQ_RangeEUTRA */
static int hf_nr_rrc_measQuantityResultsEUTRA_sinr = -1;  /* SINR_RangeEUTRA */
static int hf_nr_rrc_ResultsPerSSB_IndexList_item = -1;  /* ResultsPerSSB_Index */
static int hf_nr_rrc_ssb_Results = -1;            /* MeasQuantityResults */
static int hf_nr_rrc_ResultsPerCSI_RS_IndexList_item = -1;  /* ResultsPerCSI_RS_Index */
static int hf_nr_rrc_csi_RS_Results = -1;         /* MeasQuantityResults */
static int hf_nr_rrc_MeasResultServFreqListEUTRA_SCG_item = -1;  /* MeasResult2EUTRA */
static int hf_nr_rrc_MeasResultServFreqListNR_SCG_item = -1;  /* MeasResult2NR */
static int hf_nr_rrc_MeasResultListUTRA_FDD_r16_item = -1;  /* MeasResultUTRA_FDD_r16 */
static int hf_nr_rrc_measResult_r16_02 = -1;      /* T_measResult_r16_02 */
static int hf_nr_rrc_utra_FDD_RSCP_r16 = -1;      /* INTEGER_M5_91 */
static int hf_nr_rrc_utra_FDD_EcN0_r16 = -1;      /* INTEGER_0_49 */
static int hf_nr_rrc_rssi_Result_r16 = -1;        /* RSSI_Range_r16 */
static int hf_nr_rrc_channelOccupancy_r16 = -1;   /* INTEGER_0_100 */
static int hf_nr_rrc_measResultListSRS_RSRP_r16 = -1;  /* MeasResultListSRS_RSRP_r16 */
static int hf_nr_rrc_measResultListCLI_RSSI_r16 = -1;  /* MeasResultListCLI_RSSI_r16 */
static int hf_nr_rrc_MeasResultListSRS_RSRP_r16_item = -1;  /* MeasResultSRS_RSRP_r16 */
static int hf_nr_rrc_srs_ResourceId_r16 = -1;     /* SRS_ResourceId */
static int hf_nr_rrc_srs_RSRP_Result_r16 = -1;    /* SRS_RSRP_Range_r16 */
static int hf_nr_rrc_MeasResultListCLI_RSSI_r16_item = -1;  /* MeasResultCLI_RSSI_r16 */
static int hf_nr_rrc_cli_RSSI_Result_r16 = -1;    /* CLI_RSSI_Range_r16 */
static int hf_nr_rrc_UL_PDCP_DelayValueResultList_r16_item = -1;  /* UL_PDCP_DelayValueResult_r16 */
static int hf_nr_rrc_drb_Id_r16 = -1;             /* DRB_Identity */
static int hf_nr_rrc_averageDelay_r16 = -1;       /* INTEGER_0_10000 */
static int hf_nr_rrc_measResultServingCell_01 = -1;  /* MeasResultEUTRA */
static int hf_nr_rrc_measResultBestNeighCell_01 = -1;  /* MeasResultEUTRA */
static int hf_nr_rrc_measResultNeighCellListNR_02 = -1;  /* MeasResultListNR */
static int hf_nr_rrc_measResultsPerCarrierListIdleEUTRA_r16 = -1;  /* SEQUENCE_SIZE_1_maxFreqIdle_r16_OF_MeasResultsPerCarrierIdleEUTRA_r16 */
static int hf_nr_rrc_measResultsPerCarrierListIdleEUTRA_r16_item = -1;  /* MeasResultsPerCarrierIdleEUTRA_r16 */
static int hf_nr_rrc_measResultsPerCellListIdleEUTRA_r16 = -1;  /* SEQUENCE_SIZE_1_maxCellMeasIdle_r16_OF_MeasResultsPerCellIdleEUTRA_r16 */
static int hf_nr_rrc_measResultsPerCellListIdleEUTRA_r16_item = -1;  /* MeasResultsPerCellIdleEUTRA_r16 */
static int hf_nr_rrc_eutra_PhysCellId_r16 = -1;   /* EUTRA_PhysCellId */
static int hf_nr_rrc_measIdleResultEUTRA_r16 = -1;  /* T_measIdleResultEUTRA_r16 */
static int hf_nr_rrc_rsrp_ResultEUTRA_r16 = -1;   /* RSRP_RangeEUTRA */
static int hf_nr_rrc_rsrq_ResultEUTRA_r16 = -1;   /* RSRQ_RangeEUTRA_r16 */
static int hf_nr_rrc_measResultServingCell_r16_01 = -1;  /* T_measResultServingCell_r16 */
static int hf_nr_rrc_rsrp_Result_r16 = -1;        /* RSRP_Range */
static int hf_nr_rrc_rsrq_Result_r16 = -1;        /* RSRQ_Range */
static int hf_nr_rrc_resultsSSB_Indexes_r16_01 = -1;  /* ResultsPerSSB_IndexList_r16 */
static int hf_nr_rrc_measResultsPerCarrierListIdleNR_r16 = -1;  /* SEQUENCE_SIZE_1_maxFreqIdle_r16_OF_MeasResultsPerCarrierIdleNR_r16 */
static int hf_nr_rrc_measResultsPerCarrierListIdleNR_r16_item = -1;  /* MeasResultsPerCarrierIdleNR_r16 */
static int hf_nr_rrc_measResultsPerCellListIdleNR_r16 = -1;  /* SEQUENCE_SIZE_1_maxCellMeasIdle_r16_OF_MeasResultsPerCellIdleNR_r16 */
static int hf_nr_rrc_measResultsPerCellListIdleNR_r16_item = -1;  /* MeasResultsPerCellIdleNR_r16 */
static int hf_nr_rrc_measIdleResultNR_r16 = -1;   /* T_measIdleResultNR_r16 */
static int hf_nr_rrc_ResultsPerSSB_IndexList_r16_item = -1;  /* ResultsPerSSB_IndexIdle_r16 */
static int hf_nr_rrc_ssb_Results_r16 = -1;        /* T_ssb_Results_r16 */
static int hf_nr_rrc_ssb_RSRP_Result_r16 = -1;    /* RSRP_Range */
static int hf_nr_rrc_ssb_RSRQ_Result_r16 = -1;    /* RSRQ_Range */
static int hf_nr_rrc_measResultPerMOList = -1;    /* MeasResultList2NR */
static int hf_nr_rrc_MeasResultList2NR_item = -1;  /* MeasResult2NR */
static int hf_nr_rrc_measResultsListSL_r16 = -1;  /* T_measResultsListSL_r16 */
static int hf_nr_rrc_measResultNR_SL_r16 = -1;    /* MeasResultNR_SL_r16 */
static int hf_nr_rrc_measResultListCBR_NR_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofSL_PoolToMeasureNR_r16_OF_MeasResultCBR_NR_r16 */
static int hf_nr_rrc_measResultListCBR_NR_r16_item = -1;  /* MeasResultCBR_NR_r16 */
static int hf_nr_rrc_sl_poolReportIdentity_r16 = -1;  /* SL_ResourcePoolID_r16 */
static int hf_nr_rrc_sl_CBR_ResultsNR_r16 = -1;   /* SL_CBR_r16 */
static int hf_nr_rrc_measTriggerQuantityEUTRA_rsrp = -1;  /* RSRP_RangeEUTRA */
static int hf_nr_rrc_measTriggerQuantityEUTRA_rsrq = -1;  /* RSRQ_RangeEUTRA */
static int hf_nr_rrc_measTriggerQuantityEUTRA_sinr = -1;  /* SINR_RangeEUTRA */
static int hf_nr_rrc_t_Evaluation = -1;           /* T_t_Evaluation */
static int hf_nr_rrc_t_HystNormal = -1;           /* T_t_HystNormal */
static int hf_nr_rrc_n_CellChangeMedium = -1;     /* INTEGER_1_16 */
static int hf_nr_rrc_n_CellChangeHigh = -1;       /* INTEGER_1_16 */
static int hf_nr_rrc_rach_ConfigCommonTwoStepRA_r16 = -1;  /* RACH_ConfigCommonTwoStepRA_r16 */
static int hf_nr_rrc_msgA_PUSCH_Config_r16 = -1;  /* MsgA_PUSCH_Config_r16 */
static int hf_nr_rrc_msgA_PUSCH_ResourceGroupA_r16 = -1;  /* MsgA_PUSCH_Resource_r16 */
static int hf_nr_rrc_msgA_PUSCH_ResourceGroupB_r16 = -1;  /* MsgA_PUSCH_Resource_r16 */
static int hf_nr_rrc_msgA_TransformPrecoder_r16 = -1;  /* T_msgA_TransformPrecoder_r16 */
static int hf_nr_rrc_msgA_DataScramblingIndex_r16 = -1;  /* INTEGER_0_1023 */
static int hf_nr_rrc_msgA_DeltaPreamble_r16 = -1;  /* INTEGER_M1_6 */
static int hf_nr_rrc_msgA_MCS_r16 = -1;           /* INTEGER_0_15 */
static int hf_nr_rrc_nrofSlotsMsgA_PUSCH_r16 = -1;  /* INTEGER_1_4 */
static int hf_nr_rrc_nrofMsgA_PO_PerSlot_r16 = -1;  /* T_nrofMsgA_PO_PerSlot_r16 */
static int hf_nr_rrc_msgA_PUSCH_TimeDomainOffset_r16 = -1;  /* INTEGER_1_32 */
static int hf_nr_rrc_msgA_PUSCH_TimeDomainAllocation_r16 = -1;  /* INTEGER_1_maxNrofUL_Allocations */
static int hf_nr_rrc_startSymbolAndLengthMsgA_PO_r16 = -1;  /* INTEGER_0_127 */
static int hf_nr_rrc_mappingTypeMsgA_PUSCH_r16 = -1;  /* T_mappingTypeMsgA_PUSCH_r16 */
static int hf_nr_rrc_guardPeriodMsgA_PUSCH_r16 = -1;  /* INTEGER_0_3 */
static int hf_nr_rrc_guardBandMsgA_PUSCH_r16 = -1;  /* INTEGER_0_1 */
static int hf_nr_rrc_frequencyStartMsgA_PUSCH_r16 = -1;  /* INTEGER_0_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_nrofPRBs_PerMsgA_PO_r16 = -1;  /* INTEGER_1_32 */
static int hf_nr_rrc_nrofMsgA_PO_FDM_r16 = -1;    /* T_nrofMsgA_PO_FDM_r16 */
static int hf_nr_rrc_msgA_IntraSlotFrequencyHopping_r16 = -1;  /* T_msgA_IntraSlotFrequencyHopping_r16 */
static int hf_nr_rrc_msgA_HoppingBits_r16 = -1;   /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_msgA_DMRS_Config_r16 = -1;   /* MsgA_DMRS_Config_r16 */
static int hf_nr_rrc_nrofDMRS_Sequences_r16 = -1;  /* INTEGER_1_2 */
static int hf_nr_rrc_msgA_Alpha_r16 = -1;         /* T_msgA_Alpha_r16 */
static int hf_nr_rrc_interlaceIndexFirstPO_MsgA_PUSCH_r16 = -1;  /* INTEGER_1_10 */
static int hf_nr_rrc_nrofInterlacesPerMsgA_PO_r16 = -1;  /* INTEGER_1_10 */
static int hf_nr_rrc_msgA_DMRS_AdditionalPosition_r16 = -1;  /* T_msgA_DMRS_AdditionalPosition_r16 */
static int hf_nr_rrc_msgA_MaxLength_r16 = -1;     /* T_msgA_MaxLength_r16 */
static int hf_nr_rrc_msgA_PUSCH_DMRS_CDM_Group_r16 = -1;  /* INTEGER_0_1 */
static int hf_nr_rrc_msgA_PUSCH_NrofPorts_r16 = -1;  /* INTEGER_0_1 */
static int hf_nr_rrc_msgA_ScramblingID0_r16 = -1;  /* INTEGER_0_65535 */
static int hf_nr_rrc_msgA_ScramblingID1_r16 = -1;  /* INTEGER_0_65535 */
static int hf_nr_rrc_MultiFrequencyBandListNR_item = -1;  /* FreqBandIndicatorNR */
static int hf_nr_rrc_MultiFrequencyBandListNR_SIB_item = -1;  /* NR_MultiBandInfo */
static int hf_nr_rrc_nr_NS_PmaxList = -1;         /* NR_NS_PmaxList */
static int hf_nr_rrc_requestedTargetBandFilterNR_r16 = -1;  /* SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicatorNR */
static int hf_nr_rrc_requestedTargetBandFilterNR_r16_item = -1;  /* FreqBandIndicatorNR */
static int hf_nr_rrc_intraFreq_needForGap_r16 = -1;  /* NeedForGapsIntraFreqList_r16 */
static int hf_nr_rrc_interFreq_needForGap_r16 = -1;  /* NeedForGapsBandListNR_r16 */
static int hf_nr_rrc_NeedForGapsIntraFreqList_r16_item = -1;  /* NeedForGapsIntraFreq_r16 */
static int hf_nr_rrc_NeedForGapsBandListNR_r16_item = -1;  /* NeedForGapsNR_r16 */
static int hf_nr_rrc_servCellId_r16 = -1;         /* ServCellIndex */
static int hf_nr_rrc_gapIndicationIntra_r16 = -1;  /* T_gapIndicationIntra_r16 */
static int hf_nr_rrc_bandNR_r16 = -1;             /* FreqBandIndicatorNR */
static int hf_nr_rrc_gapIndication_r16 = -1;      /* T_gapIndication_r16 */
static int hf_nr_rrc_pni_npn_r16 = -1;            /* T_pni_npn_r16 */
static int hf_nr_rrc_cag_IdentityList_r16 = -1;   /* SEQUENCE_SIZE_1_maxNPN_r16_OF_CAG_IdentityInfo_r16 */
static int hf_nr_rrc_cag_IdentityList_r16_item = -1;  /* CAG_IdentityInfo_r16 */
static int hf_nr_rrc_snpn_r16 = -1;               /* T_snpn_r16 */
static int hf_nr_rrc_nid_List_r16 = -1;           /* SEQUENCE_SIZE_1_maxNPN_r16_OF_NID_r16 */
static int hf_nr_rrc_nid_List_r16_item = -1;      /* NID_r16 */
static int hf_nr_rrc_cag_Identity_r16 = -1;       /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_manualCAGselectionAllowed_r16 = -1;  /* T_manualCAGselectionAllowed_r16 */
static int hf_nr_rrc_NPN_IdentityInfoList_r16_item = -1;  /* NPN_IdentityInfo_r16 */
static int hf_nr_rrc_npn_IdentityList_r16 = -1;   /* SEQUENCE_SIZE_1_maxNPN_r16_OF_NPN_Identity_r16 */
static int hf_nr_rrc_npn_IdentityList_r16_item = -1;  /* NPN_Identity_r16 */
static int hf_nr_rrc_ranac_r16 = -1;              /* RAN_AreaCode */
static int hf_nr_rrc_cellReservedForOperatorUse_r16 = -1;  /* T_cellReservedForOperatorUse_r16 */
static int hf_nr_rrc_iab_Support_r16 = -1;        /* T_iab_Support_r16 */
static int hf_nr_rrc_NR_NS_PmaxList_item = -1;    /* NR_NS_PmaxValue */
static int hf_nr_rrc_additionalPmax = -1;         /* P_Max */
static int hf_nr_rrc_nzp_CSI_RS_ResourceId = -1;  /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_resourceMapping = -1;        /* CSI_RS_ResourceMapping */
static int hf_nr_rrc_powerControlOffset = -1;     /* INTEGER_M8_15 */
static int hf_nr_rrc_powerControlOffsetSS = -1;   /* T_powerControlOffsetSS */
static int hf_nr_rrc_scramblingID = -1;           /* ScramblingId */
static int hf_nr_rrc_qcl_InfoPeriodicCSI_RS = -1;  /* TCI_StateId */
static int hf_nr_rrc_nzp_CSI_ResourceSetId = -1;  /* NZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_nzp_CSI_RS_Resources = -1;   /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourcesPerSet_OF_NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_nzp_CSI_RS_Resources_item = -1;  /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_repetition = -1;             /* T_repetition */
static int hf_nr_rrc_aperiodicTriggeringOffset = -1;  /* INTEGER_0_6 */
static int hf_nr_rrc_trs_Info = -1;               /* T_trs_Info */
static int hf_nr_rrc_aperiodicTriggeringOffset_r16 = -1;  /* INTEGER_0_31 */
static int hf_nr_rrc_PCI_List_item = -1;          /* PhysCellId */
static int hf_nr_rrc_start = -1;                  /* PhysCellId */
static int hf_nr_rrc_range = -1;                  /* T_range */
static int hf_nr_rrc_pci_RangeIndex = -1;         /* PCI_RangeIndex */
static int hf_nr_rrc_pci_Range = -1;              /* PCI_Range */
static int hf_nr_rrc_PCI_RangeIndexList_item = -1;  /* PCI_RangeIndex */
static int hf_nr_rrc_controlResourceSetToAddModList = -1;  /* SEQUENCE_SIZE_1_3_OF_ControlResourceSet */
static int hf_nr_rrc_controlResourceSetToAddModList_item = -1;  /* ControlResourceSet */
static int hf_nr_rrc_controlResourceSetToReleaseList = -1;  /* SEQUENCE_SIZE_1_3_OF_ControlResourceSetId */
static int hf_nr_rrc_controlResourceSetToReleaseList_item = -1;  /* ControlResourceSetId */
static int hf_nr_rrc_searchSpacesToAddModList = -1;  /* SEQUENCE_SIZE_1_10_OF_SearchSpace */
static int hf_nr_rrc_searchSpacesToAddModList_item = -1;  /* SearchSpace */
static int hf_nr_rrc_searchSpacesToReleaseList = -1;  /* SEQUENCE_SIZE_1_10_OF_SearchSpaceId */
static int hf_nr_rrc_searchSpacesToReleaseList_item = -1;  /* SearchSpaceId */
static int hf_nr_rrc_downlinkPreemption = -1;     /* T_downlinkPreemption */
static int hf_nr_rrc_setup_50 = -1;               /* DownlinkPreemption */
static int hf_nr_rrc_tpc_PUSCH = -1;              /* T_tpc_PUSCH */
static int hf_nr_rrc_setup_51 = -1;               /* PUSCH_TPC_CommandConfig */
static int hf_nr_rrc_tpc_PUCCH = -1;              /* T_tpc_PUCCH */
static int hf_nr_rrc_setup_52 = -1;               /* PUCCH_TPC_CommandConfig */
static int hf_nr_rrc_tpc_SRS = -1;                /* T_tpc_SRS */
static int hf_nr_rrc_setup_53 = -1;               /* SRS_TPC_CommandConfig */
static int hf_nr_rrc_controlResourceSetToAddModListSizeExt_v1610 = -1;  /* SEQUENCE_SIZE_1_2_OF_ControlResourceSet */
static int hf_nr_rrc_controlResourceSetToAddModListSizeExt_v1610_item = -1;  /* ControlResourceSet */
static int hf_nr_rrc_controlResourceSetToReleaseListSizeExt_r16 = -1;  /* SEQUENCE_SIZE_1_5_OF_ControlResourceSetId_r16 */
static int hf_nr_rrc_controlResourceSetToReleaseListSizeExt_r16_item = -1;  /* ControlResourceSetId_r16 */
static int hf_nr_rrc_searchSpacesToAddModListExt_r16 = -1;  /* SEQUENCE_SIZE_1_10_OF_SearchSpaceExt_r16 */
static int hf_nr_rrc_searchSpacesToAddModListExt_r16_item = -1;  /* SearchSpaceExt_r16 */
static int hf_nr_rrc_uplinkCancellation_r16 = -1;  /* T_uplinkCancellation_r16 */
static int hf_nr_rrc_setup_54 = -1;               /* UplinkCancellation_r16 */
static int hf_nr_rrc_monitoringCapabilityConfig_r16 = -1;  /* T_monitoringCapabilityConfig_r16 */
static int hf_nr_rrc_searchSpaceSwitchConfig_r16 = -1;  /* SearchSpaceSwitchConfig_r16 */
static int hf_nr_rrc_cellGroupsForSwitchList_r16 = -1;  /* SEQUENCE_SIZE_1_4_OF_CellGroupForSwitch_r16 */
static int hf_nr_rrc_cellGroupsForSwitchList_r16_item = -1;  /* CellGroupForSwitch_r16 */
static int hf_nr_rrc_searchSpaceSwitchDelay_r16 = -1;  /* INTEGER_10_52 */
static int hf_nr_rrc_CellGroupForSwitch_r16_item = -1;  /* ServCellIndex */
static int hf_nr_rrc_controlResourceSetZero = -1;  /* ControlResourceSetZero */
static int hf_nr_rrc_commonControlResourceSet = -1;  /* ControlResourceSet */
static int hf_nr_rrc_searchSpaceZero = -1;        /* SearchSpaceZero */
static int hf_nr_rrc_commonSearchSpaceList = -1;  /* SEQUENCE_SIZE_1_4_OF_SearchSpace */
static int hf_nr_rrc_commonSearchSpaceList_item = -1;  /* SearchSpace */
static int hf_nr_rrc_searchSpaceSIB1 = -1;        /* SearchSpaceId */
static int hf_nr_rrc_searchSpaceOtherSystemInformation = -1;  /* SearchSpaceId */
static int hf_nr_rrc_pagingSearchSpace = -1;      /* SearchSpaceId */
static int hf_nr_rrc_ra_SearchSpace = -1;         /* SearchSpaceId */
static int hf_nr_rrc_firstPDCCH_MonitoringOccasionOfPO_01 = -1;  /* T_firstPDCCH_MonitoringOccasionOfPO_01 */
static int hf_nr_rrc_sCS15KHZoneT_01 = -1;        /* T_sCS15KHZoneT_01 */
static int hf_nr_rrc_sCS30KHZoneT_SCS15KHZhalfT_01 = -1;  /* T_sCS30KHZoneT_SCS15KHZhalfT_01 */
static int hf_nr_rrc_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT_01 = -1;  /* T_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT_01 */
static int hf_nr_rrc_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT_01 = -1;  /* T_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT_01 */
static int hf_nr_rrc_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT_01 = -1;  /* T_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT_01 */
static int hf_nr_rrc_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT_01 = -1;  /* T_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT_01 */
static int hf_nr_rrc_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT_01 = -1;  /* T_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT_01 */
static int hf_nr_rrc_sCS120KHZoneSixteenthT_01 = -1;  /* T_sCS120KHZoneSixteenthT_01 */
static int hf_nr_rrc_commonSearchSpaceListExt_r16 = -1;  /* SEQUENCE_SIZE_1_4_OF_SearchSpaceExt_r16 */
static int hf_nr_rrc_commonSearchSpaceListExt_r16_item = -1;  /* SearchSpaceExt_r16 */
static int hf_nr_rrc_slotFormatIndicator = -1;    /* T_slotFormatIndicator */
static int hf_nr_rrc_setup_55 = -1;               /* SlotFormatIndicator */
static int hf_nr_rrc_availabilityIndicator_r16 = -1;  /* T_availabilityIndicator_r16 */
static int hf_nr_rrc_setup_56 = -1;               /* AvailabilityIndicator_r16 */
static int hf_nr_rrc_searchSpaceSwitchTimer_r16 = -1;  /* INTEGER_1_80 */
static int hf_nr_rrc_drb = -1;                    /* T_drb */
static int hf_nr_rrc_discardTimer = -1;           /* T_discardTimer */
static int hf_nr_rrc_pdcp_SN_SizeUL = -1;         /* T_pdcp_SN_SizeUL */
static int hf_nr_rrc_pdcp_SN_SizeDL = -1;         /* T_pdcp_SN_SizeDL */
static int hf_nr_rrc_headerCompression = -1;      /* T_headerCompression */
static int hf_nr_rrc_notUsed = -1;                /* NULL */
static int hf_nr_rrc_rohc = -1;                   /* T_rohc */
static int hf_nr_rrc_maxCID = -1;                 /* INTEGER_1_16383 */
static int hf_nr_rrc_profiles = -1;               /* T_profiles */
static int hf_nr_rrc_profile0x0001 = -1;          /* BOOLEAN */
static int hf_nr_rrc_profile0x0002 = -1;          /* BOOLEAN */
static int hf_nr_rrc_profile0x0003 = -1;          /* BOOLEAN */
static int hf_nr_rrc_profile0x0004 = -1;          /* BOOLEAN */
static int hf_nr_rrc_profile0x0006 = -1;          /* BOOLEAN */
static int hf_nr_rrc_profile0x0101 = -1;          /* BOOLEAN */
static int hf_nr_rrc_profile0x0102 = -1;          /* BOOLEAN */
static int hf_nr_rrc_profile0x0103 = -1;          /* BOOLEAN */
static int hf_nr_rrc_profile0x0104 = -1;          /* BOOLEAN */
static int hf_nr_rrc_drb_ContinueROHC = -1;       /* T_drb_ContinueROHC */
static int hf_nr_rrc_uplinkOnlyROHC = -1;         /* T_uplinkOnlyROHC */
static int hf_nr_rrc_profiles_01 = -1;            /* T_profiles_01 */
static int hf_nr_rrc_drb_ContinueROHC_01 = -1;    /* T_drb_ContinueROHC_01 */
static int hf_nr_rrc_integrityProtection = -1;    /* T_integrityProtection */
static int hf_nr_rrc_statusReportRequired = -1;   /* T_statusReportRequired */
static int hf_nr_rrc_outOfOrderDelivery = -1;     /* T_outOfOrderDelivery */
static int hf_nr_rrc_moreThanOneRLC = -1;         /* T_moreThanOneRLC */
static int hf_nr_rrc_primaryPath = -1;            /* T_primaryPath */
static int hf_nr_rrc_cellGroup = -1;              /* CellGroupId */
static int hf_nr_rrc_logicalChannel = -1;         /* LogicalChannelIdentity */
static int hf_nr_rrc_ul_DataSplitThreshold = -1;  /* UL_DataSplitThreshold */
static int hf_nr_rrc_pdcp_Duplication = -1;       /* BOOLEAN */
static int hf_nr_rrc_t_Reordering = -1;           /* T_t_Reordering */
static int hf_nr_rrc_cipheringDisabled = -1;      /* T_cipheringDisabled */
static int hf_nr_rrc_discardTimerExt_r16 = -1;    /* T_discardTimerExt_r16 */
static int hf_nr_rrc_setup_57 = -1;               /* DiscardTimerExt_r16 */
static int hf_nr_rrc_moreThanTwoRLC_DRB_r16 = -1;  /* T_moreThanTwoRLC_DRB_r16 */
static int hf_nr_rrc_splitSecondaryPath_r16 = -1;  /* LogicalChannelIdentity */
static int hf_nr_rrc_duplicationState_r16 = -1;   /* T_duplicationState_r16 */
static int hf_nr_rrc_duplicationState_r16_item = -1;  /* BOOLEAN */
static int hf_nr_rrc_ethernetHeaderCompression_r16 = -1;  /* T_ethernetHeaderCompression_r16 */
static int hf_nr_rrc_setup_58 = -1;               /* EthernetHeaderCompression_r16 */
static int hf_nr_rrc_ehc_Common_r16 = -1;         /* T_ehc_Common_r16 */
static int hf_nr_rrc_ehc_CID_Length_r16 = -1;     /* T_ehc_CID_Length_r16 */
static int hf_nr_rrc_ehc_Downlink_r16 = -1;       /* T_ehc_Downlink_r16 */
static int hf_nr_rrc_drb_ContinueEHC_DL_r16 = -1;  /* T_drb_ContinueEHC_DL_r16 */
static int hf_nr_rrc_ehc_Uplink_r16 = -1;         /* T_ehc_Uplink_r16 */
static int hf_nr_rrc_maxCID_EHC_UL_r16 = -1;      /* INTEGER_1_32767 */
static int hf_nr_rrc_drb_ContinueEHC_UL_r16 = -1;  /* T_drb_ContinueEHC_UL_r16 */
static int hf_nr_rrc_dataScramblingIdentityPDSCH = -1;  /* INTEGER_0_1023 */
static int hf_nr_rrc_dmrs_DownlinkForPDSCH_MappingTypeA = -1;  /* T_dmrs_DownlinkForPDSCH_MappingTypeA */
static int hf_nr_rrc_setup_59 = -1;               /* DMRS_DownlinkConfig */
static int hf_nr_rrc_dmrs_DownlinkForPDSCH_MappingTypeB = -1;  /* T_dmrs_DownlinkForPDSCH_MappingTypeB */
static int hf_nr_rrc_tci_StatesToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofTCI_States_OF_TCI_State */
static int hf_nr_rrc_tci_StatesToAddModList_item = -1;  /* TCI_State */
static int hf_nr_rrc_tci_StatesToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofTCI_States_OF_TCI_StateId */
static int hf_nr_rrc_tci_StatesToReleaseList_item = -1;  /* TCI_StateId */
static int hf_nr_rrc_vrb_ToPRB_Interleaver = -1;  /* T_vrb_ToPRB_Interleaver */
static int hf_nr_rrc_resourceAllocation_01 = -1;  /* T_resourceAllocation_01 */
static int hf_nr_rrc_pdsch_TimeDomainAllocationList = -1;  /* T_pdsch_TimeDomainAllocationList */
static int hf_nr_rrc_setup_60 = -1;               /* PDSCH_TimeDomainResourceAllocationList */
static int hf_nr_rrc_pdsch_AggregationFactor = -1;  /* T_pdsch_AggregationFactor */
static int hf_nr_rrc_rateMatchPatternToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofRateMatchPatterns_OF_RateMatchPattern */
static int hf_nr_rrc_rateMatchPatternToAddModList_item = -1;  /* RateMatchPattern */
static int hf_nr_rrc_rateMatchPatternToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofRateMatchPatterns_OF_RateMatchPatternId */
static int hf_nr_rrc_rateMatchPatternToReleaseList_item = -1;  /* RateMatchPatternId */
static int hf_nr_rrc_rateMatchPatternGroup1 = -1;  /* RateMatchPatternGroup */
static int hf_nr_rrc_rateMatchPatternGroup2 = -1;  /* RateMatchPatternGroup */
static int hf_nr_rrc_rbg_Size_01 = -1;            /* T_rbg_Size_01 */
static int hf_nr_rrc_mcs_Table_01 = -1;           /* T_mcs_Table_01 */
static int hf_nr_rrc_maxNrofCodeWordsScheduledByDCI = -1;  /* T_maxNrofCodeWordsScheduledByDCI */
static int hf_nr_rrc_prb_BundlingType = -1;       /* T_prb_BundlingType */
static int hf_nr_rrc_staticBundling = -1;         /* T_staticBundling */
static int hf_nr_rrc_bundleSize = -1;             /* T_bundleSize */
static int hf_nr_rrc_dynamicBundling = -1;        /* T_dynamicBundling */
static int hf_nr_rrc_bundleSizeSet1 = -1;         /* T_bundleSizeSet1 */
static int hf_nr_rrc_bundleSizeSet2 = -1;         /* T_bundleSizeSet2 */
static int hf_nr_rrc_zp_CSI_RS_ResourceToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_Resources_OF_ZP_CSI_RS_Resource */
static int hf_nr_rrc_zp_CSI_RS_ResourceToAddModList_item = -1;  /* ZP_CSI_RS_Resource */
static int hf_nr_rrc_zp_CSI_RS_ResourceToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_Resources_OF_ZP_CSI_RS_ResourceId */
static int hf_nr_rrc_zp_CSI_RS_ResourceToReleaseList_item = -1;  /* ZP_CSI_RS_ResourceId */
static int hf_nr_rrc_aperiodic_ZP_CSI_RS_ResourceSetsToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_ResourceSets_OF_ZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_aperiodic_ZP_CSI_RS_ResourceSetsToAddModList_item = -1;  /* ZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_aperiodic_ZP_CSI_RS_ResourceSetsToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_ResourceSets_OF_ZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_aperiodic_ZP_CSI_RS_ResourceSetsToReleaseList_item = -1;  /* ZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_sp_ZP_CSI_RS_ResourceSetsToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_ResourceSets_OF_ZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_sp_ZP_CSI_RS_ResourceSetsToAddModList_item = -1;  /* ZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_sp_ZP_CSI_RS_ResourceSetsToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_ResourceSets_OF_ZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_sp_ZP_CSI_RS_ResourceSetsToReleaseList_item = -1;  /* ZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_p_ZP_CSI_RS_ResourceSet = -1;  /* T_p_ZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_setup_61 = -1;               /* ZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_maxMIMO_Layers_r16 = -1;     /* T_maxMIMO_Layers_r16 */
static int hf_nr_rrc_setup_62 = -1;               /* MaxMIMO_LayersDL_r16 */
static int hf_nr_rrc_minimumSchedulingOffsetK0_r16 = -1;  /* T_minimumSchedulingOffsetK0_r16 */
static int hf_nr_rrc_setup_63 = -1;               /* MinSchedulingOffsetK0_Values_r16 */
static int hf_nr_rrc_antennaPortsFieldPresenceDCI_1_2_r16 = -1;  /* T_antennaPortsFieldPresenceDCI_1_2_r16 */
static int hf_nr_rrc_aperiodicZP_CSI_RS_ResourceSetsToAddModListDCI_1_2_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_ResourceSets_OF_ZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_aperiodicZP_CSI_RS_ResourceSetsToAddModListDCI_1_2_r16_item = -1;  /* ZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_aperiodicZP_CSI_RS_ResourceSetsToReleaseListDCI_1_2_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_ResourceSets_OF_ZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_aperiodicZP_CSI_RS_ResourceSetsToReleaseListDCI_1_2_r16_item = -1;  /* ZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16 = -1;  /* T_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16 */
static int hf_nr_rrc_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16 = -1;  /* T_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16 */
static int hf_nr_rrc_dmrs_SequenceInitializationDCI_1_2_r16 = -1;  /* T_dmrs_SequenceInitializationDCI_1_2_r16 */
static int hf_nr_rrc_harq_ProcessNumberSizeDCI_1_2_r16 = -1;  /* INTEGER_0_4 */
static int hf_nr_rrc_mcs_TableDCI_1_2_r16 = -1;   /* T_mcs_TableDCI_1_2_r16 */
static int hf_nr_rrc_numberOfBitsForRV_DCI_1_2_r16 = -1;  /* INTEGER_0_2 */
static int hf_nr_rrc_pdsch_TimeDomainAllocationListDCI_1_2_r16 = -1;  /* T_pdsch_TimeDomainAllocationListDCI_1_2_r16 */
static int hf_nr_rrc_setup_64 = -1;               /* PDSCH_TimeDomainResourceAllocationList_r16 */
static int hf_nr_rrc_prb_BundlingTypeDCI_1_2_r16 = -1;  /* T_prb_BundlingTypeDCI_1_2_r16 */
static int hf_nr_rrc_staticBundling_r16 = -1;     /* T_staticBundling_r16 */
static int hf_nr_rrc_bundleSize_r16 = -1;         /* T_bundleSize_r16 */
static int hf_nr_rrc_dynamicBundling_r16 = -1;    /* T_dynamicBundling_r16 */
static int hf_nr_rrc_bundleSizeSet1_r16 = -1;     /* T_bundleSizeSet1_r16 */
static int hf_nr_rrc_bundleSizeSet2_r16 = -1;     /* T_bundleSizeSet2_r16 */
static int hf_nr_rrc_priorityIndicatorDCI_1_2_r16 = -1;  /* T_priorityIndicatorDCI_1_2_r16 */
static int hf_nr_rrc_rateMatchPatternGroup1DCI_1_2_r16 = -1;  /* RateMatchPatternGroup */
static int hf_nr_rrc_rateMatchPatternGroup2DCI_1_2_r16 = -1;  /* RateMatchPatternGroup */
static int hf_nr_rrc_resourceAllocationType1GranularityDCI_1_2_r16 = -1;  /* T_resourceAllocationType1GranularityDCI_1_2_r16 */
static int hf_nr_rrc_vrb_ToPRB_InterleaverDCI_1_2_r16 = -1;  /* T_vrb_ToPRB_InterleaverDCI_1_2_r16 */
static int hf_nr_rrc_referenceOfSLIVDCI_1_2_r16 = -1;  /* T_referenceOfSLIVDCI_1_2_r16 */
static int hf_nr_rrc_resourceAllocationDCI_1_2_r16 = -1;  /* T_resourceAllocationDCI_1_2_r16 */
static int hf_nr_rrc_priorityIndicatorDCI_1_1_r16 = -1;  /* T_priorityIndicatorDCI_1_1_r16 */
static int hf_nr_rrc_dataScramblingIdentityPDSCH2_r16 = -1;  /* INTEGER_0_1023 */
static int hf_nr_rrc_pdsch_TimeDomainAllocationList_r16 = -1;  /* T_pdsch_TimeDomainAllocationList_r16 */
static int hf_nr_rrc_repetitionSchemeConfig_r16 = -1;  /* T_repetitionSchemeConfig_r16 */
static int hf_nr_rrc_setup_65 = -1;               /* RepetitionSchemeConfig_r16 */
static int hf_nr_rrc_repetitionSchemeConfig_v1630 = -1;  /* T_repetitionSchemeConfig_v1630 */
static int hf_nr_rrc_setup_66 = -1;               /* RepetitionSchemeConfig_v1630 */
static int hf_nr_rrc_RateMatchPatternGroup_item = -1;  /* RateMatchPatternGroup_item */
static int hf_nr_rrc_cellLevel = -1;              /* RateMatchPatternId */
static int hf_nr_rrc_bwpLevel = -1;               /* RateMatchPatternId */
static int hf_nr_rrc_MinSchedulingOffsetK0_Values_r16_item = -1;  /* INTEGER_0_maxK0_SchedulingOffset_r16 */
static int hf_nr_rrc_pdsch_TimeDomainAllocationList_01 = -1;  /* PDSCH_TimeDomainResourceAllocationList */
static int hf_nr_rrc_codeBlockGroupTransmission = -1;  /* T_codeBlockGroupTransmission */
static int hf_nr_rrc_setup_67 = -1;               /* PDSCH_CodeBlockGroupTransmission */
static int hf_nr_rrc_xOverhead = -1;              /* T_xOverhead */
static int hf_nr_rrc_nrofHARQ_ProcessesForPDSCH = -1;  /* T_nrofHARQ_ProcessesForPDSCH */
static int hf_nr_rrc_pucch_Cell = -1;             /* ServCellIndex */
static int hf_nr_rrc_maxMIMO_Layers = -1;         /* INTEGER_1_8 */
static int hf_nr_rrc_processingType2Enabled = -1;  /* BOOLEAN */
static int hf_nr_rrc_pdsch_CodeBlockGroupTransmissionList_r16 = -1;  /* T_pdsch_CodeBlockGroupTransmissionList_r16 */
static int hf_nr_rrc_setup_68 = -1;               /* PDSCH_CodeBlockGroupTransmissionList_r16 */
static int hf_nr_rrc_maxCodeBlockGroupsPerTransportBlock = -1;  /* T_maxCodeBlockGroupsPerTransportBlock */
static int hf_nr_rrc_codeBlockGroupFlushIndicator = -1;  /* BOOLEAN */
static int hf_nr_rrc_PDSCH_CodeBlockGroupTransmissionList_r16_item = -1;  /* PDSCH_CodeBlockGroupTransmission */
static int hf_nr_rrc_PDSCH_TimeDomainResourceAllocationList_item = -1;  /* PDSCH_TimeDomainResourceAllocation */
static int hf_nr_rrc_k0 = -1;                     /* INTEGER_0_32 */
static int hf_nr_rrc_mappingType = -1;            /* T_mappingType */
static int hf_nr_rrc_startSymbolAndLength = -1;   /* INTEGER_0_127 */
static int hf_nr_rrc_PDSCH_TimeDomainResourceAllocationList_r16_item = -1;  /* PDSCH_TimeDomainResourceAllocation_r16 */
static int hf_nr_rrc_k0_r16 = -1;                 /* INTEGER_0_32 */
static int hf_nr_rrc_mappingType_r16 = -1;        /* T_mappingType_r16 */
static int hf_nr_rrc_startSymbolAndLength_r16 = -1;  /* INTEGER_0_127 */
static int hf_nr_rrc_repetitionNumber_r16 = -1;   /* T_repetitionNumber_r16 */
static int hf_nr_rrc_phr_PeriodicTimer = -1;      /* T_phr_PeriodicTimer */
static int hf_nr_rrc_phr_ProhibitTimer = -1;      /* T_phr_ProhibitTimer */
static int hf_nr_rrc_phr_Tx_PowerFactorChange = -1;  /* T_phr_Tx_PowerFactorChange */
static int hf_nr_rrc_multiplePHR = -1;            /* BOOLEAN */
static int hf_nr_rrc_pHR_Config_dummy = -1;       /* BOOLEAN */
static int hf_nr_rrc_phr_Type2OtherCell = -1;     /* BOOLEAN */
static int hf_nr_rrc_phr_ModeOtherCG = -1;        /* T_phr_ModeOtherCG */
static int hf_nr_rrc_mpe_Reporting_FR2_r16 = -1;  /* T_mpe_Reporting_FR2_r16 */
static int hf_nr_rrc_setup_69 = -1;               /* MPE_Config_FR2_r16 */
static int hf_nr_rrc_mpe_ProhibitTimer_r16 = -1;  /* T_mpe_ProhibitTimer_r16 */
static int hf_nr_rrc_mpe_Threshold_r16 = -1;      /* T_mpe_Threshold_r16 */
static int hf_nr_rrc_harq_ACK_SpatialBundlingPUCCH = -1;  /* T_harq_ACK_SpatialBundlingPUCCH */
static int hf_nr_rrc_harq_ACK_SpatialBundlingPUSCH = -1;  /* T_harq_ACK_SpatialBundlingPUSCH */
static int hf_nr_rrc_p_NR_FR1 = -1;               /* P_Max */
static int hf_nr_rrc_pdsch_HARQ_ACK_Codebook = -1;  /* T_pdsch_HARQ_ACK_Codebook */
static int hf_nr_rrc_tpc_SRS_RNTI = -1;           /* RNTI_Value */
static int hf_nr_rrc_tpc_PUCCH_RNTI = -1;         /* RNTI_Value */
static int hf_nr_rrc_tpc_PUSCH_RNTI = -1;         /* RNTI_Value */
static int hf_nr_rrc_sp_CSI_RNTI = -1;            /* RNTI_Value */
static int hf_nr_rrc_cs_RNTI = -1;                /* T_cs_RNTI */
static int hf_nr_rrc_setup_70 = -1;               /* RNTI_Value */
static int hf_nr_rrc_mcs_C_RNTI = -1;             /* RNTI_Value */
static int hf_nr_rrc_p_UE_FR1 = -1;               /* P_Max */
static int hf_nr_rrc_xScale = -1;                 /* T_xScale */
static int hf_nr_rrc_pdcch_BlindDetection = -1;   /* T_pdcch_BlindDetection */
static int hf_nr_rrc_setup_71 = -1;               /* PDCCH_BlindDetection */
static int hf_nr_rrc_dcp_Config_r16 = -1;         /* T_dcp_Config_r16 */
static int hf_nr_rrc_setup_72 = -1;               /* DCP_Config_r16 */
static int hf_nr_rrc_harq_ACK_SpatialBundlingPUCCH_secondaryPUCCHgroup_r16 = -1;  /* T_harq_ACK_SpatialBundlingPUCCH_secondaryPUCCHgroup_r16 */
static int hf_nr_rrc_harq_ACK_SpatialBundlingPUSCH_secondaryPUCCHgroup_r16 = -1;  /* T_harq_ACK_SpatialBundlingPUSCH_secondaryPUCCHgroup_r16 */
static int hf_nr_rrc_pdsch_HARQ_ACK_Codebook_secondaryPUCCHgroup_r16 = -1;  /* T_pdsch_HARQ_ACK_Codebook_secondaryPUCCHgroup_r16 */
static int hf_nr_rrc_p_NR_FR2_r16 = -1;           /* P_Max */
static int hf_nr_rrc_p_UE_FR2_r16 = -1;           /* P_Max */
static int hf_nr_rrc_nrdc_PCmode_FR1_r16 = -1;    /* T_nrdc_PCmode_FR1_r16 */
static int hf_nr_rrc_nrdc_PCmode_FR2_r16 = -1;    /* T_nrdc_PCmode_FR2_r16 */
static int hf_nr_rrc_pdsch_HARQ_ACK_Codebook_r16 = -1;  /* T_pdsch_HARQ_ACK_Codebook_r16 */
static int hf_nr_rrc_nfi_TotalDAI_Included_r16 = -1;  /* T_nfi_TotalDAI_Included_r16 */
static int hf_nr_rrc_ul_TotalDAI_Included_r16 = -1;  /* T_ul_TotalDAI_Included_r16 */
static int hf_nr_rrc_pdsch_HARQ_ACK_OneShotFeedback_r16 = -1;  /* T_pdsch_HARQ_ACK_OneShotFeedback_r16 */
static int hf_nr_rrc_pdsch_HARQ_ACK_OneShotFeedbackNDI_r16 = -1;  /* T_pdsch_HARQ_ACK_OneShotFeedbackNDI_r16 */
static int hf_nr_rrc_pdsch_HARQ_ACK_OneShotFeedbackCBG_r16 = -1;  /* T_pdsch_HARQ_ACK_OneShotFeedbackCBG_r16 */
static int hf_nr_rrc_downlinkAssignmentIndexDCI_0_2_r16 = -1;  /* T_downlinkAssignmentIndexDCI_0_2_r16 */
static int hf_nr_rrc_downlinkAssignmentIndexDCI_1_2_r16 = -1;  /* T_downlinkAssignmentIndexDCI_1_2_r16 */
static int hf_nr_rrc_pdsch_HARQ_ACK_CodebookList_r16 = -1;  /* T_pdsch_HARQ_ACK_CodebookList_r16 */
static int hf_nr_rrc_setup_73 = -1;               /* PDSCH_HARQ_ACK_CodebookList_r16 */
static int hf_nr_rrc_ackNackFeedbackMode_r16 = -1;  /* T_ackNackFeedbackMode_r16 */
static int hf_nr_rrc_pdcch_BlindDetectionCA_CombIndicator_r16 = -1;  /* T_pdcch_BlindDetectionCA_CombIndicator_r16 */
static int hf_nr_rrc_setup_74 = -1;               /* PDCCH_BlindDetectionCA_CombIndicator_r16 */
static int hf_nr_rrc_pdcch_BlindDetection2_r16 = -1;  /* T_pdcch_BlindDetection2_r16 */
static int hf_nr_rrc_setup_75 = -1;               /* PDCCH_BlindDetection2_r16 */
static int hf_nr_rrc_pdcch_BlindDetection3_r16 = -1;  /* T_pdcch_BlindDetection3_r16 */
static int hf_nr_rrc_setup_76 = -1;               /* PDCCH_BlindDetection3_r16 */
static int hf_nr_rrc_bdFactorR_r16 = -1;          /* T_bdFactorR_r16 */
static int hf_nr_rrc_ps_RNTI_r16 = -1;            /* RNTI_Value */
static int hf_nr_rrc_ps_Offset_r16 = -1;          /* INTEGER_1_120 */
static int hf_nr_rrc_sizeDCI_2_6_r16 = -1;        /* INTEGER_1_maxDCI_2_6_Size_r16 */
static int hf_nr_rrc_ps_PositionDCI_2_6_r16 = -1;  /* INTEGER_0_maxDCI_2_6_Size_1_r16 */
static int hf_nr_rrc_ps_WakeUp_r16 = -1;          /* T_ps_WakeUp_r16 */
static int hf_nr_rrc_ps_TransmitPeriodicL1_RSRP_r16 = -1;  /* T_ps_TransmitPeriodicL1_RSRP_r16 */
static int hf_nr_rrc_ps_TransmitOtherPeriodicCSI_r16 = -1;  /* T_ps_TransmitOtherPeriodicCSI_r16 */
static int hf_nr_rrc_PDSCH_HARQ_ACK_CodebookList_r16_item = -1;  /* PDSCH_HARQ_ACK_CodebookList_r16_item */
static int hf_nr_rrc_pdcch_BlindDetectionCA1_r16 = -1;  /* INTEGER_1_15 */
static int hf_nr_rrc_pdcch_BlindDetectionCA2_r16 = -1;  /* INTEGER_1_15 */
static int hf_nr_rrc_mcc = -1;                    /* MCC */
static int hf_nr_rrc_mnc = -1;                    /* MNC */
static int hf_nr_rrc_MCC_item = -1;               /* MCC_MNC_Digit */
static int hf_nr_rrc_MNC_item = -1;               /* MCC_MNC_Digit */
static int hf_nr_rrc_PLMN_IdentityInfoList_item = -1;  /* PLMN_IdentityInfo */
static int hf_nr_rrc_plmn_IdentityList = -1;      /* SEQUENCE_SIZE_1_maxPLMN_OF_PLMN_Identity */
static int hf_nr_rrc_plmn_IdentityList_item = -1;  /* PLMN_Identity */
static int hf_nr_rrc_ranac = -1;                  /* RAN_AreaCode */
static int hf_nr_rrc_cellReservedForOperatorUse = -1;  /* T_cellReservedForOperatorUse */
static int hf_nr_rrc_iab_Support_r16_01 = -1;     /* T_iab_Support_r16_01 */
static int hf_nr_rrc_PLMN_IdentityList2_r16_item = -1;  /* PLMN_Identity */
static int hf_nr_rrc_frequencyDensity = -1;       /* T_frequencyDensity */
static int hf_nr_rrc_frequencyDensity_item = -1;  /* INTEGER_1_276 */
static int hf_nr_rrc_timeDensity = -1;            /* T_timeDensity */
static int hf_nr_rrc_timeDensity_item = -1;       /* INTEGER_0_29 */
static int hf_nr_rrc_epre_Ratio = -1;             /* INTEGER_0_3 */
static int hf_nr_rrc_resourceElementOffset = -1;  /* T_resourceElementOffset */
static int hf_nr_rrc_maxNrofPorts_r16 = -1;       /* T_maxNrofPorts_r16 */
static int hf_nr_rrc_transformPrecoderDisabled = -1;  /* T_transformPrecoderDisabled */
static int hf_nr_rrc_frequencyDensity_01 = -1;    /* T_frequencyDensity_01 */
static int hf_nr_rrc_timeDensity_01 = -1;         /* T_timeDensity_01 */
static int hf_nr_rrc_maxNrofPorts = -1;           /* T_maxNrofPorts */
static int hf_nr_rrc_resourceElementOffset_01 = -1;  /* T_resourceElementOffset_01 */
static int hf_nr_rrc_ptrs_Power = -1;             /* T_ptrs_Power */
static int hf_nr_rrc_transformPrecoderEnabled = -1;  /* T_transformPrecoderEnabled */
static int hf_nr_rrc_sampleDensity = -1;          /* T_sampleDensity */
static int hf_nr_rrc_sampleDensity_item = -1;     /* INTEGER_1_276 */
static int hf_nr_rrc_timeDensityTransformPrecoding = -1;  /* T_timeDensityTransformPrecoding */
static int hf_nr_rrc_resourceSetToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofPUCCH_ResourceSets_OF_PUCCH_ResourceSet */
static int hf_nr_rrc_resourceSetToAddModList_item = -1;  /* PUCCH_ResourceSet */
static int hf_nr_rrc_resourceSetToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofPUCCH_ResourceSets_OF_PUCCH_ResourceSetId */
static int hf_nr_rrc_resourceSetToReleaseList_item = -1;  /* PUCCH_ResourceSetId */
static int hf_nr_rrc_resourceToAddModList = -1;   /* SEQUENCE_SIZE_1_maxNrofPUCCH_Resources_OF_PUCCH_Resource */
static int hf_nr_rrc_resourceToAddModList_item = -1;  /* PUCCH_Resource */
static int hf_nr_rrc_resourceToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofPUCCH_Resources_OF_PUCCH_ResourceId */
static int hf_nr_rrc_resourceToReleaseList_item = -1;  /* PUCCH_ResourceId */
static int hf_nr_rrc_format1 = -1;                /* T_format1 */
static int hf_nr_rrc_setup_77 = -1;               /* PUCCH_FormatConfig */
static int hf_nr_rrc_format2 = -1;                /* T_format2 */
static int hf_nr_rrc_format3 = -1;                /* T_format3 */
static int hf_nr_rrc_format4 = -1;                /* T_format4 */
static int hf_nr_rrc_schedulingRequestResourceToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofSR_Resources_OF_SchedulingRequestResourceConfig */
static int hf_nr_rrc_schedulingRequestResourceToAddModList_item = -1;  /* SchedulingRequestResourceConfig */
static int hf_nr_rrc_schedulingRequestResourceToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofSR_Resources_OF_SchedulingRequestResourceId */
static int hf_nr_rrc_schedulingRequestResourceToReleaseList_item = -1;  /* SchedulingRequestResourceId */
static int hf_nr_rrc_multi_CSI_PUCCH_ResourceList = -1;  /* SEQUENCE_SIZE_1_2_OF_PUCCH_ResourceId */
static int hf_nr_rrc_multi_CSI_PUCCH_ResourceList_item = -1;  /* PUCCH_ResourceId */
static int hf_nr_rrc_dl_DataToUL_ACK = -1;        /* T_dl_DataToUL_ACK */
static int hf_nr_rrc_dl_DataToUL_ACK_item = -1;   /* INTEGER_0_15 */
static int hf_nr_rrc_spatialRelationInfoToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofSpatialRelationInfos_OF_PUCCH_SpatialRelationInfo */
static int hf_nr_rrc_spatialRelationInfoToAddModList_item = -1;  /* PUCCH_SpatialRelationInfo */
static int hf_nr_rrc_spatialRelationInfoToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofSpatialRelationInfos_OF_PUCCH_SpatialRelationInfoId */
static int hf_nr_rrc_spatialRelationInfoToReleaseList_item = -1;  /* PUCCH_SpatialRelationInfoId */
static int hf_nr_rrc_pucch_PowerControl = -1;     /* PUCCH_PowerControl */
static int hf_nr_rrc_resourceToAddModListExt_v1610 = -1;  /* SEQUENCE_SIZE_1_maxNrofPUCCH_Resources_OF_PUCCH_ResourceExt_v1610 */
static int hf_nr_rrc_resourceToAddModListExt_v1610_item = -1;  /* PUCCH_ResourceExt_v1610 */
static int hf_nr_rrc_dl_DataToUL_ACK_r16 = -1;    /* T_dl_DataToUL_ACK_r16 */
static int hf_nr_rrc_setup_78 = -1;               /* DL_DataToUL_ACK_r16 */
static int hf_nr_rrc_ul_AccessConfigListDCI_1_1_r16 = -1;  /* T_ul_AccessConfigListDCI_1_1_r16 */
static int hf_nr_rrc_setup_79 = -1;               /* UL_AccessConfigListDCI_1_1_r16 */
static int hf_nr_rrc_subslotLengthForPUCCH_r16 = -1;  /* T_subslotLengthForPUCCH_r16 */
static int hf_nr_rrc_normalCP_r16 = -1;           /* T_normalCP_r16 */
static int hf_nr_rrc_extendedCP_r16 = -1;         /* T_extendedCP_r16 */
static int hf_nr_rrc_dl_DataToUL_ACK_DCI_1_2_r16 = -1;  /* T_dl_DataToUL_ACK_DCI_1_2_r16 */
static int hf_nr_rrc_setup_80 = -1;               /* DL_DataToUL_ACK_DCI_1_2_r16 */
static int hf_nr_rrc_numberOfBitsForPUCCH_ResourceIndicatorDCI_1_2_r16 = -1;  /* INTEGER_0_3 */
static int hf_nr_rrc_dmrs_UplinkTransformPrecodingPUCCH_r16 = -1;  /* T_dmrs_UplinkTransformPrecodingPUCCH_r16 */
static int hf_nr_rrc_spatialRelationInfoToAddModListSizeExt_v1610 = -1;  /* SEQUENCE_SIZE_1_maxNrofSpatialRelationInfosDiff_r16_OF_PUCCH_SpatialRelationInfo */
static int hf_nr_rrc_spatialRelationInfoToAddModListSizeExt_v1610_item = -1;  /* PUCCH_SpatialRelationInfo */
static int hf_nr_rrc_spatialRelationInfoToReleaseListSizeExt_v1610 = -1;  /* SEQUENCE_SIZE_1_maxNrofSpatialRelationInfosDiff_r16_OF_PUCCH_SpatialRelationInfoId */
static int hf_nr_rrc_spatialRelationInfoToReleaseListSizeExt_v1610_item = -1;  /* PUCCH_SpatialRelationInfoId */
static int hf_nr_rrc_spatialRelationInfoToAddModListExt_v1610 = -1;  /* SEQUENCE_SIZE_1_maxNrofSpatialRelationInfos_r16_OF_PUCCH_SpatialRelationInfoExt_r16 */
static int hf_nr_rrc_spatialRelationInfoToAddModListExt_v1610_item = -1;  /* PUCCH_SpatialRelationInfoExt_r16 */
static int hf_nr_rrc_spatialRelationInfoToReleaseListExt_v1610 = -1;  /* SEQUENCE_SIZE_1_maxNrofSpatialRelationInfos_r16_OF_PUCCH_SpatialRelationInfoId_r16 */
static int hf_nr_rrc_spatialRelationInfoToReleaseListExt_v1610_item = -1;  /* PUCCH_SpatialRelationInfoId_r16 */
static int hf_nr_rrc_resourceGroupToAddModList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofPUCCH_ResourceGroups_r16_OF_PUCCH_ResourceGroup_r16 */
static int hf_nr_rrc_resourceGroupToAddModList_r16_item = -1;  /* PUCCH_ResourceGroup_r16 */
static int hf_nr_rrc_resourceGroupToReleaseList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofPUCCH_ResourceGroups_r16_OF_PUCCH_ResourceGroupId_r16 */
static int hf_nr_rrc_resourceGroupToReleaseList_r16_item = -1;  /* PUCCH_ResourceGroupId_r16 */
static int hf_nr_rrc_sps_PUCCH_AN_List_r16 = -1;  /* T_sps_PUCCH_AN_List_r16 */
static int hf_nr_rrc_setup_81 = -1;               /* SPS_PUCCH_AN_List_r16 */
static int hf_nr_rrc_schedulingRequestResourceToAddModListExt_v1610 = -1;  /* SEQUENCE_SIZE_1_maxNrofSR_Resources_OF_SchedulingRequestResourceConfigExt_v1610 */
static int hf_nr_rrc_schedulingRequestResourceToAddModListExt_v1610_item = -1;  /* SchedulingRequestResourceConfigExt_v1610 */
static int hf_nr_rrc_interslotFrequencyHopping = -1;  /* T_interslotFrequencyHopping */
static int hf_nr_rrc_additionalDMRS = -1;         /* T_additionalDMRS */
static int hf_nr_rrc_maxCodeRate = -1;            /* PUCCH_MaxCodeRate */
static int hf_nr_rrc_nrofSlots = -1;              /* T_nrofSlots */
static int hf_nr_rrc_pi2BPSK = -1;                /* T_pi2BPSK */
static int hf_nr_rrc_simultaneousHARQ_ACK_CSI = -1;  /* T_simultaneousHARQ_ACK_CSI */
static int hf_nr_rrc_pucch_ResourceSetId = -1;    /* PUCCH_ResourceSetId */
static int hf_nr_rrc_resourceList = -1;           /* SEQUENCE_SIZE_1_maxNrofPUCCH_ResourcesPerSet_OF_PUCCH_ResourceId */
static int hf_nr_rrc_resourceList_item = -1;      /* PUCCH_ResourceId */
static int hf_nr_rrc_maxPayloadSize = -1;         /* INTEGER_4_256 */
static int hf_nr_rrc_pucch_ResourceId = -1;       /* PUCCH_ResourceId */
static int hf_nr_rrc_startingPRB = -1;            /* PRB_Id */
static int hf_nr_rrc_intraSlotFrequencyHopping = -1;  /* T_intraSlotFrequencyHopping */
static int hf_nr_rrc_secondHopPRB = -1;           /* PRB_Id */
static int hf_nr_rrc_format = -1;                 /* T_format */
static int hf_nr_rrc_format0 = -1;                /* PUCCH_format0 */
static int hf_nr_rrc_format1_01 = -1;             /* PUCCH_format1 */
static int hf_nr_rrc_format2_01 = -1;             /* PUCCH_format2 */
static int hf_nr_rrc_format3_01 = -1;             /* PUCCH_format3 */
static int hf_nr_rrc_format4_01 = -1;             /* PUCCH_format4 */
static int hf_nr_rrc_interlaceAllocation_r16 = -1;  /* T_interlaceAllocation_r16 */
static int hf_nr_rrc_rb_SetIndex = -1;            /* INTEGER_0_4 */
static int hf_nr_rrc_interlace0 = -1;             /* T_interlace0 */
static int hf_nr_rrc_scs15 = -1;                  /* INTEGER_0_9 */
static int hf_nr_rrc_scs30 = -1;                  /* INTEGER_0_4 */
static int hf_nr_rrc_format_v1610 = -1;           /* T_format_v1610 */
static int hf_nr_rrc_interlace1_v1610 = -1;       /* INTEGER_0_9 */
static int hf_nr_rrc_occ_v1610 = -1;              /* T_occ_v1610 */
static int hf_nr_rrc_occ_Length_v1610 = -1;       /* T_occ_Length_v1610 */
static int hf_nr_rrc_occ_Index_v1610 = -1;        /* T_occ_Index_v1610 */
static int hf_nr_rrc_initialCyclicShift = -1;     /* INTEGER_0_11 */
static int hf_nr_rrc_nrofSymbols = -1;            /* INTEGER_1_2 */
static int hf_nr_rrc_startingSymbolIndex = -1;    /* INTEGER_0_13 */
static int hf_nr_rrc_nrofSymbols_01 = -1;         /* INTEGER_4_14 */
static int hf_nr_rrc_startingSymbolIndex_01 = -1;  /* INTEGER_0_10 */
static int hf_nr_rrc_timeDomainOCC = -1;          /* INTEGER_0_6 */
static int hf_nr_rrc_nrofPRBs_01 = -1;            /* INTEGER_1_16 */
static int hf_nr_rrc_occ_Length = -1;             /* T_occ_Length */
static int hf_nr_rrc_occ_Index = -1;              /* T_occ_Index */
static int hf_nr_rrc_pucch_ResourceGroupId_r16 = -1;  /* PUCCH_ResourceGroupId_r16 */
static int hf_nr_rrc_resourcePerGroupList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofPUCCH_ResourcesPerGroup_r16_OF_PUCCH_ResourceId */
static int hf_nr_rrc_resourcePerGroupList_r16_item = -1;  /* PUCCH_ResourceId */
static int hf_nr_rrc_DL_DataToUL_ACK_r16_item = -1;  /* INTEGER_M1_15 */
static int hf_nr_rrc_DL_DataToUL_ACK_DCI_1_2_r16_item = -1;  /* INTEGER_0_15 */
static int hf_nr_rrc_UL_AccessConfigListDCI_1_1_r16_item = -1;  /* INTEGER_0_15 */
static int hf_nr_rrc_pucch_ResourceCommon = -1;   /* INTEGER_0_15 */
static int hf_nr_rrc_pucch_GroupHopping = -1;     /* T_pucch_GroupHopping */
static int hf_nr_rrc_hoppingId = -1;              /* INTEGER_0_1023 */
static int hf_nr_rrc_p0_nominal = -1;             /* INTEGER_M202_24 */
static int hf_nr_rrc_PUCCH_ConfigurationList_r16_item = -1;  /* PUCCH_Config */
static int hf_nr_rrc_deltaF_PUCCH_f0 = -1;        /* INTEGER_M16_15 */
static int hf_nr_rrc_deltaF_PUCCH_f1 = -1;        /* INTEGER_M16_15 */
static int hf_nr_rrc_deltaF_PUCCH_f2 = -1;        /* INTEGER_M16_15 */
static int hf_nr_rrc_deltaF_PUCCH_f3 = -1;        /* INTEGER_M16_15 */
static int hf_nr_rrc_deltaF_PUCCH_f4 = -1;        /* INTEGER_M16_15 */
static int hf_nr_rrc_p0_Set = -1;                 /* SEQUENCE_SIZE_1_maxNrofPUCCH_P0_PerSet_OF_P0_PUCCH */
static int hf_nr_rrc_p0_Set_item = -1;            /* P0_PUCCH */
static int hf_nr_rrc_pathlossReferenceRSs = -1;   /* SEQUENCE_SIZE_1_maxNrofPUCCH_PathlossReferenceRSs_OF_PUCCH_PathlossReferenceRS */
static int hf_nr_rrc_pathlossReferenceRSs_item = -1;  /* PUCCH_PathlossReferenceRS */
static int hf_nr_rrc_twoPUCCH_PC_AdjustmentStates = -1;  /* T_twoPUCCH_PC_AdjustmentStates */
static int hf_nr_rrc_pathlossReferenceRSs_v1610 = -1;  /* T_pathlossReferenceRSs_v1610 */
static int hf_nr_rrc_setup_82 = -1;               /* PathlossReferenceRSs_v1610 */
static int hf_nr_rrc_p0_PUCCH_Id = -1;            /* P0_PUCCH_Id */
static int hf_nr_rrc_p0_PUCCH_Value = -1;         /* INTEGER_M16_15 */
static int hf_nr_rrc_PathlossReferenceRSs_v1610_item = -1;  /* PUCCH_PathlossReferenceRS_r16 */
static int hf_nr_rrc_pucch_PathlossReferenceRS_Id = -1;  /* PUCCH_PathlossReferenceRS_Id */
static int hf_nr_rrc_referenceSignal = -1;        /* T_referenceSignal */
static int hf_nr_rrc_csi_RS_Index_01 = -1;        /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_pucch_PathlossReferenceRS_Id_r16 = -1;  /* PUCCH_PathlossReferenceRS_Id_v1610 */
static int hf_nr_rrc_referenceSignal_r16 = -1;    /* T_referenceSignal_r16 */
static int hf_nr_rrc_csi_RS_Index_r16_01 = -1;    /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_pucch_SpatialRelationInfoId = -1;  /* PUCCH_SpatialRelationInfoId */
static int hf_nr_rrc_referenceSignal_01 = -1;     /* T_referenceSignal_01 */
static int hf_nr_rrc_srs = -1;                    /* PUCCH_SRS */
static int hf_nr_rrc_closedLoopIndex = -1;        /* T_closedLoopIndex */
static int hf_nr_rrc_pucch_SpatialRelationInfoId_v1610 = -1;  /* PUCCH_SpatialRelationInfoId_v1610 */
static int hf_nr_rrc_pucch_PathlossReferenceRS_Id_v1610 = -1;  /* PUCCH_PathlossReferenceRS_Id_v1610 */
static int hf_nr_rrc_resource = -1;               /* SRS_ResourceId */
static int hf_nr_rrc_uplinkBWP = -1;              /* BWP_Id */
static int hf_nr_rrc_tpc_IndexPCell = -1;         /* INTEGER_1_15 */
static int hf_nr_rrc_tpc_IndexPUCCH_SCell = -1;   /* INTEGER_1_15 */
static int hf_nr_rrc_dataScramblingIdentityPUSCH = -1;  /* INTEGER_0_1023 */
static int hf_nr_rrc_txConfig = -1;               /* T_txConfig */
static int hf_nr_rrc_dmrs_UplinkForPUSCH_MappingTypeA = -1;  /* T_dmrs_UplinkForPUSCH_MappingTypeA */
static int hf_nr_rrc_setup_83 = -1;               /* DMRS_UplinkConfig */
static int hf_nr_rrc_dmrs_UplinkForPUSCH_MappingTypeB = -1;  /* T_dmrs_UplinkForPUSCH_MappingTypeB */
static int hf_nr_rrc_pusch_PowerControl = -1;     /* PUSCH_PowerControl */
static int hf_nr_rrc_frequencyHopping_01 = -1;    /* T_frequencyHopping_01 */
static int hf_nr_rrc_frequencyHoppingOffsetLists = -1;  /* T_frequencyHoppingOffsetLists */
static int hf_nr_rrc_frequencyHoppingOffsetLists_item = -1;  /* INTEGER_1_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_resourceAllocation_02 = -1;  /* T_resourceAllocation_02 */
static int hf_nr_rrc_pusch_TimeDomainAllocationList = -1;  /* T_pusch_TimeDomainAllocationList */
static int hf_nr_rrc_setup_84 = -1;               /* PUSCH_TimeDomainResourceAllocationList */
static int hf_nr_rrc_pusch_AggregationFactor = -1;  /* T_pusch_AggregationFactor */
static int hf_nr_rrc_mcs_Table_02 = -1;           /* T_mcs_Table_02 */
static int hf_nr_rrc_mcs_TableTransformPrecoder_01 = -1;  /* T_mcs_TableTransformPrecoder_01 */
static int hf_nr_rrc_transformPrecoder_01 = -1;   /* T_transformPrecoder_01 */
static int hf_nr_rrc_codebookSubset = -1;         /* T_codebookSubset */
static int hf_nr_rrc_maxRank = -1;                /* INTEGER_1_4 */
static int hf_nr_rrc_rbg_Size_02 = -1;            /* T_rbg_Size_02 */
static int hf_nr_rrc_uci_OnPUSCH_01 = -1;         /* T_uci_OnPUSCH_01 */
static int hf_nr_rrc_setup_85 = -1;               /* UCI_OnPUSCH */
static int hf_nr_rrc_tp_pi2BPSK = -1;             /* T_tp_pi2BPSK */
static int hf_nr_rrc_minimumSchedulingOffsetK2_r16 = -1;  /* T_minimumSchedulingOffsetK2_r16 */
static int hf_nr_rrc_setup_86 = -1;               /* MinSchedulingOffsetK2_Values_r16 */
static int hf_nr_rrc_ul_AccessConfigListDCI_0_1_r16 = -1;  /* T_ul_AccessConfigListDCI_0_1_r16 */
static int hf_nr_rrc_setup_87 = -1;               /* UL_AccessConfigListDCI_0_1_r16 */
static int hf_nr_rrc_harq_ProcessNumberSizeDCI_0_2_r16 = -1;  /* INTEGER_0_4 */
static int hf_nr_rrc_dmrs_SequenceInitializationDCI_0_2_r16 = -1;  /* T_dmrs_SequenceInitializationDCI_0_2_r16 */
static int hf_nr_rrc_numberOfBitsForRV_DCI_0_2_r16 = -1;  /* INTEGER_0_2 */
static int hf_nr_rrc_antennaPortsFieldPresenceDCI_0_2_r16 = -1;  /* T_antennaPortsFieldPresenceDCI_0_2_r16 */
static int hf_nr_rrc_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16 = -1;  /* T_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16 */
static int hf_nr_rrc_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16 = -1;  /* T_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16 */
static int hf_nr_rrc_frequencyHoppingDCI_0_2_r16 = -1;  /* T_frequencyHoppingDCI_0_2_r16 */
static int hf_nr_rrc_pusch_RepTypeA = -1;         /* T_pusch_RepTypeA */
static int hf_nr_rrc_pusch_RepTypeB = -1;         /* T_pusch_RepTypeB */
static int hf_nr_rrc_frequencyHoppingOffsetListsDCI_0_2_r16 = -1;  /* T_frequencyHoppingOffsetListsDCI_0_2_r16 */
static int hf_nr_rrc_setup_88 = -1;               /* FrequencyHoppingOffsetListsDCI_0_2_r16 */
static int hf_nr_rrc_codebookSubsetDCI_0_2_r16 = -1;  /* T_codebookSubsetDCI_0_2_r16 */
static int hf_nr_rrc_invalidSymbolPatternIndicatorDCI_0_2_r16 = -1;  /* T_invalidSymbolPatternIndicatorDCI_0_2_r16 */
static int hf_nr_rrc_maxRankDCI_0_2_r16 = -1;     /* INTEGER_1_4 */
static int hf_nr_rrc_mcs_TableDCI_0_2_r16 = -1;   /* T_mcs_TableDCI_0_2_r16 */
static int hf_nr_rrc_mcs_TableTransformPrecoderDCI_0_2_r16 = -1;  /* T_mcs_TableTransformPrecoderDCI_0_2_r16 */
static int hf_nr_rrc_priorityIndicatorDCI_0_2_r16 = -1;  /* T_priorityIndicatorDCI_0_2_r16 */
static int hf_nr_rrc_pusch_RepTypeIndicatorDCI_0_2_r16 = -1;  /* T_pusch_RepTypeIndicatorDCI_0_2_r16 */
static int hf_nr_rrc_resourceAllocationDCI_0_2_r16 = -1;  /* T_resourceAllocationDCI_0_2_r16 */
static int hf_nr_rrc_resourceAllocationType1GranularityDCI_0_2_r16 = -1;  /* T_resourceAllocationType1GranularityDCI_0_2_r16 */
static int hf_nr_rrc_uci_OnPUSCH_ListDCI_0_2_r16 = -1;  /* T_uci_OnPUSCH_ListDCI_0_2_r16 */
static int hf_nr_rrc_setup_89 = -1;               /* UCI_OnPUSCH_ListDCI_0_2_r16 */
static int hf_nr_rrc_pusch_TimeDomainAllocationListDCI_0_2_r16 = -1;  /* T_pusch_TimeDomainAllocationListDCI_0_2_r16 */
static int hf_nr_rrc_setup_90 = -1;               /* PUSCH_TimeDomainResourceAllocationList_r16 */
static int hf_nr_rrc_pusch_TimeDomainAllocationListDCI_0_1_r16 = -1;  /* T_pusch_TimeDomainAllocationListDCI_0_1_r16 */
static int hf_nr_rrc_invalidSymbolPatternIndicatorDCI_0_1_r16 = -1;  /* T_invalidSymbolPatternIndicatorDCI_0_1_r16 */
static int hf_nr_rrc_priorityIndicatorDCI_0_1_r16 = -1;  /* T_priorityIndicatorDCI_0_1_r16 */
static int hf_nr_rrc_pusch_RepTypeIndicatorDCI_0_1_r16 = -1;  /* T_pusch_RepTypeIndicatorDCI_0_1_r16 */
static int hf_nr_rrc_frequencyHoppingDCI_0_1_r16 = -1;  /* T_frequencyHoppingDCI_0_1_r16 */
static int hf_nr_rrc_uci_OnPUSCH_ListDCI_0_1_r16 = -1;  /* T_uci_OnPUSCH_ListDCI_0_1_r16 */
static int hf_nr_rrc_setup_91 = -1;               /* UCI_OnPUSCH_ListDCI_0_1_r16 */
static int hf_nr_rrc_invalidSymbolPattern_r16 = -1;  /* InvalidSymbolPattern_r16 */
static int hf_nr_rrc_pusch_PowerControl_v1610 = -1;  /* T_pusch_PowerControl_v1610 */
static int hf_nr_rrc_setup_92 = -1;               /* PUSCH_PowerControl_v1610 */
static int hf_nr_rrc_ul_FullPowerTransmission_r16 = -1;  /* T_ul_FullPowerTransmission_r16 */
static int hf_nr_rrc_pusch_TimeDomainAllocationListForMultiPUSCH_r16 = -1;  /* T_pusch_TimeDomainAllocationListForMultiPUSCH_r16 */
static int hf_nr_rrc_numberOfInvalidSymbolsForDL_UL_Switching_r16 = -1;  /* INTEGER_1_4 */
static int hf_nr_rrc_betaOffsets = -1;            /* T_betaOffsets */
static int hf_nr_rrc_dynamic_01 = -1;             /* SEQUENCE_SIZE_4_OF_BetaOffsets */
static int hf_nr_rrc_scaling = -1;                /* T_scaling */
static int hf_nr_rrc_MinSchedulingOffsetK2_Values_r16_item = -1;  /* INTEGER_0_maxK2_SchedulingOffset_r16 */
static int hf_nr_rrc_betaOffsetsDCI_0_2_r16 = -1;  /* T_betaOffsetsDCI_0_2_r16 */
static int hf_nr_rrc_dynamicDCI_0_2_r16 = -1;     /* T_dynamicDCI_0_2_r16 */
static int hf_nr_rrc_oneBit_r16 = -1;             /* SEQUENCE_SIZE_2_OF_BetaOffsets */
static int hf_nr_rrc_oneBit_r16_item = -1;        /* BetaOffsets */
static int hf_nr_rrc_twoBits_r16 = -1;            /* SEQUENCE_SIZE_4_OF_BetaOffsets */
static int hf_nr_rrc_twoBits_r16_item = -1;       /* BetaOffsets */
static int hf_nr_rrc_semiStaticDCI_0_2_r16 = -1;  /* BetaOffsets */
static int hf_nr_rrc_scalingDCI_0_2_r16 = -1;     /* T_scalingDCI_0_2_r16 */
static int hf_nr_rrc_FrequencyHoppingOffsetListsDCI_0_2_r16_item = -1;  /* INTEGER_1_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_UCI_OnPUSCH_ListDCI_0_2_r16_item = -1;  /* UCI_OnPUSCH_DCI_0_2_r16 */
static int hf_nr_rrc_UCI_OnPUSCH_ListDCI_0_1_r16_item = -1;  /* UCI_OnPUSCH */
static int hf_nr_rrc_UL_AccessConfigListDCI_0_1_r16_item = -1;  /* INTEGER_0_63 */
static int hf_nr_rrc_groupHoppingEnabledTransformPrecoding = -1;  /* T_groupHoppingEnabledTransformPrecoding */
static int hf_nr_rrc_pusch_TimeDomainAllocationList_01 = -1;  /* PUSCH_TimeDomainResourceAllocationList */
static int hf_nr_rrc_msg3_DeltaPreamble = -1;     /* INTEGER_M1_6 */
static int hf_nr_rrc_p0_NominalWithGrant = -1;    /* INTEGER_M202_24 */
static int hf_nr_rrc_tpc_Accumulation = -1;       /* T_tpc_Accumulation */
static int hf_nr_rrc_msg3_Alpha = -1;             /* Alpha */
static int hf_nr_rrc_p0_NominalWithoutGrant = -1;  /* INTEGER_M202_24 */
static int hf_nr_rrc_p0_AlphaSets = -1;           /* SEQUENCE_SIZE_1_maxNrofP0_PUSCH_AlphaSets_OF_P0_PUSCH_AlphaSet */
static int hf_nr_rrc_p0_AlphaSets_item = -1;      /* P0_PUSCH_AlphaSet */
static int hf_nr_rrc_pathlossReferenceRSToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofPUSCH_PathlossReferenceRSs_OF_PUSCH_PathlossReferenceRS */
static int hf_nr_rrc_pathlossReferenceRSToAddModList_item = -1;  /* PUSCH_PathlossReferenceRS */
static int hf_nr_rrc_pathlossReferenceRSToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofPUSCH_PathlossReferenceRSs_OF_PUSCH_PathlossReferenceRS_Id */
static int hf_nr_rrc_pathlossReferenceRSToReleaseList_item = -1;  /* PUSCH_PathlossReferenceRS_Id */
static int hf_nr_rrc_twoPUSCH_PC_AdjustmentStates = -1;  /* T_twoPUSCH_PC_AdjustmentStates */
static int hf_nr_rrc_deltaMCS = -1;               /* T_deltaMCS */
static int hf_nr_rrc_sri_PUSCH_MappingToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofSRI_PUSCH_Mappings_OF_SRI_PUSCH_PowerControl */
static int hf_nr_rrc_sri_PUSCH_MappingToAddModList_item = -1;  /* SRI_PUSCH_PowerControl */
static int hf_nr_rrc_sri_PUSCH_MappingToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofSRI_PUSCH_Mappings_OF_SRI_PUSCH_PowerControlId */
static int hf_nr_rrc_sri_PUSCH_MappingToReleaseList_item = -1;  /* SRI_PUSCH_PowerControlId */
static int hf_nr_rrc_p0_PUSCH_AlphaSetId = -1;    /* P0_PUSCH_AlphaSetId */
static int hf_nr_rrc_p0 = -1;                     /* INTEGER_M16_15 */
static int hf_nr_rrc_alpha = -1;                  /* Alpha */
static int hf_nr_rrc_pusch_PathlossReferenceRS_Id = -1;  /* PUSCH_PathlossReferenceRS_Id */
static int hf_nr_rrc_referenceSignal_02 = -1;     /* T_referenceSignal_02 */
static int hf_nr_rrc_pusch_PathlossReferenceRS_Id_r16 = -1;  /* PUSCH_PathlossReferenceRS_Id_v1610 */
static int hf_nr_rrc_referenceSignal_r16_01 = -1;  /* T_referenceSignal_r16_01 */
static int hf_nr_rrc_sri_PUSCH_PowerControlId = -1;  /* SRI_PUSCH_PowerControlId */
static int hf_nr_rrc_sri_PUSCH_PathlossReferenceRS_Id = -1;  /* PUSCH_PathlossReferenceRS_Id */
static int hf_nr_rrc_sri_P0_PUSCH_AlphaSetId = -1;  /* P0_PUSCH_AlphaSetId */
static int hf_nr_rrc_sri_PUSCH_ClosedLoopIndex = -1;  /* T_sri_PUSCH_ClosedLoopIndex */
static int hf_nr_rrc_pathlossReferenceRSToAddModListSizeExt_v1610 = -1;  /* SEQUENCE_SIZE_1_maxNrofPUSCH_PathlossReferenceRSsDiff_r16_OF_PUSCH_PathlossReferenceRS_r16 */
static int hf_nr_rrc_pathlossReferenceRSToAddModListSizeExt_v1610_item = -1;  /* PUSCH_PathlossReferenceRS_r16 */
static int hf_nr_rrc_pathlossReferenceRSToReleaseListSizeExt_v1610 = -1;  /* SEQUENCE_SIZE_1_maxNrofPUSCH_PathlossReferenceRSsDiff_r16_OF_PUSCH_PathlossReferenceRS_Id_v1610 */
static int hf_nr_rrc_pathlossReferenceRSToReleaseListSizeExt_v1610_item = -1;  /* PUSCH_PathlossReferenceRS_Id_v1610 */
static int hf_nr_rrc_p0_PUSCH_SetList_r16 = -1;   /* SEQUENCE_SIZE_1_maxNrofSRI_PUSCH_Mappings_OF_P0_PUSCH_Set_r16 */
static int hf_nr_rrc_p0_PUSCH_SetList_r16_item = -1;  /* P0_PUSCH_Set_r16 */
static int hf_nr_rrc_olpc_ParameterSet = -1;      /* T_olpc_ParameterSet */
static int hf_nr_rrc_olpc_ParameterSetDCI_0_1_r16 = -1;  /* INTEGER_1_2 */
static int hf_nr_rrc_olpc_ParameterSetDCI_0_2_r16 = -1;  /* INTEGER_1_2 */
static int hf_nr_rrc_p0_PUSCH_SetId_r16 = -1;     /* P0_PUSCH_SetId_r16 */
static int hf_nr_rrc_p0_List_r16 = -1;            /* SEQUENCE_SIZE_1_maxNrofP0_PUSCH_Set_r16_OF_P0_PUSCH_r16 */
static int hf_nr_rrc_p0_List_r16_item = -1;       /* P0_PUSCH_r16 */
static int hf_nr_rrc_codeBlockGroupTransmission_01 = -1;  /* T_codeBlockGroupTransmission_01 */
static int hf_nr_rrc_setup_93 = -1;               /* PUSCH_CodeBlockGroupTransmission */
static int hf_nr_rrc_rateMatching = -1;           /* T_rateMatching */
static int hf_nr_rrc_xOverhead_01 = -1;           /* T_xOverhead_01 */
static int hf_nr_rrc_maxMIMO_Layers_01 = -1;      /* INTEGER_1_4 */
static int hf_nr_rrc_maxMIMO_LayersDCI_0_2_r16 = -1;  /* T_maxMIMO_LayersDCI_0_2_r16 */
static int hf_nr_rrc_setup_94 = -1;               /* MaxMIMO_LayersDCI_0_2_r16 */
static int hf_nr_rrc_maxCodeBlockGroupsPerTransportBlock_01 = -1;  /* T_maxCodeBlockGroupsPerTransportBlock_01 */
static int hf_nr_rrc_PUSCH_TimeDomainResourceAllocationList_item = -1;  /* PUSCH_TimeDomainResourceAllocation */
static int hf_nr_rrc_k2 = -1;                     /* INTEGER_0_32 */
static int hf_nr_rrc_mappingType_01 = -1;         /* T_mappingType_01 */
static int hf_nr_rrc_PUSCH_TimeDomainResourceAllocationList_r16_item = -1;  /* PUSCH_TimeDomainResourceAllocation_r16 */
static int hf_nr_rrc_k2_r16 = -1;                 /* INTEGER_0_32 */
static int hf_nr_rrc_puschAllocationList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofMultiplePUSCHs_r16_OF_PUSCH_Allocation_r16 */
static int hf_nr_rrc_puschAllocationList_r16_item = -1;  /* PUSCH_Allocation_r16 */
static int hf_nr_rrc_mappingType_r16_01 = -1;     /* T_mappingType_r16_01 */
static int hf_nr_rrc_startSymbol_r16 = -1;        /* INTEGER_0_13 */
static int hf_nr_rrc_length_r16 = -1;             /* INTEGER_1_14 */
static int hf_nr_rrc_numberOfRepetitions_r16 = -1;  /* T_numberOfRepetitions_r16 */
static int hf_nr_rrc_tpc_Index = -1;              /* INTEGER_1_15 */
static int hf_nr_rrc_tpc_IndexSUL = -1;           /* INTEGER_1_15 */
static int hf_nr_rrc_targetCell = -1;             /* ServCellIndex */
static int hf_nr_rrc_quantityConfigNR_List = -1;  /* SEQUENCE_SIZE_1_maxNrofQuantityConfig_OF_QuantityConfigNR */
static int hf_nr_rrc_quantityConfigNR_List_item = -1;  /* QuantityConfigNR */
static int hf_nr_rrc_quantityConfigEUTRA = -1;    /* FilterConfig */
static int hf_nr_rrc_quantityConfigUTRA_FDD_r16 = -1;  /* QuantityConfigUTRA_FDD_r16 */
static int hf_nr_rrc_quantityConfigCLI_r16 = -1;  /* FilterConfigCLI_r16 */
static int hf_nr_rrc_quantityConfigCell = -1;     /* QuantityConfigRS */
static int hf_nr_rrc_quantityConfigRS_Index = -1;  /* QuantityConfigRS */
static int hf_nr_rrc_ssb_FilterConfig = -1;       /* FilterConfig */
static int hf_nr_rrc_csi_RS_FilterConfig = -1;    /* FilterConfig */
static int hf_nr_rrc_filterCoefficientRSRP = -1;  /* FilterCoefficient */
static int hf_nr_rrc_filterCoefficientRSRQ = -1;  /* FilterCoefficient */
static int hf_nr_rrc_filterCoefficientRS_SINR = -1;  /* FilterCoefficient */
static int hf_nr_rrc_filterCoefficientSRS_RSRP_r16 = -1;  /* FilterCoefficient */
static int hf_nr_rrc_filterCoefficientCLI_RSSI_r16 = -1;  /* FilterCoefficient */
static int hf_nr_rrc_filterCoefficientRSCP_r16 = -1;  /* FilterCoefficient */
static int hf_nr_rrc_filterCoefficientEcNO_r16 = -1;  /* FilterCoefficient */
static int hf_nr_rrc_rach_ConfigGeneric = -1;     /* RACH_ConfigGeneric */
static int hf_nr_rrc_totalNumberOfRA_Preambles = -1;  /* INTEGER_1_63 */
static int hf_nr_rrc_ssb_perRACH_OccasionAndCB_PreamblesPerSSB = -1;  /* T_ssb_perRACH_OccasionAndCB_PreamblesPerSSB */
static int hf_nr_rrc_oneEighth = -1;              /* T_oneEighth */
static int hf_nr_rrc_oneFourth = -1;              /* T_oneFourth */
static int hf_nr_rrc_oneHalf = -1;                /* T_oneHalf */
static int hf_nr_rrc_one_01 = -1;                 /* T_one */
static int hf_nr_rrc_two_01 = -1;                 /* T_two_01 */
static int hf_nr_rrc_four = -1;                   /* INTEGER_1_16 */
static int hf_nr_rrc_eight = -1;                  /* INTEGER_1_8 */
static int hf_nr_rrc_sixteen = -1;                /* INTEGER_1_4 */
static int hf_nr_rrc_groupBconfigured = -1;       /* T_groupBconfigured */
static int hf_nr_rrc_ra_Msg3SizeGroupA = -1;      /* T_ra_Msg3SizeGroupA */
static int hf_nr_rrc_messagePowerOffsetGroupB = -1;  /* T_messagePowerOffsetGroupB */
static int hf_nr_rrc_numberOfRA_PreamblesGroupA = -1;  /* INTEGER_1_64 */
static int hf_nr_rrc_ra_ContentionResolutionTimer = -1;  /* T_ra_ContentionResolutionTimer */
static int hf_nr_rrc_rsrp_ThresholdSSB_SUL = -1;  /* RSRP_Range */
static int hf_nr_rrc_prach_RootSequenceIndex = -1;  /* T_prach_RootSequenceIndex */
static int hf_nr_rrc_l839 = -1;                   /* INTEGER_0_837 */
static int hf_nr_rrc_l139 = -1;                   /* INTEGER_0_137 */
static int hf_nr_rrc_restrictedSetConfig = -1;    /* T_restrictedSetConfig */
static int hf_nr_rrc_msg3_transformPrecoder = -1;  /* T_msg3_transformPrecoder */
static int hf_nr_rrc_ra_PrioritizationForAccessIdentity_r16 = -1;  /* T_ra_PrioritizationForAccessIdentity_r16 */
static int hf_nr_rrc_ra_Prioritization_r16 = -1;  /* RA_Prioritization */
static int hf_nr_rrc_ra_PrioritizationForAI_r16 = -1;  /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_prach_RootSequenceIndex_r16 = -1;  /* T_prach_RootSequenceIndex_r16 */
static int hf_nr_rrc_l571 = -1;                   /* INTEGER_0_569 */
static int hf_nr_rrc_l1151 = -1;                  /* INTEGER_0_1149 */
static int hf_nr_rrc_rach_ConfigGenericTwoStepRA_r16 = -1;  /* RACH_ConfigGenericTwoStepRA_r16 */
static int hf_nr_rrc_msgA_TotalNumberOfRA_Preambles_r16 = -1;  /* INTEGER_1_63 */
static int hf_nr_rrc_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16 = -1;  /* T_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16 */
static int hf_nr_rrc_oneEighth_01 = -1;           /* T_oneEighth_01 */
static int hf_nr_rrc_oneFourth_01 = -1;           /* T_oneFourth_01 */
static int hf_nr_rrc_oneHalf_01 = -1;             /* T_oneHalf_01 */
static int hf_nr_rrc_one_02 = -1;                 /* T_one_01 */
static int hf_nr_rrc_two_02 = -1;                 /* T_two_02 */
static int hf_nr_rrc_msgA_CB_PreamblesPerSSB_PerSharedRO_r16 = -1;  /* INTEGER_1_60 */
static int hf_nr_rrc_msgA_SSB_SharedRO_MaskIndex_r16 = -1;  /* INTEGER_1_15 */
static int hf_nr_rrc_groupB_ConfiguredTwoStepRA_r16 = -1;  /* GroupB_ConfiguredTwoStepRA_r16 */
static int hf_nr_rrc_msgA_PRACH_RootSequenceIndex_r16 = -1;  /* T_msgA_PRACH_RootSequenceIndex_r16 */
static int hf_nr_rrc_msgA_TransMax_r16 = -1;      /* T_msgA_TransMax_r16 */
static int hf_nr_rrc_msgA_RSRP_Threshold_r16 = -1;  /* RSRP_Range */
static int hf_nr_rrc_msgA_RSRP_ThresholdSSB_r16 = -1;  /* RSRP_Range */
static int hf_nr_rrc_msgA_SubcarrierSpacing_r16 = -1;  /* SubcarrierSpacing */
static int hf_nr_rrc_msgA_RestrictedSetConfig_r16 = -1;  /* T_msgA_RestrictedSetConfig_r16 */
static int hf_nr_rrc_ra_PrioritizationForAccessIdentityTwoStep_r16 = -1;  /* T_ra_PrioritizationForAccessIdentityTwoStep_r16 */
static int hf_nr_rrc_ra_ContentionResolutionTimer_r16 = -1;  /* T_ra_ContentionResolutionTimer_r16 */
static int hf_nr_rrc_ra_MsgA_SizeGroupA = -1;     /* T_ra_MsgA_SizeGroupA */
static int hf_nr_rrc_messagePowerOffsetGroupB_01 = -1;  /* T_messagePowerOffsetGroupB_01 */
static int hf_nr_rrc_cfra = -1;                   /* CFRA */
static int hf_nr_rrc_cfra_TwoStep_r16 = -1;       /* CFRA_TwoStep_r16 */
static int hf_nr_rrc_occasions = -1;              /* T_occasions */
static int hf_nr_rrc_ssb_perRACH_Occasion_01 = -1;  /* T_ssb_perRACH_Occasion_01 */
static int hf_nr_rrc_resources = -1;              /* T_resources */
static int hf_nr_rrc_ssb_02 = -1;                 /* T_ssb */
static int hf_nr_rrc_ssb_ResourceList = -1;       /* SEQUENCE_SIZE_1_maxRA_SSB_Resources_OF_CFRA_SSB_Resource */
static int hf_nr_rrc_ssb_ResourceList_item = -1;  /* CFRA_SSB_Resource */
static int hf_nr_rrc_csirs = -1;                  /* T_csirs */
static int hf_nr_rrc_csirs_ResourceList = -1;     /* SEQUENCE_SIZE_1_maxRA_CSIRS_Resources_OF_CFRA_CSIRS_Resource */
static int hf_nr_rrc_csirs_ResourceList_item = -1;  /* CFRA_CSIRS_Resource */
static int hf_nr_rrc_rsrp_ThresholdCSI_RS = -1;   /* RSRP_Range */
static int hf_nr_rrc_occasionsTwoStepRA_r16 = -1;  /* T_occasionsTwoStepRA_r16 */
static int hf_nr_rrc_ssb_PerRACH_OccasionTwoStepRA_r16 = -1;  /* T_ssb_PerRACH_OccasionTwoStepRA_r16 */
static int hf_nr_rrc_msgA_CFRA_PUSCH_r16 = -1;    /* MsgA_PUSCH_Resource_r16 */
static int hf_nr_rrc_msgA_TransMax_r16_01 = -1;   /* T_msgA_TransMax_r16_01 */
static int hf_nr_rrc_resourcesTwoStep_r16 = -1;   /* T_resourcesTwoStep_r16 */
static int hf_nr_rrc_msgA_PUSCH_Resource_Index_r16 = -1;  /* INTEGER_0_3071 */
static int hf_nr_rrc_csi_RS_02 = -1;              /* CSI_RS_Index */
static int hf_nr_rrc_ra_OccasionList_01 = -1;     /* T_ra_OccasionList_01 */
static int hf_nr_rrc_prach_ConfigurationIndex = -1;  /* INTEGER_0_255 */
static int hf_nr_rrc_msg1_FDM = -1;               /* T_msg1_FDM */
static int hf_nr_rrc_msg1_FrequencyStart = -1;    /* INTEGER_0_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_zeroCorrelationZoneConfig = -1;  /* INTEGER_0_15 */
static int hf_nr_rrc_preambleReceivedTargetPower = -1;  /* INTEGER_M202_M60 */
static int hf_nr_rrc_preambleTransMax = -1;       /* T_preambleTransMax */
static int hf_nr_rrc_powerRampingStep = -1;       /* T_powerRampingStep */
static int hf_nr_rrc_ra_ResponseWindow = -1;      /* T_ra_ResponseWindow */
static int hf_nr_rrc_prach_ConfigurationPeriodScaling_IAB_r16 = -1;  /* T_prach_ConfigurationPeriodScaling_IAB_r16 */
static int hf_nr_rrc_prach_ConfigurationFrameOffset_IAB_r16 = -1;  /* INTEGER_0_63 */
static int hf_nr_rrc_prach_ConfigurationSOffset_IAB_r16 = -1;  /* INTEGER_0_39 */
static int hf_nr_rrc_ra_ResponseWindow_v1610 = -1;  /* T_ra_ResponseWindow_v1610 */
static int hf_nr_rrc_prach_ConfigurationIndex_v1610 = -1;  /* INTEGER_256_262 */
static int hf_nr_rrc_msgA_PRACH_ConfigurationIndex_r16 = -1;  /* INTEGER_0_262 */
static int hf_nr_rrc_msgA_RO_FDM_r16 = -1;        /* T_msgA_RO_FDM_r16 */
static int hf_nr_rrc_msgA_RO_FrequencyStart_r16 = -1;  /* INTEGER_0_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_msgA_ZeroCorrelationZoneConfig_r16 = -1;  /* INTEGER_0_15 */
static int hf_nr_rrc_msgA_PreamblePowerRampingStep_r16 = -1;  /* T_msgA_PreamblePowerRampingStep_r16 */
static int hf_nr_rrc_msgA_PreambleReceivedTargetPower_r16 = -1;  /* INTEGER_M202_M60 */
static int hf_nr_rrc_msgB_ResponseWindow_r16 = -1;  /* T_msgB_ResponseWindow_r16 */
static int hf_nr_rrc_preambleTransMax_r16 = -1;   /* T_preambleTransMax_r16 */
static int hf_nr_rrc_powerRampingStepHighPriority = -1;  /* T_powerRampingStepHighPriority */
static int hf_nr_rrc_scalingFactorBI = -1;        /* T_scalingFactorBI */
static int hf_nr_rrc_srb_ToAddModList = -1;       /* SRB_ToAddModList */
static int hf_nr_rrc_srb3_ToRelease = -1;         /* T_srb3_ToRelease */
static int hf_nr_rrc_drb_ToAddModList = -1;       /* DRB_ToAddModList */
static int hf_nr_rrc_drb_ToReleaseList = -1;      /* DRB_ToReleaseList */
static int hf_nr_rrc_securityConfig = -1;         /* SecurityConfig */
static int hf_nr_rrc_SRB_ToAddModList_item = -1;  /* SRB_ToAddMod */
static int hf_nr_rrc_srb_Identity = -1;           /* SRB_Identity */
static int hf_nr_rrc_reestablishPDCP = -1;        /* T_reestablishPDCP */
static int hf_nr_rrc_discardOnPDCP = -1;          /* T_discardOnPDCP */
static int hf_nr_rrc_pdcp_Config = -1;            /* PDCP_Config */
static int hf_nr_rrc_DRB_ToAddModList_item = -1;  /* DRB_ToAddMod */
static int hf_nr_rrc_cnAssociation = -1;          /* T_cnAssociation */
static int hf_nr_rrc_eps_BearerIdentity = -1;     /* INTEGER_0_15 */
static int hf_nr_rrc_sdap_Config = -1;            /* SDAP_Config */
static int hf_nr_rrc_reestablishPDCP_01 = -1;     /* T_reestablishPDCP_01 */
static int hf_nr_rrc_recoverPDCP = -1;            /* T_recoverPDCP */
static int hf_nr_rrc_daps_Config_r16 = -1;        /* T_daps_Config_r16 */
static int hf_nr_rrc_DRB_ToReleaseList_item = -1;  /* DRB_Identity */
static int hf_nr_rrc_keyToUse = -1;               /* T_keyToUse */
static int hf_nr_rrc_failureDetectionResourcesToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofFailureDetectionResources_OF_RadioLinkMonitoringRS */
static int hf_nr_rrc_failureDetectionResourcesToAddModList_item = -1;  /* RadioLinkMonitoringRS */
static int hf_nr_rrc_failureDetectionResourcesToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofFailureDetectionResources_OF_RadioLinkMonitoringRS_Id */
static int hf_nr_rrc_failureDetectionResourcesToReleaseList_item = -1;  /* RadioLinkMonitoringRS_Id */
static int hf_nr_rrc_beamFailureInstanceMaxCount = -1;  /* T_beamFailureInstanceMaxCount */
static int hf_nr_rrc_beamFailureDetectionTimer = -1;  /* T_beamFailureDetectionTimer */
static int hf_nr_rrc_radioLinkMonitoringRS_Id = -1;  /* RadioLinkMonitoringRS_Id */
static int hf_nr_rrc_purpose = -1;                /* T_purpose */
static int hf_nr_rrc_detectionResource = -1;      /* T_detectionResource */
static int hf_nr_rrc_rateMatchPatternId = -1;     /* RateMatchPatternId */
static int hf_nr_rrc_patternType = -1;            /* T_patternType */
static int hf_nr_rrc_bitmaps = -1;                /* T_bitmaps */
static int hf_nr_rrc_resourceBlocks = -1;         /* BIT_STRING_SIZE_275 */
static int hf_nr_rrc_symbolsInResourceBlock = -1;  /* T_symbolsInResourceBlock */
static int hf_nr_rrc_periodicityAndPattern = -1;  /* T_periodicityAndPattern */
static int hf_nr_rrc_controlResourceSet = -1;     /* ControlResourceSetId */
static int hf_nr_rrc_rateMatchPattern_dummy = -1;  /* T_rateMatchPattern_dummy */
static int hf_nr_rrc_controlResourceSet_r16 = -1;  /* ControlResourceSetId_r16 */
static int hf_nr_rrc_carrierFreqDL = -1;          /* INTEGER_0_16383 */
static int hf_nr_rrc_carrierBandwidthDL = -1;     /* T_carrierBandwidthDL */
static int hf_nr_rrc_mbsfn_SubframeConfigList = -1;  /* EUTRA_MBSFN_SubframeConfigList */
static int hf_nr_rrc_nrofCRS_Ports = -1;          /* T_nrofCRS_Ports */
static int hf_nr_rrc_v_Shift = -1;                /* T_v_Shift */
static int hf_nr_rrc_LTE_CRS_PatternList_r16_item = -1;  /* RateMatchPatternLTE_CRS */
static int hf_nr_rrc_time_r16 = -1;               /* ReferenceTime_r16 */
static int hf_nr_rrc_uncertainty_r16 = -1;        /* INTEGER_0_32767 */
static int hf_nr_rrc_timeInfoType_r16 = -1;       /* T_timeInfoType_r16 */
static int hf_nr_rrc_referenceSFN_r16 = -1;       /* INTEGER_0_1023 */
static int hf_nr_rrc_refDays_r16 = -1;            /* INTEGER_0_72999 */
static int hf_nr_rrc_refSeconds_r16 = -1;         /* INTEGER_0_86399 */
static int hf_nr_rrc_refMilliSeconds_r16 = -1;    /* INTEGER_0_999 */
static int hf_nr_rrc_refTenNanoSeconds_r16 = -1;  /* INTEGER_0_99999 */
static int hf_nr_rrc_fdm_TDM_r16 = -1;            /* T_fdm_TDM_r16 */
static int hf_nr_rrc_setup_95 = -1;               /* FDM_TDM_r16 */
static int hf_nr_rrc_slotBased_r16 = -1;          /* T_slotBased_r16 */
static int hf_nr_rrc_setup_96 = -1;               /* SlotBased_r16 */
static int hf_nr_rrc_slotBased_v1630 = -1;        /* T_slotBased_v1630 */
static int hf_nr_rrc_setup_97 = -1;               /* SlotBased_v1630 */
static int hf_nr_rrc_repetitionScheme_r16 = -1;   /* T_repetitionScheme_r16 */
static int hf_nr_rrc_startingSymbolOffsetK_r16 = -1;  /* INTEGER_0_7 */
static int hf_nr_rrc_tciMapping_r16 = -1;         /* T_tciMapping_r16 */
static int hf_nr_rrc_sequenceOffsetForRV_r16 = -1;  /* INTEGER_1_3 */
static int hf_nr_rrc_tciMapping_r16_01 = -1;      /* T_tciMapping_r16_01 */
static int hf_nr_rrc_sequenceOffsetForRV_r16_01 = -1;  /* INTEGER_0 */
static int hf_nr_rrc_reportType_01 = -1;          /* T_reportType_01 */
static int hf_nr_rrc_periodical_01 = -1;          /* PeriodicalReportConfigInterRAT */
static int hf_nr_rrc_eventTriggered_01 = -1;      /* EventTriggerConfigInterRAT */
static int hf_nr_rrc_reportCGI = -1;              /* ReportCGI_EUTRA */
static int hf_nr_rrc_reportSFTD = -1;             /* ReportSFTD_EUTRA */
static int hf_nr_rrc_cellForWhichToReportCGI_01 = -1;  /* EUTRA_PhysCellId */
static int hf_nr_rrc_useAutonomousGaps_r16 = -1;  /* T_useAutonomousGaps_r16 */
static int hf_nr_rrc_reportSFTD_Meas = -1;        /* BOOLEAN */
static int hf_nr_rrc_reportRSRP = -1;             /* BOOLEAN */
static int hf_nr_rrc_eventId = -1;                /* T_eventId */
static int hf_nr_rrc_eventB1 = -1;                /* T_eventB1 */
static int hf_nr_rrc_b1_ThresholdEUTRA = -1;      /* MeasTriggerQuantityEUTRA */
static int hf_nr_rrc_reportOnLeave = -1;          /* BOOLEAN */
static int hf_nr_rrc_eventB2 = -1;                /* T_eventB2 */
static int hf_nr_rrc_b2_Threshold1 = -1;          /* MeasTriggerQuantity */
static int hf_nr_rrc_b2_Threshold2EUTRA = -1;     /* MeasTriggerQuantityEUTRA */
static int hf_nr_rrc_eventB1_UTRA_FDD_r16 = -1;   /* T_eventB1_UTRA_FDD_r16 */
static int hf_nr_rrc_b1_ThresholdUTRA_FDD_r16 = -1;  /* MeasTriggerQuantityUTRA_FDD_r16 */
static int hf_nr_rrc_reportOnLeave_r16 = -1;      /* BOOLEAN */
static int hf_nr_rrc_hysteresis_r16 = -1;         /* Hysteresis */
static int hf_nr_rrc_timeToTrigger_r16 = -1;      /* TimeToTrigger */
static int hf_nr_rrc_eventB2_UTRA_FDD_r16 = -1;   /* T_eventB2_UTRA_FDD_r16 */
static int hf_nr_rrc_b2_Threshold1_r16 = -1;      /* MeasTriggerQuantity */
static int hf_nr_rrc_b2_Threshold2UTRA_FDD_r16 = -1;  /* MeasTriggerQuantityUTRA_FDD_r16 */
static int hf_nr_rrc_rsType = -1;                 /* NR_RS_Type */
static int hf_nr_rrc_reportInterval = -1;         /* ReportInterval */
static int hf_nr_rrc_reportAmount = -1;           /* T_reportAmount */
static int hf_nr_rrc_reportQuantity_01 = -1;      /* MeasReportQuantity */
static int hf_nr_rrc_maxReportCells = -1;         /* INTEGER_1_maxCellReport */
static int hf_nr_rrc_reportQuantityUTRA_FDD_r16 = -1;  /* MeasReportQuantityUTRA_FDD_r16 */
static int hf_nr_rrc_includeCommonLocationInfo_r16 = -1;  /* T_includeCommonLocationInfo_r16 */
static int hf_nr_rrc_includeBT_Meas_r16 = -1;     /* T_includeBT_Meas_r16 */
static int hf_nr_rrc_includeWLAN_Meas_r16 = -1;   /* T_includeWLAN_Meas_r16 */
static int hf_nr_rrc_includeSensor_Meas_r16 = -1;  /* T_includeSensor_Meas_r16 */
static int hf_nr_rrc_reportAmount_01 = -1;        /* T_reportAmount_01 */
static int hf_nr_rrc_includeCommonLocationInfo_r16_01 = -1;  /* T_includeCommonLocationInfo_r16_01 */
static int hf_nr_rrc_includeBT_Meas_r16_01 = -1;  /* T_includeBT_Meas_r16_01 */
static int hf_nr_rrc_includeWLAN_Meas_r16_01 = -1;  /* T_includeWLAN_Meas_r16_01 */
static int hf_nr_rrc_includeSensor_Meas_r16_01 = -1;  /* T_includeSensor_Meas_r16_01 */
static int hf_nr_rrc_utra_FDD_RSCP_r16_01 = -1;   /* MeasTriggerQuantityUTRA_FDD_RSCP_r16 */
static int hf_nr_rrc_utra_FDD_EcN0_r16_01 = -1;   /* MeasTriggerQuantityUTRA_FDD_EcN0_r16 */
static int hf_nr_rrc_cpich_RSCP = -1;             /* BOOLEAN */
static int hf_nr_rrc_cpich_EcN0 = -1;             /* BOOLEAN */
static int hf_nr_rrc_reportType_02 = -1;          /* T_reportType_02 */
static int hf_nr_rrc_periodical_02 = -1;          /* PeriodicalReportConfig */
static int hf_nr_rrc_eventTriggered_02 = -1;      /* EventTriggerConfig */
static int hf_nr_rrc_reportCGI_01 = -1;           /* ReportCGI */
static int hf_nr_rrc_reportSFTD_01 = -1;          /* ReportSFTD_NR */
static int hf_nr_rrc_condTriggerConfig_r16 = -1;  /* CondTriggerConfig_r16 */
static int hf_nr_rrc_cli_Periodical_r16 = -1;     /* CLI_PeriodicalReportConfig_r16 */
static int hf_nr_rrc_cli_EventTriggered_r16 = -1;  /* CLI_EventTriggerConfig_r16 */
static int hf_nr_rrc_useAutonomousGaps_r16_01 = -1;  /* T_useAutonomousGaps_r16_01 */
static int hf_nr_rrc_reportSFTD_NeighMeas = -1;   /* T_reportSFTD_NeighMeas */
static int hf_nr_rrc_drx_SFTD_NeighMeas = -1;     /* T_drx_SFTD_NeighMeas */
static int hf_nr_rrc_cellsForWhichToReportSFTD = -1;  /* SEQUENCE_SIZE_1_maxCellSFTD_OF_PhysCellId */
static int hf_nr_rrc_cellsForWhichToReportSFTD_item = -1;  /* PhysCellId */
static int hf_nr_rrc_condEventId = -1;            /* T_condEventId */
static int hf_nr_rrc_condEventA3 = -1;            /* T_condEventA3 */
static int hf_nr_rrc_a3_Offset = -1;              /* MeasTriggerQuantityOffset */
static int hf_nr_rrc_condEventA5 = -1;            /* T_condEventA5 */
static int hf_nr_rrc_a5_Threshold1 = -1;          /* MeasTriggerQuantity */
static int hf_nr_rrc_a5_Threshold2 = -1;          /* MeasTriggerQuantity */
static int hf_nr_rrc_rsType_r16 = -1;             /* NR_RS_Type */
static int hf_nr_rrc_eventId_01 = -1;             /* T_eventId_01 */
static int hf_nr_rrc_eventA1 = -1;                /* T_eventA1 */
static int hf_nr_rrc_a1_Threshold = -1;           /* MeasTriggerQuantity */
static int hf_nr_rrc_eventA2 = -1;                /* T_eventA2 */
static int hf_nr_rrc_a2_Threshold = -1;           /* MeasTriggerQuantity */
static int hf_nr_rrc_eventA3 = -1;                /* T_eventA3 */
static int hf_nr_rrc_useWhiteCellList = -1;       /* BOOLEAN */
static int hf_nr_rrc_eventA4 = -1;                /* T_eventA4 */
static int hf_nr_rrc_a4_Threshold = -1;           /* MeasTriggerQuantity */
static int hf_nr_rrc_eventA5 = -1;                /* T_eventA5 */
static int hf_nr_rrc_eventA6 = -1;                /* T_eventA6 */
static int hf_nr_rrc_a6_Offset = -1;              /* MeasTriggerQuantityOffset */
static int hf_nr_rrc_reportAmount_02 = -1;        /* T_reportAmount_02 */
static int hf_nr_rrc_reportQuantityCell = -1;     /* MeasReportQuantity */
static int hf_nr_rrc_reportQuantityRS_Indexes = -1;  /* MeasReportQuantity */
static int hf_nr_rrc_maxNrofRS_IndexesToReport = -1;  /* INTEGER_1_maxNrofIndexesToReport */
static int hf_nr_rrc_includeBeamMeasurements = -1;  /* BOOLEAN */
static int hf_nr_rrc_reportAddNeighMeas = -1;     /* T_reportAddNeighMeas */
static int hf_nr_rrc_measRSSI_ReportConfig_r16 = -1;  /* MeasRSSI_ReportConfig_r16 */
static int hf_nr_rrc_useT312_r16 = -1;            /* BOOLEAN */
static int hf_nr_rrc_includeCommonLocationInfo_r16_02 = -1;  /* T_includeCommonLocationInfo_r16_02 */
static int hf_nr_rrc_includeBT_Meas_r16_02 = -1;  /* T_includeBT_Meas_r16_02 */
static int hf_nr_rrc_includeWLAN_Meas_r16_02 = -1;  /* T_includeWLAN_Meas_r16_02 */
static int hf_nr_rrc_includeSensor_Meas_r16_02 = -1;  /* T_includeSensor_Meas_r16_02 */
static int hf_nr_rrc_reportAmount_03 = -1;        /* T_reportAmount_03 */
static int hf_nr_rrc_includeCommonLocationInfo_r16_03 = -1;  /* T_includeCommonLocationInfo_r16_03 */
static int hf_nr_rrc_includeBT_Meas_r16_03 = -1;  /* T_includeBT_Meas_r16_03 */
static int hf_nr_rrc_includeWLAN_Meas_r16_03 = -1;  /* T_includeWLAN_Meas_r16_03 */
static int hf_nr_rrc_includeSensor_Meas_r16_03 = -1;  /* T_includeSensor_Meas_r16_03 */
static int hf_nr_rrc_ul_DelayValueConfig_r16 = -1;  /* T_ul_DelayValueConfig_r16 */
static int hf_nr_rrc_setup_98 = -1;               /* UL_DelayValueConfig_r16 */
static int hf_nr_rrc_reportAddNeighMeas_r16 = -1;  /* T_reportAddNeighMeas_r16 */
static int hf_nr_rrc_measTriggerQuantity_rsrp = -1;  /* RSRP_Range */
static int hf_nr_rrc_measTriggerQuantity_rsrq = -1;  /* RSRQ_Range */
static int hf_nr_rrc_measTriggerQuantity_sinr = -1;  /* SINR_Range */
static int hf_nr_rrc_measTriggerQuantityOffset_rsrp = -1;  /* INTEGER_M30_30 */
static int hf_nr_rrc_measTriggerQuantityOffset_rsrq = -1;  /* INTEGER_M30_30 */
static int hf_nr_rrc_measTriggerQuantityOffset_sinr = -1;  /* INTEGER_M30_30 */
static int hf_nr_rrc_measReportQuantity_rsrp = -1;  /* BOOLEAN */
static int hf_nr_rrc_measReportQuantity_rsrq = -1;  /* BOOLEAN */
static int hf_nr_rrc_measReportQuantity_sinr = -1;  /* BOOLEAN */
static int hf_nr_rrc_channelOccupancyThreshold_r16 = -1;  /* RSSI_Range_r16 */
static int hf_nr_rrc_eventId_r16 = -1;            /* T_eventId_r16 */
static int hf_nr_rrc_eventI1_r16 = -1;            /* T_eventI1_r16 */
static int hf_nr_rrc_i1_Threshold_r16 = -1;       /* MeasTriggerQuantityCLI_r16 */
static int hf_nr_rrc_reportInterval_r16 = -1;     /* ReportInterval */
static int hf_nr_rrc_reportAmount_r16 = -1;       /* T_reportAmount_r16 */
static int hf_nr_rrc_maxReportCLI_r16 = -1;       /* INTEGER_1_maxCLI_Report_r16 */
static int hf_nr_rrc_reportAmount_r16_01 = -1;    /* T_reportAmount_r16_01 */
static int hf_nr_rrc_reportQuantityCLI_r16 = -1;  /* MeasReportQuantityCLI_r16 */
static int hf_nr_rrc_srs_RSRP_r16 = -1;           /* SRS_RSRP_Range_r16 */
static int hf_nr_rrc_cli_RSSI_r16 = -1;           /* CLI_RSSI_Range_r16 */
static int hf_nr_rrc_reportType_r16 = -1;         /* T_reportType_r16 */
static int hf_nr_rrc_periodical_r16 = -1;         /* PeriodicalReportConfigNR_SL_r16 */
static int hf_nr_rrc_eventTriggered_r16 = -1;     /* EventTriggerConfigNR_SL_r16 */
static int hf_nr_rrc_eventId_r16_01 = -1;         /* T_eventId_r16_01 */
static int hf_nr_rrc_eventC1 = -1;                /* T_eventC1 */
static int hf_nr_rrc_c1_Threshold_r16 = -1;       /* SL_CBR_r16 */
static int hf_nr_rrc_eventC2_r16 = -1;            /* T_eventC2_r16 */
static int hf_nr_rrc_c2_Threshold_r16 = -1;       /* SL_CBR_r16 */
static int hf_nr_rrc_reportAmount_r16_02 = -1;    /* T_reportAmount_r16_02 */
static int hf_nr_rrc_reportQuantity_r16_01 = -1;  /* MeasReportQuantity_r16 */
static int hf_nr_rrc_reportAmount_r16_03 = -1;    /* T_reportAmount_r16_03 */
static int hf_nr_rrc_cbr_r16 = -1;                /* BOOLEAN */
static int hf_nr_rrc_ReportConfigToAddModList_item = -1;  /* ReportConfigToAddMod */
static int hf_nr_rrc_reportConfig = -1;           /* T_reportConfig */
static int hf_nr_rrc_reportConfigNR = -1;         /* ReportConfigNR */
static int hf_nr_rrc_reportConfigInterRAT = -1;   /* ReportConfigInterRAT */
static int hf_nr_rrc_reportConfigNR_SL_r16 = -1;  /* ReportConfigNR_SL_r16 */
static int hf_nr_rrc_servedRadioBearer = -1;      /* T_servedRadioBearer */
static int hf_nr_rrc_reestablishRLC = -1;         /* T_reestablishRLC */
static int hf_nr_rrc_rlc_Config = -1;             /* RLC_Config */
static int hf_nr_rrc_mac_LogicalChannelConfig = -1;  /* LogicalChannelConfig */
static int hf_nr_rrc_rlc_Config_v1610 = -1;       /* RLC_Config_v1610 */
static int hf_nr_rrc_am = -1;                     /* T_am */
static int hf_nr_rrc_ul_AM_RLC = -1;              /* UL_AM_RLC */
static int hf_nr_rrc_dl_AM_RLC = -1;              /* DL_AM_RLC */
static int hf_nr_rrc_um_Bi_Directional = -1;      /* T_um_Bi_Directional */
static int hf_nr_rrc_ul_UM_RLC = -1;              /* UL_UM_RLC */
static int hf_nr_rrc_dl_UM_RLC = -1;              /* DL_UM_RLC */
static int hf_nr_rrc_um_Uni_Directional_UL = -1;  /* T_um_Uni_Directional_UL */
static int hf_nr_rrc_um_Uni_Directional_DL = -1;  /* T_um_Uni_Directional_DL */
static int hf_nr_rrc_sn_FieldLength = -1;         /* SN_FieldLengthAM */
static int hf_nr_rrc_t_PollRetransmit = -1;       /* T_PollRetransmit */
static int hf_nr_rrc_pollPDU = -1;                /* PollPDU */
static int hf_nr_rrc_pollByte = -1;               /* PollByte */
static int hf_nr_rrc_maxRetxThreshold = -1;       /* T_maxRetxThreshold */
static int hf_nr_rrc_t_Reassembly = -1;           /* T_Reassembly */
static int hf_nr_rrc_t_StatusProhibit = -1;       /* T_StatusProhibit */
static int hf_nr_rrc_sn_FieldLength_01 = -1;      /* SN_FieldLengthUM */
static int hf_nr_rrc_dl_AM_RLC_v1610 = -1;        /* DL_AM_RLC_v1610 */
static int hf_nr_rrc_t_StatusProhibit_v1610 = -1;  /* T_StatusProhibit_v1610 */
static int hf_nr_rrc_t310 = -1;                   /* T_t310 */
static int hf_nr_rrc_n310 = -1;                   /* T_n310 */
static int hf_nr_rrc_n311 = -1;                   /* T_n311 */
static int hf_nr_rrc_t311 = -1;                   /* T_t311 */
static int hf_nr_rrc_schedulingRequestToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofSR_ConfigPerCellGroup_OF_SchedulingRequestToAddMod */
static int hf_nr_rrc_schedulingRequestToAddModList_item = -1;  /* SchedulingRequestToAddMod */
static int hf_nr_rrc_schedulingRequestToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofSR_ConfigPerCellGroup_OF_SchedulingRequestId */
static int hf_nr_rrc_schedulingRequestToReleaseList_item = -1;  /* SchedulingRequestId */
static int hf_nr_rrc_schedulingRequestId = -1;    /* SchedulingRequestId */
static int hf_nr_rrc_sr_ProhibitTimer = -1;       /* T_sr_ProhibitTimer */
static int hf_nr_rrc_sr_TransMax = -1;            /* T_sr_TransMax */
static int hf_nr_rrc_schedulingRequestResourceId = -1;  /* SchedulingRequestResourceId */
static int hf_nr_rrc_periodicityAndOffset_01 = -1;  /* T_periodicityAndOffset */
static int hf_nr_rrc_sym2 = -1;                   /* NULL */
static int hf_nr_rrc_sym6or7 = -1;                /* NULL */
static int hf_nr_rrc_sl1 = -1;                    /* NULL */
static int hf_nr_rrc_sl2 = -1;                    /* INTEGER_0_1 */
static int hf_nr_rrc_sl4 = -1;                    /* INTEGER_0_3 */
static int hf_nr_rrc_sl5 = -1;                    /* INTEGER_0_4 */
static int hf_nr_rrc_sl8 = -1;                    /* INTEGER_0_7 */
static int hf_nr_rrc_sl16 = -1;                   /* INTEGER_0_15 */
static int hf_nr_rrc_sl640 = -1;                  /* INTEGER_0_639 */
static int hf_nr_rrc_resource_01 = -1;            /* PUCCH_ResourceId */
static int hf_nr_rrc_phy_PriorityIndex_r16_01 = -1;  /* T_phy_PriorityIndex_r16_01 */
static int hf_nr_rrc_offsetToCarrier = -1;        /* INTEGER_0_2199 */
static int hf_nr_rrc_carrierBandwidth = -1;       /* INTEGER_1_maxNrofPhysicalResourceBlocks */
static int hf_nr_rrc_txDirectCurrentLocation = -1;  /* INTEGER_0_4095 */
static int hf_nr_rrc_pdu_Session = -1;            /* PDU_SessionID */
static int hf_nr_rrc_sdap_HeaderDL = -1;          /* T_sdap_HeaderDL */
static int hf_nr_rrc_sdap_HeaderUL = -1;          /* T_sdap_HeaderUL */
static int hf_nr_rrc_defaultDRB = -1;             /* BOOLEAN */
static int hf_nr_rrc_mappedQoS_FlowsToAdd = -1;   /* SEQUENCE_SIZE_1_maxNrofQFIs_OF_QFI */
static int hf_nr_rrc_mappedQoS_FlowsToAdd_item = -1;  /* QFI */
static int hf_nr_rrc_mappedQoS_FlowsToRelease = -1;  /* SEQUENCE_SIZE_1_maxNrofQFIs_OF_QFI */
static int hf_nr_rrc_mappedQoS_FlowsToRelease_item = -1;  /* QFI */
static int hf_nr_rrc_searchSpaceId = -1;          /* SearchSpaceId */
static int hf_nr_rrc_monitoringSlotPeriodicityAndOffset = -1;  /* T_monitoringSlotPeriodicityAndOffset */
static int hf_nr_rrc_sl1280 = -1;                 /* INTEGER_0_1279 */
static int hf_nr_rrc_sl2560 = -1;                 /* INTEGER_0_2559 */
static int hf_nr_rrc_duration_01 = -1;            /* INTEGER_2_2559 */
static int hf_nr_rrc_monitoringSymbolsWithinSlot = -1;  /* BIT_STRING_SIZE_14 */
static int hf_nr_rrc_nrofCandidates = -1;         /* T_nrofCandidates */
static int hf_nr_rrc_aggregationLevel1 = -1;      /* T_aggregationLevel1 */
static int hf_nr_rrc_aggregationLevel2 = -1;      /* T_aggregationLevel2 */
static int hf_nr_rrc_aggregationLevel4 = -1;      /* T_aggregationLevel4 */
static int hf_nr_rrc_aggregationLevel8 = -1;      /* T_aggregationLevel8 */
static int hf_nr_rrc_aggregationLevel16 = -1;     /* T_aggregationLevel16 */
static int hf_nr_rrc_searchSpaceType = -1;        /* T_searchSpaceType */
static int hf_nr_rrc_common = -1;                 /* T_common */
static int hf_nr_rrc_dci_Format0_0_AndFormat1_0 = -1;  /* T_dci_Format0_0_AndFormat1_0 */
static int hf_nr_rrc_dci_Format2_0 = -1;          /* T_dci_Format2_0 */
static int hf_nr_rrc_nrofCandidates_SFI = -1;     /* T_nrofCandidates_SFI */
static int hf_nr_rrc_aggregationLevel1_01 = -1;   /* T_aggregationLevel1_01 */
static int hf_nr_rrc_aggregationLevel2_01 = -1;   /* T_aggregationLevel2_01 */
static int hf_nr_rrc_aggregationLevel4_01 = -1;   /* T_aggregationLevel4_01 */
static int hf_nr_rrc_aggregationLevel8_01 = -1;   /* T_aggregationLevel8_01 */
static int hf_nr_rrc_aggregationLevel16_01 = -1;  /* T_aggregationLevel16_01 */
static int hf_nr_rrc_dci_Format2_1 = -1;          /* T_dci_Format2_1 */
static int hf_nr_rrc_dci_Format2_2 = -1;          /* T_dci_Format2_2 */
static int hf_nr_rrc_dci_Format2_3 = -1;          /* T_dci_Format2_3 */
static int hf_nr_rrc_searchSpace_searchSpaceType__common_dci_Format2_3_dummy1 = -1;  /* T_searchSpace_searchSpaceType__common_dci_Format2_3_dummy1 */
static int hf_nr_rrc_searchSpace_searchSpaceType_common_dci_Format2_3_dummy2 = -1;  /* T_searchSpace_searchSpaceType_common_dci_Format2_3_dummy2 */
static int hf_nr_rrc_ue_Specific = -1;            /* T_ue_Specific */
static int hf_nr_rrc_dci_Formats = -1;            /* T_dci_Formats */
static int hf_nr_rrc_dci_Formats_MT_r16 = -1;     /* T_dci_Formats_MT_r16 */
static int hf_nr_rrc_dci_FormatsSL_r16 = -1;      /* T_dci_FormatsSL_r16 */
static int hf_nr_rrc_dci_FormatsExt_r16 = -1;     /* T_dci_FormatsExt_r16 */
static int hf_nr_rrc_controlResourceSetId_r16 = -1;  /* ControlResourceSetId_r16 */
static int hf_nr_rrc_searchSpaceType_r16 = -1;    /* T_searchSpaceType_r16 */
static int hf_nr_rrc_common_r16 = -1;             /* T_common_r16 */
static int hf_nr_rrc_dci_Format2_4_r16 = -1;      /* T_dci_Format2_4_r16 */
static int hf_nr_rrc_nrofCandidates_CI_r16 = -1;  /* T_nrofCandidates_CI_r16 */
static int hf_nr_rrc_aggregationLevel1_r16 = -1;  /* T_aggregationLevel1_r16 */
static int hf_nr_rrc_aggregationLevel2_r16 = -1;  /* T_aggregationLevel2_r16 */
static int hf_nr_rrc_aggregationLevel4_r16 = -1;  /* T_aggregationLevel4_r16 */
static int hf_nr_rrc_aggregationLevel8_r16 = -1;  /* T_aggregationLevel8_r16 */
static int hf_nr_rrc_aggregationLevel16_r16 = -1;  /* T_aggregationLevel16_r16 */
static int hf_nr_rrc_dci_Format2_5_r16 = -1;      /* T_dci_Format2_5_r16 */
static int hf_nr_rrc_nrofCandidates_IAB_r16 = -1;  /* T_nrofCandidates_IAB_r16 */
static int hf_nr_rrc_aggregationLevel1_r16_01 = -1;  /* T_aggregationLevel1_r16_01 */
static int hf_nr_rrc_aggregationLevel2_r16_01 = -1;  /* T_aggregationLevel2_r16_01 */
static int hf_nr_rrc_aggregationLevel4_r16_01 = -1;  /* T_aggregationLevel4_r16_01 */
static int hf_nr_rrc_aggregationLevel8_r16_01 = -1;  /* T_aggregationLevel8_r16_01 */
static int hf_nr_rrc_aggregationLevel16_r16_01 = -1;  /* T_aggregationLevel16_r16_01 */
static int hf_nr_rrc_dci_Format2_6_r16 = -1;      /* T_dci_Format2_6_r16 */
static int hf_nr_rrc_searchSpaceGroupIdList_r16 = -1;  /* T_searchSpaceGroupIdList_r16 */
static int hf_nr_rrc_searchSpaceGroupIdList_r16_item = -1;  /* INTEGER_0_1 */
static int hf_nr_rrc_freqMonitorLocations_r16 = -1;  /* BIT_STRING_SIZE_5 */
static int hf_nr_rrc_cipheringAlgorithm = -1;     /* CipheringAlgorithm */
static int hf_nr_rrc_integrityProtAlgorithm = -1;  /* IntegrityProtAlgorithm */
static int hf_nr_rrc_period = -1;                 /* T_period */
static int hf_nr_rrc_sensor_MeasurementInformation_r16 = -1;  /* T_sensor_MeasurementInformation_r16 */
static int hf_nr_rrc_sensor_MotionInformation_r16 = -1;  /* T_sensor_MotionInformation_r16 */
static int hf_nr_rrc_tdd_UL_DL_ConfigurationDedicated = -1;  /* TDD_UL_DL_ConfigDedicated */
static int hf_nr_rrc_initialDownlinkBWP_01 = -1;  /* BWP_DownlinkDedicated */
static int hf_nr_rrc_downlinkBWP_ToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofBWPs_OF_BWP_Id */
static int hf_nr_rrc_downlinkBWP_ToReleaseList_item = -1;  /* BWP_Id */
static int hf_nr_rrc_downlinkBWP_ToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofBWPs_OF_BWP_Downlink */
static int hf_nr_rrc_downlinkBWP_ToAddModList_item = -1;  /* BWP_Downlink */
static int hf_nr_rrc_firstActiveDownlinkBWP_Id = -1;  /* BWP_Id */
static int hf_nr_rrc_bwp_InactivityTimer = -1;    /* T_bwp_InactivityTimer */
static int hf_nr_rrc_defaultDownlinkBWP_Id = -1;  /* BWP_Id */
static int hf_nr_rrc_uplinkConfig = -1;           /* UplinkConfig */
static int hf_nr_rrc_supplementaryUplink_01 = -1;  /* UplinkConfig */
static int hf_nr_rrc_pdcch_ServingCellConfig = -1;  /* T_pdcch_ServingCellConfig */
static int hf_nr_rrc_setup_99 = -1;               /* PDCCH_ServingCellConfig */
static int hf_nr_rrc_pdsch_ServingCellConfig = -1;  /* T_pdsch_ServingCellConfig */
static int hf_nr_rrc_setup_100 = -1;              /* PDSCH_ServingCellConfig */
static int hf_nr_rrc_csi_MeasConfig = -1;         /* T_csi_MeasConfig */
static int hf_nr_rrc_setup_101 = -1;              /* CSI_MeasConfig */
static int hf_nr_rrc_sCellDeactivationTimer = -1;  /* T_sCellDeactivationTimer */
static int hf_nr_rrc_crossCarrierSchedulingConfig = -1;  /* CrossCarrierSchedulingConfig */
static int hf_nr_rrc_tag_Id = -1;                 /* TAG_Id */
static int hf_nr_rrc_dummy1_01 = -1;              /* T_dummy1_01 */
static int hf_nr_rrc_pathlossReferenceLinking = -1;  /* T_pathlossReferenceLinking */
static int hf_nr_rrc_servingCellMO = -1;          /* MeasObjectId */
static int hf_nr_rrc_lte_CRS_ToMatchAround = -1;  /* T_lte_CRS_ToMatchAround */
static int hf_nr_rrc_setup_102 = -1;              /* RateMatchPatternLTE_CRS */
static int hf_nr_rrc_downlinkChannelBW_PerSCS_List = -1;  /* SEQUENCE_SIZE_1_maxSCSs_OF_SCS_SpecificCarrier */
static int hf_nr_rrc_downlinkChannelBW_PerSCS_List_item = -1;  /* SCS_SpecificCarrier */
static int hf_nr_rrc_supplementaryUplinkRelease_r16 = -1;  /* T_supplementaryUplinkRelease_r16 */
static int hf_nr_rrc_tdd_UL_DL_ConfigurationDedicated_IAB_MT_r16 = -1;  /* TDD_UL_DL_ConfigDedicated_IAB_MT_r16 */
static int hf_nr_rrc_dormantBWP_Config_r16 = -1;  /* T_dormantBWP_Config_r16 */
static int hf_nr_rrc_setup_103 = -1;              /* DormantBWP_Config_r16 */
static int hf_nr_rrc_ca_SlotOffset_r16 = -1;      /* T_ca_SlotOffset_r16 */
static int hf_nr_rrc_refSCS15kHz = -1;            /* INTEGER_M2_2 */
static int hf_nr_rrc_refSCS30KHz = -1;            /* INTEGER_M5_5 */
static int hf_nr_rrc_refSCS60KHz = -1;            /* INTEGER_M10_10 */
static int hf_nr_rrc_refSCS120KHz = -1;           /* INTEGER_M20_20 */
static int hf_nr_rrc_servingCellConfig_eag_2_dummy2 = -1;  /* T_servingCellConfig_eag_2_dummy2 */
static int hf_nr_rrc_setup_104 = -1;              /* DummyJ */
static int hf_nr_rrc_intraCellGuardBandsDL_List_r16 = -1;  /* SEQUENCE_SIZE_1_maxSCSs_OF_IntraCellGuardBandsPerSCS_r16 */
static int hf_nr_rrc_intraCellGuardBandsDL_List_r16_item = -1;  /* IntraCellGuardBandsPerSCS_r16 */
static int hf_nr_rrc_intraCellGuardBandsUL_List_r16 = -1;  /* SEQUENCE_SIZE_1_maxSCSs_OF_IntraCellGuardBandsPerSCS_r16 */
static int hf_nr_rrc_intraCellGuardBandsUL_List_r16_item = -1;  /* IntraCellGuardBandsPerSCS_r16 */
static int hf_nr_rrc_csi_RS_ValidationWithDCI_r16 = -1;  /* T_csi_RS_ValidationWithDCI_r16 */
static int hf_nr_rrc_lte_CRS_PatternList1_r16 = -1;  /* T_lte_CRS_PatternList1_r16 */
static int hf_nr_rrc_setup_105 = -1;              /* LTE_CRS_PatternList_r16 */
static int hf_nr_rrc_lte_CRS_PatternList2_r16 = -1;  /* T_lte_CRS_PatternList2_r16 */
static int hf_nr_rrc_crs_RateMatch_PerCORESETPoolIndex_r16 = -1;  /* T_crs_RateMatch_PerCORESETPoolIndex_r16 */
static int hf_nr_rrc_enableTwoDefaultTCI_States_r16 = -1;  /* T_enableTwoDefaultTCI_States_r16 */
static int hf_nr_rrc_enableDefaultTCI_StatePerCoresetPoolIndex_r16 = -1;  /* T_enableDefaultTCI_StatePerCoresetPoolIndex_r16 */
static int hf_nr_rrc_enableBeamSwitchTiming_r16 = -1;  /* T_enableBeamSwitchTiming_r16 */
static int hf_nr_rrc_cbg_TxDiffTBsProcessingType1_r16 = -1;  /* T_cbg_TxDiffTBsProcessingType1_r16 */
static int hf_nr_rrc_cbg_TxDiffTBsProcessingType2_r16 = -1;  /* T_cbg_TxDiffTBsProcessingType2_r16 */
static int hf_nr_rrc_directionalCollisionHandling_r16 = -1;  /* T_directionalCollisionHandling_r16 */
static int hf_nr_rrc_channelAccessConfig_r16 = -1;  /* T_channelAccessConfig_r16 */
static int hf_nr_rrc_setup_106 = -1;              /* ChannelAccessConfig_r16 */
static int hf_nr_rrc_initialUplinkBWP = -1;       /* BWP_UplinkDedicated */
static int hf_nr_rrc_uplinkBWP_ToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofBWPs_OF_BWP_Id */
static int hf_nr_rrc_uplinkBWP_ToReleaseList_item = -1;  /* BWP_Id */
static int hf_nr_rrc_uplinkBWP_ToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofBWPs_OF_BWP_Uplink */
static int hf_nr_rrc_uplinkBWP_ToAddModList_item = -1;  /* BWP_Uplink */
static int hf_nr_rrc_firstActiveUplinkBWP_Id = -1;  /* BWP_Id */
static int hf_nr_rrc_pusch_ServingCellConfig = -1;  /* T_pusch_ServingCellConfig */
static int hf_nr_rrc_setup_107 = -1;              /* PUSCH_ServingCellConfig */
static int hf_nr_rrc_carrierSwitching = -1;       /* T_carrierSwitching */
static int hf_nr_rrc_setup_108 = -1;              /* SRS_CarrierSwitching */
static int hf_nr_rrc_powerBoostPi2BPSK = -1;      /* BOOLEAN */
static int hf_nr_rrc_uplinkChannelBW_PerSCS_List = -1;  /* SEQUENCE_SIZE_1_maxSCSs_OF_SCS_SpecificCarrier */
static int hf_nr_rrc_uplinkChannelBW_PerSCS_List_item = -1;  /* SCS_SpecificCarrier */
static int hf_nr_rrc_enablePL_RS_UpdateForPUSCH_SRS_r16 = -1;  /* T_enablePL_RS_UpdateForPUSCH_SRS_r16 */
static int hf_nr_rrc_enableDefaultBeamPL_ForPUSCH0_0_r16 = -1;  /* T_enableDefaultBeamPL_ForPUSCH0_0_r16 */
static int hf_nr_rrc_enableDefaultBeamPL_ForPUCCH_r16 = -1;  /* T_enableDefaultBeamPL_ForPUCCH_r16 */
static int hf_nr_rrc_enableDefaultBeamPL_ForSRS_r16 = -1;  /* T_enableDefaultBeamPL_ForSRS_r16 */
static int hf_nr_rrc_uplinkTxSwitching_r16 = -1;  /* T_uplinkTxSwitching_r16 */
static int hf_nr_rrc_setup_109 = -1;              /* UplinkTxSwitching_r16 */
static int hf_nr_rrc_mpr_PowerBoost_FR2_r16 = -1;  /* T_mpr_PowerBoost_FR2_r16 */
static int hf_nr_rrc_maxEnergyDetectionThreshold_r16 = -1;  /* INTEGER_M85_M52 */
static int hf_nr_rrc_energyDetectionThresholdOffset_r16 = -1;  /* INTEGER_M20_M13 */
static int hf_nr_rrc_ul_toDL_COT_SharingED_Threshold_r16 = -1;  /* INTEGER_M85_M52 */
static int hf_nr_rrc_absenceOfAnyOtherTechnology_r16 = -1;  /* T_absenceOfAnyOtherTechnology_r16 */
static int hf_nr_rrc_energyDetectionConfig_r16 = -1;  /* T_energyDetectionConfig_r16 */
static int hf_nr_rrc_energyDetectionThresholdOffset_r16_01 = -1;  /* INTEGER_M13_20 */
static int hf_nr_rrc_absenceOfAnyOtherTechnology_r16_01 = -1;  /* T_absenceOfAnyOtherTechnology_r16_01 */
static int hf_nr_rrc_guardBandSCS_r16 = -1;       /* SubcarrierSpacing */
static int hf_nr_rrc_intraCellGuardBands_r16 = -1;  /* SEQUENCE_SIZE_1_4_OF_GuardBand_r16 */
static int hf_nr_rrc_intraCellGuardBands_r16_item = -1;  /* GuardBand_r16 */
static int hf_nr_rrc_startCRB_r16 = -1;           /* INTEGER_0_274 */
static int hf_nr_rrc_nrofCRBs_r16 = -1;           /* INTEGER_0_15 */
static int hf_nr_rrc_dormantBWP_Id_r16 = -1;      /* BWP_Id */
static int hf_nr_rrc_withinActiveTimeConfig_r16 = -1;  /* T_withinActiveTimeConfig_r16 */
static int hf_nr_rrc_setup_110 = -1;              /* WithinActiveTimeConfig_r16 */
static int hf_nr_rrc_outsideActiveTimeConfig_r16 = -1;  /* T_outsideActiveTimeConfig_r16 */
static int hf_nr_rrc_setup_111 = -1;              /* OutsideActiveTimeConfig_r16 */
static int hf_nr_rrc_firstWithinActiveTimeBWP_Id_r16 = -1;  /* BWP_Id */
static int hf_nr_rrc_dormancyGroupWithinActiveTime_r16 = -1;  /* DormancyGroupID_r16 */
static int hf_nr_rrc_firstOutsideActiveTimeBWP_Id_r16 = -1;  /* BWP_Id */
static int hf_nr_rrc_dormancyGroupOutsideActiveTime_r16 = -1;  /* DormancyGroupID_r16 */
static int hf_nr_rrc_uplinkTxSwitchingPeriodLocation_r16 = -1;  /* BOOLEAN */
static int hf_nr_rrc_uplinkTxSwitchingCarrier_r16 = -1;  /* T_uplinkTxSwitchingCarrier_r16 */
static int hf_nr_rrc_downlinkConfigCommon = -1;   /* DownlinkConfigCommon */
static int hf_nr_rrc_uplinkConfigCommon = -1;     /* UplinkConfigCommon */
static int hf_nr_rrc_supplementaryUplinkConfig = -1;  /* UplinkConfigCommon */
static int hf_nr_rrc_n_TimingAdvanceOffset = -1;  /* T_n_TimingAdvanceOffset */
static int hf_nr_rrc_ssb_PositionsInBurst = -1;   /* T_ssb_PositionsInBurst */
static int hf_nr_rrc_shortBitmap = -1;            /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_mediumBitmap = -1;           /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_longBitmap = -1;             /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_ssb_periodicityServingCell = -1;  /* T_ssb_periodicityServingCell */
static int hf_nr_rrc_dmrs_TypeA_Position_01 = -1;  /* T_dmrs_TypeA_Position_01 */
static int hf_nr_rrc_lte_CRS_ToMatchAround_01 = -1;  /* T_lte_CRS_ToMatchAround_01 */
static int hf_nr_rrc_tdd_UL_DL_ConfigurationCommon = -1;  /* TDD_UL_DL_ConfigCommon */
static int hf_nr_rrc_ss_PBCH_BlockPower = -1;     /* INTEGER_M60_50 */
static int hf_nr_rrc_channelAccessMode_r16 = -1;  /* T_channelAccessMode_r16 */
static int hf_nr_rrc_dynamic_02 = -1;             /* NULL */
static int hf_nr_rrc_semiStatic_01 = -1;          /* SemiStaticChannelAccessConfig_r16 */
static int hf_nr_rrc_discoveryBurstWindowLength_r16 = -1;  /* T_discoveryBurstWindowLength_r16 */
static int hf_nr_rrc_highSpeedConfig_r16 = -1;    /* HighSpeedConfig_r16 */
static int hf_nr_rrc_downlinkConfigCommon_01 = -1;  /* DownlinkConfigCommonSIB */
static int hf_nr_rrc_uplinkConfigCommon_01 = -1;  /* UplinkConfigCommonSIB */
static int hf_nr_rrc_supplementaryUplink_02 = -1;  /* UplinkConfigCommonSIB */
static int hf_nr_rrc_n_TimingAdvanceOffset_01 = -1;  /* T_n_TimingAdvanceOffset_01 */
static int hf_nr_rrc_ssb_PositionsInBurst_01 = -1;  /* T_ssb_PositionsInBurst_01 */
static int hf_nr_rrc_inOneGroup = -1;             /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_groupPresence = -1;          /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_ssb_PeriodicityServingCell = -1;  /* T_ssb_PeriodicityServingCell */
static int hf_nr_rrc_channelAccessMode_r16_01 = -1;  /* T_channelAccessMode_r16_01 */
static int hf_nr_rrc_discoveryBurstWindowLength_r16_01 = -1;  /* T_discoveryBurstWindowLength_r16_01 */
static int hf_nr_rrc_rach_OccasionsSI = -1;       /* T_rach_OccasionsSI */
static int hf_nr_rrc_rach_ConfigSI = -1;          /* RACH_ConfigGeneric */
static int hf_nr_rrc_ssb_perRACH_Occasion_02 = -1;  /* T_ssb_perRACH_Occasion_02 */
static int hf_nr_rrc_si_RequestPeriod = -1;       /* T_si_RequestPeriod */
static int hf_nr_rrc_si_RequestResources = -1;    /* SEQUENCE_SIZE_1_maxSI_Message_OF_SI_RequestResources */
static int hf_nr_rrc_si_RequestResources_item = -1;  /* SI_RequestResources */
static int hf_nr_rrc_ra_PreambleStartIndex = -1;  /* INTEGER_0_63 */
static int hf_nr_rrc_ra_AssociationPeriodIndex = -1;  /* INTEGER_0_15 */
static int hf_nr_rrc_schedulingInfoList = -1;     /* SEQUENCE_SIZE_1_maxSI_Message_OF_SchedulingInfo */
static int hf_nr_rrc_schedulingInfoList_item = -1;  /* SchedulingInfo */
static int hf_nr_rrc_si_WindowLength = -1;        /* T_si_WindowLength */
static int hf_nr_rrc_si_RequestConfig = -1;       /* SI_RequestConfig */
static int hf_nr_rrc_si_RequestConfigSUL = -1;    /* SI_RequestConfig */
static int hf_nr_rrc_systemInformationAreaID = -1;  /* BIT_STRING_SIZE_24 */
static int hf_nr_rrc_si_BroadcastStatus = -1;     /* T_si_BroadcastStatus */
static int hf_nr_rrc_si_Periodicity = -1;         /* T_si_Periodicity */
static int hf_nr_rrc_sib_MappingInfo = -1;        /* SIB_Mapping */
static int hf_nr_rrc_SIB_Mapping_item = -1;       /* SIB_TypeInfo */
static int hf_nr_rrc_type = -1;                   /* T_type */
static int hf_nr_rrc_valueTag = -1;               /* INTEGER_0_31 */
static int hf_nr_rrc_areaScope = -1;              /* T_areaScope */
static int hf_nr_rrc_subcarrierSpacing2 = -1;     /* SubcarrierSpacing */
static int hf_nr_rrc_slotFormatCombinations = -1;  /* SEQUENCE_SIZE_1_maxNrofSlotFormatCombinationsPerSet_OF_SlotFormatCombination */
static int hf_nr_rrc_slotFormatCombinations_item = -1;  /* SlotFormatCombination */
static int hf_nr_rrc_positionInDCI_01 = -1;       /* INTEGER_0_maxSFI_DCI_PayloadSize_1 */
static int hf_nr_rrc_enableConfiguredUL_r16 = -1;  /* T_enableConfiguredUL_r16 */
static int hf_nr_rrc_slotFormatCombinationId = -1;  /* SlotFormatCombinationId */
static int hf_nr_rrc_slotFormats = -1;            /* T_slotFormats */
static int hf_nr_rrc_slotFormats_item = -1;       /* INTEGER_0_255 */
static int hf_nr_rrc_sfi_RNTI = -1;               /* RNTI_Value */
static int hf_nr_rrc_dci_PayloadSize_01 = -1;     /* INTEGER_1_maxSFI_DCI_PayloadSize */
static int hf_nr_rrc_slotFormatCombToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroup_OF_SlotFormatCombinationsPerCell */
static int hf_nr_rrc_slotFormatCombToAddModList_item = -1;  /* SlotFormatCombinationsPerCell */
static int hf_nr_rrc_slotFormatCombToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroup_OF_ServCellIndex */
static int hf_nr_rrc_slotFormatCombToReleaseList_item = -1;  /* ServCellIndex */
static int hf_nr_rrc_availableRB_SetsToAddModList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroup_OF_AvailableRB_SetsPerCell_r16 */
static int hf_nr_rrc_availableRB_SetsToAddModList_r16_item = -1;  /* AvailableRB_SetsPerCell_r16 */
static int hf_nr_rrc_availableRB_SetsToReleaseList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroup_OF_ServCellIndex */
static int hf_nr_rrc_availableRB_SetsToReleaseList_r16_item = -1;  /* ServCellIndex */
static int hf_nr_rrc_switchTriggerToAddModList_r16 = -1;  /* SEQUENCE_SIZE_1_4_OF_SearchSpaceSwitchTrigger_r16 */
static int hf_nr_rrc_switchTriggerToAddModList_r16_item = -1;  /* SearchSpaceSwitchTrigger_r16 */
static int hf_nr_rrc_switchTriggerToReleaseList_r16 = -1;  /* SEQUENCE_SIZE_1_4_OF_ServCellIndex */
static int hf_nr_rrc_switchTriggerToReleaseList_r16_item = -1;  /* ServCellIndex */
static int hf_nr_rrc_co_DurationsPerCellToAddModList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroup_OF_CO_DurationsPerCell_r16 */
static int hf_nr_rrc_co_DurationsPerCellToAddModList_r16_item = -1;  /* CO_DurationsPerCell_r16 */
static int hf_nr_rrc_co_DurationsPerCellToReleaseList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroup_OF_ServCellIndex */
static int hf_nr_rrc_co_DurationsPerCellToReleaseList_r16_item = -1;  /* ServCellIndex */
static int hf_nr_rrc_switchTriggerToAddModListSizeExt_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroupMinus4_r16_OF_SearchSpaceSwitchTrigger_r16 */
static int hf_nr_rrc_switchTriggerToAddModListSizeExt_r16_item = -1;  /* SearchSpaceSwitchTrigger_r16 */
static int hf_nr_rrc_switchTriggerToReleaseListSizeExt_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroupMinus4_r16_OF_ServCellIndex */
static int hf_nr_rrc_switchTriggerToReleaseListSizeExt_r16_item = -1;  /* ServCellIndex */
static int hf_nr_rrc_servingCellId_r16 = -1;      /* ServCellIndex */
static int hf_nr_rrc_positionInDCI_r16 = -1;      /* INTEGER_0_maxSFI_DCI_PayloadSize_1 */
static int hf_nr_rrc_co_DurationList_r16 = -1;    /* SEQUENCE_SIZE_1_64_OF_CO_Duration_r16 */
static int hf_nr_rrc_co_DurationList_r16_item = -1;  /* CO_Duration_r16 */
static int hf_nr_rrc_sst = -1;                    /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_sst_SD = -1;                 /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_sf_Medium_01 = -1;           /* T_sf_Medium_01 */
static int hf_nr_rrc_sf_High_01 = -1;             /* T_sf_High_01 */
static int hf_nr_rrc_periodicity_01 = -1;         /* T_periodicity_01 */
static int hf_nr_rrc_nrofHARQ_Processes_01 = -1;  /* INTEGER_1_8 */
static int hf_nr_rrc_n1PUCCH_AN = -1;             /* PUCCH_ResourceId */
static int hf_nr_rrc_mcs_Table_03 = -1;           /* T_mcs_Table_03 */
static int hf_nr_rrc_sps_ConfigIndex_r16 = -1;    /* SPS_ConfigIndex_r16 */
static int hf_nr_rrc_harq_CodebookID_r16 = -1;    /* INTEGER_1_2 */
static int hf_nr_rrc_pdsch_AggregationFactor_r16 = -1;  /* T_pdsch_AggregationFactor_r16 */
static int hf_nr_rrc_sps_PUCCH_AN_ResourceID_r16 = -1;  /* PUCCH_ResourceId */
static int hf_nr_rrc_maxPayloadSize_r16 = -1;     /* INTEGER_4_256 */
static int hf_nr_rrc_SPS_PUCCH_AN_List_r16_item = -1;  /* SPS_PUCCH_AN_r16 */
static int hf_nr_rrc_srs_SwitchFromServCellIndex = -1;  /* INTEGER_0_31 */
static int hf_nr_rrc_srs_SwitchFromCarrier = -1;  /* T_srs_SwitchFromCarrier */
static int hf_nr_rrc_srs_TPC_PDCCH_Group = -1;    /* T_srs_TPC_PDCCH_Group */
static int hf_nr_rrc_typeA = -1;                  /* SEQUENCE_SIZE_1_32_OF_SRS_TPC_PDCCH_Config */
static int hf_nr_rrc_typeA_item = -1;             /* SRS_TPC_PDCCH_Config */
static int hf_nr_rrc_typeB = -1;                  /* SRS_TPC_PDCCH_Config */
static int hf_nr_rrc_monitoringCells = -1;        /* SEQUENCE_SIZE_1_maxNrofServingCells_OF_ServCellIndex */
static int hf_nr_rrc_monitoringCells_item = -1;   /* ServCellIndex */
static int hf_nr_rrc_srs_CC_SetIndexlist = -1;    /* SEQUENCE_SIZE_1_4_OF_SRS_CC_SetIndex */
static int hf_nr_rrc_srs_CC_SetIndexlist_item = -1;  /* SRS_CC_SetIndex */
static int hf_nr_rrc_cc_SetIndex = -1;            /* INTEGER_0_3 */
static int hf_nr_rrc_cc_IndexInOneCC_Set = -1;    /* INTEGER_0_7 */
static int hf_nr_rrc_srs_ResourceSetToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofSRS_ResourceSets_OF_SRS_ResourceSetId */
static int hf_nr_rrc_srs_ResourceSetToReleaseList_item = -1;  /* SRS_ResourceSetId */
static int hf_nr_rrc_srs_ResourceSetToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofSRS_ResourceSets_OF_SRS_ResourceSet */
static int hf_nr_rrc_srs_ResourceSetToAddModList_item = -1;  /* SRS_ResourceSet */
static int hf_nr_rrc_srs_ResourceToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofSRS_Resources_OF_SRS_ResourceId */
static int hf_nr_rrc_srs_ResourceToReleaseList_item = -1;  /* SRS_ResourceId */
static int hf_nr_rrc_srs_ResourceToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofSRS_Resources_OF_SRS_Resource */
static int hf_nr_rrc_srs_ResourceToAddModList_item = -1;  /* SRS_Resource */
static int hf_nr_rrc_tpc_Accumulation_01 = -1;    /* T_tpc_Accumulation_01 */
static int hf_nr_rrc_srs_RequestDCI_1_2_r16 = -1;  /* INTEGER_1_2 */
static int hf_nr_rrc_srs_RequestDCI_0_2_r16 = -1;  /* INTEGER_1_2 */
static int hf_nr_rrc_srs_ResourceSetToAddModListDCI_0_2_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofSRS_ResourceSets_OF_SRS_ResourceSet */
static int hf_nr_rrc_srs_ResourceSetToAddModListDCI_0_2_r16_item = -1;  /* SRS_ResourceSet */
static int hf_nr_rrc_srs_ResourceSetToReleaseListDCI_0_2_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofSRS_ResourceSets_OF_SRS_ResourceSetId */
static int hf_nr_rrc_srs_ResourceSetToReleaseListDCI_0_2_r16_item = -1;  /* SRS_ResourceSetId */
static int hf_nr_rrc_srs_PosResourceSetToReleaseList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofSRS_PosResourceSets_r16_OF_SRS_PosResourceSetId_r16 */
static int hf_nr_rrc_srs_PosResourceSetToReleaseList_r16_item = -1;  /* SRS_PosResourceSetId_r16 */
static int hf_nr_rrc_srs_PosResourceSetToAddModList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofSRS_PosResourceSets_r16_OF_SRS_PosResourceSet_r16 */
static int hf_nr_rrc_srs_PosResourceSetToAddModList_r16_item = -1;  /* SRS_PosResourceSet_r16 */
static int hf_nr_rrc_srs_PosResourceToReleaseList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofSRS_PosResources_r16_OF_SRS_PosResourceId_r16 */
static int hf_nr_rrc_srs_PosResourceToReleaseList_r16_item = -1;  /* SRS_PosResourceId_r16 */
static int hf_nr_rrc_srs_PosResourceToAddModList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofSRS_PosResources_r16_OF_SRS_PosResource_r16 */
static int hf_nr_rrc_srs_PosResourceToAddModList_r16_item = -1;  /* SRS_PosResource_r16 */
static int hf_nr_rrc_srs_ResourceSetId = -1;      /* SRS_ResourceSetId */
static int hf_nr_rrc_srs_ResourceIdList = -1;     /* SEQUENCE_SIZE_1_maxNrofSRS_ResourcesPerSet_OF_SRS_ResourceId */
static int hf_nr_rrc_srs_ResourceIdList_item = -1;  /* SRS_ResourceId */
static int hf_nr_rrc_resourceType_01 = -1;        /* T_resourceType_01 */
static int hf_nr_rrc_aperiodic_01 = -1;           /* T_aperiodic_01 */
static int hf_nr_rrc_aperiodicSRS_ResourceTrigger = -1;  /* INTEGER_1_maxNrofSRS_TriggerStates_1 */
static int hf_nr_rrc_slotOffset = -1;             /* INTEGER_1_32 */
static int hf_nr_rrc_aperiodicSRS_ResourceTriggerList = -1;  /* T_aperiodicSRS_ResourceTriggerList */
static int hf_nr_rrc_aperiodicSRS_ResourceTriggerList_item = -1;  /* INTEGER_1_maxNrofSRS_TriggerStates_1 */
static int hf_nr_rrc_semi_persistent = -1;        /* T_semi_persistent */
static int hf_nr_rrc_associatedCSI_RS = -1;       /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_periodic_01 = -1;            /* T_periodic_01 */
static int hf_nr_rrc_usage = -1;                  /* T_usage */
static int hf_nr_rrc_p0_01 = -1;                  /* INTEGER_M202_24 */
static int hf_nr_rrc_pathlossReferenceRS = -1;    /* PathlossReferenceRS_Config */
static int hf_nr_rrc_srs_PowerControlAdjustmentStates = -1;  /* T_srs_PowerControlAdjustmentStates */
static int hf_nr_rrc_pathlossReferenceRSList_r16 = -1;  /* T_pathlossReferenceRSList_r16 */
static int hf_nr_rrc_setup_112 = -1;              /* PathlossReferenceRSList_r16 */
static int hf_nr_rrc_PathlossReferenceRSList_r16_item = -1;  /* PathlossReferenceRS_r16 */
static int hf_nr_rrc_srs_PathlossReferenceRS_Id_r16 = -1;  /* SRS_PathlossReferenceRS_Id_r16 */
static int hf_nr_rrc_pathlossReferenceRS_r16 = -1;  /* PathlossReferenceRS_Config */
static int hf_nr_rrc_srs_PosResourceSetId_r16 = -1;  /* SRS_PosResourceSetId_r16 */
static int hf_nr_rrc_srs_PosResourceIdList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofSRS_ResourcesPerSet_OF_SRS_PosResourceId_r16 */
static int hf_nr_rrc_srs_PosResourceIdList_r16_item = -1;  /* SRS_PosResourceId_r16 */
static int hf_nr_rrc_resourceType_r16 = -1;       /* T_resourceType_r16 */
static int hf_nr_rrc_aperiodic_r16 = -1;          /* T_aperiodic_r16 */
static int hf_nr_rrc_aperiodicSRS_ResourceTriggerList_r16 = -1;  /* T_aperiodicSRS_ResourceTriggerList_r16 */
static int hf_nr_rrc_aperiodicSRS_ResourceTriggerList_r16_item = -1;  /* INTEGER_1_maxNrofSRS_TriggerStates_1 */
static int hf_nr_rrc_semi_persistent_r16 = -1;    /* T_semi_persistent_r16 */
static int hf_nr_rrc_periodic_r16 = -1;           /* T_periodic_r16 */
static int hf_nr_rrc_alpha_r16 = -1;              /* Alpha */
static int hf_nr_rrc_p0_r16 = -1;                 /* INTEGER_M202_24 */
static int hf_nr_rrc_pathlossReferenceRS_Pos_r16 = -1;  /* T_pathlossReferenceRS_Pos_r16 */
static int hf_nr_rrc_ssb_IndexServing_r16 = -1;   /* SSB_Index */
static int hf_nr_rrc_ssb_Ncell_r16 = -1;          /* SSB_InfoNcell_r16 */
static int hf_nr_rrc_dl_PRS_r16 = -1;             /* DL_PRS_Info_r16 */
static int hf_nr_rrc_srs_ResourceId = -1;         /* SRS_ResourceId */
static int hf_nr_rrc_nrofSRS_Ports = -1;          /* T_nrofSRS_Ports */
static int hf_nr_rrc_ptrs_PortIndex = -1;         /* T_ptrs_PortIndex */
static int hf_nr_rrc_transmissionComb = -1;       /* T_transmissionComb */
static int hf_nr_rrc_n2_01 = -1;                  /* T_n2 */
static int hf_nr_rrc_combOffset_n2 = -1;          /* INTEGER_0_1 */
static int hf_nr_rrc_cyclicShift_n2 = -1;         /* INTEGER_0_7 */
static int hf_nr_rrc_n4_01 = -1;                  /* T_n4 */
static int hf_nr_rrc_combOffset_n4 = -1;          /* INTEGER_0_3 */
static int hf_nr_rrc_cyclicShift_n4 = -1;         /* INTEGER_0_11 */
static int hf_nr_rrc_resourceMapping_01 = -1;     /* T_resourceMapping */
static int hf_nr_rrc_startPosition = -1;          /* INTEGER_0_5 */
static int hf_nr_rrc_nrofSymbols_02 = -1;         /* T_nrofSymbols */
static int hf_nr_rrc_repetitionFactor = -1;       /* T_repetitionFactor */
static int hf_nr_rrc_freqDomainPosition = -1;     /* INTEGER_0_67 */
static int hf_nr_rrc_freqDomainShift = -1;        /* INTEGER_0_268 */
static int hf_nr_rrc_freqHopping = -1;            /* T_freqHopping */
static int hf_nr_rrc_c_SRS = -1;                  /* INTEGER_0_63 */
static int hf_nr_rrc_b_SRS = -1;                  /* INTEGER_0_3 */
static int hf_nr_rrc_b_hop = -1;                  /* INTEGER_0_3 */
static int hf_nr_rrc_groupOrSequenceHopping = -1;  /* T_groupOrSequenceHopping */
static int hf_nr_rrc_resourceType_02 = -1;        /* T_resourceType_02 */
static int hf_nr_rrc_aperiodic_02 = -1;           /* T_aperiodic_02 */
static int hf_nr_rrc_semi_persistent_01 = -1;     /* T_semi_persistent_01 */
static int hf_nr_rrc_periodicityAndOffset_sp = -1;  /* SRS_PeriodicityAndOffset */
static int hf_nr_rrc_periodic_02 = -1;            /* T_periodic_02 */
static int hf_nr_rrc_periodicityAndOffset_p = -1;  /* SRS_PeriodicityAndOffset */
static int hf_nr_rrc_sequenceId = -1;             /* INTEGER_0_1023 */
static int hf_nr_rrc_spatialRelationInfo = -1;    /* SRS_SpatialRelationInfo */
static int hf_nr_rrc_resourceMapping_r16 = -1;    /* T_resourceMapping_r16 */
static int hf_nr_rrc_nrofSymbols_r16_01 = -1;     /* T_nrofSymbols_r16 */
static int hf_nr_rrc_repetitionFactor_r16 = -1;   /* T_repetitionFactor_r16 */
static int hf_nr_rrc_srs_PosResourceId_r16 = -1;  /* SRS_PosResourceId_r16 */
static int hf_nr_rrc_transmissionComb_r16 = -1;   /* T_transmissionComb_r16 */
static int hf_nr_rrc_n2_r16 = -1;                 /* T_n2_r16 */
static int hf_nr_rrc_combOffset_n2_r16 = -1;      /* INTEGER_0_1 */
static int hf_nr_rrc_cyclicShift_n2_r16 = -1;     /* INTEGER_0_7 */
static int hf_nr_rrc_n4_r16 = -1;                 /* T_n4_r16 */
static int hf_nr_rrc_combOffset_n4_r16 = -1;      /* INTEGER_0_3 */
static int hf_nr_rrc_cyclicShift_n4_r16 = -1;     /* INTEGER_0_11 */
static int hf_nr_rrc_n8_r16 = -1;                 /* T_n8_r16 */
static int hf_nr_rrc_combOffset_n8_r16 = -1;      /* INTEGER_0_7 */
static int hf_nr_rrc_cyclicShift_n8_r16 = -1;     /* INTEGER_0_5 */
static int hf_nr_rrc_resourceMapping_r16_01 = -1;  /* T_resourceMapping_r16_01 */
static int hf_nr_rrc_nrofSymbols_r16_02 = -1;     /* T_nrofSymbols_r16_01 */
static int hf_nr_rrc_freqDomainShift_r16 = -1;    /* INTEGER_0_268 */
static int hf_nr_rrc_freqHopping_r16 = -1;        /* T_freqHopping_r16 */
static int hf_nr_rrc_c_SRS_r16 = -1;              /* INTEGER_0_63 */
static int hf_nr_rrc_groupOrSequenceHopping_r16 = -1;  /* T_groupOrSequenceHopping_r16 */
static int hf_nr_rrc_resourceType_r16_01 = -1;    /* T_resourceType_r16_01 */
static int hf_nr_rrc_aperiodic_r16_01 = -1;       /* T_aperiodic_r16_01 */
static int hf_nr_rrc_slotOffset_r16 = -1;         /* INTEGER_1_32 */
static int hf_nr_rrc_semi_persistent_r16_01 = -1;  /* T_semi_persistent_r16_01 */
static int hf_nr_rrc_periodicityAndOffset_sp_r16 = -1;  /* SRS_PeriodicityAndOffset_r16 */
static int hf_nr_rrc_periodic_r16_01 = -1;        /* T_periodic_r16_01 */
static int hf_nr_rrc_periodicityAndOffset_p_r16 = -1;  /* SRS_PeriodicityAndOffset_r16 */
static int hf_nr_rrc_sequenceId_r16 = -1;         /* INTEGER_0_65535 */
static int hf_nr_rrc_spatialRelationInfoPos_r16 = -1;  /* SRS_SpatialRelationInfoPos_r16 */
static int hf_nr_rrc_referenceSignal_03 = -1;     /* T_referenceSignal_03 */
static int hf_nr_rrc_srs_01 = -1;                 /* T_srs */
static int hf_nr_rrc_resourceId = -1;             /* SRS_ResourceId */
static int hf_nr_rrc_servingRS_r16 = -1;          /* T_servingRS_r16 */
static int hf_nr_rrc_referenceSignal_r16_02 = -1;  /* T_referenceSignal_r16_02 */
static int hf_nr_rrc_csi_RS_IndexServing_r16 = -1;  /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_srs_SpatialRelation_r16 = -1;  /* T_srs_SpatialRelation_r16 */
static int hf_nr_rrc_resourceSelection_r16 = -1;  /* T_resourceSelection_r16 */
static int hf_nr_rrc_uplinkBWP_r16 = -1;          /* BWP_Id */
static int hf_nr_rrc_ssb_Freq_r16 = -1;           /* ARFCN_ValueNR */
static int hf_nr_rrc_halfFrameIndex_r16 = -1;     /* T_halfFrameIndex_r16 */
static int hf_nr_rrc_ssb_Periodicity_r16 = -1;    /* T_ssb_Periodicity_r16 */
static int hf_nr_rrc_sfn0_Offset_r16 = -1;        /* T_sfn0_Offset_r16 */
static int hf_nr_rrc_sfn_Offset_r16 = -1;         /* INTEGER_0_1023 */
static int hf_nr_rrc_integerSubframeOffset_r16 = -1;  /* INTEGER_0_9 */
static int hf_nr_rrc_sfn_SSB_Offset_r16 = -1;     /* INTEGER_0_15 */
static int hf_nr_rrc_ss_PBCH_BlockPower_r16 = -1;  /* INTEGER_M60_50 */
static int hf_nr_rrc_physicalCellId_r16 = -1;     /* PhysCellId */
static int hf_nr_rrc_ssb_IndexNcell_r16 = -1;     /* SSB_Index */
static int hf_nr_rrc_ssb_Configuration_r16 = -1;  /* SSB_Configuration_r16 */
static int hf_nr_rrc_dl_PRS_ID_r16 = -1;          /* INTEGER_0_255 */
static int hf_nr_rrc_dl_PRS_ResourceSetId_r16 = -1;  /* INTEGER_0_7 */
static int hf_nr_rrc_dl_PRS_ResourceId_r16 = -1;  /* INTEGER_0_63 */
static int hf_nr_rrc_sl32 = -1;                   /* INTEGER_0_31 */
static int hf_nr_rrc_sl64 = -1;                   /* INTEGER_0_63 */
static int hf_nr_rrc_sl5120 = -1;                 /* INTEGER_0_5119 */
static int hf_nr_rrc_sl10240 = -1;                /* INTEGER_0_10239 */
static int hf_nr_rrc_sl40960 = -1;                /* INTEGER_0_40959 */
static int hf_nr_rrc_sl81920 = -1;                /* INTEGER_0_81919 */
static int hf_nr_rrc_startingBitOfFormat2_3 = -1;  /* INTEGER_1_31 */
static int hf_nr_rrc_fieldTypeFormat2_3 = -1;     /* INTEGER_0_1 */
static int hf_nr_rrc_startingBitOfFormat2_3SUL = -1;  /* INTEGER_1_31 */
static int hf_nr_rrc_periodicityAndOffset_02 = -1;  /* T_periodicityAndOffset_01 */
static int hf_nr_rrc_sf5 = -1;                    /* INTEGER_0_4 */
static int hf_nr_rrc_sf10 = -1;                   /* INTEGER_0_9 */
static int hf_nr_rrc_sf20 = -1;                   /* INTEGER_0_19 */
static int hf_nr_rrc_sf40 = -1;                   /* INTEGER_0_39 */
static int hf_nr_rrc_sf80 = -1;                   /* INTEGER_0_79 */
static int hf_nr_rrc_sf160 = -1;                  /* INTEGER_0_159 */
static int hf_nr_rrc_duration_02 = -1;            /* T_duration */
static int hf_nr_rrc_pci_List = -1;               /* SEQUENCE_SIZE_1_maxNrofPCIsPerSMTC_OF_PhysCellId */
static int hf_nr_rrc_pci_List_item = -1;          /* PhysCellId */
static int hf_nr_rrc_periodicity_02 = -1;         /* T_periodicity_02 */
static int hf_nr_rrc_periodicity_03 = -1;         /* T_periodicity_03 */
static int hf_nr_rrc_periodicityAndOffset_r16 = -1;  /* T_periodicityAndOffset_r16 */
static int hf_nr_rrc_sf5_r16 = -1;                /* INTEGER_0_4 */
static int hf_nr_rrc_sf10_r16 = -1;               /* INTEGER_0_9 */
static int hf_nr_rrc_sf20_r16 = -1;               /* INTEGER_0_19 */
static int hf_nr_rrc_sf40_r16 = -1;               /* INTEGER_0_39 */
static int hf_nr_rrc_sf80_r16 = -1;               /* INTEGER_0_79 */
static int hf_nr_rrc_sf160_r16 = -1;              /* INTEGER_0_159 */
static int hf_nr_rrc_sf320_r16 = -1;              /* INTEGER_0_319 */
static int hf_nr_rrc_sf640_r16 = -1;              /* INTEGER_0_639 */
static int hf_nr_rrc_sf1280_r16 = -1;             /* INTEGER_0_1279 */
static int hf_nr_rrc_duration_r16_01 = -1;        /* T_duration_r16 */
static int hf_nr_rrc_pci_List_r16 = -1;           /* SEQUENCE_SIZE_1_maxNrofPCIsPerSMTC_OF_PhysCellId */
static int hf_nr_rrc_pci_List_r16_item = -1;      /* PhysCellId */
static int hf_nr_rrc_ssb_ToMeasure_r16_01 = -1;   /* T_ssb_ToMeasure_r16 */
static int hf_nr_rrc_measurementSlots = -1;       /* BIT_STRING_SIZE_1_80 */
static int hf_nr_rrc_endSymbol = -1;              /* INTEGER_0_3 */
static int hf_nr_rrc_tag_ToReleaseList = -1;      /* SEQUENCE_SIZE_1_maxNrofTAGs_OF_TAG_Id */
static int hf_nr_rrc_tag_ToReleaseList_item = -1;  /* TAG_Id */
static int hf_nr_rrc_tag_ToAddModList = -1;       /* SEQUENCE_SIZE_1_maxNrofTAGs_OF_TAG */
static int hf_nr_rrc_tag_ToAddModList_item = -1;  /* TAG */
static int hf_nr_rrc_timeAlignmentTimer = -1;     /* TimeAlignmentTimer */
static int hf_nr_rrc_tci_StateId = -1;            /* TCI_StateId */
static int hf_nr_rrc_qcl_Type1 = -1;              /* QCL_Info */
static int hf_nr_rrc_qcl_Type2 = -1;              /* QCL_Info */
static int hf_nr_rrc_cell = -1;                   /* ServCellIndex */
static int hf_nr_rrc_referenceSignal_04 = -1;     /* T_referenceSignal_04 */
static int hf_nr_rrc_csi_rs = -1;                 /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_qcl_Type = -1;               /* T_qcl_Type */
static int hf_nr_rrc_referenceSubcarrierSpacing = -1;  /* SubcarrierSpacing */
static int hf_nr_rrc_pattern1_01 = -1;            /* TDD_UL_DL_Pattern */
static int hf_nr_rrc_pattern2 = -1;               /* TDD_UL_DL_Pattern */
static int hf_nr_rrc_dl_UL_TransmissionPeriodicity = -1;  /* T_dl_UL_TransmissionPeriodicity */
static int hf_nr_rrc_nrofDownlinkSlots = -1;      /* INTEGER_0_maxNrofSlots */
static int hf_nr_rrc_nrofDownlinkSymbols = -1;    /* INTEGER_0_maxNrofSymbols_1 */
static int hf_nr_rrc_nrofUplinkSlots = -1;        /* INTEGER_0_maxNrofSlots */
static int hf_nr_rrc_nrofUplinkSymbols = -1;      /* INTEGER_0_maxNrofSymbols_1 */
static int hf_nr_rrc_dl_UL_TransmissionPeriodicity_v1530 = -1;  /* T_dl_UL_TransmissionPeriodicity_v1530 */
static int hf_nr_rrc_slotSpecificConfigurationsToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofSlots_OF_TDD_UL_DL_SlotConfig */
static int hf_nr_rrc_slotSpecificConfigurationsToAddModList_item = -1;  /* TDD_UL_DL_SlotConfig */
static int hf_nr_rrc_slotSpecificConfigurationsToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofSlots_OF_TDD_UL_DL_SlotIndex */
static int hf_nr_rrc_slotSpecificConfigurationsToReleaseList_item = -1;  /* TDD_UL_DL_SlotIndex */
static int hf_nr_rrc_slotSpecificConfigurationsToAddModList_IAB_MT_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofSlots_OF_TDD_UL_DL_SlotConfig_IAB_MT_r16 */
static int hf_nr_rrc_slotSpecificConfigurationsToAddModList_IAB_MT_r16_item = -1;  /* TDD_UL_DL_SlotConfig_IAB_MT_r16 */
static int hf_nr_rrc_slotSpecificConfigurationsToReleaseList_IAB_MT_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofSlots_OF_TDD_UL_DL_SlotIndex */
static int hf_nr_rrc_slotSpecificConfigurationsToReleaseList_IAB_MT_r16_item = -1;  /* TDD_UL_DL_SlotIndex */
static int hf_nr_rrc_slotIndex = -1;              /* TDD_UL_DL_SlotIndex */
static int hf_nr_rrc_symbols = -1;                /* T_symbols */
static int hf_nr_rrc_allDownlink = -1;            /* NULL */
static int hf_nr_rrc_allUplink = -1;              /* NULL */
static int hf_nr_rrc_explicit = -1;               /* T_explicit */
static int hf_nr_rrc_nrofDownlinkSymbols_01 = -1;  /* INTEGER_1_maxNrofSymbols_1 */
static int hf_nr_rrc_nrofUplinkSymbols_01 = -1;   /* INTEGER_1_maxNrofSymbols_1 */
static int hf_nr_rrc_slotIndex_r16 = -1;          /* TDD_UL_DL_SlotIndex */
static int hf_nr_rrc_symbols_IAB_MT_r16 = -1;     /* T_symbols_IAB_MT_r16 */
static int hf_nr_rrc_allDownlink_r16 = -1;        /* NULL */
static int hf_nr_rrc_allUplink_r16 = -1;          /* NULL */
static int hf_nr_rrc_explicit_r16 = -1;           /* T_explicit_r16 */
static int hf_nr_rrc_nrofDownlinkSymbols_r16 = -1;  /* INTEGER_1_maxNrofSymbols_1 */
static int hf_nr_rrc_nrofUplinkSymbols_r16 = -1;  /* INTEGER_1_maxNrofSymbols_1 */
static int hf_nr_rrc_explicit_IAB_MT_r16 = -1;    /* T_explicit_IAB_MT_r16 */
static int hf_nr_rrc_UAC_BarringInfoSetList_item = -1;  /* UAC_BarringInfoSet */
static int hf_nr_rrc_uac_BarringFactor = -1;      /* T_uac_BarringFactor */
static int hf_nr_rrc_uac_BarringTime = -1;        /* T_uac_BarringTime */
static int hf_nr_rrc_uac_BarringForAccessIdentity = -1;  /* BIT_STRING_SIZE_7 */
static int hf_nr_rrc_UAC_BarringPerCatList_item = -1;  /* UAC_BarringPerCat */
static int hf_nr_rrc_accessCategory = -1;         /* INTEGER_1_maxAccessCat_1 */
static int hf_nr_rrc_uac_barringInfoSetIndex = -1;  /* UAC_BarringInfoSetIndex */
static int hf_nr_rrc_UAC_BarringPerPLMN_List_item = -1;  /* UAC_BarringPerPLMN */
static int hf_nr_rrc_plmn_IdentityIndex = -1;     /* INTEGER_1_maxPLMN */
static int hf_nr_rrc_uac_ACBarringListType = -1;  /* T_uac_ACBarringListType */
static int hf_nr_rrc_uac_ImplicitACBarringList = -1;  /* SEQUENCE_SIZE_maxAccessCat_1_OF_UAC_BarringInfoSetIndex */
static int hf_nr_rrc_uac_ImplicitACBarringList_item = -1;  /* UAC_BarringInfoSetIndex */
static int hf_nr_rrc_uac_ExplicitACBarringList = -1;  /* UAC_BarringPerCatList */
static int hf_nr_rrc_t300 = -1;                   /* T_t300 */
static int hf_nr_rrc_t301 = -1;                   /* T_t301 */
static int hf_nr_rrc_t310_01 = -1;                /* T_t310_01 */
static int hf_nr_rrc_n310_01 = -1;                /* T_n310_01 */
static int hf_nr_rrc_t311_01 = -1;                /* T_t311_01 */
static int hf_nr_rrc_n311_01 = -1;                /* T_n311_01 */
static int hf_nr_rrc_t319 = -1;                   /* T_t319 */
static int hf_nr_rrc_delay_DRBlist = -1;          /* SEQUENCE_SIZE_1_maxDRB_OF_DRB_Identity */
static int hf_nr_rrc_delay_DRBlist_item = -1;     /* DRB_Identity */
static int hf_nr_rrc_ci_RNTI_r16 = -1;            /* RNTI_Value */
static int hf_nr_rrc_dci_PayloadSizeForCI_r16 = -1;  /* INTEGER_0_maxCI_DCI_PayloadSize_r16 */
static int hf_nr_rrc_ci_ConfigurationPerServingCell_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofServingCells_OF_CI_ConfigurationPerServingCell_r16 */
static int hf_nr_rrc_ci_ConfigurationPerServingCell_r16_item = -1;  /* CI_ConfigurationPerServingCell_r16 */
static int hf_nr_rrc_positionInDCI_r16_01 = -1;   /* INTEGER_0_maxCI_DCI_PayloadSize_1_r16 */
static int hf_nr_rrc_positionInDCI_ForSUL_r16 = -1;  /* INTEGER_0_maxCI_DCI_PayloadSize_1_r16 */
static int hf_nr_rrc_ci_PayloadSize_r16 = -1;     /* T_ci_PayloadSize_r16 */
static int hf_nr_rrc_timeFrequencyRegion_r16 = -1;  /* T_timeFrequencyRegion_r16 */
static int hf_nr_rrc_timeDurationForCI_r16 = -1;  /* T_timeDurationForCI_r16 */
static int hf_nr_rrc_timeGranularityForCI_r16 = -1;  /* T_timeGranularityForCI_r16 */
static int hf_nr_rrc_frequencyRegionForCI_r16 = -1;  /* INTEGER_0_37949 */
static int hf_nr_rrc_deltaOffset_r16 = -1;        /* INTEGER_0_2 */
static int hf_nr_rrc_uplinkCancellationPriority_v1610 = -1;  /* T_uplinkCancellationPriority_v1610 */
static int hf_nr_rrc_frequencyInfoUL = -1;        /* FrequencyInfoUL */
static int hf_nr_rrc_initialUplinkBWP_01 = -1;    /* BWP_UplinkCommon */
static int hf_nr_rrc_uplinkConfigCommon_dummy = -1;  /* TimeAlignmentTimer */
static int hf_nr_rrc_frequencyInfoUL_01 = -1;     /* FrequencyInfoUL_SIB */
static int hf_nr_rrc_timeAlignmentTimerCommon = -1;  /* TimeAlignmentTimer */
static int hf_nr_rrc_UplinkTxDirectCurrentList_item = -1;  /* UplinkTxDirectCurrentCell */
static int hf_nr_rrc_uplinkDirectCurrentBWP = -1;  /* SEQUENCE_SIZE_1_maxNrofBWPs_OF_UplinkTxDirectCurrentBWP */
static int hf_nr_rrc_uplinkDirectCurrentBWP_item = -1;  /* UplinkTxDirectCurrentBWP */
static int hf_nr_rrc_uplinkDirectCurrentBWP_SUL = -1;  /* SEQUENCE_SIZE_1_maxNrofBWPs_OF_UplinkTxDirectCurrentBWP */
static int hf_nr_rrc_uplinkDirectCurrentBWP_SUL_item = -1;  /* UplinkTxDirectCurrentBWP */
static int hf_nr_rrc_shift7dot5kHz = -1;          /* BOOLEAN */
static int hf_nr_rrc_txDirectCurrentLocation_01 = -1;  /* INTEGER_0_3301 */
static int hf_nr_rrc_UplinkTxDirectCurrentTwoCarrierList_r16_item = -1;  /* UplinkTxDirectCurrentTwoCarrier_r16 */
static int hf_nr_rrc_carrierOneInfo_r16 = -1;     /* UplinkTxDirectCurrentCarrierInfo_r16 */
static int hf_nr_rrc_carrierTwoInfo_r16 = -1;     /* UplinkTxDirectCurrentCarrierInfo_r16 */
static int hf_nr_rrc_singlePA_TxDirectCurrent_r16 = -1;  /* UplinkTxDirectCurrentTwoCarrierInfo_r16 */
static int hf_nr_rrc_secondPA_TxDirectCurrent_r16 = -1;  /* UplinkTxDirectCurrentTwoCarrierInfo_r16 */
static int hf_nr_rrc_servCellIndex_r16 = -1;      /* ServCellIndex */
static int hf_nr_rrc_servCellInfo_r16 = -1;       /* T_servCellInfo_r16 */
static int hf_nr_rrc_bwp_Id_r16 = -1;             /* BWP_Id */
static int hf_nr_rrc_deactivatedCarrier_r16 = -1;  /* T_deactivatedCarrier_r16 */
static int hf_nr_rrc_referenceCarrierIndex_r16 = -1;  /* ServCellIndex */
static int hf_nr_rrc_shift7dot5kHz_r16 = -1;      /* BOOLEAN */
static int hf_nr_rrc_txDirectCurrentLocation_r16 = -1;  /* INTEGER_0_3301 */
static int hf_nr_rrc_zp_CSI_RS_ResourceId = -1;   /* ZP_CSI_RS_ResourceId */
static int hf_nr_rrc_zp_CSI_RS_ResourceSetId = -1;  /* ZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_zp_CSI_RS_ResourceIdList = -1;  /* SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_ResourcesPerSet_OF_ZP_CSI_RS_ResourceId */
static int hf_nr_rrc_zp_CSI_RS_ResourceIdList_item = -1;  /* ZP_CSI_RS_ResourceId */
static int hf_nr_rrc_BandCombinationList_item = -1;  /* BandCombination */
static int hf_nr_rrc_BandCombinationList_v1540_item = -1;  /* BandCombination_v1540 */
static int hf_nr_rrc_BandCombinationList_v1550_item = -1;  /* BandCombination_v1550 */
static int hf_nr_rrc_BandCombinationList_v1560_item = -1;  /* BandCombination_v1560 */
static int hf_nr_rrc_BandCombinationList_v1570_item = -1;  /* BandCombination_v1570 */
static int hf_nr_rrc_BandCombinationList_v1580_item = -1;  /* BandCombination_v1580 */
static int hf_nr_rrc_BandCombinationList_v1590_item = -1;  /* BandCombination_v1590 */
static int hf_nr_rrc_BandCombinationList_v15g0_item = -1;  /* BandCombination_v15g0 */
static int hf_nr_rrc_BandCombinationList_v1610_item = -1;  /* BandCombination_v1610 */
static int hf_nr_rrc_BandCombinationList_v1630_item = -1;  /* BandCombination_v1630 */
static int hf_nr_rrc_BandCombinationList_v1640_item = -1;  /* BandCombination_v1640 */
static int hf_nr_rrc_BandCombinationList_v1650_item = -1;  /* BandCombination_v1650 */
static int hf_nr_rrc_BandCombinationList_v1680_item = -1;  /* BandCombination_v1680 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_r16_item = -1;  /* BandCombination_UplinkTxSwitch_r16 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_v1630_item = -1;  /* BandCombination_UplinkTxSwitch_v1630 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_v1640_item = -1;  /* BandCombination_UplinkTxSwitch_v1640 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_v1650_item = -1;  /* BandCombination_UplinkTxSwitch_v1650 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_v1670_item = -1;  /* BandCombination_UplinkTxSwitch_v1670 */
static int hf_nr_rrc_bandList = -1;               /* SEQUENCE_SIZE_1_maxSimultaneousBands_OF_BandParameters */
static int hf_nr_rrc_bandList_item = -1;          /* BandParameters */
static int hf_nr_rrc_featureSetCombination = -1;  /* FeatureSetCombinationId */
static int hf_nr_rrc_ca_ParametersEUTRA = -1;     /* CA_ParametersEUTRA */
static int hf_nr_rrc_ca_ParametersNR = -1;        /* CA_ParametersNR */
static int hf_nr_rrc_mrdc_Parameters = -1;        /* MRDC_Parameters */
static int hf_nr_rrc_supportedBandwidthCombinationSet = -1;  /* BIT_STRING_SIZE_1_32 */
static int hf_nr_rrc_powerClass_v1530 = -1;       /* T_powerClass_v1530 */
static int hf_nr_rrc_bandList_v1540 = -1;         /* SEQUENCE_SIZE_1_maxSimultaneousBands_OF_BandParameters_v1540 */
static int hf_nr_rrc_bandList_v1540_item = -1;    /* BandParameters_v1540 */
static int hf_nr_rrc_ca_ParametersNR_v1540 = -1;  /* CA_ParametersNR_v1540 */
static int hf_nr_rrc_ca_ParametersNR_v1550 = -1;  /* CA_ParametersNR_v1550 */
static int hf_nr_rrc_ne_DC_BC = -1;               /* T_ne_DC_BC */
static int hf_nr_rrc_ca_ParametersNRDC = -1;      /* CA_ParametersNRDC */
static int hf_nr_rrc_ca_ParametersEUTRA_v1560 = -1;  /* CA_ParametersEUTRA_v1560 */
static int hf_nr_rrc_ca_ParametersNR_v1560 = -1;  /* CA_ParametersNR_v1560 */
static int hf_nr_rrc_ca_ParametersEUTRA_v1570 = -1;  /* CA_ParametersEUTRA_v1570 */
static int hf_nr_rrc_mrdc_Parameters_v1580 = -1;  /* MRDC_Parameters_v1580 */
static int hf_nr_rrc_supportedBandwidthCombinationSetIntraENDC = -1;  /* BIT_STRING_SIZE_1_32 */
static int hf_nr_rrc_mrdc_Parameters_v1590 = -1;  /* MRDC_Parameters_v1590 */
static int hf_nr_rrc_ca_ParametersNR_v15g0 = -1;  /* CA_ParametersNR_v15g0 */
static int hf_nr_rrc_ca_ParametersNRDC_v15g0 = -1;  /* CA_ParametersNRDC_v15g0 */
static int hf_nr_rrc_mrdc_Parameters_v15g0 = -1;  /* MRDC_Parameters_v15g0 */
static int hf_nr_rrc_bandList_v1610 = -1;         /* SEQUENCE_SIZE_1_maxSimultaneousBands_OF_BandParameters_v1610 */
static int hf_nr_rrc_bandList_v1610_item = -1;    /* BandParameters_v1610 */
static int hf_nr_rrc_ca_ParametersNR_v1610 = -1;  /* CA_ParametersNR_v1610 */
static int hf_nr_rrc_ca_ParametersNRDC_v1610 = -1;  /* CA_ParametersNRDC_v1610 */
static int hf_nr_rrc_powerClass_v1610 = -1;       /* T_powerClass_v1610 */
static int hf_nr_rrc_powerClassNRPart_r16 = -1;   /* T_powerClassNRPart_r16 */
static int hf_nr_rrc_featureSetCombinationDAPS_r16 = -1;  /* FeatureSetCombinationId */
static int hf_nr_rrc_mrdc_Parameters_v1620 = -1;  /* MRDC_Parameters_v1620 */
static int hf_nr_rrc_ca_ParametersNR_v1630 = -1;  /* CA_ParametersNR_v1630 */
static int hf_nr_rrc_ca_ParametersNRDC_v1630 = -1;  /* CA_ParametersNRDC_v1630 */
static int hf_nr_rrc_mrdc_Parameters_v1630 = -1;  /* MRDC_Parameters_v1630 */
static int hf_nr_rrc_supportedTxBandCombListPerBC_Sidelink_r16 = -1;  /* BIT_STRING_SIZE_1_maxBandComb */
static int hf_nr_rrc_supportedRxBandCombListPerBC_Sidelink_r16 = -1;  /* BIT_STRING_SIZE_1_maxBandComb */
static int hf_nr_rrc_scalingFactorTxSidelink_r16 = -1;  /* SEQUENCE_SIZE_1_maxBandComb_OF_ScalingFactorSidelink_r16 */
static int hf_nr_rrc_scalingFactorTxSidelink_r16_item = -1;  /* ScalingFactorSidelink_r16 */
static int hf_nr_rrc_scalingFactorRxSidelink_r16 = -1;  /* SEQUENCE_SIZE_1_maxBandComb_OF_ScalingFactorSidelink_r16 */
static int hf_nr_rrc_scalingFactorRxSidelink_r16_item = -1;  /* ScalingFactorSidelink_r16 */
static int hf_nr_rrc_ca_ParametersNR_v1640 = -1;  /* CA_ParametersNR_v1640 */
static int hf_nr_rrc_ca_ParametersNRDC_v1640 = -1;  /* CA_ParametersNRDC_v1640 */
static int hf_nr_rrc_ca_ParametersNRDC_v1650 = -1;  /* CA_ParametersNRDC_v1650 */
static int hf_nr_rrc_intrabandConcurrentOperationPowerClass_r16 = -1;  /* SEQUENCE_SIZE_1_maxBandComb_OF_IntraBandPowerClass_r16 */
static int hf_nr_rrc_intrabandConcurrentOperationPowerClass_r16_item = -1;  /* IntraBandPowerClass_r16 */
static int hf_nr_rrc_bandCombination_r16 = -1;    /* BandCombination */
static int hf_nr_rrc_bandCombination_v1540 = -1;  /* BandCombination_v1540 */
static int hf_nr_rrc_bandCombination_v1560 = -1;  /* BandCombination_v1560 */
static int hf_nr_rrc_bandCombination_v1570 = -1;  /* BandCombination_v1570 */
static int hf_nr_rrc_bandCombination_v1580 = -1;  /* BandCombination_v1580 */
static int hf_nr_rrc_bandCombination_v1590 = -1;  /* BandCombination_v1590 */
static int hf_nr_rrc_bandCombination_v1610 = -1;  /* BandCombination_v1610 */
static int hf_nr_rrc_supportedBandPairListNR_r16 = -1;  /* SEQUENCE_SIZE_1_maxULTxSwitchingBandPairs_OF_ULTxSwitchingBandPair_r16 */
static int hf_nr_rrc_supportedBandPairListNR_r16_item = -1;  /* ULTxSwitchingBandPair_r16 */
static int hf_nr_rrc_uplinkTxSwitching_OptionSupport_r16 = -1;  /* T_uplinkTxSwitching_OptionSupport_r16 */
static int hf_nr_rrc_uplinkTxSwitching_PowerBoosting_r16 = -1;  /* T_uplinkTxSwitching_PowerBoosting_r16 */
static int hf_nr_rrc_uplinkTxSwitching_PUSCH_TransCoherence_r16 = -1;  /* T_uplinkTxSwitching_PUSCH_TransCoherence_r16 */
static int hf_nr_rrc_bandCombination_v1630 = -1;  /* BandCombination_v1630 */
static int hf_nr_rrc_bandCombination_v1640 = -1;  /* BandCombination_v1640 */
static int hf_nr_rrc_bandCombination_v1650 = -1;  /* BandCombination_v1650 */
static int hf_nr_rrc_bandCombination_v15g0 = -1;  /* BandCombination_v15g0 */
static int hf_nr_rrc_bandIndexUL1_r16 = -1;       /* INTEGER_1_maxSimultaneousBands */
static int hf_nr_rrc_bandIndexUL2_r16 = -1;       /* INTEGER_1_maxSimultaneousBands */
static int hf_nr_rrc_uplinkTxSwitchingPeriod_r16 = -1;  /* T_uplinkTxSwitchingPeriod_r16 */
static int hf_nr_rrc_uplinkTxSwitching_DL_Interruption_r16 = -1;  /* BIT_STRING_SIZE_1_maxSimultaneousBands */
static int hf_nr_rrc_eutra_01 = -1;               /* T_eutra */
static int hf_nr_rrc_bandEUTRA = -1;              /* FreqBandIndicatorEUTRA */
static int hf_nr_rrc_ca_BandwidthClassDL_EUTRA = -1;  /* CA_BandwidthClassEUTRA */
static int hf_nr_rrc_ca_BandwidthClassUL_EUTRA = -1;  /* CA_BandwidthClassEUTRA */
static int hf_nr_rrc_nr_01 = -1;                  /* T_nr */
static int hf_nr_rrc_bandNR = -1;                 /* FreqBandIndicatorNR */
static int hf_nr_rrc_ca_BandwidthClassDL_NR = -1;  /* CA_BandwidthClassNR */
static int hf_nr_rrc_ca_BandwidthClassUL_NR = -1;  /* CA_BandwidthClassNR */
static int hf_nr_rrc_srs_CarrierSwitch = -1;      /* T_srs_CarrierSwitch */
static int hf_nr_rrc_nr_02 = -1;                  /* T_nr_01 */
static int hf_nr_rrc_srs_SwitchingTimesListNR = -1;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_OF_SRS_SwitchingTimeNR */
static int hf_nr_rrc_srs_SwitchingTimesListNR_item = -1;  /* SRS_SwitchingTimeNR */
static int hf_nr_rrc_eutra_02 = -1;               /* T_eutra_01 */
static int hf_nr_rrc_srs_SwitchingTimesListEUTRA = -1;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_OF_SRS_SwitchingTimeEUTRA */
static int hf_nr_rrc_srs_SwitchingTimesListEUTRA_item = -1;  /* SRS_SwitchingTimeEUTRA */
static int hf_nr_rrc_srs_TxSwitch = -1;           /* T_srs_TxSwitch */
static int hf_nr_rrc_supportedSRS_TxPortSwitch = -1;  /* T_supportedSRS_TxPortSwitch */
static int hf_nr_rrc_txSwitchImpactToRx = -1;     /* INTEGER_1_32 */
static int hf_nr_rrc_txSwitchWithAnotherBand = -1;  /* INTEGER_1_32 */
static int hf_nr_rrc_srs_TxSwitch_v1610 = -1;     /* T_srs_TxSwitch_v1610 */
static int hf_nr_rrc_supportedSRS_TxPortSwitch_v1610 = -1;  /* T_supportedSRS_TxPortSwitch_v1610 */
static int hf_nr_rrc_BandCombinationListSidelinkEUTRA_NR_r16_item = -1;  /* BandCombinationParametersSidelinkEUTRA_NR_r16 */
static int hf_nr_rrc_BandCombinationListSidelinkEUTRA_NR_v1630_item = -1;  /* BandCombinationParametersSidelinkEUTRA_NR_v1630 */
static int hf_nr_rrc_BandCombinationParametersSidelinkEUTRA_NR_r16_item = -1;  /* BandParametersSidelinkEUTRA_NR_r16 */
static int hf_nr_rrc_BandCombinationParametersSidelinkEUTRA_NR_v1630_item = -1;  /* BandParametersSidelinkEUTRA_NR_v1630 */
static int hf_nr_rrc_eutra_03 = -1;               /* T_eutra_02 */
static int hf_nr_rrc_bandParametersSidelinkEUTRA1_r16 = -1;  /* T_bandParametersSidelinkEUTRA1_r16 */
static int hf_nr_rrc_bandParametersSidelinkEUTRA2_r16 = -1;  /* T_bandParametersSidelinkEUTRA2_r16 */
static int hf_nr_rrc_nr_03 = -1;                  /* T_nr_02 */
static int hf_nr_rrc_bandParametersSidelinkNR_r16 = -1;  /* BandParametersSidelink_r16 */
static int hf_nr_rrc_eutra_04 = -1;               /* NULL */
static int hf_nr_rrc_nr_04 = -1;                  /* T_nr_03 */
static int hf_nr_rrc_tx_Sidelink_r16 = -1;        /* T_tx_Sidelink_r16 */
static int hf_nr_rrc_rx_Sidelink_r16 = -1;        /* T_rx_Sidelink_r16 */
static int hf_nr_rrc_sl_CrossCarrierScheduling_r16 = -1;  /* T_sl_CrossCarrierScheduling_r16 */
static int hf_nr_rrc_freqBandSidelink_r16 = -1;   /* FreqBandIndicatorNR */
static int hf_nr_rrc_multipleTimingAdvance = -1;  /* T_multipleTimingAdvance */
static int hf_nr_rrc_simultaneousRx_Tx = -1;      /* T_simultaneousRx_Tx */
static int hf_nr_rrc_supportedNAICS_2CRS_AP = -1;  /* BIT_STRING_SIZE_1_8 */
static int hf_nr_rrc_additionalRx_Tx_PerformanceReq = -1;  /* T_additionalRx_Tx_PerformanceReq */
static int hf_nr_rrc_ue_CA_PowerClass_N = -1;     /* T_ue_CA_PowerClass_N */
static int hf_nr_rrc_supportedBandwidthCombinationSetEUTRA_v1530 = -1;  /* BIT_STRING_SIZE_1_32 */
static int hf_nr_rrc_fd_MIMO_TotalWeightedLayers = -1;  /* INTEGER_2_128 */
static int hf_nr_rrc_dl_1024QAM_TotalWeightedLayers = -1;  /* INTEGER_0_10 */
static int hf_nr_rrc_cA_ParametersNR_dummy = -1;  /* T_cA_ParametersNR_dummy */
static int hf_nr_rrc_parallelTxSRS_PUCCH_PUSCH = -1;  /* T_parallelTxSRS_PUCCH_PUSCH */
static int hf_nr_rrc_parallelTxPRACH_SRS_PUCCH_PUSCH = -1;  /* T_parallelTxPRACH_SRS_PUCCH_PUSCH */
static int hf_nr_rrc_simultaneousRxTxInterBandCA = -1;  /* T_simultaneousRxTxInterBandCA */
static int hf_nr_rrc_simultaneousRxTxSUL = -1;    /* T_simultaneousRxTxSUL */
static int hf_nr_rrc_diffNumerologyAcrossPUCCH_Group = -1;  /* T_diffNumerologyAcrossPUCCH_Group */
static int hf_nr_rrc_diffNumerologyWithinPUCCH_GroupSmallerSCS = -1;  /* T_diffNumerologyWithinPUCCH_GroupSmallerSCS */
static int hf_nr_rrc_supportedNumberTAG = -1;     /* T_supportedNumberTAG */
static int hf_nr_rrc_simultaneousSRS_AssocCSI_RS_AllCC = -1;  /* INTEGER_5_32 */
static int hf_nr_rrc_csi_RS_IM_ReceptionForFeedbackPerBandComb = -1;  /* T_csi_RS_IM_ReceptionForFeedbackPerBandComb */
static int hf_nr_rrc_maxNumberSimultaneousNZP_CSI_RS_ActBWP_AllCC = -1;  /* INTEGER_1_64 */
static int hf_nr_rrc_totalNumberPortsSimultaneousNZP_CSI_RS_ActBWP_AllCC = -1;  /* INTEGER_2_256 */
static int hf_nr_rrc_simultaneousCSI_ReportsAllCC = -1;  /* INTEGER_5_32 */
static int hf_nr_rrc_dualPA_Architecture = -1;    /* T_dualPA_Architecture */
static int hf_nr_rrc_cA_ParametersNR_v1550_dummy = -1;  /* T_cA_ParametersNR_v1550_dummy */
static int hf_nr_rrc_diffNumerologyWithinPUCCH_GroupLargerSCS = -1;  /* T_diffNumerologyWithinPUCCH_GroupLargerSCS */
static int hf_nr_rrc_simultaneousRxTxInterBandCAPerBandPair = -1;  /* SimultaneousRxTxPerBandPair */
static int hf_nr_rrc_simultaneousRxTxSULPerBandPair = -1;  /* SimultaneousRxTxPerBandPair */
static int hf_nr_rrc_parallelTxMsgA_SRS_PUCCH_PUSCH_r16 = -1;  /* T_parallelTxMsgA_SRS_PUCCH_PUSCH_r16 */
static int hf_nr_rrc_msgA_SUL_r16 = -1;           /* T_msgA_SUL_r16 */
static int hf_nr_rrc_jointSearchSpaceSwitchAcrossCells_r16 = -1;  /* T_jointSearchSpaceSwitchAcrossCells_r16 */
static int hf_nr_rrc_half_DuplexTDD_CA_SameSCS_r16 = -1;  /* T_half_DuplexTDD_CA_SameSCS_r16 */
static int hf_nr_rrc_scellDormancyWithinActiveTime_r16 = -1;  /* T_scellDormancyWithinActiveTime_r16 */
static int hf_nr_rrc_scellDormancyOutsideActiveTime_r16 = -1;  /* T_scellDormancyOutsideActiveTime_r16 */
static int hf_nr_rrc_crossCarrierA_CSI_trigDiffSCS_r16 = -1;  /* T_crossCarrierA_CSI_trigDiffSCS_r16 */
static int hf_nr_rrc_defaultQCL_CrossCarrierA_CSI_Trig_r16 = -1;  /* T_defaultQCL_CrossCarrierA_CSI_Trig_r16 */
static int hf_nr_rrc_interCA_NonAlignedFrame_r16 = -1;  /* T_interCA_NonAlignedFrame_r16 */
static int hf_nr_rrc_simul_SRS_Trans_BC_r16 = -1;  /* T_simul_SRS_Trans_BC_r16 */
static int hf_nr_rrc_interFreqDAPS_r16 = -1;      /* T_interFreqDAPS_r16 */
static int hf_nr_rrc_interFreqAsyncDAPS_r16 = -1;  /* T_interFreqAsyncDAPS_r16 */
static int hf_nr_rrc_interFreqDiffSCS_DAPS_r16 = -1;  /* T_interFreqDiffSCS_DAPS_r16 */
static int hf_nr_rrc_interFreqMultiUL_TransmissionDAPS_r16 = -1;  /* T_interFreqMultiUL_TransmissionDAPS_r16 */
static int hf_nr_rrc_interFreqSemiStaticPowerSharingDAPS_Mode1_r16 = -1;  /* T_interFreqSemiStaticPowerSharingDAPS_Mode1_r16 */
static int hf_nr_rrc_interFreqSemiStaticPowerSharingDAPS_Mode2_r16 = -1;  /* T_interFreqSemiStaticPowerSharingDAPS_Mode2_r16 */
static int hf_nr_rrc_interFreqDynamicPowerSharingDAPS_r16 = -1;  /* T_interFreqDynamicPowerSharingDAPS_r16 */
static int hf_nr_rrc_interFreqUL_TransCancellationDAPS_r16 = -1;  /* T_interFreqUL_TransCancellationDAPS_r16 */
static int hf_nr_rrc_codebookParametersPerBC_r16 = -1;  /* CodebookParameters_v1610 */
static int hf_nr_rrc_blindDetectFactor_r16 = -1;  /* INTEGER_1_2 */
static int hf_nr_rrc_pdcch_MonitoringCA_r16 = -1;  /* T_pdcch_MonitoringCA_r16 */
static int hf_nr_rrc_maxNumberOfMonitoringCC_r16 = -1;  /* INTEGER_2_16 */
static int hf_nr_rrc_supportedSpanArrangement_r16 = -1;  /* T_supportedSpanArrangement_r16 */
static int hf_nr_rrc_pdcch_BlindDetectionCA_Mixed_r16 = -1;  /* T_pdcch_BlindDetectionCA_Mixed_r16 */
static int hf_nr_rrc_supportedSpanArrangement_r16_01 = -1;  /* T_supportedSpanArrangement_r16_01 */
static int hf_nr_rrc_pdcch_BlindDetectionMCG_UE_r16 = -1;  /* INTEGER_1_14 */
static int hf_nr_rrc_pdcch_BlindDetectionSCG_UE_r16 = -1;  /* INTEGER_1_14 */
static int hf_nr_rrc_pdcch_BlindDetectionMCG_UE_Mixed_r16 = -1;  /* T_pdcch_BlindDetectionMCG_UE_Mixed_r16 */
static int hf_nr_rrc_pdcch_BlindDetectionMCG_UE1_r16 = -1;  /* INTEGER_0_15 */
static int hf_nr_rrc_pdcch_BlindDetectionMCG_UE2_r16 = -1;  /* INTEGER_0_15 */
static int hf_nr_rrc_pdcch_BlindDetectionSCG_UE_Mixed_r16 = -1;  /* T_pdcch_BlindDetectionSCG_UE_Mixed_r16 */
static int hf_nr_rrc_pdcch_BlindDetectionSCG_UE1_r16 = -1;  /* INTEGER_0_15 */
static int hf_nr_rrc_pdcch_BlindDetectionSCG_UE2_r16 = -1;  /* INTEGER_0_15 */
static int hf_nr_rrc_crossCarrierSchedulingDL_DiffSCS_r16 = -1;  /* T_crossCarrierSchedulingDL_DiffSCS_r16 */
static int hf_nr_rrc_crossCarrierSchedulingDefaultQCL_r16 = -1;  /* T_crossCarrierSchedulingDefaultQCL_r16 */
static int hf_nr_rrc_crossCarrierSchedulingUL_DiffSCS_r16 = -1;  /* T_crossCarrierSchedulingUL_DiffSCS_r16 */
static int hf_nr_rrc_simul_SRS_MIMO_Trans_BC_r16 = -1;  /* T_simul_SRS_MIMO_Trans_BC_r16 */
static int hf_nr_rrc_codebookParametersAdditionPerBC_r16 = -1;  /* CodebookParametersAdditionPerBC_r16 */
static int hf_nr_rrc_codebookComboParametersAdditionPerBC_r16 = -1;  /* CodebookComboParametersAdditionPerBC_r16 */
static int hf_nr_rrc_simulTX_SRS_AntSwitchingInterBandUL_CA_r16 = -1;  /* SimulSRS_ForAntennaSwitching_r16 */
static int hf_nr_rrc_beamManagementType_r16 = -1;  /* T_beamManagementType_r16 */
static int hf_nr_rrc_intraBandFreqSeparationUL_AggBW_GapBW_r16 = -1;  /* T_intraBandFreqSeparationUL_AggBW_GapBW_r16 */
static int hf_nr_rrc_interCA_NonAlignedFrame_B_r16 = -1;  /* T_interCA_NonAlignedFrame_B_r16 */
static int hf_nr_rrc_uplinkTxDC_TwoCarrierReport_r16 = -1;  /* T_uplinkTxDC_TwoCarrierReport_r16 */
static int hf_nr_rrc_maxUpTo3Diff_NumerologiesConfigSinglePUCCH_grp_r16 = -1;  /* PUCCH_Grp_CarrierTypes_r16 */
static int hf_nr_rrc_maxUpTo4Diff_NumerologiesConfigSinglePUCCH_grp_r16 = -1;  /* PUCCH_Grp_CarrierTypes_r16 */
static int hf_nr_rrc_twoPUCCH_Grp_ConfigurationsList_r16 = -1;  /* SEQUENCE_SIZE_1_maxTwoPUCCH_Grp_ConfigList_r16_OF_TwoPUCCH_Grp_Configurations_r16 */
static int hf_nr_rrc_twoPUCCH_Grp_ConfigurationsList_r16_item = -1;  /* TwoPUCCH_Grp_Configurations_r16 */
static int hf_nr_rrc_diffNumerologyAcrossPUCCH_Group_CarrierTypes_r16 = -1;  /* T_diffNumerologyAcrossPUCCH_Group_CarrierTypes_r16 */
static int hf_nr_rrc_diffNumerologyWithinPUCCH_GroupSmallerSCS_CarrierTypes_r16 = -1;  /* T_diffNumerologyWithinPUCCH_GroupSmallerSCS_CarrierTypes_r16 */
static int hf_nr_rrc_diffNumerologyWithinPUCCH_GroupLargerSCS_CarrierTypes_r16 = -1;  /* T_diffNumerologyWithinPUCCH_GroupLargerSCS_CarrierTypes_r16 */
static int hf_nr_rrc_pdcch_MonitoringCA_NonAlignedSpan_r16 = -1;  /* INTEGER_2_16 */
static int hf_nr_rrc_pdcch_BlindDetectionCA_Mixed_NonAlignedSpan_r16 = -1;  /* T_pdcch_BlindDetectionCA_Mixed_NonAlignedSpan_r16 */
static int hf_nr_rrc_supportSRS_xTyR_xLessThanY_r16 = -1;  /* T_supportSRS_xTyR_xLessThanY_r16 */
static int hf_nr_rrc_supportSRS_xTyR_xEqualToY_r16 = -1;  /* T_supportSRS_xTyR_xEqualToY_r16 */
static int hf_nr_rrc_supportSRS_AntennaSwitching_r16 = -1;  /* T_supportSRS_AntennaSwitching_r16 */
static int hf_nr_rrc_pucch_PrimaryGroupMapping_r16 = -1;  /* TwoPUCCH_Grp_ConfigParams_r16 */
static int hf_nr_rrc_pucch_SecondaryGroupMapping_r16 = -1;  /* TwoPUCCH_Grp_ConfigParams_r16 */
static int hf_nr_rrc_pucch_GroupMapping_r16 = -1;  /* PUCCH_Grp_CarrierTypes_r16 */
static int hf_nr_rrc_pucch_TX_r16 = -1;           /* PUCCH_Grp_CarrierTypes_r16 */
static int hf_nr_rrc_fr1_NonSharedTDD_r16 = -1;   /* T_fr1_NonSharedTDD_r16 */
static int hf_nr_rrc_fr1_SharedTDD_r16 = -1;      /* T_fr1_SharedTDD_r16 */
static int hf_nr_rrc_fr1_NonSharedFDD_r16 = -1;   /* T_fr1_NonSharedFDD_r16 */
static int hf_nr_rrc_fr2_r16 = -1;                /* T_fr2_r16 */
static int hf_nr_rrc_ca_ParametersNR_ForDC = -1;  /* CA_ParametersNR */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v1540 = -1;  /* CA_ParametersNR_v1540 */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v1550 = -1;  /* CA_ParametersNR_v1550 */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v1560 = -1;  /* CA_ParametersNR_v1560 */
static int hf_nr_rrc_featureSetCombinationDC = -1;  /* FeatureSetCombinationId */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v15g0 = -1;  /* CA_ParametersNR_v15g0 */
static int hf_nr_rrc_intraFR_NR_DC_PwrSharingMode1_r16 = -1;  /* T_intraFR_NR_DC_PwrSharingMode1_r16 */
static int hf_nr_rrc_intraFR_NR_DC_PwrSharingMode2_r16 = -1;  /* T_intraFR_NR_DC_PwrSharingMode2_r16 */
static int hf_nr_rrc_intraFR_NR_DC_DynamicPwrSharing_r16 = -1;  /* T_intraFR_NR_DC_DynamicPwrSharing_r16 */
static int hf_nr_rrc_asyncNRDC_r16 = -1;          /* T_asyncNRDC_r16 */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v1610 = -1;  /* CA_ParametersNR_v1610 */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v1630 = -1;  /* CA_ParametersNR_v1630 */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v1640 = -1;  /* CA_ParametersNR_v1640 */
static int hf_nr_rrc_supportedCellGrouping_r16 = -1;  /* BIT_STRING_SIZE_1_maxCellGroupings_r16 */
static int hf_nr_rrc_fr1fdd_FR1TDD_CA_SpCellOnFR1FDD = -1;  /* T_fr1fdd_FR1TDD_CA_SpCellOnFR1FDD */
static int hf_nr_rrc_fr1fdd_FR1TDD_CA_SpCellOnFR1TDD = -1;  /* T_fr1fdd_FR1TDD_CA_SpCellOnFR1TDD */
static int hf_nr_rrc_fr1fdd_FR2TDD_CA_SpCellOnFR1FDD = -1;  /* T_fr1fdd_FR2TDD_CA_SpCellOnFR1FDD */
static int hf_nr_rrc_fr1fdd_FR2TDD_CA_SpCellOnFR2TDD = -1;  /* T_fr1fdd_FR2TDD_CA_SpCellOnFR2TDD */
static int hf_nr_rrc_fr1tdd_FR2TDD_CA_SpCellOnFR1TDD = -1;  /* T_fr1tdd_FR2TDD_CA_SpCellOnFR1TDD */
static int hf_nr_rrc_fr1tdd_FR2TDD_CA_SpCellOnFR2TDD = -1;  /* T_fr1tdd_FR2TDD_CA_SpCellOnFR2TDD */
static int hf_nr_rrc_fr1fdd_FR1TDD_FR2TDD_CA_SpCellOnFR1FDD = -1;  /* T_fr1fdd_FR1TDD_FR2TDD_CA_SpCellOnFR1FDD */
static int hf_nr_rrc_fr1fdd_FR1TDD_FR2TDD_CA_SpCellOnFR1TDD = -1;  /* T_fr1fdd_FR1TDD_FR2TDD_CA_SpCellOnFR1TDD */
static int hf_nr_rrc_fr1fdd_FR1TDD_FR2TDD_CA_SpCellOnFR2TDD = -1;  /* T_fr1fdd_FR1TDD_FR2TDD_CA_SpCellOnFR2TDD */
static int hf_nr_rrc_type1_02 = -1;               /* T_type1_02 */
static int hf_nr_rrc_singlePanel = -1;            /* T_singlePanel */
static int hf_nr_rrc_supportedCSI_RS_ResourceList = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_RS_Resources_OF_SupportedCSI_RS_Resource */
static int hf_nr_rrc_supportedCSI_RS_ResourceList_item = -1;  /* SupportedCSI_RS_Resource */
static int hf_nr_rrc_modes = -1;                  /* T_modes */
static int hf_nr_rrc_maxNumberCSI_RS_PerResourceSet = -1;  /* INTEGER_1_8 */
static int hf_nr_rrc_multiPanel = -1;             /* T_multiPanel */
static int hf_nr_rrc_modes_01 = -1;               /* T_modes_01 */
static int hf_nr_rrc_nrofPanels = -1;             /* T_nrofPanels */
static int hf_nr_rrc_type2_02 = -1;               /* T_type2_02 */
static int hf_nr_rrc_parameterLx = -1;            /* INTEGER_2_4 */
static int hf_nr_rrc_amplitudeScalingType = -1;   /* T_amplitudeScalingType */
static int hf_nr_rrc_amplitudeSubsetRestriction = -1;  /* T_amplitudeSubsetRestriction */
static int hf_nr_rrc_type2_PortSelection = -1;    /* T_type2_PortSelection */
static int hf_nr_rrc_amplitudeScalingType_01 = -1;  /* T_amplitudeScalingType_01 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAlt_r16 = -1;  /* T_supportedCSI_RS_ResourceListAlt_r16 */
static int hf_nr_rrc_type1_SinglePanel_r16 = -1;  /* T_type1_SinglePanel_r16 */
static int hf_nr_rrc_type1_SinglePanel_r16_item = -1;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1_MultiPanel_r16 = -1;   /* T_type1_MultiPanel_r16 */
static int hf_nr_rrc_type1_MultiPanel_r16_item = -1;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type2_r16 = -1;              /* T_type2_r16 */
static int hf_nr_rrc_type2_r16_item = -1;         /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type2_PortSelection_r16 = -1;  /* T_type2_PortSelection_r16 */
static int hf_nr_rrc_type2_PortSelection_r16_item = -1;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_etype2_r16 = -1;             /* T_etype2_r16 */
static int hf_nr_rrc_etype2R1_r16 = -1;           /* T_etype2R1_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16 = -1;  /* T_supportedCSI_RS_ResourceListAdd_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_item = -1;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_etype2R2_r16 = -1;           /* T_etype2R2_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_01 = -1;  /* T_supportedCSI_RS_ResourceListAdd_r16_01 */
static int hf_nr_rrc_paramComb7_8_r16 = -1;       /* T_paramComb7_8_r16 */
static int hf_nr_rrc_rank3_4_r16 = -1;            /* T_rank3_4_r16 */
static int hf_nr_rrc_amplitudeSubsetRestriction_r16 = -1;  /* T_amplitudeSubsetRestriction_r16 */
static int hf_nr_rrc_etype2_PS_r16 = -1;          /* T_etype2_PS_r16 */
static int hf_nr_rrc_etype2R1_PortSelection_r16 = -1;  /* T_etype2R1_PortSelection_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_02 = -1;  /* T_supportedCSI_RS_ResourceListAdd_r16_02 */
static int hf_nr_rrc_etype2R2_PortSelection_r16 = -1;  /* T_etype2R2_PortSelection_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_03 = -1;  /* T_supportedCSI_RS_ResourceListAdd_r16_03 */
static int hf_nr_rrc_rank3_4_r16_01 = -1;         /* T_rank3_4_r16_01 */
static int hf_nr_rrc_type1SP_Type2_null_r16 = -1;  /* T_type1SP_Type2_null_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_04 = -1;  /* T_supportedCSI_RS_ResourceListAdd_r16_04 */
static int hf_nr_rrc_type1SP_Type2PS_null_r16 = -1;  /* T_type1SP_Type2PS_null_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_05 = -1;  /* T_supportedCSI_RS_ResourceListAdd_r16_05 */
static int hf_nr_rrc_type1SP_eType2R1_null_r16 = -1;  /* T_type1SP_eType2R1_null_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_06 = -1;  /* T_supportedCSI_RS_ResourceListAdd_r16_06 */
static int hf_nr_rrc_type1SP_eType2R2_null_r16 = -1;  /* T_type1SP_eType2R2_null_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_07 = -1;  /* T_supportedCSI_RS_ResourceListAdd_r16_07 */
static int hf_nr_rrc_type1SP_eType2R1PS_null_r16 = -1;  /* T_type1SP_eType2R1PS_null_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_08 = -1;  /* T_supportedCSI_RS_ResourceListAdd_r16_08 */
static int hf_nr_rrc_type1SP_eType2R2PS_null_r16 = -1;  /* T_type1SP_eType2R2PS_null_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_09 = -1;  /* T_supportedCSI_RS_ResourceListAdd_r16_09 */
static int hf_nr_rrc_type1SP_Type2_Type2PS_r16 = -1;  /* T_type1SP_Type2_Type2PS_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_10 = -1;  /* T_supportedCSI_RS_ResourceListAdd_r16_10 */
static int hf_nr_rrc_type1MP_Type2_null_r16 = -1;  /* T_type1MP_Type2_null_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_11 = -1;  /* T_supportedCSI_RS_ResourceListAdd_r16_11 */
static int hf_nr_rrc_type1MP_Type2PS_null_r16 = -1;  /* T_type1MP_Type2PS_null_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_12 = -1;  /* T_supportedCSI_RS_ResourceListAdd_r16_12 */
static int hf_nr_rrc_type1MP_eType2R1_null_r16 = -1;  /* T_type1MP_eType2R1_null_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_13 = -1;  /* T_supportedCSI_RS_ResourceListAdd_r16_13 */
static int hf_nr_rrc_type1MP_eType2R2_null_r16 = -1;  /* T_type1MP_eType2R2_null_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_14 = -1;  /* T_supportedCSI_RS_ResourceListAdd_r16_14 */
static int hf_nr_rrc_type1MP_eType2R1PS_null_r16 = -1;  /* T_type1MP_eType2R1PS_null_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_15 = -1;  /* T_supportedCSI_RS_ResourceListAdd_r16_15 */
static int hf_nr_rrc_type1MP_eType2R2PS_null_r16 = -1;  /* T_type1MP_eType2R2PS_null_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_16 = -1;  /* T_supportedCSI_RS_ResourceListAdd_r16_16 */
static int hf_nr_rrc_type1MP_Type2_Type2PS_r16 = -1;  /* T_type1MP_Type2_Type2PS_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_17 = -1;  /* T_supportedCSI_RS_ResourceListAdd_r16_17 */
static int hf_nr_rrc_etype2R1_r16_01 = -1;        /* T_etype2R1_r16_01 */
static int hf_nr_rrc_etype2R1_r16_item = -1;      /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_etype2R2_r16_01 = -1;        /* T_etype2R2_r16_01 */
static int hf_nr_rrc_etype2R2_r16_item = -1;      /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_etype2R1_PortSelection_r16_01 = -1;  /* T_etype2R1_PortSelection_r16_01 */
static int hf_nr_rrc_etype2R1_PortSelection_r16_item = -1;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_etype2R2_PortSelection_r16_01 = -1;  /* T_etype2R2_PortSelection_r16_01 */
static int hf_nr_rrc_etype2R2_PortSelection_r16_item = -1;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1SP_Type2_null_r16_01 = -1;  /* T_type1SP_Type2_null_r16_01 */
static int hf_nr_rrc_type1SP_Type2_null_r16_item = -1;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1SP_Type2PS_null_r16_01 = -1;  /* T_type1SP_Type2PS_null_r16_01 */
static int hf_nr_rrc_type1SP_Type2PS_null_r16_item = -1;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1SP_eType2R1_null_r16_01 = -1;  /* T_type1SP_eType2R1_null_r16_01 */
static int hf_nr_rrc_type1SP_eType2R1_null_r16_item = -1;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1SP_eType2R2_null_r16_01 = -1;  /* T_type1SP_eType2R2_null_r16_01 */
static int hf_nr_rrc_type1SP_eType2R2_null_r16_item = -1;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1SP_eType2R1PS_null_r16_01 = -1;  /* T_type1SP_eType2R1PS_null_r16_01 */
static int hf_nr_rrc_type1SP_eType2R1PS_null_r16_item = -1;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1SP_eType2R2PS_null_r16_01 = -1;  /* T_type1SP_eType2R2PS_null_r16_01 */
static int hf_nr_rrc_type1SP_eType2R2PS_null_r16_item = -1;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1SP_Type2_Type2PS_r16_01 = -1;  /* T_type1SP_Type2_Type2PS_r16_01 */
static int hf_nr_rrc_type1SP_Type2_Type2PS_r16_item = -1;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1MP_Type2_null_r16_01 = -1;  /* T_type1MP_Type2_null_r16_01 */
static int hf_nr_rrc_type1MP_Type2_null_r16_item = -1;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1MP_Type2PS_null_r16_01 = -1;  /* T_type1MP_Type2PS_null_r16_01 */
static int hf_nr_rrc_type1MP_Type2PS_null_r16_item = -1;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1MP_eType2R1_null_r16_01 = -1;  /* T_type1MP_eType2R1_null_r16_01 */
static int hf_nr_rrc_type1MP_eType2R1_null_r16_item = -1;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1MP_eType2R2_null_r16_01 = -1;  /* T_type1MP_eType2R2_null_r16_01 */
static int hf_nr_rrc_type1MP_eType2R2_null_r16_item = -1;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1MP_eType2R1PS_null_r16_01 = -1;  /* T_type1MP_eType2R1PS_null_r16_01 */
static int hf_nr_rrc_type1MP_eType2R1PS_null_r16_item = -1;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1MP_eType2R2PS_null_r16_01 = -1;  /* T_type1MP_eType2R2PS_null_r16_01 */
static int hf_nr_rrc_type1MP_eType2R2PS_null_r16_item = -1;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1MP_Type2_Type2PS_r16_01 = -1;  /* T_type1MP_Type2_Type2PS_r16_01 */
static int hf_nr_rrc_type1MP_Type2_Type2PS_r16_item = -1;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_CodebookVariantsList_r16_item = -1;  /* SupportedCSI_RS_Resource */
static int hf_nr_rrc_maxNumberTxPortsPerResource = -1;  /* T_maxNumberTxPortsPerResource */
static int hf_nr_rrc_maxNumberResourcesPerBand = -1;  /* INTEGER_1_64 */
static int hf_nr_rrc_totalNumberTxPortsPerBand = -1;  /* INTEGER_2_256 */
static int hf_nr_rrc_FeatureSetCombination_item = -1;  /* FeatureSetsPerBand */
static int hf_nr_rrc_FeatureSetsPerBand_item = -1;  /* FeatureSet */
static int hf_nr_rrc_eutra_05 = -1;               /* T_eutra_03 */
static int hf_nr_rrc_downlinkSetEUTRA = -1;       /* FeatureSetEUTRA_DownlinkId */
static int hf_nr_rrc_uplinkSetEUTRA = -1;         /* FeatureSetEUTRA_UplinkId */
static int hf_nr_rrc_nr_05 = -1;                  /* T_nr_04 */
static int hf_nr_rrc_downlinkSetNR = -1;          /* FeatureSetDownlinkId */
static int hf_nr_rrc_uplinkSetNR = -1;            /* FeatureSetUplinkId */
static int hf_nr_rrc_featureSetListPerDownlinkCC = -1;  /* SEQUENCE_SIZE_1_maxNrofServingCells_OF_FeatureSetDownlinkPerCC_Id */
static int hf_nr_rrc_featureSetListPerDownlinkCC_item = -1;  /* FeatureSetDownlinkPerCC_Id */
static int hf_nr_rrc_intraBandFreqSeparationDL = -1;  /* FreqSeparationClass */
static int hf_nr_rrc_scalingFactor = -1;          /* T_scalingFactor */
static int hf_nr_rrc_dummy8 = -1;                 /* T_dummy8 */
static int hf_nr_rrc_scellWithoutSSB = -1;        /* T_scellWithoutSSB */
static int hf_nr_rrc_csi_RS_MeasSCellWithoutSSB = -1;  /* T_csi_RS_MeasSCellWithoutSSB */
static int hf_nr_rrc_featureSetDownlink_dummy1 = -1;  /* T_featureSetDownlink_dummy1 */
static int hf_nr_rrc_type1_3_CSS = -1;            /* T_type1_3_CSS */
static int hf_nr_rrc_pdcch_MonitoringAnyOccasions = -1;  /* T_pdcch_MonitoringAnyOccasions */
static int hf_nr_rrc_featureSetDownlink_dummy2 = -1;  /* T_featureSetDownlink_dummy2 */
static int hf_nr_rrc_ue_SpecificUL_DL_Assignment = -1;  /* T_ue_SpecificUL_DL_Assignment */
static int hf_nr_rrc_searchSpaceSharingCA_DL = -1;  /* T_searchSpaceSharingCA_DL */
static int hf_nr_rrc_timeDurationForQCL = -1;     /* T_timeDurationForQCL */
static int hf_nr_rrc_featureSetDownlink_timeDurationForQCL_scs_60kHz = -1;  /* T_featureSetDownlink_timeDurationForQCL_scs_60kHz */
static int hf_nr_rrc_featureSetDownlink_timeDurationForQCL_scs_120kHz = -1;  /* T_featureSetDownlink_timeDurationForQCL_scs_120kHz */
static int hf_nr_rrc_pdsch_ProcessingType1_DifferentTB_PerSlot = -1;  /* T_pdsch_ProcessingType1_DifferentTB_PerSlot */
static int hf_nr_rrc_scs_15kHz = -1;              /* T_scs_15kHz */
static int hf_nr_rrc_scs_30kHz = -1;              /* T_scs_30kHz */
static int hf_nr_rrc_scs_60kHz = -1;              /* T_scs_60kHz */
static int hf_nr_rrc_featureSetDownlink_pdsch_ProcessingType1_DifferentTB_PerSlot_scs_120kHz = -1;  /* T_featureSetDownlink_pdsch_ProcessingType1_DifferentTB_PerSlot_scs_120kHz */
static int hf_nr_rrc_featureSetDownlink_dummy3 = -1;  /* DummyA */
static int hf_nr_rrc_featureSetDownlink_dummy4 = -1;  /* SEQUENCE_SIZE_1_maxNrofCodebooks_OF_DummyB */
static int hf_nr_rrc_featureSetDownlink_dummy4_item = -1;  /* DummyB */
static int hf_nr_rrc_featureSetDownlink_dummy5 = -1;  /* SEQUENCE_SIZE_1_maxNrofCodebooks_OF_DummyC */
static int hf_nr_rrc_featureSetDownlink_dummy5_item = -1;  /* DummyC */
static int hf_nr_rrc_featureSetDownlink_dummy6 = -1;  /* SEQUENCE_SIZE_1_maxNrofCodebooks_OF_DummyD */
static int hf_nr_rrc_featureSetDownlink_dummy6_item = -1;  /* DummyD */
static int hf_nr_rrc_dummy7 = -1;                 /* SEQUENCE_SIZE_1_maxNrofCodebooks_OF_DummyE */
static int hf_nr_rrc_dummy7_item = -1;            /* DummyE */
static int hf_nr_rrc_oneFL_DMRS_TwoAdditionalDMRS_DL = -1;  /* T_oneFL_DMRS_TwoAdditionalDMRS_DL */
static int hf_nr_rrc_additionalDMRS_DL_Alt = -1;  /* T_additionalDMRS_DL_Alt */
static int hf_nr_rrc_twoFL_DMRS_TwoAdditionalDMRS_DL = -1;  /* T_twoFL_DMRS_TwoAdditionalDMRS_DL */
static int hf_nr_rrc_oneFL_DMRS_ThreeAdditionalDMRS_DL = -1;  /* T_oneFL_DMRS_ThreeAdditionalDMRS_DL */
static int hf_nr_rrc_pdcch_MonitoringAnyOccasionsWithSpanGap = -1;  /* T_pdcch_MonitoringAnyOccasionsWithSpanGap */
static int hf_nr_rrc_featureSetDownlink_v1540_pdcch_MonitoringAnyOccasionsWithSpanGap_scs_15kHz = -1;  /* T_featureSetDownlink_v1540_pdcch_MonitoringAnyOccasionsWithSpanGap_scs_15kHz */
static int hf_nr_rrc_scs_30kHz_01 = -1;           /* T_scs_30kHz_01 */
static int hf_nr_rrc_scs_60kHz_01 = -1;           /* T_scs_60kHz_01 */
static int hf_nr_rrc_featureSetDownlink_v1540_pdcch_MonitoringAnyOccasionsWithSpanGap_scs_120kHz = -1;  /* T_featureSetDownlink_v1540_pdcch_MonitoringAnyOccasionsWithSpanGap_scs_120kHz */
static int hf_nr_rrc_pdsch_SeparationWithGap = -1;  /* T_pdsch_SeparationWithGap */
static int hf_nr_rrc_pdsch_ProcessingType2 = -1;  /* T_pdsch_ProcessingType2 */
static int hf_nr_rrc_featureSetDownlink_v1540_pdsch_ProcessingType2_scs_15kHz = -1;  /* ProcessingParameters */
static int hf_nr_rrc_scs_30kHz_02 = -1;           /* ProcessingParameters */
static int hf_nr_rrc_featureSetDownlink_v1540_pdsch_ProcessingType2_scs_60kHz = -1;  /* ProcessingParameters */
static int hf_nr_rrc_pdsch_ProcessingType2_Limited = -1;  /* T_pdsch_ProcessingType2_Limited */
static int hf_nr_rrc_differentTB_PerSlot_SCS_30kHz = -1;  /* T_differentTB_PerSlot_SCS_30kHz */
static int hf_nr_rrc_dl_MCS_TableAlt_DynamicIndication = -1;  /* T_dl_MCS_TableAlt_DynamicIndication */
static int hf_nr_rrc_supportedSRS_Resources = -1;  /* SRS_Resources */
static int hf_nr_rrc_cbgPDSCH_ProcessingType1_DifferentTB_PerSlot_r16 = -1;  /* T_cbgPDSCH_ProcessingType1_DifferentTB_PerSlot_r16 */
static int hf_nr_rrc_featureSetDownlink_v1610_cbgPDSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_15kHz_r16 = -1;  /* T_featureSetDownlink_v1610_cbgPDSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_15kHz_r16 */
static int hf_nr_rrc_featureSetDownlink_v1610_cbgPDSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_30kHz_r16 = -1;  /* T_featureSetDownlink_v1610_cbgPDSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_30kHz_r16 */
static int hf_nr_rrc_featureSetDownlink_v1610_cbgPDSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_60kHz_r16 = -1;  /* T_featureSetDownlink_v1610_cbgPDSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_60kHz_r16 */
static int hf_nr_rrc_featureSetDownlink_v1610_cbgPDSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_120kHz_r16 = -1;  /* T_featureSetDownlink_v1610_cbgPDSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_120kHz_r16 */
static int hf_nr_rrc_cbgPDSCH_ProcessingType2_DifferentTB_PerSlot_r16 = -1;  /* T_cbgPDSCH_ProcessingType2_DifferentTB_PerSlot_r16 */
static int hf_nr_rrc_featureSetDownlink_v1610_cbgPDSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_15kHz_r16 = -1;  /* T_featureSetDownlink_v1610_cbgPDSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_15kHz_r16 */
static int hf_nr_rrc_featureSetDownlink_v1610_cbgPDSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_30kHz_r16 = -1;  /* T_featureSetDownlink_v1610_cbgPDSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_30kHz_r16 */
static int hf_nr_rrc_featureSetDownlink_v1610_cbgPDSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_60kHz_r16 = -1;  /* T_featureSetDownlink_v1610_cbgPDSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_60kHz_r16 */
static int hf_nr_rrc_featureSetDownlink_v1610_cbgPDSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_120kHz_r16 = -1;  /* T_featureSetDownlink_v1610_cbgPDSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_120kHz_r16 */
static int hf_nr_rrc_intraFreqDAPS_r16 = -1;      /* T_intraFreqDAPS_r16 */
static int hf_nr_rrc_intraFreqDiffSCS_DAPS_r16 = -1;  /* T_intraFreqDiffSCS_DAPS_r16 */
static int hf_nr_rrc_intraFreqAsyncDAPS_r16 = -1;  /* T_intraFreqAsyncDAPS_r16 */
static int hf_nr_rrc_intraBandFreqSeparationDL_v1620 = -1;  /* FreqSeparationClassDL_v1620 */
static int hf_nr_rrc_intraBandFreqSeparationDL_Only_r16 = -1;  /* FreqSeparationClassDL_Only_r16 */
static int hf_nr_rrc_pdcch_Monitoring_r16 = -1;   /* T_pdcch_Monitoring_r16 */
static int hf_nr_rrc_pdsch_ProcessingType1_r16 = -1;  /* T_pdsch_ProcessingType1_r16 */
static int hf_nr_rrc_featureSetDownlink_v1610_pdcch_Monitoring_r16_pdsch_ProcessingType1_r16_scs_15kHz_r16 = -1;  /* PDCCH_MonitoringOccasions_r16 */
static int hf_nr_rrc_featureSetDownlink_v1610_pdcch_Monitoring_r16_pdsch_ProcessingType1_r16_scs_30kHz_r16 = -1;  /* PDCCH_MonitoringOccasions_r16 */
static int hf_nr_rrc_pdsch_ProcessingType2_r16 = -1;  /* T_pdsch_ProcessingType2_r16 */
static int hf_nr_rrc_featureSetDownlink_v1610_pdcch_Monitoring_r16_pdsch_ProcessingType2_r16_scs_15kHz_r16 = -1;  /* PDCCH_MonitoringOccasions_r16 */
static int hf_nr_rrc_scs_30kHz_r16 = -1;          /* PDCCH_MonitoringOccasions_r16 */
static int hf_nr_rrc_pdcch_MonitoringMixed_r16 = -1;  /* T_pdcch_MonitoringMixed_r16 */
static int hf_nr_rrc_crossCarrierSchedulingProcessing_DiffSCS_r16 = -1;  /* T_crossCarrierSchedulingProcessing_DiffSCS_r16 */
static int hf_nr_rrc_scs_15kHz_120kHz_r16 = -1;   /* T_scs_15kHz_120kHz_r16 */
static int hf_nr_rrc_scs_15kHz_60kHz_r16 = -1;    /* T_scs_15kHz_60kHz_r16 */
static int hf_nr_rrc_scs_30kHz_120kHz_r16 = -1;   /* T_scs_30kHz_120kHz_r16 */
static int hf_nr_rrc_scs_15kHz_30kHz_r16 = -1;    /* T_scs_15kHz_30kHz_r16 */
static int hf_nr_rrc_scs_30kHz_60kHz_r16 = -1;    /* T_scs_30kHz_60kHz_r16 */
static int hf_nr_rrc_scs_60kHz_120kHz_r16 = -1;   /* T_scs_60kHz_120kHz_r16 */
static int hf_nr_rrc_singleDCI_SDM_scheme_r16 = -1;  /* T_singleDCI_SDM_scheme_r16 */
static int hf_nr_rrc_period7span3_r16 = -1;       /* T_period7span3_r16 */
static int hf_nr_rrc_period4span3_r16 = -1;       /* T_period4span3_r16 */
static int hf_nr_rrc_period2span2_r16 = -1;       /* T_period2span2_r16 */
static int hf_nr_rrc_maxNumberNZP_CSI_RS_PerCC = -1;  /* INTEGER_1_32 */
static int hf_nr_rrc_maxNumberPortsAcrossNZP_CSI_RS_PerCC = -1;  /* T_maxNumberPortsAcrossNZP_CSI_RS_PerCC */
static int hf_nr_rrc_maxNumberCS_IM_PerCC = -1;   /* T_maxNumberCS_IM_PerCC */
static int hf_nr_rrc_maxNumberSimultaneousCSI_RS_ActBWP_AllCC = -1;  /* T_maxNumberSimultaneousCSI_RS_ActBWP_AllCC */
static int hf_nr_rrc_totalNumberPortsSimultaneousCSI_RS_ActBWP_AllCC = -1;  /* T_totalNumberPortsSimultaneousCSI_RS_ActBWP_AllCC */
static int hf_nr_rrc_maxNumberTxPortsPerResource_01 = -1;  /* T_maxNumberTxPortsPerResource_01 */
static int hf_nr_rrc_maxNumberResources = -1;     /* INTEGER_1_64 */
static int hf_nr_rrc_totalNumberTxPorts = -1;     /* INTEGER_2_256 */
static int hf_nr_rrc_supportedCodebookMode = -1;  /* T_supportedCodebookMode */
static int hf_nr_rrc_maxNumberTxPortsPerResource_02 = -1;  /* T_maxNumberTxPortsPerResource_02 */
static int hf_nr_rrc_supportedCodebookMode_01 = -1;  /* T_supportedCodebookMode_01 */
static int hf_nr_rrc_supportedNumberPanels = -1;  /* T_supportedNumberPanels */
static int hf_nr_rrc_maxNumberTxPortsPerResource_03 = -1;  /* T_maxNumberTxPortsPerResource_03 */
static int hf_nr_rrc_amplitudeScalingType_02 = -1;  /* T_amplitudeScalingType_02 */
static int hf_nr_rrc_amplitudeSubsetRestriction_01 = -1;  /* T_amplitudeSubsetRestriction_01 */
static int hf_nr_rrc_maxNumberTxPortsPerResource_04 = -1;  /* T_maxNumberTxPortsPerResource_04 */
static int hf_nr_rrc_amplitudeScalingType_03 = -1;  /* T_amplitudeScalingType_03 */
static int hf_nr_rrc_supportedSubcarrierSpacingDL = -1;  /* SubcarrierSpacing */
static int hf_nr_rrc_supportedBandwidthDL = -1;   /* SupportedBandwidth */
static int hf_nr_rrc_channelBW_90mhz = -1;        /* T_channelBW_90mhz */
static int hf_nr_rrc_maxNumberMIMO_LayersPDSCH = -1;  /* MIMO_LayersDL */
static int hf_nr_rrc_supportedModulationOrderDL = -1;  /* ModulationOrder */
static int hf_nr_rrc_multiDCI_MultiTRP_r16 = -1;  /* MultiDCI_MultiTRP_r16 */
static int hf_nr_rrc_supportFDM_SchemeB_r16 = -1;  /* T_supportFDM_SchemeB_r16 */
static int hf_nr_rrc_maxNumberCORESET_r16 = -1;   /* T_maxNumberCORESET_r16 */
static int hf_nr_rrc_maxNumberCORESETPerPoolIndex_r16 = -1;  /* INTEGER_1_3 */
static int hf_nr_rrc_maxNumberUnicastPDSCH_PerPool_r16 = -1;  /* T_maxNumberUnicastPDSCH_PerPool_r16 */
static int hf_nr_rrc_featureSetsDownlink = -1;    /* SEQUENCE_SIZE_1_maxDownlinkFeatureSets_OF_FeatureSetDownlink */
static int hf_nr_rrc_featureSetsDownlink_item = -1;  /* FeatureSetDownlink */
static int hf_nr_rrc_featureSetsDownlinkPerCC = -1;  /* SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetDownlinkPerCC */
static int hf_nr_rrc_featureSetsDownlinkPerCC_item = -1;  /* FeatureSetDownlinkPerCC */
static int hf_nr_rrc_featureSetsUplink = -1;      /* SEQUENCE_SIZE_1_maxUplinkFeatureSets_OF_FeatureSetUplink */
static int hf_nr_rrc_featureSetsUplink_item = -1;  /* FeatureSetUplink */
static int hf_nr_rrc_featureSetsUplinkPerCC = -1;  /* SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetUplinkPerCC */
static int hf_nr_rrc_featureSetsUplinkPerCC_item = -1;  /* FeatureSetUplinkPerCC */
static int hf_nr_rrc_featureSetsDownlink_v1540 = -1;  /* SEQUENCE_SIZE_1_maxDownlinkFeatureSets_OF_FeatureSetDownlink_v1540 */
static int hf_nr_rrc_featureSetsDownlink_v1540_item = -1;  /* FeatureSetDownlink_v1540 */
static int hf_nr_rrc_featureSetsUplink_v1540 = -1;  /* SEQUENCE_SIZE_1_maxUplinkFeatureSets_OF_FeatureSetUplink_v1540 */
static int hf_nr_rrc_featureSetsUplink_v1540_item = -1;  /* FeatureSetUplink_v1540 */
static int hf_nr_rrc_featureSetsUplinkPerCC_v1540 = -1;  /* SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetUplinkPerCC_v1540 */
static int hf_nr_rrc_featureSetsUplinkPerCC_v1540_item = -1;  /* FeatureSetUplinkPerCC_v1540 */
static int hf_nr_rrc_featureSetsDownlink_v15a0 = -1;  /* SEQUENCE_SIZE_1_maxDownlinkFeatureSets_OF_FeatureSetDownlink_v15a0 */
static int hf_nr_rrc_featureSetsDownlink_v15a0_item = -1;  /* FeatureSetDownlink_v15a0 */
static int hf_nr_rrc_featureSetsDownlink_v1610 = -1;  /* SEQUENCE_SIZE_1_maxDownlinkFeatureSets_OF_FeatureSetDownlink_v1610 */
static int hf_nr_rrc_featureSetsDownlink_v1610_item = -1;  /* FeatureSetDownlink_v1610 */
static int hf_nr_rrc_featureSetsUplink_v1610 = -1;  /* SEQUENCE_SIZE_1_maxUplinkFeatureSets_OF_FeatureSetUplink_v1610 */
static int hf_nr_rrc_featureSetsUplink_v1610_item = -1;  /* FeatureSetUplink_v1610 */
static int hf_nr_rrc_featureSetDownlinkPerCC_v1620 = -1;  /* SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetDownlinkPerCC_v1620 */
static int hf_nr_rrc_featureSetDownlinkPerCC_v1620_item = -1;  /* FeatureSetDownlinkPerCC_v1620 */
static int hf_nr_rrc_featureSetsUplink_v1630 = -1;  /* SEQUENCE_SIZE_1_maxUplinkFeatureSets_OF_FeatureSetUplink_v1630 */
static int hf_nr_rrc_featureSetsUplink_v1630_item = -1;  /* FeatureSetUplink_v1630 */
static int hf_nr_rrc_featureSetsUplink_v1640 = -1;  /* SEQUENCE_SIZE_1_maxUplinkFeatureSets_OF_FeatureSetUplink_v1640 */
static int hf_nr_rrc_featureSetsUplink_v1640_item = -1;  /* FeatureSetUplink_v1640 */
static int hf_nr_rrc_featureSetListPerUplinkCC = -1;  /* SEQUENCE_SIZE_1_maxNrofServingCells_OF_FeatureSetUplinkPerCC_Id */
static int hf_nr_rrc_featureSetListPerUplinkCC_item = -1;  /* FeatureSetUplinkPerCC_Id */
static int hf_nr_rrc_scalingFactor_01 = -1;       /* T_scalingFactor_01 */
static int hf_nr_rrc_dummy3 = -1;                 /* T_dummy3 */
static int hf_nr_rrc_intraBandFreqSeparationUL = -1;  /* FreqSeparationClass */
static int hf_nr_rrc_searchSpaceSharingCA_UL = -1;  /* T_searchSpaceSharingCA_UL */
static int hf_nr_rrc_featureSetUplink_dummy1 = -1;  /* DummyI */
static int hf_nr_rrc_twoPUCCH_Group = -1;         /* T_twoPUCCH_Group */
static int hf_nr_rrc_dynamicSwitchSUL = -1;       /* T_dynamicSwitchSUL */
static int hf_nr_rrc_simultaneousTxSUL_NonSUL = -1;  /* T_simultaneousTxSUL_NonSUL */
static int hf_nr_rrc_pusch_ProcessingType1_DifferentTB_PerSlot = -1;  /* T_pusch_ProcessingType1_DifferentTB_PerSlot */
static int hf_nr_rrc_featureSetUplink_pusch_ProcessingType1_DifferentTB_PerSlot_scs_15kHz = -1;  /* T_featureSetUplink_pusch_ProcessingType1_DifferentTB_PerSlot_scs_15kHz */
static int hf_nr_rrc_scs_30kHz_03 = -1;           /* T_scs_30kHz_02 */
static int hf_nr_rrc_featureSetUplink_pusch_ProcessingType1_DifferentTB_PerSlot_scs_60kHz = -1;  /* T_featureSetUplink_pusch_ProcessingType1_DifferentTB_PerSlot_scs_60kHz */
static int hf_nr_rrc_featureSetUplink_pusch_ProcessingType1_DifferentTB_PerSlot_scs_120kHz = -1;  /* T_featureSetUplink_pusch_ProcessingType1_DifferentTB_PerSlot_scs_120kHz */
static int hf_nr_rrc_featureSetUplink_dummy2 = -1;  /* DummyF */
static int hf_nr_rrc_zeroSlotOffsetAperiodicSRS = -1;  /* T_zeroSlotOffsetAperiodicSRS */
static int hf_nr_rrc_pa_PhaseDiscontinuityImpacts = -1;  /* T_pa_PhaseDiscontinuityImpacts */
static int hf_nr_rrc_pusch_SeparationWithGap = -1;  /* T_pusch_SeparationWithGap */
static int hf_nr_rrc_pusch_ProcessingType2 = -1;  /* T_pusch_ProcessingType2 */
static int hf_nr_rrc_featureSetUplink_v1540_pusch_ProcessingType2_scs_15kHz = -1;  /* ProcessingParameters */
static int hf_nr_rrc_featureSetUplink_v1540_pusch_ProcessingType2_scs_60kHz = -1;  /* ProcessingParameters */
static int hf_nr_rrc_ul_MCS_TableAlt_DynamicIndication = -1;  /* T_ul_MCS_TableAlt_DynamicIndication */
static int hf_nr_rrc_pusch_RepetitionTypeB_r16 = -1;  /* T_pusch_RepetitionTypeB_r16 */
static int hf_nr_rrc_maxNumberPUSCH_Tx_r16 = -1;  /* T_maxNumberPUSCH_Tx_r16 */
static int hf_nr_rrc_hoppingScheme_r16 = -1;      /* T_hoppingScheme_r16 */
static int hf_nr_rrc_ul_CancellationSelfCarrier_r16 = -1;  /* T_ul_CancellationSelfCarrier_r16 */
static int hf_nr_rrc_ul_CancellationCrossCarrier_r16 = -1;  /* T_ul_CancellationCrossCarrier_r16 */
static int hf_nr_rrc_ul_FullPwrMode2_MaxSRS_ResInSet_r16 = -1;  /* T_ul_FullPwrMode2_MaxSRS_ResInSet_r16 */
static int hf_nr_rrc_cbgPUSCH_ProcessingType1_DifferentTB_PerSlot_r16 = -1;  /* T_cbgPUSCH_ProcessingType1_DifferentTB_PerSlot_r16 */
static int hf_nr_rrc_featureSetUplink_v1610_cbgPUSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_15kHz_r16 = -1;  /* T_featureSetUplink_v1610_cbgPUSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_15kHz_r16 */
static int hf_nr_rrc_featureSetUplink_v1610_cbgPUSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_30kHz_r16 = -1;  /* T_featureSetUplink_v1610_cbgPUSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_30kHz_r16 */
static int hf_nr_rrc_featureSetUplink_v1610_cbgPUSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_60kHz_r16 = -1;  /* T_featureSetUplink_v1610_cbgPUSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_60kHz_r16 */
static int hf_nr_rrc_featureSetUplink_v1610_cbgPUSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_120kHz_r16 = -1;  /* T_featureSetUplink_v1610_cbgPUSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_120kHz_r16 */
static int hf_nr_rrc_cbgPUSCH_ProcessingType2_DifferentTB_PerSlot_r16 = -1;  /* T_cbgPUSCH_ProcessingType2_DifferentTB_PerSlot_r16 */
static int hf_nr_rrc_featureSetUplink_v1610_cbgPUSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_15kHz_r16 = -1;  /* T_featureSetUplink_v1610_cbgPUSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_15kHz_r16 */
static int hf_nr_rrc_featureSetUplink_v1610_cbgPUSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_30kHz_r16 = -1;  /* T_featureSetUplink_v1610_cbgPUSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_30kHz_r16 */
static int hf_nr_rrc_featureSetUplink_v1610_cbgPUSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_60kHz_r16 = -1;  /* T_featureSetUplink_v1610_cbgPUSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_60kHz_r16 */
static int hf_nr_rrc_featureSetUplink_v1610_cbgPUSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_120kHz_r16 = -1;  /* T_featureSetUplink_v1610_cbgPUSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_120kHz_r16 */
static int hf_nr_rrc_supportedSRS_PosResources_r16 = -1;  /* SRS_AllPosResources_r16 */
static int hf_nr_rrc_intraFreqDAPS_UL_r16 = -1;   /* T_intraFreqDAPS_UL_r16 */
static int hf_nr_rrc_dummy = -1;                  /* T_dummy */
static int hf_nr_rrc_intraFreqTwoTAGs_DAPS_r16 = -1;  /* T_intraFreqTwoTAGs_DAPS_r16 */
static int hf_nr_rrc_dummy1_02 = -1;              /* T_dummy1_02 */
static int hf_nr_rrc_dummy2 = -1;                 /* T_dummy2 */
static int hf_nr_rrc_dummy3_01 = -1;              /* T_dummy3_01 */
static int hf_nr_rrc_intraBandFreqSeparationUL_v1620 = -1;  /* FreqSeparationClassUL_v1620 */
static int hf_nr_rrc_multiPUCCH_r16 = -1;         /* T_multiPUCCH_r16 */
static int hf_nr_rrc_sub_SlotConfig_NCP_r16 = -1;  /* T_sub_SlotConfig_NCP_r16 */
static int hf_nr_rrc_sub_SlotConfig_ECP_r16 = -1;  /* T_sub_SlotConfig_ECP_r16 */
static int hf_nr_rrc_twoPUCCH_Type1_r16 = -1;     /* T_twoPUCCH_Type1_r16 */
static int hf_nr_rrc_twoPUCCH_Type2_r16 = -1;     /* T_twoPUCCH_Type2_r16 */
static int hf_nr_rrc_twoPUCCH_Type3_r16 = -1;     /* T_twoPUCCH_Type3_r16 */
static int hf_nr_rrc_twoPUCCH_Type4_r16 = -1;     /* T_twoPUCCH_Type4_r16 */
static int hf_nr_rrc_mux_SR_HARQ_ACK_r16 = -1;    /* T_mux_SR_HARQ_ACK_r16 */
static int hf_nr_rrc_dummy1_03 = -1;              /* T_dummy1_03 */
static int hf_nr_rrc_dummy2_01 = -1;              /* T_dummy2_01 */
static int hf_nr_rrc_twoPUCCH_Type5_r16 = -1;     /* T_twoPUCCH_Type5_r16 */
static int hf_nr_rrc_twoPUCCH_Type6_r16 = -1;     /* T_twoPUCCH_Type6_r16 */
static int hf_nr_rrc_twoPUCCH_Type7_r16 = -1;     /* T_twoPUCCH_Type7_r16 */
static int hf_nr_rrc_twoPUCCH_Type8_r16 = -1;     /* T_twoPUCCH_Type8_r16 */
static int hf_nr_rrc_twoPUCCH_Type9_r16 = -1;     /* T_twoPUCCH_Type9_r16 */
static int hf_nr_rrc_twoPUCCH_Type10_r16 = -1;    /* T_twoPUCCH_Type10_r16 */
static int hf_nr_rrc_twoPUCCH_Type11_r16 = -1;    /* T_twoPUCCH_Type11_r16 */
static int hf_nr_rrc_ul_IntraUE_Mux_r16 = -1;     /* T_ul_IntraUE_Mux_r16 */
static int hf_nr_rrc_pusch_PreparationLowPriority_r16 = -1;  /* T_pusch_PreparationLowPriority_r16 */
static int hf_nr_rrc_pusch_PreparationHighPriority_r16 = -1;  /* T_pusch_PreparationHighPriority_r16 */
static int hf_nr_rrc_ul_FullPwrMode_r16 = -1;     /* T_ul_FullPwrMode_r16 */
static int hf_nr_rrc_crossCarrierSchedulingProcessing_DiffSCS_r16_01 = -1;  /* T_crossCarrierSchedulingProcessing_DiffSCS_r16_01 */
static int hf_nr_rrc_scs_15kHz_120kHz_r16_01 = -1;  /* T_scs_15kHz_120kHz_r16_01 */
static int hf_nr_rrc_scs_15kHz_60kHz_r16_01 = -1;  /* T_scs_15kHz_60kHz_r16_01 */
static int hf_nr_rrc_scs_30kHz_120kHz_r16_01 = -1;  /* T_scs_30kHz_120kHz_r16_01 */
static int hf_nr_rrc_scs_15kHz_30kHz_r16_01 = -1;  /* T_scs_15kHz_30kHz_r16_01 */
static int hf_nr_rrc_scs_30kHz_60kHz_r16_01 = -1;  /* T_scs_30kHz_60kHz_r16_01 */
static int hf_nr_rrc_featureSetUplink_v1610_crossCarrierSchedulingProcessing_DiffSCS_r16_scs_60kHz_120kHz_r16 = -1;  /* T_featureSetUplink_v1610_crossCarrierSchedulingProcessing_DiffSCS_r16_scs_60kHz_120kHz_r16 */
static int hf_nr_rrc_ul_FullPwrMode1_r16 = -1;    /* T_ul_FullPwrMode1_r16 */
static int hf_nr_rrc_ul_FullPwrMode2_SRSConfig_diffNumSRSPorts_r16 = -1;  /* T_ul_FullPwrMode2_SRSConfig_diffNumSRSPorts_r16 */
static int hf_nr_rrc_ul_FullPwrMode2_TPMIGroup_r16 = -1;  /* T_ul_FullPwrMode2_TPMIGroup_r16 */
static int hf_nr_rrc_twoPorts_r16 = -1;           /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_fourPortsNonCoherent_r16 = -1;  /* T_fourPortsNonCoherent_r16 */
static int hf_nr_rrc_fourPortsPartialCoherent_r16 = -1;  /* T_fourPortsPartialCoherent_r16 */
static int hf_nr_rrc_offsetSRS_CB_PUSCH_Ant_Switch_fr1_r16 = -1;  /* T_offsetSRS_CB_PUSCH_Ant_Switch_fr1_r16 */
static int hf_nr_rrc_offsetSRS_CB_PUSCH_PDCCH_MonitorSingleOcc_fr1_r16 = -1;  /* T_offsetSRS_CB_PUSCH_PDCCH_MonitorSingleOcc_fr1_r16 */
static int hf_nr_rrc_offsetSRS_CB_PUSCH_PDCCH_MonitorAnyOccWithoutGap_fr1_r16 = -1;  /* T_offsetSRS_CB_PUSCH_PDCCH_MonitorAnyOccWithoutGap_fr1_r16 */
static int hf_nr_rrc_offsetSRS_CB_PUSCH_PDCCH_MonitorAnyOccWithGap_fr1_r16 = -1;  /* T_offsetSRS_CB_PUSCH_PDCCH_MonitorAnyOccWithGap_fr1_r16 */
static int hf_nr_rrc_dummy_01 = -1;               /* T_dummy_01 */
static int hf_nr_rrc_partialCancellationPUCCH_PUSCH_PRACH_TX_r16 = -1;  /* T_partialCancellationPUCCH_PUSCH_PRACH_TX_r16 */
static int hf_nr_rrc_twoHARQ_ACK_Codebook_type1_r16 = -1;  /* SubSlot_Config_r16 */
static int hf_nr_rrc_twoHARQ_ACK_Codebook_type2_r16 = -1;  /* SubSlot_Config_r16 */
static int hf_nr_rrc_offsetSRS_CB_PUSCH_PDCCH_MonitorAnyOccWithSpanGap_fr1_r16 = -1;  /* T_offsetSRS_CB_PUSCH_PDCCH_MonitorAnyOccWithSpanGap_fr1_r16 */
static int hf_nr_rrc_scs_15kHz_r16 = -1;          /* T_scs_15kHz_r16 */
static int hf_nr_rrc_scs_30kHz_r16_01 = -1;       /* T_scs_30kHz_r16 */
static int hf_nr_rrc_scs_60kHz_r16 = -1;          /* T_scs_60kHz_r16 */
static int hf_nr_rrc_sub_SlotConfig_NCP_r16_01 = -1;  /* T_sub_SlotConfig_NCP_r16_01 */
static int hf_nr_rrc_sub_SlotConfig_ECP_r16_01 = -1;  /* T_sub_SlotConfig_ECP_r16_01 */
static int hf_nr_rrc_srs_PosResources_r16 = -1;   /* SRS_PosResources_r16 */
static int hf_nr_rrc_srs_PosResourceAP_r16 = -1;  /* SRS_PosResourceAP_r16 */
static int hf_nr_rrc_srs_PosResourceSP_r16 = -1;  /* SRS_PosResourceSP_r16 */
static int hf_nr_rrc_maxNumberSRS_PosResourceSetPerBWP_r16 = -1;  /* T_maxNumberSRS_PosResourceSetPerBWP_r16 */
static int hf_nr_rrc_maxNumberSRS_PosResourcesPerBWP_r16 = -1;  /* T_maxNumberSRS_PosResourcesPerBWP_r16 */
static int hf_nr_rrc_maxNumberSRS_ResourcesPerBWP_PerSlot_r16 = -1;  /* T_maxNumberSRS_ResourcesPerBWP_PerSlot_r16 */
static int hf_nr_rrc_maxNumberPeriodicSRS_PosResourcesPerBWP_r16 = -1;  /* T_maxNumberPeriodicSRS_PosResourcesPerBWP_r16 */
static int hf_nr_rrc_maxNumberPeriodicSRS_PosResourcesPerBWP_PerSlot_r16 = -1;  /* T_maxNumberPeriodicSRS_PosResourcesPerBWP_PerSlot_r16 */
static int hf_nr_rrc_maxNumberAP_SRS_PosResourcesPerBWP_r16 = -1;  /* T_maxNumberAP_SRS_PosResourcesPerBWP_r16 */
static int hf_nr_rrc_maxNumberAP_SRS_PosResourcesPerBWP_PerSlot_r16 = -1;  /* T_maxNumberAP_SRS_PosResourcesPerBWP_PerSlot_r16 */
static int hf_nr_rrc_maxNumberSP_SRS_PosResourcesPerBWP_r16 = -1;  /* T_maxNumberSP_SRS_PosResourcesPerBWP_r16 */
static int hf_nr_rrc_maxNumberSP_SRS_PosResourcesPerBWP_PerSlot_r16 = -1;  /* T_maxNumberSP_SRS_PosResourcesPerBWP_PerSlot_r16 */
static int hf_nr_rrc_maxNumberAperiodicSRS_PerBWP = -1;  /* T_maxNumberAperiodicSRS_PerBWP */
static int hf_nr_rrc_maxNumberAperiodicSRS_PerBWP_PerSlot = -1;  /* INTEGER_1_6 */
static int hf_nr_rrc_maxNumberPeriodicSRS_PerBWP = -1;  /* T_maxNumberPeriodicSRS_PerBWP */
static int hf_nr_rrc_maxNumberPeriodicSRS_PerBWP_PerSlot = -1;  /* INTEGER_1_6 */
static int hf_nr_rrc_maxNumberSemiPersistentSRS_PerBWP = -1;  /* T_maxNumberSemiPersistentSRS_PerBWP */
static int hf_nr_rrc_maxNumberSemiPersistentSRS_PerBWP_PerSlot = -1;  /* INTEGER_1_6 */
static int hf_nr_rrc_maxNumberSRS_Ports_PerResource = -1;  /* T_maxNumberSRS_Ports_PerResource */
static int hf_nr_rrc_maxNumberPeriodicCSI_ReportPerBWP = -1;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberAperiodicCSI_ReportPerBWP = -1;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberSemiPersistentCSI_ReportPerBWP = -1;  /* INTEGER_0_4 */
static int hf_nr_rrc_supportedSubcarrierSpacingUL = -1;  /* SubcarrierSpacing */
static int hf_nr_rrc_supportedBandwidthUL = -1;   /* SupportedBandwidth */
static int hf_nr_rrc_channelBW_90mhz_01 = -1;     /* T_channelBW_90mhz_01 */
static int hf_nr_rrc_mimo_CB_PUSCH = -1;          /* T_mimo_CB_PUSCH */
static int hf_nr_rrc_maxNumberMIMO_LayersCB_PUSCH = -1;  /* MIMO_LayersUL */
static int hf_nr_rrc_maxNumberSRS_ResourcePerSet = -1;  /* INTEGER_1_2 */
static int hf_nr_rrc_maxNumberMIMO_LayersNonCB_PUSCH = -1;  /* MIMO_LayersUL */
static int hf_nr_rrc_supportedModulationOrderUL = -1;  /* ModulationOrder */
static int hf_nr_rrc_mimo_NonCB_PUSCH = -1;       /* T_mimo_NonCB_PUSCH */
static int hf_nr_rrc_maxNumberSRS_ResourcePerSet_01 = -1;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberSimultaneousSRS_ResourceTx = -1;  /* INTEGER_1_4 */
static int hf_nr_rrc_FreqBandList_item = -1;      /* FreqBandInformation */
static int hf_nr_rrc_bandInformationEUTRA = -1;   /* FreqBandInformationEUTRA */
static int hf_nr_rrc_bandInformationNR = -1;      /* FreqBandInformationNR */
static int hf_nr_rrc_maxBandwidthRequestedDL = -1;  /* AggregatedBandwidth */
static int hf_nr_rrc_maxBandwidthRequestedUL = -1;  /* AggregatedBandwidth */
static int hf_nr_rrc_maxCarriersRequestedDL = -1;  /* INTEGER_1_maxNrofServingCells */
static int hf_nr_rrc_maxCarriersRequestedUL = -1;  /* INTEGER_1_maxNrofServingCells */
static int hf_nr_rrc_measurementEnhancement_r16 = -1;  /* T_measurementEnhancement_r16 */
static int hf_nr_rrc_demodulationEnhancement_r16 = -1;  /* T_demodulationEnhancement_r16 */
static int hf_nr_rrc_intraNR_MeasurementEnhancement_r16 = -1;  /* T_intraNR_MeasurementEnhancement_r16 */
static int hf_nr_rrc_interRAT_MeasurementEnhancement_r16 = -1;  /* T_interRAT_MeasurementEnhancement_r16 */
static int hf_nr_rrc_ims_ParametersCommon = -1;   /* IMS_ParametersCommon */
static int hf_nr_rrc_ims_ParametersFRX_Diff = -1;  /* IMS_ParametersFRX_Diff */
static int hf_nr_rrc_voiceOverEUTRA_5GC = -1;     /* T_voiceOverEUTRA_5GC */
static int hf_nr_rrc_voiceOverSCG_BearerEUTRA_5GC = -1;  /* T_voiceOverSCG_BearerEUTRA_5GC */
static int hf_nr_rrc_voiceFallbackIndicationEPS_r16 = -1;  /* T_voiceFallbackIndicationEPS_r16 */
static int hf_nr_rrc_voiceOverNR = -1;            /* T_voiceOverNR */
static int hf_nr_rrc_eutra_06 = -1;               /* EUTRA_Parameters */
static int hf_nr_rrc_utra_FDD_r16 = -1;           /* UTRA_FDD_Parameters_r16 */
static int hf_nr_rrc_supportedBandListEUTRA = -1;  /* SEQUENCE_SIZE_1_maxBandsEUTRA_OF_FreqBandIndicatorEUTRA */
static int hf_nr_rrc_supportedBandListEUTRA_item = -1;  /* FreqBandIndicatorEUTRA */
static int hf_nr_rrc_eutra_ParametersCommon = -1;  /* EUTRA_ParametersCommon */
static int hf_nr_rrc_eutra_ParametersXDD_Diff = -1;  /* EUTRA_ParametersXDD_Diff */
static int hf_nr_rrc_mfbi_EUTRA = -1;             /* T_mfbi_EUTRA */
static int hf_nr_rrc_modifiedMPR_BehaviorEUTRA = -1;  /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_multiNS_Pmax_EUTRA = -1;     /* T_multiNS_Pmax_EUTRA */
static int hf_nr_rrc_rs_SINR_MeasEUTRA = -1;      /* T_rs_SINR_MeasEUTRA */
static int hf_nr_rrc_ne_DC = -1;                  /* T_ne_DC */
static int hf_nr_rrc_nr_HO_ToEN_DC_r16 = -1;      /* T_nr_HO_ToEN_DC_r16 */
static int hf_nr_rrc_rsrqMeasWidebandEUTRA = -1;  /* T_rsrqMeasWidebandEUTRA */
static int hf_nr_rrc_supportedBandListUTRA_FDD_r16 = -1;  /* SEQUENCE_SIZE_1_maxBandsUTRA_FDD_r16_OF_SupportedBandUTRA_FDD_r16 */
static int hf_nr_rrc_supportedBandListUTRA_FDD_r16_item = -1;  /* SupportedBandUTRA_FDD_r16 */
static int hf_nr_rrc_mac_ParametersCommon = -1;   /* MAC_ParametersCommon */
static int hf_nr_rrc_mac_ParametersXDD_Diff = -1;  /* MAC_ParametersXDD_Diff */
static int hf_nr_rrc_mac_ParametersFRX_Diff_r16 = -1;  /* MAC_ParametersFRX_Diff_r16 */
static int hf_nr_rrc_lcp_Restriction = -1;        /* T_lcp_Restriction */
static int hf_nr_rrc_mAC_ParametersCommon_dummy = -1;  /* T_mAC_ParametersCommon_dummy */
static int hf_nr_rrc_lch_ToSCellRestriction = -1;  /* T_lch_ToSCellRestriction */
static int hf_nr_rrc_recommendedBitRate = -1;     /* T_recommendedBitRate */
static int hf_nr_rrc_recommendedBitRateQuery = -1;  /* T_recommendedBitRateQuery */
static int hf_nr_rrc_recommendedBitRateMultiplier_r16 = -1;  /* T_recommendedBitRateMultiplier_r16 */
static int hf_nr_rrc_preEmptiveBSR_r16 = -1;      /* T_preEmptiveBSR_r16 */
static int hf_nr_rrc_autonomousTransmission_r16 = -1;  /* T_autonomousTransmission_r16 */
static int hf_nr_rrc_lch_PriorityBasedPrioritization_r16 = -1;  /* T_lch_PriorityBasedPrioritization_r16 */
static int hf_nr_rrc_lch_ToConfiguredGrantMapping_r16 = -1;  /* T_lch_ToConfiguredGrantMapping_r16 */
static int hf_nr_rrc_lch_ToGrantPriorityRestriction_r16 = -1;  /* T_lch_ToGrantPriorityRestriction_r16 */
static int hf_nr_rrc_singlePHR_P_r16 = -1;        /* T_singlePHR_P_r16 */
static int hf_nr_rrc_ul_LBT_FailureDetectionRecovery_r16 = -1;  /* T_ul_LBT_FailureDetectionRecovery_r16 */
static int hf_nr_rrc_tdd_MPE_P_MPR_Reporting_r16 = -1;  /* T_tdd_MPE_P_MPR_Reporting_r16 */
static int hf_nr_rrc_lcid_ExtensionIAB_r16 = -1;  /* T_lcid_ExtensionIAB_r16 */
static int hf_nr_rrc_spCell_BFR_CBRA_r16_01 = -1;  /* T_spCell_BFR_CBRA_r16_01 */
static int hf_nr_rrc_srs_ResourceId_Ext_r16 = -1;  /* T_srs_ResourceId_Ext_r16 */
static int hf_nr_rrc_directMCG_SCellActivation_r16 = -1;  /* T_directMCG_SCellActivation_r16 */
static int hf_nr_rrc_directMCG_SCellActivationResume_r16 = -1;  /* T_directMCG_SCellActivationResume_r16 */
static int hf_nr_rrc_directSCG_SCellActivation_r16 = -1;  /* T_directSCG_SCellActivation_r16 */
static int hf_nr_rrc_directSCG_SCellActivationResume_r16 = -1;  /* T_directSCG_SCellActivationResume_r16 */
static int hf_nr_rrc_drx_Adaptation_r16 = -1;     /* T_drx_Adaptation_r16 */
static int hf_nr_rrc_non_SharedSpectrumChAccess_r16 = -1;  /* MinTimeGap_r16 */
static int hf_nr_rrc_sharedSpectrumChAccess_r16 = -1;  /* MinTimeGap_r16 */
static int hf_nr_rrc_skipUplinkTxDynamic = -1;    /* T_skipUplinkTxDynamic */
static int hf_nr_rrc_logicalChannelSR_DelayTimer_01 = -1;  /* T_logicalChannelSR_DelayTimer_01 */
static int hf_nr_rrc_longDRX_Cycle = -1;          /* T_longDRX_Cycle */
static int hf_nr_rrc_shortDRX_Cycle = -1;         /* T_shortDRX_Cycle */
static int hf_nr_rrc_multipleSR_Configurations = -1;  /* T_multipleSR_Configurations */
static int hf_nr_rrc_multipleConfiguredGrants = -1;  /* T_multipleConfiguredGrants */
static int hf_nr_rrc_secondaryDRX_Group_r16 = -1;  /* T_secondaryDRX_Group_r16 */
static int hf_nr_rrc_enhancedSkipUplinkTxDynamic_r16_01 = -1;  /* T_enhancedSkipUplinkTxDynamic_r16_01 */
static int hf_nr_rrc_enhancedSkipUplinkTxConfigured_r16_01 = -1;  /* T_enhancedSkipUplinkTxConfigured_r16_01 */
static int hf_nr_rrc_scs_15kHz_r16_01 = -1;       /* T_scs_15kHz_r16_01 */
static int hf_nr_rrc_minTimeGap_r16_scs_30kHz_r16 = -1;  /* T_minTimeGap_r16_scs_30kHz_r16 */
static int hf_nr_rrc_minTimeGap_r16_scs_60kHz_r16 = -1;  /* T_minTimeGap_r16_scs_60kHz_r16 */
static int hf_nr_rrc_minTimeGap_r16_scs_120kHz_r16 = -1;  /* T_minTimeGap_r16_scs_120kHz_r16 */
static int hf_nr_rrc_measAndMobParametersCommon = -1;  /* MeasAndMobParametersCommon */
static int hf_nr_rrc_measAndMobParametersXDD_Diff = -1;  /* MeasAndMobParametersXDD_Diff */
static int hf_nr_rrc_measAndMobParametersFRX_Diff = -1;  /* MeasAndMobParametersFRX_Diff */
static int hf_nr_rrc_supportedGapPattern = -1;    /* BIT_STRING_SIZE_22 */
static int hf_nr_rrc_ssb_RLM = -1;                /* T_ssb_RLM */
static int hf_nr_rrc_ssb_AndCSI_RS_RLM = -1;      /* T_ssb_AndCSI_RS_RLM */
static int hf_nr_rrc_eventB_MeasAndReport = -1;   /* T_eventB_MeasAndReport */
static int hf_nr_rrc_handoverFDD_TDD = -1;        /* T_handoverFDD_TDD */
static int hf_nr_rrc_eutra_CGI_Reporting = -1;    /* T_eutra_CGI_Reporting */
static int hf_nr_rrc_nr_CGI_Reporting = -1;       /* T_nr_CGI_Reporting */
static int hf_nr_rrc_independentGapConfig = -1;   /* T_independentGapConfig */
static int hf_nr_rrc_periodicEUTRA_MeasAndReport = -1;  /* T_periodicEUTRA_MeasAndReport */
static int hf_nr_rrc_handoverFR1_FR2 = -1;        /* T_handoverFR1_FR2 */
static int hf_nr_rrc_maxNumberCSI_RS_RRM_RS_SINR = -1;  /* T_maxNumberCSI_RS_RRM_RS_SINR */
static int hf_nr_rrc_nr_CGI_Reporting_ENDC = -1;  /* T_nr_CGI_Reporting_ENDC */
static int hf_nr_rrc_eutra_CGI_Reporting_NEDC = -1;  /* T_eutra_CGI_Reporting_NEDC */
static int hf_nr_rrc_eutra_CGI_Reporting_NRDC = -1;  /* T_eutra_CGI_Reporting_NRDC */
static int hf_nr_rrc_nr_CGI_Reporting_NEDC = -1;  /* T_nr_CGI_Reporting_NEDC */
static int hf_nr_rrc_nr_CGI_Reporting_NRDC = -1;  /* T_nr_CGI_Reporting_NRDC */
static int hf_nr_rrc_reportAddNeighMeasForPeriodic_r16 = -1;  /* T_reportAddNeighMeasForPeriodic_r16 */
static int hf_nr_rrc_condHandoverParametersCommon_r16 = -1;  /* T_condHandoverParametersCommon_r16 */
static int hf_nr_rrc_condHandoverFDD_TDD_r16 = -1;  /* T_condHandoverFDD_TDD_r16 */
static int hf_nr_rrc_condHandoverFR1_FR2_r16 = -1;  /* T_condHandoverFR1_FR2_r16 */
static int hf_nr_rrc_nr_NeedForGap_Reporting_r16 = -1;  /* T_nr_NeedForGap_Reporting_r16 */
static int hf_nr_rrc_supportedGapPattern_NRonly_r16 = -1;  /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_supportedGapPattern_NRonly_NEDC_r16 = -1;  /* T_supportedGapPattern_NRonly_NEDC_r16 */
static int hf_nr_rrc_maxNumberCLI_RSSI_r16 = -1;  /* T_maxNumberCLI_RSSI_r16 */
static int hf_nr_rrc_maxNumberCLI_SRS_RSRP_r16 = -1;  /* T_maxNumberCLI_SRS_RSRP_r16 */
static int hf_nr_rrc_maxNumberPerSlotCLI_SRS_RSRP_r16 = -1;  /* T_maxNumberPerSlotCLI_SRS_RSRP_r16 */
static int hf_nr_rrc_mfbi_IAB_r16 = -1;           /* T_mfbi_IAB_r16 */
static int hf_nr_rrc_measAndMobParametersCommon_eag_5_dummy = -1;  /* T_measAndMobParametersCommon_eag_5_dummy */
static int hf_nr_rrc_nr_CGI_Reporting_NPN_r16 = -1;  /* T_nr_CGI_Reporting_NPN_r16 */
static int hf_nr_rrc_idleInactiveEUTRA_MeasReport_r16 = -1;  /* T_idleInactiveEUTRA_MeasReport_r16 */
static int hf_nr_rrc_idleInactive_ValidityArea_r16 = -1;  /* T_idleInactive_ValidityArea_r16 */
static int hf_nr_rrc_eutra_AutonomousGaps_r16 = -1;  /* T_eutra_AutonomousGaps_r16 */
static int hf_nr_rrc_eutra_AutonomousGaps_NEDC_r16 = -1;  /* T_eutra_AutonomousGaps_NEDC_r16 */
static int hf_nr_rrc_eutra_AutonomousGaps_NRDC_r16 = -1;  /* T_eutra_AutonomousGaps_NRDC_r16 */
static int hf_nr_rrc_pcellT312_r16 = -1;          /* T_pcellT312_r16 */
static int hf_nr_rrc_supportedGapPattern_r16 = -1;  /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_intraAndInterF_MeasAndReport = -1;  /* T_intraAndInterF_MeasAndReport */
static int hf_nr_rrc_eventA_MeasAndReport = -1;   /* T_eventA_MeasAndReport */
static int hf_nr_rrc_handoverInterF = -1;         /* T_handoverInterF */
static int hf_nr_rrc_handoverLTE_EPC = -1;        /* T_handoverLTE_EPC */
static int hf_nr_rrc_handoverLTE_5GC = -1;        /* T_handoverLTE_5GC */
static int hf_nr_rrc_sftd_MeasNR_Neigh = -1;      /* T_sftd_MeasNR_Neigh */
static int hf_nr_rrc_sftd_MeasNR_Neigh_DRX = -1;  /* T_sftd_MeasNR_Neigh_DRX */
static int hf_nr_rrc_dummy_02 = -1;               /* T_dummy_02 */
static int hf_nr_rrc_ss_SINR_Meas = -1;           /* T_ss_SINR_Meas */
static int hf_nr_rrc_csi_RSRP_AndRSRQ_MeasWithSSB = -1;  /* T_csi_RSRP_AndRSRQ_MeasWithSSB */
static int hf_nr_rrc_csi_RSRP_AndRSRQ_MeasWithoutSSB = -1;  /* T_csi_RSRP_AndRSRQ_MeasWithoutSSB */
static int hf_nr_rrc_csi_SINR_Meas = -1;          /* T_csi_SINR_Meas */
static int hf_nr_rrc_csi_RS_RLM = -1;             /* T_csi_RS_RLM */
static int hf_nr_rrc_handoverInterF_01 = -1;      /* T_handoverInterF_01 */
static int hf_nr_rrc_handoverLTE_EPC_01 = -1;     /* T_handoverLTE_EPC_01 */
static int hf_nr_rrc_handoverLTE_5GC_01 = -1;     /* T_handoverLTE_5GC_01 */
static int hf_nr_rrc_maxNumberResource_CSI_RS_RLM = -1;  /* T_maxNumberResource_CSI_RS_RLM */
static int hf_nr_rrc_simultaneousRxDataSSB_DiffNumerology = -1;  /* T_simultaneousRxDataSSB_DiffNumerology */
static int hf_nr_rrc_nr_AutonomousGaps_r16 = -1;  /* T_nr_AutonomousGaps_r16 */
static int hf_nr_rrc_nr_AutonomousGaps_ENDC_r16 = -1;  /* T_nr_AutonomousGaps_ENDC_r16 */
static int hf_nr_rrc_nr_AutonomousGaps_NEDC_r16 = -1;  /* T_nr_AutonomousGaps_NEDC_r16 */
static int hf_nr_rrc_nr_AutonomousGaps_NRDC_r16 = -1;  /* T_nr_AutonomousGaps_NRDC_r16 */
static int hf_nr_rrc_dummy_03 = -1;               /* T_dummy_03 */
static int hf_nr_rrc_cli_RSSI_Meas_r16 = -1;      /* T_cli_RSSI_Meas_r16 */
static int hf_nr_rrc_cli_SRS_RSRP_Meas_r16 = -1;  /* T_cli_SRS_RSRP_Meas_r16 */
static int hf_nr_rrc_interFrequencyMeas_NoGap_r16 = -1;  /* T_interFrequencyMeas_NoGap_r16 */
static int hf_nr_rrc_simultaneousRxDataSSB_DiffNumerology_Inter_r16 = -1;  /* T_simultaneousRxDataSSB_DiffNumerology_Inter_r16 */
static int hf_nr_rrc_idleInactiveNR_MeasReport_r16 = -1;  /* T_idleInactiveNR_MeasReport_r16 */
static int hf_nr_rrc_idleInactiveNR_MeasBeamReport_r16 = -1;  /* T_idleInactiveNR_MeasBeamReport_r16 */
static int hf_nr_rrc_increasedNumberofCSIRSPerMO_r16 = -1;  /* T_increasedNumberofCSIRSPerMO_r16 */
static int hf_nr_rrc_measAndMobParametersMRDC_Common = -1;  /* MeasAndMobParametersMRDC_Common */
static int hf_nr_rrc_measAndMobParametersMRDC_XDD_Diff = -1;  /* MeasAndMobParametersMRDC_XDD_Diff */
static int hf_nr_rrc_measAndMobParametersMRDC_FRX_Diff = -1;  /* MeasAndMobParametersMRDC_FRX_Diff */
static int hf_nr_rrc_measAndMobParametersMRDC_XDD_Diff_v1560 = -1;  /* MeasAndMobParametersMRDC_XDD_Diff_v1560 */
static int hf_nr_rrc_measAndMobParametersMRDC_Common_v1610 = -1;  /* MeasAndMobParametersMRDC_Common_v1610 */
static int hf_nr_rrc_interNR_MeasEUTRA_IAB_r16 = -1;  /* T_interNR_MeasEUTRA_IAB_r16 */
static int hf_nr_rrc_independentGapConfig_01 = -1;  /* T_independentGapConfig_01 */
static int hf_nr_rrc_condPSCellChangeParametersCommon_r16 = -1;  /* T_condPSCellChangeParametersCommon_r16 */
static int hf_nr_rrc_condPSCellChangeFDD_TDD_r16 = -1;  /* T_condPSCellChangeFDD_TDD_r16 */
static int hf_nr_rrc_condPSCellChangeFR1_FR2_r16 = -1;  /* T_condPSCellChangeFR1_FR2_r16 */
static int hf_nr_rrc_pscellT312_r16 = -1;         /* T_pscellT312_r16 */
static int hf_nr_rrc_sftd_MeasPSCell = -1;        /* T_sftd_MeasPSCell */
static int hf_nr_rrc_sftd_MeasNR_Cell = -1;       /* T_sftd_MeasNR_Cell */
static int hf_nr_rrc_sftd_MeasPSCell_NEDC = -1;   /* T_sftd_MeasPSCell_NEDC */
static int hf_nr_rrc_simultaneousRxDataSSB_DiffNumerology_01 = -1;  /* T_simultaneousRxDataSSB_DiffNumerology_01 */
static int hf_nr_rrc_tci_StatePDSCH = -1;         /* T_tci_StatePDSCH */
static int hf_nr_rrc_maxNumberConfiguredTCIstatesPerCC = -1;  /* T_maxNumberConfiguredTCIstatesPerCC */
static int hf_nr_rrc_maxNumberActiveTCI_PerBWP = -1;  /* T_maxNumberActiveTCI_PerBWP */
static int hf_nr_rrc_additionalActiveTCI_StatePDCCH = -1;  /* T_additionalActiveTCI_StatePDCCH */
static int hf_nr_rrc_pusch_TransCoherence = -1;   /* T_pusch_TransCoherence */
static int hf_nr_rrc_beamCorrespondenceWithoutUL_BeamSweeping = -1;  /* T_beamCorrespondenceWithoutUL_BeamSweeping */
static int hf_nr_rrc_periodicBeamReport = -1;     /* T_periodicBeamReport */
static int hf_nr_rrc_aperiodicBeamReport = -1;    /* T_aperiodicBeamReport */
static int hf_nr_rrc_sp_BeamReportPUCCH = -1;     /* T_sp_BeamReportPUCCH */
static int hf_nr_rrc_sp_BeamReportPUSCH = -1;     /* T_sp_BeamReportPUSCH */
static int hf_nr_rrc_mIMO_ParametersPerBand_dummy1 = -1;  /* DummyG */
static int hf_nr_rrc_maxNumberRxBeam = -1;        /* INTEGER_2_8 */
static int hf_nr_rrc_maxNumberRxTxBeamSwitchDL = -1;  /* T_maxNumberRxTxBeamSwitchDL */
static int hf_nr_rrc_mIMO_ParametersPerBand_maxNumberRxTxBeamSwitchDL_scs_15kHz = -1;  /* T_mIMO_ParametersPerBand_maxNumberRxTxBeamSwitchDL_scs_15kHz */
static int hf_nr_rrc_scs_30kHz_04 = -1;           /* T_scs_30kHz_03 */
static int hf_nr_rrc_mIMO_ParametersPerBand_maxNumberRxTxBeamSwitchDL_scs_60kHz = -1;  /* T_mIMO_ParametersPerBand_maxNumberRxTxBeamSwitchDL_scs_60kHz */
static int hf_nr_rrc_mIMO_ParametersPerBand_maxNumberRxTxBeamSwitchDL_scs_120kHz = -1;  /* T_mIMO_ParametersPerBand_maxNumberRxTxBeamSwitchDL_scs_120kHz */
static int hf_nr_rrc_scs_240kHz = -1;             /* T_scs_240kHz */
static int hf_nr_rrc_maxNumberNonGroupBeamReporting = -1;  /* T_maxNumberNonGroupBeamReporting */
static int hf_nr_rrc_groupBeamReporting = -1;     /* T_groupBeamReporting */
static int hf_nr_rrc_uplinkBeamManagement = -1;   /* T_uplinkBeamManagement */
static int hf_nr_rrc_maxNumberSRS_ResourcePerSet_BM = -1;  /* T_maxNumberSRS_ResourcePerSet_BM */
static int hf_nr_rrc_maxNumberSRS_ResourceSet = -1;  /* INTEGER_1_8 */
static int hf_nr_rrc_maxNumberCSI_RS_BFD = -1;    /* INTEGER_1_64 */
static int hf_nr_rrc_maxNumberSSB_BFD = -1;       /* INTEGER_1_64 */
static int hf_nr_rrc_maxNumberCSI_RS_SSB_CBD = -1;  /* INTEGER_1_256 */
static int hf_nr_rrc_mIMO_ParametersPerBand_dummy2 = -1;  /* T_mIMO_ParametersPerBand_dummy2 */
static int hf_nr_rrc_twoPortsPTRS_UL = -1;        /* T_twoPortsPTRS_UL */
static int hf_nr_rrc_mIMO_ParametersPerBand_dummy5 = -1;  /* SRS_Resources */
static int hf_nr_rrc_mIMO_ParametersPerBand_dummy3 = -1;  /* INTEGER_1_4 */
static int hf_nr_rrc_beamReportTiming = -1;       /* T_beamReportTiming */
static int hf_nr_rrc_mIMO_ParametersPerBand_beamReportTiming_scs_15kHz = -1;  /* T_mIMO_ParametersPerBand_beamReportTiming_scs_15kHz */
static int hf_nr_rrc_scs_30kHz_05 = -1;           /* T_scs_30kHz_04 */
static int hf_nr_rrc_mIMO_ParametersPerBand_beamReportTiming_scs_60kHz = -1;  /* T_mIMO_ParametersPerBand_beamReportTiming_scs_60kHz */
static int hf_nr_rrc_mIMO_ParametersPerBand_beamReportTiming_scs_120kHz = -1;  /* T_mIMO_ParametersPerBand_beamReportTiming_scs_120kHz */
static int hf_nr_rrc_ptrs_DensityRecommendationSetDL = -1;  /* T_ptrs_DensityRecommendationSetDL */
static int hf_nr_rrc_mIMO_ParametersPerBand_ptrs_DensityRecommendationSetDL_scs_15kHz = -1;  /* PTRS_DensityRecommendationDL */
static int hf_nr_rrc_scs_30kHz_06 = -1;           /* PTRS_DensityRecommendationDL */
static int hf_nr_rrc_mIMO_ParametersPerBand_ptrs_DensityRecommendationSetDL_scs_60kHz = -1;  /* PTRS_DensityRecommendationDL */
static int hf_nr_rrc_mIMO_ParametersPerBand_ptrs_DensityRecommendationSetDL_scs_120kHz = -1;  /* PTRS_DensityRecommendationDL */
static int hf_nr_rrc_ptrs_DensityRecommendationSetUL = -1;  /* T_ptrs_DensityRecommendationSetUL */
static int hf_nr_rrc_mIMO_ParametersPerBand_ptrs_DensityRecommendationSetUL_scs_15kHz = -1;  /* PTRS_DensityRecommendationUL */
static int hf_nr_rrc_scs_30kHz_07 = -1;           /* PTRS_DensityRecommendationUL */
static int hf_nr_rrc_mIMO_ParametersPerBand_ptrs_DensityRecommendationSetUL_scs_60kHz = -1;  /* PTRS_DensityRecommendationUL */
static int hf_nr_rrc_mIMO_ParametersPerBand_ptrs_DensityRecommendationSetUL_scs_120kHz = -1;  /* PTRS_DensityRecommendationUL */
static int hf_nr_rrc_mIMO_ParametersPerBand_dummy4 = -1;  /* DummyH */
static int hf_nr_rrc_aperiodicTRS = -1;           /* T_aperiodicTRS */
static int hf_nr_rrc_mIMO_ParametersPerBand_eag_1_dummy6 = -1;  /* T_mIMO_ParametersPerBand_eag_1_dummy6 */
static int hf_nr_rrc_beamManagementSSB_CSI_RS = -1;  /* BeamManagementSSB_CSI_RS */
static int hf_nr_rrc_beamSwitchTiming = -1;       /* T_beamSwitchTiming */
static int hf_nr_rrc_MmIMO_ParametersPerBand_eag_1_beamSwitchTiming_scs_60kHz = -1;  /* T_MmIMO_ParametersPerBand_eag_1_beamSwitchTiming_scs_60kHz */
static int hf_nr_rrc_mIMO_ParametersPerBand_eag_1_beamSwitchTiming_scs_120kHz = -1;  /* T_mIMO_ParametersPerBand_eag_1_beamSwitchTiming_scs_120kHz */
static int hf_nr_rrc_codebookParameters = -1;     /* CodebookParameters */
static int hf_nr_rrc_csi_RS_IM_ReceptionForFeedback = -1;  /* CSI_RS_IM_ReceptionForFeedback */
static int hf_nr_rrc_csi_RS_ProcFrameworkForSRS = -1;  /* CSI_RS_ProcFrameworkForSRS */
static int hf_nr_rrc_csi_ReportFramework = -1;    /* CSI_ReportFramework */
static int hf_nr_rrc_csi_RS_ForTracking = -1;     /* CSI_RS_ForTracking */
static int hf_nr_rrc_srs_AssocCSI_RS = -1;        /* SEQUENCE_SIZE_1_maxNrofCSI_RS_Resources_OF_SupportedCSI_RS_Resource */
static int hf_nr_rrc_srs_AssocCSI_RS_item = -1;   /* SupportedCSI_RS_Resource */
static int hf_nr_rrc_spatialRelations = -1;       /* SpatialRelations */
static int hf_nr_rrc_defaultQCL_TwoTCI_r16 = -1;  /* T_defaultQCL_TwoTCI_r16 */
static int hf_nr_rrc_codebookParametersPerBand_r16 = -1;  /* CodebookParameters_v1610 */
static int hf_nr_rrc_simul_SpatialRelationUpdatePUCCHResGroup_r16 = -1;  /* T_simul_SpatialRelationUpdatePUCCHResGroup_r16 */
static int hf_nr_rrc_maxNumberSCellBFR_r16 = -1;  /* T_maxNumberSCellBFR_r16 */
static int hf_nr_rrc_simultaneousReceptionDiffTypeD_r16 = -1;  /* T_simultaneousReceptionDiffTypeD_r16 */
static int hf_nr_rrc_ssb_csirs_SINR_measurement_r16 = -1;  /* T_ssb_csirs_SINR_measurement_r16 */
static int hf_nr_rrc_maxNumberSSB_CSIRS_OneTx_CMR_r16 = -1;  /* T_maxNumberSSB_CSIRS_OneTx_CMR_r16 */
static int hf_nr_rrc_maxNumberCSI_IM_NZP_IMR_res_r16 = -1;  /* T_maxNumberCSI_IM_NZP_IMR_res_r16 */
static int hf_nr_rrc_maxNumberCSIRS_2Tx_res_r16 = -1;  /* T_maxNumberCSIRS_2Tx_res_r16 */
static int hf_nr_rrc_maxNumberSSB_CSIRS_res_r16 = -1;  /* T_maxNumberSSB_CSIRS_res_r16 */
static int hf_nr_rrc_maxNumberCSI_IM_NZP_IMR_res_mem_r16 = -1;  /* T_maxNumberCSI_IM_NZP_IMR_res_mem_r16 */
static int hf_nr_rrc_supportedCSI_RS_Density_CMR_r16 = -1;  /* T_supportedCSI_RS_Density_CMR_r16 */
static int hf_nr_rrc_maxNumberAperiodicCSI_RS_Res_r16 = -1;  /* T_maxNumberAperiodicCSI_RS_Res_r16 */
static int hf_nr_rrc_supportedSINR_meas_r16 = -1;  /* T_supportedSINR_meas_r16 */
static int hf_nr_rrc_nonGroupSINR_reporting_r16 = -1;  /* T_nonGroupSINR_reporting_r16 */
static int hf_nr_rrc_groupSINR_reporting_r16 = -1;  /* T_groupSINR_reporting_r16 */
static int hf_nr_rrc_multiDCI_multiTRP_Parameters_r16 = -1;  /* T_multiDCI_multiTRP_Parameters_r16 */
static int hf_nr_rrc_overlapPDSCHsFullyFreqTime_r16 = -1;  /* INTEGER_1_2 */
static int hf_nr_rrc_overlapPDSCHsInTimePartiallyFreq_r16 = -1;  /* T_overlapPDSCHsInTimePartiallyFreq_r16 */
static int hf_nr_rrc_outOfOrderOperationDL_r16 = -1;  /* T_outOfOrderOperationDL_r16 */
static int hf_nr_rrc_supportPDCCH_ToPDSCH_r16 = -1;  /* T_supportPDCCH_ToPDSCH_r16 */
static int hf_nr_rrc_supportPDSCH_ToHARQ_ACK_r16 = -1;  /* T_supportPDSCH_ToHARQ_ACK_r16 */
static int hf_nr_rrc_outOfOrderOperationUL_r16 = -1;  /* T_outOfOrderOperationUL_r16 */
static int hf_nr_rrc_separateCRS_RateMatching_r16 = -1;  /* T_separateCRS_RateMatching_r16 */
static int hf_nr_rrc_defaultQCL_PerCORESETPoolIndex_r16 = -1;  /* T_defaultQCL_PerCORESETPoolIndex_r16 */
static int hf_nr_rrc_maxNumberActivatedTCI_States_r16 = -1;  /* T_maxNumberActivatedTCI_States_r16 */
static int hf_nr_rrc_maxNumberPerCORESET_Pool_r16 = -1;  /* T_maxNumberPerCORESET_Pool_r16 */
static int hf_nr_rrc_maxTotalNumberAcrossCORESET_Pool_r16 = -1;  /* T_maxTotalNumberAcrossCORESET_Pool_r16 */
static int hf_nr_rrc_singleDCI_SDM_scheme_Parameters_r16 = -1;  /* T_singleDCI_SDM_scheme_Parameters_r16 */
static int hf_nr_rrc_supportNewDMRS_Port_r16 = -1;  /* T_supportNewDMRS_Port_r16 */
static int hf_nr_rrc_supportTwoPortDL_PTRS_r16 = -1;  /* T_supportTwoPortDL_PTRS_r16 */
static int hf_nr_rrc_supportFDM_SchemeA_r16 = -1;  /* T_supportFDM_SchemeA_r16 */
static int hf_nr_rrc_supportCodeWordSoftCombining_r16 = -1;  /* T_supportCodeWordSoftCombining_r16 */
static int hf_nr_rrc_supportTDM_SchemeA_r16 = -1;  /* T_supportTDM_SchemeA_r16 */
static int hf_nr_rrc_supportInter_slotTDM_r16 = -1;  /* T_supportInter_slotTDM_r16 */
static int hf_nr_rrc_supportRepNumPDSCH_TDRA_r16 = -1;  /* T_supportRepNumPDSCH_TDRA_r16 */
static int hf_nr_rrc_maxTBS_Size_r16 = -1;        /* T_maxTBS_Size_r16 */
static int hf_nr_rrc_maxNumberTCI_states_r16 = -1;  /* INTEGER_1_2 */
static int hf_nr_rrc_lowPAPR_DMRS_PDSCH_r16 = -1;  /* T_lowPAPR_DMRS_PDSCH_r16 */
static int hf_nr_rrc_lowPAPR_DMRS_PUSCHwithoutPrecoding_r16 = -1;  /* T_lowPAPR_DMRS_PUSCHwithoutPrecoding_r16 */
static int hf_nr_rrc_lowPAPR_DMRS_PUCCH_r16 = -1;  /* T_lowPAPR_DMRS_PUCCH_r16 */
static int hf_nr_rrc_lowPAPR_DMRS_PUSCHwithPrecoding_r16 = -1;  /* T_lowPAPR_DMRS_PUSCHwithPrecoding_r16 */
static int hf_nr_rrc_csi_ReportFrameworkExt_r16 = -1;  /* CSI_ReportFrameworkExt_r16 */
static int hf_nr_rrc_codebookParametersAddition_r16 = -1;  /* CodebookParametersAddition_r16 */
static int hf_nr_rrc_codebookComboParametersAddition_r16 = -1;  /* CodebookComboParametersAddition_r16 */
static int hf_nr_rrc_beamCorrespondenceSSB_based_r16 = -1;  /* T_beamCorrespondenceSSB_based_r16 */
static int hf_nr_rrc_beamCorrespondenceCSI_RS_based_r16 = -1;  /* T_beamCorrespondenceCSI_RS_based_r16 */
static int hf_nr_rrc_beamSwitchTiming_r16 = -1;   /* T_beamSwitchTiming_r16 */
static int hf_nr_rrc_mIMO_ParametersPerBand_eag_2_beamSwitchTiming_r16_scs_60kHz_r16 = -1;  /* T_mIMO_ParametersPerBand_eag_2_beamSwitchTiming_r16_scs_60kHz_r16 */
static int hf_nr_rrc_mIMO_ParametersPerBand_eag_2_beamSwitchTiming_r16_scs_120kHz_r16 = -1;  /* T_mIMO_ParametersPerBand_eag_2_beamSwitchTiming_r16_scs_120kHz_r16 */
static int hf_nr_rrc_semi_PersistentL1_SINR_Report_PUCCH_r16 = -1;  /* T_semi_PersistentL1_SINR_Report_PUCCH_r16 */
static int hf_nr_rrc_supportReportFormat1_2OFDM_syms_r16 = -1;  /* T_supportReportFormat1_2OFDM_syms_r16 */
static int hf_nr_rrc_supportReportFormat4_14OFDM_syms_r16 = -1;  /* T_supportReportFormat4_14OFDM_syms_r16 */
static int hf_nr_rrc_semi_PersistentL1_SINR_Report_PUSCH_r16 = -1;  /* T_semi_PersistentL1_SINR_Report_PUSCH_r16 */
static int hf_nr_rrc_spatialRelations_v1640 = -1;  /* T_spatialRelations_v1640 */
static int hf_nr_rrc_maxNumberConfiguredSpatialRelations_v1640 = -1;  /* T_maxNumberConfiguredSpatialRelations_v1640 */
static int hf_nr_rrc_support64CandidateBeamRS_BFR_r16 = -1;  /* T_support64CandidateBeamRS_BFR_r16 */
static int hf_nr_rrc_maxMIMO_LayersForMulti_DCI_mTRP_r16 = -1;  /* T_maxMIMO_LayersForMulti_DCI_mTRP_r16 */
static int hf_nr_rrc_supportedSINR_meas_v1670 = -1;  /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_maxNumberSSB_CSI_RS_ResourceOneTx = -1;  /* T_maxNumberSSB_CSI_RS_ResourceOneTx */
static int hf_nr_rrc_maxNumberSSB_CSI_RS_ResourceTwoTx = -1;  /* T_maxNumberSSB_CSI_RS_ResourceTwoTx */
static int hf_nr_rrc_supportedCSI_RS_Density = -1;  /* T_supportedCSI_RS_Density */
static int hf_nr_rrc_maxNumberSSB_CSI_RS_ResourceOneTx_01 = -1;  /* T_maxNumberSSB_CSI_RS_ResourceOneTx_01 */
static int hf_nr_rrc_maxNumberCSI_RS_Resource = -1;  /* T_maxNumberCSI_RS_Resource */
static int hf_nr_rrc_maxNumberCSI_RS_ResourceTwoTx = -1;  /* T_maxNumberCSI_RS_ResourceTwoTx */
static int hf_nr_rrc_supportedCSI_RS_Density_01 = -1;  /* T_supportedCSI_RS_Density_01 */
static int hf_nr_rrc_maxNumberAperiodicCSI_RS_Resource = -1;  /* T_maxNumberAperiodicCSI_RS_Resource */
static int hf_nr_rrc_burstLength = -1;            /* INTEGER_1_2 */
static int hf_nr_rrc_maxSimultaneousResourceSetsPerCC = -1;  /* INTEGER_1_8 */
static int hf_nr_rrc_maxConfiguredResourceSetsPerCC = -1;  /* INTEGER_1_64 */
static int hf_nr_rrc_maxConfiguredResourceSetsAllCC = -1;  /* INTEGER_1_128 */
static int hf_nr_rrc_maxBurstLength = -1;         /* INTEGER_1_2 */
static int hf_nr_rrc_maxConfiguredResourceSetsAllCC_01 = -1;  /* INTEGER_1_256 */
static int hf_nr_rrc_maxConfigNumberNZP_CSI_RS_PerCC = -1;  /* INTEGER_1_64 */
static int hf_nr_rrc_maxConfigNumberPortsAcrossNZP_CSI_RS_PerCC = -1;  /* INTEGER_2_256 */
static int hf_nr_rrc_maxConfigNumberCSI_IM_PerCC = -1;  /* T_maxConfigNumberCSI_IM_PerCC */
static int hf_nr_rrc_maxNumberSimultaneousNZP_CSI_RS_PerCC = -1;  /* INTEGER_1_64 */
static int hf_nr_rrc_totalNumberPortsSimultaneousNZP_CSI_RS_PerCC = -1;  /* INTEGER_2_256 */
static int hf_nr_rrc_maxNumberPeriodicSRS_AssocCSI_RS_PerBWP = -1;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberAperiodicSRS_AssocCSI_RS_PerBWP = -1;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberSP_SRS_AssocCSI_RS_PerBWP = -1;  /* INTEGER_0_4 */
static int hf_nr_rrc_simultaneousSRS_AssocCSI_RS_PerCC = -1;  /* INTEGER_1_8 */
static int hf_nr_rrc_maxNumberPeriodicCSI_PerBWP_ForCSI_Report = -1;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberAperiodicCSI_PerBWP_ForCSI_Report = -1;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberSemiPersistentCSI_PerBWP_ForCSI_Report = -1;  /* INTEGER_0_4 */
static int hf_nr_rrc_maxNumberPeriodicCSI_PerBWP_ForBeamReport = -1;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberAperiodicCSI_PerBWP_ForBeamReport = -1;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberAperiodicCSI_triggeringStatePerCC = -1;  /* T_maxNumberAperiodicCSI_triggeringStatePerCC */
static int hf_nr_rrc_maxNumberSemiPersistentCSI_PerBWP_ForBeamReport = -1;  /* INTEGER_0_4 */
static int hf_nr_rrc_simultaneousCSI_ReportsPerCC = -1;  /* INTEGER_1_8 */
static int hf_nr_rrc_maxNumberAperiodicCSI_PerBWP_ForCSI_ReportExt_r16 = -1;  /* INTEGER_5_8 */
static int hf_nr_rrc_frequencyDensity1 = -1;      /* INTEGER_1_276 */
static int hf_nr_rrc_frequencyDensity2 = -1;      /* INTEGER_1_276 */
static int hf_nr_rrc_timeDensity1 = -1;           /* INTEGER_0_29 */
static int hf_nr_rrc_timeDensity2 = -1;           /* INTEGER_0_29 */
static int hf_nr_rrc_timeDensity3 = -1;           /* INTEGER_0_29 */
static int hf_nr_rrc_sampleDensity1 = -1;         /* INTEGER_1_276 */
static int hf_nr_rrc_sampleDensity2 = -1;         /* INTEGER_1_276 */
static int hf_nr_rrc_sampleDensity3 = -1;         /* INTEGER_1_276 */
static int hf_nr_rrc_sampleDensity4 = -1;         /* INTEGER_1_276 */
static int hf_nr_rrc_sampleDensity5 = -1;         /* INTEGER_1_276 */
static int hf_nr_rrc_maxNumberConfiguredSpatialRelations = -1;  /* T_maxNumberConfiguredSpatialRelations */
static int hf_nr_rrc_maxNumberActiveSpatialRelations = -1;  /* T_maxNumberActiveSpatialRelations */
static int hf_nr_rrc_additionalActiveSpatialRelationPUCCH = -1;  /* T_additionalActiveSpatialRelationPUCCH */
static int hf_nr_rrc_maxNumberDL_RS_QCL_TypeD = -1;  /* T_maxNumberDL_RS_QCL_TypeD */
static int hf_nr_rrc_supportedSRS_TxPortSwitch_01 = -1;  /* T_supportedSRS_TxPortSwitch_01 */
static int hf_nr_rrc_txSwitchImpactToRx_01 = -1;  /* T_txSwitchImpactToRx */
static int hf_nr_rrc_singleUL_Transmission = -1;  /* T_singleUL_Transmission */
static int hf_nr_rrc_dynamicPowerSharingENDC = -1;  /* T_dynamicPowerSharingENDC */
static int hf_nr_rrc_tdm_Pattern = -1;            /* T_tdm_Pattern */
static int hf_nr_rrc_ul_SharingEUTRA_NR = -1;     /* T_ul_SharingEUTRA_NR */
static int hf_nr_rrc_ul_SwitchingTimeEUTRA_NR = -1;  /* T_ul_SwitchingTimeEUTRA_NR */
static int hf_nr_rrc_simultaneousRxTxInterBandENDC = -1;  /* T_simultaneousRxTxInterBandENDC */
static int hf_nr_rrc_asyncIntraBandENDC = -1;     /* T_asyncIntraBandENDC */
static int hf_nr_rrc_dualPA_Architecture_01 = -1;  /* T_dualPA_Architecture_01 */
static int hf_nr_rrc_intraBandENDC_Support = -1;  /* T_intraBandENDC_Support */
static int hf_nr_rrc_ul_TimingAlignmentEUTRA_NR = -1;  /* T_ul_TimingAlignmentEUTRA_NR */
static int hf_nr_rrc_dynamicPowerSharingNEDC = -1;  /* T_dynamicPowerSharingNEDC */
static int hf_nr_rrc_interBandContiguousMRDC = -1;  /* T_interBandContiguousMRDC */
static int hf_nr_rrc_simultaneousRxTxInterBandENDCPerBandPair = -1;  /* SimultaneousRxTxPerBandPair */
static int hf_nr_rrc_maxUplinkDutyCycle_interBandENDC_TDD_PC2_r16 = -1;  /* T_maxUplinkDutyCycle_interBandENDC_TDD_PC2_r16 */
static int hf_nr_rrc_eutra_TDD_Config0_r16 = -1;  /* T_eutra_TDD_Config0_r16 */
static int hf_nr_rrc_eutra_TDD_Config1_r16 = -1;  /* T_eutra_TDD_Config1_r16 */
static int hf_nr_rrc_eutra_TDD_Config2_r16 = -1;  /* T_eutra_TDD_Config2_r16 */
static int hf_nr_rrc_eutra_TDD_Config3_r16 = -1;  /* T_eutra_TDD_Config3_r16 */
static int hf_nr_rrc_eutra_TDD_Config4_r16 = -1;  /* T_eutra_TDD_Config4_r16 */
static int hf_nr_rrc_eutra_TDD_Config5_r16 = -1;  /* T_eutra_TDD_Config5_r16 */
static int hf_nr_rrc_eutra_TDD_Config6_r16 = -1;  /* T_eutra_TDD_Config6_r16 */
static int hf_nr_rrc_tdm_restrictionTDD_endc_r16 = -1;  /* T_tdm_restrictionTDD_endc_r16 */
static int hf_nr_rrc_tdm_restrictionFDD_endc_r16 = -1;  /* T_tdm_restrictionFDD_endc_r16 */
static int hf_nr_rrc_singleUL_HARQ_offsetTDD_PCell_r16 = -1;  /* T_singleUL_HARQ_offsetTDD_PCell_r16 */
static int hf_nr_rrc_tdm_restrictionDualTX_FDD_endc_r16 = -1;  /* T_tdm_restrictionDualTX_FDD_endc_r16 */
static int hf_nr_rrc_maxUplinkDutyCycle_interBandENDC_FDD_TDD_PC2_r16 = -1;  /* T_maxUplinkDutyCycle_interBandENDC_FDD_TDD_PC2_r16 */
static int hf_nr_rrc_maxUplinkDutyCycle_FDD_TDD_EN_DC1_r16 = -1;  /* T_maxUplinkDutyCycle_FDD_TDD_EN_DC1_r16 */
static int hf_nr_rrc_maxUplinkDutyCycle_FDD_TDD_EN_DC2_r16 = -1;  /* T_maxUplinkDutyCycle_FDD_TDD_EN_DC2_r16 */
static int hf_nr_rrc_interBandMRDC_WithOverlapDL_Bands_r16 = -1;  /* T_interBandMRDC_WithOverlapDL_Bands_r16 */
static int hf_nr_rrc_measAndMobParametersNRDC = -1;  /* MeasAndMobParametersMRDC */
static int hf_nr_rrc_generalParametersNRDC = -1;  /* GeneralParametersMRDC_XDD_Diff */
static int hf_nr_rrc_fdd_Add_UE_NRDC_Capabilities = -1;  /* UE_MRDC_CapabilityAddXDD_Mode */
static int hf_nr_rrc_tdd_Add_UE_NRDC_Capabilities = -1;  /* UE_MRDC_CapabilityAddXDD_Mode */
static int hf_nr_rrc_fr1_Add_UE_NRDC_Capabilities = -1;  /* UE_MRDC_CapabilityAddFRX_Mode */
static int hf_nr_rrc_fr2_Add_UE_NRDC_Capabilities = -1;  /* UE_MRDC_CapabilityAddFRX_Mode */
static int hf_nr_rrc_nRDC_Parameters_dummy2 = -1;  /* OCTET_STRING */
static int hf_nr_rrc_nRDC_Parameters_dummy = -1;  /* T_nRDC_Parameters_dummy */
static int hf_nr_rrc_sfn_SyncNRDC = -1;           /* T_sfn_SyncNRDC */
static int hf_nr_rrc_pdcp_DuplicationSplitSRB = -1;  /* T_pdcp_DuplicationSplitSRB */
static int hf_nr_rrc_pdcp_DuplicationSplitDRB = -1;  /* T_pdcp_DuplicationSplitDRB */
static int hf_nr_rrc_measAndMobParametersNRDC_v1610 = -1;  /* MeasAndMobParametersMRDC_v1610 */
static int hf_nr_rrc_olpc_SRS_PosBasedOnPRS_Serving_r16 = -1;  /* T_olpc_SRS_PosBasedOnPRS_Serving_r16 */
static int hf_nr_rrc_olpc_SRS_PosBasedOnSSB_Neigh_r16 = -1;  /* T_olpc_SRS_PosBasedOnSSB_Neigh_r16 */
static int hf_nr_rrc_olpc_SRS_PosBasedOnPRS_Neigh_r16 = -1;  /* T_olpc_SRS_PosBasedOnPRS_Neigh_r16 */
static int hf_nr_rrc_maxNumberPathLossEstimatePerServing_r16 = -1;  /* T_maxNumberPathLossEstimatePerServing_r16 */
static int hf_nr_rrc_supportedROHC_Profiles = -1;  /* T_supportedROHC_Profiles */
static int hf_nr_rrc_profile0x0000 = -1;          /* BOOLEAN */
static int hf_nr_rrc_maxNumberROHC_ContextSessions = -1;  /* T_maxNumberROHC_ContextSessions */
static int hf_nr_rrc_uplinkOnlyROHC_Profiles = -1;  /* T_uplinkOnlyROHC_Profiles */
static int hf_nr_rrc_continueROHC_Context = -1;   /* T_continueROHC_Context */
static int hf_nr_rrc_outOfOrderDelivery_01 = -1;  /* T_outOfOrderDelivery_01 */
static int hf_nr_rrc_shortSN = -1;                /* T_shortSN */
static int hf_nr_rrc_pdcp_DuplicationSRB = -1;    /* T_pdcp_DuplicationSRB */
static int hf_nr_rrc_pdcp_DuplicationMCG_OrSCG_DRB = -1;  /* T_pdcp_DuplicationMCG_OrSCG_DRB */
static int hf_nr_rrc_drb_IAB_r16 = -1;            /* T_drb_IAB_r16 */
static int hf_nr_rrc_non_DRB_IAB_r16 = -1;        /* T_non_DRB_IAB_r16 */
static int hf_nr_rrc_extendedDiscardTimer_r16 = -1;  /* T_extendedDiscardTimer_r16 */
static int hf_nr_rrc_continueEHC_Context_r16 = -1;  /* T_continueEHC_Context_r16 */
static int hf_nr_rrc_ehc_r16 = -1;                /* T_ehc_r16 */
static int hf_nr_rrc_maxNumberEHC_Contexts_r16 = -1;  /* T_maxNumberEHC_Contexts_r16 */
static int hf_nr_rrc_jointEHC_ROHC_Config_r16 = -1;  /* T_jointEHC_ROHC_Config_r16 */
static int hf_nr_rrc_pdcp_DuplicationMoreThanTwoRLC_r16 = -1;  /* T_pdcp_DuplicationMoreThanTwoRLC_r16 */
static int hf_nr_rrc_pdcp_DuplicationSplitSRB_01 = -1;  /* T_pdcp_DuplicationSplitSRB_01 */
static int hf_nr_rrc_pdcp_DuplicationSplitDRB_01 = -1;  /* T_pdcp_DuplicationSplitDRB_01 */
static int hf_nr_rrc_scg_DRB_NR_IAB_r16 = -1;     /* T_scg_DRB_NR_IAB_r16 */
static int hf_nr_rrc_phy_ParametersCommon = -1;   /* Phy_ParametersCommon */
static int hf_nr_rrc_phy_ParametersXDD_Diff = -1;  /* Phy_ParametersXDD_Diff */
static int hf_nr_rrc_phy_ParametersFRX_Diff = -1;  /* Phy_ParametersFRX_Diff */
static int hf_nr_rrc_phy_ParametersFR1 = -1;      /* Phy_ParametersFR1 */
static int hf_nr_rrc_phy_ParametersFR2 = -1;      /* Phy_ParametersFR2 */
static int hf_nr_rrc_csi_RS_CFRA_ForHO = -1;      /* T_csi_RS_CFRA_ForHO */
static int hf_nr_rrc_dynamicPRB_BundlingDL = -1;  /* T_dynamicPRB_BundlingDL */
static int hf_nr_rrc_sp_CSI_ReportPUCCH = -1;     /* T_sp_CSI_ReportPUCCH */
static int hf_nr_rrc_sp_CSI_ReportPUSCH = -1;     /* T_sp_CSI_ReportPUSCH */
static int hf_nr_rrc_nzp_CSI_RS_IntefMgmt = -1;   /* T_nzp_CSI_RS_IntefMgmt */
static int hf_nr_rrc_type2_SP_CSI_Feedback_LongPUCCH = -1;  /* T_type2_SP_CSI_Feedback_LongPUCCH */
static int hf_nr_rrc_precoderGranularityCORESET = -1;  /* T_precoderGranularityCORESET */
static int hf_nr_rrc_dynamicHARQ_ACK_Codebook = -1;  /* T_dynamicHARQ_ACK_Codebook */
static int hf_nr_rrc_semiStaticHARQ_ACK_Codebook = -1;  /* T_semiStaticHARQ_ACK_Codebook */
static int hf_nr_rrc_spatialBundlingHARQ_ACK = -1;  /* T_spatialBundlingHARQ_ACK */
static int hf_nr_rrc_dynamicBetaOffsetInd_HARQ_ACK_CSI = -1;  /* T_dynamicBetaOffsetInd_HARQ_ACK_CSI */
static int hf_nr_rrc_pucch_Repetition_F1_3_4 = -1;  /* T_pucch_Repetition_F1_3_4 */
static int hf_nr_rrc_ra_Type0_PUSCH = -1;         /* T_ra_Type0_PUSCH */
static int hf_nr_rrc_dynamicSwitchRA_Type0_1_PDSCH = -1;  /* T_dynamicSwitchRA_Type0_1_PDSCH */
static int hf_nr_rrc_dynamicSwitchRA_Type0_1_PUSCH = -1;  /* T_dynamicSwitchRA_Type0_1_PUSCH */
static int hf_nr_rrc_pdsch_MappingTypeA = -1;     /* T_pdsch_MappingTypeA */
static int hf_nr_rrc_pdsch_MappingTypeB = -1;     /* T_pdsch_MappingTypeB */
static int hf_nr_rrc_interleavingVRB_ToPRB_PDSCH = -1;  /* T_interleavingVRB_ToPRB_PDSCH */
static int hf_nr_rrc_interSlotFreqHopping_PUSCH = -1;  /* T_interSlotFreqHopping_PUSCH */
static int hf_nr_rrc_type1_PUSCH_RepetitionMultiSlots = -1;  /* T_type1_PUSCH_RepetitionMultiSlots */
static int hf_nr_rrc_type2_PUSCH_RepetitionMultiSlots = -1;  /* T_type2_PUSCH_RepetitionMultiSlots */
static int hf_nr_rrc_pusch_RepetitionMultiSlots = -1;  /* T_pusch_RepetitionMultiSlots */
static int hf_nr_rrc_pdsch_RepetitionMultiSlots = -1;  /* T_pdsch_RepetitionMultiSlots */
static int hf_nr_rrc_downlinkSPS = -1;            /* T_downlinkSPS */
static int hf_nr_rrc_configuredUL_GrantType1 = -1;  /* T_configuredUL_GrantType1 */
static int hf_nr_rrc_configuredUL_GrantType2 = -1;  /* T_configuredUL_GrantType2 */
static int hf_nr_rrc_pre_EmptIndication_DL = -1;  /* T_pre_EmptIndication_DL */
static int hf_nr_rrc_cbg_TransIndication_DL = -1;  /* T_cbg_TransIndication_DL */
static int hf_nr_rrc_cbg_TransIndication_UL = -1;  /* T_cbg_TransIndication_UL */
static int hf_nr_rrc_cbg_FlushIndication_DL = -1;  /* T_cbg_FlushIndication_DL */
static int hf_nr_rrc_dynamicHARQ_ACK_CodeB_CBG_Retx_DL = -1;  /* T_dynamicHARQ_ACK_CodeB_CBG_Retx_DL */
static int hf_nr_rrc_rateMatchingResrcSetSemi_Static = -1;  /* T_rateMatchingResrcSetSemi_Static */
static int hf_nr_rrc_rateMatchingResrcSetDynamic = -1;  /* T_rateMatchingResrcSetDynamic */
static int hf_nr_rrc_bwp_SwitchingDelay = -1;     /* T_bwp_SwitchingDelay */
static int hf_nr_rrc_phy_ParametersCommon_eag_1_dummy = -1;  /* T_phy_ParametersCommon_eag_1_dummy */
static int hf_nr_rrc_maxNumberSearchSpaces = -1;  /* T_maxNumberSearchSpaces */
static int hf_nr_rrc_rateMatchingCtrlResrcSetDynamic = -1;  /* T_rateMatchingCtrlResrcSetDynamic */
static int hf_nr_rrc_maxLayersMIMO_Indication = -1;  /* T_maxLayersMIMO_Indication */
static int hf_nr_rrc_spCellPlacement = -1;        /* CarrierAggregationVariant */
static int hf_nr_rrc_twoStepRACH_r16 = -1;        /* T_twoStepRACH_r16 */
static int hf_nr_rrc_dci_Format1_2And0_2_r16 = -1;  /* T_dci_Format1_2And0_2_r16 */
static int hf_nr_rrc_monitoringDCI_SameSearchSpace_r16 = -1;  /* T_monitoringDCI_SameSearchSpace_r16 */
static int hf_nr_rrc_type2_CG_ReleaseDCI_0_1_r16 = -1;  /* T_type2_CG_ReleaseDCI_0_1_r16 */
static int hf_nr_rrc_type2_CG_ReleaseDCI_0_2_r16 = -1;  /* T_type2_CG_ReleaseDCI_0_2_r16 */
static int hf_nr_rrc_sps_ReleaseDCI_1_1_r16 = -1;  /* T_sps_ReleaseDCI_1_1_r16 */
static int hf_nr_rrc_sps_ReleaseDCI_1_2_r16 = -1;  /* T_sps_ReleaseDCI_1_2_r16 */
static int hf_nr_rrc_csi_TriggerStateNon_ActiveBWP_r16 = -1;  /* T_csi_TriggerStateNon_ActiveBWP_r16 */
static int hf_nr_rrc_seperateSMTC_InterIAB_Support_r16 = -1;  /* T_seperateSMTC_InterIAB_Support_r16 */
static int hf_nr_rrc_seperateRACH_IAB_Support_r16 = -1;  /* T_seperateRACH_IAB_Support_r16 */
static int hf_nr_rrc_ul_flexibleDL_SlotFormatSemiStatic_IAB_r16 = -1;  /* T_ul_flexibleDL_SlotFormatSemiStatic_IAB_r16 */
static int hf_nr_rrc_ul_flexibleDL_SlotFormatDynamics_IAB_r16 = -1;  /* T_ul_flexibleDL_SlotFormatDynamics_IAB_r16 */
static int hf_nr_rrc_dft_S_OFDM_WaveformUL_IAB_r16 = -1;  /* T_dft_S_OFDM_WaveformUL_IAB_r16 */
static int hf_nr_rrc_dci_25_AI_RNTI_Support_IAB_r16 = -1;  /* T_dci_25_AI_RNTI_Support_IAB_r16 */
static int hf_nr_rrc_t_DeltaReceptionSupport_IAB_r16 = -1;  /* T_t_DeltaReceptionSupport_IAB_r16 */
static int hf_nr_rrc_guardSymbolReportReception_IAB_r16 = -1;  /* T_guardSymbolReportReception_IAB_r16 */
static int hf_nr_rrc_harqACK_CB_SpatialBundlingPUCCH_Group_r16 = -1;  /* T_harqACK_CB_SpatialBundlingPUCCH_Group_r16 */
static int hf_nr_rrc_crossSlotScheduling_r16 = -1;  /* T_crossSlotScheduling_r16 */
static int hf_nr_rrc_non_SharedSpectrumChAccess_r16_01 = -1;  /* T_non_SharedSpectrumChAccess_r16 */
static int hf_nr_rrc_sharedSpectrumChAccess_r16_01 = -1;  /* T_sharedSpectrumChAccess_r16 */
static int hf_nr_rrc_maxNumberSRS_PosPathLossEstimateAllServingCells_r16 = -1;  /* T_maxNumberSRS_PosPathLossEstimateAllServingCells_r16 */
static int hf_nr_rrc_extendedCG_Periodicities_r16 = -1;  /* T_extendedCG_Periodicities_r16 */
static int hf_nr_rrc_extendedSPS_Periodicities_r16 = -1;  /* T_extendedSPS_Periodicities_r16 */
static int hf_nr_rrc_codebookVariantsList_r16 = -1;  /* CodebookVariantsList_r16 */
static int hf_nr_rrc_pusch_RepetitionTypeA_r16 = -1;  /* T_pusch_RepetitionTypeA_r16 */
static int hf_nr_rrc_sharedSpectrumChAccess_r16_02 = -1;  /* T_sharedSpectrumChAccess_r16_01 */
static int hf_nr_rrc_non_SharedSpectrumChAccess_r16_02 = -1;  /* T_non_SharedSpectrumChAccess_r16_01 */
static int hf_nr_rrc_dci_DL_PriorityIndicator_r16 = -1;  /* T_dci_DL_PriorityIndicator_r16 */
static int hf_nr_rrc_dci_UL_PriorityIndicator_r16 = -1;  /* T_dci_UL_PriorityIndicator_r16 */
static int hf_nr_rrc_maxNumberPathlossRS_Update_r16 = -1;  /* T_maxNumberPathlossRS_Update_r16 */
static int hf_nr_rrc_type2_HARQ_ACK_Codebook_r16 = -1;  /* T_type2_HARQ_ACK_Codebook_r16 */
static int hf_nr_rrc_maxTotalResourcesForAcrossFreqRanges_r16 = -1;  /* T_maxTotalResourcesForAcrossFreqRanges_r16 */
static int hf_nr_rrc_maxNumberResWithinSlotAcrossCC_AcrossFR_r16 = -1;  /* T_maxNumberResWithinSlotAcrossCC_AcrossFR_r16 */
static int hf_nr_rrc_maxNumberResAcrossCC_AcrossFR_r16 = -1;  /* T_maxNumberResAcrossCC_AcrossFR_r16 */
static int hf_nr_rrc_harqACK_separateMultiDCI_MultiTRP_r16 = -1;  /* T_harqACK_separateMultiDCI_MultiTRP_r16 */
static int hf_nr_rrc_maxNumberLongPUCCHs_r16 = -1;  /* T_maxNumberLongPUCCHs_r16 */
static int hf_nr_rrc_harqACK_jointMultiDCI_MultiTRP_r16 = -1;  /* T_harqACK_jointMultiDCI_MultiTRP_r16 */
static int hf_nr_rrc_bwp_SwitchingMultiCCs_r16 = -1;  /* T_bwp_SwitchingMultiCCs_r16 */
static int hf_nr_rrc_type1_r16 = -1;              /* T_type1_r16 */
static int hf_nr_rrc_type2_r16_01 = -1;           /* T_type2_r16_01 */
static int hf_nr_rrc_targetSMTC_SCG_r16 = -1;     /* T_targetSMTC_SCG_r16 */
static int hf_nr_rrc_supportRepetitionZeroOffsetRV_r16 = -1;  /* T_supportRepetitionZeroOffsetRV_r16 */
static int hf_nr_rrc_cbg_TransInOrderPUSCH_UL_r16 = -1;  /* T_cbg_TransInOrderPUSCH_UL_r16 */
static int hf_nr_rrc_bwp_SwitchingMultiDormancyCCs_r16 = -1;  /* T_bwp_SwitchingMultiDormancyCCs_r16 */
static int hf_nr_rrc_type1_r16_01 = -1;           /* T_type1_r16_01 */
static int hf_nr_rrc_type2_r16_02 = -1;           /* T_type2_r16_02 */
static int hf_nr_rrc_supportRetx_Diff_CoresetPool_Multi_DCI_TRP_r16 = -1;  /* T_supportRetx_Diff_CoresetPool_Multi_DCI_TRP_r16 */
static int hf_nr_rrc_pdcch_MonitoringAnyOccasionsWithSpanGapCrossCarrierSch_r16 = -1;  /* T_pdcch_MonitoringAnyOccasionsWithSpanGapCrossCarrierSch_r16 */
static int hf_nr_rrc_newBeamIdentifications2PortCSI_RS_r16 = -1;  /* T_newBeamIdentifications2PortCSI_RS_r16 */
static int hf_nr_rrc_pathlossEstimation2PortCSI_RS_r16 = -1;  /* T_pathlossEstimation2PortCSI_RS_r16 */
static int hf_nr_rrc_dynamicSFI = -1;             /* T_dynamicSFI */
static int hf_nr_rrc_twoPUCCH_F0_2_ConsecSymbols = -1;  /* T_twoPUCCH_F0_2_ConsecSymbols */
static int hf_nr_rrc_twoDifferentTPC_Loop_PUSCH = -1;  /* T_twoDifferentTPC_Loop_PUSCH */
static int hf_nr_rrc_twoDifferentTPC_Loop_PUCCH = -1;  /* T_twoDifferentTPC_Loop_PUCCH */
static int hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeA = -1;  /* T_dl_SchedulingOffset_PDSCH_TypeA */
static int hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeB = -1;  /* T_dl_SchedulingOffset_PDSCH_TypeB */
static int hf_nr_rrc_ul_SchedulingOffset = -1;    /* T_ul_SchedulingOffset */
static int hf_nr_rrc_dynamicSFI_01 = -1;          /* T_dynamicSFI_01 */
static int hf_nr_rrc_phy_ParametersFRX_Diff_dummy1 = -1;  /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_twoFL_DMRS = -1;             /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_phy_ParametersFRX_Diff_dummy2 = -1;  /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_phy_ParametersFRX_Diff_dummy3 = -1;  /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_supportedDMRS_TypeDL = -1;   /* T_supportedDMRS_TypeDL */
static int hf_nr_rrc_supportedDMRS_TypeUL = -1;   /* T_supportedDMRS_TypeUL */
static int hf_nr_rrc_semiOpenLoopCSI = -1;        /* T_semiOpenLoopCSI */
static int hf_nr_rrc_csi_ReportWithoutPMI = -1;   /* T_csi_ReportWithoutPMI */
static int hf_nr_rrc_csi_ReportWithoutCQI = -1;   /* T_csi_ReportWithoutCQI */
static int hf_nr_rrc_onePortsPTRS = -1;           /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_twoPUCCH_F0_2_ConsecSymbols_01 = -1;  /* T_twoPUCCH_F0_2_ConsecSymbols_01 */
static int hf_nr_rrc_pucch_F2_WithFH = -1;        /* T_pucch_F2_WithFH */
static int hf_nr_rrc_pucch_F3_WithFH = -1;        /* T_pucch_F3_WithFH */
static int hf_nr_rrc_pucch_F4_WithFH = -1;        /* T_pucch_F4_WithFH */
static int hf_nr_rrc_pucch_F0_2WithoutFH = -1;    /* T_pucch_F0_2WithoutFH */
static int hf_nr_rrc_pucch_F1_3_4WithoutFH = -1;  /* T_pucch_F1_3_4WithoutFH */
static int hf_nr_rrc_mux_SR_HARQ_ACK_CSI_PUCCH_MultiPerSlot = -1;  /* T_mux_SR_HARQ_ACK_CSI_PUCCH_MultiPerSlot */
static int hf_nr_rrc_uci_CodeBlockSegmentation = -1;  /* T_uci_CodeBlockSegmentation */
static int hf_nr_rrc_onePUCCH_LongAndShortFormat = -1;  /* T_onePUCCH_LongAndShortFormat */
static int hf_nr_rrc_twoPUCCH_AnyOthersInSlot = -1;  /* T_twoPUCCH_AnyOthersInSlot */
static int hf_nr_rrc_intraSlotFreqHopping_PUSCH = -1;  /* T_intraSlotFreqHopping_PUSCH */
static int hf_nr_rrc_pusch_LBRM = -1;             /* T_pusch_LBRM */
static int hf_nr_rrc_pdcch_BlindDetectionCA = -1;  /* INTEGER_4_16 */
static int hf_nr_rrc_tpc_PUSCH_RNTI_01 = -1;      /* T_tpc_PUSCH_RNTI */
static int hf_nr_rrc_tpc_PUCCH_RNTI_01 = -1;      /* T_tpc_PUCCH_RNTI */
static int hf_nr_rrc_tpc_SRS_RNTI_01 = -1;        /* T_tpc_SRS_RNTI */
static int hf_nr_rrc_absoluteTPC_Command = -1;    /* T_absoluteTPC_Command */
static int hf_nr_rrc_twoDifferentTPC_Loop_PUSCH_01 = -1;  /* T_twoDifferentTPC_Loop_PUSCH_01 */
static int hf_nr_rrc_twoDifferentTPC_Loop_PUCCH_01 = -1;  /* T_twoDifferentTPC_Loop_PUCCH_01 */
static int hf_nr_rrc_pusch_HalfPi_BPSK = -1;      /* T_pusch_HalfPi_BPSK */
static int hf_nr_rrc_pucch_F3_4_HalfPi_BPSK = -1;  /* T_pucch_F3_4_HalfPi_BPSK */
static int hf_nr_rrc_almostContiguousCP_OFDM_UL = -1;  /* T_almostContiguousCP_OFDM_UL */
static int hf_nr_rrc_sp_CSI_RS = -1;              /* T_sp_CSI_RS */
static int hf_nr_rrc_sp_CSI_IM = -1;              /* T_sp_CSI_IM */
static int hf_nr_rrc_tdd_MultiDL_UL_SwitchPerSlot = -1;  /* T_tdd_MultiDL_UL_SwitchPerSlot */
static int hf_nr_rrc_multipleCORESET = -1;        /* T_multipleCORESET */
static int hf_nr_rrc_mux_SR_HARQ_ACK_CSI_PUCCH_OncePerSlot = -1;  /* T_mux_SR_HARQ_ACK_CSI_PUCCH_OncePerSlot */
static int hf_nr_rrc_sameSymbol = -1;             /* T_sameSymbol */
static int hf_nr_rrc_diffSymbol = -1;             /* T_diffSymbol */
static int hf_nr_rrc_mux_SR_HARQ_ACK_PUCCH = -1;  /* T_mux_SR_HARQ_ACK_PUCCH */
static int hf_nr_rrc_mux_MultipleGroupCtrlCH_Overlap = -1;  /* T_mux_MultipleGroupCtrlCH_Overlap */
static int hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeA_01 = -1;  /* T_dl_SchedulingOffset_PDSCH_TypeA_01 */
static int hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeB_01 = -1;  /* T_dl_SchedulingOffset_PDSCH_TypeB_01 */
static int hf_nr_rrc_ul_SchedulingOffset_01 = -1;  /* T_ul_SchedulingOffset_01 */
static int hf_nr_rrc_dl_64QAM_MCS_TableAlt = -1;  /* T_dl_64QAM_MCS_TableAlt */
static int hf_nr_rrc_ul_64QAM_MCS_TableAlt = -1;  /* T_ul_64QAM_MCS_TableAlt */
static int hf_nr_rrc_cqi_TableAlt = -1;           /* T_cqi_TableAlt */
static int hf_nr_rrc_oneFL_DMRS_TwoAdditionalDMRS_UL = -1;  /* T_oneFL_DMRS_TwoAdditionalDMRS_UL */
static int hf_nr_rrc_twoFL_DMRS_TwoAdditionalDMRS_UL = -1;  /* T_twoFL_DMRS_TwoAdditionalDMRS_UL */
static int hf_nr_rrc_oneFL_DMRS_ThreeAdditionalDMRS_UL = -1;  /* T_oneFL_DMRS_ThreeAdditionalDMRS_UL */
static int hf_nr_rrc_pdcch_BlindDetectionNRDC = -1;  /* T_pdcch_BlindDetectionNRDC */
static int hf_nr_rrc_pdcch_BlindDetectionMCG_UE = -1;  /* INTEGER_1_15 */
static int hf_nr_rrc_pdcch_BlindDetectionSCG_UE = -1;  /* INTEGER_1_15 */
static int hf_nr_rrc_mux_HARQ_ACK_PUSCH_DiffSymbol = -1;  /* T_mux_HARQ_ACK_PUSCH_DiffSymbol */
static int hf_nr_rrc_type1_HARQ_ACK_Codebook_r16 = -1;  /* T_type1_HARQ_ACK_Codebook_r16 */
static int hf_nr_rrc_enhancedPowerControl_r16 = -1;  /* T_enhancedPowerControl_r16 */
static int hf_nr_rrc_simultaneousTCI_ActMultipleCC_r16 = -1;  /* T_simultaneousTCI_ActMultipleCC_r16 */
static int hf_nr_rrc_simultaneousSpatialRelationMultipleCC_r16 = -1;  /* T_simultaneousSpatialRelationMultipleCC_r16 */
static int hf_nr_rrc_cli_RSSI_FDM_DL_r16 = -1;    /* T_cli_RSSI_FDM_DL_r16 */
static int hf_nr_rrc_cli_SRS_RSRP_FDM_DL_r16 = -1;  /* T_cli_SRS_RSRP_FDM_DL_r16 */
static int hf_nr_rrc_maxLayersMIMO_Adaptation_r16 = -1;  /* T_maxLayersMIMO_Adaptation_r16 */
static int hf_nr_rrc_aggregationFactorSPS_DL_r16 = -1;  /* T_aggregationFactorSPS_DL_r16 */
static int hf_nr_rrc_maxTotalResourcesForOneFreqRange_r16 = -1;  /* T_maxTotalResourcesForOneFreqRange_r16 */
static int hf_nr_rrc_maxNumberResWithinSlotAcrossCC_OneFR_r16 = -1;  /* T_maxNumberResWithinSlotAcrossCC_OneFR_r16 */
static int hf_nr_rrc_maxNumberResAcrossCC_OneFR_r16 = -1;  /* T_maxNumberResAcrossCC_OneFR_r16 */
static int hf_nr_rrc_twoTCI_Act_servingCellInCC_List_r16 = -1;  /* T_twoTCI_Act_servingCellInCC_List_r16 */
static int hf_nr_rrc_cri_RI_CQI_WithoutNon_PMI_PortInd_r16 = -1;  /* T_cri_RI_CQI_WithoutNon_PMI_PortInd_r16 */
static int hf_nr_rrc_pdcch_MonitoringSingleOccasion = -1;  /* T_pdcch_MonitoringSingleOccasion */
static int hf_nr_rrc_phy_ParametersFR1_scs_60kHz = -1;  /* T_phy_ParametersFR1_scs_60kHz */
static int hf_nr_rrc_pdsch_256QAM_FR1 = -1;       /* T_pdsch_256QAM_FR1 */
static int hf_nr_rrc_pdsch_RE_MappingFR1_PerSymbol = -1;  /* T_pdsch_RE_MappingFR1_PerSymbol */
static int hf_nr_rrc_pdsch_RE_MappingFR1_PerSlot = -1;  /* T_pdsch_RE_MappingFR1_PerSlot */
static int hf_nr_rrc_phy_ParametersFR2_dummy = -1;  /* T_phy_ParametersFR2_dummy */
static int hf_nr_rrc_pdsch_RE_MappingFR2_PerSymbol = -1;  /* T_pdsch_RE_MappingFR2_PerSymbol */
static int hf_nr_rrc_pCell_FR2 = -1;              /* T_pCell_FR2 */
static int hf_nr_rrc_pdsch_RE_MappingFR2_PerSlot = -1;  /* T_pdsch_RE_MappingFR2_PerSlot */
static int hf_nr_rrc_defaultSpatialRelationPathlossRS_r16 = -1;  /* T_defaultSpatialRelationPathlossRS_r16 */
static int hf_nr_rrc_spatialRelationUpdateAP_SRS_r16 = -1;  /* T_spatialRelationUpdateAP_SRS_r16 */
static int hf_nr_rrc_maxNumberSRS_PosSpatialRelationsAllServingCells_r16 = -1;  /* T_maxNumberSRS_PosSpatialRelationsAllServingCells_r16 */
static int hf_nr_rrc_naics_Capability_List = -1;  /* SEQUENCE_SIZE_1_maxNrofNAICS_Entries_OF_NAICS_Capability_Entry */
static int hf_nr_rrc_naics_Capability_List_item = -1;  /* NAICS_Capability_Entry */
static int hf_nr_rrc_tdd_PCellUL_TX_AllUL_Subframe_r16 = -1;  /* T_tdd_PCellUL_TX_AllUL_Subframe_r16 */
static int hf_nr_rrc_fdd_PCellUL_TX_AllUL_Subframe_r16 = -1;  /* T_fdd_PCellUL_TX_AllUL_Subframe_r16 */
static int hf_nr_rrc_numberOfNAICS_CapableCC = -1;  /* INTEGER_1_5 */
static int hf_nr_rrc_numberOfAggregatedPRB = -1;  /* T_numberOfAggregatedPRB */
static int hf_nr_rrc_ss_SINR_Meas_r16 = -1;       /* T_ss_SINR_Meas_r16 */
static int hf_nr_rrc_sp_CSI_ReportPUCCH_r16 = -1;  /* T_sp_CSI_ReportPUCCH_r16 */
static int hf_nr_rrc_sp_CSI_ReportPUSCH_r16 = -1;  /* T_sp_CSI_ReportPUSCH_r16 */
static int hf_nr_rrc_dynamicSFI_r16 = -1;         /* T_dynamicSFI_r16 */
static int hf_nr_rrc_mux_SR_HARQ_ACK_CSI_PUCCH_OncePerSlot_r16 = -1;  /* T_mux_SR_HARQ_ACK_CSI_PUCCH_OncePerSlot_r16 */
static int hf_nr_rrc_sameSymbol_r16 = -1;         /* T_sameSymbol_r16 */
static int hf_nr_rrc_diffSymbol_r16 = -1;         /* T_diffSymbol_r16 */
static int hf_nr_rrc_mux_SR_HARQ_ACK_PUCCH_r16 = -1;  /* T_mux_SR_HARQ_ACK_PUCCH_r16 */
static int hf_nr_rrc_mux_SR_HARQ_ACK_CSI_PUCCH_MultiPerSlot_r16 = -1;  /* T_mux_SR_HARQ_ACK_CSI_PUCCH_MultiPerSlot_r16 */
static int hf_nr_rrc_mux_HARQ_ACK_PUSCH_DiffSymbol_r16 = -1;  /* T_mux_HARQ_ACK_PUSCH_DiffSymbol_r16 */
static int hf_nr_rrc_pucch_Repetition_F1_3_4_r16 = -1;  /* T_pucch_Repetition_F1_3_4_r16 */
static int hf_nr_rrc_type1_PUSCH_RepetitionMultiSlots_r16 = -1;  /* T_type1_PUSCH_RepetitionMultiSlots_r16 */
static int hf_nr_rrc_type2_PUSCH_RepetitionMultiSlots_r16 = -1;  /* T_type2_PUSCH_RepetitionMultiSlots_r16 */
static int hf_nr_rrc_pusch_RepetitionMultiSlots_r16 = -1;  /* T_pusch_RepetitionMultiSlots_r16 */
static int hf_nr_rrc_pdsch_RepetitionMultiSlots_r16 = -1;  /* T_pdsch_RepetitionMultiSlots_r16 */
static int hf_nr_rrc_downlinkSPS_r16 = -1;        /* T_downlinkSPS_r16 */
static int hf_nr_rrc_configuredUL_GrantType1_r16 = -1;  /* T_configuredUL_GrantType1_r16 */
static int hf_nr_rrc_configuredUL_GrantType2_r16 = -1;  /* T_configuredUL_GrantType2_r16 */
static int hf_nr_rrc_pre_EmptIndication_DL_r16 = -1;  /* T_pre_EmptIndication_DL_r16 */
static int hf_nr_rrc_powSav_ParametersCommon_r16 = -1;  /* PowSav_ParametersCommon_r16 */
static int hf_nr_rrc_powSav_ParametersFRX_Diff_r16 = -1;  /* PowSav_ParametersFRX_Diff_r16 */
static int hf_nr_rrc_drx_Preference_r16_01 = -1;  /* T_drx_Preference_r16 */
static int hf_nr_rrc_maxCC_Preference_r16_01 = -1;  /* T_maxCC_Preference_r16 */
static int hf_nr_rrc_releasePreference_r16_01 = -1;  /* T_releasePreference_r16 */
static int hf_nr_rrc_minSchedulingOffsetPreference_r16_01 = -1;  /* T_minSchedulingOffsetPreference_r16 */
static int hf_nr_rrc_maxBW_Preference_r16_01 = -1;  /* T_maxBW_Preference_r16 */
static int hf_nr_rrc_maxMIMO_LayerPreference_r16_01 = -1;  /* T_maxMIMO_LayerPreference_r16 */
static int hf_nr_rrc_fallback = -1;               /* T_fallback */
static int hf_nr_rrc_differentTB_PerSlot = -1;    /* T_differentTB_PerSlot */
static int hf_nr_rrc_upto1 = -1;                  /* NumberOfCarriers */
static int hf_nr_rrc_upto2 = -1;                  /* NumberOfCarriers */
static int hf_nr_rrc_upto4 = -1;                  /* NumberOfCarriers */
static int hf_nr_rrc_upto7 = -1;                  /* NumberOfCarriers */
static int hf_nr_rrc_supportedBandListNR = -1;    /* SEQUENCE_SIZE_1_maxBands_OF_BandNR */
static int hf_nr_rrc_supportedBandListNR_item = -1;  /* BandNR */
static int hf_nr_rrc_supportedBandCombinationList = -1;  /* BandCombinationList */
static int hf_nr_rrc_appliedFreqBandListFilter = -1;  /* FreqBandList */
static int hf_nr_rrc_supportedBandCombinationList_v1540 = -1;  /* BandCombinationList_v1540 */
static int hf_nr_rrc_srs_SwitchingTimeRequested = -1;  /* T_srs_SwitchingTimeRequested */
static int hf_nr_rrc_supportedBandCombinationList_v1550 = -1;  /* BandCombinationList_v1550 */
static int hf_nr_rrc_supportedBandCombinationList_v1560 = -1;  /* BandCombinationList_v1560 */
static int hf_nr_rrc_supportedBandCombinationList_v1610 = -1;  /* BandCombinationList_v1610 */
static int hf_nr_rrc_supportedBandCombinationListSidelinkEUTRA_NR_r16 = -1;  /* BandCombinationListSidelinkEUTRA_NR_r16 */
static int hf_nr_rrc_supportedBandCombinationList_UplinkTxSwitch_r16 = -1;  /* BandCombinationList_UplinkTxSwitch_r16 */
static int hf_nr_rrc_supportedBandCombinationList_v1630 = -1;  /* BandCombinationList_v1630 */
static int hf_nr_rrc_supportedBandCombinationListSidelinkEUTRA_NR_v1630 = -1;  /* BandCombinationListSidelinkEUTRA_NR_v1630 */
static int hf_nr_rrc_supportedBandCombinationList_UplinkTxSwitch_v1630 = -1;  /* BandCombinationList_UplinkTxSwitch_v1630 */
static int hf_nr_rrc_supportedBandCombinationList_v1640 = -1;  /* BandCombinationList_v1640 */
static int hf_nr_rrc_supportedBandCombinationList_UplinkTxSwitch_v1640 = -1;  /* BandCombinationList_UplinkTxSwitch_v1640 */
static int hf_nr_rrc_supportedBandCombinationList_v1650 = -1;  /* BandCombinationList_v1650 */
static int hf_nr_rrc_supportedBandCombinationList_UplinkTxSwitch_v1650 = -1;  /* BandCombinationList_UplinkTxSwitch_v1650 */
static int hf_nr_rrc_extendedBand_n77_r16 = -1;   /* T_extendedBand_n77_r16 */
static int hf_nr_rrc_supportedBandCombinationList_UplinkTxSwitch_v1670 = -1;  /* BandCombinationList_UplinkTxSwitch_v1670 */
static int hf_nr_rrc_supportedBandCombinationList_v1680 = -1;  /* BandCombinationList_v1680 */
static int hf_nr_rrc_supportedBandCombinationList_v15g0 = -1;  /* BandCombinationList_v15g0 */
static int hf_nr_rrc_modifiedMPR_Behaviour = -1;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_mimo_ParametersPerBand = -1;  /* MIMO_ParametersPerBand */
static int hf_nr_rrc_extendedCP = -1;             /* T_extendedCP */
static int hf_nr_rrc_multipleTCI = -1;            /* T_multipleTCI */
static int hf_nr_rrc_bwp_WithoutRestriction = -1;  /* T_bwp_WithoutRestriction */
static int hf_nr_rrc_bwp_SameNumerology = -1;     /* T_bwp_SameNumerology */
static int hf_nr_rrc_bwp_DiffNumerology = -1;     /* T_bwp_DiffNumerology */
static int hf_nr_rrc_crossCarrierScheduling_SameSCS = -1;  /* T_crossCarrierScheduling_SameSCS */
static int hf_nr_rrc_pdsch_256QAM_FR2 = -1;       /* T_pdsch_256QAM_FR2 */
static int hf_nr_rrc_pusch_256QAM = -1;           /* T_pusch_256QAM */
static int hf_nr_rrc_ue_PowerClass = -1;          /* T_ue_PowerClass */
static int hf_nr_rrc_rateMatchingLTE_CRS = -1;    /* T_rateMatchingLTE_CRS */
static int hf_nr_rrc_channelBWs_DL = -1;          /* T_channelBWs_DL */
static int hf_nr_rrc_fr1 = -1;                    /* T_fr1 */
static int hf_nr_rrc_bandNR_channelBWs_DL_fr1_scs_15kHz = -1;  /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_scs_30kHz_08 = -1;           /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_bandNR_channelBWs_DL_fr1_scs_60kHz = -1;  /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_fr2 = -1;                    /* T_fr2 */
static int hf_nr_rrc_bandNR_channelBWs_DL_fr2_scs_60kHz = -1;  /* BIT_STRING_SIZE_3 */
static int hf_nr_rrc_bandNR_channelBWs_DL_fr2_scs_120kHz = -1;  /* BIT_STRING_SIZE_3 */
static int hf_nr_rrc_channelBWs_UL = -1;          /* T_channelBWs_UL */
static int hf_nr_rrc_fr1_01 = -1;                 /* T_fr1_01 */
static int hf_nr_rrc_bandNR_channelBWs_UL_fr1_scs_15kHz = -1;  /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_bandNR_channelBWs_UL_fr1_scs_60kHz = -1;  /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_fr2_01 = -1;                 /* T_fr2_01 */
static int hf_nr_rrc_bandNR_channelBWs_UL_fr2_scs_60kHz = -1;  /* BIT_STRING_SIZE_3 */
static int hf_nr_rrc_bandNR_channelBWs_UL_fr2_scs_120kHz = -1;  /* BIT_STRING_SIZE_3 */
static int hf_nr_rrc_maxUplinkDutyCycle_PC2_FR1 = -1;  /* T_maxUplinkDutyCycle_PC2_FR1 */
static int hf_nr_rrc_pucch_SpatialRelInfoMAC_CE = -1;  /* T_pucch_SpatialRelInfoMAC_CE */
static int hf_nr_rrc_powerBoosting_pi2BPSK = -1;  /* T_powerBoosting_pi2BPSK */
static int hf_nr_rrc_maxUplinkDutyCycle_FR2 = -1;  /* T_maxUplinkDutyCycle_FR2 */
static int hf_nr_rrc_channelBWs_DL_v1590 = -1;    /* T_channelBWs_DL_v1590 */
static int hf_nr_rrc_fr1_02 = -1;                 /* T_fr1_02 */
static int hf_nr_rrc_bandNR_eag_4_channelBWs_DL_v1590_fr1_scs_15kHz = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_scs_30kHz_09 = -1;           /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_bandNR_eag_4_channelBWs_DL_v1590_fr1_scs_60kHz = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_fr2_02 = -1;                 /* T_fr2_02 */
static int hf_nr_rrc_bandNR_eag_4_channelBWs_DL_v1590_fr2_scs_60kHz = -1;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_bandNR_eag_4_channelBWs_DL_v1590_fr2_scs_120kHz = -1;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_channelBWs_UL_v1590 = -1;    /* T_channelBWs_UL_v1590 */
static int hf_nr_rrc_fr1_03 = -1;                 /* T_fr1_03 */
static int hf_nr_rrc_bandNR_eag_4_channelBWs_UL_v1590_fr1_scs_15kHz = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_bandNR_eag_4_channelBWs_UL_v1590_fr1_scs_60kHz = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_fr2_03 = -1;                 /* T_fr2_03 */
static int hf_nr_rrc_bandNR_eag_4_channelBWs_UL_v1590_fr2_scs_60kHz = -1;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_bandNR_eag_4_channelBWs_UL_v1590_fr2_scs_120kHz = -1;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_asymmetricBandwidthCombinationSet = -1;  /* BIT_STRING_SIZE_1_32 */
static int hf_nr_rrc_sharedSpectrumChAccessParamsPerBand_r16 = -1;  /* SharedSpectrumChAccessParamsPerBand_r16 */
static int hf_nr_rrc_cancelOverlappingPUSCH_r16 = -1;  /* T_cancelOverlappingPUSCH_r16 */
static int hf_nr_rrc_multipleRateMatchingEUTRA_CRS_r16 = -1;  /* T_multipleRateMatchingEUTRA_CRS_r16 */
static int hf_nr_rrc_maxNumberPatterns_r16 = -1;  /* INTEGER_2_6 */
static int hf_nr_rrc_maxNumberNon_OverlapPatterns_r16 = -1;  /* INTEGER_1_3 */
static int hf_nr_rrc_overlapRateMatchingEUTRA_CRS_r16 = -1;  /* T_overlapRateMatchingEUTRA_CRS_r16 */
static int hf_nr_rrc_pdsch_MappingTypeB_Alt_r16 = -1;  /* T_pdsch_MappingTypeB_Alt_r16 */
static int hf_nr_rrc_oneSlotPeriodicTRS_r16 = -1;  /* T_oneSlotPeriodicTRS_r16 */
static int hf_nr_rrc_olpc_SRS_Pos_r16 = -1;       /* OLPC_SRS_Pos_r16 */
static int hf_nr_rrc_spatialRelationsSRS_Pos_r16 = -1;  /* SpatialRelationsSRS_Pos_r16 */
static int hf_nr_rrc_simulSRS_MIMO_TransWithinBand_r16 = -1;  /* T_simulSRS_MIMO_TransWithinBand_r16 */
static int hf_nr_rrc_channelBW_DL_IAB_r16 = -1;   /* T_channelBW_DL_IAB_r16 */
static int hf_nr_rrc_fr1_100mhz = -1;             /* T_fr1_100mhz */
static int hf_nr_rrc_bandNR_eag_6_channelBW_DL_IAB_r16_fr1_100mhz_scs_15kHz = -1;  /* T_bandNR_eag_6_channelBW_DL_IAB_r16_fr1_100mhz_scs_15kHz */
static int hf_nr_rrc_scs_30kHz_10 = -1;           /* T_scs_30kHz_05 */
static int hf_nr_rrc_bandNR_eag_6_channelBW_DL_IAB_r16_fr1_100mhz_scs_60kHz = -1;  /* T_bandNR_eag_6_channelBW_DL_IAB_r16_fr1_100mhz_scs_60kHz */
static int hf_nr_rrc_fr2_200mhz = -1;             /* T_fr2_200mhz */
static int hf_nr_rrc_bandNR_eag_6_channelBW_DL_IAB_r16_fr2_200mhz_scs_60kHz = -1;  /* T_bandNR_eag_6_channelBW_DL_IAB_r16_fr2_200mhz_scs_60kHz */
static int hf_nr_rrc_bandNR_eag_6_channelBW_DL_IAB_r16_fr2_200mhz_scs_120kHz = -1;  /* T_bandNR_eag_6_channelBW_DL_IAB_r16_fr2_200mhz_scs_120kHz */
static int hf_nr_rrc_channelBW_UL_IAB_r16 = -1;   /* T_channelBW_UL_IAB_r16 */
static int hf_nr_rrc_fr1_100mhz_01 = -1;          /* T_fr1_100mhz_01 */
static int hf_nr_rrc_bandNR_eag_6_channelBW_UL_IAB_r16_fr1_100mhz_scs_15kHz = -1;  /* T_bandNR_eag_6_channelBW_UL_IAB_r16_fr1_100mhz_scs_15kHz */
static int hf_nr_rrc_scs_30kHz_11 = -1;           /* T_scs_30kHz_06 */
static int hf_nr_rrc_bandNR_eag_6_channelBW_UL_IAB_r16_fr1_100mhz_scs_60kHz = -1;  /* T_bandNR_eag_6_channelBW_UL_IAB_r16_fr1_100mhz_scs_60kHz */
static int hf_nr_rrc_fr2_200mhz_01 = -1;          /* T_fr2_200mhz_01 */
static int hf_nr_rrc_bandNR_eag_6_channelBW_UL_IAB_r16_fr2_200mhz_scs_60kHz = -1;  /* T_bandNR_eag_6_channelBW_UL_IAB_r16_fr2_200mhz_scs_60kHz */
static int hf_nr_rrc_bandNR_eag_6_channelBW_UL_IAB_r16_fr2_200mhz_scs_120kHz = -1;  /* T_bandNR_eag_6_channelBW_UL_IAB_r16_fr2_200mhz_scs_120kHz */
static int hf_nr_rrc_rasterShift7dot5_IAB_r16 = -1;  /* T_rasterShift7dot5_IAB_r16 */
static int hf_nr_rrc_ue_PowerClass_v1610 = -1;    /* T_ue_PowerClass_v1610 */
static int hf_nr_rrc_condHandover_r16 = -1;       /* T_condHandover_r16 */
static int hf_nr_rrc_condHandoverFailure_r16 = -1;  /* T_condHandoverFailure_r16 */
static int hf_nr_rrc_condHandoverTwoTriggerEvents_r16 = -1;  /* T_condHandoverTwoTriggerEvents_r16 */
static int hf_nr_rrc_condPSCellChange_r16 = -1;   /* T_condPSCellChange_r16 */
static int hf_nr_rrc_condPSCellChangeTwoTriggerEvents_r16 = -1;  /* T_condPSCellChangeTwoTriggerEvents_r16 */
static int hf_nr_rrc_mpr_PowerBoost_FR2_r16_01 = -1;  /* T_mpr_PowerBoost_FR2_r16_01 */
static int hf_nr_rrc_activeConfiguredGrant_r16 = -1;  /* T_activeConfiguredGrant_r16 */
static int hf_nr_rrc_maxNumberConfigsPerBWP_r16 = -1;  /* T_maxNumberConfigsPerBWP_r16 */
static int hf_nr_rrc_maxNumberConfigsAllCC_r16 = -1;  /* INTEGER_2_32 */
static int hf_nr_rrc_jointReleaseConfiguredGrantType2_r16 = -1;  /* T_jointReleaseConfiguredGrantType2_r16 */
static int hf_nr_rrc_sps_r16 = -1;                /* T_sps_r16 */
static int hf_nr_rrc_maxNumberConfigsPerBWP_r16_01 = -1;  /* INTEGER_1_8 */
static int hf_nr_rrc_jointReleaseSPS_r16 = -1;    /* T_jointReleaseSPS_r16 */
static int hf_nr_rrc_simulSRS_TransWithinBand_r16 = -1;  /* T_simulSRS_TransWithinBand_r16 */
static int hf_nr_rrc_trs_AdditionalBandwidth_r16 = -1;  /* T_trs_AdditionalBandwidth_r16 */
static int hf_nr_rrc_handoverIntraF_IAB_r16 = -1;  /* T_handoverIntraF_IAB_r16 */
static int hf_nr_rrc_simulTX_SRS_AntSwitchingIntraBandUL_CA_r16 = -1;  /* SimulSRS_ForAntennaSwitching_r16 */
static int hf_nr_rrc_sharedSpectrumChAccessParamsPerBand_v1630 = -1;  /* SharedSpectrumChAccessParamsPerBand_v1630 */
static int hf_nr_rrc_handoverUTRA_FDD_r16 = -1;   /* T_handoverUTRA_FDD_r16 */
static int hf_nr_rrc_enhancedUL_TransientPeriod_r16 = -1;  /* T_enhancedUL_TransientPeriod_r16 */
static int hf_nr_rrc_sharedSpectrumChAccessParamsPerBand_v1640 = -1;  /* SharedSpectrumChAccessParamsPerBand_v1640 */
static int hf_nr_rrc_type1_PUSCH_RepetitionMultiSlots_v1650 = -1;  /* T_type1_PUSCH_RepetitionMultiSlots_v1650 */
static int hf_nr_rrc_type2_PUSCH_RepetitionMultiSlots_v1650 = -1;  /* T_type2_PUSCH_RepetitionMultiSlots_v1650 */
static int hf_nr_rrc_pusch_RepetitionMultiSlots_v1650 = -1;  /* T_pusch_RepetitionMultiSlots_v1650 */
static int hf_nr_rrc_configuredUL_GrantType1_v1650 = -1;  /* T_configuredUL_GrantType1_v1650 */
static int hf_nr_rrc_configuredUL_GrantType2_v1650 = -1;  /* T_configuredUL_GrantType2_v1650 */
static int hf_nr_rrc_sharedSpectrumChAccessParamsPerBand_v1650 = -1;  /* SharedSpectrumChAccessParamsPerBand_v1650 */
static int hf_nr_rrc_enhancedSkipUplinkTxConfigured_v1660 = -1;  /* T_enhancedSkipUplinkTxConfigured_v1660 */
static int hf_nr_rrc_enhancedSkipUplinkTxDynamic_v1660 = -1;  /* T_enhancedSkipUplinkTxDynamic_v1660 */
static int hf_nr_rrc_maxUplinkDutyCycle_PC1dot5_MPE_FR1_r16 = -1;  /* T_maxUplinkDutyCycle_PC1dot5_MPE_FR1_r16 */
static int hf_nr_rrc_txDiversity_r16 = -1;        /* T_txDiversity_r16 */
static int hf_nr_rrc_srs_SwitchingTimeRequested_01 = -1;  /* T_srs_SwitchingTimeRequested_01 */
static int hf_nr_rrc_supportedBandCombinationListNEDC_Only = -1;  /* BandCombinationList */
static int hf_nr_rrc_supportedBandCombinationList_v1570 = -1;  /* BandCombinationList_v1570 */
static int hf_nr_rrc_supportedBandCombinationList_v1580 = -1;  /* BandCombinationList_v1580 */
static int hf_nr_rrc_supportedBandCombinationList_v1590 = -1;  /* BandCombinationList_v1590 */
static int hf_nr_rrc_supportedBandCombinationListNEDC_Only_v15a0 = -1;  /* T_supportedBandCombinationListNEDC_Only_v15a0 */
static int hf_nr_rrc_supportedBandCombinationListNEDC_Only_v1610 = -1;  /* BandCombinationList_v1610 */
static int hf_nr_rrc_supportedBandCombinationListNEDC_Only_v1630 = -1;  /* BandCombinationList_v1630 */
static int hf_nr_rrc_supportedBandCombinationListNEDC_Only_v1640 = -1;  /* BandCombinationList_v1640 */
static int hf_nr_rrc_supportedBandCombinationListNEDC_Only_v15g0 = -1;  /* BandCombinationList_v15g0 */
static int hf_nr_rrc_am_WithShortSN = -1;         /* T_am_WithShortSN */
static int hf_nr_rrc_um_WithShortSN = -1;         /* T_um_WithShortSN */
static int hf_nr_rrc_um_WithLongSN = -1;          /* T_um_WithLongSN */
static int hf_nr_rrc_extendedT_PollRetransmit_r16 = -1;  /* T_extendedT_PollRetransmit_r16 */
static int hf_nr_rrc_extendedT_StatusProhibit_r16 = -1;  /* T_extendedT_StatusProhibit_r16 */
static int hf_nr_rrc_as_ReflectiveQoS = -1;       /* T_as_ReflectiveQoS */
static int hf_nr_rrc_sdap_QOS_IAB_r16 = -1;       /* T_sdap_QOS_IAB_r16 */
static int hf_nr_rrc_sdapHeaderIAB_r16 = -1;      /* T_sdapHeaderIAB_r16 */
static int hf_nr_rrc_sidelinkParametersNR_r16 = -1;  /* SidelinkParametersNR_r16 */
static int hf_nr_rrc_sidelinkParametersEUTRA_r16 = -1;  /* SidelinkParametersEUTRA_r16 */
static int hf_nr_rrc_rlc_ParametersSidelink_r16 = -1;  /* RLC_ParametersSidelink_r16 */
static int hf_nr_rrc_mac_ParametersSidelink_r16 = -1;  /* MAC_ParametersSidelink_r16 */
static int hf_nr_rrc_fdd_Add_UE_Sidelink_Capabilities_r16 = -1;  /* UE_SidelinkCapabilityAddXDD_Mode_r16 */
static int hf_nr_rrc_tdd_Add_UE_Sidelink_Capabilities_r16 = -1;  /* UE_SidelinkCapabilityAddXDD_Mode_r16 */
static int hf_nr_rrc_supportedBandListSidelink_r16 = -1;  /* SEQUENCE_SIZE_1_maxBands_OF_BandSidelink_r16 */
static int hf_nr_rrc_supportedBandListSidelink_r16_item = -1;  /* BandSidelink_r16 */
static int hf_nr_rrc_sl_ParametersEUTRA1_r16 = -1;  /* T_sl_ParametersEUTRA1_r16 */
static int hf_nr_rrc_sl_ParametersEUTRA2_r16 = -1;  /* T_sl_ParametersEUTRA2_r16 */
static int hf_nr_rrc_sl_ParametersEUTRA3_r16 = -1;  /* T_sl_ParametersEUTRA3_r16 */
static int hf_nr_rrc_supportedBandListSidelinkEUTRA_r16 = -1;  /* SEQUENCE_SIZE_1_maxBandsEUTRA_OF_BandSidelinkEUTRA_r16 */
static int hf_nr_rrc_supportedBandListSidelinkEUTRA_r16_item = -1;  /* BandSidelinkEUTRA_r16 */
static int hf_nr_rrc_am_WithLongSN_Sidelink_r16 = -1;  /* T_am_WithLongSN_Sidelink_r16 */
static int hf_nr_rrc_um_WithLongSN_Sidelink_r16 = -1;  /* T_um_WithLongSN_Sidelink_r16 */
static int hf_nr_rrc_mac_ParametersSidelinkCommon_r16 = -1;  /* MAC_ParametersSidelinkCommon_r16 */
static int hf_nr_rrc_mac_ParametersSidelinkXDD_Diff_r16 = -1;  /* MAC_ParametersSidelinkXDD_Diff_r16 */
static int hf_nr_rrc_lcp_RestrictionSidelink_r16 = -1;  /* T_lcp_RestrictionSidelink_r16 */
static int hf_nr_rrc_multipleConfiguredGrantsSidelink_r16 = -1;  /* T_multipleConfiguredGrantsSidelink_r16 */
static int hf_nr_rrc_multipleSR_ConfigurationsSidelink_r16 = -1;  /* T_multipleSR_ConfigurationsSidelink_r16 */
static int hf_nr_rrc_logicalChannelSR_DelayTimerSidelink_r16 = -1;  /* T_logicalChannelSR_DelayTimerSidelink_r16 */
static int hf_nr_rrc_freqBandSidelinkEUTRA_r16 = -1;  /* FreqBandIndicatorEUTRA */
static int hf_nr_rrc_gnb_ScheduledMode3SidelinkEUTRA_r16 = -1;  /* T_gnb_ScheduledMode3SidelinkEUTRA_r16 */
static int hf_nr_rrc_gnb_ScheduledMode3DelaySidelinkEUTRA_r16 = -1;  /* T_gnb_ScheduledMode3DelaySidelinkEUTRA_r16 */
static int hf_nr_rrc_gnb_ScheduledMode4SidelinkEUTRA_r16 = -1;  /* T_gnb_ScheduledMode4SidelinkEUTRA_r16 */
static int hf_nr_rrc_sl_Reception_r16 = -1;       /* T_sl_Reception_r16 */
static int hf_nr_rrc_harq_RxProcessSidelink_r16 = -1;  /* T_harq_RxProcessSidelink_r16 */
static int hf_nr_rrc_pscch_RxSidelink_r16 = -1;   /* T_pscch_RxSidelink_r16 */
static int hf_nr_rrc_scs_CP_PatternRxSidelink_r16 = -1;  /* T_scs_CP_PatternRxSidelink_r16 */
static int hf_nr_rrc_fr1_r16 = -1;                /* T_fr1_r16 */
static int hf_nr_rrc_bandSidelink_r16_sl_Reception_r16_scs_CP_PatternRxSidelink_r16_fr1_r16_scs_15kHz_r16 = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_bandSidelink_r16_sl_Reception_r16_scs_CP_PatternRxSidelink_r16_fr1_r16_scs_30kHz_r16 = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_bandSidelink_r16_sl_Reception_r16_scs_CP_PatternRxSidelink_r16_fr1_r16_scs_60kHz_r16 = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_fr2_r16_01 = -1;             /* T_fr2_r16_01 */
static int hf_nr_rrc_bandSidelink_r16_sl_Reception_r16_scs_CP_PatternRxSidelink_r16_fr2_r16_scs_60kHz_r16 = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_bandSidelink_r16_sl_Reception_r16_scs_CP_PatternRxSidelink_r16_fr2_r16_scs_120kHz_r16 = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_extendedCP_RxSidelink_r16 = -1;  /* T_extendedCP_RxSidelink_r16 */
static int hf_nr_rrc_sl_TransmissionMode1_r16 = -1;  /* T_sl_TransmissionMode1_r16 */
static int hf_nr_rrc_harq_TxProcessModeOneSidelink_r16 = -1;  /* T_harq_TxProcessModeOneSidelink_r16 */
static int hf_nr_rrc_scs_CP_PatternTxSidelinkModeOne_r16 = -1;  /* T_scs_CP_PatternTxSidelinkModeOne_r16 */
static int hf_nr_rrc_fr1_r16_01 = -1;             /* T_fr1_r16_01 */
static int hf_nr_rrc_bandSidelink_r16_sl_TransmissionMode1_r16_scs_CP_PatternTxSidelinkModeOne_r16_fr1_r16_scs_15kHz_r16 = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_bandSidelink_r16_sl_TransmissionMode1_r16_scs_CP_PatternTxSidelinkModeOne_r16_fr1_r16_scs_30kHz_r16 = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_bandSidelink_r16_sl_TransmissionMode1_r16_scs_CP_PatternTxSidelinkModeOne_r16_fr1_r16_scs_60kHz_r16 = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_fr2_r16_02 = -1;             /* T_fr2_r16_02 */
static int hf_nr_rrc_bandSidelink_r16_sl_TransmissionMode1_r16_scs_CP_PatternTxSidelinkModeOne_r16_fr2_r16_scs_60kHz_r16 = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_bandSidelink_r16_sl_TransmissionMode1_r16_scs_CP_PatternTxSidelinkModeOne_r16_fr2_r16_scs_120kHz_r16 = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_extendedCP_TxSidelink_r16 = -1;  /* T_extendedCP_TxSidelink_r16 */
static int hf_nr_rrc_harq_ReportOnPUCCH_r16 = -1;  /* T_harq_ReportOnPUCCH_r16 */
static int hf_nr_rrc_sync_Sidelink_r16 = -1;      /* T_sync_Sidelink_r16 */
static int hf_nr_rrc_gNB_Sync_r16 = -1;           /* T_gNB_Sync_r16 */
static int hf_nr_rrc_gNB_GNSS_UE_SyncWithPriorityOnGNB_ENB_r16 = -1;  /* T_gNB_GNSS_UE_SyncWithPriorityOnGNB_ENB_r16 */
static int hf_nr_rrc_gNB_GNSS_UE_SyncWithPriorityOnGNSS_r16 = -1;  /* T_gNB_GNSS_UE_SyncWithPriorityOnGNSS_r16 */
static int hf_nr_rrc_sl_Tx_256QAM_r16 = -1;       /* T_sl_Tx_256QAM_r16 */
static int hf_nr_rrc_psfch_FormatZeroSidelink_r16 = -1;  /* T_psfch_FormatZeroSidelink_r16 */
static int hf_nr_rrc_psfch_RxNumber = -1;         /* T_psfch_RxNumber */
static int hf_nr_rrc_psfch_TxNumber = -1;         /* T_psfch_TxNumber */
static int hf_nr_rrc_lowSE_64QAM_MCS_TableSidelink_r16 = -1;  /* T_lowSE_64QAM_MCS_TableSidelink_r16 */
static int hf_nr_rrc_enb_sync_Sidelink_r16 = -1;  /* T_enb_sync_Sidelink_r16 */
static int hf_nr_rrc_sl_TransmissionMode2_r16 = -1;  /* T_sl_TransmissionMode2_r16 */
static int hf_nr_rrc_harq_TxProcessModeTwoSidelink_r16 = -1;  /* T_harq_TxProcessModeTwoSidelink_r16 */
static int hf_nr_rrc_scs_CP_PatternTxSidelinkModeTwo_r16 = -1;  /* T_scs_CP_PatternTxSidelinkModeTwo_r16 */
static int hf_nr_rrc_dl_openLoopPC_Sidelink_r16 = -1;  /* T_dl_openLoopPC_Sidelink_r16 */
static int hf_nr_rrc_congestionControlSidelink_r16 = -1;  /* T_congestionControlSidelink_r16 */
static int hf_nr_rrc_cbr_ReportSidelink_r16 = -1;  /* T_cbr_ReportSidelink_r16 */
static int hf_nr_rrc_cbr_CR_TimeLimitSidelink_r16 = -1;  /* T_cbr_CR_TimeLimitSidelink_r16 */
static int hf_nr_rrc_fewerSymbolSlotSidelink_r16 = -1;  /* T_fewerSymbolSlotSidelink_r16 */
static int hf_nr_rrc_sl_openLoopPC_RSRP_ReportSidelink_r16 = -1;  /* T_sl_openLoopPC_RSRP_ReportSidelink_r16 */
static int hf_nr_rrc_sl_Rx_256QAM_r16 = -1;       /* T_sl_Rx_256QAM_r16 */
static int hf_nr_rrc_ue_PowerClassSidelink_r16 = -1;  /* T_ue_PowerClassSidelink_r16 */
static int hf_nr_rrc_rach_Report_r16 = -1;        /* T_rach_Report_r16 */
static int hf_nr_rrc_spatialRelation_SRS_PosBasedOnSSB_Serving_r16 = -1;  /* T_spatialRelation_SRS_PosBasedOnSSB_Serving_r16 */
static int hf_nr_rrc_spatialRelation_SRS_PosBasedOnCSI_RS_Serving_r16 = -1;  /* T_spatialRelation_SRS_PosBasedOnCSI_RS_Serving_r16 */
static int hf_nr_rrc_spatialRelation_SRS_PosBasedOnPRS_Serving_r16 = -1;  /* T_spatialRelation_SRS_PosBasedOnPRS_Serving_r16 */
static int hf_nr_rrc_spatialRelation_SRS_PosBasedOnSRS_r16 = -1;  /* T_spatialRelation_SRS_PosBasedOnSRS_r16 */
static int hf_nr_rrc_spatialRelation_SRS_PosBasedOnSSB_Neigh_r16 = -1;  /* T_spatialRelation_SRS_PosBasedOnSSB_Neigh_r16 */
static int hf_nr_rrc_spatialRelation_SRS_PosBasedOnPRS_Neigh_r16 = -1;  /* T_spatialRelation_SRS_PosBasedOnPRS_Neigh_r16 */
static int hf_nr_rrc_switchingTimeDL = -1;        /* T_switchingTimeDL */
static int hf_nr_rrc_switchingTimeUL = -1;        /* T_switchingTimeUL */
static int hf_nr_rrc_switchingTimeDL_01 = -1;     /* T_switchingTimeDL_01 */
static int hf_nr_rrc_switchingTimeUL_01 = -1;     /* T_switchingTimeUL_01 */
static int hf_nr_rrc_fr1_04 = -1;                 /* T_fr1_04 */
static int hf_nr_rrc_fr2_04 = -1;                 /* T_fr2_04 */
static int hf_nr_rrc_barometerMeasReport_r16 = -1;  /* T_barometerMeasReport_r16 */
static int hf_nr_rrc_immMeasBT_r16 = -1;          /* T_immMeasBT_r16 */
static int hf_nr_rrc_immMeasWLAN_r16 = -1;        /* T_immMeasWLAN_r16 */
static int hf_nr_rrc_loggedMeasBT_r16 = -1;       /* T_loggedMeasBT_r16 */
static int hf_nr_rrc_loggedMeasurements_r16 = -1;  /* T_loggedMeasurements_r16 */
static int hf_nr_rrc_loggedMeasWLAN_r16 = -1;     /* T_loggedMeasWLAN_r16 */
static int hf_nr_rrc_orientationMeasReport_r16 = -1;  /* T_orientationMeasReport_r16 */
static int hf_nr_rrc_speedMeasReport_r16 = -1;    /* T_speedMeasReport_r16 */
static int hf_nr_rrc_gnss_Location_r16 = -1;      /* T_gnss_Location_r16 */
static int hf_nr_rrc_ulPDCP_Delay_r16 = -1;       /* T_ulPDCP_Delay_r16 */
static int hf_nr_rrc_UE_CapabilityRAT_ContainerList_item = -1;  /* UE_CapabilityRAT_Container */
static int hf_nr_rrc_rat_Type = -1;               /* RAT_Type */
static int hf_nr_rrc_ue_CapabilityRAT_Container = -1;  /* T_ue_CapabilityRAT_Container */
static int hf_nr_rrc_UE_CapabilityRAT_RequestList_item = -1;  /* UE_CapabilityRAT_Request */
static int hf_nr_rrc_capabilityRequestFilter = -1;  /* T_capabilityRequestFilter */
static int hf_nr_rrc_mrdc_Request = -1;           /* T_mrdc_Request */
static int hf_nr_rrc_omitEN_DC = -1;              /* T_omitEN_DC */
static int hf_nr_rrc_includeNR_DC = -1;           /* T_includeNR_DC */
static int hf_nr_rrc_includeNE_DC = -1;           /* T_includeNE_DC */
static int hf_nr_rrc_codebookTypeRequest_r16 = -1;  /* T_codebookTypeRequest_r16 */
static int hf_nr_rrc_type1_SinglePanel_r16_01 = -1;  /* T_type1_SinglePanel_r16_01 */
static int hf_nr_rrc_type1_MultiPanel_r16_01 = -1;  /* T_type1_MultiPanel_r16_01 */
static int hf_nr_rrc_type2_r16_03 = -1;           /* T_type2_r16_03 */
static int hf_nr_rrc_type2_PortSelection_r16_01 = -1;  /* T_type2_PortSelection_r16_01 */
static int hf_nr_rrc_uplinkTxSwitchRequest_r16 = -1;  /* T_uplinkTxSwitchRequest_r16 */
static int hf_nr_rrc_requestedCellGrouping_r16 = -1;  /* SEQUENCE_SIZE_1_maxCellGroupings_r16_OF_CellGrouping_r16 */
static int hf_nr_rrc_requestedCellGrouping_r16_item = -1;  /* CellGrouping_r16 */
static int hf_nr_rrc_mcg_r16 = -1;                /* SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicatorNR */
static int hf_nr_rrc_mcg_r16_item = -1;           /* FreqBandIndicatorNR */
static int hf_nr_rrc_scg_r16 = -1;                /* SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicatorNR */
static int hf_nr_rrc_scg_r16_item = -1;           /* FreqBandIndicatorNR */
static int hf_nr_rrc_mode_r16 = -1;               /* T_mode_r16 */
static int hf_nr_rrc_frequencyBandListFilter = -1;  /* FreqBandList */
static int hf_nr_rrc_nonCriticalExtension_93 = -1;  /* UE_CapabilityRequestFilterNR_v1540 */
static int hf_nr_rrc_srs_SwitchingTimeRequest = -1;  /* T_srs_SwitchingTimeRequest */
static int hf_nr_rrc_nonCriticalExtension_94 = -1;  /* T_nonCriticalExtension_49 */
static int hf_nr_rrc_measAndMobParametersMRDC = -1;  /* MeasAndMobParametersMRDC */
static int hf_nr_rrc_phy_ParametersMRDC_v1530 = -1;  /* Phy_ParametersMRDC */
static int hf_nr_rrc_rf_ParametersMRDC = -1;      /* RF_ParametersMRDC */
static int hf_nr_rrc_generalParametersMRDC = -1;  /* GeneralParametersMRDC_XDD_Diff */
static int hf_nr_rrc_fdd_Add_UE_MRDC_Capabilities = -1;  /* UE_MRDC_CapabilityAddXDD_Mode */
static int hf_nr_rrc_tdd_Add_UE_MRDC_Capabilities = -1;  /* UE_MRDC_CapabilityAddXDD_Mode */
static int hf_nr_rrc_fr1_Add_UE_MRDC_Capabilities = -1;  /* UE_MRDC_CapabilityAddFRX_Mode */
static int hf_nr_rrc_fr2_Add_UE_MRDC_Capabilities = -1;  /* UE_MRDC_CapabilityAddFRX_Mode */
static int hf_nr_rrc_featureSetCombinations = -1;  /* SEQUENCE_SIZE_1_maxFeatureSetCombinations_OF_FeatureSetCombination */
static int hf_nr_rrc_featureSetCombinations_item = -1;  /* FeatureSetCombination */
static int hf_nr_rrc_pdcp_ParametersMRDC_v1530 = -1;  /* PDCP_ParametersMRDC */
static int hf_nr_rrc_lateNonCriticalExtension_01 = -1;  /* T_lateNonCriticalExtension */
static int hf_nr_rrc_nonCriticalExtension_95 = -1;  /* UE_MRDC_Capability_v1560 */
static int hf_nr_rrc_receivedFilters = -1;        /* T_receivedFilters */
static int hf_nr_rrc_measAndMobParametersMRDC_v1560 = -1;  /* MeasAndMobParametersMRDC_v1560 */
static int hf_nr_rrc_fdd_Add_UE_MRDC_Capabilities_v1560 = -1;  /* UE_MRDC_CapabilityAddXDD_Mode_v1560 */
static int hf_nr_rrc_tdd_Add_UE_MRDC_Capabilities_v1560 = -1;  /* UE_MRDC_CapabilityAddXDD_Mode_v1560 */
static int hf_nr_rrc_nonCriticalExtension_96 = -1;  /* UE_MRDC_Capability_v1610 */
static int hf_nr_rrc_measAndMobParametersMRDC_v1610 = -1;  /* MeasAndMobParametersMRDC_v1610 */
static int hf_nr_rrc_generalParametersMRDC_v1610 = -1;  /* GeneralParametersMRDC_v1610 */
static int hf_nr_rrc_pdcp_ParametersMRDC_v1610 = -1;  /* PDCP_ParametersMRDC_v1610 */
static int hf_nr_rrc_nonCriticalExtension_97 = -1;  /* T_nonCriticalExtension_50 */
static int hf_nr_rrc_rf_ParametersMRDC_v15g0 = -1;  /* RF_ParametersMRDC_v15g0 */
static int hf_nr_rrc_nonCriticalExtension_98 = -1;  /* T_nonCriticalExtension_51 */
static int hf_nr_rrc_generalParametersMRDC_XDD_Diff = -1;  /* GeneralParametersMRDC_XDD_Diff */
static int hf_nr_rrc_splitSRB_WithOneUL_Path = -1;  /* T_splitSRB_WithOneUL_Path */
static int hf_nr_rrc_splitDRB_withUL_Both_MCG_SCG = -1;  /* T_splitDRB_withUL_Both_MCG_SCG */
static int hf_nr_rrc_srb3 = -1;                   /* T_srb3 */
static int hf_nr_rrc_dummy_04 = -1;               /* T_dummy_04 */
static int hf_nr_rrc_f1c_OverEUTRA_r16 = -1;      /* T_f1c_OverEUTRA_r16 */
static int hf_nr_rrc_accessStratumRelease = -1;   /* AccessStratumRelease */
static int hf_nr_rrc_pdcp_Parameters = -1;        /* PDCP_Parameters */
static int hf_nr_rrc_rlc_Parameters = -1;         /* RLC_Parameters */
static int hf_nr_rrc_mac_Parameters = -1;         /* MAC_Parameters */
static int hf_nr_rrc_phy_Parameters = -1;         /* Phy_Parameters */
static int hf_nr_rrc_rf_Parameters = -1;          /* RF_Parameters */
static int hf_nr_rrc_measAndMobParameters = -1;   /* MeasAndMobParameters */
static int hf_nr_rrc_fdd_Add_UE_NR_Capabilities = -1;  /* UE_NR_CapabilityAddXDD_Mode */
static int hf_nr_rrc_tdd_Add_UE_NR_Capabilities = -1;  /* UE_NR_CapabilityAddXDD_Mode */
static int hf_nr_rrc_fr1_Add_UE_NR_Capabilities = -1;  /* UE_NR_CapabilityAddFRX_Mode */
static int hf_nr_rrc_fr2_Add_UE_NR_Capabilities = -1;  /* UE_NR_CapabilityAddFRX_Mode */
static int hf_nr_rrc_featureSets = -1;            /* FeatureSets */
static int hf_nr_rrc_lateNonCriticalExtension_02 = -1;  /* T_lateNonCriticalExtension_01 */
static int hf_nr_rrc_nonCriticalExtension_99 = -1;  /* UE_NR_Capability_v1530 */
static int hf_nr_rrc_fdd_Add_UE_NR_Capabilities_v1530 = -1;  /* UE_NR_CapabilityAddXDD_Mode_v1530 */
static int hf_nr_rrc_tdd_Add_UE_NR_Capabilities_v1530 = -1;  /* UE_NR_CapabilityAddXDD_Mode_v1530 */
static int hf_nr_rrc_uE_NR_Capability_v1530_dummy = -1;  /* T_uE_NR_Capability_v1530_dummy */
static int hf_nr_rrc_interRAT_Parameters = -1;    /* InterRAT_Parameters */
static int hf_nr_rrc_inactiveState = -1;          /* T_inactiveState */
static int hf_nr_rrc_delayBudgetReporting = -1;   /* T_delayBudgetReporting */
static int hf_nr_rrc_nonCriticalExtension_100 = -1;  /* UE_NR_Capability_v1540 */
static int hf_nr_rrc_sdap_Parameters = -1;        /* SDAP_Parameters */
static int hf_nr_rrc_overheatingInd = -1;         /* T_overheatingInd */
static int hf_nr_rrc_ims_Parameters = -1;         /* IMS_Parameters */
static int hf_nr_rrc_fr1_Add_UE_NR_Capabilities_v1540 = -1;  /* UE_NR_CapabilityAddFRX_Mode_v1540 */
static int hf_nr_rrc_fr2_Add_UE_NR_Capabilities_v1540 = -1;  /* UE_NR_CapabilityAddFRX_Mode_v1540 */
static int hf_nr_rrc_fr1_fr2_Add_UE_NR_Capabilities = -1;  /* UE_NR_CapabilityAddFRX_Mode */
static int hf_nr_rrc_nonCriticalExtension_101 = -1;  /* UE_NR_Capability_v1550 */
static int hf_nr_rrc_reducedCP_Latency = -1;      /* T_reducedCP_Latency */
static int hf_nr_rrc_nonCriticalExtension_102 = -1;  /* UE_NR_Capability_v1560 */
static int hf_nr_rrc_nrdc_Parameters = -1;        /* NRDC_Parameters */
static int hf_nr_rrc_receivedFilters_01 = -1;     /* T_receivedFilters_01 */
static int hf_nr_rrc_nonCriticalExtension_103 = -1;  /* UE_NR_Capability_v1570 */
static int hf_nr_rrc_nrdc_Parameters_v1570 = -1;  /* NRDC_Parameters_v1570 */
static int hf_nr_rrc_nonCriticalExtension_104 = -1;  /* UE_NR_Capability_v1610 */
static int hf_nr_rrc_nrdc_Parameters_v15c0 = -1;  /* NRDC_Parameters_v15c0 */
static int hf_nr_rrc_partialFR2_FallbackRX_Req = -1;  /* T_partialFR2_FallbackRX_Req */
static int hf_nr_rrc_nonCriticalExtension_105 = -1;  /* UE_NR_Capability_v15g0 */
static int hf_nr_rrc_rf_Parameters_v15g0 = -1;    /* RF_Parameters_v15g0 */
static int hf_nr_rrc_nonCriticalExtension_106 = -1;  /* T_nonCriticalExtension_52 */
static int hf_nr_rrc_inDeviceCoexInd_r16 = -1;    /* T_inDeviceCoexInd_r16 */
static int hf_nr_rrc_dl_DedicatedMessageSegmentation_r16 = -1;  /* T_dl_DedicatedMessageSegmentation_r16 */
static int hf_nr_rrc_nrdc_Parameters_v1610 = -1;  /* NRDC_Parameters_v1610 */
static int hf_nr_rrc_powSav_Parameters_r16 = -1;  /* PowSav_Parameters_r16 */
static int hf_nr_rrc_fr1_Add_UE_NR_Capabilities_v1610 = -1;  /* UE_NR_CapabilityAddFRX_Mode_v1610 */
static int hf_nr_rrc_fr2_Add_UE_NR_Capabilities_v1610 = -1;  /* UE_NR_CapabilityAddFRX_Mode_v1610 */
static int hf_nr_rrc_bh_RLF_Indication_r16 = -1;  /* T_bh_RLF_Indication_r16 */
static int hf_nr_rrc_directSN_AdditionFirstRRC_IAB_r16 = -1;  /* T_directSN_AdditionFirstRRC_IAB_r16 */
static int hf_nr_rrc_bap_Parameters_r16 = -1;     /* BAP_Parameters_r16 */
static int hf_nr_rrc_referenceTimeProvision_r16 = -1;  /* T_referenceTimeProvision_r16 */
static int hf_nr_rrc_sidelinkParameters_r16 = -1;  /* SidelinkParameters_r16 */
static int hf_nr_rrc_highSpeedParameters_r16 = -1;  /* HighSpeedParameters_r16 */
static int hf_nr_rrc_mac_Parameters_v1610 = -1;   /* MAC_Parameters_v1610 */
static int hf_nr_rrc_mcgRLF_RecoveryViaSCG_r16 = -1;  /* T_mcgRLF_RecoveryViaSCG_r16 */
static int hf_nr_rrc_resumeWithStoredMCG_SCells_r16 = -1;  /* T_resumeWithStoredMCG_SCells_r16 */
static int hf_nr_rrc_resumeWithStoredSCG_r16 = -1;  /* T_resumeWithStoredSCG_r16 */
static int hf_nr_rrc_resumeWithSCG_Config_r16 = -1;  /* T_resumeWithSCG_Config_r16 */
static int hf_nr_rrc_ue_BasedPerfMeas_Parameters_r16 = -1;  /* UE_BasedPerfMeas_Parameters_r16 */
static int hf_nr_rrc_son_Parameters_r16 = -1;     /* SON_Parameters_r16 */
static int hf_nr_rrc_onDemandSIB_Connected_r16 = -1;  /* T_onDemandSIB_Connected_r16 */
static int hf_nr_rrc_nonCriticalExtension_107 = -1;  /* UE_NR_Capability_v1640 */
static int hf_nr_rrc_redirectAtResumeByNAS_r16 = -1;  /* T_redirectAtResumeByNAS_r16 */
static int hf_nr_rrc_phy_ParametersSharedSpectrumChAccess_r16 = -1;  /* Phy_ParametersSharedSpectrumChAccess_r16 */
static int hf_nr_rrc_nonCriticalExtension_108 = -1;  /* UE_NR_Capability_v1650 */
static int hf_nr_rrc_mpsPriorityIndication_r16_01 = -1;  /* T_mpsPriorityIndication_r16_01 */
static int hf_nr_rrc_highSpeedParameters_v1650 = -1;  /* HighSpeedParameters_v1650 */
static int hf_nr_rrc_nonCriticalExtension_109 = -1;  /* T_nonCriticalExtension_53 */
static int hf_nr_rrc_flowControlBH_RLC_ChannelBased_r16 = -1;  /* T_flowControlBH_RLC_ChannelBased_r16 */
static int hf_nr_rrc_flowControlRouting_ID_Based_r16 = -1;  /* T_flowControlRouting_ID_Based_r16 */
static int hf_nr_rrc_ul_DynamicChAccess_r16 = -1;  /* T_ul_DynamicChAccess_r16 */
static int hf_nr_rrc_ul_Semi_StaticChAccess_r16 = -1;  /* T_ul_Semi_StaticChAccess_r16 */
static int hf_nr_rrc_ssb_RRM_DynamicChAccess_r16 = -1;  /* T_ssb_RRM_DynamicChAccess_r16 */
static int hf_nr_rrc_ssb_RRM_Semi_StaticChAccess_r16 = -1;  /* T_ssb_RRM_Semi_StaticChAccess_r16 */
static int hf_nr_rrc_mib_Acquisition_r16 = -1;    /* T_mib_Acquisition_r16 */
static int hf_nr_rrc_ssb_RLM_DynamicChAccess_r16 = -1;  /* T_ssb_RLM_DynamicChAccess_r16 */
static int hf_nr_rrc_ssb_RLM_Semi_StaticChAccess_r16 = -1;  /* T_ssb_RLM_Semi_StaticChAccess_r16 */
static int hf_nr_rrc_sib1_Acquisition_r16 = -1;   /* T_sib1_Acquisition_r16 */
static int hf_nr_rrc_extRA_ResponseWindow_r16 = -1;  /* T_extRA_ResponseWindow_r16 */
static int hf_nr_rrc_ssb_BFD_CBD_dynamicChannelAccess_r16 = -1;  /* T_ssb_BFD_CBD_dynamicChannelAccess_r16 */
static int hf_nr_rrc_ssb_BFD_CBD_semi_staticChannelAccess_r16 = -1;  /* T_ssb_BFD_CBD_semi_staticChannelAccess_r16 */
static int hf_nr_rrc_csi_RS_BFD_CBD_r16 = -1;     /* T_csi_RS_BFD_CBD_r16 */
static int hf_nr_rrc_ul_ChannelBW_SCell_10mhz_r16 = -1;  /* T_ul_ChannelBW_SCell_10mhz_r16 */
static int hf_nr_rrc_rssi_ChannelOccupancyReporting_r16 = -1;  /* T_rssi_ChannelOccupancyReporting_r16 */
static int hf_nr_rrc_srs_StartAnyOFDM_Symbol_r16 = -1;  /* T_srs_StartAnyOFDM_Symbol_r16 */
static int hf_nr_rrc_searchSpaceFreqMonitorLocation_r16 = -1;  /* INTEGER_1_5 */
static int hf_nr_rrc_coreset_RB_Offset_r16 = -1;  /* T_coreset_RB_Offset_r16 */
static int hf_nr_rrc_cgi_Acquisition_r16 = -1;    /* T_cgi_Acquisition_r16 */
static int hf_nr_rrc_configuredUL_Tx_r16 = -1;    /* T_configuredUL_Tx_r16 */
static int hf_nr_rrc_prach_Wideband_r16 = -1;     /* T_prach_Wideband_r16 */
static int hf_nr_rrc_dci_AvailableRB_Set_r16 = -1;  /* T_dci_AvailableRB_Set_r16 */
static int hf_nr_rrc_dci_ChOccupancyDuration_r16 = -1;  /* T_dci_ChOccupancyDuration_r16 */
static int hf_nr_rrc_typeB_PDSCH_length_r16 = -1;  /* T_typeB_PDSCH_length_r16 */
static int hf_nr_rrc_searchSpaceSwitchWithDCI_r16 = -1;  /* T_searchSpaceSwitchWithDCI_r16 */
static int hf_nr_rrc_searchSpaceSwitchWithoutDCI_r16 = -1;  /* T_searchSpaceSwitchWithoutDCI_r16 */
static int hf_nr_rrc_searchSpaceSwitchCapability2_r16 = -1;  /* T_searchSpaceSwitchCapability2_r16 */
static int hf_nr_rrc_non_numericalPDSCH_HARQ_timing_r16 = -1;  /* T_non_numericalPDSCH_HARQ_timing_r16 */
static int hf_nr_rrc_enhancedDynamicHARQ_codebook_r16 = -1;  /* T_enhancedDynamicHARQ_codebook_r16 */
static int hf_nr_rrc_oneShotHARQ_feedback_r16 = -1;  /* T_oneShotHARQ_feedback_r16 */
static int hf_nr_rrc_multiPUSCH_UL_grant_r16 = -1;  /* T_multiPUSCH_UL_grant_r16 */
static int hf_nr_rrc_csi_RS_RLM_r16 = -1;         /* T_csi_RS_RLM_r16 */
static int hf_nr_rrc_dummy_05 = -1;               /* T_dummy_05 */
static int hf_nr_rrc_periodicAndSemi_PersistentCSI_RS_r16 = -1;  /* T_periodicAndSemi_PersistentCSI_RS_r16 */
static int hf_nr_rrc_pusch_PRB_interlace_r16 = -1;  /* T_pusch_PRB_interlace_r16 */
static int hf_nr_rrc_pucch_F0_F1_PRB_Interlace_r16 = -1;  /* T_pucch_F0_F1_PRB_Interlace_r16 */
static int hf_nr_rrc_occ_PRB_PF2_PF3_r16 = -1;    /* T_occ_PRB_PF2_PF3_r16 */
static int hf_nr_rrc_extCP_rangeCG_PUSCH_r16 = -1;  /* T_extCP_rangeCG_PUSCH_r16 */
static int hf_nr_rrc_configuredGrantWithReTx_r16 = -1;  /* T_configuredGrantWithReTx_r16 */
static int hf_nr_rrc_ed_Threshold_r16 = -1;       /* T_ed_Threshold_r16 */
static int hf_nr_rrc_ul_DL_COT_Sharing_r16 = -1;  /* T_ul_DL_COT_Sharing_r16 */
static int hf_nr_rrc_mux_CG_UCI_HARQ_ACK_r16 = -1;  /* T_mux_CG_UCI_HARQ_ACK_r16 */
static int hf_nr_rrc_cg_resourceConfig_r16 = -1;  /* T_cg_resourceConfig_r16 */
static int hf_nr_rrc_dl_ReceptionIntraCellGuardband_r16 = -1;  /* T_dl_ReceptionIntraCellGuardband_r16 */
static int hf_nr_rrc_dl_ReceptionLBT_subsetRB_r16 = -1;  /* T_dl_ReceptionLBT_subsetRB_r16 */
static int hf_nr_rrc_csi_RSRP_AndRSRQ_MeasWithSSB_r16 = -1;  /* T_csi_RSRP_AndRSRQ_MeasWithSSB_r16 */
static int hf_nr_rrc_csi_RSRP_AndRSRQ_MeasWithoutSSB_r16 = -1;  /* T_csi_RSRP_AndRSRQ_MeasWithoutSSB_r16 */
static int hf_nr_rrc_csi_SINR_Meas_r16 = -1;      /* T_csi_SINR_Meas_r16 */
static int hf_nr_rrc_ssb_AndCSI_RS_RLM_r16 = -1;  /* T_ssb_AndCSI_RS_RLM_r16 */
static int hf_nr_rrc_csi_RS_CFRA_ForHO_r16 = -1;  /* T_csi_RS_CFRA_ForHO_r16 */
static int hf_nr_rrc_extendedSearchSpaceSwitchWithDCI_r16 = -1;  /* T_extendedSearchSpaceSwitchWithDCI_r16 */
static int hf_nr_rrc_areaConfig_r16 = -1;         /* AreaConfig_r16 */
static int hf_nr_rrc_interFreqTargetList_r16 = -1;  /* SEQUENCE_SIZE_1_maxFreq_OF_InterFreqTargetInfo_r16 */
static int hf_nr_rrc_interFreqTargetList_r16_item = -1;  /* InterFreqTargetInfo_r16 */
static int hf_nr_rrc_cellGlobalIdList_r16 = -1;   /* CellGlobalIdList_r16 */
static int hf_nr_rrc_trackingAreaCodeList_r16 = -1;  /* TrackingAreaCodeList_r16 */
static int hf_nr_rrc_trackingAreaIdentityList_r16 = -1;  /* TrackingAreaIdentityList_r16 */
static int hf_nr_rrc_dl_CarrierFreq_r16 = -1;     /* ARFCN_ValueNR */
static int hf_nr_rrc_cellList_r16 = -1;           /* SEQUENCE_SIZE_1_32_OF_PhysCellId */
static int hf_nr_rrc_cellList_r16_item = -1;      /* PhysCellId */
static int hf_nr_rrc_CellGlobalIdList_r16_item = -1;  /* CGI_Info_Logging_r16 */
static int hf_nr_rrc_TrackingAreaCodeList_r16_item = -1;  /* TrackingAreaCode */
static int hf_nr_rrc_TrackingAreaIdentityList_r16_item = -1;  /* TrackingAreaIdentity_r16 */
static int hf_nr_rrc_BT_NameList_r16_item = -1;   /* BT_Name_r16 */
static int hf_nr_rrc_EUTRA_MBSFN_SubframeConfigList_item = -1;  /* EUTRA_MBSFN_SubframeConfig */
static int hf_nr_rrc_radioframeAllocationPeriod = -1;  /* T_radioframeAllocationPeriod */
static int hf_nr_rrc_radioframeAllocationOffset = -1;  /* INTEGER_0_7 */
static int hf_nr_rrc_subframeAllocation1 = -1;    /* T_subframeAllocation1 */
static int hf_nr_rrc_oneFrame = -1;               /* BIT_STRING_SIZE_6 */
static int hf_nr_rrc_fourFrames = -1;             /* BIT_STRING_SIZE_24 */
static int hf_nr_rrc_subframeAllocation2 = -1;    /* T_subframeAllocation2 */
static int hf_nr_rrc_oneFrame_01 = -1;            /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_fourFrames_01 = -1;          /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_EUTRA_MultiBandInfoList_item = -1;  /* EUTRA_MultiBandInfo */
static int hf_nr_rrc_eutra_FreqBandIndicator = -1;  /* FreqBandIndicatorEUTRA */
static int hf_nr_rrc_eutra_NS_PmaxList = -1;      /* EUTRA_NS_PmaxList */
static int hf_nr_rrc_EUTRA_NS_PmaxList_item = -1;  /* EUTRA_NS_PmaxValue */
static int hf_nr_rrc_additionalPmax_01 = -1;      /* INTEGER_M30_33 */
static int hf_nr_rrc_additionalSpectrumEmission_01 = -1;  /* INTEGER_1_288 */
static int hf_nr_rrc_start_01 = -1;               /* EUTRA_PhysCellId */
static int hf_nr_rrc_range_01 = -1;               /* T_range_01 */
static int hf_nr_rrc_iPv4_Address_r16 = -1;       /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_iPv6_Address_r16 = -1;       /* BIT_STRING_SIZE_128 */
static int hf_nr_rrc_iPv6_Prefix_r16 = -1;        /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_LogMeasResultListBT_r16_item = -1;  /* LogMeasResultBT_r16 */
static int hf_nr_rrc_bt_Addr_r16 = -1;            /* BIT_STRING_SIZE_48 */
static int hf_nr_rrc_rssi_BT_r16 = -1;            /* INTEGER_M128_127 */
static int hf_nr_rrc_LogMeasResultListWLAN_r16_item = -1;  /* LogMeasResultWLAN_r16 */
static int hf_nr_rrc_wlan_Identifiers_r16 = -1;   /* WLAN_Identifiers_r16 */
static int hf_nr_rrc_rssiWLAN_r16 = -1;           /* WLAN_RSSI_Range_r16 */
static int hf_nr_rrc_rtt_WLAN_r16 = -1;           /* WLAN_RTT_r16 */
static int hf_nr_rrc_ssid_r16 = -1;               /* T_ssid_r16 */
static int hf_nr_rrc_bssid_r16 = -1;              /* OCTET_STRING_SIZE_6 */
static int hf_nr_rrc_hessid_r16 = -1;             /* OCTET_STRING_SIZE_6 */
static int hf_nr_rrc_rttValue_r16 = -1;           /* INTEGER_0_16777215 */
static int hf_nr_rrc_rttUnits_r16 = -1;           /* T_rttUnits_r16 */
static int hf_nr_rrc_rttAccuracy_r16 = -1;        /* INTEGER_0_255 */
static int hf_nr_rrc_delayBudgetReportingConfig = -1;  /* T_delayBudgetReportingConfig */
static int hf_nr_rrc_setup_113 = -1;              /* T_setup */
static int hf_nr_rrc_delayBudgetReportingProhibitTimer = -1;  /* T_delayBudgetReportingProhibitTimer */
static int hf_nr_rrc_overheatingAssistanceConfig = -1;  /* T_overheatingAssistanceConfig */
static int hf_nr_rrc_setup_114 = -1;              /* OverheatingAssistanceConfig */
static int hf_nr_rrc_CandidateServingFreqListNR_r16_item = -1;  /* ARFCN_ValueNR */
static int hf_nr_rrc_idc_AssistanceConfig_r16 = -1;  /* T_idc_AssistanceConfig_r16 */
static int hf_nr_rrc_setup_115 = -1;              /* IDC_AssistanceConfig_r16 */
static int hf_nr_rrc_drx_PreferenceConfig_r16 = -1;  /* T_drx_PreferenceConfig_r16 */
static int hf_nr_rrc_setup_116 = -1;              /* DRX_PreferenceConfig_r16 */
static int hf_nr_rrc_maxBW_PreferenceConfig_r16 = -1;  /* T_maxBW_PreferenceConfig_r16 */
static int hf_nr_rrc_setup_117 = -1;              /* MaxBW_PreferenceConfig_r16 */
static int hf_nr_rrc_maxCC_PreferenceConfig_r16 = -1;  /* T_maxCC_PreferenceConfig_r16 */
static int hf_nr_rrc_setup_118 = -1;              /* MaxCC_PreferenceConfig_r16 */
static int hf_nr_rrc_maxMIMO_LayerPreferenceConfig_r16 = -1;  /* T_maxMIMO_LayerPreferenceConfig_r16 */
static int hf_nr_rrc_setup_119 = -1;              /* MaxMIMO_LayerPreferenceConfig_r16 */
static int hf_nr_rrc_minSchedulingOffsetPreferenceConfig_r16 = -1;  /* T_minSchedulingOffsetPreferenceConfig_r16 */
static int hf_nr_rrc_setup_120 = -1;              /* MinSchedulingOffsetPreferenceConfig_r16 */
static int hf_nr_rrc_releasePreferenceConfig_r16 = -1;  /* T_releasePreferenceConfig_r16 */
static int hf_nr_rrc_setup_121 = -1;              /* ReleasePreferenceConfig_r16 */
static int hf_nr_rrc_referenceTimePreferenceReporting_r16 = -1;  /* T_referenceTimePreferenceReporting_r16 */
static int hf_nr_rrc_btNameList_r16 = -1;         /* T_btNameList_r16 */
static int hf_nr_rrc_wlanNameList_r16 = -1;       /* T_wlanNameList_r16 */
static int hf_nr_rrc_sensorNameList_r16 = -1;     /* T_sensorNameList_r16 */
static int hf_nr_rrc_obtainCommonLocation_r16 = -1;  /* T_obtainCommonLocation_r16 */
static int hf_nr_rrc_sl_AssistanceConfigNR_r16 = -1;  /* T_sl_AssistanceConfigNR_r16 */
static int hf_nr_rrc_overheatingIndicationProhibitTimer = -1;  /* T_overheatingIndicationProhibitTimer */
static int hf_nr_rrc_candidateServingFreqListNR_r16 = -1;  /* CandidateServingFreqListNR_r16 */
static int hf_nr_rrc_drx_PreferenceProhibitTimer_r16 = -1;  /* T_drx_PreferenceProhibitTimer_r16 */
static int hf_nr_rrc_maxBW_PreferenceProhibitTimer_r16 = -1;  /* T_maxBW_PreferenceProhibitTimer_r16 */
static int hf_nr_rrc_maxCC_PreferenceProhibitTimer_r16 = -1;  /* T_maxCC_PreferenceProhibitTimer_r16 */
static int hf_nr_rrc_maxMIMO_LayerPreferenceProhibitTimer_r16 = -1;  /* T_maxMIMO_LayerPreferenceProhibitTimer_r16 */
static int hf_nr_rrc_minSchedulingOffsetPreferenceProhibitTimer_r16 = -1;  /* T_minSchedulingOffsetPreferenceProhibitTimer_r16 */
static int hf_nr_rrc_releasePreferenceProhibitTimer_r16 = -1;  /* T_releasePreferenceProhibitTimer_r16 */
static int hf_nr_rrc_connectedReporting = -1;     /* T_connectedReporting */
static int hf_nr_rrc_measUncomBarPre_r16 = -1;    /* T_measUncomBarPre_r16 */
static int hf_nr_rrc_measUeSpeed = -1;            /* T_measUeSpeed */
static int hf_nr_rrc_measUeOrientation = -1;      /* T_measUeOrientation */
static int hf_nr_rrc_traceId_r16 = -1;            /* OCTET_STRING_SIZE_3 */
static int hf_nr_rrc_logMeasAvailable_r16_01 = -1;  /* T_logMeasAvailable_r16_01 */
static int hf_nr_rrc_logMeasAvailableBT_r16_01 = -1;  /* T_logMeasAvailableBT_r16_01 */
static int hf_nr_rrc_logMeasAvailableWLAN_r16_01 = -1;  /* T_logMeasAvailableWLAN_r16_01 */
static int hf_nr_rrc_connEstFailInfoAvailable_r16 = -1;  /* T_connEstFailInfoAvailable_r16 */
static int hf_nr_rrc_rlf_InfoAvailable_r16 = -1;  /* T_rlf_InfoAvailable_r16 */
static int hf_nr_rrc_VisitedCellInfoList_r16_item = -1;  /* VisitedCellInfo_r16 */
static int hf_nr_rrc_visitedCellId_r16 = -1;      /* T_visitedCellId_r16 */
static int hf_nr_rrc_nr_CellId_r16 = -1;          /* T_nr_CellId_r16 */
static int hf_nr_rrc_pci_arfcn_r16_03 = -1;       /* T_pci_arfcn_r16_03 */
static int hf_nr_rrc_eutra_CellId_r16 = -1;       /* T_eutra_CellId_r16 */
static int hf_nr_rrc_cellGlobalId_r16_02 = -1;    /* CGI_InfoEUTRA */
static int hf_nr_rrc_pci_arfcn_r16_04 = -1;       /* T_pci_arfcn_r16_04 */
static int hf_nr_rrc_timeSpent_r16 = -1;          /* INTEGER_0_4095 */
static int hf_nr_rrc_WLAN_NameList_r16_item = -1;  /* WLAN_Name_r16 */
static int hf_nr_rrc_sl_BWP_Id = -1;              /* BWP_Id */
static int hf_nr_rrc_sl_BWP_Generic_r16 = -1;     /* SL_BWP_Generic_r16 */
static int hf_nr_rrc_sl_BWP_PoolConfig_r16 = -1;  /* SL_BWP_PoolConfig_r16 */
static int hf_nr_rrc_sl_BWP_r16 = -1;             /* BWP */
static int hf_nr_rrc_sl_LengthSymbols_r16 = -1;   /* T_sl_LengthSymbols_r16 */
static int hf_nr_rrc_sl_StartSymbol_r16 = -1;     /* T_sl_StartSymbol_r16 */
static int hf_nr_rrc_sl_PSBCH_Config_r16 = -1;    /* T_sl_PSBCH_Config_r16 */
static int hf_nr_rrc_setup_122 = -1;              /* SL_PSBCH_Config_r16 */
static int hf_nr_rrc_sl_TxDirectCurrentLocation_r16 = -1;  /* INTEGER_0_3301 */
static int hf_nr_rrc_sl_RxPool_r16 = -1;          /* SEQUENCE_SIZE_1_maxNrofRXPool_r16_OF_SL_ResourcePool_r16 */
static int hf_nr_rrc_sl_RxPool_r16_item = -1;     /* SL_ResourcePool_r16 */
static int hf_nr_rrc_sl_TxPoolSelectedNormal_r16 = -1;  /* SL_TxPoolDedicated_r16 */
static int hf_nr_rrc_sl_TxPoolScheduling_r16 = -1;  /* SL_TxPoolDedicated_r16 */
static int hf_nr_rrc_sl_TxPoolExceptional_r16 = -1;  /* SL_ResourcePoolConfig_r16 */
static int hf_nr_rrc_sl_PoolToReleaseList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofTXPool_r16_OF_SL_ResourcePoolID_r16 */
static int hf_nr_rrc_sl_PoolToReleaseList_r16_item = -1;  /* SL_ResourcePoolID_r16 */
static int hf_nr_rrc_sl_PoolToAddModList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofTXPool_r16_OF_SL_ResourcePoolConfig_r16 */
static int hf_nr_rrc_sl_PoolToAddModList_r16_item = -1;  /* SL_ResourcePoolConfig_r16 */
static int hf_nr_rrc_sl_ResourcePoolID_r16 = -1;  /* SL_ResourcePoolID_r16 */
static int hf_nr_rrc_sl_ResourcePool_r16 = -1;    /* SL_ResourcePool_r16 */
static int hf_nr_rrc_SL_CBR_PriorityTxConfigList_r16_item = -1;  /* SL_PriorityTxConfigIndex_r16 */
static int hf_nr_rrc_SL_CBR_PriorityTxConfigList_v1650_item = -1;  /* SL_PriorityTxConfigIndex_v1650 */
static int hf_nr_rrc_sl_PriorityThreshold_r16 = -1;  /* INTEGER_1_8 */
static int hf_nr_rrc_sl_DefaultTxConfigIndex_r16 = -1;  /* INTEGER_0_maxCBR_Level_1_r16 */
static int hf_nr_rrc_sl_CBR_ConfigIndex_r16 = -1;  /* INTEGER_0_maxCBR_Config_1_r16 */
static int hf_nr_rrc_sl_Tx_ConfigIndexList_r16 = -1;  /* SEQUENCE_SIZE_1_maxCBR_Level_r16_OF_SL_TxConfigIndex_r16 */
static int hf_nr_rrc_sl_Tx_ConfigIndexList_r16_item = -1;  /* SL_TxConfigIndex_r16 */
static int hf_nr_rrc_sl_MCS_RangeList_r16 = -1;   /* SEQUENCE_SIZE_1_maxCBR_Level_r16_OF_SL_MinMaxMCS_List_r16 */
static int hf_nr_rrc_sl_MCS_RangeList_r16_item = -1;  /* SL_MinMaxMCS_List_r16 */
static int hf_nr_rrc_sl_CBR_RangeConfigList_r16 = -1;  /* SEQUENCE_SIZE_1_maxCBR_Config_r16_OF_SL_CBR_LevelsConfig_r16 */
static int hf_nr_rrc_sl_CBR_RangeConfigList_r16_item = -1;  /* SL_CBR_LevelsConfig_r16 */
static int hf_nr_rrc_sl_CBR_PSSCH_TxConfigList_r16 = -1;  /* SEQUENCE_SIZE_1_maxTxConfig_r16_OF_SL_CBR_PSSCH_TxConfig_r16 */
static int hf_nr_rrc_sl_CBR_PSSCH_TxConfigList_r16_item = -1;  /* SL_CBR_PSSCH_TxConfig_r16 */
static int hf_nr_rrc_SL_CBR_LevelsConfig_r16_item = -1;  /* SL_CBR_r16 */
static int hf_nr_rrc_sl_CR_Limit_r16 = -1;        /* INTEGER_0_10000 */
static int hf_nr_rrc_sl_TxParameters_r16 = -1;    /* SL_PSSCH_TxParameters_r16 */
static int hf_nr_rrc_sl_PHY_MAC_RLC_Config_r16 = -1;  /* SL_PHY_MAC_RLC_Config_r16 */
static int hf_nr_rrc_sl_RadioBearerToReleaseList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofSLRB_r16_OF_SLRB_Uu_ConfigIndex_r16 */
static int hf_nr_rrc_sl_RadioBearerToReleaseList_r16_item = -1;  /* SLRB_Uu_ConfigIndex_r16 */
static int hf_nr_rrc_sl_RadioBearerToAddModList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofSLRB_r16_OF_SL_RadioBearerConfig_r16 */
static int hf_nr_rrc_sl_RadioBearerToAddModList_r16_item = -1;  /* SL_RadioBearerConfig_r16 */
static int hf_nr_rrc_sl_MeasConfigInfoToReleaseList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofSL_Dest_r16_OF_SL_DestinationIndex_r16 */
static int hf_nr_rrc_sl_MeasConfigInfoToReleaseList_r16_item = -1;  /* SL_DestinationIndex_r16 */
static int hf_nr_rrc_sl_MeasConfigInfoToAddModList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofSL_Dest_r16_OF_SL_MeasConfigInfo_r16 */
static int hf_nr_rrc_sl_MeasConfigInfoToAddModList_r16_item = -1;  /* SL_MeasConfigInfo_r16 */
static int hf_nr_rrc_t400_r16 = -1;               /* T_t400_r16 */
static int hf_nr_rrc_sl_ScheduledConfig_r16 = -1;  /* T_sl_ScheduledConfig_r16 */
static int hf_nr_rrc_setup_123 = -1;              /* SL_ScheduledConfig_r16 */
static int hf_nr_rrc_sl_UE_SelectedConfig_r16 = -1;  /* T_sl_UE_SelectedConfig_r16 */
static int hf_nr_rrc_setup_124 = -1;              /* SL_UE_SelectedConfig_r16 */
static int hf_nr_rrc_sl_FreqInfoToReleaseList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofFreqSL_r16_OF_SL_Freq_Id_r16 */
static int hf_nr_rrc_sl_FreqInfoToReleaseList_r16_item = -1;  /* SL_Freq_Id_r16 */
static int hf_nr_rrc_sl_FreqInfoToAddModList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofFreqSL_r16_OF_SL_FreqConfig_r16 */
static int hf_nr_rrc_sl_FreqInfoToAddModList_r16_item = -1;  /* SL_FreqConfig_r16 */
static int hf_nr_rrc_sl_RLC_BearerToReleaseList_r16 = -1;  /* SEQUENCE_SIZE_1_maxSL_LCID_r16_OF_SL_RLC_BearerConfigIndex_r16 */
static int hf_nr_rrc_sl_RLC_BearerToReleaseList_r16_item = -1;  /* SL_RLC_BearerConfigIndex_r16 */
static int hf_nr_rrc_sl_RLC_BearerToAddModList_r16 = -1;  /* SEQUENCE_SIZE_1_maxSL_LCID_r16_OF_SL_RLC_BearerConfig_r16 */
static int hf_nr_rrc_sl_RLC_BearerToAddModList_r16_item = -1;  /* SL_RLC_BearerConfig_r16 */
static int hf_nr_rrc_sl_MaxNumConsecutiveDTX_r16 = -1;  /* T_sl_MaxNumConsecutiveDTX_r16 */
static int hf_nr_rrc_sl_CSI_Acquisition_r16 = -1;  /* T_sl_CSI_Acquisition_r16 */
static int hf_nr_rrc_sl_CSI_SchedulingRequestId_r16 = -1;  /* T_sl_CSI_SchedulingRequestId_r16 */
static int hf_nr_rrc_setup_125 = -1;              /* SchedulingRequestId */
static int hf_nr_rrc_sl_SSB_PriorityNR_r16 = -1;  /* INTEGER_1_8 */
static int hf_nr_rrc_networkControlledSyncTx_r16 = -1;  /* T_networkControlledSyncTx_r16 */
static int hf_nr_rrc_sl_ConfigIndexCG_r16 = -1;   /* SL_ConfigIndexCG_r16 */
static int hf_nr_rrc_sl_PeriodCG_r16 = -1;        /* SL_PeriodCG_r16 */
static int hf_nr_rrc_sl_NrOfHARQ_Processes_r16 = -1;  /* INTEGER_1_16 */
static int hf_nr_rrc_sl_HARQ_ProcID_offset_r16 = -1;  /* INTEGER_0_15 */
static int hf_nr_rrc_sl_CG_MaxTransNumList_r16 = -1;  /* SL_CG_MaxTransNumList_r16 */
static int hf_nr_rrc_rrc_ConfiguredSidelinkGrant_r16 = -1;  /* T_rrc_ConfiguredSidelinkGrant_r16 */
static int hf_nr_rrc_sl_TimeResourceCG_Type1_r16 = -1;  /* INTEGER_0_496 */
static int hf_nr_rrc_sl_StartSubchannelCG_Type1_r16 = -1;  /* INTEGER_0_26 */
static int hf_nr_rrc_sl_FreqResourceCG_Type1_r16 = -1;  /* INTEGER_0_6929 */
static int hf_nr_rrc_sl_TimeOffsetCG_Type1_r16 = -1;  /* INTEGER_0_7999 */
static int hf_nr_rrc_sl_N1PUCCH_AN_r16 = -1;      /* PUCCH_ResourceId */
static int hf_nr_rrc_sl_PSFCH_ToPUCCH_CG_Type1_r16 = -1;  /* INTEGER_0_15 */
static int hf_nr_rrc_sl_TimeReferenceSFN_Type1_r16 = -1;  /* T_sl_TimeReferenceSFN_Type1_r16 */
static int hf_nr_rrc_sl_N1PUCCH_AN_Type2_r16 = -1;  /* PUCCH_ResourceId */
static int hf_nr_rrc_SL_CG_MaxTransNumList_r16_item = -1;  /* SL_CG_MaxTransNum_r16 */
static int hf_nr_rrc_sl_Priority_r16 = -1;        /* INTEGER_1_8 */
static int hf_nr_rrc_sl_MaxTransNum_r16 = -1;     /* INTEGER_1_32 */
static int hf_nr_rrc_sl_PeriodCG1_r16 = -1;       /* T_sl_PeriodCG1_r16 */
static int hf_nr_rrc_sl_PeriodCG2_r16 = -1;       /* INTEGER_1_99 */
static int hf_nr_rrc_sl_Freq_Id_r16 = -1;         /* SL_Freq_Id_r16 */
static int hf_nr_rrc_sl_SCS_SpecificCarrierList_r16 = -1;  /* SEQUENCE_SIZE_1_maxSCSs_OF_SCS_SpecificCarrier */
static int hf_nr_rrc_sl_SCS_SpecificCarrierList_r16_item = -1;  /* SCS_SpecificCarrier */
static int hf_nr_rrc_sl_AbsoluteFrequencyPointA_r16 = -1;  /* ARFCN_ValueNR */
static int hf_nr_rrc_sl_AbsoluteFrequencySSB_r16 = -1;  /* ARFCN_ValueNR */
static int hf_nr_rrc_frequencyShift7p5khzSL_r16 = -1;  /* T_frequencyShift7p5khzSL_r16 */
static int hf_nr_rrc_valueN_r16 = -1;             /* INTEGER_M1_1 */
static int hf_nr_rrc_sl_BWP_ToReleaseList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofSL_BWPs_r16_OF_BWP_Id */
static int hf_nr_rrc_sl_BWP_ToReleaseList_r16_item = -1;  /* BWP_Id */
static int hf_nr_rrc_sl_BWP_ToAddModList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofSL_BWPs_r16_OF_SL_BWP_Config_r16 */
static int hf_nr_rrc_sl_BWP_ToAddModList_r16_item = -1;  /* SL_BWP_Config_r16 */
static int hf_nr_rrc_sl_SyncConfigList_r16 = -1;  /* SL_SyncConfigList_r16 */
static int hf_nr_rrc_sl_SyncPriority_r16 = -1;    /* T_sl_SyncPriority_r16 */
static int hf_nr_rrc_sl_PrioritisedBitRate_r16 = -1;  /* T_sl_PrioritisedBitRate_r16 */
static int hf_nr_rrc_sl_BucketSizeDuration_r16 = -1;  /* T_sl_BucketSizeDuration_r16 */
static int hf_nr_rrc_sl_ConfiguredGrantType1Allowed_r16 = -1;  /* T_sl_ConfiguredGrantType1Allowed_r16 */
static int hf_nr_rrc_sl_HARQ_FeedbackEnabled_r16 = -1;  /* T_sl_HARQ_FeedbackEnabled_r16 */
static int hf_nr_rrc_sl_AllowedCG_List_r16 = -1;  /* SEQUENCE_SIZE_0_maxNrofCG_SL_1_r16_OF_SL_ConfigIndexCG_r16 */
static int hf_nr_rrc_sl_AllowedCG_List_r16_item = -1;  /* SL_ConfigIndexCG_r16 */
static int hf_nr_rrc_sl_AllowedSCS_List_r16 = -1;  /* SEQUENCE_SIZE_1_maxSCSs_OF_SubcarrierSpacing */
static int hf_nr_rrc_sl_AllowedSCS_List_r16_item = -1;  /* SubcarrierSpacing */
static int hf_nr_rrc_sl_MaxPUSCH_Duration_r16 = -1;  /* T_sl_MaxPUSCH_Duration_r16 */
static int hf_nr_rrc_sl_LogicalChannelGroup_r16 = -1;  /* INTEGER_0_maxLCG_ID */
static int hf_nr_rrc_sl_SchedulingRequestId_r16 = -1;  /* SchedulingRequestId */
static int hf_nr_rrc_sl_LogicalChannelSR_DelayTimerApplied_r16 = -1;  /* BOOLEAN */
static int hf_nr_rrc_sl_DestinationIndex_r16 = -1;  /* SL_DestinationIndex_r16 */
static int hf_nr_rrc_sl_MeasConfig_r16 = -1;      /* SL_MeasConfig_r16 */
static int hf_nr_rrc_sl_MeasObjectToRemoveList_r16 = -1;  /* SL_MeasObjectToRemoveList_r16 */
static int hf_nr_rrc_sl_MeasObjectToAddModList_r16 = -1;  /* SL_MeasObjectList_r16 */
static int hf_nr_rrc_sl_ReportConfigToRemoveList_r16 = -1;  /* SL_ReportConfigToRemoveList_r16 */
static int hf_nr_rrc_sl_ReportConfigToAddModList_r16 = -1;  /* SL_ReportConfigList_r16 */
static int hf_nr_rrc_sl_MeasIdToRemoveList_r16 = -1;  /* SL_MeasIdToRemoveList_r16 */
static int hf_nr_rrc_sl_MeasIdToAddModList_r16 = -1;  /* SL_MeasIdList_r16 */
static int hf_nr_rrc_sl_QuantityConfig_r16 = -1;  /* SL_QuantityConfig_r16 */
static int hf_nr_rrc_SL_MeasObjectToRemoveList_r16_item = -1;  /* SL_MeasObjectId_r16 */
static int hf_nr_rrc_SL_ReportConfigToRemoveList_r16_item = -1;  /* SL_ReportConfigId_r16 */
static int hf_nr_rrc_SL_MeasIdToRemoveList_r16_item = -1;  /* SL_MeasId_r16 */
static int hf_nr_rrc_SL_MeasIdList_r16_item = -1;  /* SL_MeasIdInfo_r16 */
static int hf_nr_rrc_sl_MeasId_r16 = -1;          /* SL_MeasId_r16 */
static int hf_nr_rrc_sl_MeasObjectId_r16 = -1;    /* SL_MeasObjectId_r16 */
static int hf_nr_rrc_sl_ReportConfigId_r16 = -1;  /* SL_ReportConfigId_r16 */
static int hf_nr_rrc_SL_MeasObjectList_r16_item = -1;  /* SL_MeasObjectInfo_r16 */
static int hf_nr_rrc_sl_MeasObject_r16 = -1;      /* SL_MeasObject_r16 */
static int hf_nr_rrc_frequencyInfoSL_r16 = -1;    /* ARFCN_ValueNR */
static int hf_nr_rrc_sl_DiscardTimer_r16 = -1;    /* T_sl_DiscardTimer_r16 */
static int hf_nr_rrc_sl_PDCP_SN_Size_r16 = -1;    /* T_sl_PDCP_SN_Size_r16 */
static int hf_nr_rrc_sl_OutOfOrderDelivery = -1;  /* T_sl_OutOfOrderDelivery */
static int hf_nr_rrc_dl_P0_PSBCH_r16 = -1;        /* INTEGER_M16_15 */
static int hf_nr_rrc_dl_Alpha_PSBCH_r16 = -1;     /* T_dl_Alpha_PSBCH_r16 */
static int hf_nr_rrc_SL_PSSCH_TxConfigList_r16_item = -1;  /* SL_PSSCH_TxConfig_r16 */
static int hf_nr_rrc_sl_TypeTxSync_r16 = -1;      /* SL_TypeTxSync_r16 */
static int hf_nr_rrc_sl_ThresUE_Speed_r16 = -1;   /* T_sl_ThresUE_Speed_r16 */
static int hf_nr_rrc_sl_ParametersAboveThres_r16 = -1;  /* SL_PSSCH_TxParameters_r16 */
static int hf_nr_rrc_sl_ParametersBelowThres_r16 = -1;  /* SL_PSSCH_TxParameters_r16 */
static int hf_nr_rrc_sl_ParametersAboveThres_v1650 = -1;  /* SL_MinMaxMCS_List_r16 */
static int hf_nr_rrc_sl_ParametersBelowThres_v1650 = -1;  /* SL_MinMaxMCS_List_r16 */
static int hf_nr_rrc_sl_MinMCS_PSSCH_r16 = -1;    /* INTEGER_0_27 */
static int hf_nr_rrc_sl_MaxMCS_PSSCH_r16 = -1;    /* INTEGER_0_31 */
static int hf_nr_rrc_sl_MinSubChannelNumPSSCH_r16 = -1;  /* INTEGER_1_27 */
static int hf_nr_rrc_sl_MaxSubchannelNumPSSCH_r16 = -1;  /* INTEGER_1_27 */
static int hf_nr_rrc_sl_MaxTxTransNumPSSCH_r16 = -1;  /* INTEGER_1_32 */
static int hf_nr_rrc_sl_MaxTxPower_r16 = -1;      /* SL_TxPower_r16 */
static int hf_nr_rrc_sl_PQI_r16 = -1;             /* SL_PQI_r16 */
static int hf_nr_rrc_sl_GFBR_r16 = -1;            /* INTEGER_0_4000000000 */
static int hf_nr_rrc_sl_MFBR_r16 = -1;            /* INTEGER_0_4000000000 */
static int hf_nr_rrc_sl_Range_r16 = -1;           /* INTEGER_1_1000 */
static int hf_nr_rrc_sl_StandardizedPQI_r16 = -1;  /* INTEGER_0_255 */
static int hf_nr_rrc_sl_Non_StandardizedPQI_r16 = -1;  /* T_sl_Non_StandardizedPQI_r16 */
static int hf_nr_rrc_sl_ResourceType_r16 = -1;    /* T_sl_ResourceType_r16 */
static int hf_nr_rrc_sl_PriorityLevel_r16 = -1;   /* INTEGER_1_8 */
static int hf_nr_rrc_sl_PacketDelayBudget_r16 = -1;  /* INTEGER_0_1023 */
static int hf_nr_rrc_sl_PacketErrorRate_r16 = -1;  /* INTEGER_0_9 */
static int hf_nr_rrc_sl_AveragingWindow_r16 = -1;  /* INTEGER_0_4095 */
static int hf_nr_rrc_sl_MaxDataBurstVolume_r16 = -1;  /* INTEGER_0_4095 */
static int hf_nr_rrc_sl_FilterCoefficientDMRS_r16 = -1;  /* FilterCoefficient */
static int hf_nr_rrc_slrb_Uu_ConfigIndex_r16 = -1;  /* SLRB_Uu_ConfigIndex_r16 */
static int hf_nr_rrc_sl_SDAP_Config_r16 = -1;     /* SL_SDAP_Config_r16 */
static int hf_nr_rrc_sl_PDCP_Config_r16 = -1;     /* SL_PDCP_Config_r16 */
static int hf_nr_rrc_sl_TransRange_r16 = -1;      /* T_sl_TransRange_r16 */
static int hf_nr_rrc_SL_ReportConfigList_r16_item = -1;  /* SL_ReportConfigInfo_r16 */
static int hf_nr_rrc_sl_ReportConfig_r16 = -1;    /* SL_ReportConfig_r16 */
static int hf_nr_rrc_sl_ReportType_r16 = -1;      /* T_sl_ReportType_r16 */
static int hf_nr_rrc_sl_Periodical_r16 = -1;      /* SL_PeriodicalReportConfig_r16 */
static int hf_nr_rrc_sl_EventTriggered_r16 = -1;  /* SL_EventTriggerConfig_r16 */
static int hf_nr_rrc_sl_ReportInterval_r16 = -1;  /* ReportInterval */
static int hf_nr_rrc_sl_ReportAmount_r16 = -1;    /* T_sl_ReportAmount_r16 */
static int hf_nr_rrc_sl_ReportQuantity_r16 = -1;  /* SL_MeasReportQuantity_r16 */
static int hf_nr_rrc_sl_RS_Type_r16 = -1;         /* SL_RS_Type_r16 */
static int hf_nr_rrc_sl_EventId_r16 = -1;         /* T_sl_EventId_r16 */
static int hf_nr_rrc_eventS1_r16 = -1;            /* T_eventS1_r16 */
static int hf_nr_rrc_s1_Threshold_r16 = -1;       /* SL_MeasTriggerQuantity_r16 */
static int hf_nr_rrc_sl_ReportOnLeave_r16 = -1;   /* BOOLEAN */
static int hf_nr_rrc_sl_Hysteresis_r16 = -1;      /* Hysteresis */
static int hf_nr_rrc_sl_TimeToTrigger_r16 = -1;   /* TimeToTrigger */
static int hf_nr_rrc_eventS2_r16 = -1;            /* T_eventS2_r16 */
static int hf_nr_rrc_s2_Threshold_r16 = -1;       /* SL_MeasTriggerQuantity_r16 */
static int hf_nr_rrc_sl_ReportAmount_r16_01 = -1;  /* T_sl_ReportAmount_r16_01 */
static int hf_nr_rrc_sL_MeasReportQuantity_r16_sl_RSRP_r16 = -1;  /* BOOLEAN */
static int hf_nr_rrc_sl_RSRP_r16 = -1;            /* RSRP_Range */
static int hf_nr_rrc_sl_PSCCH_Config_r16 = -1;    /* T_sl_PSCCH_Config_r16 */
static int hf_nr_rrc_setup_126 = -1;              /* SL_PSCCH_Config_r16 */
static int hf_nr_rrc_sl_PSSCH_Config_r16 = -1;    /* T_sl_PSSCH_Config_r16 */
static int hf_nr_rrc_setup_127 = -1;              /* SL_PSSCH_Config_r16 */
static int hf_nr_rrc_sl_PSFCH_Config_r16 = -1;    /* T_sl_PSFCH_Config_r16 */
static int hf_nr_rrc_setup_128 = -1;              /* SL_PSFCH_Config_r16 */
static int hf_nr_rrc_sl_SyncAllowed_r16 = -1;     /* SL_SyncAllowed_r16 */
static int hf_nr_rrc_sl_SubchannelSize_r16 = -1;  /* T_sl_SubchannelSize_r16 */
static int hf_nr_rrc_sL_ResourcePool_r16_dummy = -1;  /* INTEGER_10_160 */
static int hf_nr_rrc_sl_StartRB_Subchannel_r16 = -1;  /* INTEGER_0_265 */
static int hf_nr_rrc_sl_NumSubchannel_r16 = -1;   /* INTEGER_1_27 */
static int hf_nr_rrc_sl_Additional_MCS_Table_r16 = -1;  /* T_sl_Additional_MCS_Table_r16 */
static int hf_nr_rrc_sl_ThreshS_RSSI_CBR_r16 = -1;  /* INTEGER_0_45 */
static int hf_nr_rrc_sl_TimeWindowSizeCBR_r16 = -1;  /* T_sl_TimeWindowSizeCBR_r16 */
static int hf_nr_rrc_sl_TimeWindowSizeCR_r16 = -1;  /* T_sl_TimeWindowSizeCR_r16 */
static int hf_nr_rrc_sl_PTRS_Config_r16 = -1;     /* SL_PTRS_Config_r16 */
static int hf_nr_rrc_sl_UE_SelectedConfigRP_r16 = -1;  /* SL_UE_SelectedConfigRP_r16 */
static int hf_nr_rrc_sl_RxParametersNcell_r16 = -1;  /* T_sl_RxParametersNcell_r16 */
static int hf_nr_rrc_sl_TDD_Configuration_r16 = -1;  /* TDD_UL_DL_ConfigCommon */
static int hf_nr_rrc_sl_SyncConfigIndex_r16 = -1;  /* INTEGER_0_15 */
static int hf_nr_rrc_sl_ZoneConfigMCR_List_r16 = -1;  /* SEQUENCE_SIZE_16_OF_SL_ZoneConfigMCR_r16 */
static int hf_nr_rrc_sl_ZoneConfigMCR_List_r16_item = -1;  /* SL_ZoneConfigMCR_r16 */
static int hf_nr_rrc_sl_FilterCoefficient_r16 = -1;  /* FilterCoefficient */
static int hf_nr_rrc_sl_RB_Number_r16 = -1;       /* INTEGER_10_275 */
static int hf_nr_rrc_sl_PreemptionEnable_r16 = -1;  /* T_sl_PreemptionEnable_r16 */
static int hf_nr_rrc_sl_PriorityThreshold_UL_URLLC_r16 = -1;  /* INTEGER_1_9 */
static int hf_nr_rrc_sl_PriorityThreshold_r16_01 = -1;  /* INTEGER_1_9 */
static int hf_nr_rrc_sl_X_Overhead_r16 = -1;      /* T_sl_X_Overhead_r16 */
static int hf_nr_rrc_sl_PowerControl_r16 = -1;    /* SL_PowerControl_r16 */
static int hf_nr_rrc_sl_TxPercentageList_r16 = -1;  /* SL_TxPercentageList_r16 */
static int hf_nr_rrc_sl_MinMaxMCS_List_r16 = -1;  /* SL_MinMaxMCS_List_r16 */
static int hf_nr_rrc_sl_TimeResource_r16 = -1;    /* BIT_STRING_SIZE_10_160 */
static int hf_nr_rrc_sl_ZoneConfigMCR_Index_r16 = -1;  /* INTEGER_0_15 */
static int hf_nr_rrc_sl_TransRange_r16_01 = -1;   /* T_sl_TransRange_r16_01 */
static int hf_nr_rrc_sl_ZoneConfig_r16 = -1;      /* SL_ZoneConfig_r16 */
static int hf_nr_rrc_gnss_Sync_r16 = -1;          /* T_gnss_Sync_r16 */
static int hf_nr_rrc_gnbEnb_Sync_r16 = -1;        /* T_gnbEnb_Sync_r16 */
static int hf_nr_rrc_ue_Sync_r16 = -1;            /* T_ue_Sync_r16 */
static int hf_nr_rrc_sl_TimeResourcePSCCH_r16 = -1;  /* T_sl_TimeResourcePSCCH_r16 */
static int hf_nr_rrc_sl_FreqResourcePSCCH_r16 = -1;  /* T_sl_FreqResourcePSCCH_r16 */
static int hf_nr_rrc_sl_DMRS_ScrambleID_r16 = -1;  /* INTEGER_0_65535 */
static int hf_nr_rrc_sl_NumReservedBits_r16 = -1;  /* INTEGER_2_4 */
static int hf_nr_rrc_sl_PSSCH_DMRS_TimePatternList_r16 = -1;  /* T_sl_PSSCH_DMRS_TimePatternList_r16 */
static int hf_nr_rrc_sl_PSSCH_DMRS_TimePatternList_r16_item = -1;  /* INTEGER_2_4 */
static int hf_nr_rrc_sl_BetaOffsets2ndSCI_r16 = -1;  /* SEQUENCE_SIZE_4_OF_SL_BetaOffsets_r16 */
static int hf_nr_rrc_sl_BetaOffsets2ndSCI_r16_item = -1;  /* SL_BetaOffsets_r16 */
static int hf_nr_rrc_sl_Scaling_r16 = -1;         /* T_sl_Scaling_r16 */
static int hf_nr_rrc_sl_PSFCH_Period_r16 = -1;    /* T_sl_PSFCH_Period_r16 */
static int hf_nr_rrc_sl_PSFCH_RB_Set_r16 = -1;    /* BIT_STRING_SIZE_10_275 */
static int hf_nr_rrc_sl_NumMuxCS_Pair_r16 = -1;   /* T_sl_NumMuxCS_Pair_r16 */
static int hf_nr_rrc_sl_MinTimeGapPSFCH_r16 = -1;  /* T_sl_MinTimeGapPSFCH_r16 */
static int hf_nr_rrc_sl_PSFCH_HopID_r16 = -1;     /* INTEGER_0_1023 */
static int hf_nr_rrc_sl_PSFCH_CandidateResourceType_r16 = -1;  /* T_sl_PSFCH_CandidateResourceType_r16 */
static int hf_nr_rrc_sl_PTRS_FreqDensity_r16 = -1;  /* T_sl_PTRS_FreqDensity_r16 */
static int hf_nr_rrc_sl_PTRS_FreqDensity_r16_item = -1;  /* INTEGER_1_276 */
static int hf_nr_rrc_sl_PTRS_TimeDensity_r16 = -1;  /* T_sl_PTRS_TimeDensity_r16 */
static int hf_nr_rrc_sl_PTRS_TimeDensity_r16_item = -1;  /* INTEGER_0_29 */
static int hf_nr_rrc_sl_PTRS_RE_Offset_r16 = -1;  /* T_sl_PTRS_RE_Offset_r16 */
static int hf_nr_rrc_sl_CBR_PriorityTxConfigList_r16 = -1;  /* SL_CBR_PriorityTxConfigList_r16 */
static int hf_nr_rrc_sl_Thres_RSRP_List_r16 = -1;  /* SL_Thres_RSRP_List_r16 */
static int hf_nr_rrc_sl_MultiReserveResource_r16 = -1;  /* T_sl_MultiReserveResource_r16 */
static int hf_nr_rrc_sl_MaxNumPerReserve_r16 = -1;  /* T_sl_MaxNumPerReserve_r16 */
static int hf_nr_rrc_sl_SensingWindow_r16 = -1;   /* T_sl_SensingWindow_r16 */
static int hf_nr_rrc_sl_SelectionWindowList_r16 = -1;  /* SL_SelectionWindowList_r16 */
static int hf_nr_rrc_sl_ResourceReservePeriodList_r16 = -1;  /* SEQUENCE_SIZE_1_16_OF_SL_ResourceReservePeriod_r16 */
static int hf_nr_rrc_sl_ResourceReservePeriodList_r16_item = -1;  /* SL_ResourceReservePeriod_r16 */
static int hf_nr_rrc_sl_RS_ForSensing_r16 = -1;   /* T_sl_RS_ForSensing_r16 */
static int hf_nr_rrc_sl_CBR_PriorityTxConfigList_v1650 = -1;  /* SL_CBR_PriorityTxConfigList_v1650 */
static int hf_nr_rrc_sl_ResourceReservePeriod1_r16 = -1;  /* T_sl_ResourceReservePeriod1_r16 */
static int hf_nr_rrc_sl_ResourceReservePeriod2_r16 = -1;  /* INTEGER_1_99 */
static int hf_nr_rrc_SL_SelectionWindowList_r16_item = -1;  /* SL_SelectionWindowConfig_r16 */
static int hf_nr_rrc_sl_SelectionWindow_r16 = -1;  /* T_sl_SelectionWindow_r16 */
static int hf_nr_rrc_SL_TxPercentageList_r16_item = -1;  /* SL_TxPercentageConfig_r16 */
static int hf_nr_rrc_sl_TxPercentage_r16 = -1;    /* T_sl_TxPercentage_r16 */
static int hf_nr_rrc_SL_MinMaxMCS_List_r16_item = -1;  /* SL_MinMaxMCS_Config_r16 */
static int hf_nr_rrc_sl_MCS_Table_r16 = -1;       /* T_sl_MCS_Table_r16 */
static int hf_nr_rrc_sl_MaxTransPower_r16 = -1;   /* INTEGER_M30_33 */
static int hf_nr_rrc_sl_Alpha_PSSCH_PSCCH_r16 = -1;  /* T_sl_Alpha_PSSCH_PSCCH_r16 */
static int hf_nr_rrc_dl_Alpha_PSSCH_PSCCH_r16 = -1;  /* T_dl_Alpha_PSSCH_PSCCH_r16 */
static int hf_nr_rrc_sl_P0_PSSCH_PSCCH_r16 = -1;  /* INTEGER_M16_15 */
static int hf_nr_rrc_dl_P0_PSSCH_PSCCH_r16 = -1;  /* INTEGER_M16_15 */
static int hf_nr_rrc_dl_Alpha_PSFCH_r16 = -1;     /* T_dl_Alpha_PSFCH_r16 */
static int hf_nr_rrc_dl_P0_PSFCH_r16 = -1;        /* INTEGER_M16_15 */
static int hf_nr_rrc_sl_RLC_BearerConfigIndex_r16 = -1;  /* SL_RLC_BearerConfigIndex_r16 */
static int hf_nr_rrc_sl_ServedRadioBearer_r16 = -1;  /* SLRB_Uu_ConfigIndex_r16 */
static int hf_nr_rrc_sl_RLC_Config_r16 = -1;      /* SL_RLC_Config_r16 */
static int hf_nr_rrc_sl_MAC_LogicalChannelConfig_r16 = -1;  /* SL_LogicalChannelConfig_r16 */
static int hf_nr_rrc_sl_AM_RLC_r16 = -1;          /* T_sl_AM_RLC_r16 */
static int hf_nr_rrc_sl_SN_FieldLengthAM_r16 = -1;  /* SN_FieldLengthAM */
static int hf_nr_rrc_sl_T_PollRetransmit_r16 = -1;  /* T_PollRetransmit */
static int hf_nr_rrc_sl_PollPDU_r16 = -1;         /* PollPDU */
static int hf_nr_rrc_sl_PollByte_r16 = -1;        /* PollByte */
static int hf_nr_rrc_sl_MaxRetxThreshold_r16 = -1;  /* T_sl_MaxRetxThreshold_r16 */
static int hf_nr_rrc_sl_UM_RLC_r16 = -1;          /* T_sl_UM_RLC_r16 */
static int hf_nr_rrc_sl_SN_FieldLengthUM_r16 = -1;  /* SN_FieldLengthUM */
static int hf_nr_rrc_sl_RNTI_r16 = -1;            /* RNTI_Value */
static int hf_nr_rrc_mac_MainConfigSL_r16 = -1;   /* MAC_MainConfigSL_r16 */
static int hf_nr_rrc_sl_CS_RNTI_r16 = -1;         /* RNTI_Value */
static int hf_nr_rrc_sl_PSFCH_ToPUCCH_r16 = -1;   /* T_sl_PSFCH_ToPUCCH_r16 */
static int hf_nr_rrc_sl_PSFCH_ToPUCCH_r16_item = -1;  /* INTEGER_0_15 */
static int hf_nr_rrc_sl_ConfiguredGrantConfigList_r16 = -1;  /* SL_ConfiguredGrantConfigList_r16 */
static int hf_nr_rrc_sl_DCI_ToSL_Trans_r16 = -1;  /* T_sl_DCI_ToSL_Trans_r16 */
static int hf_nr_rrc_sl_DCI_ToSL_Trans_r16_item = -1;  /* INTEGER_1_32 */
static int hf_nr_rrc_sl_BSR_Config_r16 = -1;      /* BSR_Config */
static int hf_nr_rrc_ul_PrioritizationThres_r16 = -1;  /* INTEGER_1_16 */
static int hf_nr_rrc_sl_PrioritizationThres_r16 = -1;  /* INTEGER_1_8 */
static int hf_nr_rrc_sl_ConfiguredGrantConfigToReleaseList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofCG_SL_r16_OF_SL_ConfigIndexCG_r16 */
static int hf_nr_rrc_sl_ConfiguredGrantConfigToReleaseList_r16_item = -1;  /* SL_ConfigIndexCG_r16 */
static int hf_nr_rrc_sl_ConfiguredGrantConfigToAddModList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofCG_SL_r16_OF_SL_ConfiguredGrantConfig_r16 */
static int hf_nr_rrc_sl_ConfiguredGrantConfigToAddModList_r16_item = -1;  /* SL_ConfiguredGrantConfig_r16 */
static int hf_nr_rrc_sl_SDAP_Header_r16 = -1;     /* T_sl_SDAP_Header_r16 */
static int hf_nr_rrc_sl_DefaultRB_r16 = -1;       /* BOOLEAN */
static int hf_nr_rrc_sl_MappedQoS_Flows_r16 = -1;  /* T_sl_MappedQoS_Flows_r16 */
static int hf_nr_rrc_sl_MappedQoS_FlowsList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofSL_QFIs_r16_OF_SL_QoS_Profile_r16 */
static int hf_nr_rrc_sl_MappedQoS_FlowsList_r16_item = -1;  /* SL_QoS_Profile_r16 */
static int hf_nr_rrc_sl_MappedQoS_FlowsListDedicated_r16 = -1;  /* SL_MappedQoS_FlowsListDedicated_r16 */
static int hf_nr_rrc_sl_CastType_r16_01 = -1;     /* T_sl_CastType_r16_01 */
static int hf_nr_rrc_sl_MappedQoS_FlowsToAddList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofSL_QFIs_r16_OF_SL_QoS_FlowIdentity_r16 */
static int hf_nr_rrc_sl_MappedQoS_FlowsToAddList_r16_item = -1;  /* SL_QoS_FlowIdentity_r16 */
static int hf_nr_rrc_sl_MappedQoS_FlowsToReleaseList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofSL_QFIs_r16_OF_SL_QoS_FlowIdentity_r16 */
static int hf_nr_rrc_sl_MappedQoS_FlowsToReleaseList_r16_item = -1;  /* SL_QoS_FlowIdentity_r16 */
static int hf_nr_rrc_SL_SyncConfigList_r16_item = -1;  /* SL_SyncConfig_r16 */
static int hf_nr_rrc_sl_SyncRefMinHyst_r16 = -1;  /* T_sl_SyncRefMinHyst_r16 */
static int hf_nr_rrc_sl_SyncRefDiffHyst_r16 = -1;  /* T_sl_SyncRefDiffHyst_r16 */
static int hf_nr_rrc_sl_filterCoefficient_r16 = -1;  /* FilterCoefficient */
static int hf_nr_rrc_sl_SSB_TimeAllocation1_r16 = -1;  /* SL_SSB_TimeAllocation_r16 */
static int hf_nr_rrc_sl_SSB_TimeAllocation2_r16 = -1;  /* SL_SSB_TimeAllocation_r16 */
static int hf_nr_rrc_sl_SSB_TimeAllocation3_r16 = -1;  /* SL_SSB_TimeAllocation_r16 */
static int hf_nr_rrc_sl_SSID_r16 = -1;            /* INTEGER_0_671 */
static int hf_nr_rrc_txParameters_r16 = -1;       /* T_txParameters_r16 */
static int hf_nr_rrc_syncTxThreshIC_r16 = -1;     /* SL_RSRP_Range_r16 */
static int hf_nr_rrc_syncTxThreshOoC_r16 = -1;    /* SL_RSRP_Range_r16 */
static int hf_nr_rrc_syncInfoReserved_r16 = -1;   /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_gnss_Sync_r16_01 = -1;       /* T_gnss_Sync_r16_01 */
static int hf_nr_rrc_sl_NumSSB_WithinPeriod_r16 = -1;  /* T_sl_NumSSB_WithinPeriod_r16 */
static int hf_nr_rrc_sl_TimeOffsetSSB_r16 = -1;   /* INTEGER_0_1279 */
static int hf_nr_rrc_sl_TimeInterval_r16 = -1;    /* INTEGER_0_639 */
static int hf_nr_rrc_SL_Thres_RSRP_List_r16_item = -1;  /* SL_Thres_RSRP_r16 */
static int hf_nr_rrc_minusinfinity_r16 = -1;      /* NULL */
static int hf_nr_rrc_txPower_r16 = -1;            /* INTEGER_M30_33 */
static int hf_nr_rrc_sl_PSSCH_TxConfigList_r16 = -1;  /* SL_PSSCH_TxConfigList_r16 */
static int hf_nr_rrc_sl_ProbResourceKeep_r16 = -1;  /* T_sl_ProbResourceKeep_r16 */
static int hf_nr_rrc_sl_ReselectAfter_r16 = -1;   /* T_sl_ReselectAfter_r16 */
static int hf_nr_rrc_sl_CBR_CommonTxConfigList_r16 = -1;  /* SL_CBR_CommonTxConfigList_r16 */
static int hf_nr_rrc_sl_ZoneLength_r16 = -1;      /* T_sl_ZoneLength_r16 */
static int hf_nr_rrc_message_08 = -1;             /* SBCCH_SL_BCH_MessageType */
static int hf_nr_rrc_c1_17 = -1;                  /* T_c1_17 */
static int hf_nr_rrc_masterInformationBlockSidelink = -1;  /* MasterInformationBlockSidelink */
static int hf_nr_rrc_messageClassExtension_08 = -1;  /* T_messageClassExtension_08 */
static int hf_nr_rrc_message_09 = -1;             /* SCCH_MessageType */
static int hf_nr_rrc_c1_18 = -1;                  /* T_c1_18 */
static int hf_nr_rrc_measurementReportSidelink = -1;  /* MeasurementReportSidelink */
static int hf_nr_rrc_rrcReconfigurationSidelink = -1;  /* RRCReconfigurationSidelink */
static int hf_nr_rrc_rrcReconfigurationCompleteSidelink = -1;  /* RRCReconfigurationCompleteSidelink */
static int hf_nr_rrc_rrcReconfigurationFailureSidelink = -1;  /* RRCReconfigurationFailureSidelink */
static int hf_nr_rrc_ueCapabilityEnquirySidelink = -1;  /* UECapabilityEnquirySidelink */
static int hf_nr_rrc_ueCapabilityInformationSidelink = -1;  /* UECapabilityInformationSidelink */
static int hf_nr_rrc_messageClassExtension_09 = -1;  /* T_messageClassExtension_09 */
static int hf_nr_rrc_sl_TDD_Config_r16 = -1;      /* BIT_STRING_SIZE_12 */
static int hf_nr_rrc_inCoverage_r16 = -1;         /* BOOLEAN */
static int hf_nr_rrc_directFrameNumber_r16 = -1;  /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_masterInformationBlockSidelink_slotIndex_r16 = -1;  /* BIT_STRING_SIZE_7 */
static int hf_nr_rrc_reservedBits_r16 = -1;       /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_criticalExtensions_47 = -1;  /* T_criticalExtensions_47 */
static int hf_nr_rrc_measurementReportSidelink_r16 = -1;  /* MeasurementReportSidelink_IEs_r16 */
static int hf_nr_rrc_criticalExtensionsFuture_47 = -1;  /* T_criticalExtensionsFuture_47 */
static int hf_nr_rrc_sl_measResults_r16 = -1;     /* SL_MeasResults_r16 */
static int hf_nr_rrc_nonCriticalExtension_110 = -1;  /* T_nonCriticalExtension_54 */
static int hf_nr_rrc_sl_MeasResult_r16 = -1;      /* SL_MeasResult_r16 */
static int hf_nr_rrc_sl_ResultDMRS_r16 = -1;      /* SL_MeasQuantityResult_r16 */
static int hf_nr_rrc_rrc_TransactionIdentifier_r16 = -1;  /* RRC_TransactionIdentifier */
static int hf_nr_rrc_criticalExtensions_48 = -1;  /* T_criticalExtensions_48 */
static int hf_nr_rrc_rrcReconfigurationSidelink_r16 = -1;  /* RRCReconfigurationSidelink_IEs_r16 */
static int hf_nr_rrc_criticalExtensionsFuture_48 = -1;  /* T_criticalExtensionsFuture_48 */
static int hf_nr_rrc_slrb_ConfigToAddModList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofSLRB_r16_OF_SLRB_Config_r16 */
static int hf_nr_rrc_slrb_ConfigToAddModList_r16_item = -1;  /* SLRB_Config_r16 */
static int hf_nr_rrc_slrb_ConfigToReleaseList_r16 = -1;  /* SEQUENCE_SIZE_1_maxNrofSLRB_r16_OF_SLRB_PC5_ConfigIndex_r16 */
static int hf_nr_rrc_slrb_ConfigToReleaseList_r16_item = -1;  /* SLRB_PC5_ConfigIndex_r16 */
static int hf_nr_rrc_sl_MeasConfig_r16_01 = -1;   /* T_sl_MeasConfig_r16 */
static int hf_nr_rrc_setup_129 = -1;              /* SL_MeasConfig_r16 */
static int hf_nr_rrc_sl_CSI_RS_Config_r16 = -1;   /* T_sl_CSI_RS_Config_r16 */
static int hf_nr_rrc_setup_130 = -1;              /* SL_CSI_RS_Config_r16 */
static int hf_nr_rrc_sl_ResetConfig_r16 = -1;     /* T_sl_ResetConfig_r16 */
static int hf_nr_rrc_sl_LatencyBoundCSI_Report_r16 = -1;  /* INTEGER_3_160 */
static int hf_nr_rrc_nonCriticalExtension_111 = -1;  /* T_nonCriticalExtension_55 */
static int hf_nr_rrc_slrb_PC5_ConfigIndex_r16 = -1;  /* SLRB_PC5_ConfigIndex_r16 */
static int hf_nr_rrc_sl_SDAP_ConfigPC5_r16 = -1;  /* SL_SDAP_ConfigPC5_r16 */
static int hf_nr_rrc_sl_PDCP_ConfigPC5_r16 = -1;  /* SL_PDCP_ConfigPC5_r16 */
static int hf_nr_rrc_sl_RLC_ConfigPC5_r16 = -1;   /* SL_RLC_ConfigPC5_r16 */
static int hf_nr_rrc_sl_MAC_LogicalChannelConfigPC5_r16 = -1;  /* SL_LogicalChannelConfigPC5_r16 */
static int hf_nr_rrc_sl_MappedQoS_FlowsToAddList_r16_01 = -1;  /* SEQUENCE_SIZE_1_maxNrofSL_QFIsPerDest_r16_OF_SL_PQFI_r16 */
static int hf_nr_rrc_sl_MappedQoS_FlowsToAddList_r16_item_01 = -1;  /* SL_PQFI_r16 */
static int hf_nr_rrc_sl_MappedQoS_FlowsToReleaseList_r16_01 = -1;  /* SEQUENCE_SIZE_1_maxNrofSL_QFIsPerDest_r16_OF_SL_PQFI_r16 */
static int hf_nr_rrc_sl_MappedQoS_FlowsToReleaseList_r16_item_01 = -1;  /* SL_PQFI_r16 */
static int hf_nr_rrc_sl_SDAP_Header_r16_01 = -1;  /* T_sl_SDAP_Header_r16_01 */
static int hf_nr_rrc_sl_PDCP_SN_Size_r16_01 = -1;  /* T_sl_PDCP_SN_Size_r16_01 */
static int hf_nr_rrc_sl_OutOfOrderDelivery_r16 = -1;  /* T_sl_OutOfOrderDelivery_r16 */
static int hf_nr_rrc_sl_AM_RLC_r16_01 = -1;       /* T_sl_AM_RLC_r16_01 */
static int hf_nr_rrc_sl_UM_Bi_Directional_RLC_r16 = -1;  /* T_sl_UM_Bi_Directional_RLC_r16 */
static int hf_nr_rrc_sl_UM_Uni_Directional_RLC_r16 = -1;  /* T_sl_UM_Uni_Directional_RLC_r16 */
static int hf_nr_rrc_sl_LogicalChannelIdentity_r16 = -1;  /* LogicalChannelIdentity */
static int hf_nr_rrc_sl_CSI_RS_FreqAllocation_r16 = -1;  /* T_sl_CSI_RS_FreqAllocation_r16 */
static int hf_nr_rrc_sl_OneAntennaPort_r16 = -1;  /* BIT_STRING_SIZE_12 */
static int hf_nr_rrc_sl_TwoAntennaPort_r16 = -1;  /* BIT_STRING_SIZE_6 */
static int hf_nr_rrc_sl_CSI_RS_FirstSymbol_r16 = -1;  /* INTEGER_3_12 */
static int hf_nr_rrc_criticalExtensions_49 = -1;  /* T_criticalExtensions_49 */
static int hf_nr_rrc_rrcReconfigurationCompleteSidelink_r16 = -1;  /* RRCReconfigurationCompleteSidelink_IEs_r16 */
static int hf_nr_rrc_criticalExtensionsFuture_49 = -1;  /* T_criticalExtensionsFuture_49 */
static int hf_nr_rrc_nonCriticalExtension_112 = -1;  /* T_nonCriticalExtension_56 */
static int hf_nr_rrc_criticalExtensions_50 = -1;  /* T_criticalExtensions_50 */
static int hf_nr_rrc_rrcReconfigurationFailureSidelink_r16 = -1;  /* RRCReconfigurationFailureSidelink_IEs_r16 */
static int hf_nr_rrc_criticalExtensionsFuture_50 = -1;  /* T_criticalExtensionsFuture_50 */
static int hf_nr_rrc_nonCriticalExtension_113 = -1;  /* T_nonCriticalExtension_57 */
static int hf_nr_rrc_criticalExtensions_51 = -1;  /* T_criticalExtensions_51 */
static int hf_nr_rrc_ueCapabilityEnquirySidelink_r16 = -1;  /* UECapabilityEnquirySidelink_IEs_r16 */
static int hf_nr_rrc_criticalExtensionsFuture_51 = -1;  /* T_criticalExtensionsFuture_51 */
static int hf_nr_rrc_frequencyBandListFilterSidelink_r16 = -1;  /* FreqBandList */
static int hf_nr_rrc_ue_CapabilityInformationSidelink_r16 = -1;  /* OCTET_STRING */
static int hf_nr_rrc_nonCriticalExtension_114 = -1;  /* T_nonCriticalExtension_58 */
static int hf_nr_rrc_criticalExtensions_52 = -1;  /* T_criticalExtensions_52 */
static int hf_nr_rrc_ueCapabilityInformationSidelink_r16 = -1;  /* UECapabilityInformationSidelink_IEs_r16 */
static int hf_nr_rrc_criticalExtensionsFuture_52 = -1;  /* T_criticalExtensionsFuture_52 */
static int hf_nr_rrc_accessStratumReleaseSidelink_r16 = -1;  /* AccessStratumReleaseSidelink_r16 */
static int hf_nr_rrc_pdcp_ParametersSidelink_r16 = -1;  /* PDCP_ParametersSidelink_r16 */
static int hf_nr_rrc_supportedBandCombinationListSidelinkNR_r16 = -1;  /* BandCombinationListSidelinkNR_r16 */
static int hf_nr_rrc_supportedBandListSidelink_r16_01 = -1;  /* SEQUENCE_SIZE_1_maxBands_OF_BandSidelinkPC5_r16 */
static int hf_nr_rrc_supportedBandListSidelink_r16_item_01 = -1;  /* BandSidelinkPC5_r16 */
static int hf_nr_rrc_appliedFreqBandListFilter_r16 = -1;  /* FreqBandList */
static int hf_nr_rrc_nonCriticalExtension_115 = -1;  /* T_nonCriticalExtension_59 */
static int hf_nr_rrc_outOfOrderDeliverySidelink_r16 = -1;  /* T_outOfOrderDeliverySidelink_r16 */
static int hf_nr_rrc_BandCombinationListSidelinkNR_r16_item = -1;  /* BandCombinationParametersSidelinkNR_r16 */
static int hf_nr_rrc_BandCombinationParametersSidelinkNR_r16_item = -1;  /* BandParametersSidelink_r16 */
static int hf_nr_rrc_sl_Reception_r16_01 = -1;    /* T_sl_Reception_r16_01 */
static int hf_nr_rrc_harq_RxProcessSidelink_r16_01 = -1;  /* T_harq_RxProcessSidelink_r16_01 */
static int hf_nr_rrc_pscch_RxSidelink_r16_01 = -1;  /* T_pscch_RxSidelink_r16_01 */
static int hf_nr_rrc_scs_CP_PatternRxSidelink_r16_01 = -1;  /* T_scs_CP_PatternRxSidelink_r16_01 */
static int hf_nr_rrc_fr1_r16_02 = -1;             /* T_fr1_r16_02 */
static int hf_nr_rrc_bandSidelinkPC5_r16_sl_Reception_r16_scs_CP_PatternRxSidelink_r16_fr1_r16_scs_15kHz_r16 = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_bandSidelinkPC5_r16_sl_Reception_r16_scs_CP_PatternRxSidelink_r16_fr1_r16_scs_30kHz_r16 = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_bandSidelinkPC5_r16_sl_Reception_r16_scs_CP_PatternRxSidelink_r16_fr1_r16_scs_60kHz_r16 = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_fr2_r16_03 = -1;             /* T_fr2_r16_03 */
static int hf_nr_rrc_bandSidelinkPC5_r16_sl_Reception_r16_scs_CP_PatternRxSidelink_r16_fr2_r16_scs_60kHz_r16 = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_bandSidelinkPC5_r16_sl_Reception_r16_scs_CP_PatternRxSidelink_r16_fr2_r16_scs_120kHz_r16 = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_extendedCP_RxSidelink_r16_01 = -1;  /* T_extendedCP_RxSidelink_r16_01 */
static int hf_nr_rrc_sl_Tx_256QAM_r16_01 = -1;    /* T_sl_Tx_256QAM_r16_01 */
static int hf_nr_rrc_lowSE_64QAM_MCS_TableSidelink_r16_01 = -1;  /* T_lowSE_64QAM_MCS_TableSidelink_r16_01 */
static int hf_nr_rrc_csi_ReportSidelink_r16 = -1;  /* T_csi_ReportSidelink_r16 */
static int hf_nr_rrc_csi_RS_PortsSidelink_r16 = -1;  /* T_csi_RS_PortsSidelink_r16 */
static int hf_nr_rrc_rankTwoReception_r16 = -1;   /* T_rankTwoReception_r16 */
static int hf_nr_rrc_sl_openLoopPC_RSRP_ReportSidelink_r16_01 = -1;  /* T_sl_openLoopPC_RSRP_ReportSidelink_r16_01 */
static int hf_nr_rrc_sl_Rx_256QAM_r16_01 = -1;    /* T_sl_Rx_256QAM_r16_01 */
static int dummy_hf_nr_rrc_eag_field = -1; /* never registered */

/*--- End of included file: packet-nr-rrc-hf.c ---*/
#line 71 "./asn1/nr-rrc/packet-nr-rrc-template.c"
static int hf_nr_rrc_serialNumber_gs = -1;
static int hf_nr_rrc_serialNumber_msg_code = -1;
static int hf_nr_rrc_serialNumber_upd_nb = -1;
static int hf_nr_rrc_warningType_value = -1;
static int hf_nr_rrc_warningType_emergency_user_alert = -1;
static int hf_nr_rrc_warningType_popup = -1;
static int hf_nr_rrc_warningMessageSegment_nb_pages = -1;
static int hf_nr_rrc_warningMessageSegment_decoded_page = -1;
static int hf_nr_rrc_sib7_fragments = -1;
static int hf_nr_rrc_sib7_fragment = -1;
static int hf_nr_rrc_sib7_fragment_overlap = -1;
static int hf_nr_rrc_sib7_fragment_overlap_conflict = -1;
static int hf_nr_rrc_sib7_fragment_multiple_tails = -1;
static int hf_nr_rrc_sib7_fragment_too_long_fragment = -1;
static int hf_nr_rrc_sib7_fragment_error = -1;
static int hf_nr_rrc_sib7_fragment_count = -1;
static int hf_nr_rrc_sib7_reassembled_in = -1;
static int hf_nr_rrc_sib7_reassembled_length = -1;
static int hf_nr_rrc_sib7_reassembled_data = -1;
static int hf_nr_rrc_sib8_fragments = -1;
static int hf_nr_rrc_sib8_fragment = -1;
static int hf_nr_rrc_sib8_fragment_overlap = -1;
static int hf_nr_rrc_sib8_fragment_overlap_conflict = -1;
static int hf_nr_rrc_sib8_fragment_multiple_tails = -1;
static int hf_nr_rrc_sib8_fragment_too_long_fragment = -1;
static int hf_nr_rrc_sib8_fragment_error = -1;
static int hf_nr_rrc_sib8_fragment_count = -1;
static int hf_nr_rrc_sib8_reassembled_in = -1;
static int hf_nr_rrc_sib8_reassembled_length = -1;
static int hf_nr_rrc_sib8_reassembled_data = -1;
static int hf_nr_rrc_utc_time = -1;
static int hf_nr_rrc_local_time = -1;
static int hf_nr_rrc_absolute_time = -1;

/* Initialize the subtree pointers */
static gint ett_nr_rrc = -1;

/*--- Included file: packet-nr-rrc-ett.c ---*/
#line 1 "./asn1/nr-rrc/packet-nr-rrc-ett.c"
static gint ett_nr_rrc_HandoverCommand = -1;
static gint ett_nr_rrc_T_criticalExtensions = -1;
static gint ett_nr_rrc_T_c1 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture = -1;
static gint ett_nr_rrc_HandoverCommand_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension = -1;
static gint ett_nr_rrc_HandoverPreparationInformation = -1;
static gint ett_nr_rrc_T_criticalExtensions_01 = -1;
static gint ett_nr_rrc_T_c1_01 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_01 = -1;
static gint ett_nr_rrc_HandoverPreparationInformation_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_01 = -1;
static gint ett_nr_rrc_AS_Config = -1;
static gint ett_nr_rrc_AS_Context = -1;
static gint ett_nr_rrc_ConfigRestrictInfoDAPS_r16 = -1;
static gint ett_nr_rrc_T_powerCoordination_r16 = -1;
static gint ett_nr_rrc_ConfigRestrictInfoDAPS_v1640 = -1;
static gint ett_nr_rrc_ReestablishmentInfo = -1;
static gint ett_nr_rrc_ReestabNCellInfoList = -1;
static gint ett_nr_rrc_ReestabNCellInfo = -1;
static gint ett_nr_rrc_RRM_Config = -1;
static gint ett_nr_rrc_CG_Config = -1;
static gint ett_nr_rrc_T_criticalExtensions_02 = -1;
static gint ett_nr_rrc_T_c1_02 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_02 = -1;
static gint ett_nr_rrc_CG_Config_IEs = -1;
static gint ett_nr_rrc_CG_Config_v1540_IEs = -1;
static gint ett_nr_rrc_T_reportCGI_RequestNR = -1;
static gint ett_nr_rrc_T_requestedCellInfo = -1;
static gint ett_nr_rrc_CG_Config_v1560_IEs = -1;
static gint ett_nr_rrc_T_reportCGI_RequestEUTRA = -1;
static gint ett_nr_rrc_T_requestedCellInfoEUTRA = -1;
static gint ett_nr_rrc_CG_Config_v1590_IEs = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofServingCells_1_OF_ARFCN_ValueNR = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofServingCells_1_OF_ARFCN_ValueEUTRA = -1;
static gint ett_nr_rrc_CG_Config_v1610_IEs = -1;
static gint ett_nr_rrc_CG_Config_v1620_IEs = -1;
static gint ett_nr_rrc_CG_Config_v1630_IEs = -1;
static gint ett_nr_rrc_CG_Config_v1640_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_02 = -1;
static gint ett_nr_rrc_ServCellInfoListSCG_NR_r16 = -1;
static gint ett_nr_rrc_ServCellInfoXCG_NR_r16 = -1;
static gint ett_nr_rrc_FrequencyConfig_NR_r16 = -1;
static gint ett_nr_rrc_ServCellInfoListSCG_EUTRA_r16 = -1;
static gint ett_nr_rrc_ServCellInfoXCG_EUTRA_r16 = -1;
static gint ett_nr_rrc_PH_TypeListSCG = -1;
static gint ett_nr_rrc_PH_InfoSCG = -1;
static gint ett_nr_rrc_PH_UplinkCarrierSCG = -1;
static gint ett_nr_rrc_MeasConfigSN = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxMeasFreqsSN_OF_NR_FreqInfo = -1;
static gint ett_nr_rrc_NR_FreqInfo = -1;
static gint ett_nr_rrc_ConfigRestrictModReqSCG = -1;
static gint ett_nr_rrc_BandCombinationInfoSN = -1;
static gint ett_nr_rrc_FR_InfoList = -1;
static gint ett_nr_rrc_FR_Info = -1;
static gint ett_nr_rrc_CandidateServingFreqListNR = -1;
static gint ett_nr_rrc_CandidateServingFreqListEUTRA = -1;
static gint ett_nr_rrc_CG_ConfigInfo = -1;
static gint ett_nr_rrc_T_criticalExtensions_03 = -1;
static gint ett_nr_rrc_T_c1_03 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_03 = -1;
static gint ett_nr_rrc_CG_ConfigInfo_IEs = -1;
static gint ett_nr_rrc_T_scgFailureInfo = -1;
static gint ett_nr_rrc_CG_ConfigInfo_v1540_IEs = -1;
static gint ett_nr_rrc_T_measResultReportCGI = -1;
static gint ett_nr_rrc_CG_ConfigInfo_v1560_IEs = -1;
static gint ett_nr_rrc_T_scgFailureInfoEUTRA = -1;
static gint ett_nr_rrc_T_measResultReportCGI_EUTRA = -1;
static gint ett_nr_rrc_CG_ConfigInfo_v1570_IEs = -1;
static gint ett_nr_rrc_CG_ConfigInfo_v1590_IEs = -1;
static gint ett_nr_rrc_CG_ConfigInfo_v1610_IEs = -1;
static gint ett_nr_rrc_T_scgFailureInfo_r16 = -1;
static gint ett_nr_rrc_T_dummy1 = -1;
static gint ett_nr_rrc_CG_ConfigInfo_v1620_IEs = -1;
static gint ett_nr_rrc_CG_ConfigInfo_v1640_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_03 = -1;
static gint ett_nr_rrc_ServCellInfoListMCG_NR_r16 = -1;
static gint ett_nr_rrc_ServCellInfoListMCG_EUTRA_r16 = -1;
static gint ett_nr_rrc_SFTD_FrequencyList_NR = -1;
static gint ett_nr_rrc_SFTD_FrequencyList_EUTRA = -1;
static gint ett_nr_rrc_ConfigRestrictInfoSCG = -1;
static gint ett_nr_rrc_T_powerCoordination_FR1 = -1;
static gint ett_nr_rrc_T_servCellIndexRangeSCG = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxBandComb_OF_SelectedBandEntriesMN = -1;
static gint ett_nr_rrc_T_powerCoordination_FR2_r16 = -1;
static gint ett_nr_rrc_SelectedBandEntriesMN = -1;
static gint ett_nr_rrc_PH_TypeListMCG = -1;
static gint ett_nr_rrc_PH_InfoMCG = -1;
static gint ett_nr_rrc_PH_UplinkCarrierMCG = -1;
static gint ett_nr_rrc_BandCombinationInfoList = -1;
static gint ett_nr_rrc_BandCombinationInfo = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxFeatureSetsPerBand_OF_FeatureSetEntryIndex = -1;
static gint ett_nr_rrc_DRX_Info = -1;
static gint ett_nr_rrc_T_drx_LongCycleStartOffset = -1;
static gint ett_nr_rrc_T_shortDRX = -1;
static gint ett_nr_rrc_DRX_Info2 = -1;
static gint ett_nr_rrc_T_drx_onDurationTimer = -1;
static gint ett_nr_rrc_MeasConfigMN = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxMeasFreqsMN_OF_NR_FreqInfo = -1;
static gint ett_nr_rrc_T_measGapConfig = -1;
static gint ett_nr_rrc_T_measGapConfigFR2 = -1;
static gint ett_nr_rrc_MRDC_AssistanceInfo = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCombIDC_OF_AffectedCarrierFreqCombInfoMRDC = -1;
static gint ett_nr_rrc_AffectedCarrierFreqCombInfoMRDC = -1;
static gint ett_nr_rrc_T_affectedCarrierFreqCombMRDC = -1;
static gint ett_nr_rrc_VictimSystemType = -1;
static gint ett_nr_rrc_AffectedCarrierFreqCombEUTRA = -1;
static gint ett_nr_rrc_AffectedCarrierFreqCombNR = -1;
static gint ett_nr_rrc_MeasurementTimingConfiguration = -1;
static gint ett_nr_rrc_T_criticalExtensions_04 = -1;
static gint ett_nr_rrc_T_c1_04 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_04 = -1;
static gint ett_nr_rrc_MeasurementTimingConfiguration_IEs = -1;
static gint ett_nr_rrc_MeasurementTimingConfiguration_v1550_IEs = -1;
static gint ett_nr_rrc_MeasurementTimingConfiguration_v1610_IEs = -1;
static gint ett_nr_rrc_T_csi_RS_Config_r16 = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_04 = -1;
static gint ett_nr_rrc_MeasTimingList = -1;
static gint ett_nr_rrc_MeasTiming = -1;
static gint ett_nr_rrc_T_frequencyAndTiming = -1;
static gint ett_nr_rrc_UERadioPagingInformation = -1;
static gint ett_nr_rrc_T_criticalExtensions_05 = -1;
static gint ett_nr_rrc_T_c1_05 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_05 = -1;
static gint ett_nr_rrc_UERadioPagingInformation_IEs = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicatorNR = -1;
static gint ett_nr_rrc_UERadioPagingInformation_v15e0_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_05 = -1;
static gint ett_nr_rrc_UERadioAccessCapabilityInformation = -1;
static gint ett_nr_rrc_T_criticalExtensions_06 = -1;
static gint ett_nr_rrc_T_c1_06 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_06 = -1;
static gint ett_nr_rrc_UERadioAccessCapabilityInformation_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_06 = -1;
static gint ett_nr_rrc_BCCH_BCH_Message = -1;
static gint ett_nr_rrc_BCCH_BCH_MessageType = -1;
static gint ett_nr_rrc_T_messageClassExtension = -1;
static gint ett_nr_rrc_BCCH_DL_SCH_Message = -1;
static gint ett_nr_rrc_BCCH_DL_SCH_MessageType = -1;
static gint ett_nr_rrc_T_c1_07 = -1;
static gint ett_nr_rrc_T_messageClassExtension_01 = -1;
static gint ett_nr_rrc_DL_CCCH_Message = -1;
static gint ett_nr_rrc_DL_CCCH_MessageType = -1;
static gint ett_nr_rrc_T_c1_08 = -1;
static gint ett_nr_rrc_T_messageClassExtension_02 = -1;
static gint ett_nr_rrc_DL_DCCH_Message = -1;
static gint ett_nr_rrc_DL_DCCH_MessageType = -1;
static gint ett_nr_rrc_T_c1_09 = -1;
static gint ett_nr_rrc_T_messageClassExtension_03 = -1;
static gint ett_nr_rrc_PCCH_Message = -1;
static gint ett_nr_rrc_PCCH_MessageType = -1;
static gint ett_nr_rrc_T_c1_10 = -1;
static gint ett_nr_rrc_T_messageClassExtension_04 = -1;
static gint ett_nr_rrc_UL_CCCH_Message = -1;
static gint ett_nr_rrc_UL_CCCH_MessageType = -1;
static gint ett_nr_rrc_T_c1_11 = -1;
static gint ett_nr_rrc_T_messageClassExtension_05 = -1;
static gint ett_nr_rrc_UL_CCCH1_Message = -1;
static gint ett_nr_rrc_UL_CCCH1_MessageType = -1;
static gint ett_nr_rrc_T_c1_12 = -1;
static gint ett_nr_rrc_T_messageClassExtension_06 = -1;
static gint ett_nr_rrc_UL_DCCH_Message = -1;
static gint ett_nr_rrc_UL_DCCH_MessageType = -1;
static gint ett_nr_rrc_T_c1_13 = -1;
static gint ett_nr_rrc_T_messageClassExtension_07 = -1;
static gint ett_nr_rrc_T_c2 = -1;
static gint ett_nr_rrc_T_messageClassExtensionFuture_r16 = -1;
static gint ett_nr_rrc_CounterCheck = -1;
static gint ett_nr_rrc_T_criticalExtensions_07 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_07 = -1;
static gint ett_nr_rrc_CounterCheck_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_07 = -1;
static gint ett_nr_rrc_DRB_CountMSB_InfoList = -1;
static gint ett_nr_rrc_DRB_CountMSB_Info = -1;
static gint ett_nr_rrc_CounterCheckResponse = -1;
static gint ett_nr_rrc_T_criticalExtensions_08 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_08 = -1;
static gint ett_nr_rrc_CounterCheckResponse_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_08 = -1;
static gint ett_nr_rrc_DRB_CountInfoList = -1;
static gint ett_nr_rrc_DRB_CountInfo = -1;
static gint ett_nr_rrc_DedicatedSIBRequest_r16 = -1;
static gint ett_nr_rrc_T_criticalExtensions_09 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_09 = -1;
static gint ett_nr_rrc_DedicatedSIBRequest_r16_IEs = -1;
static gint ett_nr_rrc_T_onDemandSIB_RequestList_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxOnDemandSIB_r16_OF_SIB_ReqInfo_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxOnDemandPosSIB_r16_OF_PosSIB_ReqInfo_r16 = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_09 = -1;
static gint ett_nr_rrc_PosSIB_ReqInfo_r16 = -1;
static gint ett_nr_rrc_DLDedicatedMessageSegment_r16 = -1;
static gint ett_nr_rrc_T_criticalExtensions_10 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_10 = -1;
static gint ett_nr_rrc_DLDedicatedMessageSegment_r16_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_10 = -1;
static gint ett_nr_rrc_DLInformationTransfer = -1;
static gint ett_nr_rrc_T_criticalExtensions_11 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_11 = -1;
static gint ett_nr_rrc_DLInformationTransfer_IEs = -1;
static gint ett_nr_rrc_DLInformationTransfer_v1610_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_11 = -1;
static gint ett_nr_rrc_DLInformationTransferMRDC_r16 = -1;
static gint ett_nr_rrc_T_criticalExtensions_12 = -1;
static gint ett_nr_rrc_T_c1_14 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_12 = -1;
static gint ett_nr_rrc_DLInformationTransferMRDC_r16_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_12 = -1;
static gint ett_nr_rrc_FailureInformation = -1;
static gint ett_nr_rrc_T_criticalExtensions_13 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_13 = -1;
static gint ett_nr_rrc_FailureInformation_IEs = -1;
static gint ett_nr_rrc_FailureInfoRLC_Bearer = -1;
static gint ett_nr_rrc_FailureInformation_v1610_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_13 = -1;
static gint ett_nr_rrc_FailureInfoDAPS_r16 = -1;
static gint ett_nr_rrc_IABOtherInformation_r16 = -1;
static gint ett_nr_rrc_T_criticalExtensions_14 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_14 = -1;
static gint ett_nr_rrc_IABOtherInformation_r16_IEs = -1;
static gint ett_nr_rrc_T_ip_InfoType_r16 = -1;
static gint ett_nr_rrc_T_iab_IP_Request_r16 = -1;
static gint ett_nr_rrc_T_iab_IPv6_AddressReq_r16 = -1;
static gint ett_nr_rrc_T_iab_IP_Report_r16 = -1;
static gint ett_nr_rrc_T_iab_IPv6_Report_r16 = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_14 = -1;
static gint ett_nr_rrc_IAB_IP_AddressNumReq_r16 = -1;
static gint ett_nr_rrc_IAB_IP_AddressPrefixReq_r16 = -1;
static gint ett_nr_rrc_IAB_IP_AddressAndTraffic_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_8_OF_IAB_IP_Address_r16 = -1;
static gint ett_nr_rrc_IAB_IP_PrefixAndTraffic_r16 = -1;
static gint ett_nr_rrc_LocationMeasurementIndication = -1;
static gint ett_nr_rrc_T_criticalExtensions_15 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_15 = -1;
static gint ett_nr_rrc_LocationMeasurementIndication_IEs = -1;
static gint ett_nr_rrc_T_measurementIndication = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_15 = -1;
static gint ett_nr_rrc_LoggedMeasurementConfiguration_r16 = -1;
static gint ett_nr_rrc_T_criticalExtensions_16 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_16 = -1;
static gint ett_nr_rrc_LoggedMeasurementConfiguration_r16_IEs = -1;
static gint ett_nr_rrc_T_bt_NameList_r16 = -1;
static gint ett_nr_rrc_T_wlan_NameList_r16 = -1;
static gint ett_nr_rrc_T_sensor_NameList_r16 = -1;
static gint ett_nr_rrc_T_reportType = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_16 = -1;
static gint ett_nr_rrc_LoggedPeriodicalReportConfig_r16 = -1;
static gint ett_nr_rrc_LoggedEventTriggerConfig_r16 = -1;
static gint ett_nr_rrc_EventType_r16 = -1;
static gint ett_nr_rrc_T_eventL1 = -1;
static gint ett_nr_rrc_MCGFailureInformation_r16 = -1;
static gint ett_nr_rrc_T_criticalExtensions_17 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_17 = -1;
static gint ett_nr_rrc_MCGFailureInformation_r16_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_17 = -1;
static gint ett_nr_rrc_FailureReportMCG_r16 = -1;
static gint ett_nr_rrc_MeasResultList2UTRA = -1;
static gint ett_nr_rrc_MeasResult2UTRA_FDD_r16 = -1;
static gint ett_nr_rrc_MeasResultList2EUTRA = -1;
static gint ett_nr_rrc_MeasurementReport = -1;
static gint ett_nr_rrc_T_criticalExtensions_18 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_18 = -1;
static gint ett_nr_rrc_MeasurementReport_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_18 = -1;
static gint ett_nr_rrc_MIB = -1;
static gint ett_nr_rrc_MobilityFromNRCommand = -1;
static gint ett_nr_rrc_T_criticalExtensions_19 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_19 = -1;
static gint ett_nr_rrc_MobilityFromNRCommand_IEs = -1;
static gint ett_nr_rrc_MobilityFromNRCommand_v1610_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_19 = -1;
static gint ett_nr_rrc_Paging = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_20 = -1;
static gint ett_nr_rrc_PagingRecordList = -1;
static gint ett_nr_rrc_PagingRecord = -1;
static gint ett_nr_rrc_PagingUE_Identity = -1;
static gint ett_nr_rrc_RRCReestablishment = -1;
static gint ett_nr_rrc_T_criticalExtensions_20 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_20 = -1;
static gint ett_nr_rrc_RRCReestablishment_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_21 = -1;
static gint ett_nr_rrc_RRCReestablishmentComplete = -1;
static gint ett_nr_rrc_T_criticalExtensions_21 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_21 = -1;
static gint ett_nr_rrc_RRCReestablishmentComplete_IEs = -1;
static gint ett_nr_rrc_RRCReestablishmentComplete_v1610_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_22 = -1;
static gint ett_nr_rrc_RRCReestablishmentRequest = -1;
static gint ett_nr_rrc_RRCReestablishmentRequest_IEs = -1;
static gint ett_nr_rrc_ReestabUE_Identity = -1;
static gint ett_nr_rrc_RRCReconfiguration = -1;
static gint ett_nr_rrc_T_criticalExtensions_22 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_22 = -1;
static gint ett_nr_rrc_RRCReconfiguration_IEs = -1;
static gint ett_nr_rrc_RRCReconfiguration_v1530_IEs = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxDRB_OF_DedicatedNAS_Message = -1;
static gint ett_nr_rrc_RRCReconfiguration_v1540_IEs = -1;
static gint ett_nr_rrc_RRCReconfiguration_v1560_IEs = -1;
static gint ett_nr_rrc_T_mrdc_SecondaryCellGroupConfig = -1;
static gint ett_nr_rrc_RRCReconfiguration_v1610_IEs = -1;
static gint ett_nr_rrc_T_bap_Config_r16 = -1;
static gint ett_nr_rrc_T_t316_r16 = -1;
static gint ett_nr_rrc_T_needForGapsConfigNR_r16 = -1;
static gint ett_nr_rrc_T_onDemandSIB_Request_r16 = -1;
static gint ett_nr_rrc_T_sl_ConfigDedicatedNR_r16 = -1;
static gint ett_nr_rrc_T_sl_ConfigDedicatedEUTRA_Info_r16 = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_23 = -1;
static gint ett_nr_rrc_MRDC_SecondaryCellGroupConfig = -1;
static gint ett_nr_rrc_T_mrdc_SecondaryCellGroup = -1;
static gint ett_nr_rrc_BAP_Config_r16 = -1;
static gint ett_nr_rrc_MasterKeyUpdate = -1;
static gint ett_nr_rrc_OnDemandSIB_Request_r16 = -1;
static gint ett_nr_rrc_IAB_IP_AddressConfigurationList_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxIAB_IP_Address_r16_OF_IAB_IP_AddressConfiguration_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxIAB_IP_Address_r16_OF_IAB_IP_AddressIndex_r16 = -1;
static gint ett_nr_rrc_IAB_IP_AddressConfiguration_r16 = -1;
static gint ett_nr_rrc_SL_ConfigDedicatedEUTRA_Info_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_8_OF_SL_TimeOffsetEUTRA_r16 = -1;
static gint ett_nr_rrc_RRCReconfigurationComplete = -1;
static gint ett_nr_rrc_T_criticalExtensions_23 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_23 = -1;
static gint ett_nr_rrc_RRCReconfigurationComplete_IEs = -1;
static gint ett_nr_rrc_RRCReconfigurationComplete_v1530_IEs = -1;
static gint ett_nr_rrc_RRCReconfigurationComplete_v1560_IEs = -1;
static gint ett_nr_rrc_T_scg_Response = -1;
static gint ett_nr_rrc_RRCReconfigurationComplete_v1610_IEs = -1;
static gint ett_nr_rrc_RRCReconfigurationComplete_v1640_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_24 = -1;
static gint ett_nr_rrc_RRCReject = -1;
static gint ett_nr_rrc_T_criticalExtensions_24 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_24 = -1;
static gint ett_nr_rrc_RRCReject_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_25 = -1;
static gint ett_nr_rrc_RRCRelease = -1;
static gint ett_nr_rrc_T_criticalExtensions_25 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_25 = -1;
static gint ett_nr_rrc_RRCRelease_IEs = -1;
static gint ett_nr_rrc_T_deprioritisationReq = -1;
static gint ett_nr_rrc_RRCRelease_v1540_IEs = -1;
static gint ett_nr_rrc_RRCRelease_v1610_IEs = -1;
static gint ett_nr_rrc_T_measIdleConfig_r16 = -1;
static gint ett_nr_rrc_RRCRelease_v1650_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_26 = -1;
static gint ett_nr_rrc_RedirectedCarrierInfo = -1;
static gint ett_nr_rrc_RedirectedCarrierInfo_EUTRA = -1;
static gint ett_nr_rrc_CarrierInfoNR = -1;
static gint ett_nr_rrc_SuspendConfig = -1;
static gint ett_nr_rrc_CellReselectionPriorities = -1;
static gint ett_nr_rrc_FreqPriorityListEUTRA = -1;
static gint ett_nr_rrc_FreqPriorityListNR = -1;
static gint ett_nr_rrc_FreqPriorityEUTRA = -1;
static gint ett_nr_rrc_FreqPriorityNR = -1;
static gint ett_nr_rrc_RAN_NotificationAreaInfo = -1;
static gint ett_nr_rrc_PLMN_RAN_AreaCellList = -1;
static gint ett_nr_rrc_PLMN_RAN_AreaCell = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_32_OF_CellIdentity = -1;
static gint ett_nr_rrc_PLMN_RAN_AreaConfigList = -1;
static gint ett_nr_rrc_PLMN_RAN_AreaConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_16_OF_RAN_AreaConfig = -1;
static gint ett_nr_rrc_RAN_AreaConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_32_OF_RAN_AreaCode = -1;
static gint ett_nr_rrc_RRCResume = -1;
static gint ett_nr_rrc_T_criticalExtensions_26 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_26 = -1;
static gint ett_nr_rrc_RRCResume_IEs = -1;
static gint ett_nr_rrc_RRCResume_v1560_IEs = -1;
static gint ett_nr_rrc_RRCResume_v1610_IEs = -1;
static gint ett_nr_rrc_T_mrdc_SecondaryCellGroup_r16 = -1;
static gint ett_nr_rrc_T_needForGapsConfigNR_r16_01 = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_27 = -1;
static gint ett_nr_rrc_RRCResumeComplete = -1;
static gint ett_nr_rrc_T_criticalExtensions_27 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_27 = -1;
static gint ett_nr_rrc_RRCResumeComplete_IEs = -1;
static gint ett_nr_rrc_RRCResumeComplete_v1610_IEs = -1;
static gint ett_nr_rrc_T_scg_Response_r16 = -1;
static gint ett_nr_rrc_RRCResumeComplete_v1640_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_28 = -1;
static gint ett_nr_rrc_RRCResumeRequest = -1;
static gint ett_nr_rrc_RRCResumeRequest_IEs = -1;
static gint ett_nr_rrc_RRCResumeRequest1 = -1;
static gint ett_nr_rrc_RRCResumeRequest1_IEs = -1;
static gint ett_nr_rrc_RRCSetup = -1;
static gint ett_nr_rrc_T_criticalExtensions_28 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_28 = -1;
static gint ett_nr_rrc_RRCSetup_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_29 = -1;
static gint ett_nr_rrc_RRCSetupComplete = -1;
static gint ett_nr_rrc_T_criticalExtensions_29 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_29 = -1;
static gint ett_nr_rrc_RRCSetupComplete_IEs = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofS_NSSAI_OF_S_NSSAI = -1;
static gint ett_nr_rrc_T_ng_5G_S_TMSI_Value = -1;
static gint ett_nr_rrc_RRCSetupComplete_v1610_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_30 = -1;
static gint ett_nr_rrc_RegisteredAMF = -1;
static gint ett_nr_rrc_RRCSetupRequest = -1;
static gint ett_nr_rrc_RRCSetupRequest_IEs = -1;
static gint ett_nr_rrc_InitialUE_Identity = -1;
static gint ett_nr_rrc_RRCSystemInfoRequest = -1;
static gint ett_nr_rrc_T_criticalExtensions_30 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_r16 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_30 = -1;
static gint ett_nr_rrc_RRCSystemInfoRequest_IEs = -1;
static gint ett_nr_rrc_RRC_PosSystemInfoRequest_r16_IEs = -1;
static gint ett_nr_rrc_SCGFailureInformation = -1;
static gint ett_nr_rrc_T_criticalExtensions_31 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_31 = -1;
static gint ett_nr_rrc_SCGFailureInformation_IEs = -1;
static gint ett_nr_rrc_SCGFailureInformation_v1590_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_31 = -1;
static gint ett_nr_rrc_FailureReportSCG = -1;
static gint ett_nr_rrc_MeasResultFreqList = -1;
static gint ett_nr_rrc_SCGFailureInformationEUTRA = -1;
static gint ett_nr_rrc_T_criticalExtensions_32 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_32 = -1;
static gint ett_nr_rrc_SCGFailureInformationEUTRA_IEs = -1;
static gint ett_nr_rrc_SCGFailureInformationEUTRA_v1590_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_32 = -1;
static gint ett_nr_rrc_FailureReportSCG_EUTRA = -1;
static gint ett_nr_rrc_MeasResultFreqListFailMRDC = -1;
static gint ett_nr_rrc_SecurityModeCommand = -1;
static gint ett_nr_rrc_T_criticalExtensions_33 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_33 = -1;
static gint ett_nr_rrc_SecurityModeCommand_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_33 = -1;
static gint ett_nr_rrc_SecurityConfigSMC = -1;
static gint ett_nr_rrc_SecurityModeComplete = -1;
static gint ett_nr_rrc_T_criticalExtensions_34 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_34 = -1;
static gint ett_nr_rrc_SecurityModeComplete_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_34 = -1;
static gint ett_nr_rrc_SecurityModeFailure = -1;
static gint ett_nr_rrc_T_criticalExtensions_35 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_35 = -1;
static gint ett_nr_rrc_SecurityModeFailure_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_35 = -1;
static gint ett_nr_rrc_SIB1 = -1;
static gint ett_nr_rrc_T_cellSelectionInfo = -1;
static gint ett_nr_rrc_T_uac_BarringInfo = -1;
static gint ett_nr_rrc_T_uac_AccessCategory1_SelectionAssistanceInfo = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_2_maxPLMN_OF_UAC_AccessCategory1_SelectionAssistanceInfo = -1;
static gint ett_nr_rrc_SIB1_v1610_IEs = -1;
static gint ett_nr_rrc_SIB1_v1630_IEs = -1;
static gint ett_nr_rrc_T_uac_BarringInfo_v1630 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_2_maxPLMN_OF_UAC_AC1_SelectAssistInfo_r16 = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_36 = -1;
static gint ett_nr_rrc_SidelinkUEInformationNR_r16 = -1;
static gint ett_nr_rrc_T_criticalExtensions_36 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_36 = -1;
static gint ett_nr_rrc_SidelinkUEInformationNR_r16_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_37 = -1;
static gint ett_nr_rrc_SL_InterestedFreqList_r16 = -1;
static gint ett_nr_rrc_SL_TxResourceReqList_r16 = -1;
static gint ett_nr_rrc_SL_TxResourceReq_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSLRB_r16_OF_SL_RLC_ModeIndication_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSL_QFIsPerDest_r16_OF_SL_QoS_Info_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofFreqSL_r16_OF_SL_TypeTxSync_r16 = -1;
static gint ett_nr_rrc_SL_TxInterestedFreqList_r16 = -1;
static gint ett_nr_rrc_SL_QoS_Info_r16 = -1;
static gint ett_nr_rrc_SL_RLC_ModeIndication_r16 = -1;
static gint ett_nr_rrc_T_sl_Mode_r16 = -1;
static gint ett_nr_rrc_SL_FailureList_r16 = -1;
static gint ett_nr_rrc_SL_Failure_r16 = -1;
static gint ett_nr_rrc_SystemInformation = -1;
static gint ett_nr_rrc_T_criticalExtensions_37 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_r16_01 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_37 = -1;
static gint ett_nr_rrc_SystemInformation_IEs = -1;
static gint ett_nr_rrc_T_sib_TypeAndInfo = -1;
static gint ett_nr_rrc_T_sib_TypeAndInfo_item = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_38 = -1;
static gint ett_nr_rrc_UEAssistanceInformation = -1;
static gint ett_nr_rrc_T_criticalExtensions_38 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_38 = -1;
static gint ett_nr_rrc_UEAssistanceInformation_IEs = -1;
static gint ett_nr_rrc_DelayBudgetReport = -1;
static gint ett_nr_rrc_UEAssistanceInformation_v1540_IEs = -1;
static gint ett_nr_rrc_OverheatingAssistance = -1;
static gint ett_nr_rrc_T_reducedMaxMIMO_LayersFR1 = -1;
static gint ett_nr_rrc_T_reducedMaxMIMO_LayersFR2 = -1;
static gint ett_nr_rrc_UEAssistanceInformation_v1610_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_39 = -1;
static gint ett_nr_rrc_IDC_Assistance_r16 = -1;
static gint ett_nr_rrc_AffectedCarrierFreqList_r16 = -1;
static gint ett_nr_rrc_AffectedCarrierFreq_r16 = -1;
static gint ett_nr_rrc_AffectedCarrierFreqCombList_r16 = -1;
static gint ett_nr_rrc_AffectedCarrierFreqComb_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_2_maxNrofServingCells_OF_ARFCN_ValueNR = -1;
static gint ett_nr_rrc_VictimSystemType_r16 = -1;
static gint ett_nr_rrc_DRX_Preference_r16 = -1;
static gint ett_nr_rrc_MaxBW_Preference_r16 = -1;
static gint ett_nr_rrc_MaxCC_Preference_r16 = -1;
static gint ett_nr_rrc_MaxMIMO_LayerPreference_r16 = -1;
static gint ett_nr_rrc_T_reducedMaxMIMO_LayersFR1_r16 = -1;
static gint ett_nr_rrc_T_reducedMaxMIMO_LayersFR2_r16 = -1;
static gint ett_nr_rrc_MinSchedulingOffsetPreference_r16 = -1;
static gint ett_nr_rrc_T_preferredK0_r16 = -1;
static gint ett_nr_rrc_T_preferredK2_r16 = -1;
static gint ett_nr_rrc_ReleasePreference_r16 = -1;
static gint ett_nr_rrc_ReducedMaxBW_FRx_r16 = -1;
static gint ett_nr_rrc_ReducedMaxCCs_r16 = -1;
static gint ett_nr_rrc_SL_UE_AssistanceInformationNR_r16 = -1;
static gint ett_nr_rrc_SL_TrafficPatternInfo_r16 = -1;
static gint ett_nr_rrc_UECapabilityEnquiry = -1;
static gint ett_nr_rrc_T_criticalExtensions_39 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_39 = -1;
static gint ett_nr_rrc_UECapabilityEnquiry_IEs = -1;
static gint ett_nr_rrc_UECapabilityEnquiry_v1560_IEs = -1;
static gint ett_nr_rrc_UECapabilityEnquiry_v1610_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_40 = -1;
static gint ett_nr_rrc_UECapabilityInformation = -1;
static gint ett_nr_rrc_T_criticalExtensions_40 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_40 = -1;
static gint ett_nr_rrc_UECapabilityInformation_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_41 = -1;
static gint ett_nr_rrc_UEInformationRequest_r16 = -1;
static gint ett_nr_rrc_T_criticalExtensions_41 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_41 = -1;
static gint ett_nr_rrc_UEInformationRequest_r16_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_42 = -1;
static gint ett_nr_rrc_UEInformationResponse_r16 = -1;
static gint ett_nr_rrc_T_criticalExtensions_42 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_42 = -1;
static gint ett_nr_rrc_UEInformationResponse_r16_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_43 = -1;
static gint ett_nr_rrc_LogMeasReport_r16 = -1;
static gint ett_nr_rrc_LogMeasInfoList_r16 = -1;
static gint ett_nr_rrc_LogMeasInfo_r16 = -1;
static gint ett_nr_rrc_T_measResultNeighCells_r16 = -1;
static gint ett_nr_rrc_ConnEstFailReport_r16 = -1;
static gint ett_nr_rrc_T_measResultNeighCells_r16_01 = -1;
static gint ett_nr_rrc_MeasResultServingCell_r16 = -1;
static gint ett_nr_rrc_T_resultsSSB = -1;
static gint ett_nr_rrc_MeasResultFailedCell_r16 = -1;
static gint ett_nr_rrc_T_measResult_r16 = -1;
static gint ett_nr_rrc_T_cellResults_r16 = -1;
static gint ett_nr_rrc_T_rsIndexResults_r16 = -1;
static gint ett_nr_rrc_RA_ReportList_r16 = -1;
static gint ett_nr_rrc_RA_Report_r16 = -1;
static gint ett_nr_rrc_T_cellId_r16 = -1;
static gint ett_nr_rrc_T_pci_arfcn_r16 = -1;
static gint ett_nr_rrc_RA_InformationCommon_r16 = -1;
static gint ett_nr_rrc_PerRAInfoList_r16 = -1;
static gint ett_nr_rrc_PerRAInfoList_v1660 = -1;
static gint ett_nr_rrc_PerRAInfo_r16 = -1;
static gint ett_nr_rrc_PerRASSBInfo_r16 = -1;
static gint ett_nr_rrc_PerRACSI_RSInfo_r16 = -1;
static gint ett_nr_rrc_PerRACSI_RSInfo_v1660 = -1;
static gint ett_nr_rrc_PerRAAttemptInfoList_r16 = -1;
static gint ett_nr_rrc_PerRAAttemptInfo_r16 = -1;
static gint ett_nr_rrc_RLF_Report_r16 = -1;
static gint ett_nr_rrc_T_nr_RLF_Report_r16 = -1;
static gint ett_nr_rrc_T_measResultNeighCells_r16_02 = -1;
static gint ett_nr_rrc_T_previousPCellId_r16 = -1;
static gint ett_nr_rrc_T_failedPCellId_r16 = -1;
static gint ett_nr_rrc_T_nrFailedPCellId_r16 = -1;
static gint ett_nr_rrc_T_pci_arfcn_r16_01 = -1;
static gint ett_nr_rrc_T_eutraFailedPCellId_r16 = -1;
static gint ett_nr_rrc_T_pci_arfcn_r16_02 = -1;
static gint ett_nr_rrc_T_reconnectCellId_r16 = -1;
static gint ett_nr_rrc_T_eutra_RLF_Report_r16 = -1;
static gint ett_nr_rrc_MeasResultList2NR_r16 = -1;
static gint ett_nr_rrc_MeasResultList2EUTRA_r16 = -1;
static gint ett_nr_rrc_MeasResult2NR_r16 = -1;
static gint ett_nr_rrc_MeasResultListLogging2NR_r16 = -1;
static gint ett_nr_rrc_MeasResultLogging2NR_r16 = -1;
static gint ett_nr_rrc_MeasResultListLoggingNR_r16 = -1;
static gint ett_nr_rrc_MeasResultLoggingNR_r16 = -1;
static gint ett_nr_rrc_MeasResult2EUTRA_r16 = -1;
static gint ett_nr_rrc_MeasResultRLFNR_r16 = -1;
static gint ett_nr_rrc_T_measResult_r16_01 = -1;
static gint ett_nr_rrc_T_cellResults_r16_01 = -1;
static gint ett_nr_rrc_T_rsIndexResults_r16_01 = -1;
static gint ett_nr_rrc_ULDedicatedMessageSegment_r16 = -1;
static gint ett_nr_rrc_T_criticalExtensions_43 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_43 = -1;
static gint ett_nr_rrc_ULDedicatedMessageSegment_r16_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_44 = -1;
static gint ett_nr_rrc_ULInformationTransfer = -1;
static gint ett_nr_rrc_T_criticalExtensions_44 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_44 = -1;
static gint ett_nr_rrc_ULInformationTransfer_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_45 = -1;
static gint ett_nr_rrc_ULInformationTransferIRAT_r16 = -1;
static gint ett_nr_rrc_T_criticalExtensions_45 = -1;
static gint ett_nr_rrc_T_c1_15 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_45 = -1;
static gint ett_nr_rrc_ULInformationTransferIRAT_r16_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_46 = -1;
static gint ett_nr_rrc_ULInformationTransferMRDC = -1;
static gint ett_nr_rrc_T_criticalExtensions_46 = -1;
static gint ett_nr_rrc_T_c1_16 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_46 = -1;
static gint ett_nr_rrc_ULInformationTransferMRDC_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_47 = -1;
static gint ett_nr_rrc_SIB2 = -1;
static gint ett_nr_rrc_T_cellReselectionInfoCommon = -1;
static gint ett_nr_rrc_T_speedStateReselectionPars = -1;
static gint ett_nr_rrc_T_q_HystSF = -1;
static gint ett_nr_rrc_T_cellReselectionServingFreqInfo = -1;
static gint ett_nr_rrc_T_intraFreqCellReselectionInfo = -1;
static gint ett_nr_rrc_T_relaxedMeasurement_r16 = -1;
static gint ett_nr_rrc_T_lowMobilityEvaluation_r16 = -1;
static gint ett_nr_rrc_T_cellEdgeEvaluation_r16 = -1;
static gint ett_nr_rrc_SIB3 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxPLMN_OF_IntraFreqCAG_CellListPerPLMN_r16 = -1;
static gint ett_nr_rrc_IntraFreqNeighCellList = -1;
static gint ett_nr_rrc_IntraFreqNeighCellList_v1610 = -1;
static gint ett_nr_rrc_IntraFreqNeighCellInfo = -1;
static gint ett_nr_rrc_IntraFreqNeighCellInfo_v1610 = -1;
static gint ett_nr_rrc_IntraFreqBlackCellList = -1;
static gint ett_nr_rrc_IntraFreqWhiteCellList_r16 = -1;
static gint ett_nr_rrc_IntraFreqCAG_CellListPerPLMN_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxCAG_Cell_r16_OF_PCI_Range = -1;
static gint ett_nr_rrc_SIB4 = -1;
static gint ett_nr_rrc_InterFreqCarrierFreqList = -1;
static gint ett_nr_rrc_InterFreqCarrierFreqList_v1610 = -1;
static gint ett_nr_rrc_InterFreqCarrierFreqInfo = -1;
static gint ett_nr_rrc_T_threshX_Q = -1;
static gint ett_nr_rrc_InterFreqCarrierFreqInfo_v1610 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxPLMN_OF_InterFreqCAG_CellListPerPLMN_r16 = -1;
static gint ett_nr_rrc_InterFreqNeighCellList = -1;
static gint ett_nr_rrc_InterFreqNeighCellList_v1610 = -1;
static gint ett_nr_rrc_InterFreqNeighCellInfo = -1;
static gint ett_nr_rrc_InterFreqNeighCellInfo_v1610 = -1;
static gint ett_nr_rrc_InterFreqBlackCellList = -1;
static gint ett_nr_rrc_InterFreqWhiteCellList_r16 = -1;
static gint ett_nr_rrc_InterFreqCAG_CellListPerPLMN_r16 = -1;
static gint ett_nr_rrc_SIB5 = -1;
static gint ett_nr_rrc_CarrierFreqListEUTRA = -1;
static gint ett_nr_rrc_CarrierFreqListEUTRA_v1610 = -1;
static gint ett_nr_rrc_CarrierFreqEUTRA = -1;
static gint ett_nr_rrc_T_threshX_Q_01 = -1;
static gint ett_nr_rrc_CarrierFreqEUTRA_v1610 = -1;
static gint ett_nr_rrc_EUTRA_FreqBlackCellList = -1;
static gint ett_nr_rrc_EUTRA_FreqNeighCellList = -1;
static gint ett_nr_rrc_EUTRA_FreqNeighCellInfo = -1;
static gint ett_nr_rrc_SIB6 = -1;
static gint ett_nr_rrc_SIB7 = -1;
static gint ett_nr_rrc_SIB8 = -1;
static gint ett_nr_rrc_SIB9 = -1;
static gint ett_nr_rrc_T_timeInfo = -1;
static gint ett_nr_rrc_SIB10_r16 = -1;
static gint ett_nr_rrc_HRNN_List_r16 = -1;
static gint ett_nr_rrc_HRNN_r16 = -1;
static gint ett_nr_rrc_SIB11_r16 = -1;
static gint ett_nr_rrc_SIB12_r16 = -1;
static gint ett_nr_rrc_SIB13_r16 = -1;
static gint ett_nr_rrc_SIB14_r16 = -1;
static gint ett_nr_rrc_PosSystemInformation_r16_IEs = -1;
static gint ett_nr_rrc_T_posSIB_TypeAndInfo_r16 = -1;
static gint ett_nr_rrc_T_posSIB_TypeAndInfo_r16_item = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_48 = -1;
static gint ett_nr_rrc_PosSI_SchedulingInfo_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxSI_Message_OF_PosSchedulingInfo_r16 = -1;
static gint ett_nr_rrc_PosSchedulingInfo_r16 = -1;
static gint ett_nr_rrc_PosSIB_MappingInfo_r16 = -1;
static gint ett_nr_rrc_PosSIB_Type_r16 = -1;
static gint ett_nr_rrc_GNSS_ID_r16 = -1;
static gint ett_nr_rrc_SBAS_ID_r16 = -1;
static gint ett_nr_rrc_SIBpos_r16 = -1;
static gint ett_nr_rrc_AvailabilityCombinationsPerCell_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofAvailabilityCombinationsPerSet_r16_OF_AvailabilityCombination_r16 = -1;
static gint ett_nr_rrc_AvailabilityCombination_r16 = -1;
static gint ett_nr_rrc_T_resourceAvailability_r16 = -1;
static gint ett_nr_rrc_AvailabilityIndicator_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofDUCells_r16_OF_AvailabilityCombinationsPerCell_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofDUCells_r16_OF_AvailabilityCombinationsPerCellIndex_r16 = -1;
static gint ett_nr_rrc_BAP_RoutingID_r16 = -1;
static gint ett_nr_rrc_BeamFailureRecoveryConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCandidateBeams_OF_PRACH_ResourceDedicatedBFR = -1;
static gint ett_nr_rrc_T_candidateBeamRSListExt_v1610 = -1;
static gint ett_nr_rrc_PRACH_ResourceDedicatedBFR = -1;
static gint ett_nr_rrc_BFR_SSB_Resource = -1;
static gint ett_nr_rrc_BFR_CSIRS_Resource = -1;
static gint ett_nr_rrc_T_ra_OccasionList = -1;
static gint ett_nr_rrc_CandidateBeamRSListExt_r16 = -1;
static gint ett_nr_rrc_BeamFailureRecoverySCellConfig_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCandidateBeams_r16_OF_CandidateBeamRS_r16 = -1;
static gint ett_nr_rrc_CandidateBeamRS_r16 = -1;
static gint ett_nr_rrc_T_candidateBeamConfig_r16 = -1;
static gint ett_nr_rrc_BetaOffsets = -1;
static gint ett_nr_rrc_BH_LogicalChannelIdentity_r16 = -1;
static gint ett_nr_rrc_BH_RLC_ChannelConfig_r16 = -1;
static gint ett_nr_rrc_BSR_Config = -1;
static gint ett_nr_rrc_BWP = -1;
static gint ett_nr_rrc_BWP_Downlink = -1;
static gint ett_nr_rrc_BWP_DownlinkCommon = -1;
static gint ett_nr_rrc_T_pdcch_ConfigCommon = -1;
static gint ett_nr_rrc_T_pdsch_ConfigCommon = -1;
static gint ett_nr_rrc_BWP_DownlinkDedicated = -1;
static gint ett_nr_rrc_T_pdcch_Config = -1;
static gint ett_nr_rrc_T_pdsch_Config = -1;
static gint ett_nr_rrc_T_sps_Config = -1;
static gint ett_nr_rrc_T_radioLinkMonitoringConfig = -1;
static gint ett_nr_rrc_T_beamFailureRecoverySCellConfig_r16 = -1;
static gint ett_nr_rrc_T_sl_PDCCH_Config_r16 = -1;
static gint ett_nr_rrc_T_sl_V2X_PDCCH_Config_r16 = -1;
static gint ett_nr_rrc_SPS_ConfigToAddModList_r16 = -1;
static gint ett_nr_rrc_SPS_ConfigToReleaseList_r16 = -1;
static gint ett_nr_rrc_SPS_ConfigDeactivationState_r16 = -1;
static gint ett_nr_rrc_SPS_ConfigDeactivationStateList_r16 = -1;
static gint ett_nr_rrc_BWP_Uplink = -1;
static gint ett_nr_rrc_BWP_UplinkCommon = -1;
static gint ett_nr_rrc_T_rach_ConfigCommon = -1;
static gint ett_nr_rrc_T_pusch_ConfigCommon = -1;
static gint ett_nr_rrc_T_pucch_ConfigCommon = -1;
static gint ett_nr_rrc_T_rach_ConfigCommonIAB_r16 = -1;
static gint ett_nr_rrc_T_msgA_ConfigCommon_r16 = -1;
static gint ett_nr_rrc_BWP_UplinkDedicated = -1;
static gint ett_nr_rrc_T_pucch_Config = -1;
static gint ett_nr_rrc_T_pusch_Config = -1;
static gint ett_nr_rrc_T_configuredGrantConfig = -1;
static gint ett_nr_rrc_T_srs_Config = -1;
static gint ett_nr_rrc_T_beamFailureRecoveryConfig = -1;
static gint ett_nr_rrc_T_sl_PUCCH_Config_r16 = -1;
static gint ett_nr_rrc_T_pucch_ConfigurationList_r16 = -1;
static gint ett_nr_rrc_T_lbt_FailureRecoveryConfig_r16 = -1;
static gint ett_nr_rrc_ConfiguredGrantConfigToAddModList_r16 = -1;
static gint ett_nr_rrc_ConfiguredGrantConfigToReleaseList_r16 = -1;
static gint ett_nr_rrc_ConfiguredGrantConfigType2DeactivationState_r16 = -1;
static gint ett_nr_rrc_ConfiguredGrantConfigType2DeactivationStateList_r16 = -1;
static gint ett_nr_rrc_CellAccessRelatedInfo = -1;
static gint ett_nr_rrc_CellAccessRelatedInfo_EUTRA_5GC = -1;
static gint ett_nr_rrc_PLMN_IdentityList_EUTRA_5GC = -1;
static gint ett_nr_rrc_PLMN_Identity_EUTRA_5GC = -1;
static gint ett_nr_rrc_CellIdentity_EUTRA_5GC = -1;
static gint ett_nr_rrc_CellAccessRelatedInfo_EUTRA_EPC = -1;
static gint ett_nr_rrc_PLMN_IdentityList_EUTRA_EPC = -1;
static gint ett_nr_rrc_CellGroupConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxLC_ID_OF_RLC_BearerConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxLC_ID_OF_LogicalChannelIdentity = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSCells_OF_SCellConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSCells_OF_SCellIndex = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxBH_RLC_ChannelID_r16_OF_BH_RLC_ChannelConfig_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxBH_RLC_ChannelID_r16_OF_BH_RLC_ChannelID_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofServingCellsTCI_r16_OF_ServCellIndex = -1;
static gint ett_nr_rrc_SpCellConfig = -1;
static gint ett_nr_rrc_T_rlf_TimersAndConstants = -1;
static gint ett_nr_rrc_ReconfigurationWithSync = -1;
static gint ett_nr_rrc_T_rach_ConfigDedicated = -1;
static gint ett_nr_rrc_DAPS_UplinkPowerConfig_r16 = -1;
static gint ett_nr_rrc_SCellConfig = -1;
static gint ett_nr_rrc_CGI_InfoEUTRA = -1;
static gint ett_nr_rrc_T_cgi_info_EPC = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_EPC = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_5GC = -1;
static gint ett_nr_rrc_CGI_InfoEUTRALogging = -1;
static gint ett_nr_rrc_CGI_InfoNR = -1;
static gint ett_nr_rrc_T_noSIB1 = -1;
static gint ett_nr_rrc_CGI_Info_Logging_r16 = -1;
static gint ett_nr_rrc_CodebookConfig = -1;
static gint ett_nr_rrc_T_codebookType = -1;
static gint ett_nr_rrc_T_type1_01 = -1;
static gint ett_nr_rrc_T_subType = -1;
static gint ett_nr_rrc_T_typeI_SinglePanel = -1;
static gint ett_nr_rrc_T_nrOfAntennaPorts = -1;
static gint ett_nr_rrc_T_two = -1;
static gint ett_nr_rrc_T_moreThanTwo = -1;
static gint ett_nr_rrc_T_n1_n2 = -1;
static gint ett_nr_rrc_T_typeI_MultiPanel = -1;
static gint ett_nr_rrc_T_ng_n1_n2 = -1;
static gint ett_nr_rrc_T_type2 = -1;
static gint ett_nr_rrc_T_subType_01 = -1;
static gint ett_nr_rrc_T_typeII = -1;
static gint ett_nr_rrc_T_n1_n2_codebookSubsetRestriction = -1;
static gint ett_nr_rrc_T_typeII_PortSelection = -1;
static gint ett_nr_rrc_CodebookConfig_r16 = -1;
static gint ett_nr_rrc_T_codebookType_01 = -1;
static gint ett_nr_rrc_T_type2_01 = -1;
static gint ett_nr_rrc_T_subType_02 = -1;
static gint ett_nr_rrc_T_typeII_r16 = -1;
static gint ett_nr_rrc_T_n1_n2_codebookSubsetRestriction_r16 = -1;
static gint ett_nr_rrc_T_typeII_PortSelection_r16 = -1;
static gint ett_nr_rrc_CommonLocationInfo_r16 = -1;
static gint ett_nr_rrc_CondReconfigToAddModList_r16 = -1;
static gint ett_nr_rrc_CondReconfigToAddMod_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_2_OF_MeasId = -1;
static gint ett_nr_rrc_ConditionalReconfiguration_r16 = -1;
static gint ett_nr_rrc_CondReconfigToRemoveList_r16 = -1;
static gint ett_nr_rrc_ConfiguredGrantConfig = -1;
static gint ett_nr_rrc_T_uci_OnPUSCH = -1;
static gint ett_nr_rrc_T_rrc_ConfiguredUplinkGrant = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_1709_OF_CG_COT_Sharing_r16 = -1;
static gint ett_nr_rrc_CG_UCI_OnPUSCH = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_4_OF_BetaOffsets = -1;
static gint ett_nr_rrc_CG_COT_Sharing_r16 = -1;
static gint ett_nr_rrc_T_cot_Sharing_r16 = -1;
static gint ett_nr_rrc_CG_StartingOffsets_r16 = -1;
static gint ett_nr_rrc_T_cg_StartingFullBW_InsideCOT_r16 = -1;
static gint ett_nr_rrc_T_cg_StartingFullBW_OutsideCOT_r16 = -1;
static gint ett_nr_rrc_ConnEstFailureControl = -1;
static gint ett_nr_rrc_ControlResourceSet = -1;
static gint ett_nr_rrc_T_cce_REG_MappingType = -1;
static gint ett_nr_rrc_T_interleaved = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofTCI_StatesPDCCH_OF_TCI_StateId = -1;
static gint ett_nr_rrc_CrossCarrierSchedulingConfig = -1;
static gint ett_nr_rrc_T_schedulingCellInfo = -1;
static gint ett_nr_rrc_T_own = -1;
static gint ett_nr_rrc_T_other = -1;
static gint ett_nr_rrc_T_carrierIndicatorSize_r16 = -1;
static gint ett_nr_rrc_CSI_AperiodicTriggerStateList = -1;
static gint ett_nr_rrc_CSI_AperiodicTriggerState = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofReportConfigPerAperiodicTrigger_OF_CSI_AssociatedReportConfigInfo = -1;
static gint ett_nr_rrc_CSI_AssociatedReportConfigInfo = -1;
static gint ett_nr_rrc_T_resourcesForChannel = -1;
static gint ett_nr_rrc_T_nzp_CSI_RS = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofAP_CSI_RS_ResourcesPerSet_OF_TCI_StateId = -1;
static gint ett_nr_rrc_CSI_FrequencyOccupation = -1;
static gint ett_nr_rrc_CSI_IM_Resource = -1;
static gint ett_nr_rrc_T_csi_IM_ResourceElementPattern = -1;
static gint ett_nr_rrc_T_pattern0 = -1;
static gint ett_nr_rrc_T_pattern1 = -1;
static gint ett_nr_rrc_CSI_IM_ResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_IM_ResourcesPerSet_OF_CSI_IM_ResourceId = -1;
static gint ett_nr_rrc_CSI_MeasConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_Resources_OF_NZP_CSI_RS_Resource = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_Resources_OF_NZP_CSI_RS_ResourceId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourceSets_OF_NZP_CSI_RS_ResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourceSets_OF_NZP_CSI_RS_ResourceSetId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_IM_Resources_OF_CSI_IM_Resource = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_IM_Resources_OF_CSI_IM_ResourceId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_IM_ResourceSets_OF_CSI_IM_ResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_IM_ResourceSets_OF_CSI_IM_ResourceSetId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_SSB_ResourceSets_OF_CSI_SSB_ResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_SSB_ResourceSets_OF_CSI_SSB_ResourceSetId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_ResourceConfigurations_OF_CSI_ResourceConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_ResourceConfigurations_OF_CSI_ResourceConfigId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_ReportConfigurations_OF_CSI_ReportConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_ReportConfigurations_OF_CSI_ReportConfigId = -1;
static gint ett_nr_rrc_T_aperiodicTriggerStateList = -1;
static gint ett_nr_rrc_T_semiPersistentOnPUSCH_TriggerStateList = -1;
static gint ett_nr_rrc_CSI_ReportConfig = -1;
static gint ett_nr_rrc_T_reportConfigType = -1;
static gint ett_nr_rrc_T_periodic = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofBWPs_OF_PUCCH_CSI_Resource = -1;
static gint ett_nr_rrc_T_semiPersistentOnPUCCH = -1;
static gint ett_nr_rrc_T_semiPersistentOnPUSCH = -1;
static gint ett_nr_rrc_T_reportSlotOffsetList = -1;
static gint ett_nr_rrc_T_aperiodic = -1;
static gint ett_nr_rrc_T_reportSlotOffsetList_01 = -1;
static gint ett_nr_rrc_T_reportQuantity = -1;
static gint ett_nr_rrc_T_cri_RI_i1_CQI = -1;
static gint ett_nr_rrc_T_reportFreqConfiguration = -1;
static gint ett_nr_rrc_T_csi_ReportingBand = -1;
static gint ett_nr_rrc_T_groupBasedBeamReporting = -1;
static gint ett_nr_rrc_T_disabled = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourcesPerConfig_OF_PortIndexFor8Ranks = -1;
static gint ett_nr_rrc_T_semiPersistentOnPUSCH_v1530 = -1;
static gint ett_nr_rrc_T_semiPersistentOnPUSCH_v1610 = -1;
static gint ett_nr_rrc_T_reportSlotOffsetListDCI_0_2_r16 = -1;
static gint ett_nr_rrc_T_reportSlotOffsetListDCI_0_1_r16 = -1;
static gint ett_nr_rrc_T_aperiodic_v1610 = -1;
static gint ett_nr_rrc_T_reportSlotOffsetListDCI_0_2_r16_01 = -1;
static gint ett_nr_rrc_T_reportSlotOffsetListDCI_0_1_r16_01 = -1;
static gint ett_nr_rrc_T_reportQuantity_r16 = -1;
static gint ett_nr_rrc_CSI_ReportPeriodicityAndOffset = -1;
static gint ett_nr_rrc_PUCCH_CSI_Resource = -1;
static gint ett_nr_rrc_PortIndexFor8Ranks = -1;
static gint ett_nr_rrc_T_portIndex8 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_2_OF_PortIndex8 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_3_OF_PortIndex8 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_4_OF_PortIndex8 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_5_OF_PortIndex8 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_6_OF_PortIndex8 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_7_OF_PortIndex8 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_8_OF_PortIndex8 = -1;
static gint ett_nr_rrc_T_portIndex4 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_2_OF_PortIndex4 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_3_OF_PortIndex4 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_4_OF_PortIndex4 = -1;
static gint ett_nr_rrc_T_portIndex2 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_2_OF_PortIndex2 = -1;
static gint ett_nr_rrc_CSI_ResourceConfig = -1;
static gint ett_nr_rrc_T_csi_RS_ResourceSetList = -1;
static gint ett_nr_rrc_T_nzp_CSI_RS_SSB = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourceSetsPerConfig_OF_NZP_CSI_RS_ResourceSetId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_SSB_ResourceSetsPerConfig_OF_CSI_SSB_ResourceSetId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_IM_ResourceSetsPerConfig_OF_CSI_IM_ResourceSetId = -1;
static gint ett_nr_rrc_CSI_ResourcePeriodicityAndOffset = -1;
static gint ett_nr_rrc_CSI_RS_ResourceConfigMobility = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_RS_CellsRRM_OF_CSI_RS_CellMobility = -1;
static gint ett_nr_rrc_CSI_RS_CellMobility = -1;
static gint ett_nr_rrc_T_csi_rs_MeasurementBW = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_RS_ResourcesRRM_OF_CSI_RS_Resource_Mobility = -1;
static gint ett_nr_rrc_CSI_RS_Resource_Mobility = -1;
static gint ett_nr_rrc_T_slotConfig = -1;
static gint ett_nr_rrc_T_associatedSSB = -1;
static gint ett_nr_rrc_T_frequencyDomainAllocation = -1;
static gint ett_nr_rrc_CSI_RS_ResourceMapping = -1;
static gint ett_nr_rrc_T_frequencyDomainAllocation_01 = -1;
static gint ett_nr_rrc_T_density_01 = -1;
static gint ett_nr_rrc_CSI_SemiPersistentOnPUSCH_TriggerStateList = -1;
static gint ett_nr_rrc_CSI_SemiPersistentOnPUSCH_TriggerState = -1;
static gint ett_nr_rrc_CSI_SSB_ResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_SSB_ResourcePerSet_OF_SSB_Index = -1;
static gint ett_nr_rrc_DMRS_DownlinkConfig = -1;
static gint ett_nr_rrc_T_phaseTrackingRS = -1;
static gint ett_nr_rrc_DMRS_UplinkConfig = -1;
static gint ett_nr_rrc_T_phaseTrackingRS_01 = -1;
static gint ett_nr_rrc_T_transformPrecodingDisabled = -1;
static gint ett_nr_rrc_T_transformPrecodingEnabled = -1;
static gint ett_nr_rrc_T_dmrs_UplinkTransformPrecoding_r16 = -1;
static gint ett_nr_rrc_DMRS_UplinkTransformPrecoding_r16 = -1;
static gint ett_nr_rrc_DownlinkConfigCommon = -1;
static gint ett_nr_rrc_DownlinkConfigCommonSIB = -1;
static gint ett_nr_rrc_BCCH_Config = -1;
static gint ett_nr_rrc_PCCH_Config = -1;
static gint ett_nr_rrc_T_nAndPagingFrameOffset = -1;
static gint ett_nr_rrc_T_firstPDCCH_MonitoringOccasionOfPO = -1;
static gint ett_nr_rrc_T_sCS15KHZoneT = -1;
static gint ett_nr_rrc_T_sCS30KHZoneT_SCS15KHZhalfT = -1;
static gint ett_nr_rrc_T_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT = -1;
static gint ett_nr_rrc_T_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT = -1;
static gint ett_nr_rrc_T_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT = -1;
static gint ett_nr_rrc_T_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT = -1;
static gint ett_nr_rrc_T_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT = -1;
static gint ett_nr_rrc_T_sCS120KHZoneSixteenthT = -1;
static gint ett_nr_rrc_DownlinkPreemption = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofServingCells_OF_INT_ConfigurationPerServingCell = -1;
static gint ett_nr_rrc_INT_ConfigurationPerServingCell = -1;
static gint ett_nr_rrc_DRX_Config = -1;
static gint ett_nr_rrc_T_drx_onDurationTimer_01 = -1;
static gint ett_nr_rrc_T_drx_LongCycleStartOffset_01 = -1;
static gint ett_nr_rrc_T_shortDRX_01 = -1;
static gint ett_nr_rrc_DRX_ConfigSecondaryGroup = -1;
static gint ett_nr_rrc_T_drx_onDurationTimer_02 = -1;
static gint ett_nr_rrc_FrequencyInfoDL = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxSCSs_OF_SCS_SpecificCarrier = -1;
static gint ett_nr_rrc_FrequencyInfoDL_SIB = -1;
static gint ett_nr_rrc_FrequencyInfoUL = -1;
static gint ett_nr_rrc_FrequencyInfoUL_SIB = -1;
static gint ett_nr_rrc_HighSpeedConfig_r16 = -1;
static gint ett_nr_rrc_InvalidSymbolPattern_r16 = -1;
static gint ett_nr_rrc_T_symbols_r16 = -1;
static gint ett_nr_rrc_T_periodicityAndPattern_r16 = -1;
static gint ett_nr_rrc_LBT_FailureRecoveryConfig_r16 = -1;
static gint ett_nr_rrc_LocationInfo_r16 = -1;
static gint ett_nr_rrc_LocationMeasurementInfo = -1;
static gint ett_nr_rrc_EUTRA_RSTD_InfoList = -1;
static gint ett_nr_rrc_EUTRA_RSTD_Info = -1;
static gint ett_nr_rrc_NR_PRS_MeasurementInfoList_r16 = -1;
static gint ett_nr_rrc_NR_PRS_MeasurementInfo_r16 = -1;
static gint ett_nr_rrc_T_nr_MeasPRS_RepetitionAndOffset_r16 = -1;
static gint ett_nr_rrc_LogicalChannelConfig = -1;
static gint ett_nr_rrc_T_ul_SpecificParameters = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofServingCells_1_OF_ServCellIndex = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxSCSs_OF_SubcarrierSpacing = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_0_maxNrofConfiguredGrantConfigMAC_1_r16_OF_ConfiguredGrantConfigIndexMAC_r16 = -1;
static gint ett_nr_rrc_MAC_CellGroupConfig = -1;
static gint ett_nr_rrc_T_drx_Config = -1;
static gint ett_nr_rrc_T_phr_Config = -1;
static gint ett_nr_rrc_T_dataInactivityTimer = -1;
static gint ett_nr_rrc_T_drx_ConfigSecondaryGroup_r16 = -1;
static gint ett_nr_rrc_MeasConfig = -1;
static gint ett_nr_rrc_T_s_MeasureConfig = -1;
static gint ett_nr_rrc_MeasObjectToRemoveList = -1;
static gint ett_nr_rrc_MeasIdToRemoveList = -1;
static gint ett_nr_rrc_ReportConfigToRemoveList = -1;
static gint ett_nr_rrc_MeasGapConfig = -1;
static gint ett_nr_rrc_T_gapFR2 = -1;
static gint ett_nr_rrc_T_gapFR1 = -1;
static gint ett_nr_rrc_T_gapUE = -1;
static gint ett_nr_rrc_GapConfig = -1;
static gint ett_nr_rrc_MeasGapSharingConfig = -1;
static gint ett_nr_rrc_T_gapSharingFR2 = -1;
static gint ett_nr_rrc_T_gapSharingFR1 = -1;
static gint ett_nr_rrc_T_gapSharingUE = -1;
static gint ett_nr_rrc_MeasIdleConfigSIB_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxFreqIdle_r16_OF_MeasIdleCarrierNR_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxFreqIdle_r16_OF_MeasIdleCarrierEUTRA_r16 = -1;
static gint ett_nr_rrc_MeasIdleConfigDedicated_r16 = -1;
static gint ett_nr_rrc_ValidityAreaList_r16 = -1;
static gint ett_nr_rrc_ValidityArea_r16 = -1;
static gint ett_nr_rrc_ValidityCellList = -1;
static gint ett_nr_rrc_MeasIdleCarrierNR_r16 = -1;
static gint ett_nr_rrc_T_qualityThreshold_r16 = -1;
static gint ett_nr_rrc_T_ssb_MeasConfig_r16 = -1;
static gint ett_nr_rrc_MeasIdleCarrierEUTRA_r16 = -1;
static gint ett_nr_rrc_T_qualityThresholdEUTRA_r16 = -1;
static gint ett_nr_rrc_CellListNR_r16 = -1;
static gint ett_nr_rrc_CellListEUTRA_r16 = -1;
static gint ett_nr_rrc_BeamMeasConfigIdle_NR_r16 = -1;
static gint ett_nr_rrc_MeasIdToAddModList = -1;
static gint ett_nr_rrc_MeasIdToAddMod = -1;
static gint ett_nr_rrc_MeasObjectCLI_r16 = -1;
static gint ett_nr_rrc_CLI_ResourceConfig_r16 = -1;
static gint ett_nr_rrc_T_srs_ResourceConfig_r16 = -1;
static gint ett_nr_rrc_T_rssi_ResourceConfig_r16 = -1;
static gint ett_nr_rrc_SRS_ResourceListConfigCLI_r16 = -1;
static gint ett_nr_rrc_RSSI_ResourceListConfigCLI_r16 = -1;
static gint ett_nr_rrc_SRS_ResourceConfigCLI_r16 = -1;
static gint ett_nr_rrc_RSSI_ResourceConfigCLI_r16 = -1;
static gint ett_nr_rrc_RSSI_PeriodicityAndOffset_r16 = -1;
static gint ett_nr_rrc_MeasObjectEUTRA = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxCellMeasEUTRA_OF_EUTRA_Cell = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxCellMeasEUTRA_OF_EUTRA_BlackCell = -1;
static gint ett_nr_rrc_EUTRA_CellIndexList = -1;
static gint ett_nr_rrc_EUTRA_Cell = -1;
static gint ett_nr_rrc_EUTRA_BlackCell = -1;
static gint ett_nr_rrc_MeasObjectNR = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPCI_Ranges_OF_PCI_RangeElement = -1;
static gint ett_nr_rrc_T_rmtc_Config_r16 = -1;
static gint ett_nr_rrc_T_t312_r16 = -1;
static gint ett_nr_rrc_SSB_MTC3List_r16 = -1;
static gint ett_nr_rrc_ReferenceSignalConfig = -1;
static gint ett_nr_rrc_T_csi_rs_ResourceConfigMobility = -1;
static gint ett_nr_rrc_SSB_ConfigMobility = -1;
static gint ett_nr_rrc_T_ssb_ToMeasure = -1;
static gint ett_nr_rrc_Q_OffsetRangeList = -1;
static gint ett_nr_rrc_ThresholdNR = -1;
static gint ett_nr_rrc_CellsToAddModList = -1;
static gint ett_nr_rrc_CellsToAddMod = -1;
static gint ett_nr_rrc_RMTC_Config_r16 = -1;
static gint ett_nr_rrc_SSB_PositionQCL_CellsToAddModList_r16 = -1;
static gint ett_nr_rrc_SSB_PositionQCL_CellsToAddMod_r16 = -1;
static gint ett_nr_rrc_MeasObjectNR_SL_r16 = -1;
static gint ett_nr_rrc_Tx_PoolMeasList_r16 = -1;
static gint ett_nr_rrc_MeasObjectToAddModList = -1;
static gint ett_nr_rrc_MeasObjectToAddMod = -1;
static gint ett_nr_rrc_T_measObject = -1;
static gint ett_nr_rrc_MeasObjectUTRA_FDD_r16 = -1;
static gint ett_nr_rrc_CellsToAddModListUTRA_FDD_r16 = -1;
static gint ett_nr_rrc_CellsToAddModUTRA_FDD_r16 = -1;
static gint ett_nr_rrc_UTRA_FDD_CellIndexList_r16 = -1;
static gint ett_nr_rrc_MeasResultCellListSFTD_NR = -1;
static gint ett_nr_rrc_MeasResultCellSFTD_NR = -1;
static gint ett_nr_rrc_MeasResultCellListSFTD_EUTRA = -1;
static gint ett_nr_rrc_MeasResultSFTD_EUTRA = -1;
static gint ett_nr_rrc_MeasResults = -1;
static gint ett_nr_rrc_T_measResultNeighCells = -1;
static gint ett_nr_rrc_MeasResultServMOList = -1;
static gint ett_nr_rrc_MeasResultServMO = -1;
static gint ett_nr_rrc_MeasResultListNR = -1;
static gint ett_nr_rrc_MeasResultNR = -1;
static gint ett_nr_rrc_T_measResult = -1;
static gint ett_nr_rrc_T_cellResults = -1;
static gint ett_nr_rrc_T_rsIndexResults = -1;
static gint ett_nr_rrc_MeasResultListEUTRA = -1;
static gint ett_nr_rrc_MeasResultEUTRA = -1;
static gint ett_nr_rrc_MultiBandInfoListEUTRA = -1;
static gint ett_nr_rrc_MeasQuantityResults = -1;
static gint ett_nr_rrc_MeasQuantityResultsEUTRA = -1;
static gint ett_nr_rrc_ResultsPerSSB_IndexList = -1;
static gint ett_nr_rrc_ResultsPerSSB_Index = -1;
static gint ett_nr_rrc_ResultsPerCSI_RS_IndexList = -1;
static gint ett_nr_rrc_ResultsPerCSI_RS_Index = -1;
static gint ett_nr_rrc_MeasResultServFreqListEUTRA_SCG = -1;
static gint ett_nr_rrc_MeasResultServFreqListNR_SCG = -1;
static gint ett_nr_rrc_MeasResultListUTRA_FDD_r16 = -1;
static gint ett_nr_rrc_MeasResultUTRA_FDD_r16 = -1;
static gint ett_nr_rrc_T_measResult_r16_02 = -1;
static gint ett_nr_rrc_MeasResultForRSSI_r16 = -1;
static gint ett_nr_rrc_MeasResultCLI_r16 = -1;
static gint ett_nr_rrc_MeasResultListSRS_RSRP_r16 = -1;
static gint ett_nr_rrc_MeasResultSRS_RSRP_r16 = -1;
static gint ett_nr_rrc_MeasResultListCLI_RSSI_r16 = -1;
static gint ett_nr_rrc_MeasResultCLI_RSSI_r16 = -1;
static gint ett_nr_rrc_UL_PDCP_DelayValueResultList_r16 = -1;
static gint ett_nr_rrc_UL_PDCP_DelayValueResult_r16 = -1;
static gint ett_nr_rrc_MeasResult2EUTRA = -1;
static gint ett_nr_rrc_MeasResult2NR = -1;
static gint ett_nr_rrc_MeasResultIdleEUTRA_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxFreqIdle_r16_OF_MeasResultsPerCarrierIdleEUTRA_r16 = -1;
static gint ett_nr_rrc_MeasResultsPerCarrierIdleEUTRA_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxCellMeasIdle_r16_OF_MeasResultsPerCellIdleEUTRA_r16 = -1;
static gint ett_nr_rrc_MeasResultsPerCellIdleEUTRA_r16 = -1;
static gint ett_nr_rrc_T_measIdleResultEUTRA_r16 = -1;
static gint ett_nr_rrc_MeasResultIdleNR_r16 = -1;
static gint ett_nr_rrc_T_measResultServingCell_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxFreqIdle_r16_OF_MeasResultsPerCarrierIdleNR_r16 = -1;
static gint ett_nr_rrc_MeasResultsPerCarrierIdleNR_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxCellMeasIdle_r16_OF_MeasResultsPerCellIdleNR_r16 = -1;
static gint ett_nr_rrc_MeasResultsPerCellIdleNR_r16 = -1;
static gint ett_nr_rrc_T_measIdleResultNR_r16 = -1;
static gint ett_nr_rrc_ResultsPerSSB_IndexList_r16 = -1;
static gint ett_nr_rrc_ResultsPerSSB_IndexIdle_r16 = -1;
static gint ett_nr_rrc_T_ssb_Results_r16 = -1;
static gint ett_nr_rrc_MeasResultSCG_Failure = -1;
static gint ett_nr_rrc_MeasResultList2NR = -1;
static gint ett_nr_rrc_MeasResultsSL_r16 = -1;
static gint ett_nr_rrc_T_measResultsListSL_r16 = -1;
static gint ett_nr_rrc_MeasResultNR_SL_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSL_PoolToMeasureNR_r16_OF_MeasResultCBR_NR_r16 = -1;
static gint ett_nr_rrc_MeasResultCBR_NR_r16 = -1;
static gint ett_nr_rrc_MeasTriggerQuantityEUTRA = -1;
static gint ett_nr_rrc_MobilityStateParameters = -1;
static gint ett_nr_rrc_MsgA_ConfigCommon_r16 = -1;
static gint ett_nr_rrc_MsgA_PUSCH_Config_r16 = -1;
static gint ett_nr_rrc_MsgA_PUSCH_Resource_r16 = -1;
static gint ett_nr_rrc_MsgA_DMRS_Config_r16 = -1;
static gint ett_nr_rrc_MultiFrequencyBandListNR = -1;
static gint ett_nr_rrc_MultiFrequencyBandListNR_SIB = -1;
static gint ett_nr_rrc_NR_MultiBandInfo = -1;
static gint ett_nr_rrc_NeedForGapsConfigNR_r16 = -1;
static gint ett_nr_rrc_NeedForGapsInfoNR_r16 = -1;
static gint ett_nr_rrc_NeedForGapsIntraFreqList_r16 = -1;
static gint ett_nr_rrc_NeedForGapsBandListNR_r16 = -1;
static gint ett_nr_rrc_NeedForGapsIntraFreq_r16 = -1;
static gint ett_nr_rrc_NeedForGapsNR_r16 = -1;
static gint ett_nr_rrc_NPN_Identity_r16 = -1;
static gint ett_nr_rrc_T_pni_npn_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNPN_r16_OF_CAG_IdentityInfo_r16 = -1;
static gint ett_nr_rrc_T_snpn_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNPN_r16_OF_NID_r16 = -1;
static gint ett_nr_rrc_CAG_IdentityInfo_r16 = -1;
static gint ett_nr_rrc_NPN_IdentityInfoList_r16 = -1;
static gint ett_nr_rrc_NPN_IdentityInfo_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNPN_r16_OF_NPN_Identity_r16 = -1;
static gint ett_nr_rrc_NR_NS_PmaxList = -1;
static gint ett_nr_rrc_NR_NS_PmaxValue = -1;
static gint ett_nr_rrc_NZP_CSI_RS_Resource = -1;
static gint ett_nr_rrc_NZP_CSI_RS_ResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourcesPerSet_OF_NZP_CSI_RS_ResourceId = -1;
static gint ett_nr_rrc_PCI_List = -1;
static gint ett_nr_rrc_PCI_Range = -1;
static gint ett_nr_rrc_PCI_RangeElement = -1;
static gint ett_nr_rrc_PCI_RangeIndexList = -1;
static gint ett_nr_rrc_PDCCH_Config = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_3_OF_ControlResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_3_OF_ControlResourceSetId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_10_OF_SearchSpace = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_10_OF_SearchSpaceId = -1;
static gint ett_nr_rrc_T_downlinkPreemption = -1;
static gint ett_nr_rrc_T_tpc_PUSCH = -1;
static gint ett_nr_rrc_T_tpc_PUCCH = -1;
static gint ett_nr_rrc_T_tpc_SRS = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_2_OF_ControlResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_5_OF_ControlResourceSetId_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_10_OF_SearchSpaceExt_r16 = -1;
static gint ett_nr_rrc_T_uplinkCancellation_r16 = -1;
static gint ett_nr_rrc_SearchSpaceSwitchConfig_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_4_OF_CellGroupForSwitch_r16 = -1;
static gint ett_nr_rrc_CellGroupForSwitch_r16 = -1;
static gint ett_nr_rrc_PDCCH_ConfigCommon = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_4_OF_SearchSpace = -1;
static gint ett_nr_rrc_T_firstPDCCH_MonitoringOccasionOfPO_01 = -1;
static gint ett_nr_rrc_T_sCS15KHZoneT_01 = -1;
static gint ett_nr_rrc_T_sCS30KHZoneT_SCS15KHZhalfT_01 = -1;
static gint ett_nr_rrc_T_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT_01 = -1;
static gint ett_nr_rrc_T_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT_01 = -1;
static gint ett_nr_rrc_T_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT_01 = -1;
static gint ett_nr_rrc_T_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT_01 = -1;
static gint ett_nr_rrc_T_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT_01 = -1;
static gint ett_nr_rrc_T_sCS120KHZoneSixteenthT_01 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_4_OF_SearchSpaceExt_r16 = -1;
static gint ett_nr_rrc_PDCCH_ConfigSIB1 = -1;
static gint ett_nr_rrc_PDCCH_ServingCellConfig = -1;
static gint ett_nr_rrc_T_slotFormatIndicator = -1;
static gint ett_nr_rrc_T_availabilityIndicator_r16 = -1;
static gint ett_nr_rrc_PDCP_Config = -1;
static gint ett_nr_rrc_T_drb = -1;
static gint ett_nr_rrc_T_headerCompression = -1;
static gint ett_nr_rrc_T_rohc = -1;
static gint ett_nr_rrc_T_profiles = -1;
static gint ett_nr_rrc_T_uplinkOnlyROHC = -1;
static gint ett_nr_rrc_T_profiles_01 = -1;
static gint ett_nr_rrc_T_moreThanOneRLC = -1;
static gint ett_nr_rrc_T_primaryPath = -1;
static gint ett_nr_rrc_T_discardTimerExt_r16 = -1;
static gint ett_nr_rrc_T_moreThanTwoRLC_DRB_r16 = -1;
static gint ett_nr_rrc_T_duplicationState_r16 = -1;
static gint ett_nr_rrc_T_ethernetHeaderCompression_r16 = -1;
static gint ett_nr_rrc_EthernetHeaderCompression_r16 = -1;
static gint ett_nr_rrc_T_ehc_Common_r16 = -1;
static gint ett_nr_rrc_T_ehc_Downlink_r16 = -1;
static gint ett_nr_rrc_T_ehc_Uplink_r16 = -1;
static gint ett_nr_rrc_PDSCH_Config = -1;
static gint ett_nr_rrc_T_dmrs_DownlinkForPDSCH_MappingTypeA = -1;
static gint ett_nr_rrc_T_dmrs_DownlinkForPDSCH_MappingTypeB = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofTCI_States_OF_TCI_State = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofTCI_States_OF_TCI_StateId = -1;
static gint ett_nr_rrc_T_pdsch_TimeDomainAllocationList = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofRateMatchPatterns_OF_RateMatchPattern = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofRateMatchPatterns_OF_RateMatchPatternId = -1;
static gint ett_nr_rrc_T_prb_BundlingType = -1;
static gint ett_nr_rrc_T_staticBundling = -1;
static gint ett_nr_rrc_T_dynamicBundling = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_Resources_OF_ZP_CSI_RS_Resource = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_Resources_OF_ZP_CSI_RS_ResourceId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_ResourceSets_OF_ZP_CSI_RS_ResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_ResourceSets_OF_ZP_CSI_RS_ResourceSetId = -1;
static gint ett_nr_rrc_T_p_ZP_CSI_RS_ResourceSet = -1;
static gint ett_nr_rrc_T_maxMIMO_Layers_r16 = -1;
static gint ett_nr_rrc_T_minimumSchedulingOffsetK0_r16 = -1;
static gint ett_nr_rrc_T_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16 = -1;
static gint ett_nr_rrc_T_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16 = -1;
static gint ett_nr_rrc_T_pdsch_TimeDomainAllocationListDCI_1_2_r16 = -1;
static gint ett_nr_rrc_T_prb_BundlingTypeDCI_1_2_r16 = -1;
static gint ett_nr_rrc_T_staticBundling_r16 = -1;
static gint ett_nr_rrc_T_dynamicBundling_r16 = -1;
static gint ett_nr_rrc_T_pdsch_TimeDomainAllocationList_r16 = -1;
static gint ett_nr_rrc_T_repetitionSchemeConfig_r16 = -1;
static gint ett_nr_rrc_T_repetitionSchemeConfig_v1630 = -1;
static gint ett_nr_rrc_RateMatchPatternGroup = -1;
static gint ett_nr_rrc_RateMatchPatternGroup_item = -1;
static gint ett_nr_rrc_MinSchedulingOffsetK0_Values_r16 = -1;
static gint ett_nr_rrc_PDSCH_ConfigCommon = -1;
static gint ett_nr_rrc_PDSCH_ServingCellConfig = -1;
static gint ett_nr_rrc_T_codeBlockGroupTransmission = -1;
static gint ett_nr_rrc_T_pdsch_CodeBlockGroupTransmissionList_r16 = -1;
static gint ett_nr_rrc_PDSCH_CodeBlockGroupTransmission = -1;
static gint ett_nr_rrc_PDSCH_CodeBlockGroupTransmissionList_r16 = -1;
static gint ett_nr_rrc_PDSCH_TimeDomainResourceAllocationList = -1;
static gint ett_nr_rrc_PDSCH_TimeDomainResourceAllocation = -1;
static gint ett_nr_rrc_PDSCH_TimeDomainResourceAllocationList_r16 = -1;
static gint ett_nr_rrc_PDSCH_TimeDomainResourceAllocation_r16 = -1;
static gint ett_nr_rrc_PHR_Config = -1;
static gint ett_nr_rrc_T_mpe_Reporting_FR2_r16 = -1;
static gint ett_nr_rrc_MPE_Config_FR2_r16 = -1;
static gint ett_nr_rrc_PhysicalCellGroupConfig = -1;
static gint ett_nr_rrc_T_cs_RNTI = -1;
static gint ett_nr_rrc_T_pdcch_BlindDetection = -1;
static gint ett_nr_rrc_T_dcp_Config_r16 = -1;
static gint ett_nr_rrc_T_pdsch_HARQ_ACK_CodebookList_r16 = -1;
static gint ett_nr_rrc_T_pdcch_BlindDetectionCA_CombIndicator_r16 = -1;
static gint ett_nr_rrc_T_pdcch_BlindDetection2_r16 = -1;
static gint ett_nr_rrc_T_pdcch_BlindDetection3_r16 = -1;
static gint ett_nr_rrc_DCP_Config_r16 = -1;
static gint ett_nr_rrc_PDSCH_HARQ_ACK_CodebookList_r16 = -1;
static gint ett_nr_rrc_PDCCH_BlindDetectionCA_CombIndicator_r16 = -1;
static gint ett_nr_rrc_PLMN_Identity = -1;
static gint ett_nr_rrc_MCC = -1;
static gint ett_nr_rrc_MNC = -1;
static gint ett_nr_rrc_PLMN_IdentityInfoList = -1;
static gint ett_nr_rrc_PLMN_IdentityInfo = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxPLMN_OF_PLMN_Identity = -1;
static gint ett_nr_rrc_PLMN_IdentityList2_r16 = -1;
static gint ett_nr_rrc_PTRS_DownlinkConfig = -1;
static gint ett_nr_rrc_T_frequencyDensity = -1;
static gint ett_nr_rrc_T_timeDensity = -1;
static gint ett_nr_rrc_PTRS_UplinkConfig = -1;
static gint ett_nr_rrc_T_transformPrecoderDisabled = -1;
static gint ett_nr_rrc_T_frequencyDensity_01 = -1;
static gint ett_nr_rrc_T_timeDensity_01 = -1;
static gint ett_nr_rrc_T_transformPrecoderEnabled = -1;
static gint ett_nr_rrc_T_sampleDensity = -1;
static gint ett_nr_rrc_PUCCH_Config = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPUCCH_ResourceSets_OF_PUCCH_ResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPUCCH_ResourceSets_OF_PUCCH_ResourceSetId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPUCCH_Resources_OF_PUCCH_Resource = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPUCCH_Resources_OF_PUCCH_ResourceId = -1;
static gint ett_nr_rrc_T_format1 = -1;
static gint ett_nr_rrc_T_format2 = -1;
static gint ett_nr_rrc_T_format3 = -1;
static gint ett_nr_rrc_T_format4 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSR_Resources_OF_SchedulingRequestResourceConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSR_Resources_OF_SchedulingRequestResourceId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_2_OF_PUCCH_ResourceId = -1;
static gint ett_nr_rrc_T_dl_DataToUL_ACK = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSpatialRelationInfos_OF_PUCCH_SpatialRelationInfo = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSpatialRelationInfos_OF_PUCCH_SpatialRelationInfoId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPUCCH_Resources_OF_PUCCH_ResourceExt_v1610 = -1;
static gint ett_nr_rrc_T_dl_DataToUL_ACK_r16 = -1;
static gint ett_nr_rrc_T_ul_AccessConfigListDCI_1_1_r16 = -1;
static gint ett_nr_rrc_T_subslotLengthForPUCCH_r16 = -1;
static gint ett_nr_rrc_T_dl_DataToUL_ACK_DCI_1_2_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSpatialRelationInfosDiff_r16_OF_PUCCH_SpatialRelationInfo = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSpatialRelationInfosDiff_r16_OF_PUCCH_SpatialRelationInfoId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSpatialRelationInfos_r16_OF_PUCCH_SpatialRelationInfoExt_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSpatialRelationInfos_r16_OF_PUCCH_SpatialRelationInfoId_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPUCCH_ResourceGroups_r16_OF_PUCCH_ResourceGroup_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPUCCH_ResourceGroups_r16_OF_PUCCH_ResourceGroupId_r16 = -1;
static gint ett_nr_rrc_T_sps_PUCCH_AN_List_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSR_Resources_OF_SchedulingRequestResourceConfigExt_v1610 = -1;
static gint ett_nr_rrc_PUCCH_FormatConfig = -1;
static gint ett_nr_rrc_PUCCH_ResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPUCCH_ResourcesPerSet_OF_PUCCH_ResourceId = -1;
static gint ett_nr_rrc_PUCCH_Resource = -1;
static gint ett_nr_rrc_T_format = -1;
static gint ett_nr_rrc_PUCCH_ResourceExt_v1610 = -1;
static gint ett_nr_rrc_T_interlaceAllocation_r16 = -1;
static gint ett_nr_rrc_T_interlace0 = -1;
static gint ett_nr_rrc_T_format_v1610 = -1;
static gint ett_nr_rrc_T_occ_v1610 = -1;
static gint ett_nr_rrc_PUCCH_format0 = -1;
static gint ett_nr_rrc_PUCCH_format1 = -1;
static gint ett_nr_rrc_PUCCH_format2 = -1;
static gint ett_nr_rrc_PUCCH_format3 = -1;
static gint ett_nr_rrc_PUCCH_format4 = -1;
static gint ett_nr_rrc_PUCCH_ResourceGroup_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPUCCH_ResourcesPerGroup_r16_OF_PUCCH_ResourceId = -1;
static gint ett_nr_rrc_DL_DataToUL_ACK_r16 = -1;
static gint ett_nr_rrc_DL_DataToUL_ACK_DCI_1_2_r16 = -1;
static gint ett_nr_rrc_UL_AccessConfigListDCI_1_1_r16 = -1;
static gint ett_nr_rrc_PUCCH_ConfigCommon = -1;
static gint ett_nr_rrc_PUCCH_ConfigurationList_r16 = -1;
static gint ett_nr_rrc_PUCCH_PowerControl = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPUCCH_P0_PerSet_OF_P0_PUCCH = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPUCCH_PathlossReferenceRSs_OF_PUCCH_PathlossReferenceRS = -1;
static gint ett_nr_rrc_T_pathlossReferenceRSs_v1610 = -1;
static gint ett_nr_rrc_P0_PUCCH = -1;
static gint ett_nr_rrc_PathlossReferenceRSs_v1610 = -1;
static gint ett_nr_rrc_PUCCH_PathlossReferenceRS = -1;
static gint ett_nr_rrc_T_referenceSignal = -1;
static gint ett_nr_rrc_PUCCH_PathlossReferenceRS_r16 = -1;
static gint ett_nr_rrc_T_referenceSignal_r16 = -1;
static gint ett_nr_rrc_PUCCH_SpatialRelationInfo = -1;
static gint ett_nr_rrc_T_referenceSignal_01 = -1;
static gint ett_nr_rrc_PUCCH_SpatialRelationInfoExt_r16 = -1;
static gint ett_nr_rrc_PUCCH_SRS = -1;
static gint ett_nr_rrc_PUCCH_TPC_CommandConfig = -1;
static gint ett_nr_rrc_PUSCH_Config = -1;
static gint ett_nr_rrc_T_dmrs_UplinkForPUSCH_MappingTypeA = -1;
static gint ett_nr_rrc_T_dmrs_UplinkForPUSCH_MappingTypeB = -1;
static gint ett_nr_rrc_T_frequencyHoppingOffsetLists = -1;
static gint ett_nr_rrc_T_pusch_TimeDomainAllocationList = -1;
static gint ett_nr_rrc_T_uci_OnPUSCH_01 = -1;
static gint ett_nr_rrc_T_minimumSchedulingOffsetK2_r16 = -1;
static gint ett_nr_rrc_T_ul_AccessConfigListDCI_0_1_r16 = -1;
static gint ett_nr_rrc_T_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16 = -1;
static gint ett_nr_rrc_T_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16 = -1;
static gint ett_nr_rrc_T_frequencyHoppingDCI_0_2_r16 = -1;
static gint ett_nr_rrc_T_frequencyHoppingOffsetListsDCI_0_2_r16 = -1;
static gint ett_nr_rrc_T_uci_OnPUSCH_ListDCI_0_2_r16 = -1;
static gint ett_nr_rrc_T_pusch_TimeDomainAllocationListDCI_0_2_r16 = -1;
static gint ett_nr_rrc_T_pusch_TimeDomainAllocationListDCI_0_1_r16 = -1;
static gint ett_nr_rrc_T_uci_OnPUSCH_ListDCI_0_1_r16 = -1;
static gint ett_nr_rrc_T_pusch_PowerControl_v1610 = -1;
static gint ett_nr_rrc_T_pusch_TimeDomainAllocationListForMultiPUSCH_r16 = -1;
static gint ett_nr_rrc_UCI_OnPUSCH = -1;
static gint ett_nr_rrc_T_betaOffsets = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_4_OF_BetaOffsets = -1;
static gint ett_nr_rrc_MinSchedulingOffsetK2_Values_r16 = -1;
static gint ett_nr_rrc_UCI_OnPUSCH_DCI_0_2_r16 = -1;
static gint ett_nr_rrc_T_betaOffsetsDCI_0_2_r16 = -1;
static gint ett_nr_rrc_T_dynamicDCI_0_2_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_2_OF_BetaOffsets = -1;
static gint ett_nr_rrc_FrequencyHoppingOffsetListsDCI_0_2_r16 = -1;
static gint ett_nr_rrc_UCI_OnPUSCH_ListDCI_0_2_r16 = -1;
static gint ett_nr_rrc_UCI_OnPUSCH_ListDCI_0_1_r16 = -1;
static gint ett_nr_rrc_UL_AccessConfigListDCI_0_1_r16 = -1;
static gint ett_nr_rrc_PUSCH_ConfigCommon = -1;
static gint ett_nr_rrc_PUSCH_PowerControl = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofP0_PUSCH_AlphaSets_OF_P0_PUSCH_AlphaSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPUSCH_PathlossReferenceRSs_OF_PUSCH_PathlossReferenceRS = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPUSCH_PathlossReferenceRSs_OF_PUSCH_PathlossReferenceRS_Id = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSRI_PUSCH_Mappings_OF_SRI_PUSCH_PowerControl = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSRI_PUSCH_Mappings_OF_SRI_PUSCH_PowerControlId = -1;
static gint ett_nr_rrc_P0_PUSCH_AlphaSet = -1;
static gint ett_nr_rrc_PUSCH_PathlossReferenceRS = -1;
static gint ett_nr_rrc_T_referenceSignal_02 = -1;
static gint ett_nr_rrc_PUSCH_PathlossReferenceRS_r16 = -1;
static gint ett_nr_rrc_T_referenceSignal_r16_01 = -1;
static gint ett_nr_rrc_SRI_PUSCH_PowerControl = -1;
static gint ett_nr_rrc_PUSCH_PowerControl_v1610 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPUSCH_PathlossReferenceRSsDiff_r16_OF_PUSCH_PathlossReferenceRS_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPUSCH_PathlossReferenceRSsDiff_r16_OF_PUSCH_PathlossReferenceRS_Id_v1610 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSRI_PUSCH_Mappings_OF_P0_PUSCH_Set_r16 = -1;
static gint ett_nr_rrc_T_olpc_ParameterSet = -1;
static gint ett_nr_rrc_P0_PUSCH_Set_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofP0_PUSCH_Set_r16_OF_P0_PUSCH_r16 = -1;
static gint ett_nr_rrc_PUSCH_ServingCellConfig = -1;
static gint ett_nr_rrc_T_codeBlockGroupTransmission_01 = -1;
static gint ett_nr_rrc_T_maxMIMO_LayersDCI_0_2_r16 = -1;
static gint ett_nr_rrc_PUSCH_CodeBlockGroupTransmission = -1;
static gint ett_nr_rrc_PUSCH_TimeDomainResourceAllocationList = -1;
static gint ett_nr_rrc_PUSCH_TimeDomainResourceAllocation = -1;
static gint ett_nr_rrc_PUSCH_TimeDomainResourceAllocationList_r16 = -1;
static gint ett_nr_rrc_PUSCH_TimeDomainResourceAllocation_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofMultiplePUSCHs_r16_OF_PUSCH_Allocation_r16 = -1;
static gint ett_nr_rrc_PUSCH_Allocation_r16 = -1;
static gint ett_nr_rrc_PUSCH_TPC_CommandConfig = -1;
static gint ett_nr_rrc_QuantityConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofQuantityConfig_OF_QuantityConfigNR = -1;
static gint ett_nr_rrc_QuantityConfigNR = -1;
static gint ett_nr_rrc_QuantityConfigRS = -1;
static gint ett_nr_rrc_FilterConfig = -1;
static gint ett_nr_rrc_FilterConfigCLI_r16 = -1;
static gint ett_nr_rrc_QuantityConfigUTRA_FDD_r16 = -1;
static gint ett_nr_rrc_RACH_ConfigCommon = -1;
static gint ett_nr_rrc_T_ssb_perRACH_OccasionAndCB_PreamblesPerSSB = -1;
static gint ett_nr_rrc_T_groupBconfigured = -1;
static gint ett_nr_rrc_T_prach_RootSequenceIndex = -1;
static gint ett_nr_rrc_T_ra_PrioritizationForAccessIdentity_r16 = -1;
static gint ett_nr_rrc_T_prach_RootSequenceIndex_r16 = -1;
static gint ett_nr_rrc_RACH_ConfigCommonTwoStepRA_r16 = -1;
static gint ett_nr_rrc_T_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16 = -1;
static gint ett_nr_rrc_T_msgA_PRACH_RootSequenceIndex_r16 = -1;
static gint ett_nr_rrc_T_ra_PrioritizationForAccessIdentityTwoStep_r16 = -1;
static gint ett_nr_rrc_GroupB_ConfiguredTwoStepRA_r16 = -1;
static gint ett_nr_rrc_RACH_ConfigDedicated = -1;
static gint ett_nr_rrc_CFRA = -1;
static gint ett_nr_rrc_T_occasions = -1;
static gint ett_nr_rrc_T_resources = -1;
static gint ett_nr_rrc_T_ssb = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxRA_SSB_Resources_OF_CFRA_SSB_Resource = -1;
static gint ett_nr_rrc_T_csirs = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxRA_CSIRS_Resources_OF_CFRA_CSIRS_Resource = -1;
static gint ett_nr_rrc_CFRA_TwoStep_r16 = -1;
static gint ett_nr_rrc_T_occasionsTwoStepRA_r16 = -1;
static gint ett_nr_rrc_T_resourcesTwoStep_r16 = -1;
static gint ett_nr_rrc_CFRA_SSB_Resource = -1;
static gint ett_nr_rrc_CFRA_CSIRS_Resource = -1;
static gint ett_nr_rrc_T_ra_OccasionList_01 = -1;
static gint ett_nr_rrc_RACH_ConfigGeneric = -1;
static gint ett_nr_rrc_RACH_ConfigGenericTwoStepRA_r16 = -1;
static gint ett_nr_rrc_RA_Prioritization = -1;
static gint ett_nr_rrc_RadioBearerConfig = -1;
static gint ett_nr_rrc_SRB_ToAddModList = -1;
static gint ett_nr_rrc_SRB_ToAddMod = -1;
static gint ett_nr_rrc_DRB_ToAddModList = -1;
static gint ett_nr_rrc_DRB_ToAddMod = -1;
static gint ett_nr_rrc_T_cnAssociation = -1;
static gint ett_nr_rrc_DRB_ToReleaseList = -1;
static gint ett_nr_rrc_SecurityConfig = -1;
static gint ett_nr_rrc_RadioLinkMonitoringConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofFailureDetectionResources_OF_RadioLinkMonitoringRS = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofFailureDetectionResources_OF_RadioLinkMonitoringRS_Id = -1;
static gint ett_nr_rrc_RadioLinkMonitoringRS = -1;
static gint ett_nr_rrc_T_detectionResource = -1;
static gint ett_nr_rrc_RateMatchPattern = -1;
static gint ett_nr_rrc_T_patternType = -1;
static gint ett_nr_rrc_T_bitmaps = -1;
static gint ett_nr_rrc_T_symbolsInResourceBlock = -1;
static gint ett_nr_rrc_T_periodicityAndPattern = -1;
static gint ett_nr_rrc_RateMatchPatternLTE_CRS = -1;
static gint ett_nr_rrc_LTE_CRS_PatternList_r16 = -1;
static gint ett_nr_rrc_ReferenceTimeInfo_r16 = -1;
static gint ett_nr_rrc_ReferenceTime_r16 = -1;
static gint ett_nr_rrc_RepetitionSchemeConfig_r16 = -1;
static gint ett_nr_rrc_T_fdm_TDM_r16 = -1;
static gint ett_nr_rrc_T_slotBased_r16 = -1;
static gint ett_nr_rrc_RepetitionSchemeConfig_v1630 = -1;
static gint ett_nr_rrc_T_slotBased_v1630 = -1;
static gint ett_nr_rrc_FDM_TDM_r16 = -1;
static gint ett_nr_rrc_SlotBased_r16 = -1;
static gint ett_nr_rrc_SlotBased_v1630 = -1;
static gint ett_nr_rrc_ReportConfigInterRAT = -1;
static gint ett_nr_rrc_T_reportType_01 = -1;
static gint ett_nr_rrc_ReportCGI_EUTRA = -1;
static gint ett_nr_rrc_ReportSFTD_EUTRA = -1;
static gint ett_nr_rrc_EventTriggerConfigInterRAT = -1;
static gint ett_nr_rrc_T_eventId = -1;
static gint ett_nr_rrc_T_eventB1 = -1;
static gint ett_nr_rrc_T_eventB2 = -1;
static gint ett_nr_rrc_T_eventB1_UTRA_FDD_r16 = -1;
static gint ett_nr_rrc_T_eventB2_UTRA_FDD_r16 = -1;
static gint ett_nr_rrc_T_includeBT_Meas_r16 = -1;
static gint ett_nr_rrc_T_includeWLAN_Meas_r16 = -1;
static gint ett_nr_rrc_T_includeSensor_Meas_r16 = -1;
static gint ett_nr_rrc_PeriodicalReportConfigInterRAT = -1;
static gint ett_nr_rrc_T_includeBT_Meas_r16_01 = -1;
static gint ett_nr_rrc_T_includeWLAN_Meas_r16_01 = -1;
static gint ett_nr_rrc_T_includeSensor_Meas_r16_01 = -1;
static gint ett_nr_rrc_MeasTriggerQuantityUTRA_FDD_r16 = -1;
static gint ett_nr_rrc_MeasReportQuantityUTRA_FDD_r16 = -1;
static gint ett_nr_rrc_ReportConfigNR = -1;
static gint ett_nr_rrc_T_reportType_02 = -1;
static gint ett_nr_rrc_ReportCGI = -1;
static gint ett_nr_rrc_ReportSFTD_NR = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxCellSFTD_OF_PhysCellId = -1;
static gint ett_nr_rrc_CondTriggerConfig_r16 = -1;
static gint ett_nr_rrc_T_condEventId = -1;
static gint ett_nr_rrc_T_condEventA3 = -1;
static gint ett_nr_rrc_T_condEventA5 = -1;
static gint ett_nr_rrc_EventTriggerConfig = -1;
static gint ett_nr_rrc_T_eventId_01 = -1;
static gint ett_nr_rrc_T_eventA1 = -1;
static gint ett_nr_rrc_T_eventA2 = -1;
static gint ett_nr_rrc_T_eventA3 = -1;
static gint ett_nr_rrc_T_eventA4 = -1;
static gint ett_nr_rrc_T_eventA5 = -1;
static gint ett_nr_rrc_T_eventA6 = -1;
static gint ett_nr_rrc_T_includeBT_Meas_r16_02 = -1;
static gint ett_nr_rrc_T_includeWLAN_Meas_r16_02 = -1;
static gint ett_nr_rrc_T_includeSensor_Meas_r16_02 = -1;
static gint ett_nr_rrc_PeriodicalReportConfig = -1;
static gint ett_nr_rrc_T_includeBT_Meas_r16_03 = -1;
static gint ett_nr_rrc_T_includeWLAN_Meas_r16_03 = -1;
static gint ett_nr_rrc_T_includeSensor_Meas_r16_03 = -1;
static gint ett_nr_rrc_T_ul_DelayValueConfig_r16 = -1;
static gint ett_nr_rrc_MeasTriggerQuantity = -1;
static gint ett_nr_rrc_MeasTriggerQuantityOffset = -1;
static gint ett_nr_rrc_MeasReportQuantity = -1;
static gint ett_nr_rrc_MeasRSSI_ReportConfig_r16 = -1;
static gint ett_nr_rrc_CLI_EventTriggerConfig_r16 = -1;
static gint ett_nr_rrc_T_eventId_r16 = -1;
static gint ett_nr_rrc_T_eventI1_r16 = -1;
static gint ett_nr_rrc_CLI_PeriodicalReportConfig_r16 = -1;
static gint ett_nr_rrc_MeasTriggerQuantityCLI_r16 = -1;
static gint ett_nr_rrc_ReportConfigNR_SL_r16 = -1;
static gint ett_nr_rrc_T_reportType_r16 = -1;
static gint ett_nr_rrc_EventTriggerConfigNR_SL_r16 = -1;
static gint ett_nr_rrc_T_eventId_r16_01 = -1;
static gint ett_nr_rrc_T_eventC1 = -1;
static gint ett_nr_rrc_T_eventC2_r16 = -1;
static gint ett_nr_rrc_PeriodicalReportConfigNR_SL_r16 = -1;
static gint ett_nr_rrc_MeasReportQuantity_r16 = -1;
static gint ett_nr_rrc_ReportConfigToAddModList = -1;
static gint ett_nr_rrc_ReportConfigToAddMod = -1;
static gint ett_nr_rrc_T_reportConfig = -1;
static gint ett_nr_rrc_RLC_BearerConfig = -1;
static gint ett_nr_rrc_T_servedRadioBearer = -1;
static gint ett_nr_rrc_RLC_Config = -1;
static gint ett_nr_rrc_T_am = -1;
static gint ett_nr_rrc_T_um_Bi_Directional = -1;
static gint ett_nr_rrc_T_um_Uni_Directional_UL = -1;
static gint ett_nr_rrc_T_um_Uni_Directional_DL = -1;
static gint ett_nr_rrc_UL_AM_RLC = -1;
static gint ett_nr_rrc_DL_AM_RLC = -1;
static gint ett_nr_rrc_UL_UM_RLC = -1;
static gint ett_nr_rrc_DL_UM_RLC = -1;
static gint ett_nr_rrc_RLC_Config_v1610 = -1;
static gint ett_nr_rrc_DL_AM_RLC_v1610 = -1;
static gint ett_nr_rrc_RLF_TimersAndConstants = -1;
static gint ett_nr_rrc_SchedulingRequestConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSR_ConfigPerCellGroup_OF_SchedulingRequestToAddMod = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSR_ConfigPerCellGroup_OF_SchedulingRequestId = -1;
static gint ett_nr_rrc_SchedulingRequestToAddMod = -1;
static gint ett_nr_rrc_SchedulingRequestResourceConfig = -1;
static gint ett_nr_rrc_T_periodicityAndOffset = -1;
static gint ett_nr_rrc_SchedulingRequestResourceConfigExt_v1610 = -1;
static gint ett_nr_rrc_SCS_SpecificCarrier = -1;
static gint ett_nr_rrc_SDAP_Config = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofQFIs_OF_QFI = -1;
static gint ett_nr_rrc_SearchSpace = -1;
static gint ett_nr_rrc_T_monitoringSlotPeriodicityAndOffset = -1;
static gint ett_nr_rrc_T_nrofCandidates = -1;
static gint ett_nr_rrc_T_searchSpaceType = -1;
static gint ett_nr_rrc_T_common = -1;
static gint ett_nr_rrc_T_dci_Format0_0_AndFormat1_0 = -1;
static gint ett_nr_rrc_T_dci_Format2_0 = -1;
static gint ett_nr_rrc_T_nrofCandidates_SFI = -1;
static gint ett_nr_rrc_T_dci_Format2_1 = -1;
static gint ett_nr_rrc_T_dci_Format2_2 = -1;
static gint ett_nr_rrc_T_dci_Format2_3 = -1;
static gint ett_nr_rrc_T_ue_Specific = -1;
static gint ett_nr_rrc_SearchSpaceExt_r16 = -1;
static gint ett_nr_rrc_T_searchSpaceType_r16 = -1;
static gint ett_nr_rrc_T_common_r16 = -1;
static gint ett_nr_rrc_T_dci_Format2_4_r16 = -1;
static gint ett_nr_rrc_T_nrofCandidates_CI_r16 = -1;
static gint ett_nr_rrc_T_dci_Format2_5_r16 = -1;
static gint ett_nr_rrc_T_nrofCandidates_IAB_r16 = -1;
static gint ett_nr_rrc_T_dci_Format2_6_r16 = -1;
static gint ett_nr_rrc_T_searchSpaceGroupIdList_r16 = -1;
static gint ett_nr_rrc_SecurityAlgorithmConfig = -1;
static gint ett_nr_rrc_SemiStaticChannelAccessConfig_r16 = -1;
static gint ett_nr_rrc_Sensor_LocationInfo_r16 = -1;
static gint ett_nr_rrc_ServingCellConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofBWPs_OF_BWP_Id = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofBWPs_OF_BWP_Downlink = -1;
static gint ett_nr_rrc_T_pdcch_ServingCellConfig = -1;
static gint ett_nr_rrc_T_pdsch_ServingCellConfig = -1;
static gint ett_nr_rrc_T_csi_MeasConfig = -1;
static gint ett_nr_rrc_T_lte_CRS_ToMatchAround = -1;
static gint ett_nr_rrc_T_dormantBWP_Config_r16 = -1;
static gint ett_nr_rrc_T_ca_SlotOffset_r16 = -1;
static gint ett_nr_rrc_T_servingCellConfig_eag_2_dummy2 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxSCSs_OF_IntraCellGuardBandsPerSCS_r16 = -1;
static gint ett_nr_rrc_T_lte_CRS_PatternList1_r16 = -1;
static gint ett_nr_rrc_T_lte_CRS_PatternList2_r16 = -1;
static gint ett_nr_rrc_T_channelAccessConfig_r16 = -1;
static gint ett_nr_rrc_UplinkConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofBWPs_OF_BWP_Uplink = -1;
static gint ett_nr_rrc_T_pusch_ServingCellConfig = -1;
static gint ett_nr_rrc_T_carrierSwitching = -1;
static gint ett_nr_rrc_T_uplinkTxSwitching_r16 = -1;
static gint ett_nr_rrc_DummyJ = -1;
static gint ett_nr_rrc_ChannelAccessConfig_r16 = -1;
static gint ett_nr_rrc_T_energyDetectionConfig_r16 = -1;
static gint ett_nr_rrc_IntraCellGuardBandsPerSCS_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_4_OF_GuardBand_r16 = -1;
static gint ett_nr_rrc_GuardBand_r16 = -1;
static gint ett_nr_rrc_DormantBWP_Config_r16 = -1;
static gint ett_nr_rrc_T_withinActiveTimeConfig_r16 = -1;
static gint ett_nr_rrc_T_outsideActiveTimeConfig_r16 = -1;
static gint ett_nr_rrc_WithinActiveTimeConfig_r16 = -1;
static gint ett_nr_rrc_OutsideActiveTimeConfig_r16 = -1;
static gint ett_nr_rrc_UplinkTxSwitching_r16 = -1;
static gint ett_nr_rrc_ServingCellConfigCommon = -1;
static gint ett_nr_rrc_T_ssb_PositionsInBurst = -1;
static gint ett_nr_rrc_T_lte_CRS_ToMatchAround_01 = -1;
static gint ett_nr_rrc_T_channelAccessMode_r16 = -1;
static gint ett_nr_rrc_ServingCellConfigCommonSIB = -1;
static gint ett_nr_rrc_T_ssb_PositionsInBurst_01 = -1;
static gint ett_nr_rrc_T_channelAccessMode_r16_01 = -1;
static gint ett_nr_rrc_SI_RequestConfig = -1;
static gint ett_nr_rrc_T_rach_OccasionsSI = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxSI_Message_OF_SI_RequestResources = -1;
static gint ett_nr_rrc_SI_RequestResources = -1;
static gint ett_nr_rrc_SI_SchedulingInfo = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxSI_Message_OF_SchedulingInfo = -1;
static gint ett_nr_rrc_SchedulingInfo = -1;
static gint ett_nr_rrc_SIB_Mapping = -1;
static gint ett_nr_rrc_SIB_TypeInfo = -1;
static gint ett_nr_rrc_SlotFormatCombinationsPerCell = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSlotFormatCombinationsPerSet_OF_SlotFormatCombination = -1;
static gint ett_nr_rrc_SlotFormatCombination = -1;
static gint ett_nr_rrc_T_slotFormats = -1;
static gint ett_nr_rrc_SlotFormatIndicator = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroup_OF_SlotFormatCombinationsPerCell = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroup_OF_ServCellIndex = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroup_OF_AvailableRB_SetsPerCell_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_4_OF_SearchSpaceSwitchTrigger_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_4_OF_ServCellIndex = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroup_OF_CO_DurationsPerCell_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroupMinus4_r16_OF_SearchSpaceSwitchTrigger_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroupMinus4_r16_OF_ServCellIndex = -1;
static gint ett_nr_rrc_CO_DurationsPerCell_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_64_OF_CO_Duration_r16 = -1;
static gint ett_nr_rrc_AvailableRB_SetsPerCell_r16 = -1;
static gint ett_nr_rrc_SearchSpaceSwitchTrigger_r16 = -1;
static gint ett_nr_rrc_S_NSSAI = -1;
static gint ett_nr_rrc_SpeedStateScaleFactors = -1;
static gint ett_nr_rrc_SPS_Config = -1;
static gint ett_nr_rrc_SPS_PUCCH_AN_r16 = -1;
static gint ett_nr_rrc_SPS_PUCCH_AN_List_r16 = -1;
static gint ett_nr_rrc_SRS_CarrierSwitching = -1;
static gint ett_nr_rrc_T_srs_TPC_PDCCH_Group = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_32_OF_SRS_TPC_PDCCH_Config = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofServingCells_OF_ServCellIndex = -1;
static gint ett_nr_rrc_SRS_TPC_PDCCH_Config = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_4_OF_SRS_CC_SetIndex = -1;
static gint ett_nr_rrc_SRS_CC_SetIndex = -1;
static gint ett_nr_rrc_SRS_Config = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSRS_ResourceSets_OF_SRS_ResourceSetId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSRS_ResourceSets_OF_SRS_ResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSRS_Resources_OF_SRS_ResourceId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSRS_Resources_OF_SRS_Resource = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSRS_PosResourceSets_r16_OF_SRS_PosResourceSetId_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSRS_PosResourceSets_r16_OF_SRS_PosResourceSet_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSRS_PosResources_r16_OF_SRS_PosResourceId_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSRS_PosResources_r16_OF_SRS_PosResource_r16 = -1;
static gint ett_nr_rrc_SRS_ResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSRS_ResourcesPerSet_OF_SRS_ResourceId = -1;
static gint ett_nr_rrc_T_resourceType_01 = -1;
static gint ett_nr_rrc_T_aperiodic_01 = -1;
static gint ett_nr_rrc_T_aperiodicSRS_ResourceTriggerList = -1;
static gint ett_nr_rrc_T_semi_persistent = -1;
static gint ett_nr_rrc_T_periodic_01 = -1;
static gint ett_nr_rrc_T_pathlossReferenceRSList_r16 = -1;
static gint ett_nr_rrc_PathlossReferenceRS_Config = -1;
static gint ett_nr_rrc_PathlossReferenceRSList_r16 = -1;
static gint ett_nr_rrc_PathlossReferenceRS_r16 = -1;
static gint ett_nr_rrc_SRS_PosResourceSet_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSRS_ResourcesPerSet_OF_SRS_PosResourceId_r16 = -1;
static gint ett_nr_rrc_T_resourceType_r16 = -1;
static gint ett_nr_rrc_T_aperiodic_r16 = -1;
static gint ett_nr_rrc_T_aperiodicSRS_ResourceTriggerList_r16 = -1;
static gint ett_nr_rrc_T_semi_persistent_r16 = -1;
static gint ett_nr_rrc_T_periodic_r16 = -1;
static gint ett_nr_rrc_T_pathlossReferenceRS_Pos_r16 = -1;
static gint ett_nr_rrc_SRS_Resource = -1;
static gint ett_nr_rrc_T_transmissionComb = -1;
static gint ett_nr_rrc_T_n2 = -1;
static gint ett_nr_rrc_T_n4 = -1;
static gint ett_nr_rrc_T_resourceMapping = -1;
static gint ett_nr_rrc_T_freqHopping = -1;
static gint ett_nr_rrc_T_resourceType_02 = -1;
static gint ett_nr_rrc_T_aperiodic_02 = -1;
static gint ett_nr_rrc_T_semi_persistent_01 = -1;
static gint ett_nr_rrc_T_periodic_02 = -1;
static gint ett_nr_rrc_T_resourceMapping_r16 = -1;
static gint ett_nr_rrc_SRS_PosResource_r16 = -1;
static gint ett_nr_rrc_T_transmissionComb_r16 = -1;
static gint ett_nr_rrc_T_n2_r16 = -1;
static gint ett_nr_rrc_T_n4_r16 = -1;
static gint ett_nr_rrc_T_n8_r16 = -1;
static gint ett_nr_rrc_T_resourceMapping_r16_01 = -1;
static gint ett_nr_rrc_T_freqHopping_r16 = -1;
static gint ett_nr_rrc_T_resourceType_r16_01 = -1;
static gint ett_nr_rrc_T_aperiodic_r16_01 = -1;
static gint ett_nr_rrc_T_semi_persistent_r16_01 = -1;
static gint ett_nr_rrc_T_periodic_r16_01 = -1;
static gint ett_nr_rrc_SRS_SpatialRelationInfo = -1;
static gint ett_nr_rrc_T_referenceSignal_03 = -1;
static gint ett_nr_rrc_T_srs = -1;
static gint ett_nr_rrc_SRS_SpatialRelationInfoPos_r16 = -1;
static gint ett_nr_rrc_T_servingRS_r16 = -1;
static gint ett_nr_rrc_T_referenceSignal_r16_02 = -1;
static gint ett_nr_rrc_T_srs_SpatialRelation_r16 = -1;
static gint ett_nr_rrc_T_resourceSelection_r16 = -1;
static gint ett_nr_rrc_SSB_Configuration_r16 = -1;
static gint ett_nr_rrc_T_sfn0_Offset_r16 = -1;
static gint ett_nr_rrc_SSB_InfoNcell_r16 = -1;
static gint ett_nr_rrc_DL_PRS_Info_r16 = -1;
static gint ett_nr_rrc_SRS_PeriodicityAndOffset = -1;
static gint ett_nr_rrc_SRS_PeriodicityAndOffset_r16 = -1;
static gint ett_nr_rrc_SRS_TPC_CommandConfig = -1;
static gint ett_nr_rrc_SSB_MTC = -1;
static gint ett_nr_rrc_T_periodicityAndOffset_01 = -1;
static gint ett_nr_rrc_SSB_MTC2 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPCIsPerSMTC_OF_PhysCellId = -1;
static gint ett_nr_rrc_SSB_MTC2_LP_r16 = -1;
static gint ett_nr_rrc_SSB_MTC3_r16 = -1;
static gint ett_nr_rrc_T_periodicityAndOffset_r16 = -1;
static gint ett_nr_rrc_T_ssb_ToMeasure_r16 = -1;
static gint ett_nr_rrc_SSB_ToMeasure = -1;
static gint ett_nr_rrc_SS_RSSI_Measurement = -1;
static gint ett_nr_rrc_TAG_Config = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofTAGs_OF_TAG_Id = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofTAGs_OF_TAG = -1;
static gint ett_nr_rrc_TAG = -1;
static gint ett_nr_rrc_TCI_State = -1;
static gint ett_nr_rrc_QCL_Info = -1;
static gint ett_nr_rrc_T_referenceSignal_04 = -1;
static gint ett_nr_rrc_TDD_UL_DL_ConfigCommon = -1;
static gint ett_nr_rrc_TDD_UL_DL_Pattern = -1;
static gint ett_nr_rrc_TDD_UL_DL_ConfigDedicated = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSlots_OF_TDD_UL_DL_SlotConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSlots_OF_TDD_UL_DL_SlotIndex = -1;
static gint ett_nr_rrc_TDD_UL_DL_ConfigDedicated_IAB_MT_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSlots_OF_TDD_UL_DL_SlotConfig_IAB_MT_r16 = -1;
static gint ett_nr_rrc_TDD_UL_DL_SlotConfig = -1;
static gint ett_nr_rrc_T_symbols = -1;
static gint ett_nr_rrc_T_explicit = -1;
static gint ett_nr_rrc_TDD_UL_DL_SlotConfig_IAB_MT_r16 = -1;
static gint ett_nr_rrc_T_symbols_IAB_MT_r16 = -1;
static gint ett_nr_rrc_T_explicit_r16 = -1;
static gint ett_nr_rrc_T_explicit_IAB_MT_r16 = -1;
static gint ett_nr_rrc_UAC_BarringInfoSetList = -1;
static gint ett_nr_rrc_UAC_BarringInfoSet = -1;
static gint ett_nr_rrc_UAC_BarringPerCatList = -1;
static gint ett_nr_rrc_UAC_BarringPerCat = -1;
static gint ett_nr_rrc_UAC_BarringPerPLMN_List = -1;
static gint ett_nr_rrc_UAC_BarringPerPLMN = -1;
static gint ett_nr_rrc_T_uac_ACBarringListType = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_maxAccessCat_1_OF_UAC_BarringInfoSetIndex = -1;
static gint ett_nr_rrc_UE_TimersAndConstants = -1;
static gint ett_nr_rrc_UL_DelayValueConfig_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxDRB_OF_DRB_Identity = -1;
static gint ett_nr_rrc_UplinkCancellation_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofServingCells_OF_CI_ConfigurationPerServingCell_r16 = -1;
static gint ett_nr_rrc_CI_ConfigurationPerServingCell_r16 = -1;
static gint ett_nr_rrc_T_timeFrequencyRegion_r16 = -1;
static gint ett_nr_rrc_UplinkConfigCommon = -1;
static gint ett_nr_rrc_UplinkConfigCommonSIB = -1;
static gint ett_nr_rrc_UplinkTxDirectCurrentList = -1;
static gint ett_nr_rrc_UplinkTxDirectCurrentCell = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofBWPs_OF_UplinkTxDirectCurrentBWP = -1;
static gint ett_nr_rrc_UplinkTxDirectCurrentBWP = -1;
static gint ett_nr_rrc_UplinkTxDirectCurrentTwoCarrierList_r16 = -1;
static gint ett_nr_rrc_UplinkTxDirectCurrentTwoCarrier_r16 = -1;
static gint ett_nr_rrc_UplinkTxDirectCurrentCarrierInfo_r16 = -1;
static gint ett_nr_rrc_T_servCellInfo_r16 = -1;
static gint ett_nr_rrc_UplinkTxDirectCurrentTwoCarrierInfo_r16 = -1;
static gint ett_nr_rrc_ZP_CSI_RS_Resource = -1;
static gint ett_nr_rrc_ZP_CSI_RS_ResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_ResourcesPerSet_OF_ZP_CSI_RS_ResourceId = -1;
static gint ett_nr_rrc_BandCombinationList = -1;
static gint ett_nr_rrc_BandCombinationList_v1540 = -1;
static gint ett_nr_rrc_BandCombinationList_v1550 = -1;
static gint ett_nr_rrc_BandCombinationList_v1560 = -1;
static gint ett_nr_rrc_BandCombinationList_v1570 = -1;
static gint ett_nr_rrc_BandCombinationList_v1580 = -1;
static gint ett_nr_rrc_BandCombinationList_v1590 = -1;
static gint ett_nr_rrc_BandCombinationList_v15g0 = -1;
static gint ett_nr_rrc_BandCombinationList_v1610 = -1;
static gint ett_nr_rrc_BandCombinationList_v1630 = -1;
static gint ett_nr_rrc_BandCombinationList_v1640 = -1;
static gint ett_nr_rrc_BandCombinationList_v1650 = -1;
static gint ett_nr_rrc_BandCombinationList_v1680 = -1;
static gint ett_nr_rrc_BandCombinationList_UplinkTxSwitch_r16 = -1;
static gint ett_nr_rrc_BandCombinationList_UplinkTxSwitch_v1630 = -1;
static gint ett_nr_rrc_BandCombinationList_UplinkTxSwitch_v1640 = -1;
static gint ett_nr_rrc_BandCombinationList_UplinkTxSwitch_v1650 = -1;
static gint ett_nr_rrc_BandCombinationList_UplinkTxSwitch_v1670 = -1;
static gint ett_nr_rrc_BandCombination = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_OF_BandParameters = -1;
static gint ett_nr_rrc_BandCombination_v1540 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_OF_BandParameters_v1540 = -1;
static gint ett_nr_rrc_BandCombination_v1550 = -1;
static gint ett_nr_rrc_BandCombination_v1560 = -1;
static gint ett_nr_rrc_BandCombination_v1570 = -1;
static gint ett_nr_rrc_BandCombination_v1580 = -1;
static gint ett_nr_rrc_BandCombination_v1590 = -1;
static gint ett_nr_rrc_BandCombination_v15g0 = -1;
static gint ett_nr_rrc_BandCombination_v1610 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_OF_BandParameters_v1610 = -1;
static gint ett_nr_rrc_BandCombination_v1630 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxBandComb_OF_ScalingFactorSidelink_r16 = -1;
static gint ett_nr_rrc_BandCombination_v1640 = -1;
static gint ett_nr_rrc_BandCombination_v1650 = -1;
static gint ett_nr_rrc_BandCombination_v1680 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxBandComb_OF_IntraBandPowerClass_r16 = -1;
static gint ett_nr_rrc_BandCombination_UplinkTxSwitch_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxULTxSwitchingBandPairs_OF_ULTxSwitchingBandPair_r16 = -1;
static gint ett_nr_rrc_BandCombination_UplinkTxSwitch_v1630 = -1;
static gint ett_nr_rrc_BandCombination_UplinkTxSwitch_v1640 = -1;
static gint ett_nr_rrc_BandCombination_UplinkTxSwitch_v1650 = -1;
static gint ett_nr_rrc_BandCombination_UplinkTxSwitch_v1670 = -1;
static gint ett_nr_rrc_ULTxSwitchingBandPair_r16 = -1;
static gint ett_nr_rrc_BandParameters = -1;
static gint ett_nr_rrc_T_eutra = -1;
static gint ett_nr_rrc_T_nr = -1;
static gint ett_nr_rrc_BandParameters_v1540 = -1;
static gint ett_nr_rrc_T_srs_CarrierSwitch = -1;
static gint ett_nr_rrc_T_nr_01 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_OF_SRS_SwitchingTimeNR = -1;
static gint ett_nr_rrc_T_eutra_01 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_OF_SRS_SwitchingTimeEUTRA = -1;
static gint ett_nr_rrc_T_srs_TxSwitch = -1;
static gint ett_nr_rrc_BandParameters_v1610 = -1;
static gint ett_nr_rrc_T_srs_TxSwitch_v1610 = -1;
static gint ett_nr_rrc_BandCombinationListSidelinkEUTRA_NR_r16 = -1;
static gint ett_nr_rrc_BandCombinationListSidelinkEUTRA_NR_v1630 = -1;
static gint ett_nr_rrc_BandCombinationParametersSidelinkEUTRA_NR_r16 = -1;
static gint ett_nr_rrc_BandCombinationParametersSidelinkEUTRA_NR_v1630 = -1;
static gint ett_nr_rrc_BandParametersSidelinkEUTRA_NR_r16 = -1;
static gint ett_nr_rrc_T_eutra_02 = -1;
static gint ett_nr_rrc_T_nr_02 = -1;
static gint ett_nr_rrc_BandParametersSidelinkEUTRA_NR_v1630 = -1;
static gint ett_nr_rrc_T_nr_03 = -1;
static gint ett_nr_rrc_BandParametersSidelink_r16 = -1;
static gint ett_nr_rrc_CA_ParametersEUTRA = -1;
static gint ett_nr_rrc_CA_ParametersEUTRA_v1560 = -1;
static gint ett_nr_rrc_CA_ParametersEUTRA_v1570 = -1;
static gint ett_nr_rrc_CA_ParametersNR = -1;
static gint ett_nr_rrc_CA_ParametersNR_v1540 = -1;
static gint ett_nr_rrc_T_csi_RS_IM_ReceptionForFeedbackPerBandComb = -1;
static gint ett_nr_rrc_CA_ParametersNR_v1550 = -1;
static gint ett_nr_rrc_CA_ParametersNR_v1560 = -1;
static gint ett_nr_rrc_CA_ParametersNR_v15g0 = -1;
static gint ett_nr_rrc_CA_ParametersNR_v1610 = -1;
static gint ett_nr_rrc_T_interFreqDAPS_r16 = -1;
static gint ett_nr_rrc_T_pdcch_MonitoringCA_r16 = -1;
static gint ett_nr_rrc_T_pdcch_BlindDetectionCA_Mixed_r16 = -1;
static gint ett_nr_rrc_T_pdcch_BlindDetectionMCG_UE_Mixed_r16 = -1;
static gint ett_nr_rrc_T_pdcch_BlindDetectionSCG_UE_Mixed_r16 = -1;
static gint ett_nr_rrc_CA_ParametersNR_v1630 = -1;
static gint ett_nr_rrc_CA_ParametersNR_v1640 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxTwoPUCCH_Grp_ConfigList_r16_OF_TwoPUCCH_Grp_Configurations_r16 = -1;
static gint ett_nr_rrc_T_pdcch_BlindDetectionCA_Mixed_NonAlignedSpan_r16 = -1;
static gint ett_nr_rrc_SimulSRS_ForAntennaSwitching_r16 = -1;
static gint ett_nr_rrc_TwoPUCCH_Grp_Configurations_r16 = -1;
static gint ett_nr_rrc_TwoPUCCH_Grp_ConfigParams_r16 = -1;
static gint ett_nr_rrc_PUCCH_Grp_CarrierTypes_r16 = -1;
static gint ett_nr_rrc_CA_ParametersNRDC = -1;
static gint ett_nr_rrc_CA_ParametersNRDC_v15g0 = -1;
static gint ett_nr_rrc_CA_ParametersNRDC_v1610 = -1;
static gint ett_nr_rrc_CA_ParametersNRDC_v1630 = -1;
static gint ett_nr_rrc_CA_ParametersNRDC_v1640 = -1;
static gint ett_nr_rrc_CA_ParametersNRDC_v1650 = -1;
static gint ett_nr_rrc_CarrierAggregationVariant = -1;
static gint ett_nr_rrc_CodebookParameters = -1;
static gint ett_nr_rrc_T_type1_02 = -1;
static gint ett_nr_rrc_T_singlePanel = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_RS_Resources_OF_SupportedCSI_RS_Resource = -1;
static gint ett_nr_rrc_T_multiPanel = -1;
static gint ett_nr_rrc_T_type2_02 = -1;
static gint ett_nr_rrc_T_type2_PortSelection = -1;
static gint ett_nr_rrc_CodebookParameters_v1610 = -1;
static gint ett_nr_rrc_T_supportedCSI_RS_ResourceListAlt_r16 = -1;
static gint ett_nr_rrc_T_type1_SinglePanel_r16 = -1;
static gint ett_nr_rrc_T_type1_MultiPanel_r16 = -1;
static gint ett_nr_rrc_T_type2_r16 = -1;
static gint ett_nr_rrc_T_type2_PortSelection_r16 = -1;
static gint ett_nr_rrc_CodebookParametersAddition_r16 = -1;
static gint ett_nr_rrc_T_etype2_r16 = -1;
static gint ett_nr_rrc_T_etype2R1_r16 = -1;
static gint ett_nr_rrc_T_supportedCSI_RS_ResourceListAdd_r16 = -1;
static gint ett_nr_rrc_T_etype2R2_r16 = -1;
static gint ett_nr_rrc_T_supportedCSI_RS_ResourceListAdd_r16_01 = -1;
static gint ett_nr_rrc_T_etype2_PS_r16 = -1;
static gint ett_nr_rrc_T_etype2R1_PortSelection_r16 = -1;
static gint ett_nr_rrc_T_supportedCSI_RS_ResourceListAdd_r16_02 = -1;
static gint ett_nr_rrc_T_etype2R2_PortSelection_r16 = -1;
static gint ett_nr_rrc_T_supportedCSI_RS_ResourceListAdd_r16_03 = -1;
static gint ett_nr_rrc_CodebookComboParametersAddition_r16 = -1;
static gint ett_nr_rrc_T_type1SP_Type2_null_r16 = -1;
static gint ett_nr_rrc_T_supportedCSI_RS_ResourceListAdd_r16_04 = -1;
static gint ett_nr_rrc_T_type1SP_Type2PS_null_r16 = -1;
static gint ett_nr_rrc_T_supportedCSI_RS_ResourceListAdd_r16_05 = -1;
static gint ett_nr_rrc_T_type1SP_eType2R1_null_r16 = -1;
static gint ett_nr_rrc_T_supportedCSI_RS_ResourceListAdd_r16_06 = -1;
static gint ett_nr_rrc_T_type1SP_eType2R2_null_r16 = -1;
static gint ett_nr_rrc_T_supportedCSI_RS_ResourceListAdd_r16_07 = -1;
static gint ett_nr_rrc_T_type1SP_eType2R1PS_null_r16 = -1;
static gint ett_nr_rrc_T_supportedCSI_RS_ResourceListAdd_r16_08 = -1;
static gint ett_nr_rrc_T_type1SP_eType2R2PS_null_r16 = -1;
static gint ett_nr_rrc_T_supportedCSI_RS_ResourceListAdd_r16_09 = -1;
static gint ett_nr_rrc_T_type1SP_Type2_Type2PS_r16 = -1;
static gint ett_nr_rrc_T_supportedCSI_RS_ResourceListAdd_r16_10 = -1;
static gint ett_nr_rrc_T_type1MP_Type2_null_r16 = -1;
static gint ett_nr_rrc_T_supportedCSI_RS_ResourceListAdd_r16_11 = -1;
static gint ett_nr_rrc_T_type1MP_Type2PS_null_r16 = -1;
static gint ett_nr_rrc_T_supportedCSI_RS_ResourceListAdd_r16_12 = -1;
static gint ett_nr_rrc_T_type1MP_eType2R1_null_r16 = -1;
static gint ett_nr_rrc_T_supportedCSI_RS_ResourceListAdd_r16_13 = -1;
static gint ett_nr_rrc_T_type1MP_eType2R2_null_r16 = -1;
static gint ett_nr_rrc_T_supportedCSI_RS_ResourceListAdd_r16_14 = -1;
static gint ett_nr_rrc_T_type1MP_eType2R1PS_null_r16 = -1;
static gint ett_nr_rrc_T_supportedCSI_RS_ResourceListAdd_r16_15 = -1;
static gint ett_nr_rrc_T_type1MP_eType2R2PS_null_r16 = -1;
static gint ett_nr_rrc_T_supportedCSI_RS_ResourceListAdd_r16_16 = -1;
static gint ett_nr_rrc_T_type1MP_Type2_Type2PS_r16 = -1;
static gint ett_nr_rrc_T_supportedCSI_RS_ResourceListAdd_r16_17 = -1;
static gint ett_nr_rrc_CodebookParametersAdditionPerBC_r16 = -1;
static gint ett_nr_rrc_T_etype2R1_r16_01 = -1;
static gint ett_nr_rrc_T_etype2R2_r16_01 = -1;
static gint ett_nr_rrc_T_etype2R1_PortSelection_r16_01 = -1;
static gint ett_nr_rrc_T_etype2R2_PortSelection_r16_01 = -1;
static gint ett_nr_rrc_CodebookComboParametersAdditionPerBC_r16 = -1;
static gint ett_nr_rrc_T_type1SP_Type2_null_r16_01 = -1;
static gint ett_nr_rrc_T_type1SP_Type2PS_null_r16_01 = -1;
static gint ett_nr_rrc_T_type1SP_eType2R1_null_r16_01 = -1;
static gint ett_nr_rrc_T_type1SP_eType2R2_null_r16_01 = -1;
static gint ett_nr_rrc_T_type1SP_eType2R1PS_null_r16_01 = -1;
static gint ett_nr_rrc_T_type1SP_eType2R2PS_null_r16_01 = -1;
static gint ett_nr_rrc_T_type1SP_Type2_Type2PS_r16_01 = -1;
static gint ett_nr_rrc_T_type1MP_Type2_null_r16_01 = -1;
static gint ett_nr_rrc_T_type1MP_Type2PS_null_r16_01 = -1;
static gint ett_nr_rrc_T_type1MP_eType2R1_null_r16_01 = -1;
static gint ett_nr_rrc_T_type1MP_eType2R2_null_r16_01 = -1;
static gint ett_nr_rrc_T_type1MP_eType2R1PS_null_r16_01 = -1;
static gint ett_nr_rrc_T_type1MP_eType2R2PS_null_r16_01 = -1;
static gint ett_nr_rrc_T_type1MP_Type2_Type2PS_r16_01 = -1;
static gint ett_nr_rrc_CodebookVariantsList_r16 = -1;
static gint ett_nr_rrc_SupportedCSI_RS_Resource = -1;
static gint ett_nr_rrc_FeatureSetCombination = -1;
static gint ett_nr_rrc_FeatureSetsPerBand = -1;
static gint ett_nr_rrc_FeatureSet = -1;
static gint ett_nr_rrc_T_eutra_03 = -1;
static gint ett_nr_rrc_T_nr_04 = -1;
static gint ett_nr_rrc_FeatureSetDownlink = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofServingCells_OF_FeatureSetDownlinkPerCC_Id = -1;
static gint ett_nr_rrc_T_timeDurationForQCL = -1;
static gint ett_nr_rrc_T_pdsch_ProcessingType1_DifferentTB_PerSlot = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCodebooks_OF_DummyB = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCodebooks_OF_DummyC = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCodebooks_OF_DummyD = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCodebooks_OF_DummyE = -1;
static gint ett_nr_rrc_FeatureSetDownlink_v1540 = -1;
static gint ett_nr_rrc_T_pdcch_MonitoringAnyOccasionsWithSpanGap = -1;
static gint ett_nr_rrc_T_pdsch_ProcessingType2 = -1;
static gint ett_nr_rrc_T_pdsch_ProcessingType2_Limited = -1;
static gint ett_nr_rrc_FeatureSetDownlink_v15a0 = -1;
static gint ett_nr_rrc_FeatureSetDownlink_v1610 = -1;
static gint ett_nr_rrc_T_cbgPDSCH_ProcessingType1_DifferentTB_PerSlot_r16 = -1;
static gint ett_nr_rrc_T_cbgPDSCH_ProcessingType2_DifferentTB_PerSlot_r16 = -1;
static gint ett_nr_rrc_T_intraFreqDAPS_r16 = -1;
static gint ett_nr_rrc_T_pdcch_Monitoring_r16 = -1;
static gint ett_nr_rrc_T_pdsch_ProcessingType1_r16 = -1;
static gint ett_nr_rrc_T_pdsch_ProcessingType2_r16 = -1;
static gint ett_nr_rrc_T_crossCarrierSchedulingProcessing_DiffSCS_r16 = -1;
static gint ett_nr_rrc_PDCCH_MonitoringOccasions_r16 = -1;
static gint ett_nr_rrc_DummyA = -1;
static gint ett_nr_rrc_DummyB = -1;
static gint ett_nr_rrc_DummyC = -1;
static gint ett_nr_rrc_DummyD = -1;
static gint ett_nr_rrc_DummyE = -1;
static gint ett_nr_rrc_FeatureSetDownlinkPerCC = -1;
static gint ett_nr_rrc_FeatureSetDownlinkPerCC_v1620 = -1;
static gint ett_nr_rrc_MultiDCI_MultiTRP_r16 = -1;
static gint ett_nr_rrc_FeatureSets = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxDownlinkFeatureSets_OF_FeatureSetDownlink = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetDownlinkPerCC = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxUplinkFeatureSets_OF_FeatureSetUplink = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetUplinkPerCC = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxDownlinkFeatureSets_OF_FeatureSetDownlink_v1540 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxUplinkFeatureSets_OF_FeatureSetUplink_v1540 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetUplinkPerCC_v1540 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxDownlinkFeatureSets_OF_FeatureSetDownlink_v15a0 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxDownlinkFeatureSets_OF_FeatureSetDownlink_v1610 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxUplinkFeatureSets_OF_FeatureSetUplink_v1610 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetDownlinkPerCC_v1620 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxUplinkFeatureSets_OF_FeatureSetUplink_v1630 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxUplinkFeatureSets_OF_FeatureSetUplink_v1640 = -1;
static gint ett_nr_rrc_FeatureSetUplink = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofServingCells_OF_FeatureSetUplinkPerCC_Id = -1;
static gint ett_nr_rrc_T_pusch_ProcessingType1_DifferentTB_PerSlot = -1;
static gint ett_nr_rrc_FeatureSetUplink_v1540 = -1;
static gint ett_nr_rrc_T_pusch_ProcessingType2 = -1;
static gint ett_nr_rrc_FeatureSetUplink_v1610 = -1;
static gint ett_nr_rrc_T_pusch_RepetitionTypeB_r16 = -1;
static gint ett_nr_rrc_T_cbgPUSCH_ProcessingType1_DifferentTB_PerSlot_r16 = -1;
static gint ett_nr_rrc_T_cbgPUSCH_ProcessingType2_DifferentTB_PerSlot_r16 = -1;
static gint ett_nr_rrc_T_intraFreqDAPS_UL_r16 = -1;
static gint ett_nr_rrc_T_multiPUCCH_r16 = -1;
static gint ett_nr_rrc_T_ul_IntraUE_Mux_r16 = -1;
static gint ett_nr_rrc_T_crossCarrierSchedulingProcessing_DiffSCS_r16_01 = -1;
static gint ett_nr_rrc_T_ul_FullPwrMode2_TPMIGroup_r16 = -1;
static gint ett_nr_rrc_FeatureSetUplink_v1630 = -1;
static gint ett_nr_rrc_FeatureSetUplink_v1640 = -1;
static gint ett_nr_rrc_T_offsetSRS_CB_PUSCH_PDCCH_MonitorAnyOccWithSpanGap_fr1_r16 = -1;
static gint ett_nr_rrc_SubSlot_Config_r16 = -1;
static gint ett_nr_rrc_SRS_AllPosResources_r16 = -1;
static gint ett_nr_rrc_SRS_PosResources_r16 = -1;
static gint ett_nr_rrc_SRS_PosResourceAP_r16 = -1;
static gint ett_nr_rrc_SRS_PosResourceSP_r16 = -1;
static gint ett_nr_rrc_SRS_Resources = -1;
static gint ett_nr_rrc_DummyF = -1;
static gint ett_nr_rrc_FeatureSetUplinkPerCC = -1;
static gint ett_nr_rrc_T_mimo_CB_PUSCH = -1;
static gint ett_nr_rrc_FeatureSetUplinkPerCC_v1540 = -1;
static gint ett_nr_rrc_T_mimo_NonCB_PUSCH = -1;
static gint ett_nr_rrc_FreqBandList = -1;
static gint ett_nr_rrc_FreqBandInformation = -1;
static gint ett_nr_rrc_FreqBandInformationEUTRA = -1;
static gint ett_nr_rrc_FreqBandInformationNR = -1;
static gint ett_nr_rrc_HighSpeedParameters_r16 = -1;
static gint ett_nr_rrc_HighSpeedParameters_v1650 = -1;
static gint ett_nr_rrc_IMS_Parameters = -1;
static gint ett_nr_rrc_IMS_ParametersCommon = -1;
static gint ett_nr_rrc_IMS_ParametersFRX_Diff = -1;
static gint ett_nr_rrc_InterRAT_Parameters = -1;
static gint ett_nr_rrc_EUTRA_Parameters = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxBandsEUTRA_OF_FreqBandIndicatorEUTRA = -1;
static gint ett_nr_rrc_EUTRA_ParametersCommon = -1;
static gint ett_nr_rrc_EUTRA_ParametersXDD_Diff = -1;
static gint ett_nr_rrc_UTRA_FDD_Parameters_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxBandsUTRA_FDD_r16_OF_SupportedBandUTRA_FDD_r16 = -1;
static gint ett_nr_rrc_MAC_Parameters = -1;
static gint ett_nr_rrc_MAC_Parameters_v1610 = -1;
static gint ett_nr_rrc_MAC_ParametersCommon = -1;
static gint ett_nr_rrc_MAC_ParametersFRX_Diff_r16 = -1;
static gint ett_nr_rrc_T_drx_Adaptation_r16 = -1;
static gint ett_nr_rrc_MAC_ParametersXDD_Diff = -1;
static gint ett_nr_rrc_MinTimeGap_r16 = -1;
static gint ett_nr_rrc_MeasAndMobParameters = -1;
static gint ett_nr_rrc_MeasAndMobParametersCommon = -1;
static gint ett_nr_rrc_T_condHandoverParametersCommon_r16 = -1;
static gint ett_nr_rrc_MeasAndMobParametersXDD_Diff = -1;
static gint ett_nr_rrc_MeasAndMobParametersFRX_Diff = -1;
static gint ett_nr_rrc_MeasAndMobParametersMRDC = -1;
static gint ett_nr_rrc_MeasAndMobParametersMRDC_v1560 = -1;
static gint ett_nr_rrc_MeasAndMobParametersMRDC_v1610 = -1;
static gint ett_nr_rrc_MeasAndMobParametersMRDC_Common = -1;
static gint ett_nr_rrc_MeasAndMobParametersMRDC_Common_v1610 = -1;
static gint ett_nr_rrc_T_condPSCellChangeParametersCommon_r16 = -1;
static gint ett_nr_rrc_MeasAndMobParametersMRDC_XDD_Diff = -1;
static gint ett_nr_rrc_MeasAndMobParametersMRDC_XDD_Diff_v1560 = -1;
static gint ett_nr_rrc_MeasAndMobParametersMRDC_FRX_Diff = -1;
static gint ett_nr_rrc_MIMO_ParametersPerBand = -1;
static gint ett_nr_rrc_T_tci_StatePDSCH = -1;
static gint ett_nr_rrc_T_maxNumberRxTxBeamSwitchDL = -1;
static gint ett_nr_rrc_T_uplinkBeamManagement = -1;
static gint ett_nr_rrc_T_beamReportTiming = -1;
static gint ett_nr_rrc_T_ptrs_DensityRecommendationSetDL = -1;
static gint ett_nr_rrc_T_ptrs_DensityRecommendationSetUL = -1;
static gint ett_nr_rrc_T_beamSwitchTiming = -1;
static gint ett_nr_rrc_T_ssb_csirs_SINR_measurement_r16 = -1;
static gint ett_nr_rrc_T_multiDCI_multiTRP_Parameters_r16 = -1;
static gint ett_nr_rrc_T_outOfOrderOperationDL_r16 = -1;
static gint ett_nr_rrc_T_maxNumberActivatedTCI_States_r16 = -1;
static gint ett_nr_rrc_T_singleDCI_SDM_scheme_Parameters_r16 = -1;
static gint ett_nr_rrc_T_supportInter_slotTDM_r16 = -1;
static gint ett_nr_rrc_T_beamSwitchTiming_r16 = -1;
static gint ett_nr_rrc_T_semi_PersistentL1_SINR_Report_PUCCH_r16 = -1;
static gint ett_nr_rrc_T_spatialRelations_v1640 = -1;
static gint ett_nr_rrc_DummyG = -1;
static gint ett_nr_rrc_BeamManagementSSB_CSI_RS = -1;
static gint ett_nr_rrc_DummyH = -1;
static gint ett_nr_rrc_CSI_RS_ForTracking = -1;
static gint ett_nr_rrc_CSI_RS_IM_ReceptionForFeedback = -1;
static gint ett_nr_rrc_CSI_RS_ProcFrameworkForSRS = -1;
static gint ett_nr_rrc_CSI_ReportFramework = -1;
static gint ett_nr_rrc_CSI_ReportFrameworkExt_r16 = -1;
static gint ett_nr_rrc_PTRS_DensityRecommendationDL = -1;
static gint ett_nr_rrc_PTRS_DensityRecommendationUL = -1;
static gint ett_nr_rrc_SpatialRelations = -1;
static gint ett_nr_rrc_DummyI = -1;
static gint ett_nr_rrc_MRDC_Parameters = -1;
static gint ett_nr_rrc_MRDC_Parameters_v1580 = -1;
static gint ett_nr_rrc_MRDC_Parameters_v1590 = -1;
static gint ett_nr_rrc_MRDC_Parameters_v15g0 = -1;
static gint ett_nr_rrc_MRDC_Parameters_v1620 = -1;
static gint ett_nr_rrc_T_maxUplinkDutyCycle_interBandENDC_TDD_PC2_r16 = -1;
static gint ett_nr_rrc_MRDC_Parameters_v1630 = -1;
static gint ett_nr_rrc_T_maxUplinkDutyCycle_interBandENDC_FDD_TDD_PC2_r16 = -1;
static gint ett_nr_rrc_NRDC_Parameters = -1;
static gint ett_nr_rrc_T_nRDC_Parameters_dummy = -1;
static gint ett_nr_rrc_NRDC_Parameters_v1570 = -1;
static gint ett_nr_rrc_NRDC_Parameters_v15c0 = -1;
static gint ett_nr_rrc_NRDC_Parameters_v1610 = -1;
static gint ett_nr_rrc_OLPC_SRS_Pos_r16 = -1;
static gint ett_nr_rrc_PDCP_Parameters = -1;
static gint ett_nr_rrc_T_supportedROHC_Profiles = -1;
static gint ett_nr_rrc_PDCP_ParametersMRDC = -1;
static gint ett_nr_rrc_PDCP_ParametersMRDC_v1610 = -1;
static gint ett_nr_rrc_Phy_Parameters = -1;
static gint ett_nr_rrc_Phy_ParametersCommon = -1;
static gint ett_nr_rrc_T_crossSlotScheduling_r16 = -1;
static gint ett_nr_rrc_T_pusch_RepetitionTypeA_r16 = -1;
static gint ett_nr_rrc_T_maxTotalResourcesForAcrossFreqRanges_r16 = -1;
static gint ett_nr_rrc_T_harqACK_separateMultiDCI_MultiTRP_r16 = -1;
static gint ett_nr_rrc_T_bwp_SwitchingMultiCCs_r16 = -1;
static gint ett_nr_rrc_T_bwp_SwitchingMultiDormancyCCs_r16 = -1;
static gint ett_nr_rrc_Phy_ParametersXDD_Diff = -1;
static gint ett_nr_rrc_Phy_ParametersFRX_Diff = -1;
static gint ett_nr_rrc_T_mux_SR_HARQ_ACK_CSI_PUCCH_OncePerSlot = -1;
static gint ett_nr_rrc_T_pdcch_BlindDetectionNRDC = -1;
static gint ett_nr_rrc_T_maxTotalResourcesForOneFreqRange_r16 = -1;
static gint ett_nr_rrc_Phy_ParametersFR1 = -1;
static gint ett_nr_rrc_Phy_ParametersFR2 = -1;
static gint ett_nr_rrc_Phy_ParametersMRDC = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofNAICS_Entries_OF_NAICS_Capability_Entry = -1;
static gint ett_nr_rrc_NAICS_Capability_Entry = -1;
static gint ett_nr_rrc_Phy_ParametersSharedSpectrumChAccess_r16 = -1;
static gint ett_nr_rrc_T_mux_SR_HARQ_ACK_CSI_PUCCH_OncePerSlot_r16 = -1;
static gint ett_nr_rrc_PowSav_Parameters_r16 = -1;
static gint ett_nr_rrc_PowSav_ParametersCommon_r16 = -1;
static gint ett_nr_rrc_PowSav_ParametersFRX_Diff_r16 = -1;
static gint ett_nr_rrc_ProcessingParameters = -1;
static gint ett_nr_rrc_T_differentTB_PerSlot = -1;
static gint ett_nr_rrc_RF_Parameters = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxBands_OF_BandNR = -1;
static gint ett_nr_rrc_RF_Parameters_v15g0 = -1;
static gint ett_nr_rrc_BandNR = -1;
static gint ett_nr_rrc_T_channelBWs_DL = -1;
static gint ett_nr_rrc_T_fr1 = -1;
static gint ett_nr_rrc_T_fr2 = -1;
static gint ett_nr_rrc_T_channelBWs_UL = -1;
static gint ett_nr_rrc_T_fr1_01 = -1;
static gint ett_nr_rrc_T_fr2_01 = -1;
static gint ett_nr_rrc_T_channelBWs_DL_v1590 = -1;
static gint ett_nr_rrc_T_fr1_02 = -1;
static gint ett_nr_rrc_T_fr2_02 = -1;
static gint ett_nr_rrc_T_channelBWs_UL_v1590 = -1;
static gint ett_nr_rrc_T_fr1_03 = -1;
static gint ett_nr_rrc_T_fr2_03 = -1;
static gint ett_nr_rrc_T_multipleRateMatchingEUTRA_CRS_r16 = -1;
static gint ett_nr_rrc_T_channelBW_DL_IAB_r16 = -1;
static gint ett_nr_rrc_T_fr1_100mhz = -1;
static gint ett_nr_rrc_T_fr2_200mhz = -1;
static gint ett_nr_rrc_T_channelBW_UL_IAB_r16 = -1;
static gint ett_nr_rrc_T_fr1_100mhz_01 = -1;
static gint ett_nr_rrc_T_fr2_200mhz_01 = -1;
static gint ett_nr_rrc_T_activeConfiguredGrant_r16 = -1;
static gint ett_nr_rrc_T_sps_r16 = -1;
static gint ett_nr_rrc_RF_ParametersMRDC = -1;
static gint ett_nr_rrc_T_supportedBandCombinationListNEDC_Only_v15a0 = -1;
static gint ett_nr_rrc_RF_ParametersMRDC_v15g0 = -1;
static gint ett_nr_rrc_RLC_Parameters = -1;
static gint ett_nr_rrc_SDAP_Parameters = -1;
static gint ett_nr_rrc_SidelinkParameters_r16 = -1;
static gint ett_nr_rrc_SidelinkParametersNR_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxBands_OF_BandSidelink_r16 = -1;
static gint ett_nr_rrc_SidelinkParametersEUTRA_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxBandsEUTRA_OF_BandSidelinkEUTRA_r16 = -1;
static gint ett_nr_rrc_RLC_ParametersSidelink_r16 = -1;
static gint ett_nr_rrc_MAC_ParametersSidelink_r16 = -1;
static gint ett_nr_rrc_UE_SidelinkCapabilityAddXDD_Mode_r16 = -1;
static gint ett_nr_rrc_MAC_ParametersSidelinkCommon_r16 = -1;
static gint ett_nr_rrc_MAC_ParametersSidelinkXDD_Diff_r16 = -1;
static gint ett_nr_rrc_BandSidelinkEUTRA_r16 = -1;
static gint ett_nr_rrc_T_gnb_ScheduledMode3SidelinkEUTRA_r16 = -1;
static gint ett_nr_rrc_BandSidelink_r16 = -1;
static gint ett_nr_rrc_T_sl_Reception_r16 = -1;
static gint ett_nr_rrc_T_scs_CP_PatternRxSidelink_r16 = -1;
static gint ett_nr_rrc_T_fr1_r16 = -1;
static gint ett_nr_rrc_T_fr2_r16_01 = -1;
static gint ett_nr_rrc_T_sl_TransmissionMode1_r16 = -1;
static gint ett_nr_rrc_T_scs_CP_PatternTxSidelinkModeOne_r16 = -1;
static gint ett_nr_rrc_T_fr1_r16_01 = -1;
static gint ett_nr_rrc_T_fr2_r16_02 = -1;
static gint ett_nr_rrc_T_sync_Sidelink_r16 = -1;
static gint ett_nr_rrc_T_psfch_FormatZeroSidelink_r16 = -1;
static gint ett_nr_rrc_T_sl_TransmissionMode2_r16 = -1;
static gint ett_nr_rrc_T_congestionControlSidelink_r16 = -1;
static gint ett_nr_rrc_SON_Parameters_r16 = -1;
static gint ett_nr_rrc_SpatialRelationsSRS_Pos_r16 = -1;
static gint ett_nr_rrc_SRS_SwitchingTimeNR = -1;
static gint ett_nr_rrc_SRS_SwitchingTimeEUTRA = -1;
static gint ett_nr_rrc_SupportedBandwidth = -1;
static gint ett_nr_rrc_UE_BasedPerfMeas_Parameters_r16 = -1;
static gint ett_nr_rrc_UE_CapabilityRAT_ContainerList = -1;
static gint ett_nr_rrc_UE_CapabilityRAT_Container = -1;
static gint ett_nr_rrc_UE_CapabilityRAT_RequestList = -1;
static gint ett_nr_rrc_UE_CapabilityRAT_Request = -1;
static gint ett_nr_rrc_UE_CapabilityRequestFilterCommon = -1;
static gint ett_nr_rrc_T_mrdc_Request = -1;
static gint ett_nr_rrc_T_codebookTypeRequest_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxCellGroupings_r16_OF_CellGrouping_r16 = -1;
static gint ett_nr_rrc_CellGrouping_r16 = -1;
static gint ett_nr_rrc_UE_CapabilityRequestFilterNR = -1;
static gint ett_nr_rrc_UE_CapabilityRequestFilterNR_v1540 = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_49 = -1;
static gint ett_nr_rrc_UE_MRDC_Capability = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxFeatureSetCombinations_OF_FeatureSetCombination = -1;
static gint ett_nr_rrc_UE_MRDC_Capability_v1560 = -1;
static gint ett_nr_rrc_UE_MRDC_Capability_v1610 = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_50 = -1;
static gint ett_nr_rrc_UE_MRDC_Capability_v15g0 = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_51 = -1;
static gint ett_nr_rrc_UE_MRDC_CapabilityAddXDD_Mode = -1;
static gint ett_nr_rrc_UE_MRDC_CapabilityAddXDD_Mode_v1560 = -1;
static gint ett_nr_rrc_UE_MRDC_CapabilityAddFRX_Mode = -1;
static gint ett_nr_rrc_GeneralParametersMRDC_XDD_Diff = -1;
static gint ett_nr_rrc_GeneralParametersMRDC_v1610 = -1;
static gint ett_nr_rrc_UE_NR_Capability = -1;
static gint ett_nr_rrc_UE_NR_Capability_v1530 = -1;
static gint ett_nr_rrc_UE_NR_Capability_v1540 = -1;
static gint ett_nr_rrc_UE_NR_Capability_v1550 = -1;
static gint ett_nr_rrc_UE_NR_Capability_v1560 = -1;
static gint ett_nr_rrc_UE_NR_Capability_v1570 = -1;
static gint ett_nr_rrc_UE_NR_Capability_v15c0 = -1;
static gint ett_nr_rrc_UE_NR_Capability_v15g0 = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_52 = -1;
static gint ett_nr_rrc_UE_NR_Capability_v1610 = -1;
static gint ett_nr_rrc_UE_NR_Capability_v1640 = -1;
static gint ett_nr_rrc_UE_NR_Capability_v1650 = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_53 = -1;
static gint ett_nr_rrc_UE_NR_CapabilityAddXDD_Mode = -1;
static gint ett_nr_rrc_UE_NR_CapabilityAddXDD_Mode_v1530 = -1;
static gint ett_nr_rrc_UE_NR_CapabilityAddFRX_Mode = -1;
static gint ett_nr_rrc_UE_NR_CapabilityAddFRX_Mode_v1540 = -1;
static gint ett_nr_rrc_UE_NR_CapabilityAddFRX_Mode_v1610 = -1;
static gint ett_nr_rrc_BAP_Parameters_r16 = -1;
static gint ett_nr_rrc_SharedSpectrumChAccessParamsPerBand_r16 = -1;
static gint ett_nr_rrc_SharedSpectrumChAccessParamsPerBand_v1630 = -1;
static gint ett_nr_rrc_SharedSpectrumChAccessParamsPerBand_v1640 = -1;
static gint ett_nr_rrc_SharedSpectrumChAccessParamsPerBand_v1650 = -1;
static gint ett_nr_rrc_AreaConfiguration_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxFreq_OF_InterFreqTargetInfo_r16 = -1;
static gint ett_nr_rrc_AreaConfig_r16 = -1;
static gint ett_nr_rrc_InterFreqTargetInfo_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_32_OF_PhysCellId = -1;
static gint ett_nr_rrc_CellGlobalIdList_r16 = -1;
static gint ett_nr_rrc_TrackingAreaCodeList_r16 = -1;
static gint ett_nr_rrc_TrackingAreaIdentityList_r16 = -1;
static gint ett_nr_rrc_TrackingAreaIdentity_r16 = -1;
static gint ett_nr_rrc_BT_NameList_r16 = -1;
static gint ett_nr_rrc_EUTRA_MBSFN_SubframeConfigList = -1;
static gint ett_nr_rrc_EUTRA_MBSFN_SubframeConfig = -1;
static gint ett_nr_rrc_T_subframeAllocation1 = -1;
static gint ett_nr_rrc_T_subframeAllocation2 = -1;
static gint ett_nr_rrc_EUTRA_MultiBandInfoList = -1;
static gint ett_nr_rrc_EUTRA_MultiBandInfo = -1;
static gint ett_nr_rrc_EUTRA_NS_PmaxList = -1;
static gint ett_nr_rrc_EUTRA_NS_PmaxValue = -1;
static gint ett_nr_rrc_EUTRA_PhysCellIdRange = -1;
static gint ett_nr_rrc_IAB_IP_Address_r16 = -1;
static gint ett_nr_rrc_LogMeasResultListBT_r16 = -1;
static gint ett_nr_rrc_LogMeasResultBT_r16 = -1;
static gint ett_nr_rrc_LogMeasResultListWLAN_r16 = -1;
static gint ett_nr_rrc_LogMeasResultWLAN_r16 = -1;
static gint ett_nr_rrc_WLAN_Identifiers_r16 = -1;
static gint ett_nr_rrc_WLAN_RTT_r16 = -1;
static gint ett_nr_rrc_OtherConfig = -1;
static gint ett_nr_rrc_T_delayBudgetReportingConfig = -1;
static gint ett_nr_rrc_T_setup = -1;
static gint ett_nr_rrc_OtherConfig_v1540 = -1;
static gint ett_nr_rrc_T_overheatingAssistanceConfig = -1;
static gint ett_nr_rrc_CandidateServingFreqListNR_r16 = -1;
static gint ett_nr_rrc_OtherConfig_v1610 = -1;
static gint ett_nr_rrc_T_idc_AssistanceConfig_r16 = -1;
static gint ett_nr_rrc_T_drx_PreferenceConfig_r16 = -1;
static gint ett_nr_rrc_T_maxBW_PreferenceConfig_r16 = -1;
static gint ett_nr_rrc_T_maxCC_PreferenceConfig_r16 = -1;
static gint ett_nr_rrc_T_maxMIMO_LayerPreferenceConfig_r16 = -1;
static gint ett_nr_rrc_T_minSchedulingOffsetPreferenceConfig_r16 = -1;
static gint ett_nr_rrc_T_releasePreferenceConfig_r16 = -1;
static gint ett_nr_rrc_T_btNameList_r16 = -1;
static gint ett_nr_rrc_T_wlanNameList_r16 = -1;
static gint ett_nr_rrc_T_sensorNameList_r16 = -1;
static gint ett_nr_rrc_OverheatingAssistanceConfig = -1;
static gint ett_nr_rrc_IDC_AssistanceConfig_r16 = -1;
static gint ett_nr_rrc_DRX_PreferenceConfig_r16 = -1;
static gint ett_nr_rrc_MaxBW_PreferenceConfig_r16 = -1;
static gint ett_nr_rrc_MaxCC_PreferenceConfig_r16 = -1;
static gint ett_nr_rrc_MaxMIMO_LayerPreferenceConfig_r16 = -1;
static gint ett_nr_rrc_MinSchedulingOffsetPreferenceConfig_r16 = -1;
static gint ett_nr_rrc_ReleasePreferenceConfig_r16 = -1;
static gint ett_nr_rrc_Sensor_NameList_r16 = -1;
static gint ett_nr_rrc_TraceReference_r16 = -1;
static gint ett_nr_rrc_UE_MeasurementsAvailable_r16 = -1;
static gint ett_nr_rrc_VisitedCellInfoList_r16 = -1;
static gint ett_nr_rrc_VisitedCellInfo_r16 = -1;
static gint ett_nr_rrc_T_visitedCellId_r16 = -1;
static gint ett_nr_rrc_T_nr_CellId_r16 = -1;
static gint ett_nr_rrc_T_pci_arfcn_r16_03 = -1;
static gint ett_nr_rrc_T_eutra_CellId_r16 = -1;
static gint ett_nr_rrc_T_pci_arfcn_r16_04 = -1;
static gint ett_nr_rrc_WLAN_NameList_r16 = -1;
static gint ett_nr_rrc_SL_BWP_Config_r16 = -1;
static gint ett_nr_rrc_SL_BWP_Generic_r16 = -1;
static gint ett_nr_rrc_T_sl_PSBCH_Config_r16 = -1;
static gint ett_nr_rrc_SL_BWP_PoolConfig_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofRXPool_r16_OF_SL_ResourcePool_r16 = -1;
static gint ett_nr_rrc_SL_TxPoolDedicated_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofTXPool_r16_OF_SL_ResourcePoolID_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofTXPool_r16_OF_SL_ResourcePoolConfig_r16 = -1;
static gint ett_nr_rrc_SL_ResourcePoolConfig_r16 = -1;
static gint ett_nr_rrc_SL_CBR_PriorityTxConfigList_r16 = -1;
static gint ett_nr_rrc_SL_CBR_PriorityTxConfigList_v1650 = -1;
static gint ett_nr_rrc_SL_PriorityTxConfigIndex_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxCBR_Level_r16_OF_SL_TxConfigIndex_r16 = -1;
static gint ett_nr_rrc_SL_PriorityTxConfigIndex_v1650 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxCBR_Level_r16_OF_SL_MinMaxMCS_List_r16 = -1;
static gint ett_nr_rrc_SL_CBR_CommonTxConfigList_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxCBR_Config_r16_OF_SL_CBR_LevelsConfig_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxTxConfig_r16_OF_SL_CBR_PSSCH_TxConfig_r16 = -1;
static gint ett_nr_rrc_SL_CBR_LevelsConfig_r16 = -1;
static gint ett_nr_rrc_SL_CBR_PSSCH_TxConfig_r16 = -1;
static gint ett_nr_rrc_SL_ConfigDedicatedNR_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSLRB_r16_OF_SLRB_Uu_ConfigIndex_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSLRB_r16_OF_SL_RadioBearerConfig_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSL_Dest_r16_OF_SL_DestinationIndex_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSL_Dest_r16_OF_SL_MeasConfigInfo_r16 = -1;
static gint ett_nr_rrc_SL_PHY_MAC_RLC_Config_r16 = -1;
static gint ett_nr_rrc_T_sl_ScheduledConfig_r16 = -1;
static gint ett_nr_rrc_T_sl_UE_SelectedConfig_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofFreqSL_r16_OF_SL_Freq_Id_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofFreqSL_r16_OF_SL_FreqConfig_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxSL_LCID_r16_OF_SL_RLC_BearerConfigIndex_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxSL_LCID_r16_OF_SL_RLC_BearerConfig_r16 = -1;
static gint ett_nr_rrc_T_sl_CSI_SchedulingRequestId_r16 = -1;
static gint ett_nr_rrc_SL_ConfiguredGrantConfig_r16 = -1;
static gint ett_nr_rrc_T_rrc_ConfiguredSidelinkGrant_r16 = -1;
static gint ett_nr_rrc_SL_CG_MaxTransNumList_r16 = -1;
static gint ett_nr_rrc_SL_CG_MaxTransNum_r16 = -1;
static gint ett_nr_rrc_SL_PeriodCG_r16 = -1;
static gint ett_nr_rrc_SL_FreqConfig_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSL_BWPs_r16_OF_BWP_Id = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSL_BWPs_r16_OF_SL_BWP_Config_r16 = -1;
static gint ett_nr_rrc_SL_LogicalChannelConfig_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_0_maxNrofCG_SL_1_r16_OF_SL_ConfigIndexCG_r16 = -1;
static gint ett_nr_rrc_SL_MeasConfigInfo_r16 = -1;
static gint ett_nr_rrc_SL_MeasConfig_r16 = -1;
static gint ett_nr_rrc_SL_MeasObjectToRemoveList_r16 = -1;
static gint ett_nr_rrc_SL_ReportConfigToRemoveList_r16 = -1;
static gint ett_nr_rrc_SL_MeasIdToRemoveList_r16 = -1;
static gint ett_nr_rrc_SL_MeasIdList_r16 = -1;
static gint ett_nr_rrc_SL_MeasIdInfo_r16 = -1;
static gint ett_nr_rrc_SL_MeasObjectList_r16 = -1;
static gint ett_nr_rrc_SL_MeasObjectInfo_r16 = -1;
static gint ett_nr_rrc_SL_MeasObject_r16 = -1;
static gint ett_nr_rrc_SL_PDCP_Config_r16 = -1;
static gint ett_nr_rrc_SL_PSBCH_Config_r16 = -1;
static gint ett_nr_rrc_SL_PSSCH_TxConfigList_r16 = -1;
static gint ett_nr_rrc_SL_PSSCH_TxConfig_r16 = -1;
static gint ett_nr_rrc_SL_PSSCH_TxParameters_r16 = -1;
static gint ett_nr_rrc_SL_QoS_Profile_r16 = -1;
static gint ett_nr_rrc_SL_PQI_r16 = -1;
static gint ett_nr_rrc_T_sl_Non_StandardizedPQI_r16 = -1;
static gint ett_nr_rrc_SL_QuantityConfig_r16 = -1;
static gint ett_nr_rrc_SL_RadioBearerConfig_r16 = -1;
static gint ett_nr_rrc_SL_ReportConfigList_r16 = -1;
static gint ett_nr_rrc_SL_ReportConfigInfo_r16 = -1;
static gint ett_nr_rrc_SL_ReportConfig_r16 = -1;
static gint ett_nr_rrc_T_sl_ReportType_r16 = -1;
static gint ett_nr_rrc_SL_PeriodicalReportConfig_r16 = -1;
static gint ett_nr_rrc_SL_EventTriggerConfig_r16 = -1;
static gint ett_nr_rrc_T_sl_EventId_r16 = -1;
static gint ett_nr_rrc_T_eventS1_r16 = -1;
static gint ett_nr_rrc_T_eventS2_r16 = -1;
static gint ett_nr_rrc_SL_MeasReportQuantity_r16 = -1;
static gint ett_nr_rrc_SL_MeasTriggerQuantity_r16 = -1;
static gint ett_nr_rrc_SL_ResourcePool_r16 = -1;
static gint ett_nr_rrc_T_sl_PSCCH_Config_r16 = -1;
static gint ett_nr_rrc_T_sl_PSSCH_Config_r16 = -1;
static gint ett_nr_rrc_T_sl_PSFCH_Config_r16 = -1;
static gint ett_nr_rrc_T_sl_RxParametersNcell_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_16_OF_SL_ZoneConfigMCR_r16 = -1;
static gint ett_nr_rrc_SL_ZoneConfigMCR_r16 = -1;
static gint ett_nr_rrc_SL_SyncAllowed_r16 = -1;
static gint ett_nr_rrc_SL_PSCCH_Config_r16 = -1;
static gint ett_nr_rrc_SL_PSSCH_Config_r16 = -1;
static gint ett_nr_rrc_T_sl_PSSCH_DMRS_TimePatternList_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_4_OF_SL_BetaOffsets_r16 = -1;
static gint ett_nr_rrc_SL_PSFCH_Config_r16 = -1;
static gint ett_nr_rrc_SL_PTRS_Config_r16 = -1;
static gint ett_nr_rrc_T_sl_PTRS_FreqDensity_r16 = -1;
static gint ett_nr_rrc_T_sl_PTRS_TimeDensity_r16 = -1;
static gint ett_nr_rrc_SL_UE_SelectedConfigRP_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_16_OF_SL_ResourceReservePeriod_r16 = -1;
static gint ett_nr_rrc_SL_ResourceReservePeriod_r16 = -1;
static gint ett_nr_rrc_SL_SelectionWindowList_r16 = -1;
static gint ett_nr_rrc_SL_SelectionWindowConfig_r16 = -1;
static gint ett_nr_rrc_SL_TxPercentageList_r16 = -1;
static gint ett_nr_rrc_SL_TxPercentageConfig_r16 = -1;
static gint ett_nr_rrc_SL_MinMaxMCS_List_r16 = -1;
static gint ett_nr_rrc_SL_MinMaxMCS_Config_r16 = -1;
static gint ett_nr_rrc_SL_PowerControl_r16 = -1;
static gint ett_nr_rrc_SL_RLC_BearerConfig_r16 = -1;
static gint ett_nr_rrc_SL_RLC_Config_r16 = -1;
static gint ett_nr_rrc_T_sl_AM_RLC_r16 = -1;
static gint ett_nr_rrc_T_sl_UM_RLC_r16 = -1;
static gint ett_nr_rrc_SL_ScheduledConfig_r16 = -1;
static gint ett_nr_rrc_T_sl_PSFCH_ToPUCCH_r16 = -1;
static gint ett_nr_rrc_T_sl_DCI_ToSL_Trans_r16 = -1;
static gint ett_nr_rrc_MAC_MainConfigSL_r16 = -1;
static gint ett_nr_rrc_SL_ConfiguredGrantConfigList_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCG_SL_r16_OF_SL_ConfigIndexCG_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCG_SL_r16_OF_SL_ConfiguredGrantConfig_r16 = -1;
static gint ett_nr_rrc_SL_SDAP_Config_r16 = -1;
static gint ett_nr_rrc_T_sl_MappedQoS_Flows_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSL_QFIs_r16_OF_SL_QoS_Profile_r16 = -1;
static gint ett_nr_rrc_SL_MappedQoS_FlowsListDedicated_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSL_QFIs_r16_OF_SL_QoS_FlowIdentity_r16 = -1;
static gint ett_nr_rrc_SL_SyncConfigList_r16 = -1;
static gint ett_nr_rrc_SL_SyncConfig_r16 = -1;
static gint ett_nr_rrc_T_txParameters_r16 = -1;
static gint ett_nr_rrc_SL_SSB_TimeAllocation_r16 = -1;
static gint ett_nr_rrc_SL_Thres_RSRP_List_r16 = -1;
static gint ett_nr_rrc_SL_TxPower_r16 = -1;
static gint ett_nr_rrc_SL_UE_SelectedConfig_r16 = -1;
static gint ett_nr_rrc_SL_ZoneConfig_r16 = -1;
static gint ett_nr_rrc_SBCCH_SL_BCH_Message = -1;
static gint ett_nr_rrc_SBCCH_SL_BCH_MessageType = -1;
static gint ett_nr_rrc_T_c1_17 = -1;
static gint ett_nr_rrc_T_messageClassExtension_08 = -1;
static gint ett_nr_rrc_SCCH_Message = -1;
static gint ett_nr_rrc_SCCH_MessageType = -1;
static gint ett_nr_rrc_T_c1_18 = -1;
static gint ett_nr_rrc_T_messageClassExtension_09 = -1;
static gint ett_nr_rrc_MasterInformationBlockSidelink = -1;
static gint ett_nr_rrc_MeasurementReportSidelink = -1;
static gint ett_nr_rrc_T_criticalExtensions_47 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_47 = -1;
static gint ett_nr_rrc_MeasurementReportSidelink_IEs_r16 = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_54 = -1;
static gint ett_nr_rrc_SL_MeasResults_r16 = -1;
static gint ett_nr_rrc_SL_MeasResult_r16 = -1;
static gint ett_nr_rrc_SL_MeasQuantityResult_r16 = -1;
static gint ett_nr_rrc_RRCReconfigurationSidelink = -1;
static gint ett_nr_rrc_T_criticalExtensions_48 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_48 = -1;
static gint ett_nr_rrc_RRCReconfigurationSidelink_IEs_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSLRB_r16_OF_SLRB_Config_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSLRB_r16_OF_SLRB_PC5_ConfigIndex_r16 = -1;
static gint ett_nr_rrc_T_sl_MeasConfig_r16 = -1;
static gint ett_nr_rrc_T_sl_CSI_RS_Config_r16 = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_55 = -1;
static gint ett_nr_rrc_SLRB_Config_r16 = -1;
static gint ett_nr_rrc_SL_SDAP_ConfigPC5_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSL_QFIsPerDest_r16_OF_SL_PQFI_r16 = -1;
static gint ett_nr_rrc_SL_PDCP_ConfigPC5_r16 = -1;
static gint ett_nr_rrc_SL_RLC_ConfigPC5_r16 = -1;
static gint ett_nr_rrc_T_sl_AM_RLC_r16_01 = -1;
static gint ett_nr_rrc_T_sl_UM_Bi_Directional_RLC_r16 = -1;
static gint ett_nr_rrc_T_sl_UM_Uni_Directional_RLC_r16 = -1;
static gint ett_nr_rrc_SL_LogicalChannelConfigPC5_r16 = -1;
static gint ett_nr_rrc_SL_CSI_RS_Config_r16 = -1;
static gint ett_nr_rrc_T_sl_CSI_RS_FreqAllocation_r16 = -1;
static gint ett_nr_rrc_RRCReconfigurationCompleteSidelink = -1;
static gint ett_nr_rrc_T_criticalExtensions_49 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_49 = -1;
static gint ett_nr_rrc_RRCReconfigurationCompleteSidelink_IEs_r16 = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_56 = -1;
static gint ett_nr_rrc_RRCReconfigurationFailureSidelink = -1;
static gint ett_nr_rrc_T_criticalExtensions_50 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_50 = -1;
static gint ett_nr_rrc_RRCReconfigurationFailureSidelink_IEs_r16 = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_57 = -1;
static gint ett_nr_rrc_UECapabilityEnquirySidelink = -1;
static gint ett_nr_rrc_T_criticalExtensions_51 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_51 = -1;
static gint ett_nr_rrc_UECapabilityEnquirySidelink_IEs_r16 = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_58 = -1;
static gint ett_nr_rrc_UECapabilityInformationSidelink = -1;
static gint ett_nr_rrc_T_criticalExtensions_52 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_52 = -1;
static gint ett_nr_rrc_UECapabilityInformationSidelink_IEs_r16 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxBands_OF_BandSidelinkPC5_r16 = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_59 = -1;
static gint ett_nr_rrc_PDCP_ParametersSidelink_r16 = -1;
static gint ett_nr_rrc_BandCombinationListSidelinkNR_r16 = -1;
static gint ett_nr_rrc_BandCombinationParametersSidelinkNR_r16 = -1;
static gint ett_nr_rrc_BandSidelinkPC5_r16 = -1;
static gint ett_nr_rrc_T_sl_Reception_r16_01 = -1;
static gint ett_nr_rrc_T_scs_CP_PatternRxSidelink_r16_01 = -1;
static gint ett_nr_rrc_T_fr1_r16_02 = -1;
static gint ett_nr_rrc_T_fr2_r16_03 = -1;
static gint ett_nr_rrc_T_csi_ReportSidelink_r16 = -1;

/*--- End of included file: packet-nr-rrc-ett.c ---*/
#line 108 "./asn1/nr-rrc/packet-nr-rrc-template.c"
static gint ett_nr_rrc_DedicatedNAS_Message = -1;
static gint ett_nr_rrc_targetRAT_MessageContainer = -1;
static gint ett_nr_rrc_nas_Container = -1;
static gint ett_nr_rrc_serialNumber = -1;
static gint ett_nr_rrc_warningType = -1;
static gint ett_nr_rrc_dataCodingScheme = -1;
static gint ett_nr_rrc_sib7_fragment = -1;
static gint ett_nr_rrc_sib7_fragments = -1;
static gint ett_nr_rrc_sib8_fragment = -1;
static gint ett_nr_rrc_sib8_fragments = -1;
static gint ett_nr_rrc_warningMessageSegment = -1;
static gint ett_nr_rrc_timeInfo = -1;
static gint ett_nr_rrc_capabilityRequestFilter = -1;
static gint ett_nr_rrc_sourceSCG_EUTRA_Config = -1;
static gint ett_nr_rrc_scg_CellGroupConfigEUTRA = -1;
static gint ett_nr_rrc_candidateCellInfoListSN_EUTRA = -1;
static gint ett_nr_rrc_candidateCellInfoListMN_EUTRA = -1;
static gint ett_nr_rrc_sourceConfigSCG_EUTRA = -1;
static gint ett_nr_rrc_eutra_SCG = -1;
static gint ett_nr_rrc_nr_SCG_Response = -1;
static gint ett_nr_rrc_eutra_SCG_Response = -1;
static gint ett_nr_rrc_measResultSCG_FailureMRDC = -1;
static gint ett_nr_rrc_ul_DCCH_MessageNR = -1;
static gint ett_nr_rrc_ul_DCCH_MessageEUTRA = -1;
static gint ett_rr_rrc_nas_SecurityParamFromNR = -1;
static gint ett_nr_rrc_sidelinkUEInformationNR = -1;
static gint ett_nr_rrc_sidelinkUEInformationEUTRA = -1;
static gint ett_nr_rrc_ueAssistanceInformationEUTRA = -1;
static gint ett_nr_rrc_dl_DCCH_MessageNR = -1;
static gint ett_nr_rrc_dl_DCCH_MessageEUTRA = -1;
static gint ett_nr_rrc_sl_ConfigDedicatedEUTRA = -1;
static gint ett_nr_rrc_sl_CapabilityInformationSidelink = -1;
static gint ett_nr_rrc_measResult_RLF_Report_EUTRA = -1;
static gint ett_nr_rrc_locationTimestamp_r16 = -1;
static gint ett_nr_rrc_locationCoordinate_r16 = -1;
static gint ett_nr_rrc_locationError_r16 = -1;
static gint ett_nr_rrc_locationSource_r16 = -1;
static gint ett_nr_rrc_velocityEstimate_r16 = -1;
static gint ett_nr_rrc_sensor_MeasurementInformation_r16 = -1;
static gint ett_nr_rrc_sensor_MotionInformation_r16 = -1;
static gint ett_nr_rrc_bandParametersSidelinkEUTRA1_r16 = -1;
static gint ett_nr_rrc_bandParametersSidelinkEUTRA2_r16 = -1;
static gint ett_nr_rrc_sl_ParametersEUTRA1_r16 = -1;
static gint ett_nr_rrc_sl_ParametersEUTRA2_r16 = -1;
static gint ett_nr_rrc_sl_ParametersEUTRA3_r16 = -1;
static gint ett_nr_rrc_absTimeInfo = -1;
static gint ett_nr_rrc_assistanceDataSIB_Element_r16 = -1;
static gint ett_nr_sl_V2X_ConfigCommon_r16 = -1;
static gint ett_nr_tdd_Config_r16 = -1;

static expert_field ei_nr_rrc_number_pages_le15 = EI_INIT;

/* Forward declarations */
static int dissect_UECapabilityInformationSidelink_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_DL_DCCH_Message_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_DL_CCCH_Message_PDU(tvbuff_t* tvb _U_, packet_info* pinfo _U_, proto_tree* tree _U_, void* data _U_);
static int dissect_UL_CCCH_Message_PDU(tvbuff_t* tvb _U_, packet_info* pinfo _U_, proto_tree* tree _U_, void* data _U_);
static int dissect_UERadioAccessCapabilityInformation_PDU(tvbuff_t* tvb _U_, packet_info* pinfo _U_, proto_tree* tree _U_, void* data _U_);

static const unit_name_string units_periodicities = { " periodicity", " periodicities" };
static const unit_name_string units_prbs = { " PRB", " PRBs" };
static const unit_name_string units_slots = { " slot", " slots" };

typedef struct {
  guint8 rat_type;
  guint8 target_rat_type;
  guint16 message_identifier;
  guint8 warning_message_segment_type;
  guint8 warning_message_segment_number;
  nr_drb_mac_rlc_mapping_t drb_rlc_mapping;
  nr_drb_rlc_pdcp_mapping_t drb_pdcp_mapping;
  lpp_pos_sib_type_t pos_sib_type;
  pdcp_nr_security_info_t pdcp_security;
} nr_rrc_private_data_t;

/* Helper function to get or create a struct that will be actx->private_data */
static nr_rrc_private_data_t*
nr_rrc_get_private_data(asn1_ctx_t *actx)
{
  if (actx->private_data == NULL) {
    actx->private_data = wmem_new0(actx->pinfo->pool, nr_rrc_private_data_t);
  }
  return (nr_rrc_private_data_t*)actx->private_data;
}


static void
nr_rrc_call_dissector(dissector_handle_t handle, tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree)
{
  TRY {
    call_dissector(handle, tvb, pinfo, tree);
  }
  CATCH_BOUNDS_ERRORS {
    show_exception(tvb, pinfo, tree, EXCEPT_CODE, GET_MESSAGE);
  }
  ENDTRY;
}

static void
nr_rrc_q_RxLevMin_fmt(gchar *s, guint32 v)
{
  gint32 d = (gint32)v;

  snprintf(s, ITEM_LABEL_LENGTH, "%d dB (%d)", 2*d, d);
}

static const value_string nr_rrc_serialNumber_gs_vals[] = {
  { 0, "Display mode immediate, cell wide"},
  { 1, "Display mode normal, PLMN wide"},
  { 2, "Display mode normal, tracking area wide"},
  { 3, "Display mode normal, cell wide"},
  { 0, NULL},
};

static const value_string nr_rrc_warningType_vals[] = {
  { 0, "Earthquake"},
  { 1, "Tsunami"},
  { 2, "Earthquake and Tsunami"},
  { 3, "Test"},
  { 4, "Other"},
  { 0, NULL},
};

static const fragment_items nr_rrc_sib7_frag_items = {
    &ett_nr_rrc_sib7_fragment,
    &ett_nr_rrc_sib7_fragments,
    &hf_nr_rrc_sib7_fragments,
    &hf_nr_rrc_sib7_fragment,
    &hf_nr_rrc_sib7_fragment_overlap,
    &hf_nr_rrc_sib7_fragment_overlap_conflict,
    &hf_nr_rrc_sib7_fragment_multiple_tails,
    &hf_nr_rrc_sib7_fragment_too_long_fragment,
    &hf_nr_rrc_sib7_fragment_error,
    &hf_nr_rrc_sib7_fragment_count,
    &hf_nr_rrc_sib7_reassembled_in,
    &hf_nr_rrc_sib7_reassembled_length,
    &hf_nr_rrc_sib7_reassembled_data,
    "SIB7 warning message segments"
};

static const fragment_items nr_rrc_sib8_frag_items = {
    &ett_nr_rrc_sib8_fragment,
    &ett_nr_rrc_sib8_fragments,
    &hf_nr_rrc_sib8_fragments,
    &hf_nr_rrc_sib8_fragment,
    &hf_nr_rrc_sib8_fragment_overlap,
    &hf_nr_rrc_sib8_fragment_overlap_conflict,
    &hf_nr_rrc_sib8_fragment_multiple_tails,
    &hf_nr_rrc_sib8_fragment_too_long_fragment,
    &hf_nr_rrc_sib8_fragment_error,
    &hf_nr_rrc_sib8_fragment_count,
    &hf_nr_rrc_sib8_reassembled_in,
    &hf_nr_rrc_sib8_reassembled_length,
    &hf_nr_rrc_sib8_reassembled_data,
    "SIB8 warning message segments"
};

static void
dissect_nr_rrc_warningMessageSegment(tvbuff_t *warning_msg_seg_tvb, proto_tree *tree, packet_info *pinfo, guint8 dataCodingScheme)
{
  guint32 offset;
  guint8 nb_of_pages, length, *str;
  proto_item *ti;
  tvbuff_t *cb_data_page_tvb, *cb_data_tvb;
  int i;

  nb_of_pages = tvb_get_guint8(warning_msg_seg_tvb, 0);
  ti = proto_tree_add_uint(tree, hf_nr_rrc_warningMessageSegment_nb_pages, warning_msg_seg_tvb, 0, 1, nb_of_pages);
  if (nb_of_pages > 15) {
    expert_add_info_format(pinfo, ti, &ei_nr_rrc_number_pages_le15,
                           "Number of pages should be <=15 (found %u)", nb_of_pages);
    nb_of_pages = 15;
  }
  for (i = 0, offset = 1; i < nb_of_pages; i++) {
    length = tvb_get_guint8(warning_msg_seg_tvb, offset+82);
    cb_data_page_tvb = tvb_new_subset_length(warning_msg_seg_tvb, offset, length);
    cb_data_tvb = dissect_cbs_data(dataCodingScheme, cb_data_page_tvb, tree, pinfo, 0);
    if (cb_data_tvb) {
      str = tvb_get_string_enc(pinfo->pool, cb_data_tvb, 0, tvb_reported_length(cb_data_tvb), ENC_UTF_8|ENC_NA);
      proto_tree_add_string_format(tree, hf_nr_rrc_warningMessageSegment_decoded_page, warning_msg_seg_tvb, offset, 83,
                                   str, "Decoded Page %u: %s", i+1, str);
    }
    offset += 83;
  }
}

static const value_string nr_rrc_daylightSavingTime_vals[] = {
  { 0, "No adjustment for Daylight Saving Time"},
  { 1, "+1 hour adjustment for Daylight Saving Time"},
  { 2, "+2 hours adjustment for Daylight Saving Time"},
  { 3, "Reserved"},
  { 0, NULL},
};

static void
nr_rrc_localTimeOffset_fmt(gchar *s, guint32 v)
{
  gint32 time_offset = (gint32) v;

  snprintf(s, ITEM_LABEL_LENGTH, "UTC time %c %dhr %dmin (%d)",
             (time_offset < 0) ? '-':'+', abs(time_offset) >> 2,
             (abs(time_offset) & 0x03) * 15, time_offset);
}

static void
nr_rrc_drx_SlotOffset_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%g ms (%u)", 1./32 * v, v);
}

static void
nr_rrc_Hysteresis_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%gdB (%u)", 0.5 * v, v);
}

static void
nr_rrc_msg3_DeltaPreamble_fmt(gchar *s, guint32 v)
{
  gint32 d = (gint32)v;

  snprintf(s, ITEM_LABEL_LENGTH, "%ddB (%d)", 2 * d, d);
}

static void
nr_rrc_Q_RxLevMin_fmt(gchar *s, guint32 v)
{
  gint32 d = (gint32)v;

  snprintf(s, ITEM_LABEL_LENGTH, "%ddBm (%d)", 2 * d, d);
}

static void
nr_rrc_RSRP_RangeEUTRA_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "RSRP < -140dBm (0)");
  } else if (v < 97) {
    snprintf(s, ITEM_LABEL_LENGTH, "%ddBm <= RSRP < %ddBm (%u)", v-141, v-140, v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "-44dBm <= RSRP (97)");
  }
}

static void
nr_rrc_RSRQ_RangeEUTRA_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "RSRQ < -19.5dB (0)");
  } else if (v < 34) {
    snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB <= RSRQ < %.1fdB (%u)", ((float)v/2)-20, (((float)v+1)/2)-20, v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "-3dB <= RSRQ (34)");
  }
}

static void
nr_rrc_SINR_RangeEUTRA_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "SINR < -23dB (0)");
  } else if (v == 127) {
    snprintf(s, ITEM_LABEL_LENGTH, "40dB <= SINR (127)");
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB <= SINR < %.1fdB (%u)", (((float)v-1)/2)-23, ((float)v/2)-23, v);
  }
}

static void
nr_rrc_ReselectionThreshold_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%udB (%u)", 2 * v, v);
}

static void
nr_rrc_RSRP_Range_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "SS-RSRP < -156dBm (0)");
  } else if (v < 126) {
    snprintf(s, ITEM_LABEL_LENGTH, "%ddBm <= SS-RSRP < %ddBm (%u)", v-157, v-156, v);
  } else if (v == 126) {
    snprintf(s, ITEM_LABEL_LENGTH, "-31dBm <= SS-RSRP (126)");
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "infinity (127)");
  }
}

static void
nr_rrc_RSRQ_Range_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "SS-RSRQ < -43dB (0)");
  } else if (v < 127) {
    snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB <= SS-RSRQ < %.1fdB (%u)", (((float)v-1)/2)-43, ((float)v/2)-43, v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "-20dB <= SS-RSRQ (127)");
  }
}

static void
nr_rrc_SINR_Range_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "SS-SINR < -23dB (0)");
  } else if (v < 127) {
    snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB <= SS-SINR < %.1fdB (%u)", (((float)v-1)/2)-23, ((float)v/2)-23, v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "40dB <= SS-SINR (127)");
  }
}

static void
nr_rrc_dl_1024QAM_TotalWeightedLayers_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%u (%u)", 10+(2*v), v);
}

static void
nr_rrc_timeConnFailure_r16_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%ums (%u)", 100*v, v);
}

static void
nr_rrc_RSSI_Range_r16_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "RSSI < -100dBm (0)");
  } else if (v < 76) {
    snprintf(s, ITEM_LABEL_LENGTH, "%ddBm <= RSSI < %ddBm (%u)", v-101, v-100, v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "-25dBm <= RSSI (76)");
  }
}

static void
nr_rrc_RSRQ_RangeEUTRA_r16_fmt(gchar *s, guint32 v)
{
  gint32 d = (gint32)v;

  if (d == -34) {
    snprintf(s, ITEM_LABEL_LENGTH, "RSRQ < -36dB (-34)");
  } else if (d < 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB <= RSRQ < %.1fdB (%d)", (((float)d-1)/2)-19, ((float)d/2)-19, d);
  } else if (d == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "RSRQ < -19.5dB (0)");
  } else if (d < 34) {
    snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB <= RSRQ < %.1fdB (%d)", (((float)d-1)/2)-19.5, ((float)d/2)-19.5, d);
  } else if (d == 34) {
    snprintf(s, ITEM_LABEL_LENGTH, "-3dB <= RSRQ (34)");
  } else if (d < 46) {
    snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB <= RSRQ < %.1fdB (%d)", (((float)d-1)/2)-20, ((float)d/2)-20, d);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "2.5dB <= RSRQ (46)");
  }
}

static void
nr_rrc_utra_FDD_RSCP_r16_fmt(gchar *s, guint32 v)
{
  gint32 d = (gint32)v;

  if (d == -5) {
    snprintf(s, ITEM_LABEL_LENGTH, "RSCP < -120dBm (-5)");
  } else if (d < 91) {
    snprintf(s, ITEM_LABEL_LENGTH, "%ddBm <= RSCP < %ddB (%d)", d-116, d-115, d);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "-25dBm <= RSCP (91)");
  }
}

static void
nr_rrc_utra_FDD_EcN0_r16_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "Ec/No < -24dB (0)");
  } else if (v < 49) {
    snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB <= Ec/No < %.1fdB (%u)", (((float)v-1)/2)-24, ((float)v/2)-24, v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "0dB <= Ec/No (49)");
  }
}

static void
nr_rrc_averageDelay_r16_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1fms (%u)", (float)v/10, v);
}

static void
nr_rrc_measTriggerQuantity_utra_FDD_RSCP_r16_fmt(gchar *s, guint32 v)
{
  gint32 d = (gint32)v;

  snprintf(s, ITEM_LABEL_LENGTH, "%ddBm (%d)", d-115, d);
}

static void
nr_rrc_measTriggerQuantity_utra_FDD_EcN0_r16_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB (%u)", (float)v/2-24.5, v);
}

static void
nr_rrc_SRS_RSRP_r16_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "SRS-RSRP < -140dBm (0)");
  } else if (v < 97) {
    snprintf(s, ITEM_LABEL_LENGTH, "%ddBm <= SRS-RSRP < %ddB (%u)", v-141, v-140, v);
  } else if (v == 97) {
    snprintf(s, ITEM_LABEL_LENGTH, "-44dBm <= SRS-RSRP (97)");
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "Infinity (98)");
  }
}

static void
nr_rrc_MeasTriggerQuantityOffset_fmt(gchar *s, guint32 v)
{
  gint32 d = (gint32)v;

  snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB (%d)", (float)d/2, d);
}

static int
dissect_nr_rrc_cg_configinfo_msg(tvbuff_t* tvb _U_, packet_info* pinfo _U_, proto_tree* tree _U_, void* data _U_)
{
    proto_item* ti;
    proto_tree* sub_tree;

    col_set_str(pinfo->cinfo, COL_PROTOCOL, "NR RRC");
    col_set_str(pinfo->cinfo, COL_INFO, "CG-ConfigInfo");

    ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
    sub_tree = proto_item_add_subtree(ti, ett_nr_rrc);
    return dissect_nr_rrc_CG_ConfigInfo_PDU(tvb, pinfo, sub_tree, NULL);
}

static int
dissect_nr_rrc_radiobearerconfig_msg(tvbuff_t* tvb _U_, packet_info* pinfo _U_, proto_tree* tree _U_, void* data _U_)
{
    proto_item* ti;
    proto_tree* sub_tree;

    col_set_str(pinfo->cinfo, COL_PROTOCOL, "NR RRC");
    col_set_str(pinfo->cinfo, COL_INFO, "RadioBearerConfig");

    ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
    sub_tree = proto_item_add_subtree(ti, ett_nr_rrc);
    return dissect_nr_rrc_RadioBearerConfig_PDU(tvb, pinfo, sub_tree, NULL);
}

static int
dissect_nr_rrc_ue_mrdc_capability_msg(tvbuff_t* tvb _U_, packet_info* pinfo _U_, proto_tree* tree _U_, void* data _U_)
{
    proto_item* ti;
    proto_tree* sub_tree;

    col_set_str(pinfo->cinfo, COL_PROTOCOL, "NR RRC");
    col_set_str(pinfo->cinfo, COL_INFO, "UE-MRDC-Capability");

    ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
    sub_tree = proto_item_add_subtree(ti, ett_nr_rrc);
    return dissect_nr_rrc_UE_MRDC_Capability_PDU(tvb, pinfo, sub_tree, NULL);
}

static int
dissect_nr_rrc_ue_nr_capability_msg(tvbuff_t* tvb _U_, packet_info* pinfo _U_, proto_tree* tree _U_, void* data _U_)
{
    proto_item* ti;
    proto_tree* sub_tree;

    col_set_str(pinfo->cinfo, COL_PROTOCOL, "NR RRC");
    col_set_str(pinfo->cinfo, COL_INFO, "UE-NR-Capability");

    ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
    sub_tree = proto_item_add_subtree(ti, ett_nr_rrc);
    return dissect_nr_rrc_UE_NR_Capability_PDU(tvb, pinfo, sub_tree, NULL);
}

static int
dissect_nr_rrc_ul_dcch_message_msg(tvbuff_t* tvb _U_, packet_info* pinfo _U_, proto_tree* tree _U_, void* data _U_)
{
    proto_item* ti;
    proto_tree* sub_tree;

    col_set_str(pinfo->cinfo, COL_PROTOCOL, "NR RRC");
    col_set_str(pinfo->cinfo, COL_INFO, "UL-DCCH-Message");

    ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
    sub_tree = proto_item_add_subtree(ti, ett_nr_rrc);
    return dissect_nr_rrc_UL_DCCH_Message_PDU(tvb, pinfo, sub_tree, NULL);
}

static int
dissect_nr_rrc_dl_dcch_message_msg(tvbuff_t* tvb _U_, packet_info* pinfo _U_, proto_tree* tree _U_, void* data _U_)
{
    proto_item* ti;
    proto_tree* sub_tree;

    col_set_str(pinfo->cinfo, COL_PROTOCOL, "NR RRC");
    col_set_str(pinfo->cinfo, COL_INFO, "DL-DCCH-Message");

    ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
    sub_tree = proto_item_add_subtree(ti, ett_nr_rrc);
    return dissect_DL_DCCH_Message_PDU(tvb, pinfo, sub_tree, NULL);
}

static int
dissect_nr_rrc_dl_ccch_message_msg(tvbuff_t* tvb _U_, packet_info* pinfo _U_, proto_tree* tree _U_, void* data _U_)
{
    proto_item* ti;
    proto_tree* sub_tree;

    col_set_str(pinfo->cinfo, COL_PROTOCOL, "NR RRC");
    col_set_str(pinfo->cinfo, COL_INFO, "DL-CCCH-Message");

    ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
    sub_tree = proto_item_add_subtree(ti, ett_nr_rrc);
    return dissect_DL_CCCH_Message_PDU(tvb, pinfo, sub_tree, NULL);
}

static int
dissect_nr_rrc_ul_ccch_message_msg(tvbuff_t* tvb _U_, packet_info* pinfo _U_, proto_tree* tree _U_, void* data _U_)
{
    proto_item* ti;
    proto_tree* sub_tree;

    col_set_str(pinfo->cinfo, COL_PROTOCOL, "NR RRC");
    col_set_str(pinfo->cinfo, COL_INFO, "UL-CCCH-Message");

    ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
    sub_tree = proto_item_add_subtree(ti, ett_nr_rrc);
    return dissect_UL_CCCH_Message_PDU(tvb, pinfo, sub_tree, NULL);
}


static int
dissect_nr_rrc_cellgroupconfig_msg(tvbuff_t* tvb _U_, packet_info* pinfo _U_, proto_tree* tree _U_, void* data _U_)
{
    proto_item* ti;
    proto_tree* sub_tree;

    col_set_str(pinfo->cinfo, COL_PROTOCOL, "NR RRC");
    col_set_str(pinfo->cinfo, COL_INFO, "CellGroupConfig");

    ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
    sub_tree = proto_item_add_subtree(ti, ett_nr_rrc);
    return dissect_nr_rrc_CellGroupConfig_PDU(tvb, pinfo, sub_tree, NULL);
}

static int
dissect_ueradioaccesscapabilityinformation_msg(tvbuff_t* tvb _U_, packet_info* pinfo _U_, proto_tree* tree _U_, void* data _U_)
{
    proto_item* ti;
    proto_tree* sub_tree;

    col_set_str(pinfo->cinfo, COL_PROTOCOL, "NR RRC");
    col_set_str(pinfo->cinfo, COL_INFO, "UERadioAccessCapabilityInformation");

    ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
    sub_tree = proto_item_add_subtree(ti, ett_nr_rrc);
    return dissect_UERadioAccessCapabilityInformation_PDU(tvb, pinfo, sub_tree, NULL);
}

static int
dissect_nr_rrc_measconfig_msg(tvbuff_t* tvb _U_, packet_info* pinfo _U_, proto_tree* tree _U_, void* data _U_)
{
    proto_item* ti;
    proto_tree* sub_tree;

    col_set_str(pinfo->cinfo, COL_PROTOCOL, "NR RRC");
    col_set_str(pinfo->cinfo, COL_INFO, "MeasConfig");

    ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
    sub_tree = proto_item_add_subtree(ti, ett_nr_rrc);
    return dissect_nr_rrc_MeasConfig_PDU(tvb, pinfo, sub_tree, NULL);
}

static int
dissect_nr_rrc_measgapconfig_msg(tvbuff_t* tvb _U_, packet_info* pinfo _U_, proto_tree* tree _U_, void* data _U_)
{
    proto_item* ti;
    proto_tree* sub_tree;

    col_set_str(pinfo->cinfo, COL_PROTOCOL, "NR RRC");
    col_set_str(pinfo->cinfo, COL_INFO, "MeasGapConfig");

    ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
    sub_tree = proto_item_add_subtree(ti, ett_nr_rrc);
    return dissect_nr_rrc_MeasGapConfig_PDU(tvb, pinfo, sub_tree, NULL);
}

static int
dissect_nr_rrc_handoverpreparationinformation_msg(tvbuff_t* tvb _U_, packet_info* pinfo _U_, proto_tree* tree _U_, void* data _U_)
{
    proto_item* ti;
    proto_tree* sub_tree;

    col_set_str(pinfo->cinfo, COL_PROTOCOL, "NR RRC");
    col_set_str(pinfo->cinfo, COL_INFO, "MeasGapConfig");

    ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
    sub_tree = proto_item_add_subtree(ti, ett_nr_rrc);
    return dissect_nr_rrc_HandoverPreparationInformation_PDU(tvb, pinfo, sub_tree, NULL);
}



static int
dissect_nr_rrc_rrcreconfiguration_msg(tvbuff_t* tvb _U_, packet_info* pinfo _U_, proto_tree* tree _U_, void* data _U_)
{
    proto_item* ti;
    proto_tree* sub_tree;

    col_set_str(pinfo->cinfo, COL_PROTOCOL, "NR RRC");
    col_set_str(pinfo->cinfo, COL_INFO, "RRCReconfiguration");

    ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
    sub_tree = proto_item_add_subtree(ti, ett_nr_rrc);
    return dissect_nr_rrc_RRCReconfiguration_PDU(tvb, pinfo, sub_tree, NULL);
}


static int
dissect_nr_rrc_ue_capabilityrat_containerlist_msg(tvbuff_t* tvb _U_, packet_info* pinfo _U_, proto_tree* tree _U_, void* data _U_)
{
    proto_item* ti;
    proto_tree* sub_tree;

    col_set_str(pinfo->cinfo, COL_PROTOCOL, "NR RRC");
    col_set_str(pinfo->cinfo, COL_INFO, "UE-CapabilityRAT-ContainerList");

    ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
    sub_tree = proto_item_add_subtree(ti, ett_nr_rrc);
    return dissect_nr_rrc_UE_CapabilityRAT_ContainerList_PDU(tvb, pinfo, sub_tree, NULL);
}

static int
dissect_nr_rrc_handovercommand_msg(tvbuff_t* tvb _U_, packet_info* pinfo _U_, proto_tree* tree _U_, void* data _U_)
{
    proto_item* ti;
    proto_tree* sub_tree;

    col_set_str(pinfo->cinfo, COL_PROTOCOL, "NR RRC");
    col_set_str(pinfo->cinfo, COL_INFO, "HandoverCommand");

    ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
    sub_tree = proto_item_add_subtree(ti, ett_nr_rrc);
    return dissect_nr_rrc_HandoverCommand_PDU(tvb, pinfo, sub_tree, NULL);
}



/*--- Included file: packet-nr-rrc-fn.c ---*/
#line 1 "./asn1/nr-rrc/packet-nr-rrc-fn.c"
/*--- PDUs declarations ---*/
static int dissect_MeasResultList2NR_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_OverheatingAssistance_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_SystemInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_PosSystemInformation_r16_IEs_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_UECapabilityEnquiry_v1560_IEs_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_UE_MRDC_Capability_v15g0_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_UE_NR_Capability_v15c0_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);



static int
dissect_nr_rrc_T_handoverCommandMessage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_RRCReconfiguration_PDU);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension, T_nonCriticalExtension_sequence);

  return offset;
}


static const per_sequence_t HandoverCommand_IEs_sequence[] = {
  { &hf_nr_rrc_handoverCommandMessage, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_handoverCommandMessage },
  { &hf_nr_rrc_nonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_HandoverCommand_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_HandoverCommand_IEs, HandoverCommand_IEs_sequence);

  return offset;
}



static int
dissect_nr_rrc_NULL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string nr_rrc_T_c1_vals[] = {
  {   0, "handoverCommand" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_choice[] = {
  {   0, &hf_nr_rrc_handoverCommand, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_HandoverCommand_IEs },
  {   1, &hf_nr_rrc_spare3       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   2, &hf_nr_rrc_spare2       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   3, &hf_nr_rrc_spare1       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_c1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_c1, T_c1_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture, T_criticalExtensionsFuture_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_choice[] = {
  {   0, &hf_nr_rrc_c1           , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_c1 },
  {   1, &hf_nr_rrc_criticalExtensionsFuture, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions, T_criticalExtensions_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t HandoverCommand_sequence[] = {
  { &hf_nr_rrc_criticalExtensions, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_HandoverCommand(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_HandoverCommand, HandoverCommand_sequence);

  return offset;
}


static const value_string nr_rrc_RAT_Type_vals[] = {
  { RAT_Type_nr, "nr" },
  { RAT_Type_eutra_nr, "eutra-nr" },
  { RAT_Type_eutra, "eutra" },
  { RAT_Type_utra_fdd_v1610, "utra-fdd-v1610" },
  { 0, NULL }
};


static int
dissect_nr_rrc_RAT_Type(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  guint32 rat_type;
  nr_rrc_private_data_t *nr_priv = nr_rrc_get_private_data(actx);
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, &rat_type, TRUE, 0, NULL);

  nr_priv->rat_type = (guint8)rat_type;


  return offset;
}



static int
dissect_nr_rrc_T_ue_CapabilityRAT_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *ue_cap_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &ue_cap_tvb);



  if (ue_cap_tvb) {
    nr_rrc_private_data_t *nr_priv = nr_rrc_get_private_data(actx);
    proto_tree *subtree;

    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_UE_CapabilityRAT_Container);
    switch(nr_priv->rat_type){
    case RAT_Type_nr:
      dissect_nr_rrc_UE_NR_Capability_PDU(ue_cap_tvb, actx->pinfo, subtree, NULL);
      break;
    case RAT_Type_eutra_nr:
      dissect_nr_rrc_UE_MRDC_Capability_PDU(ue_cap_tvb, actx->pinfo, subtree, NULL);
      break;
    case RAT_Type_eutra:
      dissect_lte_rrc_UE_EUTRA_Capability_PDU(ue_cap_tvb, actx->pinfo, subtree, NULL);
      break;
    case RAT_Type_utra_fdd_v1610:
      dissect_rrc_InterRATHandoverInfo_PDU(ue_cap_tvb, actx->pinfo, subtree, NULL);
      break;
    default:
      break;
    }
  }

  return offset;
}


static const per_sequence_t UE_CapabilityRAT_Container_sequence[] = {
  { &hf_nr_rrc_rat_Type     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RAT_Type },
  { &hf_nr_rrc_ue_CapabilityRAT_Container, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_ue_CapabilityRAT_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_UE_CapabilityRAT_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  nr_rrc_private_data_t *nr_priv = nr_rrc_get_private_data(actx);
  /* Initialise to invalid value */
  nr_priv->rat_type = 0xFF;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_UE_CapabilityRAT_Container, UE_CapabilityRAT_Container_sequence);



  return offset;
}


static const per_sequence_t UE_CapabilityRAT_ContainerList_sequence_of[1] = {
  { &hf_nr_rrc_UE_CapabilityRAT_ContainerList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_UE_CapabilityRAT_Container },
};

static int
dissect_nr_rrc_UE_CapabilityRAT_ContainerList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_UE_CapabilityRAT_ContainerList, UE_CapabilityRAT_ContainerList_sequence_of,
                                                  0, maxRAT_CapabilityContainers, FALSE);

  return offset;
}



static int
dissect_nr_rrc_T_rrcReconfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_RRCReconfiguration_PDU);

  return offset;
}



static int
dissect_nr_rrc_T_sourceRB_SN_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_RadioBearerConfig_PDU);

  return offset;
}



static int
dissect_nr_rrc_T_sourceSCG_NR_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_RRCReconfiguration_PDU);

  return offset;
}



static int
dissect_nr_rrc_T_sourceSCG_EUTRA_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *src_scg_eutra_config_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &src_scg_eutra_config_tvb);

  if (src_scg_eutra_config_tvb && lte_rrc_conn_reconf_handle) {
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_targetRAT_MessageContainer);
    nr_rrc_call_dissector(lte_rrc_conn_reconf_handle, src_scg_eutra_config_tvb, actx->pinfo, subtree);
  }


  return offset;
}


static const per_sequence_t AS_Config_eag_1_sequence[] = {
  { &hf_nr_rrc_sourceRB_SN_Config, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_sourceRB_SN_Config },
  { &hf_nr_rrc_sourceSCG_NR_Config, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_sourceSCG_NR_Config },
  { &hf_nr_rrc_sourceSCG_EUTRA_Config, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_sourceSCG_EUTRA_Config },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_AS_Config_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, AS_Config_eag_1_sequence);

  return offset;
}


static const value_string nr_rrc_T_sourceSCG_Configured_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_sourceSCG_Configured(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t AS_Config_eag_2_sequence[] = {
  { &hf_nr_rrc_sourceSCG_Configured, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_sourceSCG_Configured },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_AS_Config_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, AS_Config_eag_2_sequence);

  return offset;
}


static const per_sequence_t AS_Config_sequence[] = {
  { &hf_nr_rrc_rrcReconfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_rrcReconfiguration },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_AS_Config_eag_1 },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_AS_Config_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_AS_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_AS_Config, AS_Config_sequence);

  return offset;
}


static const value_string nr_rrc_T_ue_InactiveTime_vals[] = {
  {   0, "s1" },
  {   1, "s2" },
  {   2, "s3" },
  {   3, "s5" },
  {   4, "s7" },
  {   5, "s10" },
  {   6, "s15" },
  {   7, "s20" },
  {   8, "s25" },
  {   9, "s30" },
  {  10, "s40" },
  {  11, "s50" },
  {  12, "min1" },
  {  13, "min1s20" },
  {  14, "min1s40" },
  {  15, "min2" },
  {  16, "min2s30" },
  {  17, "min3" },
  {  18, "min3s30" },
  {  19, "min4" },
  {  20, "min5" },
  {  21, "min6" },
  {  22, "min7" },
  {  23, "min8" },
  {  24, "min9" },
  {  25, "min10" },
  {  26, "min12" },
  {  27, "min14" },
  {  28, "min17" },
  {  29, "min20" },
  {  30, "min24" },
  {  31, "min28" },
  {  32, "min33" },
  {  33, "min38" },
  {  34, "min44" },
  {  35, "min50" },
  {  36, "hr1" },
  {  37, "hr1min30" },
  {  38, "hr2" },
  {  39, "hr2min30" },
  {  40, "hr3" },
  {  41, "hr3min30" },
  {  42, "hr4" },
  {  43, "hr5" },
  {  44, "hr6" },
  {  45, "hr8" },
  {  46, "hr10" },
  {  47, "hr13" },
  {  48, "hr16" },
  {  49, "hr20" },
  {  50, "day1" },
  {  51, "day1hr12" },
  {  52, "day2" },
  {  53, "day2hr12" },
  {  54, "day3" },
  {  55, "day4" },
  {  56, "day5" },
  {  57, "day7" },
  {  58, "day10" },
  {  59, "day14" },
  {  60, "day19" },
  {  61, "day24" },
  {  62, "day30" },
  {  63, "dayMoreThan30" },
  { 0, NULL }
};

static value_string_ext nr_rrc_T_ue_InactiveTime_vals_ext = VALUE_STRING_EXT_INIT(nr_rrc_T_ue_InactiveTime_vals);


static int
dissect_nr_rrc_T_ue_InactiveTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     64, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_ARFCN_ValueNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNARFCN, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_PhysCellId(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1007U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_RSRP_Range(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_RSRQ_Range(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_SINR_Range(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}


static const per_sequence_t MeasQuantityResults_sequence[] = {
  { &hf_nr_rrc_measQuantityResults_rsrp, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RSRP_Range },
  { &hf_nr_rrc_measQuantityResults_rsrq, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RSRQ_Range },
  { &hf_nr_rrc_measQuantityResultssinr, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SINR_Range },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasQuantityResults(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasQuantityResults, MeasQuantityResults_sequence);

  return offset;
}


static const per_sequence_t T_cellResults_sequence[] = {
  { &hf_nr_rrc_resultsSSB_Cell, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasQuantityResults },
  { &hf_nr_rrc_resultsCSI_RS_Cell, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasQuantityResults },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_cellResults(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_cellResults, T_cellResults_sequence);

  return offset;
}



static int
dissect_nr_rrc_SSB_Index(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrofSSBs_1, NULL, FALSE);

  return offset;
}


static const per_sequence_t ResultsPerSSB_Index_sequence[] = {
  { &hf_nr_rrc_ssb_Index    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SSB_Index },
  { &hf_nr_rrc_ssb_Results  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasQuantityResults },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ResultsPerSSB_Index(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ResultsPerSSB_Index, ResultsPerSSB_Index_sequence);

  return offset;
}


static const per_sequence_t ResultsPerSSB_IndexList_sequence_of[1] = {
  { &hf_nr_rrc_ResultsPerSSB_IndexList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ResultsPerSSB_Index },
};

static int
dissect_nr_rrc_ResultsPerSSB_IndexList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_ResultsPerSSB_IndexList, ResultsPerSSB_IndexList_sequence_of,
                                                  1, maxNrofIndexesToReport2, FALSE);

  return offset;
}



static int
dissect_nr_rrc_CSI_RS_Index(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrofCSI_RS_ResourcesRRM_1, NULL, FALSE);

  return offset;
}


static const per_sequence_t ResultsPerCSI_RS_Index_sequence[] = {
  { &hf_nr_rrc_csi_RS_Index , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CSI_RS_Index },
  { &hf_nr_rrc_csi_RS_Results, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasQuantityResults },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ResultsPerCSI_RS_Index(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ResultsPerCSI_RS_Index, ResultsPerCSI_RS_Index_sequence);

  return offset;
}


static const per_sequence_t ResultsPerCSI_RS_IndexList_sequence_of[1] = {
  { &hf_nr_rrc_ResultsPerCSI_RS_IndexList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ResultsPerCSI_RS_Index },
};

static int
dissect_nr_rrc_ResultsPerCSI_RS_IndexList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_ResultsPerCSI_RS_IndexList, ResultsPerCSI_RS_IndexList_sequence_of,
                                                  1, maxNrofIndexesToReport2, FALSE);

  return offset;
}


static const per_sequence_t T_rsIndexResults_sequence[] = {
  { &hf_nr_rrc_resultsSSB_Indexes, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ResultsPerSSB_IndexList },
  { &hf_nr_rrc_resultsCSI_RS_Indexes, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ResultsPerCSI_RS_IndexList },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_rsIndexResults(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_rsIndexResults, T_rsIndexResults_sequence);

  return offset;
}


static const per_sequence_t T_measResult_sequence[] = {
  { &hf_nr_rrc_cellResults  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_cellResults },
  { &hf_nr_rrc_rsIndexResults, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_rsIndexResults },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_measResult(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_measResult, T_measResult_sequence);

  return offset;
}



static int
dissect_nr_rrc_MCC_MNC_Digit(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, FALSE);

  return offset;
}


static const per_sequence_t MCC_sequence_of[1] = {
  { &hf_nr_rrc_MCC_item     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MCC_MNC_Digit },
};

static int
dissect_nr_rrc_MCC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MCC, MCC_sequence_of,
                                                  3, 3, FALSE);

  return offset;
}


static const per_sequence_t MNC_sequence_of[1] = {
  { &hf_nr_rrc_MNC_item     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MCC_MNC_Digit },
};

static int
dissect_nr_rrc_MNC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MNC, MNC_sequence_of,
                                                  2, 3, FALSE);

  return offset;
}


static const per_sequence_t PLMN_Identity_sequence[] = {
  { &hf_nr_rrc_mcc          , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MCC },
  { &hf_nr_rrc_mnc          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MNC },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PLMN_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PLMN_Identity, PLMN_Identity_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxPLMN_OF_PLMN_Identity_sequence_of[1] = {
  { &hf_nr_rrc_plmn_IdentityList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PLMN_Identity },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxPLMN_OF_PLMN_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxPLMN_OF_PLMN_Identity, SEQUENCE_SIZE_1_maxPLMN_OF_PLMN_Identity_sequence_of,
                                                  1, maxPLMN, FALSE);

  return offset;
}



static int
dissect_nr_rrc_TrackingAreaCode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     24, 24, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_nr_rrc_RAN_AreaCode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_CellIdentity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     36, 36, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string nr_rrc_T_cellReservedForOperatorUse_vals[] = {
  {   0, "reserved" },
  {   1, "notReserved" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_cellReservedForOperatorUse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_iab_Support_r16_01_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_iab_Support_r16_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PLMN_IdentityInfo_eag_1_sequence[] = {
  { &hf_nr_rrc_iab_Support_r16_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_iab_Support_r16_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PLMN_IdentityInfo_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, PLMN_IdentityInfo_eag_1_sequence);

  return offset;
}


static const per_sequence_t PLMN_IdentityInfo_sequence[] = {
  { &hf_nr_rrc_plmn_IdentityList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SEQUENCE_SIZE_1_maxPLMN_OF_PLMN_Identity },
  { &hf_nr_rrc_trackingAreaCode, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_TrackingAreaCode },
  { &hf_nr_rrc_ranac        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_RAN_AreaCode },
  { &hf_nr_rrc_cellIdentity , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CellIdentity },
  { &hf_nr_rrc_cellReservedForOperatorUse, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_cellReservedForOperatorUse },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_PLMN_IdentityInfo_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PLMN_IdentityInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PLMN_IdentityInfo, PLMN_IdentityInfo_sequence);

  return offset;
}


static const per_sequence_t PLMN_IdentityInfoList_sequence_of[1] = {
  { &hf_nr_rrc_PLMN_IdentityInfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PLMN_IdentityInfo },
};

static int
dissect_nr_rrc_PLMN_IdentityInfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_PLMN_IdentityInfoList, PLMN_IdentityInfoList_sequence_of,
                                                  1, maxPLMN, FALSE);

  return offset;
}



static int
dissect_nr_rrc_FreqBandIndicatorNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1024U, NULL, FALSE);

  return offset;
}


static const per_sequence_t MultiFrequencyBandListNR_sequence_of[1] = {
  { &hf_nr_rrc_MultiFrequencyBandListNR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_FreqBandIndicatorNR },
};

static int
dissect_nr_rrc_MultiFrequencyBandListNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MultiFrequencyBandListNR, MultiFrequencyBandListNR_sequence_of,
                                                  1, maxNrofMultiBands, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_ControlResourceSetZero(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_SearchSpaceZero(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}


static const per_sequence_t PDCCH_ConfigSIB1_sequence[] = {
  { &hf_nr_rrc_controlResourceSetZero, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ControlResourceSetZero },
  { &hf_nr_rrc_searchSpaceZero, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SearchSpaceZero },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PDCCH_ConfigSIB1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PDCCH_ConfigSIB1, PDCCH_ConfigSIB1_sequence);

  return offset;
}


static const per_sequence_t T_noSIB1_sequence[] = {
  { &hf_nr_rrc_ssb_SubcarrierOffset, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_15 },
  { &hf_nr_rrc_pdcch_ConfigSIB1, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PDCCH_ConfigSIB1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_noSIB1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_noSIB1, T_noSIB1_sequence);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_32(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string nr_rrc_T_manualCAGselectionAllowed_r16_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_manualCAGselectionAllowed_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t CAG_IdentityInfo_r16_sequence[] = {
  { &hf_nr_rrc_cag_Identity_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BIT_STRING_SIZE_32 },
  { &hf_nr_rrc_manualCAGselectionAllowed_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_manualCAGselectionAllowed_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CAG_IdentityInfo_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CAG_IdentityInfo_r16, CAG_IdentityInfo_r16_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxNPN_r16_OF_CAG_IdentityInfo_r16_sequence_of[1] = {
  { &hf_nr_rrc_cag_IdentityList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CAG_IdentityInfo_r16 },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxNPN_r16_OF_CAG_IdentityInfo_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxNPN_r16_OF_CAG_IdentityInfo_r16, SEQUENCE_SIZE_1_maxNPN_r16_OF_CAG_IdentityInfo_r16_sequence_of,
                                                  1, maxNPN_r16, FALSE);

  return offset;
}


static const per_sequence_t T_pni_npn_r16_sequence[] = {
  { &hf_nr_rrc_plmn_Identity_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PLMN_Identity },
  { &hf_nr_rrc_cag_IdentityList_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SEQUENCE_SIZE_1_maxNPN_r16_OF_CAG_IdentityInfo_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_pni_npn_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_pni_npn_r16, T_pni_npn_r16_sequence);

  return offset;
}



static int
dissect_nr_rrc_NID_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     44, 44, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxNPN_r16_OF_NID_r16_sequence_of[1] = {
  { &hf_nr_rrc_nid_List_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_NID_r16 },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxNPN_r16_OF_NID_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxNPN_r16_OF_NID_r16, SEQUENCE_SIZE_1_maxNPN_r16_OF_NID_r16_sequence_of,
                                                  1, maxNPN_r16, FALSE);

  return offset;
}


static const per_sequence_t T_snpn_r16_sequence[] = {
  { &hf_nr_rrc_plmn_Identity_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PLMN_Identity },
  { &hf_nr_rrc_nid_List_r16 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SEQUENCE_SIZE_1_maxNPN_r16_OF_NID_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_snpn_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_snpn_r16, T_snpn_r16_sequence);

  return offset;
}


static const value_string nr_rrc_NPN_Identity_r16_vals[] = {
  {   0, "pni-npn-r16" },
  {   1, "snpn-r16" },
  { 0, NULL }
};

static const per_choice_t NPN_Identity_r16_choice[] = {
  {   0, &hf_nr_rrc_pni_npn_r16  , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_pni_npn_r16 },
  {   1, &hf_nr_rrc_snpn_r16     , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_snpn_r16 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_NPN_Identity_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_NPN_Identity_r16, NPN_Identity_r16_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxNPN_r16_OF_NPN_Identity_r16_sequence_of[1] = {
  { &hf_nr_rrc_npn_IdentityList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_NPN_Identity_r16 },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxNPN_r16_OF_NPN_Identity_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxNPN_r16_OF_NPN_Identity_r16, SEQUENCE_SIZE_1_maxNPN_r16_OF_NPN_Identity_r16_sequence_of,
                                                  1, maxNPN_r16, FALSE);

  return offset;
}


static const value_string nr_rrc_T_cellReservedForOperatorUse_r16_vals[] = {
  {   0, "reserved" },
  {   1, "notReserved" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_cellReservedForOperatorUse_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_iab_Support_r16_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_iab_Support_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t NPN_IdentityInfo_r16_sequence[] = {
  { &hf_nr_rrc_npn_IdentityList_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SEQUENCE_SIZE_1_maxNPN_r16_OF_NPN_Identity_r16 },
  { &hf_nr_rrc_trackingAreaCode_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_TrackingAreaCode },
  { &hf_nr_rrc_ranac_r16    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_RAN_AreaCode },
  { &hf_nr_rrc_cellIdentity_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CellIdentity },
  { &hf_nr_rrc_cellReservedForOperatorUse_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_cellReservedForOperatorUse_r16 },
  { &hf_nr_rrc_iab_Support_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_iab_Support_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_NPN_IdentityInfo_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_NPN_IdentityInfo_r16, NPN_IdentityInfo_r16_sequence);

  return offset;
}


static const per_sequence_t NPN_IdentityInfoList_r16_sequence_of[1] = {
  { &hf_nr_rrc_NPN_IdentityInfoList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_NPN_IdentityInfo_r16 },
};

static int
dissect_nr_rrc_NPN_IdentityInfoList_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_NPN_IdentityInfoList_r16, NPN_IdentityInfoList_r16_sequence_of,
                                                  1, maxNPN_r16, FALSE);

  return offset;
}


static const per_sequence_t CGI_InfoNR_eag_1_sequence[] = {
  { &hf_nr_rrc_npn_IdentityInfoList_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_NPN_IdentityInfoList_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CGI_InfoNR_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, CGI_InfoNR_eag_1_sequence);

  return offset;
}


static const value_string nr_rrc_T_cellReservedForOtherUse_r16_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_cellReservedForOtherUse_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t CGI_InfoNR_eag_2_sequence[] = {
  { &hf_nr_rrc_cellReservedForOtherUse_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_cellReservedForOtherUse_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CGI_InfoNR_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, CGI_InfoNR_eag_2_sequence);

  return offset;
}


static const per_sequence_t CGI_InfoNR_sequence[] = {
  { &hf_nr_rrc_plmn_IdentityInfoList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_PLMN_IdentityInfoList },
  { &hf_nr_rrc_frequencyBandList_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MultiFrequencyBandListNR },
  { &hf_nr_rrc_noSIB1       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_noSIB1 },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_CGI_InfoNR_eag_1 },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_CGI_InfoNR_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CGI_InfoNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CGI_InfoNR, CGI_InfoNR_sequence);

  return offset;
}


static const per_sequence_t MeasResultNR_eag_1_sequence[] = {
  { &hf_nr_rrc_cgi_Info     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CGI_InfoNR },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasResultNR_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, MeasResultNR_eag_1_sequence);

  return offset;
}


static const per_sequence_t MeasResultNR_sequence[] = {
  { &hf_nr_rrc_physCellId   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_PhysCellId },
  { &hf_nr_rrc_measResult   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_measResult },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasResultNR_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasResultNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasResultNR, MeasResultNR_sequence);

  return offset;
}


static const per_sequence_t MeasResultListNR_sequence_of[1] = {
  { &hf_nr_rrc_MeasResultListNR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasResultNR },
};

static int
dissect_nr_rrc_MeasResultListNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MeasResultListNR, MeasResultListNR_sequence_of,
                                                  1, maxCellReport, FALSE);

  return offset;
}


static const per_sequence_t MeasResult2NR_sequence[] = {
  { &hf_nr_rrc_ssbFrequency , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ARFCN_ValueNR },
  { &hf_nr_rrc_refFreqCSI_RS, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ARFCN_ValueNR },
  { &hf_nr_rrc_measResultServingCell, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MeasResultNR },
  { &hf_nr_rrc_measResultNeighCellListNR_02, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MeasResultListNR },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasResult2NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasResult2NR, MeasResult2NR_sequence);

  return offset;
}


static const per_sequence_t MeasResultList2NR_sequence_of[1] = {
  { &hf_nr_rrc_MeasResultList2NR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasResult2NR },
};

static int
dissect_nr_rrc_MeasResultList2NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MeasResultList2NR, MeasResultList2NR_sequence_of,
                                                  1, maxFreq, FALSE);

  return offset;
}



static int
dissect_nr_rrc_ARFCN_ValueEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxEARFCN, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_RSRP_RangeEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 97U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_RSRQ_RangeEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 34U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_SINR_RangeEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}


static const per_sequence_t MeasQuantityResultsEUTRA_sequence[] = {
  { &hf_nr_rrc_measQuantityResultsEUTRA_rsrp, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RSRP_RangeEUTRA },
  { &hf_nr_rrc_measQuantityResultsEUTRA_rsrq, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RSRQ_RangeEUTRA },
  { &hf_nr_rrc_measQuantityResultsEUTRA_sinr, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SINR_RangeEUTRA },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasQuantityResultsEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasQuantityResultsEUTRA, MeasQuantityResultsEUTRA_sequence);

  return offset;
}


static const per_sequence_t PLMN_IdentityList_EUTRA_EPC_sequence_of[1] = {
  { &hf_nr_rrc_PLMN_IdentityList_EUTRA_EPC_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PLMN_Identity },
};

static int
dissect_nr_rrc_PLMN_IdentityList_EUTRA_EPC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_PLMN_IdentityList_EUTRA_EPC, PLMN_IdentityList_EUTRA_EPC_sequence_of,
                                                  1, maxPLMN, FALSE);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_28(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     28, 28, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t CellAccessRelatedInfo_EUTRA_EPC_sequence[] = {
  { &hf_nr_rrc_plmn_IdentityList_eutra_epc, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PLMN_IdentityList_EUTRA_EPC },
  { &hf_nr_rrc_trackingAreaCode_eutra_epc, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BIT_STRING_SIZE_16 },
  { &hf_nr_rrc_cellIdentity_eutra_epc, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BIT_STRING_SIZE_28 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CellAccessRelatedInfo_EUTRA_EPC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CellAccessRelatedInfo_EUTRA_EPC, CellAccessRelatedInfo_EUTRA_EPC_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_EPC_sequence_of[1] = {
  { &hf_nr_rrc_cgi_info_EPC_list_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CellAccessRelatedInfo_EUTRA_EPC },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_EPC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_EPC, SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_EPC_sequence_of,
                                                  1, maxPLMN, FALSE);

  return offset;
}


static const per_sequence_t T_cgi_info_EPC_sequence[] = {
  { &hf_nr_rrc_cgi_info_EPC_legacy, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CellAccessRelatedInfo_EUTRA_EPC },
  { &hf_nr_rrc_cgi_info_EPC_list, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_EPC },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_cgi_info_EPC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_cgi_info_EPC, T_cgi_info_EPC_sequence);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_1_maxPLMN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxPLMN, NULL, FALSE);

  return offset;
}


static const value_string nr_rrc_PLMN_Identity_EUTRA_5GC_vals[] = {
  {   0, "plmn-Identity-EUTRA-5GC" },
  {   1, "plmn-index" },
  { 0, NULL }
};

static const per_choice_t PLMN_Identity_EUTRA_5GC_choice[] = {
  {   0, &hf_nr_rrc_plmn_Identity_EUTRA_5GC, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_PLMN_Identity },
  {   1, &hf_nr_rrc_plmn_index   , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_1_maxPLMN },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_PLMN_Identity_EUTRA_5GC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_PLMN_Identity_EUTRA_5GC, PLMN_Identity_EUTRA_5GC_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t PLMN_IdentityList_EUTRA_5GC_sequence_of[1] = {
  { &hf_nr_rrc_PLMN_IdentityList_EUTRA_5GC_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PLMN_Identity_EUTRA_5GC },
};

static int
dissect_nr_rrc_PLMN_IdentityList_EUTRA_5GC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_PLMN_IdentityList_EUTRA_5GC, PLMN_IdentityList_EUTRA_5GC_sequence_of,
                                                  1, maxPLMN, FALSE);

  return offset;
}


static const value_string nr_rrc_CellIdentity_EUTRA_5GC_vals[] = {
  {   0, "cellIdentity-EUTRA" },
  {   1, "cellId-index" },
  { 0, NULL }
};

static const per_choice_t CellIdentity_EUTRA_5GC_choice[] = {
  {   0, &hf_nr_rrc_cellIdentity_EUTRA, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_BIT_STRING_SIZE_28 },
  {   1, &hf_nr_rrc_cellId_index , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_1_maxPLMN },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_CellIdentity_EUTRA_5GC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_CellIdentity_EUTRA_5GC, CellIdentity_EUTRA_5GC_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CellAccessRelatedInfo_EUTRA_5GC_sequence[] = {
  { &hf_nr_rrc_plmn_IdentityList_eutra_5gc, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PLMN_IdentityList_EUTRA_5GC },
  { &hf_nr_rrc_trackingAreaCode_eutra_5gc, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_TrackingAreaCode },
  { &hf_nr_rrc_ranac_5gc    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RAN_AreaCode },
  { &hf_nr_rrc_cellAccessRelatedInfo_EUTRA_5GC_cellIdentity_eutra_5gc, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CellIdentity_EUTRA_5GC },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CellAccessRelatedInfo_EUTRA_5GC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CellAccessRelatedInfo_EUTRA_5GC, CellAccessRelatedInfo_EUTRA_5GC_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_5GC_sequence_of[1] = {
  { &hf_nr_rrc_cgi_info_5GC_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CellAccessRelatedInfo_EUTRA_5GC },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_5GC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_5GC, SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_5GC_sequence_of,
                                                  1, maxPLMN, FALSE);

  return offset;
}



static int
dissect_nr_rrc_FreqBandIndicatorEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxBandsEUTRA, NULL, FALSE);

  return offset;
}


static const per_sequence_t MultiBandInfoListEUTRA_sequence_of[1] = {
  { &hf_nr_rrc_MultiBandInfoListEUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_FreqBandIndicatorEUTRA },
};

static int
dissect_nr_rrc_MultiBandInfoListEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MultiBandInfoListEUTRA, MultiBandInfoListEUTRA_sequence_of,
                                                  1, maxMultiBands, FALSE);

  return offset;
}


static const value_string nr_rrc_T_freqBandIndicatorPriority_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_freqBandIndicatorPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t CGI_InfoEUTRA_sequence[] = {
  { &hf_nr_rrc_cgi_info_EPC , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_cgi_info_EPC },
  { &hf_nr_rrc_cgi_info_5GC , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_5GC },
  { &hf_nr_rrc_freqBandIndicator, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_FreqBandIndicatorEUTRA },
  { &hf_nr_rrc_multiBandInfoList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MultiBandInfoListEUTRA },
  { &hf_nr_rrc_freqBandIndicatorPriority, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_freqBandIndicatorPriority },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CGI_InfoEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CGI_InfoEUTRA, CGI_InfoEUTRA_sequence);

  return offset;
}


static const per_sequence_t MeasResultEUTRA_sequence[] = {
  { &hf_nr_rrc_eutra_PhysCellId_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PhysCellId },
  { &hf_nr_rrc_measResult_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasQuantityResultsEUTRA },
  { &hf_nr_rrc_cgi_Info_02  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_CGI_InfoEUTRA },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasResultEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasResultEUTRA, MeasResultEUTRA_sequence);

  return offset;
}


static const per_sequence_t MeasResult2EUTRA_sequence[] = {
  { &hf_nr_rrc_carrierFreq_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueEUTRA },
  { &hf_nr_rrc_measResultServingCell_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MeasResultEUTRA },
  { &hf_nr_rrc_measResultBestNeighCell_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MeasResultEUTRA },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasResult2EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasResult2EUTRA, MeasResult2EUTRA_sequence);

  return offset;
}


static const per_sequence_t MeasResultServFreqListEUTRA_SCG_sequence_of[1] = {
  { &hf_nr_rrc_MeasResultServFreqListEUTRA_SCG_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasResult2EUTRA },
};

static int
dissect_nr_rrc_MeasResultServFreqListEUTRA_SCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MeasResultServFreqListEUTRA_SCG, MeasResultServFreqListEUTRA_SCG_sequence_of,
                                                  1, maxNrofServingCellsEUTRA, FALSE);

  return offset;
}


static const per_sequence_t RRM_Config_eag_1_sequence[] = {
  { &hf_nr_rrc_rRM_Config_eag_1_candidateCellInfoListSN_EUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasResultServFreqListEUTRA_SCG },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRM_Config_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, RRM_Config_eag_1_sequence);

  return offset;
}


static const per_sequence_t RRM_Config_sequence[] = {
  { &hf_nr_rrc_ue_InactiveTime, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_ue_InactiveTime },
  { &hf_nr_rrc_candidateCellInfoList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MeasResultList2NR },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_RRM_Config_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRM_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRM_Config, RRM_Config_sequence);

  return offset;
}



static int
dissect_nr_rrc_ShortMAC_I(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_256(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     256, 256, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t ReestabNCellInfo_sequence[] = {
  { &hf_nr_rrc_cellIdentity , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CellIdentity },
  { &hf_nr_rrc_key_gNodeB_Star, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BIT_STRING_SIZE_256 },
  { &hf_nr_rrc_shortMAC_I   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ShortMAC_I },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ReestabNCellInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ReestabNCellInfo, ReestabNCellInfo_sequence);

  return offset;
}


static const per_sequence_t ReestabNCellInfoList_sequence_of[1] = {
  { &hf_nr_rrc_ReestabNCellInfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReestabNCellInfo },
};

static int
dissect_nr_rrc_ReestabNCellInfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_ReestabNCellInfoList, ReestabNCellInfoList_sequence_of,
                                                  1, maxCellPrep, FALSE);

  return offset;
}


static const per_sequence_t ReestablishmentInfo_sequence[] = {
  { &hf_nr_rrc_sourcePhysCellId, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PhysCellId },
  { &hf_nr_rrc_targetCellShortMAC_I, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ShortMAC_I },
  { &hf_nr_rrc_additionalReestabInfoList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ReestabNCellInfoList },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ReestablishmentInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ReestablishmentInfo, ReestablishmentInfo_sequence);

  return offset;
}



static int
dissect_nr_rrc_BandCombinationIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxBandComb, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_FeatureSetEntryIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxFeatureSetsPerBand, NULL, FALSE);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxFeatureSetsPerBand_OF_FeatureSetEntryIndex_sequence_of[1] = {
  { &hf_nr_rrc_allowedFeatureSetsList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_FeatureSetEntryIndex },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxFeatureSetsPerBand_OF_FeatureSetEntryIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxFeatureSetsPerBand_OF_FeatureSetEntryIndex, SEQUENCE_SIZE_1_maxFeatureSetsPerBand_OF_FeatureSetEntryIndex_sequence_of,
                                                  1, maxFeatureSetsPerBand, FALSE);

  return offset;
}


static const per_sequence_t BandCombinationInfo_sequence[] = {
  { &hf_nr_rrc_bandCombinationIndex, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BandCombinationIndex },
  { &hf_nr_rrc_allowedFeatureSetsList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SEQUENCE_SIZE_1_maxFeatureSetsPerBand_OF_FeatureSetEntryIndex },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_BandCombinationInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_BandCombinationInfo, BandCombinationInfo_sequence);

  return offset;
}


static const per_sequence_t BandCombinationInfoList_sequence_of[1] = {
  { &hf_nr_rrc_BandCombinationInfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BandCombinationInfo },
};

static int
dissect_nr_rrc_BandCombinationInfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_BandCombinationInfoList, BandCombinationInfoList_sequence_of,
                                                  1, maxBandComb, FALSE);

  return offset;
}



static int
dissect_nr_rrc_P_Max(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -30, 33U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_powerCoordination_FR1_sequence[] = {
  { &hf_nr_rrc_p_maxNR_FR1  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_P_Max },
  { &hf_nr_rrc_p_maxEUTRA   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_P_Max },
  { &hf_nr_rrc_p_maxUE_FR1  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_P_Max },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_powerCoordination_FR1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_powerCoordination_FR1, T_powerCoordination_FR1_sequence);

  return offset;
}



static int
dissect_nr_rrc_ServCellIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrofServingCells_1, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_servCellIndexRangeSCG_sequence[] = {
  { &hf_nr_rrc_lowBound     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ServCellIndex },
  { &hf_nr_rrc_upBound      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ServCellIndex },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_servCellIndexRangeSCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_servCellIndexRangeSCG, T_servCellIndexRangeSCG_sequence);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_1_maxMeasFreqsMN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxMeasFreqsMN, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_1_maxMeasIdentitiesMN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxMeasIdentitiesMN, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_BandEntryIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrofServingCells, NULL, FALSE);

  return offset;
}


static const per_sequence_t SelectedBandEntriesMN_sequence_of[1] = {
  { &hf_nr_rrc_SelectedBandEntriesMN_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BandEntryIndex },
};

static int
dissect_nr_rrc_SelectedBandEntriesMN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SelectedBandEntriesMN, SelectedBandEntriesMN_sequence_of,
                                                  1, maxSimultaneousBands, FALSE);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxBandComb_OF_SelectedBandEntriesMN_sequence_of[1] = {
  { &hf_nr_rrc_selectedBandEntriesMNList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SelectedBandEntriesMN },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxBandComb_OF_SelectedBandEntriesMN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxBandComb_OF_SelectedBandEntriesMN, SEQUENCE_SIZE_1_maxBandComb_OF_SelectedBandEntriesMN_sequence_of,
                                                  1, maxBandComb, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_1_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 15U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_16384(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16384U, NULL, FALSE);

  return offset;
}


static const per_sequence_t ConfigRestrictInfoSCG_eag_1_sequence[] = {
  { &hf_nr_rrc_selectedBandEntriesMNList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxBandComb_OF_SelectedBandEntriesMN },
  { &hf_nr_rrc_pdcch_BlindDetectionSCG, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_15 },
  { &hf_nr_rrc_maxNumberROHC_ContextSessionsSN, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_0_16384 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ConfigRestrictInfoSCG_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, ConfigRestrictInfoSCG_eag_1_sequence);

  return offset;
}


static const per_sequence_t ConfigRestrictInfoSCG_eag_2_sequence[] = {
  { &hf_nr_rrc_maxIntraFreqMeasIdentitiesSCG, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_maxMeasIdentitiesMN },
  { &hf_nr_rrc_maxInterFreqMeasIdentitiesSCG, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_maxMeasIdentitiesMN },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ConfigRestrictInfoSCG_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, ConfigRestrictInfoSCG_eag_2_sequence);

  return offset;
}


static const per_sequence_t T_powerCoordination_FR2_r16_sequence[] = {
  { &hf_nr_rrc_p_maxNR_FR2_MCG_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_P_Max },
  { &hf_nr_rrc_p_maxNR_FR2_SCG_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_P_Max },
  { &hf_nr_rrc_p_maxUE_FR2_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_P_Max },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_powerCoordination_FR2_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_powerCoordination_FR2_r16, T_powerCoordination_FR2_r16_sequence);

  return offset;
}


static const value_string nr_rrc_T_nrdc_PC_mode_FR1_r16_vals[] = {
  {   0, "semi-static-mode1" },
  {   1, "semi-static-mode2" },
  {   2, "dynamic" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_nrdc_PC_mode_FR1_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_nrdc_PC_mode_FR2_r16_vals[] = {
  {   0, "semi-static-mode1" },
  {   1, "semi-static-mode2" },
  {   2, "dynamic" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_nrdc_PC_mode_FR2_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_maxNrofCLI_SRS_Resources_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrofCLI_SRS_Resources_r16, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_maxNrofCLI_RSSI_Resources_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrofCLI_RSSI_Resources_r16, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_65536(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65536U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_31(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, FALSE);

  return offset;
}


static const per_sequence_t ReducedMaxCCs_r16_sequence[] = {
  { &hf_nr_rrc_reducedCCsDL_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_31 },
  { &hf_nr_rrc_reducedCCsUL_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_31 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ReducedMaxCCs_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ReducedMaxCCs_r16, ReducedMaxCCs_r16_sequence);

  return offset;
}


static const value_string nr_rrc_ReducedAggregatedBandwidth_vals[] = {
  {   0, "mhz0" },
  {   1, "mhz10" },
  {   2, "mhz20" },
  {   3, "mhz30" },
  {   4, "mhz40" },
  {   5, "mhz50" },
  {   6, "mhz60" },
  {   7, "mhz80" },
  {   8, "mhz100" },
  {   9, "mhz200" },
  {  10, "mhz300" },
  {  11, "mhz400" },
  { 0, NULL }
};


static int
dissect_nr_rrc_ReducedAggregatedBandwidth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     12, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t ReducedMaxBW_FRx_r16_sequence[] = {
  { &hf_nr_rrc_reducedBW_DL_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReducedAggregatedBandwidth },
  { &hf_nr_rrc_reducedBW_UL_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReducedAggregatedBandwidth },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ReducedMaxBW_FRx_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ReducedMaxBW_FRx_r16, ReducedMaxBW_FRx_r16_sequence);

  return offset;
}


static const value_string nr_rrc_MIMO_LayersDL_vals[] = {
  {   0, "twoLayers" },
  {   1, "fourLayers" },
  {   2, "eightLayers" },
  { 0, NULL }
};


static int
dissect_nr_rrc_MIMO_LayersDL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_MIMO_LayersUL_vals[] = {
  {   0, "oneLayer" },
  {   1, "twoLayers" },
  {   2, "fourLayers" },
  { 0, NULL }
};


static int
dissect_nr_rrc_MIMO_LayersUL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_reducedMaxMIMO_LayersFR1_sequence[] = {
  { &hf_nr_rrc_reducedMIMO_LayersFR1_DL, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MIMO_LayersDL },
  { &hf_nr_rrc_reducedMIMO_LayersFR1_UL, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MIMO_LayersUL },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_reducedMaxMIMO_LayersFR1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_reducedMaxMIMO_LayersFR1, T_reducedMaxMIMO_LayersFR1_sequence);

  return offset;
}


static const per_sequence_t T_reducedMaxMIMO_LayersFR2_sequence[] = {
  { &hf_nr_rrc_reducedMIMO_LayersFR2_DL, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MIMO_LayersDL },
  { &hf_nr_rrc_reducedMIMO_LayersFR2_UL, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MIMO_LayersUL },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_reducedMaxMIMO_LayersFR2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_reducedMaxMIMO_LayersFR2, T_reducedMaxMIMO_LayersFR2_sequence);

  return offset;
}


static const per_sequence_t OverheatingAssistance_sequence[] = {
  { &hf_nr_rrc_reducedMaxCCs, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ReducedMaxCCs_r16 },
  { &hf_nr_rrc_reducedMaxBW_FR1, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ReducedMaxBW_FRx_r16 },
  { &hf_nr_rrc_reducedMaxBW_FR2, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ReducedMaxBW_FRx_r16 },
  { &hf_nr_rrc_reducedMaxMIMO_LayersFR1, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_reducedMaxMIMO_LayersFR1 },
  { &hf_nr_rrc_reducedMaxMIMO_LayersFR2, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_reducedMaxMIMO_LayersFR2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_OverheatingAssistance(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_OverheatingAssistance, OverheatingAssistance_sequence);

  return offset;
}


static const value_string nr_rrc_T_Offset_r16_vals[] = {
  {   0, "ms0dot5" },
  {   1, "ms0dot75" },
  {   2, "ms1" },
  {   3, "ms1dot5" },
  {   4, "ms2" },
  {   5, "ms2dot5" },
  {   6, "ms3" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_Offset_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t ConfigRestrictInfoSCG_eag_3_sequence[] = {
  { &hf_nr_rrc_p_maxNR_FR1_MCG_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_P_Max },
  { &hf_nr_rrc_powerCoordination_FR2_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_powerCoordination_FR2_r16 },
  { &hf_nr_rrc_nrdc_PC_mode_FR1_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nrdc_PC_mode_FR1_r16 },
  { &hf_nr_rrc_nrdc_PC_mode_FR2_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nrdc_PC_mode_FR2_r16 },
  { &hf_nr_rrc_maxMeasSRS_ResourceSCG_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_0_maxNrofCLI_SRS_Resources_r16 },
  { &hf_nr_rrc_maxMeasCLI_ResourceSCG_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_0_maxNrofCLI_RSSI_Resources_r16 },
  { &hf_nr_rrc_maxNumberEHC_ContextsSN_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_0_65536 },
  { &hf_nr_rrc_allowedReducedConfigForOverheating_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OverheatingAssistance },
  { &hf_nr_rrc_maxToffset_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_Offset_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ConfigRestrictInfoSCG_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, ConfigRestrictInfoSCG_eag_3_sequence);

  return offset;
}


static const per_sequence_t ConfigRestrictInfoSCG_sequence[] = {
  { &hf_nr_rrc_allowedBC_ListMRDC, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_BandCombinationInfoList },
  { &hf_nr_rrc_powerCoordination_FR1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_powerCoordination_FR1 },
  { &hf_nr_rrc_servCellIndexRangeSCG, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_servCellIndexRangeSCG },
  { &hf_nr_rrc_maxMeasFreqsSCG, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_maxMeasFreqsMN },
  { &hf_nr_rrc_configRestrictInfoSCG_dummy, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_maxMeasIdentitiesMN },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_ConfigRestrictInfoSCG_eag_1 },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_ConfigRestrictInfoSCG_eag_2 },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_ConfigRestrictInfoSCG_eag_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ConfigRestrictInfoSCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ConfigRestrictInfoSCG, ConfigRestrictInfoSCG_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_32_OF_CellIdentity_sequence_of[1] = {
  { &hf_nr_rrc_ran_AreaCells_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CellIdentity },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_32_OF_CellIdentity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_32_OF_CellIdentity, SEQUENCE_SIZE_1_32_OF_CellIdentity_sequence_of,
                                                  1, 32, FALSE);

  return offset;
}


static const per_sequence_t PLMN_RAN_AreaCell_sequence[] = {
  { &hf_nr_rrc_plmn_Identity, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_PLMN_Identity },
  { &hf_nr_rrc_ran_AreaCells, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SEQUENCE_SIZE_1_32_OF_CellIdentity },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PLMN_RAN_AreaCell(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PLMN_RAN_AreaCell, PLMN_RAN_AreaCell_sequence);

  return offset;
}


static const per_sequence_t PLMN_RAN_AreaCellList_sequence_of[1] = {
  { &hf_nr_rrc_PLMN_RAN_AreaCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PLMN_RAN_AreaCell },
};

static int
dissect_nr_rrc_PLMN_RAN_AreaCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_PLMN_RAN_AreaCellList, PLMN_RAN_AreaCellList_sequence_of,
                                                  1, maxPLMNIdentities, FALSE);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_32_OF_RAN_AreaCode_sequence_of[1] = {
  { &hf_nr_rrc_ran_AreaCodeList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RAN_AreaCode },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_32_OF_RAN_AreaCode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_32_OF_RAN_AreaCode, SEQUENCE_SIZE_1_32_OF_RAN_AreaCode_sequence_of,
                                                  1, 32, FALSE);

  return offset;
}


static const per_sequence_t RAN_AreaConfig_sequence[] = {
  { &hf_nr_rrc_trackingAreaCode, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_TrackingAreaCode },
  { &hf_nr_rrc_ran_AreaCodeList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_32_OF_RAN_AreaCode },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RAN_AreaConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RAN_AreaConfig, RAN_AreaConfig_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_16_OF_RAN_AreaConfig_sequence_of[1] = {
  { &hf_nr_rrc_ran_Area_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RAN_AreaConfig },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_16_OF_RAN_AreaConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_16_OF_RAN_AreaConfig, SEQUENCE_SIZE_1_16_OF_RAN_AreaConfig_sequence_of,
                                                  1, 16, FALSE);

  return offset;
}


static const per_sequence_t PLMN_RAN_AreaConfig_sequence[] = {
  { &hf_nr_rrc_plmn_Identity, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_PLMN_Identity },
  { &hf_nr_rrc_ran_Area     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SEQUENCE_SIZE_1_16_OF_RAN_AreaConfig },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PLMN_RAN_AreaConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PLMN_RAN_AreaConfig, PLMN_RAN_AreaConfig_sequence);

  return offset;
}


static const per_sequence_t PLMN_RAN_AreaConfigList_sequence_of[1] = {
  { &hf_nr_rrc_PLMN_RAN_AreaConfigList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PLMN_RAN_AreaConfig },
};

static int
dissect_nr_rrc_PLMN_RAN_AreaConfigList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_PLMN_RAN_AreaConfigList, PLMN_RAN_AreaConfigList_sequence_of,
                                                  1, maxPLMNIdentities, FALSE);

  return offset;
}


static const value_string nr_rrc_RAN_NotificationAreaInfo_vals[] = {
  {   0, "cellList" },
  {   1, "ran-AreaConfigList" },
  { 0, NULL }
};

static const per_choice_t RAN_NotificationAreaInfo_choice[] = {
  {   0, &hf_nr_rrc_cellList     , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_PLMN_RAN_AreaCellList },
  {   1, &hf_nr_rrc_ran_AreaConfigList, ASN1_EXTENSION_ROOT    , dissect_nr_rrc_PLMN_RAN_AreaConfigList },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_RAN_NotificationAreaInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_RAN_NotificationAreaInfo, RAN_NotificationAreaInfo_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t AS_Context_eag_1_sequence[] = {
  { &hf_nr_rrc_ran_NotificationAreaInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RAN_NotificationAreaInfo },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_AS_Context_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, AS_Context_eag_1_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_ueAssistanceInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_UEAssistanceInformation_PDU);

  return offset;
}


static const per_sequence_t AS_Context_eag_2_sequence[] = {
  { &hf_nr_rrc_ueAssistanceInformation, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_ueAssistanceInformation },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_AS_Context_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, AS_Context_eag_2_sequence);

  return offset;
}


static const per_sequence_t BandCombinationInfoSN_sequence[] = {
  { &hf_nr_rrc_bandCombinationIndex, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BandCombinationIndex },
  { &hf_nr_rrc_requestedFeatureSets, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_FeatureSetEntryIndex },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_BandCombinationInfoSN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_BandCombinationInfoSN, BandCombinationInfoSN_sequence);

  return offset;
}


static const per_sequence_t AS_Context_eag_3_sequence[] = {
  { &hf_nr_rrc_selectedBandCombinationSN, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_BandCombinationInfoSN },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_AS_Context_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, AS_Context_eag_3_sequence);

  return offset;
}


static const value_string nr_rrc_T_uplinkPowerSharingDAPS_Mode_r16_vals[] = {
  {   0, "semi-static-mode1" },
  {   1, "semi-static-mode2" },
  {   2, "dynamic" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_uplinkPowerSharingDAPS_Mode_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_powerCoordination_r16_sequence[] = {
  { &hf_nr_rrc_p_DAPS_Source_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_P_Max },
  { &hf_nr_rrc_p_DAPS_Target_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_P_Max },
  { &hf_nr_rrc_uplinkPowerSharingDAPS_Mode_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_uplinkPowerSharingDAPS_Mode_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_powerCoordination_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_powerCoordination_r16, T_powerCoordination_r16_sequence);

  return offset;
}


static const per_sequence_t ConfigRestrictInfoDAPS_r16_sequence[] = {
  { &hf_nr_rrc_powerCoordination_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_powerCoordination_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ConfigRestrictInfoDAPS_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ConfigRestrictInfoDAPS_r16, ConfigRestrictInfoDAPS_r16_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_sidelinkUEInformationNR_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *sidelink_ue_info_nr_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &sidelink_ue_info_nr_tvb);

  if (sidelink_ue_info_nr_tvb) {
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_sidelinkUEInformationNR);
    dissect_nr_rrc_SidelinkUEInformationNR_r16_PDU(sidelink_ue_info_nr_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_nr_rrc_T_sidelinkUEInformationEUTRA_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *sidelink_ue_info_eutra_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &sidelink_ue_info_eutra_tvb);

  if (sidelink_ue_info_eutra_tvb) {
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_sidelinkUEInformationEUTRA);
    dissect_lte_rrc_SidelinkUEInformation_r12_PDU(sidelink_ue_info_eutra_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_nr_rrc_T_ueAssistanceInformationEUTRA_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *ue_assist_info_eutra_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &ue_assist_info_eutra_tvb);

  if (ue_assist_info_eutra_tvb) {
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_ueAssistanceInformationEUTRA);
    dissect_lte_rrc_UEAssistanceInformation_r11_PDU(ue_assist_info_eutra_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_nr_rrc_T_ueAssistanceInformationSCG_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_UEAssistanceInformation_PDU);

  return offset;
}


static const value_string nr_rrc_T_gapIndicationIntra_r16_vals[] = {
  {   0, "gap" },
  {   1, "no-gap" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_gapIndicationIntra_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t NeedForGapsIntraFreq_r16_sequence[] = {
  { &hf_nr_rrc_servCellId_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ServCellIndex },
  { &hf_nr_rrc_gapIndicationIntra_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_gapIndicationIntra_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_NeedForGapsIntraFreq_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_NeedForGapsIntraFreq_r16, NeedForGapsIntraFreq_r16_sequence);

  return offset;
}


static const per_sequence_t NeedForGapsIntraFreqList_r16_sequence_of[1] = {
  { &hf_nr_rrc_NeedForGapsIntraFreqList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_NeedForGapsIntraFreq_r16 },
};

static int
dissect_nr_rrc_NeedForGapsIntraFreqList_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_NeedForGapsIntraFreqList_r16, NeedForGapsIntraFreqList_r16_sequence_of,
                                                  1, maxNrofServingCells, FALSE);

  return offset;
}


static const value_string nr_rrc_T_gapIndication_r16_vals[] = {
  {   0, "gap" },
  {   1, "no-gap" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_gapIndication_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t NeedForGapsNR_r16_sequence[] = {
  { &hf_nr_rrc_bandNR_r16   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_FreqBandIndicatorNR },
  { &hf_nr_rrc_gapIndication_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_gapIndication_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_NeedForGapsNR_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_NeedForGapsNR_r16, NeedForGapsNR_r16_sequence);

  return offset;
}


static const per_sequence_t NeedForGapsBandListNR_r16_sequence_of[1] = {
  { &hf_nr_rrc_NeedForGapsBandListNR_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_NeedForGapsNR_r16 },
};

static int
dissect_nr_rrc_NeedForGapsBandListNR_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_NeedForGapsBandListNR_r16, NeedForGapsBandListNR_r16_sequence_of,
                                                  1, maxBands, FALSE);

  return offset;
}


static const per_sequence_t NeedForGapsInfoNR_r16_sequence[] = {
  { &hf_nr_rrc_intraFreq_needForGap_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_NeedForGapsIntraFreqList_r16 },
  { &hf_nr_rrc_interFreq_needForGap_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_NeedForGapsBandListNR_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_NeedForGapsInfoNR_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_NeedForGapsInfoNR_r16, NeedForGapsInfoNR_r16_sequence);

  return offset;
}


static const per_sequence_t AS_Context_eag_4_sequence[] = {
  { &hf_nr_rrc_configRestrictInfoDAPS_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ConfigRestrictInfoDAPS_r16 },
  { &hf_nr_rrc_sidelinkUEInformationNR_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_sidelinkUEInformationNR_r16 },
  { &hf_nr_rrc_sidelinkUEInformationEUTRA_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_sidelinkUEInformationEUTRA_r16 },
  { &hf_nr_rrc_ueAssistanceInformationEUTRA_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_ueAssistanceInformationEUTRA_r16 },
  { &hf_nr_rrc_ueAssistanceInformationSCG_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_ueAssistanceInformationSCG_r16 },
  { &hf_nr_rrc_needForGapsInfoNR_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_NeedForGapsInfoNR_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_AS_Context_eag_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, AS_Context_eag_4_sequence);

  return offset;
}



static int
dissect_nr_rrc_FeatureSetDownlinkPerCC_Id(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxPerCC_FeatureSets, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_FeatureSetUplinkPerCC_Id(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxPerCC_FeatureSets, NULL, FALSE);

  return offset;
}


static const per_sequence_t ConfigRestrictInfoDAPS_v1640_sequence[] = {
  { &hf_nr_rrc_sourceFeatureSetPerDownlinkCC_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_FeatureSetDownlinkPerCC_Id },
  { &hf_nr_rrc_sourceFeatureSetPerUplinkCC_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_FeatureSetUplinkPerCC_Id },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ConfigRestrictInfoDAPS_v1640(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ConfigRestrictInfoDAPS_v1640, ConfigRestrictInfoDAPS_v1640_sequence);

  return offset;
}


static const per_sequence_t AS_Context_eag_5_sequence[] = {
  { &hf_nr_rrc_configRestrictInfoDAPS_v1640, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ConfigRestrictInfoDAPS_v1640 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_AS_Context_eag_5(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, AS_Context_eag_5_sequence);

  return offset;
}


static const per_sequence_t AS_Context_sequence[] = {
  { &hf_nr_rrc_reestablishmentInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ReestablishmentInfo },
  { &hf_nr_rrc_configRestrictInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ConfigRestrictInfoSCG },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_AS_Context_eag_1 },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_AS_Context_eag_2 },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_AS_Context_eag_3 },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_AS_Context_eag_4 },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_AS_Context_eag_5 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_AS_Context(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_AS_Context, AS_Context_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_01_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_01, T_nonCriticalExtension_01_sequence);

  return offset;
}


static const per_sequence_t HandoverPreparationInformation_IEs_sequence[] = {
  { &hf_nr_rrc_ue_CapabilityRAT_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_UE_CapabilityRAT_ContainerList },
  { &hf_nr_rrc_sourceConfig , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_AS_Config },
  { &hf_nr_rrc_rrm_Config   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RRM_Config },
  { &hf_nr_rrc_as_Context   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_AS_Context },
  { &hf_nr_rrc_nonCriticalExtension_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_HandoverPreparationInformation_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_HandoverPreparationInformation_IEs, HandoverPreparationInformation_IEs_sequence);

  return offset;
}


static const value_string nr_rrc_T_c1_01_vals[] = {
  {   0, "handoverPreparationInformation" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_01_choice[] = {
  {   0, &hf_nr_rrc_handoverPreparationInformation, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_HandoverPreparationInformation_IEs },
  {   1, &hf_nr_rrc_spare3       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   2, &hf_nr_rrc_spare2       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   3, &hf_nr_rrc_spare1       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_c1_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_c1_01, T_c1_01_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_01_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_01, T_criticalExtensionsFuture_01_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_01_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_01_choice[] = {
  {   0, &hf_nr_rrc_c1_01        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_c1_01 },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_01 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_01, T_criticalExtensions_01_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t HandoverPreparationInformation_sequence[] = {
  { &hf_nr_rrc_criticalExtensions_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_HandoverPreparationInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_HandoverPreparationInformation, HandoverPreparationInformation_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_scg_CellGroupConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_RRCReconfiguration_PDU);

  return offset;
}



static int
dissect_nr_rrc_T_scg_RB_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_RadioBearerConfig_PDU);

  return offset;
}


static const per_sequence_t ConfigRestrictModReqSCG_eag_1_sequence[] = {
  { &hf_nr_rrc_requestedPDCCH_BlindDetectionSCG, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_15 },
  { &hf_nr_rrc_requestedP_MaxEUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_P_Max },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ConfigRestrictModReqSCG_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, ConfigRestrictModReqSCG_eag_1_sequence);

  return offset;
}


static const per_sequence_t ConfigRestrictModReqSCG_eag_2_sequence[] = {
  { &hf_nr_rrc_requestedP_MaxFR2_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_P_Max },
  { &hf_nr_rrc_requestedMaxInterFreqMeasIdSCG_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_maxMeasIdentitiesMN },
  { &hf_nr_rrc_requestedMaxIntraFreqMeasIdSCG_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_maxMeasIdentitiesMN },
  { &hf_nr_rrc_requestedToffset_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_Offset_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ConfigRestrictModReqSCG_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, ConfigRestrictModReqSCG_eag_2_sequence);

  return offset;
}


static const per_sequence_t ConfigRestrictModReqSCG_sequence[] = {
  { &hf_nr_rrc_requestedBC_MRDC, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_BandCombinationInfoSN },
  { &hf_nr_rrc_requestedP_MaxFR1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_P_Max },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_ConfigRestrictModReqSCG_eag_1 },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_ConfigRestrictModReqSCG_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ConfigRestrictModReqSCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ConfigRestrictModReqSCG, ConfigRestrictModReqSCG_sequence);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_19(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 19U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_39(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 39U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_59(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 59U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_63(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_69(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 69U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_79(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 79U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_127(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_159(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 159U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_255(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_319(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 319U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_511(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 511U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_639(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 639U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_1023(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_1279(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1279U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_2047(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2047U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_2559(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2559U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_5119(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 5119U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_10239(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 10239U, NULL, FALSE);

  return offset;
}


static const value_string nr_rrc_T_drx_LongCycleStartOffset_vals[] = {
  {   0, "ms10" },
  {   1, "ms20" },
  {   2, "ms32" },
  {   3, "ms40" },
  {   4, "ms60" },
  {   5, "ms64" },
  {   6, "ms70" },
  {   7, "ms80" },
  {   8, "ms128" },
  {   9, "ms160" },
  {  10, "ms256" },
  {  11, "ms320" },
  {  12, "ms512" },
  {  13, "ms640" },
  {  14, "ms1024" },
  {  15, "ms1280" },
  {  16, "ms2048" },
  {  17, "ms2560" },
  {  18, "ms5120" },
  {  19, "ms10240" },
  { 0, NULL }
};

static value_string_ext nr_rrc_T_drx_LongCycleStartOffset_vals_ext = VALUE_STRING_EXT_INIT(nr_rrc_T_drx_LongCycleStartOffset_vals);

static const per_choice_t T_drx_LongCycleStartOffset_choice[] = {
  {   0, &hf_nr_rrc_ms10         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_9 },
  {   1, &hf_nr_rrc_ms20         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_19 },
  {   2, &hf_nr_rrc_ms32         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_31 },
  {   3, &hf_nr_rrc_ms40         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_39 },
  {   4, &hf_nr_rrc_ms60         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_59 },
  {   5, &hf_nr_rrc_ms64         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_63 },
  {   6, &hf_nr_rrc_ms70         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_69 },
  {   7, &hf_nr_rrc_ms80         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_79 },
  {   8, &hf_nr_rrc_ms128        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_127 },
  {   9, &hf_nr_rrc_ms160        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_159 },
  {  10, &hf_nr_rrc_ms256        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_255 },
  {  11, &hf_nr_rrc_ms320        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_319 },
  {  12, &hf_nr_rrc_ms512        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_511 },
  {  13, &hf_nr_rrc_ms640        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_639 },
  {  14, &hf_nr_rrc_ms1024       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_1023 },
  {  15, &hf_nr_rrc_ms1280       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_1279 },
  {  16, &hf_nr_rrc_ms2048       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_2047 },
  {  17, &hf_nr_rrc_ms2560       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_2559 },
  {  18, &hf_nr_rrc_ms5120       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_5119 },
  {  19, &hf_nr_rrc_ms10240      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_10239 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_drx_LongCycleStartOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_drx_LongCycleStartOffset, T_drx_LongCycleStartOffset_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_T_drx_ShortCycle_vals[] = {
  {   0, "ms2" },
  {   1, "ms3" },
  {   2, "ms4" },
  {   3, "ms5" },
  {   4, "ms6" },
  {   5, "ms7" },
  {   6, "ms8" },
  {   7, "ms10" },
  {   8, "ms14" },
  {   9, "ms16" },
  {  10, "ms20" },
  {  11, "ms30" },
  {  12, "ms32" },
  {  13, "ms35" },
  {  14, "ms40" },
  {  15, "ms64" },
  {  16, "ms80" },
  {  17, "ms128" },
  {  18, "ms160" },
  {  19, "ms256" },
  {  20, "ms320" },
  {  21, "ms512" },
  {  22, "ms640" },
  {  23, "spare9" },
  {  24, "spare8" },
  {  25, "spare7" },
  {  26, "spare6" },
  {  27, "spare5" },
  {  28, "spare4" },
  {  29, "spare3" },
  {  30, "spare2" },
  {  31, "spare1" },
  { 0, NULL }
};

static value_string_ext nr_rrc_T_drx_ShortCycle_vals_ext = VALUE_STRING_EXT_INIT(nr_rrc_T_drx_ShortCycle_vals);


static int
dissect_nr_rrc_T_drx_ShortCycle(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     32, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_1_16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_shortDRX_sequence[] = {
  { &hf_nr_rrc_drx_ShortCycle, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_drx_ShortCycle },
  { &hf_nr_rrc_drx_ShortCycleTimer, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_1_16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_shortDRX(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_shortDRX, T_shortDRX_sequence);

  return offset;
}


static const per_sequence_t DRX_Info_sequence[] = {
  { &hf_nr_rrc_drx_LongCycleStartOffset, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_drx_LongCycleStartOffset },
  { &hf_nr_rrc_shortDRX     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_shortDRX },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_DRX_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_DRX_Info, DRX_Info_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_candidateCellInfoListSN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_MeasResultList2NR_PDU);

  return offset;
}


static const per_sequence_t NR_FreqInfo_sequence[] = {
  { &hf_nr_rrc_measuredFrequency, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ARFCN_ValueNR },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_NR_FreqInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_NR_FreqInfo, NR_FreqInfo_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxMeasFreqsSN_OF_NR_FreqInfo_sequence_of[1] = {
  { &hf_nr_rrc_measuredFrequenciesSN_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_NR_FreqInfo },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxMeasFreqsSN_OF_NR_FreqInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxMeasFreqsSN_OF_NR_FreqInfo, SEQUENCE_SIZE_1_maxMeasFreqsSN_OF_NR_FreqInfo_sequence_of,
                                                  1, maxMeasFreqsSN, FALSE);

  return offset;
}


static const per_sequence_t MeasConfigSN_sequence[] = {
  { &hf_nr_rrc_measuredFrequenciesSN, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxMeasFreqsSN_OF_NR_FreqInfo },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasConfigSN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasConfigSN, MeasConfigSN_sequence);

  return offset;
}


static const value_string nr_rrc_T_fr_Type_vals[] = {
  {   0, "fr1" },
  {   1, "fr2" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_fr_Type(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t FR_Info_sequence[] = {
  { &hf_nr_rrc_servCellIndex, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ServCellIndex },
  { &hf_nr_rrc_fr_Type      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_fr_Type },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_FR_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_FR_Info, FR_Info_sequence);

  return offset;
}


static const per_sequence_t FR_InfoList_sequence_of[1] = {
  { &hf_nr_rrc_FR_InfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_FR_Info },
};

static int
dissect_nr_rrc_FR_InfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_FR_InfoList, FR_InfoList_sequence_of,
                                                  1, maxNrofServingCells_1, FALSE);

  return offset;
}


static const per_sequence_t CandidateServingFreqListNR_sequence_of[1] = {
  { &hf_nr_rrc_CandidateServingFreqListNR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueNR },
};

static int
dissect_nr_rrc_CandidateServingFreqListNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_CandidateServingFreqListNR, CandidateServingFreqListNR_sequence_of,
                                                  1, maxFreqIDC_MRDC, FALSE);

  return offset;
}


static const per_sequence_t T_requestedCellInfo_sequence[] = {
  { &hf_nr_rrc_ssbFrequency , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueNR },
  { &hf_nr_rrc_cellForWhichToReportCGI, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PhysCellId },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_requestedCellInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_requestedCellInfo, T_requestedCellInfo_sequence);

  return offset;
}


static const per_sequence_t T_reportCGI_RequestNR_sequence[] = {
  { &hf_nr_rrc_requestedCellInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_requestedCellInfo },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_reportCGI_RequestNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_reportCGI_RequestNR, T_reportCGI_RequestNR_sequence);

  return offset;
}


static const value_string nr_rrc_T_ph_Type1or3_vals[] = {
  {   0, "type1" },
  {   1, "type3" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_ph_Type1or3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PH_UplinkCarrierSCG_sequence[] = {
  { &hf_nr_rrc_ph_Type1or3  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_ph_Type1or3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PH_UplinkCarrierSCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PH_UplinkCarrierSCG, PH_UplinkCarrierSCG_sequence);

  return offset;
}


static const per_sequence_t PH_InfoSCG_sequence[] = {
  { &hf_nr_rrc_servCellIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ServCellIndex },
  { &hf_nr_rrc_ph_Uplink    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PH_UplinkCarrierSCG },
  { &hf_nr_rrc_ph_SupplementaryUplink, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_PH_UplinkCarrierSCG },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PH_InfoSCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PH_InfoSCG, PH_InfoSCG_sequence);

  return offset;
}


static const per_sequence_t PH_TypeListSCG_sequence_of[1] = {
  { &hf_nr_rrc_PH_TypeListSCG_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PH_InfoSCG },
};

static int
dissect_nr_rrc_PH_TypeListSCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_PH_TypeListSCG, PH_TypeListSCG_sequence_of,
                                                  1, maxNrofServingCells, FALSE);

  return offset;
}



static int
dissect_nr_rrc_T_scg_CellGroupConfigEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *scg_cell_group_config_eutra_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &scg_cell_group_config_eutra_tvb);

  if (scg_cell_group_config_eutra_tvb && lte_rrc_conn_reconf_handle) {
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_scg_CellGroupConfigEUTRA);
    nr_rrc_call_dissector(lte_rrc_conn_reconf_handle, scg_cell_group_config_eutra_tvb, actx->pinfo, subtree);
  }


  return offset;
}



static int
dissect_nr_rrc_T_cG_Config_v1560_IEs_candidateCellInfoListSN_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *cand_cell_info_list_sn_eutra_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &cand_cell_info_list_sn_eutra_tvb);

  if (cand_cell_info_list_sn_eutra_tvb) {
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_candidateCellInfoListSN_EUTRA);
    dissect_lte_rrc_MeasResultList3EUTRA_r15_PDU(cand_cell_info_list_sn_eutra_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t CandidateServingFreqListEUTRA_sequence_of[1] = {
  { &hf_nr_rrc_CandidateServingFreqListEUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueEUTRA },
};

static int
dissect_nr_rrc_CandidateServingFreqListEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_CandidateServingFreqListEUTRA, CandidateServingFreqListEUTRA_sequence_of,
                                                  1, maxFreqIDC_MRDC, FALSE);

  return offset;
}


static const value_string nr_rrc_T_needForGaps_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_needForGaps(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_1_31(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 31U, NULL, FALSE);

  return offset;
}


static const value_string nr_rrc_T_milliSeconds_01_vals[] = {
  {   0, "ms1" },
  {   1, "ms2" },
  {   2, "ms3" },
  {   3, "ms4" },
  {   4, "ms5" },
  {   5, "ms6" },
  {   6, "ms8" },
  {   7, "ms10" },
  {   8, "ms20" },
  {   9, "ms30" },
  {  10, "ms40" },
  {  11, "ms50" },
  {  12, "ms60" },
  {  13, "ms80" },
  {  14, "ms100" },
  {  15, "ms200" },
  {  16, "ms300" },
  {  17, "ms400" },
  {  18, "ms500" },
  {  19, "ms600" },
  {  20, "ms800" },
  {  21, "ms1000" },
  {  22, "ms1200" },
  {  23, "ms1600" },
  {  24, "spare8" },
  {  25, "spare7" },
  {  26, "spare6" },
  {  27, "spare5" },
  {  28, "spare4" },
  {  29, "spare3" },
  {  30, "spare2" },
  {  31, "spare1" },
  { 0, NULL }
};

static value_string_ext nr_rrc_T_milliSeconds_01_vals_ext = VALUE_STRING_EXT_INIT(nr_rrc_T_milliSeconds_01_vals);


static int
dissect_nr_rrc_T_milliSeconds_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     32, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_drx_onDurationTimer_01_vals[] = {
  {   0, "subMilliSeconds" },
  {   1, "milliSeconds" },
  { 0, NULL }
};

static const per_choice_t T_drx_onDurationTimer_01_choice[] = {
  {   0, &hf_nr_rrc_subMilliSeconds, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_1_31 },
  {   1, &hf_nr_rrc_milliSeconds_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_milliSeconds_01 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_drx_onDurationTimer_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_drx_onDurationTimer_01, T_drx_onDurationTimer_01_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_T_drx_InactivityTimer_vals[] = {
  {   0, "ms0" },
  {   1, "ms1" },
  {   2, "ms2" },
  {   3, "ms3" },
  {   4, "ms4" },
  {   5, "ms5" },
  {   6, "ms6" },
  {   7, "ms8" },
  {   8, "ms10" },
  {   9, "ms20" },
  {  10, "ms30" },
  {  11, "ms40" },
  {  12, "ms50" },
  {  13, "ms60" },
  {  14, "ms80" },
  {  15, "ms100" },
  {  16, "ms200" },
  {  17, "ms300" },
  {  18, "ms500" },
  {  19, "ms750" },
  {  20, "ms1280" },
  {  21, "ms1920" },
  {  22, "ms2560" },
  {  23, "spare9" },
  {  24, "spare8" },
  {  25, "spare7" },
  {  26, "spare6" },
  {  27, "spare5" },
  {  28, "spare4" },
  {  29, "spare3" },
  {  30, "spare2" },
  {  31, "spare1" },
  { 0, NULL }
};

static value_string_ext nr_rrc_T_drx_InactivityTimer_vals_ext = VALUE_STRING_EXT_INIT(nr_rrc_T_drx_InactivityTimer_vals);


static int
dissect_nr_rrc_T_drx_InactivityTimer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     32, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_56(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 56U, NULL, FALSE);

  return offset;
}


static const value_string nr_rrc_T_drx_RetransmissionTimerDL_vals[] = {
  {   0, "sl0" },
  {   1, "sl1" },
  {   2, "sl2" },
  {   3, "sl4" },
  {   4, "sl6" },
  {   5, "sl8" },
  {   6, "sl16" },
  {   7, "sl24" },
  {   8, "sl33" },
  {   9, "sl40" },
  {  10, "sl64" },
  {  11, "sl80" },
  {  12, "sl96" },
  {  13, "sl112" },
  {  14, "sl128" },
  {  15, "sl160" },
  {  16, "sl320" },
  {  17, "spare15" },
  {  18, "spare14" },
  {  19, "spare13" },
  {  20, "spare12" },
  {  21, "spare11" },
  {  22, "spare10" },
  {  23, "spare9" },
  {  24, "spare8" },
  {  25, "spare7" },
  {  26, "spare6" },
  {  27, "spare5" },
  {  28, "spare4" },
  {  29, "spare3" },
  {  30, "spare2" },
  {  31, "spare1" },
  { 0, NULL }
};

static value_string_ext nr_rrc_T_drx_RetransmissionTimerDL_vals_ext = VALUE_STRING_EXT_INIT(nr_rrc_T_drx_RetransmissionTimerDL_vals);


static int
dissect_nr_rrc_T_drx_RetransmissionTimerDL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     32, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_drx_RetransmissionTimerUL_vals[] = {
  {   0, "sl0" },
  {   1, "sl1" },
  {   2, "sl2" },
  {   3, "sl4" },
  {   4, "sl6" },
  {   5, "sl8" },
  {   6, "sl16" },
  {   7, "sl24" },
  {   8, "sl33" },
  {   9, "sl40" },
  {  10, "sl64" },
  {  11, "sl80" },
  {  12, "sl96" },
  {  13, "sl112" },
  {  14, "sl128" },
  {  15, "sl160" },
  {  16, "sl320" },
  {  17, "spare15" },
  {  18, "spare14" },
  {  19, "spare13" },
  {  20, "spare12" },
  {  21, "spare11" },
  {  22, "spare10" },
  {  23, "spare9" },
  {  24, "spare8" },
  {  25, "spare7" },
  {  26, "spare6" },
  {  27, "spare5" },
  {  28, "spare4" },
  {  29, "spare3" },
  {  30, "spare2" },
  {  31, "spare1" },
  { 0, NULL }
};

static value_string_ext nr_rrc_T_drx_RetransmissionTimerUL_vals_ext = VALUE_STRING_EXT_INIT(nr_rrc_T_drx_RetransmissionTimerUL_vals);


static int
dissect_nr_rrc_T_drx_RetransmissionTimerUL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     32, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_drx_LongCycleStartOffset_01_vals[] = {
  {   0, "ms10" },
  {   1, "ms20" },
  {   2, "ms32" },
  {   3, "ms40" },
  {   4, "ms60" },
  {   5, "ms64" },
  {   6, "ms70" },
  {   7, "ms80" },
  {   8, "ms128" },
  {   9, "ms160" },
  {  10, "ms256" },
  {  11, "ms320" },
  {  12, "ms512" },
  {  13, "ms640" },
  {  14, "ms1024" },
  {  15, "ms1280" },
  {  16, "ms2048" },
  {  17, "ms2560" },
  {  18, "ms5120" },
  {  19, "ms10240" },
  { 0, NULL }
};

static value_string_ext nr_rrc_T_drx_LongCycleStartOffset_01_vals_ext = VALUE_STRING_EXT_INIT(nr_rrc_T_drx_LongCycleStartOffset_01_vals);

static const per_choice_t T_drx_LongCycleStartOffset_01_choice[] = {
  {   0, &hf_nr_rrc_ms10         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_9 },
  {   1, &hf_nr_rrc_ms20         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_19 },
  {   2, &hf_nr_rrc_ms32         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_31 },
  {   3, &hf_nr_rrc_ms40         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_39 },
  {   4, &hf_nr_rrc_ms60         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_59 },
  {   5, &hf_nr_rrc_ms64         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_63 },
  {   6, &hf_nr_rrc_ms70         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_69 },
  {   7, &hf_nr_rrc_ms80         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_79 },
  {   8, &hf_nr_rrc_ms128        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_127 },
  {   9, &hf_nr_rrc_ms160        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_159 },
  {  10, &hf_nr_rrc_ms256        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_255 },
  {  11, &hf_nr_rrc_ms320        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_319 },
  {  12, &hf_nr_rrc_ms512        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_511 },
  {  13, &hf_nr_rrc_ms640        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_639 },
  {  14, &hf_nr_rrc_ms1024       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_1023 },
  {  15, &hf_nr_rrc_ms1280       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_1279 },
  {  16, &hf_nr_rrc_ms2048       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_2047 },
  {  17, &hf_nr_rrc_ms2560       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_2559 },
  {  18, &hf_nr_rrc_ms5120       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_5119 },
  {  19, &hf_nr_rrc_ms10240      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_10239 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_drx_LongCycleStartOffset_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_drx_LongCycleStartOffset_01, T_drx_LongCycleStartOffset_01_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_T_drx_ShortCycle_01_vals[] = {
  {   0, "ms2" },
  {   1, "ms3" },
  {   2, "ms4" },
  {   3, "ms5" },
  {   4, "ms6" },
  {   5, "ms7" },
  {   6, "ms8" },
  {   7, "ms10" },
  {   8, "ms14" },
  {   9, "ms16" },
  {  10, "ms20" },
  {  11, "ms30" },
  {  12, "ms32" },
  {  13, "ms35" },
  {  14, "ms40" },
  {  15, "ms64" },
  {  16, "ms80" },
  {  17, "ms128" },
  {  18, "ms160" },
  {  19, "ms256" },
  {  20, "ms320" },
  {  21, "ms512" },
  {  22, "ms640" },
  {  23, "spare9" },
  {  24, "spare8" },
  {  25, "spare7" },
  {  26, "spare6" },
  {  27, "spare5" },
  {  28, "spare4" },
  {  29, "spare3" },
  {  30, "spare2" },
  {  31, "spare1" },
  { 0, NULL }
};

static value_string_ext nr_rrc_T_drx_ShortCycle_01_vals_ext = VALUE_STRING_EXT_INIT(nr_rrc_T_drx_ShortCycle_01_vals);


static int
dissect_nr_rrc_T_drx_ShortCycle_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     32, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_shortDRX_01_sequence[] = {
  { &hf_nr_rrc_drx_ShortCycle_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_drx_ShortCycle_01 },
  { &hf_nr_rrc_drx_ShortCycleTimer, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_1_16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_shortDRX_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_shortDRX_01, T_shortDRX_01_sequence);

  return offset;
}


static const per_sequence_t DRX_Config_sequence[] = {
  { &hf_nr_rrc_drx_onDurationTimer_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_drx_onDurationTimer_01 },
  { &hf_nr_rrc_drx_InactivityTimer, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_drx_InactivityTimer },
  { &hf_nr_rrc_drx_HARQ_RTT_TimerDL, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_56 },
  { &hf_nr_rrc_drx_HARQ_RTT_TimerUL, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_56 },
  { &hf_nr_rrc_drx_RetransmissionTimerDL, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_drx_RetransmissionTimerDL },
  { &hf_nr_rrc_drx_RetransmissionTimerUL, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_drx_RetransmissionTimerUL },
  { &hf_nr_rrc_drx_LongCycleStartOffset_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_drx_LongCycleStartOffset_01 },
  { &hf_nr_rrc_shortDRX_01  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_shortDRX_01 },
  { &hf_nr_rrc_drx_SlotOffset, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_31 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_DRX_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_DRX_Config, DRX_Config_sequence);

  return offset;
}



static int
dissect_nr_rrc_EUTRA_PhysCellId(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 503U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_requestedCellInfoEUTRA_sequence[] = {
  { &hf_nr_rrc_eutraFrequency, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueEUTRA },
  { &hf_nr_rrc_cellForWhichToReportCGI_EUTRA, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_PhysCellId },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_requestedCellInfoEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_requestedCellInfoEUTRA, T_requestedCellInfoEUTRA_sequence);

  return offset;
}


static const per_sequence_t T_reportCGI_RequestEUTRA_sequence[] = {
  { &hf_nr_rrc_requestedCellInfoEUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_requestedCellInfoEUTRA },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_reportCGI_RequestEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_reportCGI_RequestEUTRA, T_reportCGI_RequestEUTRA_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxNrofServingCells_1_OF_ARFCN_ValueNR_sequence_of[1] = {
  { &hf_nr_rrc_scellFrequenciesSN_NR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueNR },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofServingCells_1_OF_ARFCN_ValueNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofServingCells_1_OF_ARFCN_ValueNR, SEQUENCE_SIZE_1_maxNrofServingCells_1_OF_ARFCN_ValueNR_sequence_of,
                                                  1, maxNrofServingCells_1, FALSE);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxNrofServingCells_1_OF_ARFCN_ValueEUTRA_sequence_of[1] = {
  { &hf_nr_rrc_scellFrequenciesSN_EUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueEUTRA },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofServingCells_1_OF_ARFCN_ValueEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofServingCells_1_OF_ARFCN_ValueEUTRA, SEQUENCE_SIZE_1_maxNrofServingCells_1_OF_ARFCN_ValueEUTRA_sequence_of,
                                                  1, maxNrofServingCells_1, FALSE);

  return offset;
}


static const value_string nr_rrc_T_milliSeconds_vals[] = {
  {   0, "ms1" },
  {   1, "ms2" },
  {   2, "ms3" },
  {   3, "ms4" },
  {   4, "ms5" },
  {   5, "ms6" },
  {   6, "ms8" },
  {   7, "ms10" },
  {   8, "ms20" },
  {   9, "ms30" },
  {  10, "ms40" },
  {  11, "ms50" },
  {  12, "ms60" },
  {  13, "ms80" },
  {  14, "ms100" },
  {  15, "ms200" },
  {  16, "ms300" },
  {  17, "ms400" },
  {  18, "ms500" },
  {  19, "ms600" },
  {  20, "ms800" },
  {  21, "ms1000" },
  {  22, "ms1200" },
  {  23, "ms1600" },
  {  24, "spare8" },
  {  25, "spare7" },
  {  26, "spare6" },
  {  27, "spare5" },
  {  28, "spare4" },
  {  29, "spare3" },
  {  30, "spare2" },
  {  31, "spare1" },
  { 0, NULL }
};

static value_string_ext nr_rrc_T_milliSeconds_vals_ext = VALUE_STRING_EXT_INIT(nr_rrc_T_milliSeconds_vals);


static int
dissect_nr_rrc_T_milliSeconds(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     32, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_drx_onDurationTimer_vals[] = {
  {   0, "subMilliSeconds" },
  {   1, "milliSeconds" },
  { 0, NULL }
};

static const per_choice_t T_drx_onDurationTimer_choice[] = {
  {   0, &hf_nr_rrc_subMilliSeconds, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_1_31 },
  {   1, &hf_nr_rrc_milliSeconds , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_milliSeconds },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_drx_onDurationTimer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_drx_onDurationTimer, T_drx_onDurationTimer_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DRX_Info2_sequence[] = {
  { &hf_nr_rrc_drx_onDurationTimer, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_drx_onDurationTimer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_DRX_Info2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_DRX_Info2, DRX_Info2_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_ueAssistanceInformationSCG_r16_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_UEAssistanceInformation_PDU);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_1_maxNrofPhysicalResourceBlocks(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxNrofPhysicalResourceBlocks, NULL, FALSE);

  return offset;
}


static const value_string nr_rrc_SubcarrierSpacing_vals[] = {
  {   0, "kHz15" },
  {   1, "kHz30" },
  {   2, "kHz60" },
  {   3, "kHz120" },
  {   4, "kHz240" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_SubcarrierSpacing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t FrequencyConfig_NR_r16_sequence[] = {
  { &hf_nr_rrc_freqBandIndicatorNR_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_FreqBandIndicatorNR },
  { &hf_nr_rrc_carrierCenterFreq_NR_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueNR },
  { &hf_nr_rrc_carrierBandwidth_NR_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_1_maxNrofPhysicalResourceBlocks },
  { &hf_nr_rrc_subcarrierSpacing_NR_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SubcarrierSpacing },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_FrequencyConfig_NR_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_FrequencyConfig_NR_r16, FrequencyConfig_NR_r16_sequence);

  return offset;
}


static const per_sequence_t ServCellInfoXCG_NR_r16_sequence[] = {
  { &hf_nr_rrc_dl_FreqInfo_NR_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_FrequencyConfig_NR_r16 },
  { &hf_nr_rrc_ul_FreqInfo_NR_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_FrequencyConfig_NR_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ServCellInfoXCG_NR_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ServCellInfoXCG_NR_r16, ServCellInfoXCG_NR_r16_sequence);

  return offset;
}


static const per_sequence_t ServCellInfoListSCG_NR_r16_sequence_of[1] = {
  { &hf_nr_rrc_ServCellInfoListSCG_NR_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ServCellInfoXCG_NR_r16 },
};

static int
dissect_nr_rrc_ServCellInfoListSCG_NR_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_ServCellInfoListSCG_NR_r16, ServCellInfoListSCG_NR_r16_sequence_of,
                                                  1, maxNrofServingCells, FALSE);

  return offset;
}


static const value_string nr_rrc_TransmissionBandwidth_EUTRA_r16_vals[] = {
  {   0, "rb6" },
  {   1, "rb15" },
  {   2, "rb25" },
  {   3, "rb50" },
  {   4, "rb75" },
  {   5, "rb100" },
  { 0, NULL }
};


static int
dissect_nr_rrc_TransmissionBandwidth_EUTRA_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t ServCellInfoXCG_EUTRA_r16_sequence[] = {
  { &hf_nr_rrc_dl_CarrierFreq_EUTRA_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ARFCN_ValueEUTRA },
  { &hf_nr_rrc_ul_CarrierFreq_EUTRA_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ARFCN_ValueEUTRA },
  { &hf_nr_rrc_transmissionBandwidth_EUTRA_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_TransmissionBandwidth_EUTRA_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ServCellInfoXCG_EUTRA_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ServCellInfoXCG_EUTRA_r16, ServCellInfoXCG_EUTRA_r16_sequence);

  return offset;
}


static const per_sequence_t ServCellInfoListSCG_EUTRA_r16_sequence_of[1] = {
  { &hf_nr_rrc_ServCellInfoListSCG_EUTRA_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ServCellInfoXCG_EUTRA_r16 },
};

static int
dissect_nr_rrc_ServCellInfoListSCG_EUTRA_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_ServCellInfoListSCG_EUTRA_r16, ServCellInfoListSCG_EUTRA_r16_sequence_of,
                                                  1, maxNrofServingCellsEUTRA, FALSE);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_02_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_02, T_nonCriticalExtension_02_sequence);

  return offset;
}


static const per_sequence_t CG_Config_v1640_IEs_sequence[] = {
  { &hf_nr_rrc_servCellInfoListSCG_NR_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ServCellInfoListSCG_NR_r16 },
  { &hf_nr_rrc_servCellInfoListSCG_EUTRA_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ServCellInfoListSCG_EUTRA_r16 },
  { &hf_nr_rrc_nonCriticalExtension_09, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_Config_v1640_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_Config_v1640_IEs, CG_Config_v1640_IEs_sequence);

  return offset;
}


static const per_sequence_t CG_Config_v1630_IEs_sequence[] = {
  { &hf_nr_rrc_selectedToffset_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_Offset_r16 },
  { &hf_nr_rrc_nonCriticalExtension_08, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CG_Config_v1640_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_Config_v1630_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_Config_v1630_IEs, CG_Config_v1630_IEs_sequence);

  return offset;
}


static const per_sequence_t CG_Config_v1620_IEs_sequence[] = {
  { &hf_nr_rrc_ueAssistanceInformationSCG_r16_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_ueAssistanceInformationSCG_r16_01 },
  { &hf_nr_rrc_nonCriticalExtension_07, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CG_Config_v1630_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_Config_v1620_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_Config_v1620_IEs, CG_Config_v1620_IEs_sequence);

  return offset;
}


static const per_sequence_t CG_Config_v1610_IEs_sequence[] = {
  { &hf_nr_rrc_drx_InfoSCG2 , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_DRX_Info2 },
  { &hf_nr_rrc_nonCriticalExtension_06, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CG_Config_v1620_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_Config_v1610_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_Config_v1610_IEs, CG_Config_v1610_IEs_sequence);

  return offset;
}


static const per_sequence_t CG_Config_v1590_IEs_sequence[] = {
  { &hf_nr_rrc_scellFrequenciesSN_NR, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofServingCells_1_OF_ARFCN_ValueNR },
  { &hf_nr_rrc_scellFrequenciesSN_EUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofServingCells_1_OF_ARFCN_ValueEUTRA },
  { &hf_nr_rrc_nonCriticalExtension_05, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CG_Config_v1610_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_Config_v1590_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_Config_v1590_IEs, CG_Config_v1590_IEs_sequence);

  return offset;
}


static const per_sequence_t CG_Config_v1560_IEs_sequence[] = {
  { &hf_nr_rrc_pSCellFrequencyEUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ARFCN_ValueEUTRA },
  { &hf_nr_rrc_scg_CellGroupConfigEUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_scg_CellGroupConfigEUTRA },
  { &hf_nr_rrc_cG_Config_v1560_IEs_candidateCellInfoListSN_EUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_cG_Config_v1560_IEs_candidateCellInfoListSN_EUTRA },
  { &hf_nr_rrc_candidateServingFreqListEUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CandidateServingFreqListEUTRA },
  { &hf_nr_rrc_needForGaps  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_needForGaps },
  { &hf_nr_rrc_drx_ConfigSCG, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_DRX_Config },
  { &hf_nr_rrc_reportCGI_RequestEUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_reportCGI_RequestEUTRA },
  { &hf_nr_rrc_nonCriticalExtension_04, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CG_Config_v1590_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_Config_v1560_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_Config_v1560_IEs, CG_Config_v1560_IEs_sequence);

  return offset;
}


static const per_sequence_t CG_Config_v1540_IEs_sequence[] = {
  { &hf_nr_rrc_pSCellFrequency, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ARFCN_ValueNR },
  { &hf_nr_rrc_reportCGI_RequestNR, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_reportCGI_RequestNR },
  { &hf_nr_rrc_ph_InfoSCG   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_PH_TypeListSCG },
  { &hf_nr_rrc_nonCriticalExtension_03, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CG_Config_v1560_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_Config_v1540_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_Config_v1540_IEs, CG_Config_v1540_IEs_sequence);

  return offset;
}


static const per_sequence_t CG_Config_IEs_sequence[] = {
  { &hf_nr_rrc_scg_CellGroupConfig, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_scg_CellGroupConfig },
  { &hf_nr_rrc_scg_RB_Config, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_scg_RB_Config },
  { &hf_nr_rrc_configRestrictModReq, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ConfigRestrictModReqSCG },
  { &hf_nr_rrc_drx_InfoSCG  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_DRX_Info },
  { &hf_nr_rrc_candidateCellInfoListSN, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_candidateCellInfoListSN },
  { &hf_nr_rrc_measConfigSN , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasConfigSN },
  { &hf_nr_rrc_selectedBandCombination, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_BandCombinationInfoSN },
  { &hf_nr_rrc_fr_InfoListSCG, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_FR_InfoList },
  { &hf_nr_rrc_candidateServingFreqListNR, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CandidateServingFreqListNR },
  { &hf_nr_rrc_nonCriticalExtension_02, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CG_Config_v1540_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_Config_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_Config_IEs, CG_Config_IEs_sequence);

  return offset;
}


static const value_string nr_rrc_T_c1_02_vals[] = {
  {   0, "cg-Config" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_02_choice[] = {
  {   0, &hf_nr_rrc_cg_Config    , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_CG_Config_IEs },
  {   1, &hf_nr_rrc_spare3       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   2, &hf_nr_rrc_spare2       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   3, &hf_nr_rrc_spare1       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_c1_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_c1_02, T_c1_02_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_02_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_02, T_criticalExtensionsFuture_02_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_02_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_02_choice[] = {
  {   0, &hf_nr_rrc_c1_02        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_c1_02 },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_02, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_02 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_02, T_criticalExtensions_02_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CG_Config_sequence[] = {
  { &hf_nr_rrc_criticalExtensions_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_Config, CG_Config_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_ue_CapabilityInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_UE_CapabilityRAT_ContainerList_PDU);

  return offset;
}



static int
dissect_nr_rrc_T_candidateCellInfoListSN_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_MeasResultList2NR_PDU);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_M30720_30719(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -30720, 30719U, NULL, FALSE);

  return offset;
}


static const per_sequence_t MeasResultCellSFTD_NR_sequence[] = {
  { &hf_nr_rrc_physCellId   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PhysCellId },
  { &hf_nr_rrc_sfn_OffsetResult, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_1023 },
  { &hf_nr_rrc_frameBoundaryOffsetResult, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_M30720_30719 },
  { &hf_nr_rrc_rsrp_Result  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RSRP_Range },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasResultCellSFTD_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasResultCellSFTD_NR, MeasResultCellSFTD_NR_sequence);

  return offset;
}


static const per_sequence_t MeasResultCellListSFTD_NR_sequence_of[1] = {
  { &hf_nr_rrc_MeasResultCellListSFTD_NR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasResultCellSFTD_NR },
};

static int
dissect_nr_rrc_MeasResultCellListSFTD_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MeasResultCellListSFTD_NR, MeasResultCellListSFTD_NR_sequence_of,
                                                  1, maxCellSFTD, FALSE);

  return offset;
}


static const value_string nr_rrc_T_failureType_vals[] = {
  {   0, "t310-Expiry" },
  {   1, "randomAccessProblem" },
  {   2, "rlc-MaxNumRetx" },
  {   3, "synchReconfigFailure-SCG" },
  {   4, "scg-reconfigFailure" },
  {   5, "srb3-IntegrityFailure" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_failureType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_T_measResultSCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_MeasResultSCG_Failure_PDU);

  return offset;
}


static const per_sequence_t T_scgFailureInfo_sequence[] = {
  { &hf_nr_rrc_failureType  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_failureType },
  { &hf_nr_rrc_measResultSCG, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_measResultSCG },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_scgFailureInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_scgFailureInfo, T_scgFailureInfo_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxMeasFreqsMN_OF_NR_FreqInfo_sequence_of[1] = {
  { &hf_nr_rrc_measuredFrequenciesMN_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_NR_FreqInfo },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxMeasFreqsMN_OF_NR_FreqInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxMeasFreqsMN_OF_NR_FreqInfo, SEQUENCE_SIZE_1_maxMeasFreqsMN_OF_NR_FreqInfo_sequence_of,
                                                  1, maxMeasFreqsMN, FALSE);

  return offset;
}


static const value_string nr_rrc_T_mgl_vals[] = {
  {   0, "ms1dot5" },
  {   1, "ms3" },
  {   2, "ms3dot5" },
  {   3, "ms4" },
  {   4, "ms5dot5" },
  {   5, "ms6" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_mgl(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_mgrp_vals[] = {
  {   0, "ms20" },
  {   1, "ms40" },
  {   2, "ms80" },
  {   3, "ms160" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_mgrp(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_mgta_vals[] = {
  {   0, "ms0" },
  {   1, "ms0dot25" },
  {   2, "ms0dot5" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_mgta(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_refServCellIndicator_vals[] = {
  {   0, "pCell" },
  {   1, "pSCell" },
  {   2, "mcg-FR2" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_refServCellIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t GapConfig_eag_1_sequence[] = {
  { &hf_nr_rrc_refServCellIndicator, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_refServCellIndicator },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_GapConfig_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GapConfig_eag_1_sequence);

  return offset;
}


static const value_string nr_rrc_T_mgl_r16_vals[] = {
  {   0, "ms10" },
  {   1, "ms20" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_mgl_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t GapConfig_eag_2_sequence[] = {
  { &hf_nr_rrc_refFR2ServCellAsyncCA_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ServCellIndex },
  { &hf_nr_rrc_mgl_r16      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_mgl_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_GapConfig_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GapConfig_eag_2_sequence);

  return offset;
}


static const per_sequence_t GapConfig_sequence[] = {
  { &hf_nr_rrc_gapOffset    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_159 },
  { &hf_nr_rrc_mgl          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_mgl },
  { &hf_nr_rrc_mgrp         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_mgrp },
  { &hf_nr_rrc_mgta         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_mgta },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_GapConfig_eag_1 },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_GapConfig_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_GapConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_GapConfig, GapConfig_sequence);

  return offset;
}


static const value_string nr_rrc_T_measGapConfig_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_measGapConfig_choice[] = {
  {   0, &hf_nr_rrc_release      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   1, &hf_nr_rrc_setup        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_GapConfig },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_measGapConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_measGapConfig, T_measGapConfig_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_T_gapPurpose_vals[] = {
  {   0, "perUE" },
  {   1, "perFR1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_gapPurpose(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_measGapConfigFR2_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_measGapConfigFR2_choice[] = {
  {   0, &hf_nr_rrc_release      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   1, &hf_nr_rrc_setup        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_GapConfig },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_measGapConfigFR2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_measGapConfigFR2, T_measGapConfigFR2_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MeasConfigMN_eag_1_sequence[] = {
  { &hf_nr_rrc_measGapConfigFR2, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_measGapConfigFR2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasConfigMN_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, MeasConfigMN_eag_1_sequence);

  return offset;
}


static const per_sequence_t MeasConfigMN_sequence[] = {
  { &hf_nr_rrc_measuredFrequenciesMN, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxMeasFreqsMN_OF_NR_FreqInfo },
  { &hf_nr_rrc_measGapConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_measGapConfig },
  { &hf_nr_rrc_gapPurpose   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_gapPurpose },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasConfigMN_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasConfigMN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasConfigMN, MeasConfigMN_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_sourceConfigSCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_RRCReconfiguration_PDU);

  return offset;
}



static int
dissect_nr_rrc_T_scg_RB_Config_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_RadioBearerConfig_PDU);

  return offset;
}



static int
dissect_nr_rrc_T_mcg_RB_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_RadioBearerConfig_PDU);

  return offset;
}


static const value_string nr_rrc_T_gps_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_gps(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_glonass_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_glonass(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_bds_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_bds(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_galileo_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_galileo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_wlan_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_wlan(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_bluetooth_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_bluetooth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t VictimSystemType_sequence[] = {
  { &hf_nr_rrc_gps          , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_gps },
  { &hf_nr_rrc_glonass      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_glonass },
  { &hf_nr_rrc_bds          , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_bds },
  { &hf_nr_rrc_galileo      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_galileo },
  { &hf_nr_rrc_wlan         , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_wlan },
  { &hf_nr_rrc_bluetooth    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_bluetooth },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_VictimSystemType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_VictimSystemType, VictimSystemType_sequence);

  return offset;
}


static const value_string nr_rrc_T_interferenceDirectionMRDC_vals[] = {
  {   0, "eutra-nr" },
  {   1, "nr" },
  {   2, "other" },
  {   3, "utra-nr-other" },
  {   4, "nr-other" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_interferenceDirectionMRDC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t AffectedCarrierFreqCombEUTRA_sequence_of[1] = {
  { &hf_nr_rrc_AffectedCarrierFreqCombEUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueEUTRA },
};

static int
dissect_nr_rrc_AffectedCarrierFreqCombEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_AffectedCarrierFreqCombEUTRA, AffectedCarrierFreqCombEUTRA_sequence_of,
                                                  1, maxNrofServingCellsEUTRA, FALSE);

  return offset;
}


static const per_sequence_t AffectedCarrierFreqCombNR_sequence_of[1] = {
  { &hf_nr_rrc_AffectedCarrierFreqCombNR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueNR },
};

static int
dissect_nr_rrc_AffectedCarrierFreqCombNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_AffectedCarrierFreqCombNR, AffectedCarrierFreqCombNR_sequence_of,
                                                  1, maxNrofServingCells, FALSE);

  return offset;
}


static const per_sequence_t T_affectedCarrierFreqCombMRDC_sequence[] = {
  { &hf_nr_rrc_affectedCarrierFreqCombEUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_AffectedCarrierFreqCombEUTRA },
  { &hf_nr_rrc_affectedCarrierFreqCombNR, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_AffectedCarrierFreqCombNR },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_affectedCarrierFreqCombMRDC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_affectedCarrierFreqCombMRDC, T_affectedCarrierFreqCombMRDC_sequence);

  return offset;
}


static const per_sequence_t AffectedCarrierFreqCombInfoMRDC_sequence[] = {
  { &hf_nr_rrc_victimSystemType, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_VictimSystemType },
  { &hf_nr_rrc_interferenceDirectionMRDC, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_interferenceDirectionMRDC },
  { &hf_nr_rrc_affectedCarrierFreqCombMRDC, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_affectedCarrierFreqCombMRDC },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_AffectedCarrierFreqCombInfoMRDC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_AffectedCarrierFreqCombInfoMRDC, AffectedCarrierFreqCombInfoMRDC_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxNrofCombIDC_OF_AffectedCarrierFreqCombInfoMRDC_sequence_of[1] = {
  { &hf_nr_rrc_affectedCarrierFreqCombInfoListMRDC_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_AffectedCarrierFreqCombInfoMRDC },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofCombIDC_OF_AffectedCarrierFreqCombInfoMRDC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCombIDC_OF_AffectedCarrierFreqCombInfoMRDC, SEQUENCE_SIZE_1_maxNrofCombIDC_OF_AffectedCarrierFreqCombInfoMRDC_sequence_of,
                                                  1, maxNrofCombIDC, FALSE);

  return offset;
}



static int
dissect_nr_rrc_T_overheatingAssistanceSCG_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_OverheatingAssistance_PDU);

  return offset;
}


static const per_sequence_t MRDC_AssistanceInfo_eag_1_sequence[] = {
  { &hf_nr_rrc_overheatingAssistanceSCG_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_overheatingAssistanceSCG_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MRDC_AssistanceInfo_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, MRDC_AssistanceInfo_eag_1_sequence);

  return offset;
}


static const per_sequence_t MRDC_AssistanceInfo_sequence[] = {
  { &hf_nr_rrc_affectedCarrierFreqCombInfoListMRDC, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofCombIDC_OF_AffectedCarrierFreqCombInfoMRDC },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_MRDC_AssistanceInfo_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MRDC_AssistanceInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MRDC_AssistanceInfo, MRDC_AssistanceInfo_sequence);

  return offset;
}


static const value_string nr_rrc_T_ph_Type1or3_01_vals[] = {
  {   0, "type1" },
  {   1, "type3" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_ph_Type1or3_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PH_UplinkCarrierMCG_sequence[] = {
  { &hf_nr_rrc_ph_Type1or3_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_ph_Type1or3_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PH_UplinkCarrierMCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PH_UplinkCarrierMCG, PH_UplinkCarrierMCG_sequence);

  return offset;
}


static const per_sequence_t PH_InfoMCG_sequence[] = {
  { &hf_nr_rrc_servCellIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ServCellIndex },
  { &hf_nr_rrc_ph_Uplink_01 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PH_UplinkCarrierMCG },
  { &hf_nr_rrc_ph_SupplementaryUplink_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_PH_UplinkCarrierMCG },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PH_InfoMCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PH_InfoMCG, PH_InfoMCG_sequence);

  return offset;
}


static const per_sequence_t PH_TypeListMCG_sequence_of[1] = {
  { &hf_nr_rrc_PH_TypeListMCG_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PH_InfoMCG },
};

static int
dissect_nr_rrc_PH_TypeListMCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_PH_TypeListMCG, PH_TypeListMCG_sequence_of,
                                                  1, maxNrofServingCells, FALSE);

  return offset;
}


static const per_sequence_t T_measResultReportCGI_sequence[] = {
  { &hf_nr_rrc_ssbFrequency , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueNR },
  { &hf_nr_rrc_cellForWhichToReportCGI, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PhysCellId },
  { &hf_nr_rrc_cgi_Info     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CGI_InfoNR },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_measResultReportCGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_measResultReportCGI, T_measResultReportCGI_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_candidateCellInfoListMN_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *cand_cell_info_list_mn_eutra_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &cand_cell_info_list_mn_eutra_tvb);

  if (cand_cell_info_list_mn_eutra_tvb) {
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_candidateCellInfoListMN_EUTRA);
    dissect_lte_rrc_MeasResultList3EUTRA_r15_PDU(cand_cell_info_list_mn_eutra_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_nr_rrc_T_cG_ConfigInfo_v1560_IEs_candidateCellInfoListSN_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *cand_cell_info_list_sn_eutra_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &cand_cell_info_list_sn_eutra_tvb);

  if (cand_cell_info_list_sn_eutra_tvb) {
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_candidateCellInfoListSN_EUTRA);
    dissect_lte_rrc_MeasResultList3EUTRA_r15_PDU(cand_cell_info_list_sn_eutra_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_nr_rrc_T_sourceConfigSCG_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *source_config_scg_eutra_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &source_config_scg_eutra_tvb);

  if (source_config_scg_eutra_tvb && lte_rrc_conn_reconf_handle) {
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_sourceConfigSCG_EUTRA);
    nr_rrc_call_dissector(lte_rrc_conn_reconf_handle, source_config_scg_eutra_tvb, actx->pinfo, subtree);
  }


  return offset;
}


static const value_string nr_rrc_T_failureTypeEUTRA_vals[] = {
  {   0, "t313-Expiry" },
  {   1, "randomAccessProblem" },
  {   2, "rlc-MaxNumRetx" },
  {   3, "scg-ChangeFailure" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_failureTypeEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_T_measResultSCG_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *meas_result_scg_fail_mrdc_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &meas_result_scg_fail_mrdc_tvb);

  if (meas_result_scg_fail_mrdc_tvb) {
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_measResultSCG_FailureMRDC);
    dissect_lte_rrc_MeasResultSCG_FailureMRDC_r15_PDU(meas_result_scg_fail_mrdc_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t T_scgFailureInfoEUTRA_sequence[] = {
  { &hf_nr_rrc_failureTypeEUTRA, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_failureTypeEUTRA },
  { &hf_nr_rrc_measResultSCG_EUTRA, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_measResultSCG_EUTRA },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_scgFailureInfoEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_scgFailureInfoEUTRA, T_scgFailureInfoEUTRA_sequence);

  return offset;
}


static const per_sequence_t T_measResultReportCGI_EUTRA_sequence[] = {
  { &hf_nr_rrc_eutraFrequency, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueEUTRA },
  { &hf_nr_rrc_cellForWhichToReportCGI_EUTRA, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_PhysCellId },
  { &hf_nr_rrc_cgi_InfoEUTRA, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CGI_InfoEUTRA },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_measResultReportCGI_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_measResultReportCGI_EUTRA, T_measResultReportCGI_EUTRA_sequence);

  return offset;
}


static const per_sequence_t MeasResultSFTD_EUTRA_sequence[] = {
  { &hf_nr_rrc_eutra_PhysCellId, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_PhysCellId },
  { &hf_nr_rrc_sfn_OffsetResult, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_1023 },
  { &hf_nr_rrc_frameBoundaryOffsetResult, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_M30720_30719 },
  { &hf_nr_rrc_rsrp_Result  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RSRP_Range },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasResultSFTD_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasResultSFTD_EUTRA, MeasResultSFTD_EUTRA_sequence);

  return offset;
}


static const per_sequence_t MeasResultCellListSFTD_EUTRA_sequence_of[1] = {
  { &hf_nr_rrc_MeasResultCellListSFTD_EUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasResultSFTD_EUTRA },
};

static int
dissect_nr_rrc_MeasResultCellListSFTD_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MeasResultCellListSFTD_EUTRA, MeasResultCellListSFTD_EUTRA_sequence_of,
                                                  1, maxCellSFTD, FALSE);

  return offset;
}


static const per_sequence_t SFTD_FrequencyList_NR_sequence_of[1] = {
  { &hf_nr_rrc_SFTD_FrequencyList_NR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueNR },
};

static int
dissect_nr_rrc_SFTD_FrequencyList_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SFTD_FrequencyList_NR, SFTD_FrequencyList_NR_sequence_of,
                                                  1, maxCellSFTD, FALSE);

  return offset;
}


static const per_sequence_t SFTD_FrequencyList_EUTRA_sequence_of[1] = {
  { &hf_nr_rrc_SFTD_FrequencyList_EUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueEUTRA },
};

static int
dissect_nr_rrc_SFTD_FrequencyList_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SFTD_FrequencyList_EUTRA, SFTD_FrequencyList_EUTRA_sequence_of,
                                                  1, maxCellSFTD, FALSE);

  return offset;
}


static const value_string nr_rrc_T_alignedDRX_Indication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_alignedDRX_Indication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_failureType_r16_vals[] = {
  {   0, "scg-lbtFailure-r16" },
  {   1, "beamFailureRecoveryFailure-r16" },
  {   2, "t312-Expiry-r16" },
  {   3, "bh-RLF-r16" },
  {   4, "spare4" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_failureType_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_T_measResultSCG_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_MeasResultSCG_Failure_PDU);

  return offset;
}


static const per_sequence_t T_scgFailureInfo_r16_sequence[] = {
  { &hf_nr_rrc_failureType_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_failureType_r16 },
  { &hf_nr_rrc_measResultSCG_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_measResultSCG_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_scgFailureInfo_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_scgFailureInfo_r16, T_scgFailureInfo_r16_sequence);

  return offset;
}


static const value_string nr_rrc_T_failureTypeEUTRA_r16_vals[] = {
  {   0, "scg-lbtFailure-r16" },
  {   1, "beamFailureRecoveryFailure-r16" },
  {   2, "t312-Expiry-r16" },
  {   3, "spare5" },
  {   4, "spare4" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_failureTypeEUTRA_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_OCTET_STRING(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, NULL);

  return offset;
}


static const per_sequence_t T_dummy1_sequence[] = {
  { &hf_nr_rrc_failureTypeEUTRA_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_failureTypeEUTRA_r16 },
  { &hf_nr_rrc_measResultSCG_EUTRA_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_OCTET_STRING },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_dummy1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_dummy1, T_dummy1_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_sidelinkUEInformationNR_r16_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_SidelinkUEInformationNR_r16_PDU);

  return offset;
}



static int
dissect_nr_rrc_T_ueAssistanceInformationSourceSCG_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_UEAssistanceInformation_PDU);

  return offset;
}


static const per_sequence_t ServCellInfoListMCG_NR_r16_sequence_of[1] = {
  { &hf_nr_rrc_ServCellInfoListMCG_NR_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ServCellInfoXCG_NR_r16 },
};

static int
dissect_nr_rrc_ServCellInfoListMCG_NR_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_ServCellInfoListMCG_NR_r16, ServCellInfoListMCG_NR_r16_sequence_of,
                                                  1, maxNrofServingCells, FALSE);

  return offset;
}


static const per_sequence_t ServCellInfoListMCG_EUTRA_r16_sequence_of[1] = {
  { &hf_nr_rrc_ServCellInfoListMCG_EUTRA_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ServCellInfoXCG_EUTRA_r16 },
};

static int
dissect_nr_rrc_ServCellInfoListMCG_EUTRA_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_ServCellInfoListMCG_EUTRA_r16, ServCellInfoListMCG_EUTRA_r16_sequence_of,
                                                  1, maxNrofServingCellsEUTRA, FALSE);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_03_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_03, T_nonCriticalExtension_03_sequence);

  return offset;
}


static const per_sequence_t CG_ConfigInfo_v1640_IEs_sequence[] = {
  { &hf_nr_rrc_servCellInfoListMCG_NR_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ServCellInfoListMCG_NR_r16 },
  { &hf_nr_rrc_servCellInfoListMCG_EUTRA_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ServCellInfoListMCG_EUTRA_r16 },
  { &hf_nr_rrc_nonCriticalExtension_17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_03 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_ConfigInfo_v1640_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_ConfigInfo_v1640_IEs, CG_ConfigInfo_v1640_IEs_sequence);

  return offset;
}


static const per_sequence_t CG_ConfigInfo_v1620_IEs_sequence[] = {
  { &hf_nr_rrc_ueAssistanceInformationSourceSCG_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_ueAssistanceInformationSourceSCG_r16 },
  { &hf_nr_rrc_nonCriticalExtension_16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CG_ConfigInfo_v1640_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_ConfigInfo_v1620_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_ConfigInfo_v1620_IEs, CG_ConfigInfo_v1620_IEs_sequence);

  return offset;
}


static const per_sequence_t CG_ConfigInfo_v1610_IEs_sequence[] = {
  { &hf_nr_rrc_drx_InfoMCG2 , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_DRX_Info2 },
  { &hf_nr_rrc_alignedDRX_Indication, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_alignedDRX_Indication },
  { &hf_nr_rrc_scgFailureInfo_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_scgFailureInfo_r16 },
  { &hf_nr_rrc_dummy1       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_dummy1 },
  { &hf_nr_rrc_sidelinkUEInformationNR_r16_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_sidelinkUEInformationNR_r16_01 },
  { &hf_nr_rrc_sidelinkUEInformationEUTRA_r16_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { &hf_nr_rrc_nonCriticalExtension_15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CG_ConfigInfo_v1620_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_ConfigInfo_v1610_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_ConfigInfo_v1610_IEs, CG_ConfigInfo_v1610_IEs_sequence);

  return offset;
}


static const per_sequence_t CG_ConfigInfo_v1590_IEs_sequence[] = {
  { &hf_nr_rrc_servFrequenciesMN_NR, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofServingCells_1_OF_ARFCN_ValueNR },
  { &hf_nr_rrc_nonCriticalExtension_14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CG_ConfigInfo_v1610_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_ConfigInfo_v1590_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_ConfigInfo_v1590_IEs, CG_ConfigInfo_v1590_IEs_sequence);

  return offset;
}


static const per_sequence_t CG_ConfigInfo_v1570_IEs_sequence[] = {
  { &hf_nr_rrc_sftdFrequencyList_NR, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SFTD_FrequencyList_NR },
  { &hf_nr_rrc_sftdFrequencyList_EUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SFTD_FrequencyList_EUTRA },
  { &hf_nr_rrc_nonCriticalExtension_13, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CG_ConfigInfo_v1590_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_ConfigInfo_v1570_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_ConfigInfo_v1570_IEs, CG_ConfigInfo_v1570_IEs_sequence);

  return offset;
}


static const per_sequence_t CG_ConfigInfo_v1560_IEs_sequence[] = {
  { &hf_nr_rrc_candidateCellInfoListMN_EUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_candidateCellInfoListMN_EUTRA },
  { &hf_nr_rrc_cG_ConfigInfo_v1560_IEs_candidateCellInfoListSN_EUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_cG_ConfigInfo_v1560_IEs_candidateCellInfoListSN_EUTRA },
  { &hf_nr_rrc_sourceConfigSCG_EUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_sourceConfigSCG_EUTRA },
  { &hf_nr_rrc_scgFailureInfoEUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_scgFailureInfoEUTRA },
  { &hf_nr_rrc_drx_ConfigMCG, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_DRX_Config },
  { &hf_nr_rrc_measResultReportCGI_EUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_measResultReportCGI_EUTRA },
  { &hf_nr_rrc_measResultCellListSFTD_EUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasResultCellListSFTD_EUTRA },
  { &hf_nr_rrc_fr_InfoListMCG, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_FR_InfoList },
  { &hf_nr_rrc_nonCriticalExtension_12, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CG_ConfigInfo_v1570_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_ConfigInfo_v1560_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_ConfigInfo_v1560_IEs, CG_ConfigInfo_v1560_IEs_sequence);

  return offset;
}


static const per_sequence_t CG_ConfigInfo_v1540_IEs_sequence[] = {
  { &hf_nr_rrc_ph_InfoMCG   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_PH_TypeListMCG },
  { &hf_nr_rrc_measResultReportCGI, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_measResultReportCGI },
  { &hf_nr_rrc_nonCriticalExtension_11, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CG_ConfigInfo_v1560_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_ConfigInfo_v1540_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_ConfigInfo_v1540_IEs, CG_ConfigInfo_v1540_IEs_sequence);

  return offset;
}


static const per_sequence_t CG_ConfigInfo_IEs_sequence[] = {
  { &hf_nr_rrc_ue_CapabilityInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_ue_CapabilityInfo },
  { &hf_nr_rrc_candidateCellInfoListMN, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasResultList2NR },
  { &hf_nr_rrc_candidateCellInfoListSN_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_candidateCellInfoListSN_01 },
  { &hf_nr_rrc_measResultCellListSFTD_NR, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasResultCellListSFTD_NR },
  { &hf_nr_rrc_scgFailureInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_scgFailureInfo },
  { &hf_nr_rrc_configRestrictInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ConfigRestrictInfoSCG },
  { &hf_nr_rrc_drx_InfoMCG  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_DRX_Info },
  { &hf_nr_rrc_measConfigMN , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasConfigMN },
  { &hf_nr_rrc_sourceConfigSCG, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_sourceConfigSCG },
  { &hf_nr_rrc_scg_RB_Config_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_scg_RB_Config_01 },
  { &hf_nr_rrc_mcg_RB_Config, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_mcg_RB_Config },
  { &hf_nr_rrc_mrdc_AssistanceInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MRDC_AssistanceInfo },
  { &hf_nr_rrc_nonCriticalExtension_10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CG_ConfigInfo_v1540_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_ConfigInfo_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_ConfigInfo_IEs, CG_ConfigInfo_IEs_sequence);

  return offset;
}


static const value_string nr_rrc_T_c1_03_vals[] = {
  {   0, "cg-ConfigInfo" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_03_choice[] = {
  {   0, &hf_nr_rrc_cg_ConfigInfo, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_CG_ConfigInfo_IEs },
  {   1, &hf_nr_rrc_spare3       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   2, &hf_nr_rrc_spare2       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   3, &hf_nr_rrc_spare1       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_c1_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_c1_03, T_c1_03_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_03_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_03, T_criticalExtensionsFuture_03_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_03_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_03_choice[] = {
  {   0, &hf_nr_rrc_c1_03        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_c1_03 },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_03, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_03 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_03, T_criticalExtensions_03_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CG_ConfigInfo_sequence[] = {
  { &hf_nr_rrc_criticalExtensions_03, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_03 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_ConfigInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_ConfigInfo, CG_ConfigInfo_sequence);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4U, NULL, FALSE);

  return offset;
}


static const value_string nr_rrc_T_periodicityAndOffset_01_vals[] = {
  {   0, "sf5" },
  {   1, "sf10" },
  {   2, "sf20" },
  {   3, "sf40" },
  {   4, "sf80" },
  {   5, "sf160" },
  { 0, NULL }
};

static const per_choice_t T_periodicityAndOffset_01_choice[] = {
  {   0, &hf_nr_rrc_sf5          , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_4 },
  {   1, &hf_nr_rrc_sf10         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_9 },
  {   2, &hf_nr_rrc_sf20         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_19 },
  {   3, &hf_nr_rrc_sf40         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_39 },
  {   4, &hf_nr_rrc_sf80         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_79 },
  {   5, &hf_nr_rrc_sf160        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_159 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_periodicityAndOffset_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_periodicityAndOffset_01, T_periodicityAndOffset_01_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_T_duration_vals[] = {
  {   0, "sf1" },
  {   1, "sf2" },
  {   2, "sf3" },
  {   3, "sf4" },
  {   4, "sf5" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_duration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t SSB_MTC_sequence[] = {
  { &hf_nr_rrc_periodicityAndOffset_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_periodicityAndOffset_01 },
  { &hf_nr_rrc_duration_02  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_duration },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SSB_MTC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SSB_MTC, SSB_MTC_sequence);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_1_80(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 80, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, FALSE);

  return offset;
}


static const per_sequence_t SS_RSSI_Measurement_sequence[] = {
  { &hf_nr_rrc_measurementSlots, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BIT_STRING_SIZE_1_80 },
  { &hf_nr_rrc_endSymbol    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SS_RSSI_Measurement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SS_RSSI_Measurement, SS_RSSI_Measurement_sequence);

  return offset;
}


static const per_sequence_t T_frequencyAndTiming_sequence[] = {
  { &hf_nr_rrc_carrierFreq  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueNR },
  { &hf_nr_rrc_ssbSubcarrierSpacing, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SubcarrierSpacing },
  { &hf_nr_rrc_ssb_MeasurementTimingConfiguration, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SSB_MTC },
  { &hf_nr_rrc_ss_RSSI_Measurement, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SS_RSSI_Measurement },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_frequencyAndTiming(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_frequencyAndTiming, T_frequencyAndTiming_sequence);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     4, 4, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_8(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_64(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     64, 64, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string nr_rrc_SSB_ToMeasure_vals[] = {
  {   0, "shortBitmap" },
  {   1, "mediumBitmap" },
  {   2, "longBitmap" },
  { 0, NULL }
};

static const per_choice_t SSB_ToMeasure_choice[] = {
  {   0, &hf_nr_rrc_shortBitmap  , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_BIT_STRING_SIZE_4 },
  {   1, &hf_nr_rrc_mediumBitmap , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_BIT_STRING_SIZE_8 },
  {   2, &hf_nr_rrc_longBitmap   , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_BIT_STRING_SIZE_64 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_SSB_ToMeasure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_SSB_ToMeasure, SSB_ToMeasure_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MeasTiming_eag_1_sequence[] = {
  { &hf_nr_rrc_ssb_ToMeasure, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SSB_ToMeasure },
  { &hf_nr_rrc_physCellId   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_PhysCellId },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasTiming_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, MeasTiming_eag_1_sequence);

  return offset;
}


static const per_sequence_t MeasTiming_sequence[] = {
  { &hf_nr_rrc_frequencyAndTiming, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_frequencyAndTiming },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasTiming_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasTiming(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasTiming, MeasTiming_sequence);

  return offset;
}


static const per_sequence_t MeasTimingList_sequence_of[1] = {
  { &hf_nr_rrc_MeasTimingList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasTiming },
};

static int
dissect_nr_rrc_MeasTimingList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MeasTimingList, MeasTimingList_sequence_of,
                                                  1, maxMeasFreqsMN, FALSE);

  return offset;
}



static int
dissect_nr_rrc_BOOLEAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const value_string nr_rrc_T_nrofPRBs_vals[] = {
  {   0, "size24" },
  {   1, "size48" },
  {   2, "size96" },
  {   3, "size192" },
  {   4, "size264" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_nrofPRBs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_2169(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2169U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_csi_rs_MeasurementBW_sequence[] = {
  { &hf_nr_rrc_nrofPRBs     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_nrofPRBs },
  { &hf_nr_rrc_startPRB     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_2169 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_csi_rs_MeasurementBW(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_csi_rs_MeasurementBW, T_csi_rs_MeasurementBW_sequence);

  return offset;
}


static const value_string nr_rrc_T_density_vals[] = {
  {   0, "d1" },
  {   1, "d3" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_density(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_slotConfig_vals[] = {
  {   0, "ms4" },
  {   1, "ms5" },
  {   2, "ms10" },
  {   3, "ms20" },
  {   4, "ms40" },
  { 0, NULL }
};

static const per_choice_t T_slotConfig_choice[] = {
  {   0, &hf_nr_rrc_ms4          , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_31 },
  {   1, &hf_nr_rrc_ms5          , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_39 },
  {   2, &hf_nr_rrc_ms10_01      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_79 },
  {   3, &hf_nr_rrc_ms20_01      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_159 },
  {   4, &hf_nr_rrc_ms40_01      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_319 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_slotConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_slotConfig, T_slotConfig_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_associatedSSB_sequence[] = {
  { &hf_nr_rrc_ssb_Index    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SSB_Index },
  { &hf_nr_rrc_isQuasiColocated, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_associatedSSB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_associatedSSB, T_associatedSSB_sequence);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     12, 12, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string nr_rrc_T_frequencyDomainAllocation_vals[] = {
  {   0, "row1" },
  {   1, "row2" },
  { 0, NULL }
};

static const per_choice_t T_frequencyDomainAllocation_choice[] = {
  {   0, &hf_nr_rrc_row1         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_BIT_STRING_SIZE_4 },
  {   1, &hf_nr_rrc_row2         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_BIT_STRING_SIZE_12 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_frequencyDomainAllocation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_frequencyDomainAllocation, T_frequencyDomainAllocation_choice,
                                 NULL);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 13U, NULL, FALSE);

  return offset;
}


static const per_sequence_t CSI_RS_Resource_Mobility_sequence[] = {
  { &hf_nr_rrc_csi_RS_Index , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CSI_RS_Index },
  { &hf_nr_rrc_slotConfig   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_slotConfig },
  { &hf_nr_rrc_associatedSSB, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_associatedSSB },
  { &hf_nr_rrc_frequencyDomainAllocation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_frequencyDomainAllocation },
  { &hf_nr_rrc_firstOFDMSymbolInTimeDomain, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_13 },
  { &hf_nr_rrc_sequenceGenerationConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_1023 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CSI_RS_Resource_Mobility(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CSI_RS_Resource_Mobility, CSI_RS_Resource_Mobility_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxNrofCSI_RS_ResourcesRRM_OF_CSI_RS_Resource_Mobility_sequence_of[1] = {
  { &hf_nr_rrc_csi_rs_ResourceList_Mobility_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CSI_RS_Resource_Mobility },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_RS_ResourcesRRM_OF_CSI_RS_Resource_Mobility(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_RS_ResourcesRRM_OF_CSI_RS_Resource_Mobility, SEQUENCE_SIZE_1_maxNrofCSI_RS_ResourcesRRM_OF_CSI_RS_Resource_Mobility_sequence_of,
                                                  1, maxNrofCSI_RS_ResourcesRRM, FALSE);

  return offset;
}


static const per_sequence_t CSI_RS_CellMobility_sequence[] = {
  { &hf_nr_rrc_cellId       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PhysCellId },
  { &hf_nr_rrc_csi_rs_MeasurementBW, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_csi_rs_MeasurementBW },
  { &hf_nr_rrc_density      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_density },
  { &hf_nr_rrc_csi_rs_ResourceList_Mobility, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_RS_ResourcesRRM_OF_CSI_RS_Resource_Mobility },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CSI_RS_CellMobility(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CSI_RS_CellMobility, CSI_RS_CellMobility_sequence);

  return offset;
}


static const per_sequence_t T_csi_RS_Config_r16_sequence[] = {
  { &hf_nr_rrc_csi_RS_SubcarrierSpacing_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SubcarrierSpacing },
  { &hf_nr_rrc_csi_RS_CellMobility_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CSI_RS_CellMobility },
  { &hf_nr_rrc_refSSBFreq_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueNR },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_csi_RS_Config_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_csi_RS_Config_r16, T_csi_RS_Config_r16_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_04_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_04(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_04, T_nonCriticalExtension_04_sequence);

  return offset;
}


static const per_sequence_t MeasurementTimingConfiguration_v1610_IEs_sequence[] = {
  { &hf_nr_rrc_csi_RS_Config_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_csi_RS_Config_r16 },
  { &hf_nr_rrc_nonCriticalExtension_20, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_04 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasurementTimingConfiguration_v1610_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasurementTimingConfiguration_v1610_IEs, MeasurementTimingConfiguration_v1610_IEs_sequence);

  return offset;
}


static const per_sequence_t MeasurementTimingConfiguration_v1550_IEs_sequence[] = {
  { &hf_nr_rrc_campOnFirstSSB, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_psCellOnlyOnFirstSSB, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_nonCriticalExtension_19, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasurementTimingConfiguration_v1610_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasurementTimingConfiguration_v1550_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasurementTimingConfiguration_v1550_IEs, MeasurementTimingConfiguration_v1550_IEs_sequence);

  return offset;
}


static const per_sequence_t MeasurementTimingConfiguration_IEs_sequence[] = {
  { &hf_nr_rrc_measTiming   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasTimingList },
  { &hf_nr_rrc_nonCriticalExtension_18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasurementTimingConfiguration_v1550_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasurementTimingConfiguration_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasurementTimingConfiguration_IEs, MeasurementTimingConfiguration_IEs_sequence);

  return offset;
}


static const value_string nr_rrc_T_c1_04_vals[] = {
  {   0, "measTimingConf" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_04_choice[] = {
  {   0, &hf_nr_rrc_measTimingConf, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_MeasurementTimingConfiguration_IEs },
  {   1, &hf_nr_rrc_spare3       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   2, &hf_nr_rrc_spare2       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   3, &hf_nr_rrc_spare1       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_c1_04(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_c1_04, T_c1_04_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_04_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_04(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_04, T_criticalExtensionsFuture_04_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_04_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_04_choice[] = {
  {   0, &hf_nr_rrc_c1_04        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_c1_04 },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_04, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_04 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_04(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_04, T_criticalExtensions_04_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MeasurementTimingConfiguration_sequence[] = {
  { &hf_nr_rrc_criticalExtensions_04, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_04 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasurementTimingConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasurementTimingConfiguration, MeasurementTimingConfiguration_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicatorNR_sequence_of[1] = {
  { &hf_nr_rrc_supportedBandListNRForPaging_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_FreqBandIndicatorNR },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicatorNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicatorNR, SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicatorNR_sequence_of,
                                                  1, maxBands, FALSE);

  return offset;
}


static const value_string nr_rrc_T_dl_SchedulingOffset_PDSCH_TypeA_FDD_FR1_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_dl_SchedulingOffset_PDSCH_TypeA_FDD_FR1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_dl_SchedulingOffset_PDSCH_TypeA_TDD_FR1_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_dl_SchedulingOffset_PDSCH_TypeA_TDD_FR1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_dl_SchedulingOffset_PDSCH_TypeA_TDD_FR2_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_dl_SchedulingOffset_PDSCH_TypeA_TDD_FR2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_dl_SchedulingOffset_PDSCH_TypeB_FDD_FR1_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_dl_SchedulingOffset_PDSCH_TypeB_FDD_FR1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_dl_SchedulingOffset_PDSCH_TypeB_TDD_FR1_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_dl_SchedulingOffset_PDSCH_TypeB_TDD_FR1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_dl_SchedulingOffset_PDSCH_TypeB_TDD_FR2_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_dl_SchedulingOffset_PDSCH_TypeB_TDD_FR2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_05_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_05(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_05, T_nonCriticalExtension_05_sequence);

  return offset;
}


static const per_sequence_t UERadioPagingInformation_v15e0_IEs_sequence[] = {
  { &hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeA_FDD_FR1, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_dl_SchedulingOffset_PDSCH_TypeA_FDD_FR1 },
  { &hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeA_TDD_FR1, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_dl_SchedulingOffset_PDSCH_TypeA_TDD_FR1 },
  { &hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeA_TDD_FR2, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_dl_SchedulingOffset_PDSCH_TypeA_TDD_FR2 },
  { &hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeB_FDD_FR1, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_dl_SchedulingOffset_PDSCH_TypeB_FDD_FR1 },
  { &hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeB_TDD_FR1, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_dl_SchedulingOffset_PDSCH_TypeB_TDD_FR1 },
  { &hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeB_TDD_FR2, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_dl_SchedulingOffset_PDSCH_TypeB_TDD_FR2 },
  { &hf_nr_rrc_nonCriticalExtension_22, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_05 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_UERadioPagingInformation_v15e0_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_UERadioPagingInformation_v15e0_IEs, UERadioPagingInformation_v15e0_IEs_sequence);

  return offset;
}


static const per_sequence_t UERadioPagingInformation_IEs_sequence[] = {
  { &hf_nr_rrc_supportedBandListNRForPaging, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicatorNR },
  { &hf_nr_rrc_nonCriticalExtension_21, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_UERadioPagingInformation_v15e0_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_UERadioPagingInformation_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_UERadioPagingInformation_IEs, UERadioPagingInformation_IEs_sequence);

  return offset;
}


static const value_string nr_rrc_T_c1_05_vals[] = {
  {   0, "ueRadioPagingInformation" },
  {   1, "spare7" },
  {   2, "spare6" },
  {   3, "spare5" },
  {   4, "spare4" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_05_choice[] = {
  {   0, &hf_nr_rrc_ueRadioPagingInformation, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_UERadioPagingInformation_IEs },
  {   1, &hf_nr_rrc_spare7       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   2, &hf_nr_rrc_spare6       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   3, &hf_nr_rrc_spare5       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   4, &hf_nr_rrc_spare4       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   5, &hf_nr_rrc_spare3       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   6, &hf_nr_rrc_spare2       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   7, &hf_nr_rrc_spare1       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_c1_05(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_c1_05, T_c1_05_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_05_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_05(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_05, T_criticalExtensionsFuture_05_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_05_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_05_choice[] = {
  {   0, &hf_nr_rrc_c1_05        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_c1_05 },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_05, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_05 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_05(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_05, T_criticalExtensions_05_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t UERadioPagingInformation_sequence[] = {
  { &hf_nr_rrc_criticalExtensions_05, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_05 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_UERadioPagingInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_UERadioPagingInformation, UERadioPagingInformation_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_ue_RadioAccessCapabilityInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_UE_CapabilityRAT_ContainerList_PDU);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_06_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_06(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_06, T_nonCriticalExtension_06_sequence);

  return offset;
}


static const per_sequence_t UERadioAccessCapabilityInformation_IEs_sequence[] = {
  { &hf_nr_rrc_ue_RadioAccessCapabilityInfo, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_ue_RadioAccessCapabilityInfo },
  { &hf_nr_rrc_nonCriticalExtension_23, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_06 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_UERadioAccessCapabilityInformation_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_UERadioAccessCapabilityInformation_IEs, UERadioAccessCapabilityInformation_IEs_sequence);

  return offset;
}


static const value_string nr_rrc_T_c1_06_vals[] = {
  {   0, "ueRadioAccessCapabilityInformation" },
  {   1, "spare7" },
  {   2, "spare6" },
  {   3, "spare5" },
  {   4, "spare4" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_06_choice[] = {
  {   0, &hf_nr_rrc_ueRadioAccessCapabilityInformation, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_UERadioAccessCapabilityInformation_IEs },
  {   1, &hf_nr_rrc_spare7       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   2, &hf_nr_rrc_spare6       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   3, &hf_nr_rrc_spare5       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   4, &hf_nr_rrc_spare4       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   5, &hf_nr_rrc_spare3       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   6, &hf_nr_rrc_spare2       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   7, &hf_nr_rrc_spare1       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_c1_06(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_c1_06, T_c1_06_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_06_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_06(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_06, T_criticalExtensionsFuture_06_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_06_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_06_choice[] = {
  {   0, &hf_nr_rrc_c1_06        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_c1_06 },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_06, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_06 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_06(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_06, T_criticalExtensions_06_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t UERadioAccessCapabilityInformation_sequence[] = {
  { &hf_nr_rrc_criticalExtensions_06, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_06 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_UERadioAccessCapabilityInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_UERadioAccessCapabilityInformation, UERadioAccessCapabilityInformation_sequence);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_6(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     6, 6, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string nr_rrc_T_subCarrierSpacingCommon_vals[] = {
  {   0, "scs15or60" },
  {   1, "scs30or120" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_subCarrierSpacingCommon(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_dmrs_TypeA_Position_vals[] = {
  {   0, "pos2" },
  {   1, "pos3" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_dmrs_TypeA_Position(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_cellBarred_vals[] = {
  {   0, "barred" },
  {   1, "notBarred" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_cellBarred(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_intraFreqReselection_vals[] = {
  {   0, "allowed" },
  {   1, "notAllowed" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_intraFreqReselection(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 1, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t MIB_sequence[] = {
  { &hf_nr_rrc_systemFrameNumber, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BIT_STRING_SIZE_6 },
  { &hf_nr_rrc_subCarrierSpacingCommon, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_subCarrierSpacingCommon },
  { &hf_nr_rrc_ssb_SubcarrierOffset, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_15 },
  { &hf_nr_rrc_dmrs_TypeA_Position, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_dmrs_TypeA_Position },
  { &hf_nr_rrc_pdcch_ConfigSIB1, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PDCCH_ConfigSIB1 },
  { &hf_nr_rrc_cellBarred   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_cellBarred },
  { &hf_nr_rrc_intraFreqReselection, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_intraFreqReselection },
  { &hf_nr_rrc_spare        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BIT_STRING_SIZE_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MIB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "MIB");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MIB, MIB_sequence);

  return offset;
}


static const per_sequence_t T_messageClassExtension_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_messageClassExtension(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_messageClassExtension, T_messageClassExtension_sequence);

  return offset;
}


static const value_string nr_rrc_BCCH_BCH_MessageType_vals[] = {
  {   0, "mib" },
  {   1, "messageClassExtension" },
  { 0, NULL }
};

static const per_choice_t BCCH_BCH_MessageType_choice[] = {
  {   0, &hf_nr_rrc_mib          , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_MIB },
  {   1, &hf_nr_rrc_messageClassExtension, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_messageClassExtension },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_BCCH_BCH_MessageType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_BCCH_BCH_MessageType, BCCH_BCH_MessageType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t BCCH_BCH_Message_sequence[] = {
  { &hf_nr_rrc_message      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BCCH_BCH_MessageType },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_BCCH_BCH_Message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *ti;

  col_set_str(actx->pinfo->cinfo, COL_PROTOCOL, "NR RRC");
  col_clear(actx->pinfo->cinfo, COL_INFO);

  ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  tree = proto_item_add_subtree(ti, ett_nr_rrc);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_BCCH_BCH_Message, BCCH_BCH_Message_sequence);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_2_maxNrofSS_BlocksToAverage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            2U, maxNrofSS_BlocksToAverage, NULL, FALSE);

  return offset;
}


static const per_sequence_t ThresholdNR_sequence[] = {
  { &hf_nr_rrc_thresholdRSRP, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RSRP_Range },
  { &hf_nr_rrc_thresholdRSRQ, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RSRQ_Range },
  { &hf_nr_rrc_thresholdSINR, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SINR_Range },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ThresholdNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ThresholdNR, ThresholdNR_sequence);

  return offset;
}


static const value_string nr_rrc_Q_OffsetRange_vals[] = {
  {   0, "dB-24" },
  {   1, "dB-22" },
  {   2, "dB-20" },
  {   3, "dB-18" },
  {   4, "dB-16" },
  {   5, "dB-14" },
  {   6, "dB-12" },
  {   7, "dB-10" },
  {   8, "dB-8" },
  {   9, "dB-6" },
  {  10, "dB-5" },
  {  11, "dB-4" },
  {  12, "dB-3" },
  {  13, "dB-2" },
  {  14, "dB-1" },
  {  15, "dB0" },
  {  16, "dB1" },
  {  17, "dB2" },
  {  18, "dB3" },
  {  19, "dB4" },
  {  20, "dB5" },
  {  21, "dB6" },
  {  22, "dB8" },
  {  23, "dB10" },
  {  24, "dB12" },
  {  25, "dB14" },
  {  26, "dB16" },
  {  27, "dB18" },
  {  28, "dB20" },
  {  29, "dB22" },
  {  30, "dB24" },
  { 0, NULL }
};

static value_string_ext nr_rrc_Q_OffsetRange_vals_ext = VALUE_STRING_EXT_INIT(nr_rrc_Q_OffsetRange_vals);


static int
dissect_nr_rrc_Q_OffsetRange(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     31, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_RangeToBestCell(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_nr_rrc_Q_OffsetRange(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string nr_rrc_T_q_Hyst_vals[] = {
  {   0, "dB0" },
  {   1, "dB1" },
  {   2, "dB2" },
  {   3, "dB3" },
  {   4, "dB4" },
  {   5, "dB5" },
  {   6, "dB6" },
  {   7, "dB8" },
  {   8, "dB10" },
  {   9, "dB12" },
  {  10, "dB14" },
  {  11, "dB16" },
  {  12, "dB18" },
  {  13, "dB20" },
  {  14, "dB22" },
  {  15, "dB24" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_q_Hyst(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_t_Evaluation_vals[] = {
  {   0, "s30" },
  {   1, "s60" },
  {   2, "s120" },
  {   3, "s180" },
  {   4, "s240" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_t_Evaluation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_t_HystNormal_vals[] = {
  {   0, "s30" },
  {   1, "s60" },
  {   2, "s120" },
  {   3, "s180" },
  {   4, "s240" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_t_HystNormal(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t MobilityStateParameters_sequence[] = {
  { &hf_nr_rrc_t_Evaluation , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_t_Evaluation },
  { &hf_nr_rrc_t_HystNormal , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_t_HystNormal },
  { &hf_nr_rrc_n_CellChangeMedium, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_1_16 },
  { &hf_nr_rrc_n_CellChangeHigh, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_1_16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MobilityStateParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MobilityStateParameters, MobilityStateParameters_sequence);

  return offset;
}


static const value_string nr_rrc_T_sf_Medium_vals[] = {
  {   0, "dB-6" },
  {   1, "dB-4" },
  {   2, "dB-2" },
  {   3, "dB0" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_sf_Medium(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_sf_High_vals[] = {
  {   0, "dB-6" },
  {   1, "dB-4" },
  {   2, "dB-2" },
  {   3, "dB0" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_sf_High(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_q_HystSF_sequence[] = {
  { &hf_nr_rrc_sf_Medium    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_sf_Medium },
  { &hf_nr_rrc_sf_High      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_sf_High },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_q_HystSF(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_q_HystSF, T_q_HystSF_sequence);

  return offset;
}


static const per_sequence_t T_speedStateReselectionPars_sequence[] = {
  { &hf_nr_rrc_mobilityStateParameters, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MobilityStateParameters },
  { &hf_nr_rrc_q_HystSF     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_q_HystSF },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_speedStateReselectionPars(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_speedStateReselectionPars, T_speedStateReselectionPars_sequence);

  return offset;
}


static const per_sequence_t T_cellReselectionInfoCommon_sequence[] = {
  { &hf_nr_rrc_nrofSS_BlocksToAverage, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_2_maxNrofSS_BlocksToAverage },
  { &hf_nr_rrc_absThreshSS_BlocksConsolidation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ThresholdNR },
  { &hf_nr_rrc_rangeToBestCell, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_RangeToBestCell },
  { &hf_nr_rrc_q_Hyst       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_q_Hyst },
  { &hf_nr_rrc_speedStateReselectionPars, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_speedStateReselectionPars },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_cellReselectionInfoCommon(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_cellReselectionInfoCommon, T_cellReselectionInfoCommon_sequence);

  return offset;
}



static int
dissect_nr_rrc_ReselectionThreshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_ReselectionThresholdQ(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_CellReselectionPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, FALSE);

  return offset;
}


static const value_string nr_rrc_CellReselectionSubPriority_vals[] = {
  {   0, "oDot2" },
  {   1, "oDot4" },
  {   2, "oDot6" },
  {   3, "oDot8" },
  { 0, NULL }
};


static int
dissect_nr_rrc_CellReselectionSubPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_cellReselectionServingFreqInfo_sequence[] = {
  { &hf_nr_rrc_s_NonIntraSearchP, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ReselectionThreshold },
  { &hf_nr_rrc_s_NonIntraSearchQ, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ReselectionThresholdQ },
  { &hf_nr_rrc_threshServingLowP, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReselectionThreshold },
  { &hf_nr_rrc_threshServingLowQ, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ReselectionThresholdQ },
  { &hf_nr_rrc_cellReselectionPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CellReselectionPriority },
  { &hf_nr_rrc_cellReselectionSubPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_CellReselectionSubPriority },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_cellReselectionServingFreqInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_cellReselectionServingFreqInfo, T_cellReselectionServingFreqInfo_sequence);

  return offset;
}



static int
dissect_nr_rrc_Q_RxLevMin(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -70, -22, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_Q_QualMin(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -43, -12, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_T_Reselection(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_AdditionalSpectrumEmission(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, FALSE);

  return offset;
}


static const per_sequence_t NR_NS_PmaxValue_sequence[] = {
  { &hf_nr_rrc_additionalPmax, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_P_Max },
  { &hf_nr_rrc_additionalSpectrumEmission, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_AdditionalSpectrumEmission },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_NR_NS_PmaxValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_NR_NS_PmaxValue, NR_NS_PmaxValue_sequence);

  return offset;
}


static const per_sequence_t NR_NS_PmaxList_sequence_of[1] = {
  { &hf_nr_rrc_NR_NS_PmaxList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_NR_NS_PmaxValue },
};

static int
dissect_nr_rrc_NR_NS_PmaxList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_NR_NS_PmaxList, NR_NS_PmaxList_sequence_of,
                                                  1, maxNR_NS_Pmax, FALSE);

  return offset;
}


static const per_sequence_t NR_MultiBandInfo_sequence[] = {
  { &hf_nr_rrc_freqBandIndicatorNR, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_FreqBandIndicatorNR },
  { &hf_nr_rrc_nr_NS_PmaxList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_NR_NS_PmaxList },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_NR_MultiBandInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_NR_MultiBandInfo, NR_MultiBandInfo_sequence);

  return offset;
}


static const per_sequence_t MultiFrequencyBandListNR_SIB_sequence_of[1] = {
  { &hf_nr_rrc_MultiFrequencyBandListNR_SIB_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_NR_MultiBandInfo },
};

static int
dissect_nr_rrc_MultiFrequencyBandListNR_SIB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MultiFrequencyBandListNR_SIB, MultiFrequencyBandListNR_SIB_sequence_of,
                                                  1, maxNrofMultiBands, FALSE);

  return offset;
}


static const value_string nr_rrc_T_sf_Medium_01_vals[] = {
  {   0, "oDot25" },
  {   1, "oDot5" },
  {   2, "oDot75" },
  {   3, "lDot0" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_sf_Medium_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_sf_High_01_vals[] = {
  {   0, "oDot25" },
  {   1, "oDot5" },
  {   2, "oDot75" },
  {   3, "lDot0" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_sf_High_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t SpeedStateScaleFactors_sequence[] = {
  { &hf_nr_rrc_sf_Medium_01 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_sf_Medium_01 },
  { &hf_nr_rrc_sf_High_01   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_sf_High_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SpeedStateScaleFactors(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SpeedStateScaleFactors, SpeedStateScaleFactors_sequence);

  return offset;
}


static const per_sequence_t T_eag_1_01_sequence[] = {
  { &hf_nr_rrc_t_ReselectionNR_SF, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SpeedStateScaleFactors },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_eag_1_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, T_eag_1_01_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxNrofPCIsPerSMTC_OF_PhysCellId_sequence_of[1] = {
  { &hf_nr_rrc_pci_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PhysCellId },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofPCIsPerSMTC_OF_PhysCellId(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPCIsPerSMTC_OF_PhysCellId, SEQUENCE_SIZE_1_maxNrofPCIsPerSMTC_OF_PhysCellId_sequence_of,
                                                  1, maxNrofPCIsPerSMTC, FALSE);

  return offset;
}


static const value_string nr_rrc_T_periodicity_03_vals[] = {
  {   0, "sf10" },
  {   1, "sf20" },
  {   2, "sf40" },
  {   3, "sf80" },
  {   4, "sf160" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_periodicity_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t SSB_MTC2_LP_r16_sequence[] = {
  { &hf_nr_rrc_pci_List     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofPCIsPerSMTC_OF_PhysCellId },
  { &hf_nr_rrc_periodicity_03, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_periodicity_03 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SSB_MTC2_LP_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SSB_MTC2_LP_r16, SSB_MTC2_LP_r16_sequence);

  return offset;
}


static const value_string nr_rrc_SSB_PositionQCL_Relation_r16_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  { 0, NULL }
};


static int
dissect_nr_rrc_SSB_PositionQCL_Relation_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_eag_2_sequence[] = {
  { &hf_nr_rrc_smtc2_LP_r16 , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SSB_MTC2_LP_r16 },
  { &hf_nr_rrc_ssb_PositionQCL_Common_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SSB_PositionQCL_Relation_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, T_eag_2_sequence);

  return offset;
}


static const per_sequence_t T_intraFreqCellReselectionInfo_sequence[] = {
  { &hf_nr_rrc_q_RxLevMin   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_Q_RxLevMin },
  { &hf_nr_rrc_q_RxLevMinSUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_Q_RxLevMin },
  { &hf_nr_rrc_q_QualMin    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_Q_QualMin },
  { &hf_nr_rrc_s_IntraSearchP, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReselectionThreshold },
  { &hf_nr_rrc_s_IntraSearchQ, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ReselectionThresholdQ },
  { &hf_nr_rrc_t_ReselectionNR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_Reselection },
  { &hf_nr_rrc_frequencyBandList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MultiFrequencyBandListNR_SIB },
  { &hf_nr_rrc_frequencyBandListSUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MultiFrequencyBandListNR_SIB },
  { &hf_nr_rrc_p_Max        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_P_Max },
  { &hf_nr_rrc_smtc         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SSB_MTC },
  { &hf_nr_rrc_ss_RSSI_Measurement, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SS_RSSI_Measurement },
  { &hf_nr_rrc_ssb_ToMeasure, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SSB_ToMeasure },
  { &hf_nr_rrc_deriveSSB_IndexFromCell, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_eag_1_01 },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_intraFreqCellReselectionInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_intraFreqCellReselectionInfo, T_intraFreqCellReselectionInfo_sequence);

  return offset;
}


static const value_string nr_rrc_T_s_SearchDeltaP_r16_vals[] = {
  {   0, "dB3" },
  {   1, "dB6" },
  {   2, "dB9" },
  {   3, "dB12" },
  {   4, "dB15" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_s_SearchDeltaP_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_t_SearchDeltaP_r16_vals[] = {
  {   0, "s5" },
  {   1, "s10" },
  {   2, "s20" },
  {   3, "s30" },
  {   4, "s60" },
  {   5, "s120" },
  {   6, "s180" },
  {   7, "s240" },
  {   8, "s300" },
  {   9, "spare7" },
  {  10, "spare6" },
  {  11, "spare5" },
  {  12, "spare4" },
  {  13, "spare3" },
  {  14, "spare2" },
  {  15, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_t_SearchDeltaP_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_lowMobilityEvaluation_r16_sequence[] = {
  { &hf_nr_rrc_s_SearchDeltaP_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_s_SearchDeltaP_r16 },
  { &hf_nr_rrc_t_SearchDeltaP_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_t_SearchDeltaP_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_lowMobilityEvaluation_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_lowMobilityEvaluation_r16, T_lowMobilityEvaluation_r16_sequence);

  return offset;
}


static const per_sequence_t T_cellEdgeEvaluation_r16_sequence[] = {
  { &hf_nr_rrc_s_SearchThresholdP_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReselectionThreshold },
  { &hf_nr_rrc_s_SearchThresholdQ_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ReselectionThresholdQ },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_cellEdgeEvaluation_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_cellEdgeEvaluation_r16, T_cellEdgeEvaluation_r16_sequence);

  return offset;
}


static const value_string nr_rrc_T_combineRelaxedMeasCondition_r16_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_combineRelaxedMeasCondition_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_highPriorityMeasRelax_r16_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_highPriorityMeasRelax_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_relaxedMeasurement_r16_sequence[] = {
  { &hf_nr_rrc_lowMobilityEvaluation_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_lowMobilityEvaluation_r16 },
  { &hf_nr_rrc_cellEdgeEvaluation_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_cellEdgeEvaluation_r16 },
  { &hf_nr_rrc_combineRelaxedMeasCondition_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_combineRelaxedMeasCondition_r16 },
  { &hf_nr_rrc_highPriorityMeasRelax_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_highPriorityMeasRelax_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_relaxedMeasurement_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_relaxedMeasurement_r16, T_relaxedMeasurement_r16_sequence);

  return offset;
}


static const per_sequence_t SIB2_eag_1_sequence[] = {
  { &hf_nr_rrc_relaxedMeasurement_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_relaxedMeasurement_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SIB2_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, SIB2_eag_1_sequence);

  return offset;
}


static const per_sequence_t SIB2_sequence[] = {
  { &hf_nr_rrc_cellReselectionInfoCommon, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_cellReselectionInfoCommon },
  { &hf_nr_rrc_cellReselectionServingFreqInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_cellReselectionServingFreqInfo },
  { &hf_nr_rrc_intraFreqCellReselectionInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_intraFreqCellReselectionInfo },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_SIB2_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SIB2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  col_append_str(actx->pinfo->cinfo, COL_INFO, " SIB2");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SIB2, SIB2_sequence);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_1_8(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, FALSE);

  return offset;
}


static const per_sequence_t IntraFreqNeighCellInfo_sequence[] = {
  { &hf_nr_rrc_physCellId   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PhysCellId },
  { &hf_nr_rrc_q_OffsetCell , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_Q_OffsetRange },
  { &hf_nr_rrc_q_RxLevMinOffsetCell, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_8 },
  { &hf_nr_rrc_q_RxLevMinOffsetCellSUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_8 },
  { &hf_nr_rrc_q_QualMinOffsetCell, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_8 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_IntraFreqNeighCellInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_IntraFreqNeighCellInfo, IntraFreqNeighCellInfo_sequence);

  return offset;
}


static const per_sequence_t IntraFreqNeighCellList_sequence_of[1] = {
  { &hf_nr_rrc_IntraFreqNeighCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_IntraFreqNeighCellInfo },
};

static int
dissect_nr_rrc_IntraFreqNeighCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_IntraFreqNeighCellList, IntraFreqNeighCellList_sequence_of,
                                                  1, maxCellIntra, FALSE);

  return offset;
}


static const value_string nr_rrc_T_range_vals[] = {
  {   0, "n4" },
  {   1, "n8" },
  {   2, "n12" },
  {   3, "n16" },
  {   4, "n24" },
  {   5, "n32" },
  {   6, "n48" },
  {   7, "n64" },
  {   8, "n84" },
  {   9, "n96" },
  {  10, "n128" },
  {  11, "n168" },
  {  12, "n252" },
  {  13, "n504" },
  {  14, "n1008" },
  {  15, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_range(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PCI_Range_sequence[] = {
  { &hf_nr_rrc_start        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PhysCellId },
  { &hf_nr_rrc_range        , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_range },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PCI_Range(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PCI_Range, PCI_Range_sequence);

  return offset;
}


static const per_sequence_t IntraFreqBlackCellList_sequence_of[1] = {
  { &hf_nr_rrc_IntraFreqBlackCellList_item, ASN1_NO_